/*

Copyright (C) 1996 John W. Eaton
Copyright (C) 2004 Paul Kienzle
Copyright (C) 2004 Dragan Tubic

This file is part of Octave.

Octave is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

Octave is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with Octave; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

// The following must be defined for recent versions of Octave.
#define TYPEID_HAS_CLASS

#include <octave/oct.h>
#include <octave/parse.h>
#include <octave/variables.h>
#include <octave/symtab.h>
#include <octave/pager.h>
#include <octave/config.h>
#include <octave/oct-rl-edit.h>
#include <readline/readline.h>

#include <cstdlib>
#include <string>
#include <ostream>
#include <iomanip>
#include <ext/hash_map>

#include "octaviz.h"

DEFUN_DLD (vtk_init, args, ,
  "Creates an vtk_object variable and initializes VTK visualization sub-system.")
{
  static bool type_loaded = false;

  if (! type_loaded)
	{
		vtk_object::register_type ();
		type_loaded = true;
		// Initialize X window stuff
//		XInitThreads();
//		XtToolkitThreadInitialize();
		XtToolkitInitialize();
		vtk_app_context = XtCreateApplicationContext();
		octave_rl_set_event_hook( vtk_event_loop );
		rl_set_keyboard_input_timeout(10000);
  }

  octave_value retval;

  return retval;
}



/*
;;; Local Variables: ***
;;; mode: C++ ***
;;; End: ***
*/
 
