## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

function vtk_demo()  
	vtk_init;
  x   = [ 0,0,0; 1,0,0; 1,1,0; 0,1,0; 0,0,1; 1,0,1; 1,1,1; 0,1,1 ];
  pts = [ 0,1,2,3; 4,5,6,7; 0,1,5,4; 1,2,6,5; 2,3,7,6; 3,0,4,7 ];
  pts = [ ones(6,1)*4 pts ]';
	
  x(:,1) = x(:,1) + 10*(rand-0.5);
  x(:,2) = x(:,2) + 10*(rand-0.5);
  x(:,3) = x(:,3) + 10*(rand-0.5);
  
	x = x';
	
  % We'll create the building blocks of polydata including data attributes.
  % vtkPolyData *cube = vtkPolyData::New();
  cube    = vtkPolyData("New");
  % vtkPoints *points = vtkPoints::New();
  points  = vtkPoints("New");
  % vtkCellArray *polys = vtkCellArray::New();
  polys   = vtkCellArray("New");
  % vtkFloatArray *scalars = vtkFloatArray::New();
  scalars = vtkFloatArray("New");

  % Load the point, cell, and data attributes.
  % for (i=0; i<8; i++) points->InsertPoint(i,x[i]);
	coords = vtkFloatArray; 
	coords.SetNumberOfTuples(8);
	coords.SetNumberOfComponents(3);
	coords.SetArray( x(:),24,0);
	points.SetData(coords);
	
  % for (i=0; i<6; i++) polys->InsertNextCell(4,pts[i]);
	ptids = vtkIdTypeArray;
	ptids.SetArray( pts(:), length(pts(:)), 0 );
	polys.SetCells( columns(pts), ptids );
  % for (i=0; i<8; i++) scalars->InsertValue(i,i);
	scalars.SetArray([0:7],8,0);
	
  % We now assign the pieces to the vtkPolyData.
	% cube->SetPoints(points);
  cube.SetPoints(points);
  %cube->SetPolys(polys);
  cube.SetPolys(polys);

  %cube->GetPointData()->SetScalars(scalars);
	cube.GetPointData().SetScalars(scalars);

  % Now we'll look at it.
  %vtkPolyDataMapper *cubeMapper = vtkPolyDataMapper::New();
  cubeMapper = vtkPolyDataMapper("New");
      % cubeMapper->SetInput(cube);
      cubeMapper.SetInput(cube);
      % cubeMapper->SetScalarRange(0,7);
      cubeMapper.SetScalarRange(0,7);
  
	% vtkActor *cubeActor = vtkActor::New();
  cubeActor = vtkActor("New");
      % cubeActor->SetMapper(cubeMapper);
      cubeActor.SetMapper(cubeMapper);

	% get current figure
	f = vtk_figure(0);	  

	f.renderer.AddActor(cubeActor);
	
	vtk_update(f);
	
	endfunction

	