## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_contourf(@var{x},@var{y},@var{z},[@var{prop},@var{val}])
## Displays a filled contour plot defined by @var{x},@var{y},@var{z} matrices,
## where @var{x} and @var{y} are typically formed by meshgrid.
##
## Optional @var{prop},@var{val} arguments can be used to change
## properties of the plot.  Currently, valid properties are
## ";NConts;".
##
## @end deftypefn
## @seealso{vtk_contour, vtk_surf}

## Author: Dragan Tubic, Jonathan Stickel

## TBD: allow options for the contour lines through the line spec interface


function vtk_contourf( varargin )
  
  valid_props = ";NConts;";
  
  [no_numerical_params, first_prop_index, line_spec_index] = vtk_parse_params(valid_props, all_va_args);
  if ( first_prop_index > 0 )
    properties = struct(varargin{first_prop_index:length(varargin)});
    ncts = properties.NConts;  # number of contours;
  else
    properties.empty = 1;
    ncts=10;
  end

  if ( no_numerical_params < 1 | no_numerical_params > 3 )
    error("Syntax is vtk_contourf( x, (y), (z))");
  end
  
  if ( no_numerical_params == 1 )
    z = nth (varargin,1);
    [nr nc] = size(z);
    [x y] = meshgrid(1:nr,1:nc);
    c = z;
  elseif ( no_numerical_params == 2 )
    z = nth (varargin,1);
    [nr nc] = size(z);
    [x y] = meshgrid(1:nr,1:nc);
    c = nth (varargin,1);
  elseif ( no_numerical_params == 3 )
    x = nth (varargin,1);
    y = nth (varargin,2);
    z = nth (varargin,3);
    c = z;
  end
  
  
  [nr nc] = size(x);
  
  if ( nr < 2 | nc < 2 )
    error("input has to be at least 2xN or Nx2 matrix");
  end

  ## make a contour plot with black contour lines
  if ( first_prop_index > 0 )
    properties = struct(varargin{first_prop_index:length(varargin)});
    vtk_contour(x,y,z,"NConts",properties.NConts)
  else
    vtk_contour(x,y,z);
  endif
  f = vtk_figure(0);
  ctractor = f.renderer.GetActors.GetLastActor;
  ctractor.GetMapper.ScalarVisibilityOff
  ctractor.GetProperty().SetColor( 0, 0, 0 )

  ## now make a surface plot with z axis the same level as the contour render plane
  ctrbnds = ctractor.GetMapper.GetInput.GetBounds;
  z = (ctrbnds(end)+0.01*ctrbnds(end))*ones(size(z));
  
  m = nc; n=nr;
  i = 0:m-2;
  j = 0:n-2;
  [i,j] = meshgrid(i,j);
  i = i(:);
  j = j(:);
  ## t = [i*n+j,i*n+(j+1),(i+1)*n+(j+1) ; (i+1)*n+(j+1),(i+1)*n+j,i*n+j];  %1; one way to construct the triangles
  t = [i*n+j,(i+1)*n+j,(i+1)*n+(j+1) ; (i+1)*n+(j+1),i*n+(j+1),i*n+j];  %2; another way, seems a bit better
  ## could pass some properties to surf, e.g. opacity; this tbd, JJS 7/23/05
  ##if ( first_prop_index > 0 )
  ##  f = vtk_trisurf(t+1,x(:),y(:),z(:),c(:),varargin{first_prop_index:length(varargin)});
  ##else
    f = vtk_trisurf(t+1,x(:),y(:),z(:),c(:));
  ##end
  
endfunction
