## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_plot(@var{x}, @var{y}, [@var{fmt} | @var{prop},@var{val}])
## Plots a typical scatter & line plot.  @var{x} must be a vector input.
## @var{y} should be columns of data to plot against @var{x}.  If
## @var{y} is omitted, @var{x} is plotted against its indices.
##
## The optional formating arguments do nothing at the moment.  More
## features are to be added with time.
## @end deftypefn
## @seealso{vtk_plot3}

## Author: Dragan Tubic

function vtk_plot( varargin )
  
  valid_props = ";MarkerColor;MarkerSize;LineColor;";
  [no_numerical_params, first_prop_index, line_spec_index] = vtk_parse_params(valid_props, all_va_args);
  
  if ( no_numerical_params == 0 | no_numerical_params > 2 )
    error("Syntax is vtk_plot(X[,Y])");
  elseif ( no_numerical_params == 1 )
    xi = varargin{1};
    if ( size(xi,1)==1 || size(xi,2)==1 )
      if ( size(xi,1)==1 )
	xi = xi';
      endif
    else
      error("X input must be a vector");
    endif     
    [nr nc] = size(xi);
    x = 1:nr;
    y = xi;
  else
    xi = varargin{1};
    yi = varargin{2};
    if ( size(xi,1)==1 || size(xi,2)==1 )
      if ( size(xi,1)==1 )
	xi = xi';
	yi = yi';
      endif
    else
      error("X input must be a vector");
    endif     
    x = xi;
    y = yi;
  end

  
  ## set default marker type and color
  marker_type = "*";
  color = [0 0 1];   # same as default in vtk_get_line_spec function

  ## use "line specs", if provided
  if ( line_spec_index > 0 )
    line_spec = nth (varargin,line_spec_index);
    [color, marker_type, line_style] = vtk_get_line_spec( line_spec );
  end
  ## use "property specs", if provided
  if ( first_prop_index > 0 )
    properties = struct(varargin{first_prop_index:length(varargin)});
    if ( isfield(properties,"MarkerColor") )
      color = properties.MarkerColor;
    end
  end
  properties.MarkerColor = color;

  
  vtk_init

  
  [nr nc] = size(y);
  
  xyplot = vtkXYPlotActor;
  xyplot.SetXValuesToValue();
  
  xvalues = vtkFloatArray;
  
  %%  for i=1:length(x)
  %%  	xvalues.InsertValue(i-1,x(i));
  %%  end
  xvalues.SetArray(x,length(x),0);
  
  for i = 1:nc
    yvalues = vtkFloatArray;
    
    %%  	for j=1:nr
    %%  		yvalues.InsertValue(j-1,y(j,i));
    %%  	end
    yvalues.SetArray(y(:,i),nr,0);
    curve  = vtkRectilinearGrid;
    curve.SetDimensions(nr,1,1);
    curve.SetXCoordinates(xvalues);
    curve.GetPointData().SetScalars(yvalues);
    xyplot.AddInput(curve);
    xyplot.SetPlotColor(i,rand,rand,rand)         % need to change this to use specified input
  end
  
  xyplot.PlotPointsOn()
  xyplot.LegendOn();
  xyplot.GetProperty().SetPointSize(3);         % need to change this to use specified input
  xyplot.GetProperty().SetLineWidth(1)

  %% set position and scale plot to take up window
  xyplot.SetPosition(0,0);
  xyplot.SetPosition2(1,1);
  
  w = vtkXYPlotWidget;
  vtkXYPlotWidget.SetXYPlotActor(xyplot);
  
  f = vtk_figure(0);
  w.SetInteractor(f.interactor);
  f.renderer.RemoveAllProps();
  f.renderer.AddActor2D(xyplot);
  vtk_update(f);
  
endfunction
