## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_surfc(@var{x},@var{y},@var{z},@var{c},[@var{prop},@var{val}])
##
## Displays both a surface and contour plot defined by @var{x},@var{y},@var{z} matrices,
## where @var{x} and @var{y} are typically formed by meshgrid.
## @var{c} is an optional matrix to give a color scale.
##
## Optional @var{prop},@var{val} arguments can be used to change
## properties of the plot.  Currently, valid properties are
## ";Opacity;Color;NConts;".
##
## @end deftypefn
## @seealso{vtk_surf, vtk_contour, vtk_meshc}

## Author: Jonathan Stickel

function vtk_surfc( varargin )
  
  valid_props = ";Opacity;Color;NConts;";
  
  [no_numerical_params, first_prop_index, line_spec_index] = vtk_parse_params(valid_props, all_va_args);
  
  if ( no_numerical_params < 1 | no_numerical_params > 4 )
    error("Syntax is vtk_surfc( x, (y), (z), (c) )");
  end
  
  if ( no_numerical_params == 1 )
    z = nth (varargin,1);
    [nr nc] = size(z);
    [x y] = meshgrid(1:nr,1:nc);
    c = z;
  elseif ( no_numerical_params == 2 )
    z = nth (varargin,1);
    [nr nc] = size(z);
    [x y] = meshgrid(1:nr,1:nc);
    c = nth (varargin,1);
  elseif ( no_numerical_params == 3 )
    x = nth (varargin,1);
    y = nth (varargin,2);
    z = nth (varargin,3);
    c = z;
  elseif ( no_numerical_params == 4 )
    x = nth (varargin,1);
    y = nth (varargin,2);
    z = nth (varargin,3);
    c = nth (varargin,4);
  end
  
  [nr nc] = size(x);
  
  if ( nr < 2 | nc < 2 )
    error("input has to be at least 2xN or Nx2 matrix");
  end	

  ## complicated assessment of passed properties in order to call vtk_surf and vtk_contour correctly...
  if ( first_prop_index > 0 )
    properties = struct(varargin{first_prop_index:length(varargin)});
    if isfield(properties,"NConts")
      vtk_contour(x,y,z,"NConts",properties.NConts)
      properties = rmfield(properties,"NConts");
    else
      vtk_contour(x,y,z);
    endif

    if size(fieldnames(properties),1)       # returns 0 if no fieldnames
      i = 0;
      if isfield(properties,"Opacity")
	propscell{++i} = "Opacity";
	propscell{++i} = properties.Opacity;
      endif
      if isfield(properties,"Color")
	propscell{++i} = "Color";
	propscell{++i} = properties.Color;
      endif
      vtk_surf(x,y,z,c,propscell{:});
    else
      vtk_surf(x,y,z,c);
    endif

  else
    vtk_contour(x,y,z);
    vtk_surf(x,y,z,c);
  endif

  f = vtk_figure(0);
  f.axes.YAxisVisibilityOn();  # turn back on the "Z" axes (vtk_contour call turns it off)

endfunction
