## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_colormap(@var{cmap})
## @deftypefnx {Function File} {} vtk_colormap ("default")
## @deftypefnx {Function File} {@var{cmap}} = colormap
##
## @code{vtk_colormap (@var{cmap})} sets the colormap of the current
## actor to @var{cmap}.  The color map should be an @var{n} row by 3
## column matrix.  The columns contain red, green, and blue intensities
## respectively. All entries should be between 0 and 1 inclusive.
## @var{cmap} can be created by several colormap generation functions
## available in Octave-forge (jet, gray, hot, etc.).
##
## @code{colormap ("default")} restores the default colormap (spectral).
##
## @code{@var{cmap} = colormap} returns the current colormap. (not implemented yet).
##
## Example: set colormap to 'jet' with 256 values
## @example
## vtk_sombsurf
## vtk_colormap (jet(256))
## @end example
##
## @end deftypefn
## @seealso{vtk_scalarbar}

## Author: Jonathan Stickel

## to do:
## - impliment cmap = colormap
## - change existing code (e.g. vtk_surf) to call vtk_colormap to get the LookupTable

function vtk_colormap(varargin)

  f = vtk_figure(0);
  lut = f.renderer.GetActors.GetLastActor.GetMapper.GetLookupTable;

  if isstr(varargin{1})  # will assume that string = "default"
    lut.SetHueRange(0.66667, 0.0);
    lut.SetNumberOfTableValues(1);   # for some reason, the table is not being rebuilt if table already has 256 values
    lut.SetNumberOfTableValues(256);
    lut.SetRampToLinear();
    lut.ForceBuild();
  else                   # the input is a color map
    cmap = varargin{1};
    n = size(cmap,1);
    lut.SetNumberOfTableValues(n)
    for i = 1:n
      lut.SetTableValue(i-1,[cmap(i,:),1]);  # remember, vtk counting starts at zero;
				# 4th value is transparancy, which is not dealt with here
    endfor
  endif
  
  vtk_update(f);
  
endfunction
