# Copyright 1999-2004 Gentoo Technologies, Inc.                                                                         
# Distributed under the terms of the GNU General Public License v2                                                      
# $Header: $                                                                                                            

DESCRIPTION="Octaviz is a visualization system for Octave using VTK"
HOMEPAGE="http://octaviz.sourceforge.net/"
LICENSE="GPL"

SLOT="0"
KEYWORDS="~x86"

IUSE=""

RDEPEND=">=dev-libs/vtk-4.4.2
    >=app-sci/octave-2.1.57
    media-libs/jpeg
	media-libs/tiff
	media-libs/libpng
	sys-libs/zlib
	dev-libs/expat"

DEPEND=">=dev-util/cmake-1.8
	${RDEPEND}"

SRC_URI="mirror://sourceforge/${PN}/${P}.tar.gz"


src_compile() {
    # patch Common/vtkInitializeInteractor.cc
	patch ${S}/Common/vtkInitializeInteractor.cc < ${FILESDIR}/vtkInitializeInteractor.cc.diff || die "patch /Common/vtkInitializeInteractor.cc failed"

	# build list of config variables to pass to cmake
	# none are needed at the moment it seems; JJS 11/03/04
	#CMAKE_VARIABLES="-DCMAKE_INSTALL_PREFIX:PATH=${D}/usr"
	#CMAKE_VARIABLES="-DEXECUTABLE_OUTPUT_PATH:PATH=${D}"
	#CMAKE_VARIABLES="-DLIBRARY_OUTPUT_PATH:PATH=${D}"
	#CMAKE_VARIABLES="-DCMAKE_BUILD_TYPE:STR=Release"
	
	cmake ${CMAKE_VARIABLES} . || die "cmake configuration failed"

	emake -j1 || die "emake failed"
}

src_install() {
	make install DESTDIR=${D} || die "make install failed"
	#make create_links || die "make create_links failed"  #older version of octaviz required symlinks for stuff
}
