

%  This example demonstrates the use and manipulation of lookup tables.

vtk_init;


VTK_DATA_ROOT = vtkGetDataRoot();

%  First create pipeline a simple pipeline that reads a structure grid
%  and then extracts a plane 
%  differently by using different lookup tables.
% 
%  Note: the Update method is manually invoked because it causes the
%  reader to read; later on we use the output of the reader to set
%  a range for the scalar values.
pl3d = vtkPLOT3DReader();
pl3d.SetXYZFileName(strcat(VTK_DATA_ROOT,"/Data/combxyz.bin"));
pl3d.SetQFileName(strcat(VTK_DATA_ROOT,"/Data/combq.bin"));
pl3d.SetScalarFunctionNumber(100);
pl3d.SetVectorFunctionNumber(202);
pl3d.Update();
plane = vtkStructuredGridGeometryFilter();
plane.SetInput(pl3d.GetOutput());
plane.SetExtent(1, 100, 1, 100, 7, 7);
lut = vtkLookupTable();
planeMapper = vtkPolyDataMapper();
planeMapper.SetLookupTable(lut);
planeMapper.SetInput(plane.GetOutput());
planeMapper.SetScalarRange(pl3d.GetOutput().GetScalarRange());
planeActor = vtkActor();
planeActor.SetMapper(planeMapper);

%  This creates an outline around the data.
outline = vtkStructuredGridOutlineFilter();
outline.SetInput(pl3d.GetOutput());
outlineMapper = vtkPolyDataMapper();
outlineMapper.SetInput(outline.GetOutput());
outlineActor = vtkActor();
outlineActor.SetMapper(outlineMapper);

%  Much of the following is commented out. To try different lookup tables,
%  uncommented the appropriate portions.

%  This creates a black to white lut.
% lut.SetHueRange(0, 0)
% lut.SetSaturationRange(0, 0)
% lut.SetValueRange(0.2, 1.0)

%  This creates a red to blue lut.
% lut.SetHueRange(0.0, 0.667)

%  This creates a blue to red lut.
% lut.SetHueRange(0.667, 0.0)

%  This creates a wierd effect. The Build() method causes the lookup
%  table to allocate memory and create a table based on the currect
%  hue, saturation, value, and alpha (transparency) range. Here we then
%  manually overwrite the values generated by the Build() method.
lut.SetNumberOfColors(256);
lut.Build();
for i = 0:15
    lut.SetTableValue(i*16, 1, 0, 0, 1);
    lut.SetTableValue(i*16+1, 0, 1, 0, 1);
    lut.SetTableValue(i*16+2, 0, 0, 1, 1);
    lut.SetTableValue(i*16+3, 0, 0, 0, 1);
end

%  Create the RenderWindow, Renderer and both Actors
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(outlineActor);
ren.AddActor(planeActor);

ren.SetBackground(0.1, 0.2, 0.4);
ren.TwoSidedLightingOff();

renWin.SetSize(250, 250);

cam1 = ren.GetActiveCamera();
cam1.SetClippingRange(3.95297, 50);
cam1.SetFocalPoint(8.88908, 0.595038, 29.3342);
cam1.SetPosition(-12.3332, 31.7479, 41.2387);
cam1.SetViewUp(0.060772, -0.319905, 0.945498);


% renWin.Render();
vtkInitializeInteractor(iren);
