/*************************************************************************
 * odil - Copyright (C) Universite de Strasbourg
 * Distributed under the terms of the CeCILL-B license, as published by
 * the CEA-CNRS-INRIA. Refer to the LICENSE file or to
 * http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
 * for details.
 ************************************************************************/

#ifndef _afc7b2d7_0869_4fea_9a9b_7fe6228baca9_300a
#define _afc7b2d7_0869_4fea_9a9b_7fe6228baca9_300a

#include <map>
#include <string>

#include "odil/odil.h"
#include "odil/Tag.h"

namespace odil
{

namespace registry
{
Tag const RTPlanLabel(0x300a, 0x0002);
Tag const RTPlanName(0x300a, 0x0003);
Tag const RTPlanDescription(0x300a, 0x0004);
Tag const RTPlanDate(0x300a, 0x0006);
Tag const RTPlanTime(0x300a, 0x0007);
Tag const TreatmentProtocols(0x300a, 0x0009);
Tag const PlanIntent(0x300a, 0x000a);
Tag const TreatmentSites(0x300a, 0x000b);
Tag const RTPlanGeometry(0x300a, 0x000c);
Tag const PrescriptionDescription(0x300a, 0x000e);
Tag const DoseReferenceSequence(0x300a, 0x0010);
Tag const DoseReferenceNumber(0x300a, 0x0012);
Tag const DoseReferenceUID(0x300a, 0x0013);
Tag const DoseReferenceStructureType(0x300a, 0x0014);
Tag const NominalBeamEnergyUnit(0x300a, 0x0015);
Tag const DoseReferenceDescription(0x300a, 0x0016);
Tag const DoseReferencePointCoordinates(0x300a, 0x0018);
Tag const NominalPriorDose(0x300a, 0x001a);
Tag const DoseReferenceType(0x300a, 0x0020);
Tag const ConstraintWeight(0x300a, 0x0021);
Tag const DeliveryWarningDose(0x300a, 0x0022);
Tag const DeliveryMaximumDose(0x300a, 0x0023);
Tag const TargetMinimumDose(0x300a, 0x0025);
Tag const TargetPrescriptionDose(0x300a, 0x0026);
Tag const TargetMaximumDose(0x300a, 0x0027);
Tag const TargetUnderdoseVolumeFraction(0x300a, 0x0028);
Tag const OrganAtRiskFullVolumeDose(0x300a, 0x002a);
Tag const OrganAtRiskLimitDose(0x300a, 0x002b);
Tag const OrganAtRiskMaximumDose(0x300a, 0x002c);
Tag const OrganAtRiskOverdoseVolumeFraction(0x300a, 0x002d);
Tag const ToleranceTableSequence(0x300a, 0x0040);
Tag const ToleranceTableNumber(0x300a, 0x0042);
Tag const ToleranceTableLabel(0x300a, 0x0043);
Tag const GantryAngleTolerance(0x300a, 0x0044);
Tag const BeamLimitingDeviceAngleTolerance(0x300a, 0x0046);
Tag const BeamLimitingDeviceToleranceSequence(0x300a, 0x0048);
Tag const BeamLimitingDevicePositionTolerance(0x300a, 0x004a);
Tag const SnoutPositionTolerance(0x300a, 0x004b);
Tag const PatientSupportAngleTolerance(0x300a, 0x004c);
Tag const TableTopEccentricAngleTolerance(0x300a, 0x004e);
Tag const TableTopPitchAngleTolerance(0x300a, 0x004f);
Tag const TableTopRollAngleTolerance(0x300a, 0x0050);
Tag const TableTopVerticalPositionTolerance(0x300a, 0x0051);
Tag const TableTopLongitudinalPositionTolerance(0x300a, 0x0052);
Tag const TableTopLateralPositionTolerance(0x300a, 0x0053);
Tag const RTPlanRelationship(0x300a, 0x0055);
Tag const FractionGroupSequence(0x300a, 0x0070);
Tag const FractionGroupNumber(0x300a, 0x0071);
Tag const FractionGroupDescription(0x300a, 0x0072);
Tag const NumberOfFractionsPlanned(0x300a, 0x0078);
Tag const NumberOfFractionPatternDigitsPerDay(0x300a, 0x0079);
Tag const RepeatFractionCycleLength(0x300a, 0x007a);
Tag const FractionPattern(0x300a, 0x007b);
Tag const NumberOfBeams(0x300a, 0x0080);
Tag const BeamDoseSpecificationPoint(0x300a, 0x0082);
Tag const ReferencedDoseReferenceUID(0x300a, 0x0083);
Tag const BeamDose(0x300a, 0x0084);
Tag const BeamMeterset(0x300a, 0x0086);
Tag const BeamDosePointDepth(0x300a, 0x0088);
Tag const BeamDosePointEquivalentDepth(0x300a, 0x0089);
Tag const BeamDosePointSSD(0x300a, 0x008a);
Tag const BeamDoseMeaning(0x300a, 0x008b);
Tag const BeamDoseVerificationControlPointSequence(0x300a, 0x008c);
Tag const AverageBeamDosePointDepth(0x300a, 0x008d);
Tag const AverageBeamDosePointEquivalentDepth(0x300a, 0x008e);
Tag const AverageBeamDosePointSSD(0x300a, 0x008f);
Tag const BeamDoseType(0x300a, 0x0090);
Tag const AlternateBeamDose(0x300a, 0x0091);
Tag const AlternateBeamDoseType(0x300a, 0x0092);
Tag const DepthValueAveragingFlag(0x300a, 0x0093);
Tag const NumberOfBrachyApplicationSetups(0x300a, 0x00a0);
Tag const BrachyApplicationSetupDoseSpecificationPoint(0x300a, 0x00a2);
Tag const BrachyApplicationSetupDose(0x300a, 0x00a4);
Tag const BeamSequence(0x300a, 0x00b0);
Tag const TreatmentMachineName(0x300a, 0x00b2);
Tag const PrimaryDosimeterUnit(0x300a, 0x00b3);
Tag const SourceAxisDistance(0x300a, 0x00b4);
Tag const BeamLimitingDeviceSequence(0x300a, 0x00b6);
Tag const RTBeamLimitingDeviceType(0x300a, 0x00b8);
Tag const SourceToBeamLimitingDeviceDistance(0x300a, 0x00ba);
Tag const IsocenterToBeamLimitingDeviceDistance(0x300a, 0x00bb);
Tag const NumberOfLeafJawPairs(0x300a, 0x00bc);
Tag const LeafPositionBoundaries(0x300a, 0x00be);
Tag const BeamNumber(0x300a, 0x00c0);
Tag const BeamName(0x300a, 0x00c2);
Tag const BeamDescription(0x300a, 0x00c3);
Tag const BeamType(0x300a, 0x00c4);
Tag const BeamDeliveryDurationLimit(0x300a, 0x00c5);
Tag const RadiationType(0x300a, 0x00c6);
Tag const HighDoseTechniqueType(0x300a, 0x00c7);
Tag const ReferenceImageNumber(0x300a, 0x00c8);
Tag const PlannedVerificationImageSequence(0x300a, 0x00ca);
Tag const ImagingDeviceSpecificAcquisitionParameters(0x300a, 0x00cc);
Tag const TreatmentDeliveryType(0x300a, 0x00ce);
Tag const NumberOfWedges(0x300a, 0x00d0);
Tag const WedgeSequence(0x300a, 0x00d1);
Tag const WedgeNumber(0x300a, 0x00d2);
Tag const WedgeType(0x300a, 0x00d3);
Tag const WedgeID(0x300a, 0x00d4);
Tag const WedgeAngle(0x300a, 0x00d5);
Tag const WedgeFactor(0x300a, 0x00d6);
Tag const TotalWedgeTrayWaterEquivalentThickness(0x300a, 0x00d7);
Tag const WedgeOrientation(0x300a, 0x00d8);
Tag const IsocenterToWedgeTrayDistance(0x300a, 0x00d9);
Tag const SourceToWedgeTrayDistance(0x300a, 0x00da);
Tag const WedgeThinEdgePosition(0x300a, 0x00db);
Tag const BolusID(0x300a, 0x00dc);
Tag const BolusDescription(0x300a, 0x00dd);
Tag const EffectiveWedgeAngle(0x300a, 0x00de);
Tag const NumberOfCompensators(0x300a, 0x00e0);
Tag const MaterialID(0x300a, 0x00e1);
Tag const TotalCompensatorTrayFactor(0x300a, 0x00e2);
Tag const CompensatorSequence(0x300a, 0x00e3);
Tag const CompensatorNumber(0x300a, 0x00e4);
Tag const CompensatorID(0x300a, 0x00e5);
Tag const SourceToCompensatorTrayDistance(0x300a, 0x00e6);
Tag const CompensatorRows(0x300a, 0x00e7);
Tag const CompensatorColumns(0x300a, 0x00e8);
Tag const CompensatorPixelSpacing(0x300a, 0x00e9);
Tag const CompensatorPosition(0x300a, 0x00ea);
Tag const CompensatorTransmissionData(0x300a, 0x00eb);
Tag const CompensatorThicknessData(0x300a, 0x00ec);
Tag const NumberOfBoli(0x300a, 0x00ed);
Tag const CompensatorType(0x300a, 0x00ee);
Tag const CompensatorTrayID(0x300a, 0x00ef);
Tag const NumberOfBlocks(0x300a, 0x00f0);
Tag const TotalBlockTrayFactor(0x300a, 0x00f2);
Tag const TotalBlockTrayWaterEquivalentThickness(0x300a, 0x00f3);
Tag const BlockSequence(0x300a, 0x00f4);
Tag const BlockTrayID(0x300a, 0x00f5);
Tag const SourceToBlockTrayDistance(0x300a, 0x00f6);
Tag const IsocenterToBlockTrayDistance(0x300a, 0x00f7);
Tag const BlockType(0x300a, 0x00f8);
Tag const AccessoryCode(0x300a, 0x00f9);
Tag const BlockDivergence(0x300a, 0x00fa);
Tag const BlockMountingPosition(0x300a, 0x00fb);
Tag const BlockNumber(0x300a, 0x00fc);
Tag const BlockName(0x300a, 0x00fe);
Tag const BlockThickness(0x300a, 0x0100);
Tag const BlockTransmission(0x300a, 0x0102);
Tag const BlockNumberOfPoints(0x300a, 0x0104);
Tag const BlockData(0x300a, 0x0106);
Tag const ApplicatorSequence(0x300a, 0x0107);
Tag const ApplicatorID(0x300a, 0x0108);
Tag const ApplicatorType(0x300a, 0x0109);
Tag const ApplicatorDescription(0x300a, 0x010a);
Tag const CumulativeDoseReferenceCoefficient(0x300a, 0x010c);
Tag const FinalCumulativeMetersetWeight(0x300a, 0x010e);
Tag const NumberOfControlPoints(0x300a, 0x0110);
Tag const ControlPointSequence(0x300a, 0x0111);
Tag const ControlPointIndex(0x300a, 0x0112);
Tag const NominalBeamEnergy(0x300a, 0x0114);
Tag const DoseRateSet(0x300a, 0x0115);
Tag const WedgePositionSequence(0x300a, 0x0116);
Tag const WedgePosition(0x300a, 0x0118);
Tag const BeamLimitingDevicePositionSequence(0x300a, 0x011a);
Tag const LeafJawPositions(0x300a, 0x011c);
Tag const GantryAngle(0x300a, 0x011e);
Tag const GantryRotationDirection(0x300a, 0x011f);
Tag const BeamLimitingDeviceAngle(0x300a, 0x0120);
Tag const BeamLimitingDeviceRotationDirection(0x300a, 0x0121);
Tag const PatientSupportAngle(0x300a, 0x0122);
Tag const PatientSupportRotationDirection(0x300a, 0x0123);
Tag const TableTopEccentricAxisDistance(0x300a, 0x0124);
Tag const TableTopEccentricAngle(0x300a, 0x0125);
Tag const TableTopEccentricRotationDirection(0x300a, 0x0126);
Tag const TableTopVerticalPosition(0x300a, 0x0128);
Tag const TableTopLongitudinalPosition(0x300a, 0x0129);
Tag const TableTopLateralPosition(0x300a, 0x012a);
Tag const IsocenterPosition(0x300a, 0x012c);
Tag const SurfaceEntryPoint(0x300a, 0x012e);
Tag const SourceToSurfaceDistance(0x300a, 0x0130);
Tag const AverageBeamDosePointSourceToExternalContourDistance(0x300a, 0x0131);
Tag const SourceToExternalContourDistance(0x300a, 0x0132);
Tag const ExternalContourEntryPoint(0x300a, 0x0133);
Tag const CumulativeMetersetWeight(0x300a, 0x0134);
Tag const TableTopPitchAngle(0x300a, 0x0140);
Tag const TableTopPitchRotationDirection(0x300a, 0x0142);
Tag const TableTopRollAngle(0x300a, 0x0144);
Tag const TableTopRollRotationDirection(0x300a, 0x0146);
Tag const HeadFixationAngle(0x300a, 0x0148);
Tag const GantryPitchAngle(0x300a, 0x014a);
Tag const GantryPitchRotationDirection(0x300a, 0x014c);
Tag const GantryPitchAngleTolerance(0x300a, 0x014e);
Tag const FixationEye(0x300a, 0x0150);
Tag const ChairHeadFramePosition(0x300a, 0x0151);
Tag const HeadFixationAngleTolerance(0x300a, 0x0152);
Tag const ChairHeadFramePositionTolerance(0x300a, 0x0153);
Tag const FixationLightAzimuthalAngleTolerance(0x300a, 0x0154);
Tag const FixationLightPolarAngleTolerance(0x300a, 0x0155);
Tag const PatientSetupSequence(0x300a, 0x0180);
Tag const PatientSetupNumber(0x300a, 0x0182);
Tag const PatientSetupLabel(0x300a, 0x0183);
Tag const PatientAdditionalPosition(0x300a, 0x0184);
Tag const FixationDeviceSequence(0x300a, 0x0190);
Tag const FixationDeviceType(0x300a, 0x0192);
Tag const FixationDeviceLabel(0x300a, 0x0194);
Tag const FixationDeviceDescription(0x300a, 0x0196);
Tag const FixationDevicePosition(0x300a, 0x0198);
Tag const FixationDevicePitchAngle(0x300a, 0x0199);
Tag const FixationDeviceRollAngle(0x300a, 0x019a);
Tag const ShieldingDeviceSequence(0x300a, 0x01a0);
Tag const ShieldingDeviceType(0x300a, 0x01a2);
Tag const ShieldingDeviceLabel(0x300a, 0x01a4);
Tag const ShieldingDeviceDescription(0x300a, 0x01a6);
Tag const ShieldingDevicePosition(0x300a, 0x01a8);
Tag const SetupTechnique(0x300a, 0x01b0);
Tag const SetupTechniqueDescription(0x300a, 0x01b2);
Tag const SetupDeviceSequence(0x300a, 0x01b4);
Tag const SetupDeviceType(0x300a, 0x01b6);
Tag const SetupDeviceLabel(0x300a, 0x01b8);
Tag const SetupDeviceDescription(0x300a, 0x01ba);
Tag const SetupDeviceParameter(0x300a, 0x01bc);
Tag const SetupReferenceDescription(0x300a, 0x01d0);
Tag const TableTopVerticalSetupDisplacement(0x300a, 0x01d2);
Tag const TableTopLongitudinalSetupDisplacement(0x300a, 0x01d4);
Tag const TableTopLateralSetupDisplacement(0x300a, 0x01d6);
Tag const BrachyTreatmentTechnique(0x300a, 0x0200);
Tag const BrachyTreatmentType(0x300a, 0x0202);
Tag const TreatmentMachineSequence(0x300a, 0x0206);
Tag const SourceSequence(0x300a, 0x0210);
Tag const SourceNumber(0x300a, 0x0212);
Tag const SourceType(0x300a, 0x0214);
Tag const SourceManufacturer(0x300a, 0x0216);
Tag const ActiveSourceDiameter(0x300a, 0x0218);
Tag const ActiveSourceLength(0x300a, 0x021a);
Tag const SourceModelID(0x300a, 0x021b);
Tag const SourceDescription(0x300a, 0x021c);
Tag const SourceEncapsulationNominalThickness(0x300a, 0x0222);
Tag const SourceEncapsulationNominalTransmission(0x300a, 0x0224);
Tag const SourceIsotopeName(0x300a, 0x0226);
Tag const SourceIsotopeHalfLife(0x300a, 0x0228);
Tag const SourceStrengthUnits(0x300a, 0x0229);
Tag const ReferenceAirKermaRate(0x300a, 0x022a);
Tag const SourceStrength(0x300a, 0x022b);
Tag const SourceStrengthReferenceDate(0x300a, 0x022c);
Tag const SourceStrengthReferenceTime(0x300a, 0x022e);
Tag const ApplicationSetupSequence(0x300a, 0x0230);
Tag const ApplicationSetupType(0x300a, 0x0232);
Tag const ApplicationSetupNumber(0x300a, 0x0234);
Tag const ApplicationSetupName(0x300a, 0x0236);
Tag const ApplicationSetupManufacturer(0x300a, 0x0238);
Tag const TemplateNumber(0x300a, 0x0240);
Tag const TemplateType(0x300a, 0x0242);
Tag const TemplateName(0x300a, 0x0244);
Tag const TotalReferenceAirKerma(0x300a, 0x0250);
Tag const BrachyAccessoryDeviceSequence(0x300a, 0x0260);
Tag const BrachyAccessoryDeviceNumber(0x300a, 0x0262);
Tag const BrachyAccessoryDeviceID(0x300a, 0x0263);
Tag const BrachyAccessoryDeviceType(0x300a, 0x0264);
Tag const BrachyAccessoryDeviceName(0x300a, 0x0266);
Tag const BrachyAccessoryDeviceNominalThickness(0x300a, 0x026a);
Tag const BrachyAccessoryDeviceNominalTransmission(0x300a, 0x026c);
Tag const ChannelEffectiveLength(0x300a, 0x0271);
Tag const ChannelInnerLength(0x300a, 0x0272);
Tag const AfterloaderChannelID(0x300a, 0x0273);
Tag const SourceApplicatorTipLength(0x300a, 0x0274);
Tag const ChannelSequence(0x300a, 0x0280);
Tag const ChannelNumber(0x300a, 0x0282);
Tag const ChannelLength(0x300a, 0x0284);
Tag const ChannelTotalTime(0x300a, 0x0286);
Tag const SourceMovementType(0x300a, 0x0288);
Tag const NumberOfPulses(0x300a, 0x028a);
Tag const PulseRepetitionInterval(0x300a, 0x028c);
Tag const SourceApplicatorNumber(0x300a, 0x0290);
Tag const SourceApplicatorID(0x300a, 0x0291);
Tag const SourceApplicatorType(0x300a, 0x0292);
Tag const SourceApplicatorName(0x300a, 0x0294);
Tag const SourceApplicatorLength(0x300a, 0x0296);
Tag const SourceApplicatorManufacturer(0x300a, 0x0298);
Tag const SourceApplicatorWallNominalThickness(0x300a, 0x029c);
Tag const SourceApplicatorWallNominalTransmission(0x300a, 0x029e);
Tag const SourceApplicatorStepSize(0x300a, 0x02a0);
Tag const TransferTubeNumber(0x300a, 0x02a2);
Tag const TransferTubeLength(0x300a, 0x02a4);
Tag const ChannelShieldSequence(0x300a, 0x02b0);
Tag const ChannelShieldNumber(0x300a, 0x02b2);
Tag const ChannelShieldID(0x300a, 0x02b3);
Tag const ChannelShieldName(0x300a, 0x02b4);
Tag const ChannelShieldNominalThickness(0x300a, 0x02b8);
Tag const ChannelShieldNominalTransmission(0x300a, 0x02ba);
Tag const FinalCumulativeTimeWeight(0x300a, 0x02c8);
Tag const BrachyControlPointSequence(0x300a, 0x02d0);
Tag const ControlPointRelativePosition(0x300a, 0x02d2);
Tag const ControlPoint3DPosition(0x300a, 0x02d4);
Tag const CumulativeTimeWeight(0x300a, 0x02d6);
Tag const CompensatorDivergence(0x300a, 0x02e0);
Tag const CompensatorMountingPosition(0x300a, 0x02e1);
Tag const SourceToCompensatorDistance(0x300a, 0x02e2);
Tag const TotalCompensatorTrayWaterEquivalentThickness(0x300a, 0x02e3);
Tag const IsocenterToCompensatorTrayDistance(0x300a, 0x02e4);
Tag const CompensatorColumnOffset(0x300a, 0x02e5);
Tag const IsocenterToCompensatorDistances(0x300a, 0x02e6);
Tag const CompensatorRelativeStoppingPowerRatio(0x300a, 0x02e7);
Tag const CompensatorMillingToolDiameter(0x300a, 0x02e8);
Tag const IonRangeCompensatorSequence(0x300a, 0x02ea);
Tag const CompensatorDescription(0x300a, 0x02eb);
Tag const RadiationMassNumber(0x300a, 0x0302);
Tag const RadiationAtomicNumber(0x300a, 0x0304);
Tag const RadiationChargeState(0x300a, 0x0306);
Tag const ScanMode(0x300a, 0x0308);
Tag const ModulatedScanModeType(0x300a, 0x0309);
Tag const VirtualSourceAxisDistances(0x300a, 0x030a);
Tag const SnoutSequence(0x300a, 0x030c);
Tag const SnoutPosition(0x300a, 0x030d);
Tag const SnoutID(0x300a, 0x030f);
Tag const NumberOfRangeShifters(0x300a, 0x0312);
Tag const RangeShifterSequence(0x300a, 0x0314);
Tag const RangeShifterNumber(0x300a, 0x0316);
Tag const RangeShifterID(0x300a, 0x0318);
Tag const RangeShifterType(0x300a, 0x0320);
Tag const RangeShifterDescription(0x300a, 0x0322);
Tag const NumberOfLateralSpreadingDevices(0x300a, 0x0330);
Tag const LateralSpreadingDeviceSequence(0x300a, 0x0332);
Tag const LateralSpreadingDeviceNumber(0x300a, 0x0334);
Tag const LateralSpreadingDeviceID(0x300a, 0x0336);
Tag const LateralSpreadingDeviceType(0x300a, 0x0338);
Tag const LateralSpreadingDeviceDescription(0x300a, 0x033a);
Tag const LateralSpreadingDeviceWaterEquivalentThickness(0x300a, 0x033c);
Tag const NumberOfRangeModulators(0x300a, 0x0340);
Tag const RangeModulatorSequence(0x300a, 0x0342);
Tag const RangeModulatorNumber(0x300a, 0x0344);
Tag const RangeModulatorID(0x300a, 0x0346);
Tag const RangeModulatorType(0x300a, 0x0348);
Tag const RangeModulatorDescription(0x300a, 0x034a);
Tag const BeamCurrentModulationID(0x300a, 0x034c);
Tag const PatientSupportType(0x300a, 0x0350);
Tag const PatientSupportID(0x300a, 0x0352);
Tag const PatientSupportAccessoryCode(0x300a, 0x0354);
Tag const TrayAccessoryCode(0x300a, 0x0355);
Tag const FixationLightAzimuthalAngle(0x300a, 0x0356);
Tag const FixationLightPolarAngle(0x300a, 0x0358);
Tag const MetersetRate(0x300a, 0x035a);
Tag const RangeShifterSettingsSequence(0x300a, 0x0360);
Tag const RangeShifterSetting(0x300a, 0x0362);
Tag const IsocenterToRangeShifterDistance(0x300a, 0x0364);
Tag const RangeShifterWaterEquivalentThickness(0x300a, 0x0366);
Tag const LateralSpreadingDeviceSettingsSequence(0x300a, 0x0370);
Tag const LateralSpreadingDeviceSetting(0x300a, 0x0372);
Tag const IsocenterToLateralSpreadingDeviceDistance(0x300a, 0x0374);
Tag const RangeModulatorSettingsSequence(0x300a, 0x0380);
Tag const RangeModulatorGatingStartValue(0x300a, 0x0382);
Tag const RangeModulatorGatingStopValue(0x300a, 0x0384);
Tag const RangeModulatorGatingStartWaterEquivalentThickness(0x300a, 0x0386);
Tag const RangeModulatorGatingStopWaterEquivalentThickness(0x300a, 0x0388);
Tag const IsocenterToRangeModulatorDistance(0x300a, 0x038a);
Tag const ScanSpotTimeOffset(0x300a, 0x038f);
Tag const ScanSpotTuneID(0x300a, 0x0390);
Tag const ScanSpotPrescribedIndices(0x300a, 0x0391);
Tag const NumberOfScanSpotPositions(0x300a, 0x0392);
Tag const ScanSpotReordered(0x300a, 0x0393);
Tag const ScanSpotPositionMap(0x300a, 0x0394);
Tag const ScanSpotReorderingAllowed(0x300a, 0x0395);
Tag const ScanSpotMetersetWeights(0x300a, 0x0396);
Tag const ScanningSpotSize(0x300a, 0x0398);
Tag const NumberOfPaintings(0x300a, 0x039a);
Tag const IonToleranceTableSequence(0x300a, 0x03a0);
Tag const IonBeamSequence(0x300a, 0x03a2);
Tag const IonBeamLimitingDeviceSequence(0x300a, 0x03a4);
Tag const IonBlockSequence(0x300a, 0x03a6);
Tag const IonControlPointSequence(0x300a, 0x03a8);
Tag const IonWedgeSequence(0x300a, 0x03aa);
Tag const IonWedgePositionSequence(0x300a, 0x03ac);
Tag const ReferencedSetupImageSequence(0x300a, 0x0401);
Tag const SetupImageComment(0x300a, 0x0402);
Tag const MotionSynchronizationSequence(0x300a, 0x0410);
Tag const ControlPointOrientation(0x300a, 0x0412);
Tag const GeneralAccessorySequence(0x300a, 0x0420);
Tag const GeneralAccessoryID(0x300a, 0x0421);
Tag const GeneralAccessoryDescription(0x300a, 0x0422);
Tag const GeneralAccessoryType(0x300a, 0x0423);
Tag const GeneralAccessoryNumber(0x300a, 0x0424);
Tag const SourceToGeneralAccessoryDistance(0x300a, 0x0425);
Tag const ApplicatorGeometrySequence(0x300a, 0x0431);
Tag const ApplicatorApertureShape(0x300a, 0x0432);
Tag const ApplicatorOpening(0x300a, 0x0433);
Tag const ApplicatorOpeningX(0x300a, 0x0434);
Tag const ApplicatorOpeningY(0x300a, 0x0435);
Tag const SourceToApplicatorMountingPositionDistance(0x300a, 0x0436);
Tag const NumberOfBlockSlabItems(0x300a, 0x0440);
Tag const BlockSlabSequence(0x300a, 0x0441);
Tag const BlockSlabThickness(0x300a, 0x0442);
Tag const BlockSlabNumber(0x300a, 0x0443);
Tag const DeviceMotionControlSequence(0x300a, 0x0450);
Tag const DeviceMotionExecutionMode(0x300a, 0x0451);
Tag const DeviceMotionObservationMode(0x300a, 0x0452);
Tag const DeviceMotionParameterCodeSequence(0x300a, 0x0453);
Tag const DistalDepthFraction(0x300a, 0x0501);
Tag const DistalDepth(0x300a, 0x0502);
Tag const NominalRangeModulationFractions(0x300a, 0x0503);
Tag const NominalRangeModulatedRegionDepths(0x300a, 0x0504);
Tag const DepthDoseParametersSequence(0x300a, 0x0505);
Tag const DeliveredDepthDoseParametersSequence(0x300a, 0x0506);
Tag const DeliveredDistalDepthFraction(0x300a, 0x0507);
Tag const DeliveredDistalDepth(0x300a, 0x0508);
Tag const DeliveredNominalRangeModulationFractions(0x300a, 0x0509);
Tag const DeliveredNominalRangeModulatedRegionDepths(0x300a, 0x0510);
Tag const DeliveredReferenceDoseDefinition(0x300a, 0x0511);
Tag const ReferenceDoseDefinition(0x300a, 0x0512);

}

}

#endif // _afc7b2d7_0869_4fea_9a9b_7fe6228baca9_300a