/*
 *
 *  MTK2 driver for ofono/rilmodem
 *
 *  Copyright (C) 2016  Canonical Ltd.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <stddef.h>

#include "mtk2util.h"
#include "mtk2_constants.h"

const char *mtk2_request_id_to_string(int req)
{
	switch (req) {
	case MTK2_RIL_REQUEST_MODEM_POWEROFF:
		return "MTK2_RIL_REQUEST_MODEM_POWEROFF";
	case MTK2_RIL_REQUEST_DUAL_SIM_MODE_SWITCH:
		return "MTK2_RIL_REQUEST_DUAL_SIM_MODE_SWITCH";
	case MTK2_RIL_REQUEST_SET_GPRS_CONNECT_TYPE:
		return "MTK2_RIL_REQUEST_SET_GPRS_CONNECT_TYPE";
	case MTK2_RIL_REQUEST_SET_GPRS_TRANSFER_TYPE:
		return "MTK2_RIL_REQUEST_SET_GPRS_TRANSFER_TYPE";
	case MTK2_RIL_REQUEST_MODEM_POWERON:
		return "MTK2_RIL_REQUEST_MODEM_POWERON";
	case MTK2_RIL_REQUEST_SET_CALL_INDICATION:
		return "MTK2_RIL_REQUEST_SET_CALL_INDICATION";
	case MTK2_RIL_REQUEST_GET_PHONE_CAPABILITY:
		return "MTK2_RIL_REQUEST_GET_PHONE_CAPABILITY";
	case MTK2_RIL_REQUEST_SET_PHONE_CAPABILITY:
		return "MTK2_RIL_REQUEST_SET_PHONE_CAPABILITY";
	case MTK2_RIL_REQUEST_SET_TRM:
		return "MTK2_RIL_REQUEST_SET_TRM";
	case MTK2_RIL_REQUEST_SET_FD_MODE:
		return "MTK2_RIL_REQUEST_SET_FD_MODE";
	case MTK2_RIL_REQUEST_STORE_MODEM_TYPE:
		return "MTK2_RIL_REQUEST_STORE_MODEM_TYPE";
	case MTK2_RIL_REQUEST_RESUME_REGISTRATION:
		return "MTK2_RIL_REQUEST_RESUME_REGISTRATION";
	case MTK2_RIL_REQUEST_QUERY_MODEM_TYPE:
		return "MTK2_RIL_REQUEST_QUERY_MODEM_TYPE";
	case MTK2_RIL_REQUEST_SET_DATA_ON_TO_MD:
		return "MTK2_RIL_REQUEST_SET_DATA_ON_TO_MD";
	default:
		return NULL;
	}
}

const char *mtk2_unsol_request_to_string(int req)
{
	switch (req) {
	case MTK2_RIL_UNSOL_NEIGHBORING_CELL_INFO:
		return "MTK2_RIL_UNSOL_NEIGHBORING_CELL_INFO";
	case MTK2_RIL_UNSOL_NETWORK_INFO:
		return "MTK2_RIL_UNSOL_NETWORK_INFO";
	case MTK2_RIL_UNSOL_PHB_READY_NOTIFICATION:
		return "MTK2_RIL_UNSOL_PHB_READY_NOTIFICATION";
	case MTK2_RIL_UNSOL_SIM_INSERTED_STATUS:
		return "MTK2_RIL_UNSOL_SIM_INSERTED_STATUS";
	case MTK2_RIL_UNSOL_RADIO_TEMPORARILY_UNAVAILABLE:
		return "MTK2_RIL_UNSOL_RADIO_TEMPORARILY_UNAVAILABLE";
	case MTK2_RIL_UNSOL_ME_SMS_STORAGE_FULL:
		return "MTK2_RIL_UNSOL_ME_SMS_STORAGE_FULL";
	case MTK2_RIL_UNSOL_SMS_READY_NOTIFICATION:
		return "MTK2_RIL_UNSOL_SMS_READY_NOTIFICATION";
	case MTK2_RIL_UNSOL_SCRI_RESULT:
		return "MTK2_RIL_UNSOL_SCRI_RESULT";
	case MTK2_RIL_UNSOL_SIM_MISSING:
		return "MTK2_RIL_UNSOL_SIM_MISSING";
	case MTK2_RIL_UNSOL_GPRS_DETACH:
		return "MTK2_RIL_UNSOL_GPRS_DETACH";
	case MTK2_RIL_UNSOL_ATCI_RESPONSE:
		return "MTK2_RIL_UNSOL_ATCI_RESPONSE";
	case MTK2_RIL_UNSOL_SIM_RECOVERY:
		return "MTK2_RIL_UNSOL_SIM_RECOVERY";
	case MTK2_RIL_UNSOL_VIRTUAL_SIM_ON:
		return "MTK2_RIL_UNSOL_VIRTUAL_SIM_ON";
	case MTK2_RIL_UNSOL_VIRTUAL_SIM_OFF:
		return "MTK2_RIL_UNSOL_VIRTUAL_SIM_OFF";
	case MTK2_RIL_UNSOL_INVALID_SIM:
		return "MTK2_RIL_UNSOL_INVALID_SIM";
	case MTK2_RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
		return "MTK2_RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED";
	case MTK2_RIL_UNSOL_RESPONSE_ACMT:
		return "MTK2_RIL_UNSOL_RESPONSE_ACMT";
	case MTK2_RIL_UNSOL_EF_CSP_PLMN_MODE_BIT:
		return "MTK2_RIL_UNSOL_EF_CSP_PLMN_MODE_BIT";
	case MTK2_RIL_UNSOL_IMEI_LOCK:
		return "MTK2_RIL_UNSOL_IMEI_LOCK";
	case MTK2_RIL_UNSOL_RESPONSE_MMRR_STATUS_CHANGED:
		return "MTK2_RIL_UNSOL_RESPONSE_MMRR_STATUS_CHANGED";
	case MTK2_RIL_UNSOL_SIM_PLUG_OUT:
		return "MTK2_RIL_UNSOL_SIM_PLUG_OUT";
	case MTK2_RIL_UNSOL_SIM_PLUG_IN:
		return "MTK2_RIL_UNSOL_SIM_PLUG_IN";
	case MTK2_RIL_UNSOL_RESPONSE_ETWS_NOTIFICATION:
		return "MTK2_RIL_UNSOL_RESPONSE_ETWS_NOTIFICATION";
	case MTK2_RIL_UNSOL_RESPONSE_PLMN_CHANGED:
		return "MTK2_RIL_UNSOL_RESPONSE_PLMN_CHANGED";
	case MTK2_RIL_UNSOL_RESPONSE_REGISTRATION_SUSPENDED:
		return "MTK2_RIL_UNSOL_RESPONSE_REGISTRATION_SUSPENDED";
	case MTK2_RIL_UNSOL_STK_EVDL_CALL:
		return "MTK2_RIL_UNSOL_STK_EVDL_CALL";
	case MTK2_RIL_UNSOL_DATA_PACKETS_FLUSH:
		return "MTK2_RIL_UNSOL_DATA_PACKETS_FLUSH";
	case MTK2_RIL_UNSOL_FEMTOCELL_INFO:
		return "MTK2_RIL_UNSOL_FEMTOCELL_INFO";
	case MTK2_RIL_UNSOL_STK_SETUP_MENU_RESET:
		return "MTK2_RIL_UNSOL_STK_SETUP_MENU_RESET";
	case MTK2_RIL_UNSOL_APPLICATION_SESSION_ID_CHANGED:
		return "MTK2_RIL_UNSOL_APPLICATION_SESSION_ID_CHANGED";
	case MTK2_RIL_UNSOL_ECONF_SRVCC_INDICATION:
		return "MTK2_RIL_UNSOL_ECONF_SRVCC_INDICATION";
	case MTK2_RIL_UNSOL_IMS_ENABLE_DONE:
		return "MTK2_RIL_UNSOL_IMS_ENABLE_DONE";
	case MTK2_RIL_UNSOL_IMS_DISABLE_DONE:
		return "MTK2_RIL_UNSOL_IMS_DISABLE_DONE";
	case MTK2_RIL_UNSOL_IMS_REGISTRATION_INFO:
		return "MTK2_RIL_UNSOL_IMS_REGISTRATION_INFO";
	case MTK2_RIL_UNSOL_DEDICATE_BEARER_ACTIVATED:
		return "MTK2_RIL_UNSOL_DEDICATE_BEARER_ACTIVATED";
	case MTK2_RIL_UNSOL_DEDICATE_BEARER_MODIFIED:
		return "MTK2_RIL_UNSOL_DEDICATE_BEARER_MODIFIED";
	case MTK2_RIL_UNSOL_DEDICATE_BEARER_DEACTIVATED:
		return "MTK2_RIL_UNSOL_DEDICATE_BEARER_DEACTIVATED";
	case MTK2_RIL_UNSOL_RAC_UPDATE:
		return "MTK2_RIL_UNSOL_RAC_UPDATE";
	case MTK2_RIL_UNSOL_ECONF_RESULT_INDICATION:
		return "MTK2_RIL_UNSOL_ECONF_RESULT_INDICATION";
	case MTK2_RIL_UNSOL_MELOCK_NOTIFICATION:
		return "MTK2_RIL_UNSOL_MELOCK_NOTIFICATION";
	case MTK2_RIL_UNSOL_CALL_FORWARDING:
		return "MTK2_RIL_UNSOL_CALL_FORWARDING";
	case MTK2_RIL_UNSOL_CRSS_NOTIFICATION:
		return "MTK2_RIL_UNSOL_CRSS_NOTIFICATION";
	case MTK2_RIL_UNSOL_INCOMING_CALL_INDICATION:
		return "MTK2_RIL_UNSOL_INCOMING_CALL_INDICATION";
	case MTK2_RIL_UNSOL_CIPHER_INDICATION:
		return "MTK2_RIL_UNSOL_CIPHER_INDICATION";
	case MTK2_RIL_UNSOL_CNAP:
		return "MTK2_RIL_UNSOL_CNAP";
	case MTK2_RIL_UNSOL_SIM_COMMON_SLOT_NO_CHANGED:
		return "MTK2_RIL_UNSOL_SIM_COMMON_SLOT_NO_CHANGED";
	case MTK2_RIL_UNSOL_DATA_ALLOWED:
		return "MTK2_RIL_UNSOL_DATA_ALLOWED";
	case MTK2_RIL_UNSOL_STK_CALL_CTRL:
		return "MTK2_RIL_UNSOL_STK_CALL_CTRL";
	case MTK2_RIL_UNSOL_VOLTE_EPS_NETWORK_FEATURE_SUPPORT:
		return "MTK2_RIL_UNSOL_VOLTE_EPS_NETWORK_FEATURE_SUPPORT";
	case MTK2_RIL_UNSOL_CALL_INFO_INDICATION:
		return "MTK2_RIL_UNSOL_CALL_INFO_INDICATION";
	case MTK2_RIL_UNSOL_VOLTE_EPS_NETWORK_FEATURE_INFO:
		return "MTK2_RIL_UNSOL_VOLTE_EPS_NETWORK_FEATURE_INFO";
	case MTK2_RIL_UNSOL_SRVCC_HANDOVER_INFO_INDICATION:
		return "MTK2_RIL_UNSOL_SRVCC_HANDOVER_INFO_INDICATION";
	case MTK2_RIL_UNSOL_SPEECH_CODEC_INFO:
		return "MTK2_RIL_UNSOL_SPEECH_CODEC_INFO";
	case MTK2_RIL_UNSOL_MD_STATE_CHANGE:
		return "MTK2_RIL_UNSOL_MD_STATE_CHANGE";
	case MTK2_RIL_UNSOL_REMOVE_RESTRICT_EUTRAN:
		return "MTK2_RIL_UNSOL_REMOVE_RESTRICT_EUTRAN";
	case MTK2_RIL_UNSOL_MO_DATA_BARRING_INFO:
		return "MTK2_RIL_UNSOL_MO_DATA_BARRING_INFO";
	case MTK2_RIL_UNSOL_SSAC_BARRING_INFO:
		return "MTK2_RIL_UNSOL_SSAC_BARRING_INFO";
	case MTK2_RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR:
		return "MTK2_RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR";
	case MTK2_RIL_UNSOL_ABNORMAL_EVENT:
		return "MTK2_RIL_UNSOL_ABNORMAL_EVENT";
	case MTK2_RIL_UNSOL_EMERGENCY_BEARER_SUPPORT_NOTIFY:
		return "MTK2_RIL_UNSOL_EMERGENCY_BEARER_SUPPORT_NOTIFY";
	case MTK2_RIL_UNSOL_INTER_3GPP_IRAT_STATE_CHANGE:
		return "MTK2_RIL_UNSOL_INTER_3GPP_IRAT_STATE_CHANGE";
	case MTK2_RIL_UNSOL_LTE_BG_SEARCH_STATUS:
		return "MTK2_RIL_UNSOL_LTE_BG_SEARCH_STATUS";
	case MTK2_RIL_UNSOL_GMSS_RAT_CHANGED:
		return "MTK2_RIL_UNSOL_GMSS_RAT_CHANGED";
	case MTK2_RIL_UNSOL_CDMA_CARD_TYPE:
		return "MTK2_RIL_UNSOL_CDMA_CARD_TYPE";
	case MTK2_RIL_UNSOL_IMS_ENABLE_START:
		return "MTK2_RIL_UNSOL_IMS_ENABLE_START";
	case MTK2_RIL_UNSOL_IMS_DISABLE_START:
		return "MTK2_RIL_UNSOL_IMS_DISABLE_START";
	case MTK2_RIL_UNSOL_IMSI_REFRESH_DONE:
		return "MTK2_RIL_UNSOL_IMSI_REFRESH_DONE";
	case MTK2_RIL_UNSOL_EUSIM_READY:
		return "MTK2_RIL_UNSOL_EUSIM_READY";
	case MTK2_RIL_UNSOL_STK_BIP_PROACTIVE_COMMAND:
		return "MTK2_RIL_UNSOL_STK_BIP_PROACTIVE_COMMAND";
	case MTK2_RIL_UNSOL_WORLD_MODE_CHANGED:
		return "MTK2_RIL_UNSOL_WORLD_MODE_CHANGED";
	case MTK2_RIL_UNSOL_VT_STATUS_INFO:
		return "MTK2_RIL_UNSOL_VT_STATUS_INFO";
	case MTK2_RIL_UNSOL_VT_RING_INFO:
		return "MTK2_RIL_UNSOL_VT_RING_INFO";
	case MTK2_RIL_UNSOL_VSIM_OPERATION_INDICATION:
		return "MTK2_RIL_UNSOL_VSIM_OPERATION_INDICATION";
	case MTK2_RIL_UNSOL_SET_ATTACH_APN:
		return "MTK2_RIL_UNSOL_SET_ATTACH_APN";
	case MTK2_RIL_UNSOL_MAL_AT_INFO:
		return "MTK2_RIL_UNSOL_MAL_AT_INFO";
	case MTK2_RIL_UNSOL_MAIN_SIM_INFO:
		return "MTK2_RIL_UNSOL_MAIN_SIM_INFO";
	case MTK2_RIL_UNSOL_TRAY_PLUG_IN:
		return "MTK2_RIL_UNSOL_TRAY_PLUG_IN";
	case MTK2_RIL_UNSOL_CALLMOD_CHANGE_INDICATOR:
		return "MTK2_RIL_UNSOL_CALLMOD_CHANGE_INDICATOR";
	case MTK2_RIL_UNSOL_VIDEO_CAPABILITY_INDICATOR:
		return "MTK2_RIL_UNSOL_VIDEO_CAPABILITY_INDICATOR";
	case MTK2_RIL_UNSOL_LTE_ACCESS_STRATUM_STATE_CHANGE:
		return "MTK2_RIL_UNSOL_LTE_ACCESS_STRATUM_STATE_CHANGE";
	case MTK2_RIL_UNSOL_SETUP_DATA_CALL_RESPONSE:
		return "MTK2_RIL_UNSOL_SETUP_DATA_CALL_RESPONSE";
	case MTK2_RIL_UNSOL_ON_USSI:
		return "MTK2_RIL_UNSOL_ON_USSI";
	case MTK2_RIL_UNSOL_CDMA_CALL_ACCEPTED:
		return "MTK2_RIL_UNSOL_CDMA_CALL_ACCEPTED";
	case MTK2_RIL_UNSOL_UTK_SESSION_END:
		return "MTK2_RIL_UNSOL_UTK_SESSION_END";
	case MTK2_RIL_UNSOL_UTK_PROACTIVE_COMMAND:
		return "MTK2_RIL_UNSOL_UTK_PROACTIVE_COMMAND";
	case MTK2_RIL_UNSOL_UTK_EVENT_NOTIFY:
		return "MTK2_RIL_UNSOL_UTK_EVENT_NOTIFY";
	case MTK2_RIL_UNSOL_VIA_GPS_EVENT:
		return "MTK2_RIL_UNSOL_VIA_GPS_EVENT";
	case MTK2_RIL_UNSOL_VIA_NETWORK_TYPE_CHANGE:
		return "MTK2_RIL_UNSOL_VIA_NETWORK_TYPE_CHANGE";
	case MTK2_RIL_UNSOL_CDMA_PLMN_CHANGED:
		return "MTK2_RIL_UNSOL_CDMA_PLMN_CHANGED";
	case MTK2_RIL_UNSOL_VIA_INVALID_SIM_DETECTED:
		return "MTK2_RIL_UNSOL_VIA_INVALID_SIM_DETECTED";
	case MTK2_RIL_UNSOL_ENG_MODE_NETWORK_INFO:
		return "MTK2_RIL_UNSOL_ENG_MODE_NETWORK_INFO";
	case MTK2_RIL_UNSOL_RESPONSE_DATA_NETWORK_TYPE_CHANGED:
		return "MTK2_RIL_UNSOL_RESPONSE_DATA_NETWORK_TYPE_CHANGED";
	case MTK2_RIL_UNSOL_LTE_EARFCN_INFO:
		return "MTK2_RIL_UNSOL_LTE_EARFCN_INFO";
	case MTK2_RIL_UNSOL_CDMA_IMSI_READY:
		return "MTK2_RIL_UNSOL_CDMA_IMSI_READY";
	case MTK2_RIL_UNSOL_CDMA_SIGNAL_FADE:
		return "MTK2_RIL_UNSOL_CDMA_SIGNAL_FADE";
	case MTK2_RIL_UNSOL_CDMA_TONE_SIGNALS:
		return "MTK2_RIL_UNSOL_CDMA_TONE_SIGNALS";
	case MTK2_RIL_UNSOL_NETWORK_EXIST:
		return "MTK2_RIL_UNSOL_NETWORK_EXIST";
	case MTK2_RIL_UNSOL_MODULATION_INFO:
		return "MTK2_RIL_UNSOL_MODULATION_INFO";
	case MTK2_RIL_UNSOL_NETWORK_EVENT:
		return "MTK2_RIL_UNSOL_NETWORK_EVENT";
	case MTK2_RIL_UNSOL_MBIM_RESPONSE:
		return "MTK2_RIL_UNSOL_MBIM_RESPONSE";
	case MTK2_RIL_UNSOL_MAL_DATA_CALL_LIST_CHANGED:
		return "MTK2_RIL_UNSOL_MAL_DATA_CALL_LIST_CHANGED";
	case MTK2_RIL_UNSOL_EMBMS_AT_INFO :
		return "MTK2_RIL_UNSOL_EMBMS_AT_INFO ";
	case MTK2_RIL_UNSOL_RADIO_CAPABILITY_SWITCH_START:
		return "MTK2_RIL_UNSOL_RADIO_CAPABILITY_SWITCH_START";
	default:
		return NULL;
	}
}
