#!/usr/bin/env python

texVariableTypeNames =\
[
	"texture1d",
	"texture1d_array",
	"texture2d",
	"texture2d_array",
	"texturecube",
	"texturecube_array",
	"texture3d",
	"texture2d_ms",
	"texture2d_ms_array",
	"depth2d",
	"depth2d_array",
	"depth2d_ms",
	"depth2d_ms_array",
]

pixelFormatTypes =\
[
	"float",
	"half",
	"int",
	"uint",
	"short",
	"ushort",
	"char",
	"uchar",
]

accessTypes =\
[
	"sample",
	"read",
	"write",
	"read_write",
]


file = open( '../../RenderSystems/Metal/include/OgreMetalPixelFormatToShaderType.inl', 'w+' )

file.write(
'''/// AUTOGENERATED FILE!!! See Scripts/D3D11/GenerateD3D11PixelFormatToShaderType.py
namespace Ogre
{
	//depth2d through depth2d_ms_array only have 'float'
	static const char c_dataTypes[PixelFormatDataTypes::NumPixelFormatDataTypes*''' + str( len( texVariableTypeNames ) - 4 ) + '''u*4u+1u*4u*4u][48] =
	{
''' )

for texVariableTypeName in texVariableTypeNames:
	for pixelFormatType in pixelFormatTypes:
		if not texVariableTypeName.startswith( "depth2d" ) or pixelFormatType == "float":
		#if not texVariableTypeName.startswith( "depth2d" )
			for accessType in accessTypes:
				file.write( '		"' + texVariableTypeName + '<' + pixelFormatType + ', access::' + accessType + '>",\n' )

file.write( '''	};
}
''' )
