#include <klocale.h>

#include "country.h"

// disable inclusion in okle.pot for now in here - HACK ;-)
#define a18n(m) i18n(m)

CountryCode::CountryCode(const QString& n,const QString& c)
{
 name = n;
 code = c;
}

// country codes
void Country::init()
{
 countries.append(new CountryCode(a18n("Afghanistan"),"af"));
 countries.append(new CountryCode(a18n("Albania"),"al"));
 countries.append(new CountryCode(a18n("Algeria"),"dz"));
 countries.append(new CountryCode(a18n("American Samoa"),"as"));
 countries.append(new CountryCode(a18n("Andorra"),"ad"));
 countries.append(new CountryCode(a18n("Angola"),"ao"));
 countries.append(new CountryCode(a18n("Anguilla"),"ai"));
 countries.append(new CountryCode(a18n("Antarctica"),"aq"));
 countries.append(new CountryCode(a18n("Antigua and Barbuda"),"ag"));
 countries.append(new CountryCode(a18n("Argentina"),"ar"));
 countries.append(new CountryCode(a18n("Armenia"),"am"));
 countries.append(new CountryCode(a18n("Aruba"),"aw"));
 countries.append(new CountryCode(a18n("Australia"),"au"));
 countries.append(new CountryCode(a18n("Austria"),"at"));
 countries.append(new CountryCode(a18n("Azerbaijan"),"az"));
 countries.append(new CountryCode(a18n("Bahamas"),"bs"));
 countries.append(new CountryCode(a18n("Bahrain"),"bh"));
 countries.append(new CountryCode(a18n("Bangladesh"),"bd"));
 countries.append(new CountryCode(a18n("Barbados"),"bb"));
 countries.append(new CountryCode(a18n("Belarus"),"by"));
 countries.append(new CountryCode(a18n("Belgium"),"be"));
 countries.append(new CountryCode(a18n("Belize"),"bz"));
 countries.append(new CountryCode(a18n("Benin"),"bj"));
 countries.append(new CountryCode(a18n("Bermuda"),"bm"));
 countries.append(new CountryCode(a18n("Bhutan"),"bt"));
 countries.append(new CountryCode(a18n("Bolivia"),"bo"));
 countries.append(new CountryCode(a18n("Bosina and Herzegovina"),"ba"));
 countries.append(new CountryCode(a18n("Botswana"),"bw"));
 countries.append(new CountryCode(a18n("Bouvet Island"),"bv"));
 countries.append(new CountryCode(a18n("Brazil"),"br"));
 countries.append(new CountryCode(a18n("British Indian Ocean Territory"),"io"));
 countries.append(new CountryCode(a18n("Brunei Darussalam"),"bn"));
 countries.append(new CountryCode(a18n("Bulgaria"),"bg"));
 countries.append(new CountryCode(a18n("Burkina Faso"),"bf"));
 countries.append(new CountryCode(a18n("Burundi"),"bi"));
 countries.append(new CountryCode(a18n("Cambodia"),"kh"));
 countries.append(new CountryCode(a18n("Cameroon"),"cm"));
 countries.append(new CountryCode(a18n("Canada"),"ca"));
 countries.append(new CountryCode(a18n("Cape Verde"),"cv"));
 countries.append(new CountryCode(a18n("Cayman Islands"),"ky"));
 countries.append(new CountryCode(a18n("Central African Republic"),"cf"));
 countries.append(new CountryCode(a18n("Chad"),"td"));
 countries.append(new CountryCode(a18n("Chile"),"cl"));
 countries.append(new CountryCode(a18n("China"),"cn"));
 countries.append(new CountryCode(a18n("Christmas Island"),"cx"));
 countries.append(new CountryCode(a18n("Cocos (Keeling) Islands"),"cc"));
 countries.append(new CountryCode(a18n("Colombia"),"co"));
 countries.append(new CountryCode(a18n("Comoros"),"km"));
 countries.append(new CountryCode(a18n("Congo"),"cg"));
 countries.append(new CountryCode(a18n("Congo, The Democratic Republic of The"),"cd"));
 countries.append(new CountryCode(a18n("Cook Islands"),"ck"));
 countries.append(new CountryCode(a18n("Costa Rica"),"cr"));
 // TRANSLATORS: this is really C&#244;te D'Ivoire
 countries.append(new CountryCode(a18n("Cote d'Ivoire"),"ci"));
 countries.append(new CountryCode(a18n("Croatia"),"hr"));
 countries.append(new CountryCode(a18n("Cuba"),"cu"));
 countries.append(new CountryCode(a18n("Cyprus"),"cy"));
 countries.append(new CountryCode(a18n("Czech Republic"),"cz"));
 countries.append(new CountryCode(a18n("Denmark"),"dk"));
 countries.append(new CountryCode(a18n("Djibouti"),"dj"));
 countries.append(new CountryCode(a18n("Dominica"),"dm"));
 countries.append(new CountryCode(a18n("Dominican Republic"),"do"));
 countries.append(new CountryCode(a18n("East Timor"),"tl"));
 countries.append(new CountryCode(a18n("Ecuador"),"ec"));
 countries.append(new CountryCode(a18n("Egypt"),"eg"));
 countries.append(new CountryCode(a18n("El Salvador"),"sv"));
 countries.append(new CountryCode(a18n("Equatorial Guinea"),"gq"));
 countries.append(new CountryCode(a18n("Eritrea"),"er"));
 countries.append(new CountryCode(a18n("Estonia"),"ee"));
 countries.append(new CountryCode(a18n("Ethiopia"),"et"));
 countries.append(new CountryCode(a18n("Falkland Islands (Malvinas)"),"fk"));
 countries.append(new CountryCode(a18n("Faroe Islands"),"fo"));
 countries.append(new CountryCode(a18n("Fiji"),"fj"));
 countries.append(new CountryCode(a18n("Finland"),"fi"));
 countries.append(new CountryCode(a18n("France"),"fr"));
 countries.append(new CountryCode(a18n("French Guiana"),"gf"));
 countries.append(new CountryCode(a18n("French Polynesia"),"pf"));
 countries.append(new CountryCode(a18n("French Southern Territories"),"tf"));
 countries.append(new CountryCode(a18n("Gabon"),"ga"));
 countries.append(new CountryCode(a18n("Gambia"),"gm"));
 countries.append(new CountryCode(a18n("Georgia"),"ge"));
 countries.append(new CountryCode(a18n("Germany"),"de"));
 countries.append(new CountryCode(a18n("Ghana"),"gh"));
 countries.append(new CountryCode(a18n("Gibraltar"),"gi"));
 countries.append(new CountryCode(a18n("Greece"),"gr"));
 countries.append(new CountryCode(a18n("Greenland"),"gl"));
 countries.append(new CountryCode(a18n("Grenada"),"gd"));
 countries.append(new CountryCode(a18n("Guadeloupe"),"gp"));
 countries.append(new CountryCode(a18n("Guam"),"gu"));
 countries.append(new CountryCode(a18n("Guatemala"),"gt"));
 countries.append(new CountryCode(a18n("Guinea"),"gn"));
 countries.append(new CountryCode(a18n("Guinea-Bissau"),"gw"));
 countries.append(new CountryCode(a18n("Guyana"),"gy"));
 countries.append(new CountryCode(a18n("Haiti"),"hi"));
 countries.append(new CountryCode(a18n("Heard Island and McDonald Islands"),"hm"));
 countries.append(new CountryCode(a18n("Vatican City State"),"va"));
 countries.append(new CountryCode(a18n("Honduras"),"hn"));
 countries.append(new CountryCode(a18n("Hong Kong"),"hk"));
 countries.append(new CountryCode(a18n("Hungary"),"hu"));
 countries.append(new CountryCode(a18n("Iceland"),"is"));
 countries.append(new CountryCode(a18n("India"),"in"));
 countries.append(new CountryCode(a18n("Indonesia"),"id"));
 countries.append(new CountryCode(a18n("Iran, Islamic Republic of"),"ir"));
 countries.append(new CountryCode(a18n("Iraq"),"iq"));
 countries.append(new CountryCode(a18n("Ireland"),"ie"));
 countries.append(new CountryCode(a18n("Israel"),"il"));
 countries.append(new CountryCode(a18n("Italy"),"it"));
 countries.append(new CountryCode(a18n("Jamaica"),"jm"));
 countries.append(new CountryCode(a18n("Japan"),"jp"));
 countries.append(new CountryCode(a18n("Jordan"),"jo"));
 countries.append(new CountryCode(a18n("Kazakhstan"),"kz"));
 countries.append(new CountryCode(a18n("Kenya"),"ke"));
 countries.append(new CountryCode(a18n("Kiribati"),"ki"));
 countries.append(new CountryCode(a18n("Korea, Democratic People's Republic of"),"kp"));
 countries.append(new CountryCode(a18n("Korea, Republic of"),"kr"));
 countries.append(new CountryCode(a18n("Kuwait"),"kw"));
 countries.append(new CountryCode(a18n("Kyrgyzstan"),"kg"));
 countries.append(new CountryCode(a18n("Lao People's Democratic Republic"),"la"));
 countries.append(new CountryCode(a18n("Latvia"),"lv"));
 countries.append(new CountryCode(a18n("Lebanon"),"lb"));
 countries.append(new CountryCode(a18n("Lesotho"),"ls"));
 countries.append(new CountryCode(a18n("Liberia"),"lr"));
 countries.append(new CountryCode(a18n("Libyan Arab Jamahiriya"),"ly"));
 countries.append(new CountryCode(a18n("Liechtenstein"),"li"));
 countries.append(new CountryCode(a18n("Lithuania"),"lt"));
 countries.append(new CountryCode(a18n("Luxembourg"),"lu"));
 countries.append(new CountryCode(a18n("Macao"),"mo"));
 countries.append(new CountryCode(a18n("Macedonia, The Former Yugoslav Republic of"),"mk"));
 countries.append(new CountryCode(a18n("Madagascar"),"mg"));
 countries.append(new CountryCode(a18n("Malawi"),"mw"));
 countries.append(new CountryCode(a18n("Malaysia"),"my"));
 countries.append(new CountryCode(a18n("Maldives"),"mv"));
 countries.append(new CountryCode(a18n("Mali"),"ml"));
 countries.append(new CountryCode(a18n("Malta"),"mt"));
 countries.append(new CountryCode(a18n("Marshall Islands"),"mh"));
 countries.append(new CountryCode(a18n("Martinique"),"mq"));
 countries.append(new CountryCode(a18n("Mauritania"),"mr"));
 countries.append(new CountryCode(a18n("Mauritius"),"mu"));
 countries.append(new CountryCode(a18n("Mayotte"),"yt"));
 countries.append(new CountryCode(a18n("Mexico"),"mx"));
 countries.append(new CountryCode(a18n("Micronesia, Federated States of"),"fm"));
 countries.append(new CountryCode(a18n("Moldova, Republic of"),"md"));
 countries.append(new CountryCode(a18n("Monaco"),"mc"));
 countries.append(new CountryCode(a18n("Mongolia"),"mn"));
 countries.append(new CountryCode(a18n("Montserrat"),"ms"));
 countries.append(new CountryCode(a18n("Morocco"),"ma"));
 countries.append(new CountryCode(a18n("Mozambique"),"mz"));
 countries.append(new CountryCode(a18n("Myanmar"),"mm"));
 countries.append(new CountryCode(a18n("Namibia"),"na"));
 countries.append(new CountryCode(a18n("Nauru"),"nr"));
 countries.append(new CountryCode(a18n("Nepal"),"np"));
 countries.append(new CountryCode(a18n("Netherlands"),"nl"));
 countries.append(new CountryCode(a18n("Netherlands Antilles"),"an"));
 countries.append(new CountryCode(a18n("New Caledonia"),"nc"));
 countries.append(new CountryCode(a18n("New Zealand"),"nz"));
 countries.append(new CountryCode(a18n("Nicaragua"),"ni"));
 countries.append(new CountryCode(a18n("Niger"),"ne"));
 countries.append(new CountryCode(a18n("Nigeria"),"ng"));
 countries.append(new CountryCode(a18n("Niue"),"nu"));
 countries.append(new CountryCode(a18n("Norfolk Island"),"nf"));
 countries.append(new CountryCode(a18n("Northern Mariana Islands"),"mp"));
 countries.append(new CountryCode(a18n("Norway"),"no"));
 countries.append(new CountryCode(a18n("Oman"),"om"));
 countries.append(new CountryCode(a18n("Pakistan"),"pk"));
 countries.append(new CountryCode(a18n("Palau"),"pw"));
 countries.append(new CountryCode(a18n("Palestinian Territory, Occupied"),"ps"));
 countries.append(new CountryCode(a18n("Panama"),"pa"));
 countries.append(new CountryCode(a18n("Papua New Guinea"),"pg"));
 countries.append(new CountryCode(a18n("Paraguay"),"py"));
 countries.append(new CountryCode(a18n("Peru"),"pe"));
 countries.append(new CountryCode(a18n("Philippines"),"ph"));
 countries.append(new CountryCode(a18n("Pitcairn"),"pn"));
 countries.append(new CountryCode(a18n("Poland"),"pl"));
 countries.append(new CountryCode(a18n("Portugal"),"pt"));
 countries.append(new CountryCode(a18n("Puerto Rico"),"pr"));
 countries.append(new CountryCode(a18n("Qatar"),"qa"));
 // TRANSLATORS: this is really R&#233;union
 countries.append(new CountryCode(a18n("Reunion"),"re"));
 countries.append(new CountryCode(a18n("Romania"),"ro"));
 countries.append(new CountryCode(a18n("Russian Federation"),"ru"));
 countries.append(new CountryCode(a18n("Rwanda"),"rw"));
 countries.append(new CountryCode(a18n("Saint Helena"),"sh"));
 countries.append(new CountryCode(a18n("Saint Kitts and Nevis"),"kn"));
 countries.append(new CountryCode(a18n("Saint Lucia"),"lc"));
 countries.append(new CountryCode(a18n("Saint Pierre and Miquelon"),"pm"));
 countries.append(new CountryCode(a18n("Saint Vincent and the Grenadines"),"vc"));
 countries.append(new CountryCode(a18n("Samoa"),"ws"));
 countries.append(new CountryCode(a18n("San Marino"),"sm"));
 countries.append(new CountryCode(a18n("Sao Tome and Principe"),"st"));
 countries.append(new CountryCode(a18n("Saudi Arabia"),"sa"));
 countries.append(new CountryCode(a18n("Senegal"),"sn"));
 countries.append(new CountryCode(a18n("Seychelles"),"sc"));
 countries.append(new CountryCode(a18n("Sierra Leone"),"sl"));
 countries.append(new CountryCode(a18n("Singapore"),"sg"));
 countries.append(new CountryCode(a18n("Slovakia"),"sk"));
 countries.append(new CountryCode(a18n("Slovenia"),"si"));
 countries.append(new CountryCode(a18n("Solomon Islands"),"sb"));
 countries.append(new CountryCode(a18n("Somalia"),"so"));
 countries.append(new CountryCode(a18n("South Africa"),"za"));
 countries.append(new CountryCode(a18n("South Georgia and the South Sandwich Islands"),"gs"));
 countries.append(new CountryCode(a18n("Spain"),"es"));
 countries.append(new CountryCode(a18n("Sri Lanka"),"lk"));
 countries.append(new CountryCode(a18n("Sudan"),"sd"));
 countries.append(new CountryCode(a18n("Suriname"),"sr"));
 countries.append(new CountryCode(a18n("Svalbard and Jan Mayen"),"sj"));
 countries.append(new CountryCode(a18n("Swaziland"),"sz"));
 countries.append(new CountryCode(a18n("Sweden"),"se"));
 countries.append(new CountryCode(a18n("Switzerland"),"ch"));
 countries.append(new CountryCode(a18n("Syrian Arab Republic"),"sy"));
 countries.append(new CountryCode(a18n("Taiwan, Province of China"),"tw"));
 countries.append(new CountryCode(a18n("Tajikistan"),"tj"));
 countries.append(new CountryCode(a18n("Tanzania, United Republic of"),"tz"));
 countries.append(new CountryCode(a18n("Thailand"),"th"));
 countries.append(new CountryCode(a18n("Togo"),"tg"));
 countries.append(new CountryCode(a18n("Tokelau"),"tk"));
 countries.append(new CountryCode(a18n("Tonga"),"td"));
 countries.append(new CountryCode(a18n("Trinidad and Tobago"),"tt"));
 countries.append(new CountryCode(a18n("Tunisia"),"tn"));
 countries.append(new CountryCode(a18n("Turkey"),"tr"));
 countries.append(new CountryCode(a18n("Turkmenistan"),"tm"));
 countries.append(new CountryCode(a18n("Turks and Caicos Islands"),"tc"));
 countries.append(new CountryCode(a18n("Tuvalu"),"tv"));
 countries.append(new CountryCode(a18n("Uganda"),"ug"));
 countries.append(new CountryCode(a18n("Ukraine"),"ua"));
 countries.append(new CountryCode(a18n("United Arab Emirates"),"ae"));
 countries.append(new CountryCode(a18n("United Kingdom"),"gb"));
 countries.append(new CountryCode(a18n("United States (USA)"),"us"));
 countries.append(new CountryCode(a18n("United States Minore Outlying Islands"),"um"));
 countries.append(new CountryCode(a18n("Uruguay"),"uy"));
 countries.append(new CountryCode(a18n("Uzbekistan"),"uz"));
 countries.append(new CountryCode(a18n("Vanuatu"),"vu"));
 countries.append(new CountryCode(a18n("Venezuela"),"ve"));
 countries.append(new CountryCode(a18n("Viet Nam"),"vn"));
 countries.append(new CountryCode(a18n("Virgin Islands, British"),"vg"));
 countries.append(new CountryCode(a18n("Virgin Islands, U.S."),"vi"));
 countries.append(new CountryCode(a18n("Wallis and Futuna"),"wf"));
 countries.append(new CountryCode(a18n("Western Sahara"),"eh"));
 countries.append(new CountryCode(a18n("Yemen"),"ye"));
 countries.append(new CountryCode(a18n("Yugoslavia"),"yu"));
 countries.append(new CountryCode(a18n("Zambia"),"zm"));
 countries.append(new CountryCode(a18n("Zimbabwe"),"zw"));
}

QString Country::name(DVDCountryID_t lang) 
{
 QString lang_code;
 lang_code[0] = lang >> 8;
 lang_code[1] = lang & 0xff;
 for(uint i=0;i<countries.count();i++)
  {
   if(countries.at(i)->code == lang_code)
    return a18n(countries.at(i)->name);
  }
 // Unknown language
 return a18n("Unknown");
}

QString Country::code(DVDCountryID_t lang) 
{
  QString lang_code;

 lang_code[0] = lang >> 8;
 lang_code[1] = lang & 0xff;
 for(uint i=0;i<countries.count();i++)
  {
   if(countries.at(i)->code == lang_code)
    return countries.at(i)->code;
  }
 return "??";
}

QStringList Country::allNames()
{
 QStringList tmplist;
 for(uint i=0;i<countries.count();i++)
  tmplist.append(a18n(countries.at(i)->name));
 tmplist.sort();
 return tmplist;
}

QStringList Country::allCodes()
{
 QStringList tmplist;
 for(uint i=0;i<countries.count();i++)
  tmplist.append(countries.at(i)->code);
 tmplist.sort();
 return tmplist;
}

DVDCountryID_t Country::id(const QString& str)
{
 DVDCountryID_t countryid = 0;
 QString code_639_1;
 for(uint i=0;countries.count();i++)
  {
   if(a18n(countries.at(i)->name) == str)
    {
     countryid = QChar(countries.at(i)->code[0]) << 8;
     countryid += QChar(countries.at(i)->code[1]);
     break;
    }
  }
 return countryid;
}

QPtrList<CountryCode> Country::countries;

