extern "C" {
#include <ogle/dvdcontrol.h>
}

#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "okle_win.h"

int msgqid;
ZoomMode_t zoomMode;
bool isPaused;
bool isPlaying;
OkleWin* w;

static KCmdLineOptions options[] = 
{
 { "m <msgid>", "msgid", "-1" }, // this is given by the ogle binary
 { 0,0,0 }
};

int main(int argc,char** argv)
{
 if(argc < 2)
  qFatal("Please do not call the okle_gui binary directly!\nInstead run the okle script or if you can't find it\n\"DVDP_UI=/path/to/okle_gui ogle\" should also work.");

 KAboutData aboutData("okle",I18N_NOOP("oKle"),"0.4",
                      I18N_NOOP("KDE DVD Player"),KAboutData::License_GPL,0,0,
		      "http://okle.sourceforge.net");
 aboutData.addAuthor("Martin Piskernig",I18N_NOOP("Maintainer"),"martin.piskernig@univie.ac.at");
 
 KCmdLineArgs::init(argc,argv,&aboutData);
 KCmdLineArgs::addCmdLineOptions(options, "Ogle", "ogle");
 KApplication::addCmdLineOptions();
 
 KApplication app;

 msgqid = QString(KCmdLineArgs::parsedArgs("ogle")->getOption("m")).toInt();

 w = new OkleWin(msgqid);
 app.setMainWidget(w);
 w->show();

 return app.exec();
}

#if 0
i18n("_: NAME OF TRANSLATORS\nYour names");
i18n("_: EMAIL OF TRANSLATORS\nYour emails");
#endif
