#if !defined(QT_CLEAN_NAMESPACE)
#define QT_CLEAN_NAMESPACE
#endif

#include "okle_win.h"

#include "prefs_win.h"
#include "gototime_win.h"
#include "dvdinfo_win.h"
#include "screenshot_win.h"
#include "editbookmarks_win.h"
#include "sniffer.h"
#include "language.h"
#include "country.h"
#include "mixer.h"

#include <stdlib.h>
#include <klocale.h>
#include <kconfig.h>
#include <qpushbutton.h>
#include <kapp.h>
#include <klineeditdlg.h>
#include <kmenubar.h>
#include <kfiledialog.h>
#include <kmessagebox.h>
#include <qlayout.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kiconloader.h>
#include <qslider.h>
#include <qtimer.h>
#include <qlabel.h>
#include <kpopupmenu.h>
#include <kwin.h>
#include <netwm.h>
#include <kiconloader.h>
#include <kstandarddirs.h>
#include <qtooltip.h>
#include <dcopclient.h>

extern "C" {
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <X11/extensions/dpms.h>
#include <X11/keysym.h>
#include <ogle/msgevents.h>
#include <ogle/dvdevents.h>
}

OkleWin::OkleWin(int m) : DCOPObject("OkleIface") , KMainWindow(0,"oklewin",WStyle_Customize|WStyle_DialogBorder)
{
 // ogle binary gives us the message queue id
 msgqid = m;

 setCaption("oKle");
 setIcon(SmallIcon("okle"));

 // initialize language and country codes
 Language::init();
 Country::init();

 // initialize mixer
 Mixer::init();

 // initialize some variables we'll need later on
 ispaused = false;

 oldsliderval = 0;

 hasDPMS = false;
 hasScreensaver = false;

 speed = 1.0;

 sliderMoving = false;

 bookmarks = 0;
 dcopclient = 0;
 nav = 0;

 currtitle = 0;

 // get configuration handle
 conf = kapp->config();
 
 // setup connection to dcop server
 initDCOP(); 

 // build UI
 initMenuBar();
 initUI();

 // read configuration from file
 readConfig(conf);

 // is autoplay enabled? 
 conf->setGroup("Startup");
 if(conf->readBoolEntry("AutoPlay",false))
  {
//   viewFullscreen->setChecked(conf->readBoolEntry("AutoFullScreen",false)); //temp. commented out
   openDisc();
  }
}

OkleWin::~OkleWin()
{}

void OkleWin::setToTop(bool b)
{
 kapp->lock(); // is this really needed?
 if(!b)
  {
   KWin::clearState(winId(),NET::StaysOnTop);
   hide();
  }
 else
  {
   KWin::setActiveWindow(winId());
   if(viewFullscreen->isChecked())
    KWin::setState(winId(),NET::StaysOnTop);
   show();
  }
 kapp->unlock(); // see above...
}

bool OkleWin::isSetToTop()const
{
 return isVisible();
}

void OkleWin::readConfig(KConfig* c)
{
 // window position
 c->setGroup("General");
 int tx = c->readNumEntry("x",100);
 int ty = c->readNumEntry("y",100);
 move(tx,ty);
 
 // adjust screen mode
 c->setGroup("View");
// bool b = c->readBoolEntry("Fullscreen",false); //temp disabled
// viewFullscreen->setChecked(b);

 // establish uninterrupted viewing if wanted
 conf->setGroup("Startup");
 if(conf->readBoolEntry("DisableDPMS",true))
  disableDPMS();
 if(conf->readBoolEntry("DisableScreenSaver",true))
  disableScreensaver();
}

void OkleWin::saveConfig(KConfig* c)
{
 // window position
 c->setGroup("General");
 c->writeEntry("x",x());
 c->writeEntry("y",y());
 
 // screen mode at exit
 c->setGroup("View");
 c->writeEntry("Fullscreen",isFullScreen());
}

void OkleWin::initNav()
{
 if(msgqid !=-1)
  {
   DVDResult_t res = DVDOpenNav(&nav, msgqid);
   if(res != DVD_E_Ok )
    {
     DVDPerror("initNav: DVDOpen", res);
     KApplication::exit(1);
    }
  }
}

bool OkleWin::isPaused()const
{
 return ispaused;
}

bool OkleWin::isPlaying()const
{
 return !ispaused;
}

int OkleWin::currentTitle()const
{
 DVDLocation_t loc;
 DVDGetCurrentLocation(nav,&loc);
 return loc.title;
}

int OkleWin::currentChapter()const
{
 DVDLocation_t loc;
 DVDGetCurrentLocation(nav,&loc);
 return loc.ptt;
}

void OkleWin::initSniffer()
{
 sniffer = new Sniffer(this,msgqid);
 sniffer->start();
}

void OkleWin::initDCOP()
{
 // register ourself
 dcopclient = kapp->dcopClient();
// dcopclient->attach();
 dcopclient->registerAs(kapp->name());
 dcopclient->setDefaultObject(objId());
}

void OkleWin::initMenuBar()
{
 // FILE
 fileOpenDisc = new KAction(i18n("&Open disc"),CTRL+Key_O,this,SLOT(openDisc()),actionCollection(),"file_open_disc");
 fileOpenFile = new KAction(i18n("Open &file..."),CTRL+SHIFT+Key_O,this,SLOT(openFile()),actionCollection(),"file_open_file");
 fileCloseDisc = new KAction(i18n("&Close disc"),0,this,SLOT(closeDisc()),actionCollection(),"file_close_disc");
 fileDVDInfo = new KAction(i18n("Disc &information..."),CTRL+Key_I,this,SLOT(DVDInfo()),actionCollection(),"file_disc_info");
 new KAction(i18n("&Preferences"),ALT+Key_P,this,SLOT(preferences()),actionCollection(),"file_preferences");
 KStdAction::quit(this,SLOT(quit()),actionCollection());

 // VIEW
 viewFullscreen = new KToggleAction(i18n("&Fullscreen"),Key_F,this,SLOT(viewFullscreenActivated()),actionCollection(),"view_fullscreen");
 viewScreenshot = new KAction(i18n("Take &screenshot..."),0,this,SLOT(viewScreenshotActivated()),actionCollection(),"view_screenshot");

 // GO
 goPlay = new KAction(i18n("&Play"),Key_P,this,SLOT(play()),actionCollection(),"go_play");
 goPause = new KAction(i18n("P&ause"),Key_Bar,this,SLOT(pause()),actionCollection(),"go_pause");
 goStop = new KAction(i18n("&Stop"),Key_X,this,SLOT(stop()),actionCollection(),"go_stop");
 goPrevChapter = new KAction(i18n("P&revious chapter"),Key_Less,this,SLOT(previousChapter()),actionCollection(),"go_prev_chapter");
 goNextChapter = new KAction(i18n("&Next chapter"),Key_Greater,this,SLOT(nextChapter()),actionCollection(),"go_next_chapter");
 goFast = new KAction(i18n("&Fast"),Key_Period,this,SLOT(fast()),actionCollection(),"go_fast");
 goSlow = new KAction(i18n("S&low"),Key_Comma,this,SLOT(slow()),actionCollection(),"go_slow");
 goGoto = new KActionMenu(i18n("&Chapter"),actionCollection(),"go_goto_chapter");
 connect(goGoto->popupMenu(),SIGNAL(highlighted(int)),this,SLOT(gotoTitleHighlighted(int)));
 goGotoTime = new KAction(i18n("&Go to time..."),0,this,SLOT(gotoTime()),actionCollection(),"go_goto_time");
 
 // MENU
 menuUp = new KAction(i18n("&Up"),Key_Up,this,SLOT(up()),actionCollection(),"menu_up");
 menuDown = new KAction(i18n("&Down"),Key_Down,this,SLOT(down()),actionCollection(),"menu_down");
 menuLeft = new KAction(i18n("&Left"),Key_Left,this,SLOT(left()),actionCollection(),"menu_left");
 menuRight = new KAction(i18n("R&ight"),Key_Right,this,SLOT(right()),actionCollection(),"menu_right");
 menuEnter = new KAction(i18n("&Enter"),Key_Return,this,SLOT(enter()),actionCollection(),"menu_enter");
 menuGoUp = new KAction(i18n("&Go Up"),Key_U,this,SLOT(goUp()),actionCollection(),"menu_go_up");
 menuResume = new KAction(i18n("Re&sume"),Key_C,this,SLOT(resume()),actionCollection(),"menu_resume");
 menuTitleMenu = new KAction(i18n("&Title menu"),Key_T,this,SLOT(titleMenu()),actionCollection(),"menu_title_menu");
 menuRootMenu = new KAction(i18n("&Root menu"),Key_R,this,SLOT(rootMenu()),actionCollection(),"menu_root_menu");
 menuAudioMenu = new KAction(i18n("&Audio menu"),Key_A,this,SLOT(audioMenu()),actionCollection(),"menu_audio_menu");
 menuAngleMenu = new KAction(i18n("A&ngle menu"),SHIFT+Key_A,this,SLOT(angleMenu()),actionCollection(),"menu_angle_menu");
 menuChapterMenu = new KAction(i18n("&Chapter menu"),SHIFT+Key_P,this,SLOT(chapterMenu()),actionCollection(),"menu_chapter_menu");
 menuSubtitleMenu = new KAction(i18n("Su&btitle menu"),SHIFT+Key_S,this,SLOT(subtitleMenu()),actionCollection(),"menu_subtitle_menu");

 // BOOKMARKS
 bookmarksMenu = new KActionMenu(i18n("&Bookmarks"),actionCollection(),"bookmarks");
 bookmarkAdd = new KAction(i18n("&Add bookmark"),0,this,SLOT(bookmarkAddBookmark()),actionCollection(),"bookmark_add");
 bookmarkEdit = new KAction(i18n("&Edit bookmarks..."),0,this,SLOT(editBookmarks()),actionCollection(),"bookmark_edit");
 bookmarkRemove = new KActionMenu(i18n("&Remove bookmark"),actionCollection(),"bookmark_remove");
 bookmarkRemoveAll = new KAction(i18n("R&emove all bookmarks"),0,this,SLOT(removeAllBookmarks()),actionCollection(),"bookmark_remove_all");
 bookmarksMenu->insert(bookmarkAdd);
 bookmarksMenu->insert(bookmarkEdit);
 bookmarksMenu->insert(bookmarkRemove);
 bookmarksMenu->insert(bookmarkRemoveAll);
 bookmarksMenu->insert(new KActionSeparator());
 connect(bookmarksMenu->popupMenu(),SIGNAL(activated(int)),this,SLOT(bookmarkActivated(int)));
 connect(bookmarkRemove->popupMenu(),SIGNAL(activated(int)),this,SLOT(bookmarkRemoveActivated(int)));
 
 // disable now-not-possible menu items
 fileCloseDisc->setEnabled(false);
 fileDVDInfo->setEnabled(false);
 viewFullscreen->setEnabled(false);
 viewScreenshot->setEnabled(false);
 goPlay->setEnabled(false);
 goPause->setEnabled(false);
 goStop->setEnabled(false);
 goPrevChapter->setEnabled(false);
 goNextChapter->setEnabled(false);
 goFast->setEnabled(false);
 goSlow->setEnabled(false);
 goGoto->setEnabled(false);
 goGotoTime->setEnabled(false);
 menuUp->setEnabled(false);
 menuDown->setEnabled(false);
 menuLeft->setEnabled(false);
 menuRight->setEnabled(false);
 menuEnter->setEnabled(false);
 menuGoUp->setEnabled(false);
 menuResume->setEnabled(false);
 menuTitleMenu->setEnabled(false);
 menuRootMenu->setEnabled(false);
 menuAudioMenu->setEnabled(false);
 menuAngleMenu->setEnabled(false);
 menuChapterMenu->setEnabled(false);
 menuSubtitleMenu->setEnabled(false);
 //bookmarksMenu->setEnabled(false);
 bookmarkAdd->setEnabled(false);
 bookmarkEdit->setEnabled(false);
 bookmarkRemove->setEnabled(false);
 bookmarkRemoveAll->setEnabled(false);

 createGUI("okleui.rc");
}

void OkleWin::initUI()
{
 QFrame* mainframe = new QFrame(this);
 setCentralWidget(mainframe);
 
 QVBoxLayout* vbox = new QVBoxLayout(mainframe);

 vbox->addSpacing(5);

 QHBoxLayout* hbo = new QHBoxLayout(vbox);

 hbo->addSpacing(5);
 
 slider = new QSlider(QSlider::Horizontal,mainframe);
 slider->setMinValue(1);
 slider->setTracking(false);
 slider->setLineStep(1);
 slider->setPageStep(0);
 connect(slider,SIGNAL(sliderPressed()),this,SLOT(sliderPressed()));
 connect(slider,SIGNAL(sliderReleased()),this,SLOT(sliderReleased()));
 hbo->addWidget(slider);
 
 hbo->addSpacing(5);

 vbox->addSpacing(5);

 QHBoxLayout* hbox = new QHBoxLayout(vbox);

 hbox->addSpacing(5);
 
 QGridLayout* grid = new QGridLayout(hbox,17,2);

 KIconLoader iconload;

 rewindB = new QPushButton(mainframe);
 rewindB->setPixmap(locate("appdata","pics/rewind.png"));
 QToolTip::add(rewindB,i18n("Rewind"));
 grid->addWidget(rewindB,0,0);
 connect(rewindB,SIGNAL(clicked()),this,SLOT(rewind()));

 reverseB = new QPushButton(mainframe);
 reverseB->setPixmap(locate("appdata","pics/reverse.png"));
 QToolTip::add(reverseB,i18n("Reverse"));
 grid->addWidget(reverseB,0,1);
 connect(reverseB,SIGNAL(clicked()),this,SLOT(reverse()));
 
 stopB = new QPushButton(mainframe);
 stopB->setPixmap(locate("appdata","pics/stop.png"));
 QToolTip::add(stopB,i18n("Stop"));
 grid->addWidget(stopB,0,2);
 connect(stopB,SIGNAL(clicked()),this,SLOT(stop()));
 
 playB = new QPushButton(mainframe);
 playB->setPixmap(locate("appdata","pics/play.png"));
 QToolTip::add(playB,i18n("Play"));
 grid->addWidget(playB,0,3);
 connect(playB,SIGNAL(clicked()),this,SLOT(play()));
 
 fastforwardB = new QPushButton(mainframe);
 fastforwardB->setPixmap(locate("appdata","pics/fastforward.png"));
 QToolTip::add(fastforwardB,i18n("Fast forward"));
 grid->addWidget(fastforwardB,0,4);
 connect(fastforwardB,SIGNAL(clicked()),this,SLOT(fastForward()));
 
 skipbackwardB = new QPushButton(mainframe);
 skipbackwardB->setPixmap(locate("appdata","pics/skipbackward.png"));
 QToolTip::add(skipbackwardB,i18n("Skip backward"));
 grid->addWidget(skipbackwardB,1,0);
 connect(skipbackwardB,SIGNAL(clicked()),this,SLOT(previousChapter()));
 
 stepreverseB = new QPushButton(mainframe);
 stepreverseB->setPixmap(locate("appdata","pics/stepreverse.png"));
 QToolTip::add(stepreverseB,i18n("Step reverse"));
 grid->addWidget(stepreverseB,1,1);
 connect(stepreverseB,SIGNAL(clicked()),this,SLOT(stepReverse()));

 pauseB = new QPushButton(mainframe);
 pauseB->setPixmap(locate("appdata","pics/pause.png"));
 QToolTip::add(pauseB,i18n("Pause"));
 grid->addWidget(pauseB,1,2);
 connect(pauseB,SIGNAL(clicked()),this,SLOT(pause()));

 stepforwardB = new QPushButton(mainframe);
 stepforwardB->setPixmap(locate("appdata","pics/stepforward.png"));
 QToolTip::add(stepforwardB,i18n("Step forward"));
 grid->addWidget(stepforwardB,1,3);
 connect(stepforwardB,SIGNAL(clicked()),this,SLOT(stepForward()));

 skipforwardB = new QPushButton(mainframe);
 skipforwardB->setPixmap(locate("appdata","pics/skipforward.png"));
 QToolTip::add(skipforwardB,i18n("Skip forward"));
 grid->addWidget(skipforwardB,1,4);
 connect(skipforwardB,SIGNAL(clicked()),this,SLOT(nextChapter()));

 grid->addColSpacing(5,10);

 QColor bgcolor("black");
 QColor fgcolor("lightblue");
 QFrame* infoframe = new QFrame(mainframe);
 infoframe->setPaletteBackgroundColor(bgcolor);
 infoframe->setFrameShape(QFrame::Box);
 infoframe->setFrameShadow(QFrame::Sunken);
 infoframe->setLineWidth(1);
 infoframe->setMidLineWidth(0);
 QVBoxLayout* infovbox = new QVBoxLayout(infoframe,4);
 QHBoxLayout* infohbox0 = new QHBoxLayout(infovbox);
 infoctime = new QLabel("00:00:00",infoframe);
 infoctime->setPaletteForegroundColor(fgcolor);
 infohbox0->addWidget(infoctime,0,Qt::AlignLeft);
 QLabel* lof = new QLabel(i18n("of"),infoframe);
 lof->setPaletteForegroundColor(fgcolor);
 infohbox0->addWidget(lof,0,Qt::AlignHCenter);
 infottime = new QLabel("00:00:00",infoframe);
 infottime->setPaletteForegroundColor(fgcolor);
 infohbox0->addWidget(infottime,0,Qt::AlignRight);
 QHBoxLayout* infohbox1 = new QHBoxLayout(infovbox);
 infotitle = new QLabel(i18n("Title:")+" 0",infoframe);
 infotitle->setPaletteForegroundColor(fgcolor);
 infohbox1->addWidget(infotitle,0,Qt::AlignLeft);
 infochapter = new QLabel(i18n("Chapter:")+" 0",infoframe);
 infochapter->setPaletteForegroundColor(fgcolor);
 infohbox1->addWidget(infochapter,0,Qt::AlignRight);
 QHBoxLayout* infohbox2 = new QHBoxLayout(infovbox);
 infoaudio = new QLabel(i18n("Audio:")+" en",infoframe);
 infoaudio->setPaletteForegroundColor(fgcolor);
 infohbox2->addWidget(infoaudio,0,Qt::AlignLeft);
 infosubtitle = new QLabel(i18n("Subtitle:")+" -",infoframe);
 infosubtitle->setPaletteForegroundColor(fgcolor);
 infohbox2->addWidget(infosubtitle,0,Qt::AlignRight);
 grid->addMultiCellWidget(infoframe,0,1,6,10);
 
 grid->addColSpacing(11,10);

 selectmenu = new QPushButton(mainframe);
 selectmenu->setPixmap(locate("appdata","pics/selmenu.png"));
 QToolTip::add(selectmenu,i18n("Select Menu"));
 menus = new QPopupMenu;
 menus->insertItem(i18n("Chapter Menu"));
 menus->insertItem(i18n("Angle Menu"));
 menus->insertItem(i18n("Audio Menu"));
 menus->insertItem(i18n("Subtitle Menu"));
 menus->insertItem(i18n("Root Menu"));
 menus->insertItem(i18n("Title Menu"));
 menus->insertItem(i18n("Resume"));
 selectmenu->setPopup(menus);
 connect(menus,SIGNAL(activated(int)),this,SLOT(selectMenu(int)));
 grid->addWidget(selectmenu,0,12);

 audioselect = new QPushButton(mainframe);
 audioselect->setPixmap(locate("appdata","pics/audioselect.png"));
 QToolTip::add(audioselect,i18n("Select Audio Channel"));
 audioChannels = new QPopupMenu;
 audioselect->setPopup(audioChannels);
 connect(audioChannels,SIGNAL(activated(int)),this,SLOT(audioSelect(int)));
 grid->addWidget(audioselect,0,13);

 subtitleselect = new QPushButton(mainframe);
 subtitleselect->setPixmap(locate("appdata","pics/subtitleselect.png"));
 QToolTip::add(subtitleselect,i18n("Select Subtitle"));
 subtitleChannels = new QPopupMenu;
 subtitleselect->setPopup(subtitleChannels);
 connect(subtitleChannels,SIGNAL(activated(int)),this,SLOT(subTitleSelect(int)));
 grid->addWidget(subtitleselect,1,12);

 angleselect = new QPushButton(mainframe);
 angleselect->setPixmap(locate("appdata","pics/angleselect.png"));
 QToolTip::add(angleselect,i18n("Select Angle"));
 angles = new QPopupMenu;
 angleselect->setPopup(angles);
 connect(angles,SIGNAL(activated(int)),this,SLOT(angleSelect(int)));
 grid->addWidget(angleselect,1,13);

 grid->addColSpacing(14,10);

 QVBoxLayout* volvbox = new QVBoxLayout();
 
 volumeslider = new QSlider(mainframe);
 QToolTip::add(volumeslider,i18n("Volume control"));
 volumeslider->setValue(100-volume());
 volumeslider->setMinValue(0);
 volumeslider->setMaxValue(100);
 volumeslider->setOrientation(QSlider::Vertical);
 connect(volumeslider,SIGNAL(valueChanged(int)),this,SLOT(volumeChanged(int)));
 volvbox->addWidget(volumeslider);

 volvbox->addSpacing(3);

 mutebutton = new QPushButton(mainframe);
 mutebutton->setPixmap(locate("appdata","pics/volume.png"));
 mutebutton->setToggleButton(true);
 mutebutton->setFlat(true);
 connect(mutebutton,SIGNAL(toggled(bool)),this,SLOT(toggleMuteButton(bool)));
 volvbox->addWidget(mutebutton);
 
 grid->addMultiCellLayout(volvbox,0,1,15,15);

 grid->addColSpacing(16,5);

 vbox->addSpacing(5);
 
 // disable now not possible actions
 setJustStartedState();
 
 setFixedSize(sizeHint());
}

void OkleWin::setJustStartedState()
{
 // disable now-not-possible menu items
 fileCloseDisc->setEnabled(false);
 fileDVDInfo->setEnabled(false);
 viewFullscreen->setEnabled(false);
 viewScreenshot->setEnabled(false);
 goPlay->setEnabled(false);
 goPause->setEnabled(false);
 goStop->setEnabled(false);
 goPrevChapter->setEnabled(false);
 goNextChapter->setEnabled(false);
 goFast->setEnabled(false);
 goSlow->setEnabled(false);
 goGoto->setEnabled(false);
 goGotoTime->setEnabled(false);
 menuUp->setEnabled(false);
 menuDown->setEnabled(false);
 menuLeft->setEnabled(false);
 menuRight->setEnabled(false);
 menuEnter->setEnabled(false);
 menuGoUp->setEnabled(false);
 menuResume->setEnabled(false);
 menuTitleMenu->setEnabled(false);
 menuRootMenu->setEnabled(false);
 menuAudioMenu->setEnabled(false);
 menuAngleMenu->setEnabled(false);
 menuChapterMenu->setEnabled(false);
 menuSubtitleMenu->setEnabled(false);
 //bookmarksMenu->setEnabled(false);
 bookmarkAdd->setEnabled(false);
 bookmarkEdit->setEnabled(false);
 bookmarkRemove->setEnabled(false);
 bookmarkRemoveAll->setEnabled(false);

 rewindB->setEnabled(false);
 reverseB->setEnabled(false);
 stopB->setEnabled(false);
 playB->setEnabled(false);
 fastforwardB->setEnabled(false);
 skipbackwardB->setEnabled(false);
 stepreverseB->setEnabled(false);
 pauseB->setEnabled(false);
 stepforwardB->setEnabled(false);
 skipforwardB->setEnabled(false);
 selectmenu->setEnabled(false);
 audioselect->setEnabled(false);
 subtitleselect->setEnabled(false);
 angleselect->setEnabled(false);

 slider->setEnabled(false);

 volumeslider->setEnabled(false);
 mutebutton->setEnabled(false);
}

void OkleWin::setStoppedState()
{
 // disable now-not-possible menu items
 fileCloseDisc->setEnabled(true);
 fileDVDInfo->setEnabled(true);
 viewFullscreen->setEnabled(false);
 viewScreenshot->setEnabled(false);
 goPlay->setEnabled(false);
 goPause->setEnabled(false);
 goStop->setEnabled(false);
 goPrevChapter->setEnabled(false);
 goNextChapter->setEnabled(false);
 goFast->setEnabled(false);
 goSlow->setEnabled(false);
 goGoto->setEnabled(false);
 goGotoTime->setEnabled(false);
 menuUp->setEnabled(false);
 menuDown->setEnabled(false);
 menuLeft->setEnabled(false);
 menuRight->setEnabled(false);
 menuEnter->setEnabled(false);
 menuGoUp->setEnabled(false);
 menuResume->setEnabled(false);
 menuTitleMenu->setEnabled(false);
 menuRootMenu->setEnabled(false);
 menuAudioMenu->setEnabled(false);
 menuAngleMenu->setEnabled(false);
 menuChapterMenu->setEnabled(false);
 menuSubtitleMenu->setEnabled(false);
 //bookmarksMenu->setEnabled(false);
 bookmarkAdd->setEnabled(false);
 bookmarkEdit->setEnabled(false);
 bookmarkRemove->setEnabled(false);
 bookmarkRemoveAll->setEnabled(false);

 rewindB->setEnabled(false);
 reverseB->setEnabled(false);
 stopB->setEnabled(false);
 playB->setEnabled(true);
 fastforwardB->setEnabled(false);
 skipbackwardB->setEnabled(false);
 stepreverseB->setEnabled(false);
 pauseB->setEnabled(false);
 stepforwardB->setEnabled(false);
 skipforwardB->setEnabled(false);
 selectmenu->setEnabled(false);
 audioselect->setEnabled(false);
 subtitleselect->setEnabled(false);
 angleselect->setEnabled(false);

 slider->setEnabled(false);

 volumeslider->setEnabled(false);
 mutebutton->setEnabled(false);

 isstopped = true;
}

void OkleWin::setPlayingState()
{
 fileOpenDisc->setEnabled(false);
 fileOpenFile->setEnabled(false);
 fileCloseDisc->setEnabled(true);
 fileDVDInfo->setEnabled(true);
 viewScreenshot->setEnabled(true);
 goPlay->setEnabled(true);
 goPause->setEnabled(true);
 goStop->setEnabled(true);
 goPrevChapter->setEnabled(true);
 goNextChapter->setEnabled(true);
 goFast->setEnabled(true);
 goSlow->setEnabled(true);
 goGoto->setEnabled(true);
 goGotoTime->setEnabled(true);
 menuUp->setEnabled(true);
 menuDown->setEnabled(true);
 menuLeft->setEnabled(true);
 menuRight->setEnabled(true);
 menuEnter->setEnabled(true);
 menuGoUp->setEnabled(true);
 menuResume->setEnabled(true);
 menuTitleMenu->setEnabled(true);
 menuRootMenu->setEnabled(true);
 menuAudioMenu->setEnabled(true);
 menuAngleMenu->setEnabled(true);
 menuChapterMenu->setEnabled(true);
 menuSubtitleMenu->setEnabled(true);
 //bookmarksMenu->setEnabled(true);
 bookmarkAdd->setEnabled(true);
 bookmarkEdit->setEnabled(true);
 bookmarkRemove->setEnabled(true);
 bookmarkRemoveAll->setEnabled(true);

 rewindB->setEnabled(true);
 reverseB->setEnabled(true);
 stopB->setEnabled(true);
 playB->setEnabled(true);
 fastforwardB->setEnabled(true);
 skipbackwardB->setEnabled(true);
 stepreverseB->setEnabled(true);
 pauseB->setEnabled(true);
 stepforwardB->setEnabled(true);
 skipforwardB->setEnabled(true);
 selectmenu->setEnabled(true);
 audioselect->setEnabled(true);
 subtitleselect->setEnabled(true);
 angleselect->setEnabled(true);

 slider->setEnabled(true);

 volumeslider->setEnabled(true);
 mutebutton->setEnabled(true);
}

void OkleWin::setFullScreen(bool b)
{
 kapp->lock();
 ZoomMode_t z;
 if(!b)
  {
   z = static_cast<ZoomMode_t>(ZoomModeNormalScreen|ZoomModeResizeAllowed);
   setToTop(false);
   show();
  }
 else
  {
   z = ZoomModeFullScreen;
   hide();
  }
 DVDResult_t res = DVDSetZoomMode(nav,z);
 if(res != DVD_E_Ok)
  DVDPerror("OkleWin::setFullScreen(): DVDSetZoomMode:",res);
 kapp->unlock();
 
 viewFullscreen->setChecked(b);
}

bool OkleWin::isFullScreen()const
{
 if(viewFullscreen->isChecked())
  return true; 
 else 
  return false;
}

void OkleWin::toggleFullScreen()
{
 if(isFullScreen())
  setFullScreen(false);
 else
  setFullScreen(true);
}

void OkleWin::openDisc()
{
 conf->setGroup("Defaults");
 QString dvdp = conf->readEntry("DVDPath","/dev/dvd");

 openFile(dvdp);
}

void OkleWin::openFile(const QString& path)
{
 QString dvdp = path;
 if(dvdp.isEmpty())
  {
   dvdp = KFileDialog::getOpenFileName(QString::null,i18n("|All files"),this,i18n("Open File..."));
   if(dvdp.isEmpty())
    return;
  }

 QFileInfo fi(dvdp);
 if(!fi.exists())
  {
   KMessageBox::error(0,QString(i18n("%1 does not exist.\n\nEither set the correct DVD path in File -> Settings or create a symlink from your DVD device to %2.")).arg(dvdp).arg(dvdp),i18n("DVD device file not found"));
   return;
  }

 if(!fi.isFile() && !fi.isSymLink())
  {
   KMessageBox::error(0,QString(i18n("%1 exists but is not a file or symlink.\n\nMake sure that %2 really refers to your DVD device or change the DVD device path in File -> Settings.")).arg(dvdp).arg(dvdp),i18n("DVD device file not usable"));
   return;
  }

 if(!fi.isReadable())
  {
   KMessageBox::error(0,QString(i18n("%1 is not readable.\n\nCheck the file's permissions or change the DVD device path in File -> Settings.")).arg(dvdp),i18n("DVD device file not readable"));
   return;
  }
 
 initNav();
 initSniffer();

 DVDResult_t res = DVDSetDVDRoot(nav,const_cast<char*>(dvdp.latin1()));
 if(res != DVD_E_Ok)
  DVDPerror("DVDSetDVDRoot in openFile failed:",res);

 initOpen();
}

void OkleWin::initOpen()
{
 isinited = true; // for dcop state handling
 
 conf->setGroup("Defaults");
 int region = conf->readNumEntry("Region",1);
 if(region > 6)
  region=1;
 DVDPlayerRegionSelect(nav,region);

 DVDDefaultMenuLanguageSelect(nav,conf->readNumEntry("DefaultMenuLanguage",0x656e)); // default: "en"
 DVDDefaultAudioLanguageSelect(nav,conf->readNumEntry("DefaultAudioLanguage",0x656e)); // default: "en"
 DVDDefaultSubpictureLanguageSelect(nav,conf->readNumEntry("DefaultSubtitleLanguage",0x656e)); // default: "en"

 DVDParentalCountrySelect(nav,conf->readNumEntry("ParentalCountry",0x7573)); // default: "us"
 DVDParentalLevelSelect(nav,static_cast<DVDParentalLevel_t>(conf->readNumEntry("ParentalLevel",15))); // default: off

 unsigned char discid[16];
 if(DVDGetDiscID(nav,discid) != DVD_E_Ok)
  qWarning("DVDGetDiscID failed");
 if((bookmarks = DVDBookmarkOpen(discid,NULL,1)) == NULL)
  qWarning("DVDBookmarkOpen failed");

 DVDBookmarkSave(bookmarks,0);

 loadBookmarks();

 viewFullscreen->setEnabled(true);

 selectmenu->setEnabled(true);
 audioselect->setEnabled(true);
 subtitleselect->setEnabled(true);
 angleselect->setEnabled(true);
 
 updateAudioChannels();
 updateSubtitles();
 updateAngles();

 // get titles/chapters
 int nrt;
 DVDGetTitles(nav,&nrt);
 for(int i=1;i<=nrt;i++)
  {
   int nrp;
   DVDGetNumberOfPTTs(nav,i,&nrp);
   selChapter = new KActionMenu(QString(i18n("Title %1")).arg(QString::number(i)),actionCollection(),"go_goto_title_"+QString::number(i));
   connect(selChapter->popupMenu(),SIGNAL(activated(int)),this,SLOT(gotoChapter(int)));
   for(int j=0;j<nrp;j++)
    {
     selChapter->popupMenu()->insertItem(QString(i18n("Chapter %1")).arg(QString::number(j+1)));
     selChapter->popupMenu()->setId(j,j);
    }
   goGoto->insert(selChapter);
   goGoto->popupMenu()->setId(i-1,i-1);
  }

 // enable UI elements
 setPlayingState();

 setActiveWindow();

 QTimer* timer = new QTimer(this);
 connect(timer,SIGNAL(timeout()),this,SLOT(updatePosition()));
 timer->start(1000,false);
 
// does not work?? does not go to fullscreen?!
// if(viewFullscreen->isChecked()) // either autoplay fs. or was fs before closed last time
//  DVDSetZoomMode(nav,ZoomModeFullScreen);
 DVDLocation_t stoploc;
 DVDGetCurrentLocation(nav,&stoploc);
 stoptitle = stoploc.title;
 stopchapter = stoploc.ptt;
}

void OkleWin::closeDisc()
{
 KMessageBox::sorry(this,i18n("This feature is not implemented yet.\nYou must restart oKle to play another DVD!"));
// _notimpl();
// DVDCloseNav(nav);
}

void OkleWin::DVDInfo()
{
 DVDInfoWin* info = new DVDInfoWin(this);
 DVDVolumeInfo_t v;
 DVDGetDVDVolumeInfo(nav,&v);
 info->setNrOfVolumes(v.nrofvolumes);
 info->setVolume(v.volume);
 info->setSide(v.side);
 info->setNrOfTitles(v.nroftitles);
 if(info->exec())
  ;
}

void OkleWin::quit()
{
 close(true);
 KApplication::exit(0);
}

void OkleWin::_notimpl()
{
 KMessageBox::sorry(this,i18n("This feature is not implemented yet."));
}

void OkleWin::preferences()
{
 PrefsWin* prefs = new PrefsWin(this);
 
 conf->setGroup("Startup");
 prefs->setAutoPlay(conf->readBoolEntry("AutoPlay",false));
 prefs->setAutoFullScreen(conf->readBoolEntry("AutoFullScreen",false));
 prefs->setDisableScreenSaver(conf->readBoolEntry("DisableScreenSaver",true));
 prefs->setDisableDPMS(conf->readBoolEntry("DisableDPMS",true));
     
 conf->setGroup("Defaults");
 prefs->setDVDPath(conf->readEntry("DVDPath","/dev/dvd"));
 prefs->setRegion(conf->readNumEntry("Region",1));
 prefs->setDefaultAudio(Language::name(conf->readNumEntry("DefaultAudioLanguage",0x656e))); // default: "en"
 prefs->setDefaultSubtitle(Language::name(conf->readNumEntry("DefaultSubtitleLanguage",0x656e))); // default: "en"
 prefs->setDefaultMenuLanguage(Language::name(conf->readNumEntry("DefaultMenuLanguage",0x656e))); // default: "en"
 prefs->setParentalLevel(conf->readNumEntry("ParentalLevel",15));
 prefs->setParentalCountry(Country::name(conf->readNumEntry("ParentalCountry",0x7573))); //default: "us"

 /* TODO:
 conf->setGroup("Video");
 ...

 conf->setGroup("Audio");
 ...
 */
 
 if(prefs->exec())
  {
   conf->setGroup("Startup");
   conf->writeEntry("AutoPlay",prefs->autoPlay());
   conf->writeEntry("AutoFullScreen",prefs->autoFullScreen());
   conf->writeEntry("DisableScreenSaver",prefs->disableScreenSaver());
   conf->writeEntry("DisableDPMS",prefs->disableDPMS());
   
   conf->setGroup("Defaults");
   conf->writeEntry("DVDPath",prefs->DVDPath());
   conf->writeEntry("Region",prefs->region());
   conf->writeEntry("DefaultAudioLanguage",Language::id(prefs->defaultAudio()));
   conf->writeEntry("DefaultSubtitleLanguage",Language::id(prefs->defaultSubtitle()));
   conf->writeEntry("DefaultMenuLanguage",Language::id(prefs->defaultMenuLanguage()));
   conf->writeEntry("ParentalLevel",prefs->parentalLevel());
   conf->writeEntry("ParentalCountry",Country::id(prefs->parentalCountry()));
   
   /* TODO:
   conf->setGroup("Video");
   ...

   conf->setGroup("Audio");
   ...
   */
   
   conf->sync();
  }
}

void OkleWin::viewFullscreenActivated()
{
 if(!viewFullscreen->isChecked())
  setFullScreen(false);
 else
  setFullScreen(true);
}

void OkleWin::viewScreenshotActivated()
{
 pause();
 ScreenshotWin* ssw = new ScreenshotWin(this);
 ssw->setWithSPU(true);
 ssw->setFileName(QString(getenv("HOME"))+"/"+"shot.jpg");
 if(ssw->exec())
  takeScreenshot(ssw->fileName(),ssw->withSPU());
 unpause();
}

void OkleWin::takeScreenshot(const QString& fname,bool withspu)
{
 ScreenshotMode_t smode = ScreenshotModeWithSPU;
 if(!withspu)
  smode = ScreenshotModeWithoutSPU;
 DVDSaveScreenshot(nav,smode,const_cast<char*>(fname.latin1())); 
}

void OkleWin::unpause()
{
 if(ispaused)
  {
   ispaused = false;
   DVDPauseOff(nav);
  }
}

void OkleWin::rewind()
{
 if(!isinited)
  return;
  
 unpause();
  
 DVDBackwardScan(nav,4.0); 
}

void OkleWin::reverse()
{
 if(!isinited)
  return;
  
 unpause();
 
 DVDBackwardScan(nav,1.0);
}

void OkleWin::stop()
{
 if(!isinited)
  return;

 DVDPTTPlay(nav,stoptitle,stopchapter);
 DVDForwardScan(nav,8); // UGLY HACK (DVDStop() isn't implementend)
 DVDPauseOn(nav);
 slider->setValue(0);
 setStoppedState();
}

void OkleWin::play()
{
 if(!isinited)
  return;  // or openDisc(); ?
 if(isstopped)
  setPlayingState();
  
 unpause();
 
 DVDForwardScan(nav,1.0);
}

void OkleWin::fastForward()
{
 if(!isinited)
  return;

 unpause();
 
 DVDForwardScan(nav,4.0);
}

void OkleWin::previousChapter()
{
 if(!isinited)
  return;
 
 DVDPrevPGSearch(nav);
}

void OkleWin::stepReverse()
{
 if(!isinited)
  return;
 
 unpause();
 DVDTimeSkip(nav,-30);
}

void OkleWin::pause()
{
 if(!isinited)
  return;
 
 // toggle pause
 if(!ispaused)
  {
   DVDPauseOn(nav);
   ispaused = true;
  }
 else
  {
   DVDPauseOff(nav);
   ispaused = false;
  }
}

void OkleWin::stepForward()
{
 if(!isinited)
  return;
 
 unpause();
 DVDTimeSkip(nav,30);
}

void OkleWin::nextChapter()
{
 if(!isinited)
  return;
 
 DVDNextPGSearch(nav);
}

void OkleWin::fast()
{
 if(!isinited)
  return;
 
 unpause();
 
 if((speed >= 1.0) && (speed < 8.0)) 
  speed += 0.5;
 else if(speed < 1.0) 
  speed *= 2.0;
  
 DVDForwardScan(nav,speed);
}

void OkleWin::slow()
{
 if(!isinited)
  return;

 unpause();
 
 if(speed > 1.0) 
  speed -= 0.5;
 else if((speed > 0.1) && (speed <= 1.0)) 
  speed /= 2.0;
  
 DVDForwardScan(nav, speed);
}

void OkleWin::gotoTime()
{
 pause();

 GotoTimeWin* gototime = new GotoTimeWin(this);

 DVDLocation_t currloc;
 DVDGetCurrentLocation(nav,&currloc);
 DVDTimecode_t currtime = currloc.title_current;
 qDebug("current time: %d : %d : %d",currtime.Hours,currtime.Minutes,currtime.Seconds);
 gototime->setHour(currtime.Hours);
 gototime->setMinute(currtime.Minutes);
 gototime->setSecond(currtime.Seconds);  
 if(gototime->exec())
  {
   // calc pos 
   DVDTimecode_t time;
   time.Hours = gototime->hour();
   time.Minutes = gototime->minute();
   time.Seconds = gototime->second();
   qDebug("we want to %d : %d : %d",time.Hours,time.Minutes,time.Seconds);
   // seek backwards to beginning of title - there must be better way to do this?
//   DVDTimeSkip(nav,-(currtime.Hours*3600+currtime.Minutes*60+currtime.Seconds));
//   DVDTimeSkip(nav,-10000);
   DVDTitlePlay(nav,currloc.title);
   // now seek to calc position
   DVDTimeSkip(nav,time.Hours*3600+time.Minutes*60+time.Seconds); // somehow doesnt get called?!
  }
 unpause();
}

void OkleWin::up()
{
 if(!isinited)
  return;
 
 DVDUpperButtonSelect(nav);
}

void OkleWin::down()
{
 if(!isinited)
  return;
 
 DVDLowerButtonSelect(nav);
}

void OkleWin::left()
{
 if(!isinited)
  return;
 
 DVDLeftButtonSelect(nav);
}

void OkleWin::right()
{
 if(!isinited)
  return;
 
 DVDRightButtonSelect(nav);
}

void OkleWin::enter()
{
 if(!isinited)
  return;
 
 DVDButtonActivate(nav);
}

void OkleWin::goUp()
{
 if(!isinited)
  return;
 
 DVDGoUp(nav);
}

void OkleWin::resume()
{
 if(!isinited)
  return;
 
 DVDResume(nav);
}

void OkleWin::titleMenu()
{
 if(!isinited)
  return;
 
 DVDMenuCall(nav,DVD_MENU_Title);
}

void OkleWin::rootMenu()
{
 if(!isinited)
  return;
 
 DVDMenuCall(nav,DVD_MENU_Root);
}

void OkleWin::audioMenu()
{
 if(!isinited)
  return;

 DVDMenuCall(nav,DVD_MENU_Audio);
}

void OkleWin::angleMenu()
{
 if(!isinited)
  return;

 DVDMenuCall(nav,DVD_MENU_Angle);
}

void OkleWin::chapterMenu()
{
 if(!isinited)
  return;

 DVDMenuCall(nav,DVD_MENU_Part);
}

void OkleWin::subtitleMenu()
{
 if(!isinited)
  return;

 DVDMenuCall(nav,DVD_MENU_Subpicture);
}

void OkleWin::bookmarkAddBookmark()
{
 pause();
  
 int n = DVDBookmarkGetNr(bookmarks);
 
 KLineEditDlg* led = new KLineEditDlg(i18n("Description:"),QString(i18n("Bookmark %1")).arg(QString::number(n+1)),this);
 if(led->exec())
  addBookmark(led->text());
 
 unpause();
}

void OkleWin::addBookmark(const QString& uc)
{
 if(!isinited)
  return;
 
 char* state = NULL;
 char volid[33];
 int volid_type;
 char* disccomment = NULL;

 if(DVDGetVolumeIdentifiers(nav,0,&volid_type,volid,NULL) != DVD_E_Ok)
  {
   qWarning("DVDGetVolumeIdentifiers in addBookmark failed");
   volid_type = 0;
  }

 if(DVDGetState(nav,&state) == DVD_E_Ok)
  {
   if(DVDBookmarkAdd(bookmarks,state,uc.latin1(),NULL,NULL) == -1)
    qWarning("DVDBookmarkAdd in addBookmark failed");
   if(volid_type != 0)
    if(DVDBookmarkGetDiscComment(bookmarks,&disccomment) != -1)
     if((disccomment == NULL) || (disccomment[0] == '\0'))
      if(DVDBookmarkSetDiscComment(bookmarks,volid) == -1)
       qWarning("DVDSetDiscComment in addBookmark failed");
   if(DVDBookmarkSave(bookmarks,0) == -1)
    qWarning("DVDBookmarkSave in addBookmark failed");
  }
 loadBookmarks();
}

void OkleWin::editBookmarks()
{
 EditBookmarksWin* ebw = new EditBookmarksWin(this);
 if(ebw->exec())
  ;
}

void OkleWin::bookmarkRemoveActivated(int i)
{
 int ind = bookmarkRemove->popupMenu()->indexOf(i);
 removeBookmark(ind);
}

void OkleWin::removeBookmark(int i)
{
 if(!isinited)
  return;

 DVDBookmarkRemove(bookmarks,i);
 DVDBookmarkSave(bookmarks,0);

 loadBookmarks();
}

void OkleWin::removeAllBookmarks()
{
 if(!isinited)
  return;
  
 int nr = DVDBookmarkGetNr(bookmarks);
 for(int i=nr-1;i>=0;i--)
  DVDBookmarkRemove(bookmarks,i);

 DVDBookmarkSave(bookmarks,0);
   
 loadBookmarks();
}

void OkleWin::bookmarkActivated(int i)
{
 char* state=0;
 int ind = bookmarksMenu->popupMenu()->indexOf(i);
 if(ind<4)
  return;
 DVDBookmarkGet(bookmarks,ind-4,&state,NULL,NULL,NULL);
 DVDSetState(nav,state);
}

void OkleWin::gotoTitleHighlighted(int i)
{
 currtitle = i;
}

void OkleWin::gotoChapter(int i)
{
 if(!isinited)
  return;
 
 DVDPTTPlay(nav,currtitle+1,i+1);
}

void OkleWin::selectMenu(int i)
{
 if(!isinited)
  return;

 DVDMenuID_t menu = static_cast<DVDMenuID_t>(0);
 QString tmp = menus->text(i);
 if(tmp == i18n("Chapter Menu"))
  menu = DVD_MENU_Part;
 else if(tmp == i18n("Title Menu"))
  menu = DVD_MENU_Title;
 else if(tmp == i18n("Root Menu"))
  menu = DVD_MENU_Root;
 else if(tmp == i18n("Subtitle Menu"))
  menu = DVD_MENU_Subpicture;
 else if(tmp == i18n("Audio Menu"))
  menu = DVD_MENU_Audio;
 else if(tmp == i18n("Angle Menu"))
  menu = DVD_MENU_Angle;

 if(static_cast<int>(menu))
  DVDMenuCall(nav,menu);

 if(tmp == i18n("Resume"))
  DVDResume(nav);
}

void OkleWin::audioSelect(int item)
{
 if(!isinited)
  return;
 
 DVDAudioStream_t astream = item-2;
 if(item == 0) // None
  astream = static_cast<DVDAudioStream_t>(15);
 else if(item == 1) // Default
  {
   astream = 0; // fixme: should be the selected default
  }
 DVDAudioStreamChange(nav,astream);
}

void OkleWin::subTitleSelect(int item)
{
 if(!isinited)
  return;
 
 DVDSubpictureStream_t subp = item-2;
 if(item == 0) // None
  {
   DVDSetSubpictureState(nav,DVDFalse);
   return;
  }
 else if(item == 1) // Default
  {
   subp = 0; // fixme: should be the selected default
  }
 DVDSetSubpictureState(nav,DVDTrue);
 DVDSubpictureStreamChange(nav,subp);
}

void OkleWin::sliderPressed()
{
 sliderMoving = true;
 oldsliderval = slider->value();
}

void OkleWin::sliderReleased()
{
 if(!isinited)
  return;

 sliderMoving = false;
 int currpos = slider->value();

 int diff = currpos - oldsliderval;
 int direction = 1;
 if(diff < 0)
  {
   direction = -1;
   diff *= -1;
  }
 DVDTimeSkip(nav,direction*diff);
}

void OkleWin::volumeChanged(int v)
{
 setVolume(100-v);
}

void OkleWin::toggleMuteButton(bool b)
{
 if(b)
  mute();
 else
  unmute();
}

void OkleWin::mute()
{
 if(!isinited)
  return;
 
 mutebutton->setDown(true);
 mutebutton->setPixmap(locate("appdata","pics/mute.png"));
 volumeslider->setEnabled(false);
 Mixer::mute();
}

void OkleWin::unmute()
{
 if(!isinited)
  return;
 
 mutebutton->setDown(false);
 mutebutton->setPixmap(locate("appdata","pics/volume.png"));
 volumeslider->setEnabled(true);
 Mixer::unmute();
}

void OkleWin::toggleMute()
{
 if(!isinited)
  return;
 
 mutebutton->toggle();
}

bool OkleWin::isMuted()const
{
 return mutebutton->isDown();
}

void OkleWin::angleSelect(int item)
{
 if(!isinited)
  return;
 
 DVDAngle_t angle = 0;
 if(item > 0)
  angle = item-1;
 DVDAngleChange(nav,angle);
}

void OkleWin::keyPressEvent(QKeyEvent* e)
{
 switch(e->key())
  {
   case Key_Q:
    quit();
    break;
   case Key_Escape:
    if(isFullScreen())
     setFullScreen(false);
    break;
   case Key_F:
    if(isFullScreen())
     setFullScreen(false);
    else
     setFullScreen(true);
    break;
   case Key_Space:
    if(ispaused)
     unpause();
    else
     pause();
    break;
   case Key_Plus:
    setVolume(volume()+5);
    break;
   case Key_Minus:
    setVolume(volume()-5);
    break;
   case Key_Prior: // PgUp
    stepReverse();
    break;
   case Key_Next: // PgDown
    stepForward();
    break;
   case Key_Return:
   case Key_Enter:
    enter();
    break;
   case Key_Up:
    up();
    break;
   case Key_Down:
    down();
    break;
   case Key_Left:
    left();
    break;
   case Key_Right:
    right();
    break;
   case Key_Less:
    previousChapter();
    break;
   case Key_Greater:
    nextChapter();
    break;
   case Key_Comma:
    slow();
    break;
   case Key_Period:
    fast();
    break;
   case Key_T:
    titleMenu();
    break;
   case Key_R:
    rootMenu();
    break;
   case Key_A:
    if(e->state() == ShiftButton)
     angleMenu();
    else
     audioMenu();
    break;
   case Key_P:
    if(e->state() == ShiftButton)
     chapterMenu();
    else
     play();
    break;
   case Key_S:
    if(e->state() == ShiftButton)
     subtitleMenu();
    else
     {
      int foo;
      DVDSubpictureStream_t bar;
      DVDBool_t subenabled;
      DVDGetCurrentSubpicture(nav,&foo,&bar,&subenabled);
      if(subenabled == DVDTrue)
       subenabled = DVDFalse;
      else
       subenabled = DVDTrue;
      DVDSetSubpictureState(nav,subenabled);
     }
    break;
   case Key_X:
    stop();
    break;
   case Key_C:
    resume();
    break;
   case Key_U:
    goUp();
    break;
   case Key_Bar:
    pause();
    break;
   case Key_D: // for testing
    break;
   default:
    KMainWindow::keyPressEvent(e);
    break;
  }
}

void OkleWin::closeEvent(QCloseEvent* e)
{
 if(dcopclient)
  dcopclient->detach();
 if(nav)
  DVDCloseNav(nav);
 if(bookmarks)
  DVDBookmarkClose(bookmarks);
 saveConfig(conf);
 Mixer::close();
 restoreDPMS();
 restoreScreensaver();
 KMainWindow::closeEvent(e);
}

void OkleWin::updatePosition()
{
 int tit=0,chap=0;
 QString spos="00:00:00",slen="00:00:00";
 DVDTimecode_t tot;
 DVDTimecode_t curr;

 DVDUOP_t uop;
 DVDGetCurrentUOPS(nav,&uop);
 if(uop & UOP_FLAG_RootMenuCall)
  {
   DVDLocation_t loc;
   DVDGetCurrentLocation(nav,&loc);
   tot = loc.title_total;
   curr = loc.title_current;
   if(!timecode_eq(oldttime,tot) && !sliderMoving)
    slider->setMaxValue(tot.Hours*3600+tot.Minutes*60+tot.Seconds);
   if(!timecode_eq(oldctime,curr) && !sliderMoving)
    slider->setValue(curr.Hours*3600+curr.Minutes*60+curr.Seconds);
   tit = loc.title;
   chap = loc.ptt;
   spos = twonum(QString::number(curr.Hours,10))+":"+twonum(QString::number(curr.Minutes,10))+":"+twonum(QString::number(curr.Seconds,10));
   slen = twonum(QString::number(tot.Hours,10))+":"+twonum(QString::number(tot.Minutes,10))+":"+twonum(QString::number(tot.Seconds,10));
  }

 // only update on title/chapter change
 if((oldtitle != tit) || (oldchapter != chap))
  {
   infotitle->setText(i18n("Title:")+" "+QString::number(tit));
   infochapter->setText(i18n("Chapter:")+" "+QString::number(chap));
   updateSubtitles();
   updateAudioChannels();
   updateAngles();
  }

 infoctime->setText(spos);
 infottime->setText(slen);
 
 // update aud/sub/ang in info frame
 int astreamsavail=0;
 DVDAudioStream_t currastream;
 DVDGetCurrentAudio(nav,&astreamsavail,&currastream);
 DVDAudioAttributes_t audioattr;
 DVDGetAudioAttributes(nav,currastream,&audioattr);
 DVDBool_t b;
 DVDIsAudioStreamEnabled(nav,currastream,&b);
 QString alang = "-";
 if(b)
  {
   alang = Language::code(audioattr.Language);
   if(alang == "??")
    alang = "en";
  }
 infoaudio->setText(i18n("Audio:")+" "+alang);

 int streamsavail=0;
 DVDSubpictureStream_t currstream;
 DVDGetCurrentSubpicture(nav,&streamsavail,&currstream,&b);
 QString slang = "-";
 if(b)
  {
   DVDSubpictureAttributes_t subpicattr;
   DVDGetSubpictureAttributes(nav,currstream,&subpicattr);
   slang = Language::code(subpicattr.Language);
   if(slang == "??")
    slang = "en";
  }
 infosubtitle->setText(i18n("Subtitle:")+" "+slang);

 int anglesavail = 0;
 DVDAngle_t currangle;
 DVDGetCurrentAngle(nav,&anglesavail,&currangle);
 
 oldtitle = tit;
 oldchapter = chap;
 oldctime = curr;
 oldttime = tot;
}

bool OkleWin::timecode_eq(DVDTimecode_t t1,DVDTimecode_t t2)
{
 if(t1.Seconds != t2.Seconds)
  return false;
 if(t1.Minutes != t2.Minutes)
  return false;
 if(t1.Hours != t2.Hours)
  return false;
 return true;
}

void OkleWin::updateSubtitles()
{
 int streamsavail = 0;
 DVDSubpictureStream_t currstream;
 DVDBool_t b;
 DVDGetCurrentSubpicture(nav,&streamsavail,&currstream,&b);
 subtitleChannels->clear();
 subtitleChannels->insertItem(i18n("None"),0);
 subtitleChannels->insertItem(i18n("Default"),1);
 for(int i=0;i<streamsavail;i++)
  {
   DVDSubpictureAttributes_t attr;
   DVDGetSubpictureAttributes(nav,i,&attr);
   QString n = Language::name(attr.Language);
   if(n != i18n("Unknown")) // don't insert unknown languages
    subtitleChannels->insertItem(Language::name(attr.Language),i+2);
  }
}

void OkleWin::updateAudioChannels()
{
 int astreamsavail = 0;
 DVDAudioStream_t currastream;
 DVDGetCurrentAudio(nav,&astreamsavail,&currastream);
 audioChannels->clear();
 audioChannels->insertItem(i18n("None"),0);
 audioChannels->insertItem(i18n("Default"),1);
 for(int i=0;i<astreamsavail;i++)
  {
   DVDAudioAttributes_t attr;
   DVDGetAudioAttributes(nav,i,&attr);
   audioChannels->insertItem(Language::name(attr.Language),i+2);
  }
}

void OkleWin::updateAngles()
{
 int anglesavail = 0;
 DVDAngle_t currangle;
 DVDGetCurrentAngle(nav,&anglesavail,&currangle);
 angles->clear();
 angles->insertItem(i18n("Default"),0);
 for(int i=0;i<anglesavail;i++)
  {
   angles->insertItem(QString::number(i),i+1);
  }
}

QString OkleWin::twonum(const QString& s)
{
 if(s.length() == 1)
  return "0"+s;
 else
  return s;
}

void OkleWin::disableDPMS()
{
 int dummy;
 Display* dpy = qt_xdisplay();
 bool dpmsext = DPMSQueryExtension(dpy,&dummy,&dummy);
 if(!dpmsext)
  qWarning("X Server has no DPMS extension");
 else
  {
   unsigned short dummy2;
   BOOL h;
   DPMSInfo(dpy,&dummy2,&h);
   hasDPMS = h;
   DPMSGetTimeouts(dpy,&dpms_standby,&dpms_suspend,&dpms_off);
   DPMSDisable(dpy);
  }
}

void OkleWin::restoreDPMS()
{
 if(hasDPMS)
  {
   Display* dpy = qt_xdisplay();
   DPMSEnable(dpy);
   DPMSSetTimeouts(dpy,dpms_standby,dpms_suspend,dpms_off);
  }
}

void OkleWin::disableScreensaver()
{
 QByteArray qdata, qreplyData;
 QCString qreplyType;
 QDataStream qarg(qdata, IO_WriteOnly);
 if(!dcopclient->call("kdesktop","KScreensaverIface","isEnabled()",qdata,qreplyType,qreplyData))
  qWarning("There was some error using DCOP: kdesktop KScreensaverIface->isEnabled() failed.");
 else
  {
   QDataStream reply(qreplyData, IO_ReadOnly);
   if(qreplyType == "bool")
    reply >> hasScreensaver;
   else
    qWarning("disableScreensaver returned an unexpected type of reply!");
  }

 if(hasScreensaver)
  {
   QByteArray data;
   QDataStream arg(data, IO_WriteOnly);
   arg << false;
   if(!dcopclient->send("kdesktop","KScreensaverIface","enable(bool)",data))
    qWarning("There was some error using DCOP: kdesktop KScreensaverIface enable(bool) failed.");
  }
}

void OkleWin::restoreScreensaver()
{
 if(hasScreensaver)
  {
   QByteArray data;
   QDataStream arg(data, IO_WriteOnly);
   arg << true;
   if(!dcopclient->send("kdesktop","KScreensaverIface","enable(bool)",data))
    qWarning("There was some error in DCOP communication.");
  }
}

void OkleWin::loadBookmarks()
{
 int n;
 char* appinfo = 0;
 char* state = 0;
 char* usercomm = 0;
 
 bookmarksMenu->popupMenu()->clear();
 bookmarkRemove->popupMenu()->clear();

 bookmarksMenu->insert(bookmarkAdd);
 bookmarksMenu->insert(bookmarkRemove);
 bookmarksMenu->insert(bookmarkRemoveAll);
 bookmarksMenu->insert(new KActionSeparator());

 n = DVDBookmarkGetNr(bookmarks);
 
 for(int i=0;i<n;i++)
  {
   DVDBookmarkGet(bookmarks,i,NULL,&usercomm,"common",&appinfo);
   QString uc = QString(usercomm);
   if(uc.isEmpty())
    uc = QString(i18n("Bookmark %1")).arg(QString::number(i+1));
   bookmarksMenu->popupMenu()->insertItem(uc);
   bookmarkRemove->popupMenu()->insertItem(uc);
   free(appinfo);
   free(usercomm);
   free(state);
  }
}

void OkleWin::setVolume(int v)
{
 if((v < 0) || (v > 100)) // dont give mixer bad values
  return;
 Mixer::setVolume(v);
}

int OkleWin::volume()
{
 return Mixer::volume();
}

void OkleWin::keyPressed(int ks)
{
 Qt::Key k = static_cast<Qt::Key>(0);
 Qt::ButtonState mod = Qt::NoButton;
 switch(ks)
  {
   // Map X11 keysyms to Qt::Key
   // ARGL ARGL ARGL ARGL
   case XK_a: k = Key_A; break;
   case XK_b: k = Key_B; break;
   case XK_c: k = Key_C; break;
   case XK_d: k = Key_D; break;
   case XK_e: k = Key_E; break;
   case XK_f: k = Key_F; break;
   case XK_g: k = Key_G; break;
   case XK_h: k = Key_H; break;
   case XK_i: k = Key_I; break;
   case XK_j: k = Key_J; break;
   case XK_k: k = Key_K; break;
   case XK_l: k = Key_L; break;
   case XK_m: k = Key_M; break;
   case XK_n: k = Key_N; break;
   case XK_o: k = Key_O; break;
   case XK_p: k = Key_P; break;
   case XK_q: k = Key_Q; break;
   case XK_r: k = Key_R; break;
   case XK_s: k = Key_S; break;
   case XK_t: k = Key_T; break;
   case XK_u: k = Key_U; break;
   case XK_v: k = Key_V; break;
   case XK_w: k = Key_W; break;
   case XK_x: k = Key_X; break;
   case XK_y: k = Key_Y; break;
   case XK_z: k = Key_Z; break;
   case XK_A: k = Key_A; mod = Qt::ShiftButton; break;
   case XK_B: k = Key_B; mod = Qt::ShiftButton; break;
   case XK_C: k = Key_C; mod = Qt::ShiftButton; break;
   case XK_D: k = Key_D; mod = Qt::ShiftButton; break;
   case XK_E: k = Key_E; mod = Qt::ShiftButton; break;
   case XK_F: k = Key_F; mod = Qt::ShiftButton; break;
   case XK_G: k = Key_G; mod = Qt::ShiftButton; break;
   case XK_H: k = Key_H; mod = Qt::ShiftButton; break;
   case XK_I: k = Key_I; mod = Qt::ShiftButton; break;
   case XK_J: k = Key_J; mod = Qt::ShiftButton; break;
   case XK_K: k = Key_K; mod = Qt::ShiftButton; break;
   case XK_L: k = Key_L; mod = Qt::ShiftButton; break;
   case XK_M: k = Key_M; mod = Qt::ShiftButton; break;
   case XK_N: k = Key_N; mod = Qt::ShiftButton; break;
   case XK_O: k = Key_O; mod = Qt::ShiftButton; break;
   case XK_P: k = Key_P; mod = Qt::ShiftButton; break;
   case XK_Q: k = Key_Q; mod = Qt::ShiftButton; break;
   case XK_R: k = Key_R; mod = Qt::ShiftButton; break;
   case XK_S: k = Key_S; mod = Qt::ShiftButton; break;
   case XK_T: k = Key_T; mod = Qt::ShiftButton; break;
   case XK_U: k = Key_U; mod = Qt::ShiftButton; break;
   case XK_V: k = Key_V; mod = Qt::ShiftButton; break;
   case XK_W: k = Key_W; mod = Qt::ShiftButton; break;
   case XK_X: k = Key_X; mod = Qt::ShiftButton; break;
   case XK_Y: k = Key_Y; mod = Qt::ShiftButton; break;
   case XK_Z: k = Key_Z; mod = Qt::ShiftButton; break;
   case XK_BackSpace: k = Key_Backspace; break;
   case XK_Return: k = Key_Return; break;
   case XK_Pause: k = Key_Pause; break;
   case XK_Escape: k = Key_Escape; break;
   case XK_Delete: k = Key_Delete; break;
   case XK_Home: k = Key_Home; break;
   case XK_Left: k = Key_Left; break;
   case XK_Up: k = Key_Up; break;
   case XK_Right: k = Key_Right; break;
   case XK_Down: k = Key_Down; break;
   case XK_Prior: k = Key_Prior; break;
   case XK_Next: k = Key_Next; break;
   case XK_End: k = Key_End; break;
   case XK_Begin: k = Key_Home; break;
   case XK_F1: k = Key_F1; break;
   case XK_F2: k = Key_F2; break;
   case XK_F3: k = Key_F3; break;
   case XK_F4: k = Key_F4; break;
   case XK_F5: k = Key_F5; break;
   case XK_F6: k = Key_F6; break;
   case XK_F7: k = Key_F7; break;
   case XK_F8: k = Key_F8; break;
   case XK_F9: k = Key_F9; break;
   case XK_F10: k = Key_F10; break;
   case XK_F11: k = Key_F11; break;
   case XK_F12: k = Key_F12; break;
   case XK_Shift_L: k = Key_Shift; break;
   case XK_Shift_R: k = Key_Shift; break;
   case XK_space: k = Key_Space; break;
   case XK_numbersign: k = Key_NumberSign; break;
   case XK_dollar: k = Key_Dollar; break;
   case XK_percent: k = Key_Percent; break;
   case XK_parenleft: k = Key_ParenLeft; break;
   case XK_parenright: k = Key_ParenRight; break;
   case XK_asterisk: k = Key_Asterisk; break;
   case XK_plus: k = Key_Plus; break;
   case XK_comma: k = Key_Comma; break;
   case XK_minus: k = Key_Minus; break;
   case XK_period: k = Key_Period; break;
   case XK_slash: k = Key_Slash; break;
   case XK_0: k = Key_0; break;
   case XK_1: k = Key_1; break;
   case XK_2: k = Key_2; break;
   case XK_3: k = Key_3; break;
   case XK_4: k = Key_4; break;
   case XK_5: k = Key_5; break;
   case XK_6: k = Key_6; break;
   case XK_7: k = Key_7; break;
   case XK_8: k = Key_8; break;
   case XK_9: k = Key_9; break;
   case XK_colon: k = Key_Colon; break;
   case XK_semicolon: k = Key_Semicolon; break;
   case XK_less: k = Key_Less; break;
   case XK_equal: k = Key_Equal; break;
   case XK_greater: k = Key_Greater; break;
   case XK_question: k = Key_Question; break;
   case XK_at: k = Key_At; break;
   case XK_bar: k = Key_Bar; break;
   case XK_underscore: k = Key_Underscore; break;
   default: qDebug("unhandled keysym: %d!!!",ks); break;
  }
 
 QApplication::sendEvent(this,new QKeyEvent(static_cast<QEvent::Type>(6),k,0,mod)); // HACK lets see if it works
}

#include "okle_win.moc"
