#include "prefs_win.h"
#include "language.h"
#include "country.h"

#include <klocale.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qcombobox.h>

PrefsWin::PrefsWin(QWidget* parent) : KDialogBase(KDialogBase::Tabbed,i18n("Preferences"),Ok|Cancel|Default,Ok,parent)
{
 initPage1();
 initPage2();
// initPage3();
// initPage4();
}

void PrefsWin::initPage1()
{
 page1 = addPage(i18n("Startup"));

 QVBoxLayout* layout = new QVBoxLayout(page1,0,marginHint());

 _autoplay = new QCheckBox(i18n("Auto play DVD"),page1);
 layout->addWidget(_autoplay);
 
 _autofullscreen = new QCheckBox(i18n("Auto play fullscreen"),page1);
 _autofullscreen->setEnabled(false); // temp
 layout->addWidget(_autofullscreen); // temp
 _autofullscreen->hide();

 _disablescreensaver = new QCheckBox(i18n("Disable screen saver"),page1);
 layout->addWidget(_disablescreensaver);

 _disabledpms = new QCheckBox(i18n("Disable DPMS"),page1);
 layout->addWidget(_disabledpms);

 layout->activate();
}

void PrefsWin::initPage2()
{
 page2 = addPage(i18n("Defaults"));

 QVBoxLayout* layout = new QVBoxLayout(page2,0,marginHint());

 QGridLayout* grid = new QGridLayout(layout,6,2,5);

 QLabel* label = new QLabel(i18n("DVD Device:"),page2);
 grid->addWidget(label,0,0,AlignLeft);

 _dvdp = new QLineEdit(page2);
 _dvdp->setText("");
 grid->addWidget(_dvdp,0,1);

 QLabel* prlabel = new QLabel(i18n("Player Region:"),page2);
 grid->addWidget(prlabel,1,0,AlignLeft);

 _region = new QComboBox(page2);
 for(uint i=0;i<=6;i++)
  _region->insertItem(QString(i18n("Region %1")).arg(i),i);
 grid->addWidget(_region,1,1);

 QLabel* pall = new QLabel(i18n("Parental Level:"),page2);
 grid->addWidget(pall,2,0);

 _parentallevel = new QComboBox(page2);
 for(uint i=0;i<=7;i++)
  _parentallevel->insertItem(QString(i18n("Level %1")).arg(i+1),i);
 _parentallevel->insertItem(i18n("None"),8);
 grid->addWidget(_parentallevel,2,1);
 
 QLabel* pcl = new QLabel(i18n("Parental Country:"),page2);
 grid->addWidget(pcl,3,0);

 _parentalcountry = new QComboBox(page2);
 _parentalcountry->insertStringList(Country::allNames());
 grid->addWidget(_parentalcountry,3,1);
 
 QLabel* defal = new QLabel(i18n("Default Audio Language:"),page2);
 grid->addWidget(defal,4,0);

 _defaudio = new QComboBox(page2);
 _defaudio->insertStringList(Language::allNames());
 grid->addWidget(_defaudio,4,1);
 
 QLabel* defsu = new QLabel(i18n("Default Subtitle Language:"),page2);
 grid->addWidget(defsu,5,0);

 _defsub = new QComboBox(page2);
 _defsub->insertStringList(Language::allNames());
 grid->addWidget(_defsub,5,1);
 
 QLabel* defml = new QLabel(i18n("Default Menu Language:"),page2);
 grid->addWidget(defml,6,0);

 _defmenulang = new QComboBox(page2);
 _defmenulang->insertStringList(Language::allNames());
 grid->addWidget(_defmenulang,6,1);
 
 layout->activate();
}

void PrefsWin::initPage3()
{
 page3 = addPage(QString("Video"));

 QVBoxLayout* layout = new QVBoxLayout(page3,0,marginHint());

 layout->activate();
}

void PrefsWin::initPage4()
{
 page4 = addPage(QString("Audio"));

 QVBoxLayout* layout = new QVBoxLayout(page4,0,marginHint());

 layout->activate();
}

PrefsWin::~PrefsWin()
{}

void PrefsWin::setAutoPlay(bool a)
{
 _autoplay->setChecked(a);
}

bool PrefsWin::autoPlay()const
{
 return _autoplay->isChecked();
}

void PrefsWin::setAutoFullScreen(bool a)
{
 _autofullscreen->setChecked(false); // temp
}

bool PrefsWin::autoFullScreen()const
{
// return _autofullscreen->isChecked();
 return false; // temp
}

void PrefsWin::setDisableScreenSaver(bool b)
{
 _disablescreensaver->setChecked(b);
}

bool PrefsWin::disableScreenSaver()const
{
 return _disablescreensaver->isChecked();
}

void PrefsWin::setDisableDPMS(bool b)
{
 _disabledpms->setChecked(b);
}

bool PrefsWin::disableDPMS()const
{
 return _disabledpms->isChecked();
}

void PrefsWin::setDVDPath(const QString& d)
{
 _dvdp->setText(d);
}

QString PrefsWin::DVDPath()const
{
 return _dvdp->text();
}

void PrefsWin::setRegion(int r)
{
 _region->setCurrentItem(r);
}

int PrefsWin::region()const
{
 return _region->currentItem();
}

void PrefsWin::setDefaultAudio(const QString& s)
{
 _defaudio->setCurrentText(s);
}

QString PrefsWin::defaultAudio()const
{
 return _defaudio->currentText();
}

void PrefsWin::setDefaultSubtitle(const QString& s)
{
 _defsub->setCurrentText(s);
}

QString PrefsWin::defaultSubtitle()const
{
 return _defsub->currentText();
}

void PrefsWin::setDefaultMenuLanguage(const QString& s)
{
 _defmenulang->setCurrentText(s);
}

QString PrefsWin::defaultMenuLanguage()const
{
 return _defmenulang->currentText();
}

void PrefsWin::setParentalLevel(int i)
{
 if(i == 15)
  _parentallevel->setCurrentItem(8);
 else
  _parentallevel->setCurrentItem(i+1);
}

int PrefsWin::parentalLevel()const
{
 int i = _parentallevel->currentItem();
 if(i == 8)
  return 15;
 else
  return i+1;
}

void PrefsWin::setParentalCountry(const QString& pc)
{
 _parentalcountry->setCurrentText(pc);
}

QString PrefsWin::parentalCountry()const
{
 return _parentalcountry->currentText();
}

void PrefsWin::slotDefault()
{
 _autoplay->setChecked(false);
 _autofullscreen->setChecked(false);
 _disablescreensaver->setChecked(true);
 _disabledpms->setChecked(true);
 _dvdp->setText("/dev/dvd");
 _region->setCurrentItem(1);
 _defaudio->setCurrentText(i18n("English"));
 _defsub->setCurrentText(i18n("English"));
 _defmenulang->setCurrentText(i18n("English"));
 _parentalcountry->setCurrentText(i18n("United States (USA)"));
 _parentallevel->setCurrentText(i18n("None"));
}

#include "prefs_win.moc"
