/***

  Olive - Non-Linear Video Editor
  Copyright (C) 2022 Olive Team

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

***/

#ifndef TIMEBASEDPANEL_H
#define TIMEBASEDPANEL_H

#include "widget/panel/panel.h"
#include "widget/timebased/timebasedwidget.h"

namespace olive {

class TimeBasedPanel : public PanelWidget
{
  Q_OBJECT
public:
  TimeBasedPanel(const QString& object_name, QWidget *parent = nullptr);

  void ConnectViewerNode(ViewerOutput *node);

  void DisconnectViewerNode()
  {
    ConnectViewerNode(nullptr);
  }

  rational GetTime();

  // Get the timebase of this panels widget
  const rational& timebase();

  ViewerOutput *GetConnectedViewer() const
  {
    return widget_->GetConnectedNode();
  }

  TimeRuler* ruler() const
  {
    return widget_->ruler();
  }

  virtual void ZoomIn() override;

  virtual void ZoomOut() override;

  virtual void GoToStart() override;

  virtual void PrevFrame() override;

  virtual void NextFrame() override;

  virtual void GoToEnd() override;

  virtual void GoToPrevCut() override;

  virtual void GoToNextCut() override;

  virtual void PlayPause() override;

  virtual void PlayInToOut() override;

  virtual void ShuttleLeft() override;

  virtual void ShuttleStop() override;

  virtual void ShuttleRight() override;

  virtual void SetIn() override;

  virtual void SetOut() override;

  virtual void ResetIn() override;

  virtual void ResetOut() override;

  virtual void ClearInOut() override;

  virtual void SetMarker() override;

  virtual void ToggleShowAll() override;

  virtual void GoToIn() override;

  virtual void GoToOut() override;

  virtual void DeleteSelected() override;

  virtual void CutSelected() override;

  virtual void CopySelected() override;

  virtual void Paste() override;

public slots:
  void SetTimebase(const rational& timebase);

  void SetTime(const rational &time);

signals:
  void TimeChanged(const rational& time);

  void TimebaseChanged(const rational& timebase);

  void PlayPauseRequested();

  void PlayInToOutRequested();

  void ShuttleLeftRequested();

  void ShuttleStopRequested();

  void ShuttleRightRequested();

protected:
  TimeBasedWidget* GetTimeBasedWidget() const
  {
    return widget_;
  }

  void SetTimeBasedWidget(TimeBasedWidget* widget);

  virtual void Retranslate() override;

  void SetShowAndRaiseOnConnect()
  {
    show_and_raise_on_connect_ = true;
  }

private:
  TimeBasedWidget* widget_;

  bool show_and_raise_on_connect_;

private slots:
  void ConnectedNodeChanged(ViewerOutput* old, ViewerOutput* now);

};

}

#endif // TIMEBASEDPANEL_H
