/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef CLIENTHOOKS_H
#define CLIENTHOOKS_H

#include <string>

using std::string;

namespace LibOmClient {

class PatchModel;
class NodeModel;
class ConnectionModel;
class PortModel;
class MetadataModel;
class ControlModel;
class PluginModel;


/** Hooks into the client for the Comm class.
 *
 * This is used by the Comm class to call functions in the client
 * when the server sends something that requires client
 * notification.  Each client needs to implement this class.
 *
 * \ingroup libomclient
 */
class ClientHooks
{
public:
	virtual ~ClientHooks() {};
	
	virtual void error(const string& msg) = 0;
	virtual void engine_enabled() = 0;
	virtual void engine_disabled() = 0;
	virtual void new_patch(PatchModel* pm) = 0;
	virtual void new_port(PortModel* port_info) = 0;
	virtual void port_removal(const string& path) = 0;
	virtual void patch_destruction(const string& path) = 0;
	virtual void patch_enabled(const string& path) = 0;
	virtual void patch_disabled(const string& path) = 0;
	virtual void new_node(NodeModel* nm) = 0;
	virtual void node_removal(const string& path) = 0;
	virtual void object_renamed(const string& old_path, const string& new_path) = 0;
	virtual void connection(ConnectionModel* cm) = 0;
	virtual void disconnection(const string& src_port_path, const string& dst_port_path) = 0;
	virtual void metadata_update(MetadataModel* mm) = 0;
	virtual void control_change(ControlModel* cm) = 0;
	virtual void new_plugin(PluginModel* pi) = 0;
};


} // namespace LibOmClient

#endif // CLIENTHOOKS_H
