/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "GladeFactory.h"
#include <iostream>
#include <fstream>
using std::cout; using std::cerr; using std::endl;
using std::ifstream;

namespace OmGtk {

	
GladeFactory::GladeFactory()
{
	// Check for the .glade file in current directory
	m_glade_filename = "./om_gtk.glade";
	ifstream fs(m_glade_filename.c_str());
	if (fs.fail()) { // didn't find it, check PKGDATADIR
		fs.clear();
		m_glade_filename = PKGDATADIR;
		m_glade_filename += "/om_gtk.glade";
	
		fs.open(m_glade_filename.c_str());
		if (fs.fail()) {
			cerr << "Unable to find om_gtk.glade in current directory or " << PKGDATADIR << "." << endl;
			throw;
		}
		fs.close();
	}
}


Glib::RefPtr<Gnome::Glade::Xml>
GladeFactory::new_glade_reference(const string& toplevel_widget)
{
	try {
		if (toplevel_widget == "")
			return Gnome::Glade::Xml::create(m_glade_filename);
		else
			return Gnome::Glade::Xml::create(m_glade_filename, toplevel_widget.c_str());
	} catch(const Gnome::Glade::XmlError& ex) {
		cerr << ex.what() << endl;
		throw ex;
	}
}


} // namespace OmGtk
