/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef GLADEFACTORY_H
#define GLADEFACTORY_H

#include <string>
#include <libglademm/xml.h>

using std::string;

namespace OmGtk {


/** Creates glade references, so various objects can create widgets.
 *
 * This used to be in OmGtkApp, but moving it here reduced dependency on
 * OmGtkApp.h (reducing compile times).
 */
class GladeFactory {
public:
	GladeFactory();

	Glib::RefPtr<Gnome::Glade::Xml> new_glade_reference(const string& toplevel_widget = "");

private:
	Glib::ustring m_glade_filename;
};


} // namespace OmGtk

#endif // GLADEFACTORY_H
