/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License alongCont
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "NodeControlWindow.h"
#include "GladeFactory.h"
#include "OmGtk.h"
#include "PatchController.h"
#include "Controller.h"
#include "NodeModel.h"
#include "PortModel.h"
#include "ControlGroups.h"
#include <iostream>
#include <cmath>
using std::cerr; using std::cout; using std::endl;

namespace OmGtk {


NodeControlWindow::NodeControlWindow(PatchController* patch_controller, NodeModel* node_model)
{
	m_patch_controller = patch_controller;
	m_node_model = node_model;
	
	property_resizable() = true;
	property_window_position() = Gtk::WIN_POS_CENTER_ON_PARENT;
	set_border_width(5);

	Glib::ustring title = "Om - ";
	title += m_node_model->name();
	property_title() = title;

	Glib::RefPtr<Gnome::Glade::Xml> xml = glade_factory->new_glade_reference("warehouse_win");
	xml->get_widget_derived("control_panel_vbox", m_control_panel);
	m_control_panel->reparent(*this);
	m_control_panel->init(patch_controller, node_model, node_model->polyphonic());
	
	resize();

	m_callback_enabled = true;

	show_all_children();
}


NodeControlWindow::~NodeControlWindow()
{
	delete m_control_panel;
}


void
NodeControlWindow::resize()
{
	pair<int,int> controls_size = m_control_panel->ideal_size();
	int width = 400;
	int height = controls_size.second + 40;

	if (height > property_screen().get_value()->get_height() - 64)
		height = property_screen().get_value()->get_height() - 64;
	if (width > property_screen().get_value()->get_width() - 64)
		width = property_screen().get_value()->get_width() - 64;

	Gtk::Window::resize(width, height);
}

} // namespace OmGtk
