/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "OmPatchBayArea.h"
#include <cassert>
#include "canvas/PatchBayArea.h"
#include "OmGtk.h"
#include "Controller.h"
#include "PatchController.h"
#include "PatchWindow.h"
#include "LoadPluginWindow.h"
#include "LoadSubpatchWindow.h"
#include "NewSubpatchWindow.h"
#include "OmPort.h"

namespace OmGtk {


OmPatchBayArea::OmPatchBayArea(PatchController* controller, const string& patch_path, int width, int height)
: PatchBayArea(width, height),
  m_patch_controller(controller),
  m_patch_path(patch_path),
  m_last_click_x(0),
  m_last_click_y(0)
{
	assert(controller != NULL);
	
	m_base_rect.signal_event().connect(sigc::mem_fun(this, &OmPatchBayArea::canvas_event));
	
	m_patch_name = patch_path.substr(patch_path.find_last_of("/")+1);
	
	Gtk::Menu::MenuList& items = m_menu.items();
	items.push_back(Gtk::Menu_Helpers::MenuElem("Load Plugin...",
		sigc::mem_fun(this, &OmPatchBayArea::menu_load_plugin)));
	items.push_back(Gtk::Menu_Helpers::MenuElem("Load Subpatch...",
		sigc::mem_fun(this, &OmPatchBayArea::menu_load_subpatch)));
	items.push_back(Gtk::Menu_Helpers::MenuElem("Create Subpatch...",
		sigc::mem_fun(this, &OmPatchBayArea::menu_create_subpatch)));
}


void
OmPatchBayArea::connect(const Port* const port1, const Port* const port2)
{
	assert(port1 != NULL);
	assert(port2 != NULL);
	
	controller->connect(((OmPort*)port1)->port_model()->path(),
	                    ((OmPort*)port2)->port_model()->path());
}


void
OmPatchBayArea::disconnect(const Port* const port1, const Port* const port2)
{
	assert(port1 != NULL);
	assert(port2 != NULL);
	
	controller->disconnect(((OmPort*)port1)->port_model()->path(),
	                    ((OmPort*)port2)->port_model()->path());
}


bool
OmPatchBayArea::canvas_event(GdkEvent* event)
{
	assert(event != NULL);
	
	switch (event->type) {

	case GDK_BUTTON_PRESS:
		if (event->button.button == 3) {
			m_last_click_x = (int)event->button.x;
			m_last_click_y = (int)event->button.y;
			show_menu(event);
		}

	default:
		break;
	}

	return true;
}


void
OmPatchBayArea::menu_load_plugin()
{
	m_patch_controller->window()->load_plugin_window()->set_next_module_location(
		m_last_click_x, m_last_click_y);
	m_patch_controller->window()->load_plugin_window()->show();
}


void
OmPatchBayArea::menu_load_subpatch()
{
	m_patch_controller->window()->load_subpatch_window()->set_next_module_location(
		m_last_click_x, m_last_click_y);
	m_patch_controller->window()->load_subpatch_window()->show();
}


void
OmPatchBayArea::menu_create_subpatch()
{
	m_patch_controller->window()->new_subpatch_window()->set_next_module_location(
		m_last_click_x, m_last_click_y);
	m_patch_controller->window()->new_subpatch_window()->show();
}


} // namespace OmGtk
