/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "ObjectStore.h"
#include "Om.h"
#include "Patch.h"
#include "Node.h"
#include "Port.h"
#include "List.h"
#include "OmPath.h"

namespace Om {


/** Find the Patch at the given path.
 */
Patch* const
ObjectStore::find_patch(const string& path) 
{
	for (List<Patch*>::iterator i = om->patches().begin(); i != om->patches().end(); ++i)
		if ((*i)->path() == path)
			return (*i);
	
	return NULL;
}


/** Find the Node at the given path.
 */
Node* const
ObjectStore::find_node(const string& path) 
{
	Patch* parent = find_patch(OmPath::parent(path));
	Node* node = NULL;
	
	if (parent != NULL) {
		parent->node_remove_mutex().soft_lock();
		node = parent->nodes().find(OmPath::name(path));
		parent->node_remove_mutex().soft_unlock();
	}
		
	return node;
}


/** Find the Port at the given path.
 */
Port* const
ObjectStore::find_port(const string& path) 
{
	Node* node = find_node(OmPath::parent(path));
	
	if (node != NULL) {
		return node->port(OmPath::name(path));
	} else {
		// maybe a port on a patch
		Patch* patch = find_patch(OmPath::parent(path));
		if (patch != NULL)
			return patch->port(OmPath::name(path));
	}
	
	return NULL;
}


/** Find the Object at the given path.
 */
OmObject* const
ObjectStore::find_object(const string& path)
{
	// FIXME: this is implemented in the worst possible way
	OmObject* obj = NULL;
	obj = find_patch(path);
	if (obj == NULL)
		obj = find_node(path);
	if (obj == NULL)
		obj = find_port(path);

	return obj;
}


} // namespace Om
