/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <iostream>
#include <signal.h>
#include "config.h"
#include "util.h"
#include "cmdline.h"
#include "Om.h"
#include "OmApp.h"
#include "OSCReceiver.h"
#ifdef HAVE_LASH
#include "LashDriver.h"
#endif

using std::cout; using std::endl; using std::cerr;


void
catch_int(int)
{
	signal(SIGINT, catch_int);
	signal(SIGTERM, catch_int);

	std::cout << "[Main] Om interrupted." << std::endl;
	Om::om->quit();
}


int
main(int argc, char** argv)
{
	const char* port = NULL;

#ifdef HAVE_LASH
	lash_args_t* lash_args = lash_extract_args(&argc, &argv);
#endif // HAVE_LASH

	/* Parse command line options */
	gengetopt_args_info args_info;
	if (cmdline_parser (argc, argv, &args_info) != 0)
		return 1;

	/*if (!args_info.port_given) {
		cout << "You must specify a port.  Try 'om --help'." << endl;
		return 1;
	}*/
	
	port = args_info.port_arg;
	
	/* End command line parsing */

	signal(SIGINT, catch_int);
	signal(SIGTERM, catch_int);

	// It seems like this is enough, it doesn't need to be called in the Jack thread.
	// I guess that means these flags are being restored on the context switch into
	// Om when Jack calls the process callback.
	Om::set_denormal_flags();

	Om::om = new Om::OmApp(port);

#ifdef HAVE_LASH
	Om::lash_driver = new Om::LashDriver(Om::om, lash_args);
#endif

	// These need to be activated after OmApp is initialized, or incoming
	// OSC events could cause control events to exist when Om::om is still
	// NULL, causing a NULL dereference (segfault)
	Om::om->osc_receiver()->activate();

	Om::om->main();

#ifdef HAVE_LASH
	delete Om::lash_driver;
#endif
	delete Om::om;
	
	return 0;
}

