# dir.mms for omniORB.

# Note that the groupings here are physical (to avoid hateful DCL
# messages like '%MMS-F-EXESTRING, Quoted string must be under 252
# characters.') not logical.  Also, note that the DCL style
# continuation character ("-") must be used, not the UNIX shell style
# ("\") in the CXXSRCS* variables.

CXXSRCS=omniTransport.cc-
	cdrStream.cc-
	cdrStreamAdapter.cc-
	cdrMemoryStream.cc-
	giopEndpoint.cc-
	giopRope.cc-
	giopStrand.cc-
	giopStream.cc-
	giopServer.cc-
	giopWorker.cc-
	giopRendezvouser.cc

CXXSRCS_0=GIOP_C.cc-
	GIOP_S.cc-
	giopStreamImpl.cc-
	giopImpl10.cc-
	giopImpl11.cc-
	giopImpl12.cc-
	giopBiDir.cc-
	giopMonitor.cc-
	SocketCollection.cc-
	[.tcp]tcpTransportImpl.cc-
	[.tcp]tcpConnection.cc-
	[.tcp]tcpEndpoint.cc-
	[.tcp]tcpAddress.cc-
	[.tcp]tcpActive.cc


# VMS doesn't have unix local sockets.
#UNIXSOCK_SRCS =unixTransportImpl.cc-
#	unixConnection.cc-
#	unixEndpoint.cc-
#	unixAddress.cc-
#	unixActive.cc

CXXSRCS_1=codeSets.cc-
	cs-8bit.cc-
	cs-16bit.cc-
	cs-8859-1.cc-
	cs-UTF-8.cc-
	cs-UTF-16.cc

CXXSRCS_2=bootstrapstub.cc-
	objectStub.cc-
	poastubs.cc-
	Namingstub.cc

CXXSRCS_3=anonObject.cc-
	callDescriptor.cc-
	constants.cc-
	corbaObject.cc-
	corbaBoa.cc-
	corbaOrb.cc-
	corbaFixed.cc-
	corbaString.cc-
	corbaWString.cc-
	current.cc-
	dynamicLib.cc-
	exception.cc-
	exceptn.cc-
	initRefs.cc-
	interceptors.cc

CXXSRCS_4=invoker.cc-
	ior.cc-
	libcWrapper.cc-
	omniIdentity.cc-
	localIdentity.cc-
	logIOstream.cc-
	minorCode.cc-
	objectAdapter.cc-
	omniInternal.cc-
	omniIOR.cc-
	omniObjRef.cc-
	omniORB.cc-
	omniServant.cc-
	orbOptions.cc-
	orbOptionsFile.cc

CXXSRCS_5=poa.cc-
	poamanager.cc-
	policy.cc-
	portableserver.cc-
	proxyFactory.cc-
	remoteIdentity.cc-
	inProcessIdentity.cc-
	shutdownIdentity.cc-
	callHandle.cc-
	tracedthread.cc-
	transportRules.cc-
	rmutex.cc-
	uri.cc-
	omniPolicy.cc

.IFDEF ALPHA
ALPHAFLOAT_SRC=CorbaIEEEFloat.cc
.ENDIF

.IFDEF useTcpSocketVaxRoutines
# Note that this hasn't been tested since moving to the [.tcp] subdirectory.
tcpSocketVaxRoutines_src=[.tcp]tcpSocketVaxRoutines.cc
.ENDIF

CXXSRCS_9=CorbaDFloat.cc CorbaGFloat.cc-
 $(ALPHAFLOAT_SRC) $(tcpSocketVaxRoutines_src)

.IFDEF OMNIORB_CONFIG_DEFAULT_LOCATION
CONFIG_DEFAULT_LOCATION = $(OMNIORB_CONFIG_DEFAULT_LOCATION)
.ELSE
CONFIG_DEFAULT_LOCATION = /omnicfg/omniORB.cfg
.ENDIF

.IFDEF OMNIORB_CONFIG_ENV
CONFIG_ENV = $(OMNIORB_CONFIG_ENV)
.ELSE
CONFIG_ENV = OMNIORB_CONFIG
.ENDIF

.IFDEF useTcpSocketVaxRoutines
TCPVAX_MACROS=USE_tcpSocketVaxRoutines
.ENDIF

DIR_CXXINCLUDES = ../ $(TOP)/include/omniORB4/internal
DIR_CXXMACROS = USE_omniORB_logStream _OMNIORB_LIBRARY\
	CONFIG_DEFAULT_LOCATION=""""$(CONFIG_DEFAULT_LOCATION)""""\
	CONFIG_ENV=""""$(CONFIG_ENV)"""" $(TCPVAX_MACROS)
# Note that some versions of the compiler crash when /list/show=all is
# used...
DIR_CXXFLAGS=$(OMNIORB_LIB_CXXFLAGS) 
DIR_CXXLINKFLAGS=/map/full

LIB_NAME = omniORB
LIB_VERSION = $(OMNIORB_VERSION)
LIB_IMPORTS=OMNITHREAD$(OMNITHREAD_FILE_VERSION) 
.include $(TOP)/mk/mklib.mms

###############################################################################
# Compile a CORBA::Float and CORBA::Double for each floating point format
###############################################################################

$(CONFIG_DIR_V)corbaDFloat.obj : corbaDFloat.cc
        @ $(CxxCompile) "/Float=D_Float"

$(CONFIG_DIR_V)corbaGFloat.obj : corbaGFloat.cc
        @ $(CxxCompile) "/Float=G_Float"

.ifdef ALPHA

$(CONFIG_DIR_V)corbaIEEEFloat.obj : corbaIEEEFloat.cc
        @ $(CxxCompile) "/Float=IEEE_Float"

.endif
