$ ! ccompile.dcl - DCL command procedure to compile a C source file.
$
$ cflags = p1					! misc c qualifiers
$ cmacros = f$edit(p2,"TRIM,COMPRESS")		! list of macro definitions for
$						! the /define qualifier
$ cincludes = f$edit(p3,"TRIM,COMPRESS")	! list of directories for the
$						! /include qualifier
$ mmssource = p4				! source file
$ mmstarget = p5				! object file
$
$ ! convert the list arguments from space delimited to comma seperated, quoted
$ ! strings.  This preserves case-sensitivity and allows UNIX style directory
$ ! names in some cases.
$
$ write sys$output "parsing cmacros==''cmacros'"
$ call parselist cmacros
$
$ if outputlist .eqs. ""
$ then
$   definequalifier=""
$ else
$   definequalifier="/define=(" + outputlist + ")"
$ endif
$
$ write sys$output "parsing cincludes==''cincludes'"
$ call parselist cincludes
$
$ if outputlist .eqs. ""
$ then
$   includequalifier=""
$ else
$   includequalifier="/include=(" + outputlist + ")"
$ endif
$
$ write sys$output "Compiling ''mmssource'..."
$
$ oldver=f$verify(COMPILE_VERIFY)
$ CC 'CFLAGS' 'mmssource' /object='mmstarget' 'definequalifier'-
	'includequalifier'
$ x=f$verify(oldver)
$
$ diagnostics = f$parse(mmstarget,,,"name") + ".DIA"
$ listfile = f$parse(mmstarget,,,"name") + ".LIS"
$ If "''F$Search(diagnostics)'" .NES. "" Then delete 'diagnostics';*
$ If "''F$Search(mmstarget)'" .NES. "" Then purge 'mmstarget'
$ If "''F$Search(listfile)'" .NES. "" Then purge 'listfile'
$
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$ parselist: subroutine
$
$   ! in python this would be:
$   !
$   ! def parselist(s):
$   !   import string
$   !   return '"' + string.join(string.split(s),'" "') + '"'
$
$   inputlist='p1'	! Note that this is passed by name due to bugs in pass
$			! by value (call sub "''x'" does some harmful parsing).
$   converttovms=p2
$   outputlist==""
$   if inputlist .eqs. "" then exit
$   if converttovms
$   then
$     quote=""
$   else
$     quote=""""
$   endif
$   outputlist==quote
$   idx=0
$   element=f$element(idx, " ", inputlist)
$
$   next_listitem:
$
$     if converttovms
$     then
$	call unixtovmsdir "''element'"
$	element=outputdir
$     endif
$     outputlist == outputlist + element + quote
$     idx = idx + 1
$     element=f$element(idx, " ", inputlist)
$     if element .eqs. " " then goto end_listitem
$     outputlist == outputlist + "," + quote
$     goto next_listitem
$
$   end_listitem:
$ endsubroutine		! parselist
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
