// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

#pragma once

#include <unordered_map>
#include <array>

namespace onnxruntime {
namespace test {
// Avoid this arrary being initialized on stack.
// Limit the number of arguments to compile with clang.
constexpr std::array<double, 16384> bert_embeddings_position_embeddings_weight_grad = {-0.009673337, 0.015859816, -0.0060598925, 0.0061725015, 0.0686829, 0.031034196, -0.041214723, 0.04238321, -0.045230567, -0.03455956, 0.037526406, 0.019020742, -0.008562718, -0.030574083, -0.012788322, -0.0008712788, -0.041134313, 0.027024698, -0.012437805, 0.059991226, -0.026614683, -0.06257652, -0.020100333, -0.03510955, 0.05741506, 0.068152145, -0.065179504, 0.038520053, 0.019393224, 0.03954512, 0.006873767, -0.084907904, -0.0050477944, 0.0012708178, 0.0030560307, -0.032130327, -0.0144646885, -0.016298112, -0.042901997, 0.07588, 0.01613088, -0.018301323, -0.010611727, 0.005544794, -0.014955264, -0.016850606, 0.022336477, -0.0030460241, -0.014482946, 0.00859436, -0.014712406, 0.03867981, -0.022954227, 0.015440098, -0.005059921, 0.0035975706, 0.01880927, 0.062380753, 0.02279159, 0.0036130734, 0.029864375, -0.022658946, -0.0069784625, -0.06653513, -0.01116233, 0.021000436, -0.028701056, -0.024398895, 0.011476517, 0.032129377, -0.04200533, 0.05585559, 0.027091827, -0.03708192, -0.029153917, 0.014818583, -0.03863439, -0.03299714, 0.026062695, 0.027578063, -0.033457935, 0.023994414, -0.00042527216, 0.020991987, -0.043016825, 0.03330429, -0.0051043453, -0.061040144, 0.02476727, 0.07664442, -0.0109203905, 0.046167813, 0.05265824, -0.009806289, -0.032828216, -0.053807136, -0.018357445, -0.0060726395, 0.012883636, -0.03604291, -0.020931121, -0.017016709, -0.06521842, 0.09689566, 0.010757825, -0.014480298, -0.011673617, 0.014982184, -0.011422393, -0.015741495, 0.021494215, -0.013776923, -0.017716365, 0.02294489, -0.00073889084, 0.036582764, -0.013822639, 0.0075510093, -0.015371518, 0.012141101, 0.009292599, 0.0632079, 0.023068016, -0.0034772623, 0.033849746, -0.009428004, -0.0021826755, -0.07218023, -0.00040298235, 0.008162888, -0.009084097, -0.025772562, 0.01697198, 0.0096272295, -0.05384024, 0.054271728, 0.0061686123, -0.012313863, -0.010857888, 0.011092398, -0.017863888, -0.023245087, 0.0147367595, 0.0022649313, -0.0307159, 0.004318953, 0.0035282676, 0.026500994, -0.029873395, 0.0049419748, -0.007642911, -0.02280794, 0.016169535, 0.059451614, 0.015289053, 0.021232026, 0.042667653, -0.0034166733, -0.014750072, -0.05480911, 0.0012827339, -0.00061177486, 0.008855328, -0.014449824, -0.008173137, -0.033359475, -0.06602954, 0.074186556, -0.0031156093, 0.0009635263, -0.0151721025, 0.007254398, 0.015830085, 0.009578684, -0.0053947777, -0.020233134, -0.016644966, 0.002484738, -0.019542504, 0.026349604, -0.017563643, -0.005398605, 0.0013201954, 0.034780584, 0.007976923, 0.054721735, 0.015226502, -0.001414868, 0.030154174, 0.011785319, 0.0033271122, -0.07897424, 0.01796715, -0.00018319988, 0.006205301, -0.019297902, 0.03912447, 0.0022418862, -0.048669476, 0.031012537, -0.0155599145, -0.01757, -0.0011392199, 0.016611777, 0.008555129, -0.017760677, -0.02604977, 0.014489464, -0.041648414, -0.017570462, 0.005586198, 0.03271513, -0.04649407, -0.038035538, 2.2510882e-05, -0.006990753, 0.043797504, 0.0970251, 0.0041649155, 0.020328937, 0.058848612, -0.008414367, -0.026458042, -0.06685481};
static std::unordered_map<std::string, std::vector<double>> BERT_TOY_FETCHES = {
    //{"bert.embeddings.word_embeddings.weight_grad", {-0.017997999, -0.0047609806, 0.02464902, 0.028866263, 0.06591338, -0.05280977, -0.015370297, -0.012939942, 0.1371909, 0.08751389, 0.10818711, -0.019497797, -0.124962315, -0.1390562, 0.0661109, -0.019681724, -0.0032118761, 0.035696458, -0.08522252, 0.073210604, 0.03514969, 0.08053599, -0.03981568, 0.15768975, -0.1312564, 0.040767364, -0.06651594, 0.028433047, 0.043564245, -0.14705648, -0.035812557, -0.097510085, -0.025216235, 0.03342244, 0.03669464, 0.06126017, -0.10674235, -0.1621022, -0.010083556, 0.21157412, 0.05871246, 0.041555528, 0.07938622, -0.09024606, -0.02048279, -0.074269846, 0.08034445, -0.03423263, 0.04937596, 0.15147208, -0.068053015, -0.006273485, 0.077712014, 0.016324375, -0.13125984, 0.18183258, -0.0948589, 0.059835963, -0.09484588, 0.13196367, 0.16222662, -0.16240467, -0.01710342, -0.33551815, 0.021870147, -0.05047953, -0.034049097, 0.10182176, -0.09652015, -0.07168065, -0.019474177, 0.03104914, 0.072005704, 0.11224386, 0.023698522, -0.02095791, -0.13240159, -0.07948492, 0.063462, 0.07139883, 0.045547854, 0.10343336, -0.10592225, -0.013620282, 0.001788301, 0.019976346, -0.0020458638, 0.11173366, -0.049213164, 0.1023489, -0.09264092, 0.23402038, 0.09820575, -0.10847656, -0.06425326, -0.2733843, 0.0005777818, -0.00045715677, -0.00036173555, -0.0019640834, 0.0023077715, 0.0030269173, 0.0003216554, -0.0030540985, -0.0027387138, -0.0018896874, -0.0018313668, 0.0021082622, 0.0017220074, 0.0034250775, -0.0020885947, 0.0004703794, -0.0013641947, -0.003513737, 0.0018311203, -0.00090747076, -0.0013901574, -0.00074905565, 0.0025276195, -0.004190179, 0.0025550844, -0.001550093, 0.002385542, -0.004288953, -0.003978176, 0.004741103, 0.0012243219, 0.007092811, 0.0004932773, -3.407813e-05, -0.00041131352, -0.0018486764, 0.0013772693, 0.002977006, 0.00041388161, -0.00239666, -0.0027103948, -0.0026874242, -0.0026495266, 0.0011283782, 0.003614702, 0.0033591266, -0.0027252282, -0.00023112007, -0.0006990151, -0.0031920846, 0.0027318746, -0.0008869279, -0.0014932441, -0.00097284024, 0.0021366049, -0.0044928645, 0.0029478169, -0.0015973442, 0.0024006946, -0.0042834366, -0.0033588875, 0.0043437476, 0.0014113806, 0.0073353034, 0.00017268088, 0.0031279165, -0.008860842, -0.0015794376, 0.013640765, 0.017180406, -0.0033492814, -0.008177296, -0.0034932198, -0.007944155, -0.0063837077, 0.009710049, 0.002658482, -0.007252613, -0.008321298, 0.00687512, -0.009124297, -0.0019735715, 0.01227461, -0.0017833582, -0.00959424, -0.008270413, 0.0011829312, -0.020918233, 0.011265653, 0.012732341, -0.005953829, 0.0063472833, 0.01442773, 0.006419024, -0.0063098064, 0.0012746053, 0.000528592, 0.00020003058, -0.00047659109, -0.0020373329, 0.0012807047, 0.0029113134, 0.00028292075, -0.0021702966, -0.00314715, -0.0022823475, -0.0021989467, 0.0012647263, 0.002920366, 0.0034114283, -0.002363095, -9.816287e-05, -0.0008505247, -0.003039885, 0.0023686404, -0.0006314916, -0.001354714, -0.0012804912, 0.0017260184, -0.0042897323, 0.0028488827, -0.0020556434, 0.0024493027, -0.0038287458, -0.0032441246, 0.004484013, 0.0013376187, 0.007334718, -0.0105609605, 0.002379478, -0.009890937, -0.007801132, -0.012611928, 0.007029334, -0.002073091, 0.017913174, 0.010763435, -0.0063913055, -0.011892688, 0.0038930303, -0.0021932116, -0.0033742958, 0.0073220404, 0.0026410208, -0.0014802462, 0.011934996, 0.0061264015, -0.0043084286, 0.002516053, 0.013429475, -0.0037857764, -0.011030935, -0.0010085821, -3.7435908e-05, 0.0007489199, 0.0019895714, -0.0012069133, 0.004092823, 6.465707e-05, -0.0031965435, 0.0068118717, -0.0017017848, 0.011209353, -0.006382887, 0.000779508, -0.011595065, -0.0061810985, 0.0053741224, -0.005813627, -0.00042509334, 0.003855044, -0.0044160755, 0.0051464587, 0.011198121, -3.800541e-05, -0.0073320214, -0.0010064199, -0.011198526, -0.006249857, 0.007254719, -0.0022802218, -0.007081021, 0.0023023842, 0.009914208, 0.0050682398, 0.0015795352, 0.014859522, -0.010059243, -0.009821922, 5.437061e-06, 0.0020397988, 0.0041845436, 0.00060743524, 0.0035826403, -0.006658481, 0.00040580076, 0.01827403, 0.0146418195, -0.0017762181, -0.0052374043, -0.009580359, -0.0092817955, 0.005359125, 0.0057464866, -0.0019206754, -0.0047812895, -0.0034107158, 0.0015538285, -0.0088595655, 0.0065265233, 0.004471723, 0.004160745, -0.0076062633, -0.009591796, -0.0026515983, -0.017235313, 0.011589448, 0.0059728855, -0.01137335, 0.00735884, -0.0011644405, 0.013250465, 0.0011195687, -0.0034921002, 0.002805762, -0.00078478764, 0.008399065, -0.0038660385, -0.0010680065, -0.00809041, 0.00032422598, 0.0018995679, -0.0027532256, -0.0008429906, 0.0041832067, -0.008892417, 0.0059295064, 0.007870191, 0.0007508416, 0.0014074097, -0.0027645924, -0.016193701, -0.004957792, 0.003047731, 0.0012398185, -0.007731399, 0.0065540858, 0.010207696, 0.007732143, -0.0019069482, 0.007129186, -0.01141508, -0.0061322916, -0.004303914, -0.0008273189, 0.01305048, 0.00840299, 0.0041872566, -0.026471771, -0.0049715447, 0.027991377, 0.031558234, -0.0137341255, -0.020456806, 0.0022966114, -0.012054471, -0.022880767, 0.020292591, 0.00937961, -0.010463325, -0.01744223, 0.023348125, -0.020582287, -0.009090931, 0.025472654, -0.009804816, -0.025231019, -0.015752604, 0.010408943, -0.029697021, 0.020585395, 0.03790528, -0.015790287, 0.017945189, 0.04353926, -0.0017329226, -0.023595314, -0.003561283, -0.012905441, 0.008261291, -0.01975705, -0.0055251857, 0.00807631, 0.022083543, -0.010032209, 0.0101967305, 0.0065506864, -0.008186438, -0.018430836, 0.011856037, -0.0022082834, -0.013759101, -0.0021272686, 0.012042769, -0.014718293, 0.01167841, 0.016556803, -0.008750132, -0.0086417645, 0.0075992853, -0.0026043323, -0.028571844, 0.008125619, 0.016735548, -0.015955037, 0.013859228, 0.02121318, 0.012950463, -0.010491186, -0.0051214993, 0.0062633515, -0.0008233592, 0.0052910135, -0.0031190286, 0.0022047765, -0.008960088, -0.0036846313, 0.00087062386, -0.005445968, -0.002036477, 0.0004928082, -0.00269337, 0.006775616, 0.008721391, -0.0026300899, -0.006383828, 0.0019511494, -0.0076960707, -0.0063039046, 0.0042754905, 0.00040666747, -0.0042483783, 0.0019962972, 0.009262519, 0.004271232, 0.0019832584, 0.007568662, -0.008556543, -0.007411748, 0.0019751554, 0.0044261077, 0.0012573618, -5.0236147e-05, 0.0004824708, -0.0003333637, -0.0023520116, 0.0011478316, 0.0029662782, 0.00043794548, -0.0024023955, -0.0024753264, -0.0027765166, -0.002534986, 0.001345078, 0.0034824368, 0.0034430146, -0.0022662533, -0.00047193168, -0.0010801108, -0.003035931, 0.0031154254, -8.620613e-05, -0.001197993, -0.0008512347, 0.001933374, -0.0050755795, 0.002749757, -0.0027894161, 0.0028318304, -0.004384431, -0.0032763379, 0.0041905027, 0.0015910206, 0.007723295, 0.0005058864, 0.0031011272, -0.0074441275, -0.0015969422, 0.011513259, 0.013829162, -0.0016811059, -0.007419233, -0.002532541, -0.0079213325, -0.006160722, 0.0065652085, 0.0048664967, -0.0030768446, -0.008791905, 0.006305258, -0.008027553, -0.0015898008, 0.010005744, -0.0023492612, -0.008704776, -0.006143772, 0.0032253554, -0.016667034, 0.0091037275, 0.009391894, -0.0053318273, 0.0030660476, 0.00925546, 0.006078029, -0.0059509566, 0.0045770695, 0.0009995685, 0.00025790065, -0.00019580893, -0.0018566272, 0.0014472016, 0.002930538, 0.00050319685, -0.0020250285, -0.0033410026, -0.0031543304, -0.0021884134, 0.0015806631, 0.0033400243, 0.0034468751, -0.002491601, 0.00017304737, -0.001472922, -0.0029364377, 0.002639563, -0.0013256792, -0.0010594288, -0.0019129892, 0.001116221, -0.004886509, 0.0032135549, -0.0024254278, 0.0031459422, -0.004506496, -0.0036794618, 0.005542942, 0.0009883041, 0.008132616, -0.0011791522, 0.0023498351, -0.017501524, -0.010245141, -0.0025315527, 0.01148621, -0.012133535, 0.0016164572, 0.01055537, -0.0045963144, -0.02479096, 0.012457934, -5.1175943e-05, -0.0053539854, 0.0023723466, 0.009812681, -0.00492046, -0.0011487806, 0.015497501, -0.0042472202, -0.009950717, 0.011498252, 0.005137325, -0.016925538, 0.0016070234, 0.01426754, 0.0053370185, 0.006548403, 0.023479931, -0.005615459, -0.008669028, -0.004163283, -0.0050874106, 0.003956187, -0.014153139, -0.007844644, 0.008767871, 0.01511938, -0.008699781, 0.0048352266, 0.0024225372, -0.008664474, -0.009789825, 0.008774918, -0.0022714443, -0.006716069, 0.003631292, 0.0022454392, -0.01198203, 0.009634381, 0.012620629, -0.0015550813, -0.0062024663, 0.0046314243, -0.0051125707, -0.02144919, 0.008063468, 0.0095093995, -0.0010837247, 0.005946186, 0.010121394, 0.0067899553, -0.0071534347, 0.0006956016, 0.00031053132, 0.00010009212, -0.0002713576, -0.0019830703, 0.0012846666, 0.0027884827, 0.00050163764, -0.0022867846, -0.0030478789, -0.0024151385, -0.0021119115, 0.0011772054, 0.0031079187, 0.0030648473, -0.0022979607, -0.0002854559, -0.0007576107, -0.0031713017, 0.002610994, -0.000696833, -0.00113486, -0.0013523436, 0.0017056016, -0.0044626216, 0.0030272282, -0.0019895262, 0.002754993, -0.0042606164, -0.0030335283, 0.0042788293, 0.0013481595, 0.007497611, 0.00012572232, 5.194668e-05, -0.00011011079, -0.0017609808, 0.0014765817, 0.0026604726, 0.00077376695, -0.002651739, -0.0029076503, -0.002388567, -0.002244884, 0.0012056415, 0.0030024243, 0.0031733247, -0.0023766996, -0.00022431949, -0.00089091813, -0.003066816, 0.002722234, -0.000672551, -0.0011986885, -0.0013419244, 0.0017522471, -0.0046956344, 0.0029729404, -0.0017498368, 0.0028988635, -0.004392909, -0.0030258638, 0.0044696294, 0.00095764594, 0.007456648, 0.00014177138, 0.00038814277, 6.0722778e-05, -0.0016874018, 0.0010870569, 0.002512887, 0.00022265618, -0.002045031, -0.0029475964, -0.002325779, -0.0020622243, 0.0010454506, 0.002790152, 0.0029184874, -0.0020371294, -0.0001643055, -0.00077473803, -0.0025504264, 0.0024385536, -0.0006069909, -0.0007726869, -0.0014944752, 0.00093590247, -0.0042603845, 0.0027731438, -0.002029966, 0.0028363827, -0.0037331586, -0.0026346755, 0.004446668, 0.000739507, 0.006789486, 0.00032489188, 0.00026472542, -0.00017765928, -0.0017790806, 0.0004905447, 0.0027610848, 0.00053608685, -0.00175061, -0.0028320563, -0.0030973144, -0.0027286555, 0.0009836373, 0.0034077333, 0.0033763817, -0.0021585596, -0.00022196748, -0.0008464739, -0.0028755472, 0.0029746194, -0.00038144802, -0.0006132301, -0.0012783832, 0.001596144, -0.0053242757, 0.003168238, -0.0025237408, 0.0027740581, -0.0036173074, -0.0030177657, 0.0042912867, 0.0010891238, 0.0071855197, 0.0007120421, -2.2641163e-05, -0.00026424718, -0.0017066523, 0.0016475988, 0.0027217942, 0.0004691225, -0.0022624992, -0.0030432239, -0.002266623, -0.0017497039, 0.0015257796, 0.0025341224, 0.003251937, -0.0022221827, 0.00014392762, -0.0011856278, -0.0031288674, 0.002139735, -0.00092574797, -0.0013115163, -0.0013905306, 0.0018050171, -0.004222772, 0.0027052392, -0.0019097182, 0.0024739217, -0.0039873687, -0.0033327325, 0.004651979, 0.0010950787, 0.0070553594, -0.0028286173, 0.0017260195, -0.005937449, -0.0062424066, -0.013732733, 0.0015369668, -0.0057753823, 0.014663625, 0.010353247, -0.001825939, -0.014814697, 0.0027218522, -0.0035032071, -0.0015626256, 0.003517409, -0.000625875, -0.0014146453, -0.00025081984, 0.0060319556, -0.003364539, 0.00053494796, 0.014046713, -0.0014372639, -0.0065907454, -0.005231567, 0.0023598687, 0.014506616, -0.0024606339, 0.0014762101, -0.00040364405, -0.00073817524, 0.005265533, 0.0010220557, 0.0001971465, -0.00036500333, -0.0019238009, 0.0011529202, 0.0031026807, 0.00016898673, -0.0018007541, -0.0036109725, -0.0026924345, -0.0020625987, 0.0014608776, 0.0032813998, 0.0037394143, -0.002487677, 0.00010553931, -0.0010358612, -0.003001938, 0.0025230115, -0.001152096, -0.001204791, -0.001632759, 0.0011607257, -0.00446887, 0.002712753, -0.0024873903, 0.0026712872, -0.0038129413, -0.003546096, 0.0049029053, 0.0012964087, 0.007787875, 0.004531431, 0.0010632295, 0.0065595675, -0.006128853, -0.0009529692, -0.005964753, -0.016935773, 0.0016966017, -0.0022358145, 0.0013705886, -0.0128247375, 0.0062058694, 0.013967339, 0.0037530835, -0.009879645, -0.0033048312, -0.0009216337, -0.016504247, 0.004376841, 0.0034217308, -0.0071402974, -0.010982947, 0.007931545, 0.00352226, 0.001530919, 0.016663602, 0.012201151, -0.012602225, 0.020105971, -0.00022901082, -0.0030633751, 0.0007693842, 0.0029380822, -0.0026568323, 0.016330669, -0.004509992, -0.0041817413, -0.012929777, -0.007516841, 0.006911585, -0.0071876454, 0.0017941797, 0.00441558, -0.002995059, 0.00718584, 0.009401257, -0.0028873177, -0.008895685, 0.0050527602, -0.012256122, -0.009901932, 0.0096671805, -0.00018837489, -0.009238906, 0.00443279, 0.013705594, 0.0024146324, 0.002559394, 0.0143875405, -0.016104946, -0.006818282, 0.00092426245, 0.0062893876, -0.00014128862, -0.0059506055, 0.0030407128, -0.008121954, -0.0056651114, -0.0057642516, 0.006066872, -0.0026214411, 0.011021394, 0.006489616, -0.006335371, -0.009145317, 0.000823457, -0.0036655932, 0.0005924662, 0.0066564083, 0.0015874241, -0.0014039365, 0.0031718707, 0.0019350144, -0.0018479283, 0.002676228, 0.012149602, -0.00045101054, -0.010574754, 0.0002328374, -0.0017135155, 0.0018285497, 0.0006901184, -0.0021719113, 0.0024393334, 0.0018509721, 0.0021798215, 0.0009045607, -0.00014353337, -0.0005710391, -0.001732552, 0.0011271932, 0.003058374, 0.00019974685, -0.002250302, -0.003242995, -0.0023937346, -0.0024623529, 0.0014151139, 0.0026704576, 0.0035118842, -0.0024394814, 0.00038889388, -0.00084656716, -0.0029779724, 0.0021623059, -0.00079764647, -0.001117069, -0.0012453439, 0.0014935898, -0.004455296, 0.0030645332, -0.0017849146, 0.0024523397, -0.0035439185, -0.0034855672, 0.0047375336, 0.00092360895, 0.00738015, 0.006498468, -0.0036738052, 0.015163693, -0.0032198017, -0.0038915896, -0.015590584, -0.0071808156, 0.0072833896, -0.009669926, 0.0019102332, 0.005329475, -0.004685795, 0.008856878, 0.013108819, -0.0047105346, -0.007908343, 0.0020216857, -0.014218248, -0.0101794675, 0.010269184, 0.00065064564, -0.0075155194, 0.0041810796, 0.017486095, 0.0019205527, -0.0005795059, 0.014528455, -0.01579994, -0.009410718, 0.002655998, 0.008186263, -0.0018163193, 0.0014517346, 0.0030464854, -0.0070022643, -0.0031184065, 0.011362275, 0.0135162715, -0.0019787536, -0.008839537, -0.0048693754, -0.006094599, -0.0032701096, 0.0065285023, 0.0015069502, -0.0066526253, -0.0053364984, 0.006757874, -0.0074259327, -0.0052304124, 0.008923695, 0.0036826187, -0.0074168947, -0.0060998, -0.000952567, -0.017319065, 0.010477784, 0.009642714, -0.0013285489, 0.0028037834, 0.010637073, 0.002626013, -0.0027156211, 0.0026872386, 0.0070796628, -0.004015685, 0.018252838, -0.005500131, -0.0030805182, -0.018460536, -0.006066921, 0.009861857, -0.009575605, 0.004493556, 0.005666292, -0.0042706714, 0.008039122, 0.01348949, -0.0061355587, -0.008347623, 0.0030476507, -0.014059008, -0.012263626, 0.011053927, -0.0026091768, -0.0061571607, 0.0051128604, 0.018477913, 0.0019429584, 0.0007641193, 0.017233212, -0.015567182, -0.0126112215, 0.0019196854, 0.0073890155, -0.0051035318, 0.013073606, -0.008676069, 0.027437733, -0.005685153, -0.0048312936, -0.026390534, -0.011164489, 0.011887408, -0.015330074, 0.0053473106, 0.009824971, -0.008717217, 0.005872364, 0.020612434, -0.005883364, -0.011607226, 0.005767056, -0.021538887, -0.01832333, 0.017283997, -0.004239528, -0.0075377068, 0.0067623206, 0.024929691, 0.0030266875, 0.0017495112, 0.02600819, -0.021826088, -0.012778719, -0.0012914892, 0.01106718, -0.0048292875, 0.00021744988, 0.00020400426, -0.0003899804, -0.0022355018, 0.0018636945, 0.00296149, 0.0005221443, -0.0029992016, -0.0026512255, -0.0025319613, -0.0022274074, 0.0019068689, 0.0030309039, 0.0029857045, -0.0021062512, -0.00030563938, -0.0013976512, -0.003301596, 0.0028855286, -0.00052367215, -0.0013300345, -0.0010916467, 0.0019230269, -0.0047303173, 0.0030915274, -0.0023702714, 0.003067196, -0.005083602, -0.003443625, 0.004344103, 0.0016761471, 0.008039798, 0.0007844258, 0.00018137062, -0.00026568296, -0.0016601755, 0.0015186438, 0.0026420844, 0.00044743757, -0.0018867227, -0.0029778176, -0.0025416857, -0.0017308115, 0.0012217582, 0.002964157, 0.0031193872, -0.002326102, -9.0942376e-05, -0.0010594765, -0.0030576172, 0.0022836637, -0.000799529, -0.0013622262, -0.0013374407, 0.0018372526, -0.003995214, 0.0026487047, -0.001931988, 0.002098946, -0.003827079, -0.0032731576, 0.004345106, 0.0012305259, 0.0068002017, -0.012095545, 0.0028447057, -0.011966242, -0.015485612, -0.012576111, 0.013168669, -0.004160457, 0.022843808, 0.011991228, -0.0066644144, -0.011322565, 0.0063444674, -0.01410116, -0.010019832, 0.021117568, 9.187611e-05, -0.0013327657, 0.007169055, 0.009690575, 0.0040669907, -0.00133698, 0.021052241, -0.0039060686, -0.016885206, -0.0001965065, -0.0023331102, 0.0093584545, 0.00517774, -0.0043187155, -0.006356013, 0.0022162802, -0.002076353, -0.006446152, 0.0022565834, -0.0076454924, -0.00688087, -0.0070316866, 0.0053669894, -0.0012992597, 0.012064027, 0.0053672497, -0.005618355, -0.0076277144, 0.0014238689, -0.0037624568, -0.0027487723, 0.0075502866, 0.00069311843, -0.0015383572, 0.005713947, 0.004286565, 0.00071826146, 0.00025243452, 0.01146758, -0.0012699093, -0.009170919, -0.00020232564, -0.00383274, 0.0050374167, 0.00063570053, -0.0021549957, 0.0022287932, 0.0016783312, 0.0004888545, 0.002160338, 0.0038629004, -0.018004075, -0.0007131769, 0.02627013, 0.030016804, -0.008935516, -0.015536835, -0.009336805, -0.01127727, -0.010575434, 0.017461088, 0.0018116187, -0.011612832, -0.012800287, 0.014068774, -0.016989125, -0.004491312, 0.020586193, 0.002007278, -0.018472012, -0.017422924, 0.004329747, -0.030969044, 0.019137893, 0.024521464, -0.015964137, 0.015525371, 0.028104406, 0.0064570718, -0.008641956, -0.0045783324, 0.00617041, -0.0026711277, 0.011749748, -0.003963517, 0.0011188284, -0.008836435, -0.005742355, 0.0024842399, -0.008207357, -0.00028740184, 0.0025962994, -0.0018317796, 0.004489007, 0.010197395, -0.004232771, -0.006659869, 0.0006331989, -0.009419889, -0.005410017, 0.0070336685, -0.002251401, -0.0045380453, 0.0019859136, 0.0058261915, 0.0032648887, 0.0015069069, 0.013948778, -0.011478152, -0.007854606, 0.0032449178, 0.005022601, 0.0021117325, 0.0073805666, 0.002741469, -0.00014032266, -0.0042117606, 0.011156526, 0.004212981, -0.006665513, -0.0035549821, -0.0048597767, -0.008110461, -0.0021172522, 0.0013150764, 0.0034373142, 0.0019314543, -0.003959178, 0.0028005647, -0.00539309, -0.007574683, -0.0007533694, 0.005529741, -0.009072944, -0.0088231, 0.0033268996, -0.0059645716, 0.010441644, 0.010647985, 0.0029428673, 0.0010002612, 0.0038903921, 0.0015763335, -0.0032595065, 0.00012843218, -0.0061714235, 0.0019848756, -0.005874614, -0.006823655, -0.00512793, 0.004651658, -0.0016947184, 0.009745433, 0.005077403, -0.0039926767, -0.005937856, 0.0014031938, -0.0040240777, -0.0013959282, 0.006641321, 0.00048554863, -0.0019189396, 0.0025871636, 0.004949557, 0.00014530394, 0.00053653936, 0.00818183, 7.3530246e-05, -0.007692029, 0.0013642919, -0.0038802335, 0.004378024, -0.00073609594, -0.0024526988, 0.0014981793, 0.00090616435, 0.0031128596, 0.0034960525, -0.003684109, 0.012981877, -0.00423304, -0.004241525, -0.020383097, -0.011061333, 0.017700456, -0.0048262905, -0.004518502, -0.0029783815, -0.0020763755, 0.0088201305, 0.012674342, -0.004360376, -0.011975977, 0.00012832135, -0.00019296655, -0.009745534, 0.0052810255, -0.0012431666, 0.0005855025, 0.0014335308, 0.013187029, 0.0017999185, 0.012313552, 0.012351981, -0.013758875, -0.0050439537, 0.005234618, 0.0044922917, -0.008157127, 0.0010181325, 0.00012998244, -0.00019041084, -0.0018755132, 0.0008456255, 0.0030351516, -0.00031106573, -0.0014172043, -0.0031141555, -0.0028611033, -0.0020896685, 0.0012336723, 0.0027907055, 0.0029900768, -0.0020033405, 0.00020887637, -0.0007251832, -0.002925036, 0.0020099108, -0.0006732843, -0.00061546906, -0.0014423747, 0.0014687421, -0.004121246, 0.0028496573, -0.0021314549, 0.0022465729, -0.003013876, -0.003157397, 0.004369162, 0.0008920046, 0.006579509, 0.0002171929, 0.00024984716, -0.00019656037, -0.0021869547, 0.0016142554, 0.0024871952, 0.0005504462, -0.0021825775, -0.0020713354, -0.0024767125, -0.002174399, 0.00095172337, 0.003066495, 0.002730869, -0.002273328, -0.00047589117, -0.0006951919, -0.0024075068, 0.0024506943, -0.0005932778, -0.0012856632, -0.000804952, 0.0017992416, -0.0037865844, 0.0021470482, -0.0012703429, 0.002133891, -0.0040236544, -0.0029842865, 0.0040183268, 0.0010475848, 0.0064244103, 0.0054374957, -0.00034064212, 0.0043755705, -0.0038957987, 0.013612418, 0.0031713133, -0.011317272, -0.0025447651, -0.009932272, -0.0038655351, -0.00089407945, 0.0047235214, 0.008902721, 0.0019546235, -0.010988165, 0.00013108776, -0.0066782306, -0.010234417, 0.002174427, 0.006218289, -0.008708478, -0.016405452, 0.004499079, -0.0033556325, 0.010011815, 0.018780885, 0.0015382974, -0.0046784524, 0.010967234, 0.0038234438, -0.0019304641, -0.0045525716, 0.0004951601, -5.812235e-05, -0.00030713706, -0.0017293785, 0.001609722, 0.002715414, 0.00040386102, -0.002164093, -0.0029733859, -0.002576011, -0.0019755312, 0.0013737179, 0.0026233296, 0.002786489, -0.0020019233, -3.5301615e-05, -0.0008951753, -0.0032184815, 0.002233079, -0.00067864044, -0.00069875957, -0.0008629871, 0.0017969247, -0.0040618163, 0.0029859033, -0.0016509062, 0.0020643836, -0.004133572, -0.003486413, 0.004202718, 0.0013308781, 0.006886054, -2.6471036e-05, 3.0252344e-05, -0.00010333983, -0.0019170424, 0.0018193807, 0.0028218506, -6.978916e-05, -0.0027228256, -0.0030869239, -0.0016953195, -0.0015853535, 0.0015186599, 0.0019162893, 0.0028057958, -0.0016957158, -4.035469e-05, -0.0007545946, -0.0033340857, 0.00193638, -0.00043753252, -0.0009664256, -0.000999663, 0.0018938314, -0.0037964573, 0.0027999375, -0.0017857992, 0.0024231416, -0.0041455724, -0.0029776935, 0.0041433456, 0.0013523796, 0.0066797165, 0.000905996, -7.686917e-05, -0.00079697307, -0.0019986823, 0.0014579074, 0.0034682117, 0.00019557869, -0.0029555075, -0.004044311, -0.0020280434, -0.0027051398, 0.0018344714, 0.0029887734, 0.0041516987, -0.002808541, 0.00037369103, -0.00097277743, -0.0034884268, 0.0025252393, -0.00095002906, -0.0017743057, -0.0014373888, 0.001625231, -0.004907643, 0.003430385, -0.0019271915, 0.0028683352, -0.004206646, -0.0037165, 0.005199824, 0.0012826094, 0.008487024, -0.004150607, 0.0053722784, -0.006493363, 9.54268e-05, 0.016380653, 0.016911916, 0.0013577422, -0.005345783, -0.009025032, -0.0075583756, 0.0043393546, 0.0061504757, 0.00018994813, -0.0037113111, -0.005069843, 0.00424993, -0.008633678, 0.004823947, 0.0062819757, 0.0025253133, -0.0059226397, -0.012286134, -0.00076790457, -0.016947294, 0.0127494205, 0.005501068, -0.017886098, 0.0073890034, 0.0013947466, 0.0112460945, -0.00055652414, -0.0026047076, -0.00021909301, 2.1232743e-05, 2.111515e-06, -0.0017520738, 0.0014491577, 0.0027099485, 0.0006047261, -0.0027359193, -0.0026827862, -0.0021999339, -0.00224807, 0.0009353834, 0.00293704, 0.003033272, -0.0024646244, -0.0005621152, -0.00068372133, -0.0035252145, 0.0028055804, -0.00018824104, -0.0012673639, -0.001238738, 0.0020090698, -0.0046917414, 0.003384725, -0.0019347088, 0.0030888957, -0.0045490437, -0.0027450926, 0.0039386945, 0.0012418695, 0.0075267707, -0.00048685318, 0.0032050323, -0.0023975158, 0.00014976528, 0.024089929, 0.013015091, -0.0074903853, -0.0008408498, -0.016083915, -0.008722074, 0.0082209045, 0.0062642386, 0.0019960036, -0.0039535845, -0.009605093, -0.0019010922, -0.010570506, -0.00030217832, 0.0036756378, 0.009644123, -0.0036832122, -0.02181431, -0.0041279467, -0.012327228, 0.018967424, 0.010756321, -0.016836679, 0.0055831256, 0.0032254949, 0.013985716, 0.005566305, -0.007201682, 0.00056333025, -0.00027411422, -0.00017052304, -0.0016560657, 0.001567519, 0.0029629918, 0.000678718, -0.0027026318, -0.0029078547, -0.0023922592, -0.0023347768, 0.0015239465, 0.0025536825, 0.0035639883, -0.0024720326, 0.00012644277, -0.0011780494, -0.0033140026, 0.002509107, -0.0007816692, -0.0012339482, -0.0013395188, 0.0020148966, -0.0049744933, 0.0030158134, -0.0017933924, 0.0028926379, -0.004127897, -0.003460374, 0.0047097593, 0.00091159204, 0.0075191753, -0.008614111, 0.0033545352, -0.005901906, -0.008597089, -0.0053662965, 0.00631929, -0.003156506, 0.013949568, 0.008407091, -0.0064625656, -0.0101375235, 0.0033526947, -0.008583939, -0.0022829266, 0.009111658, -0.00032367796, -0.0010312267, 0.006857365, 0.0038495301, -0.0012925735, -0.0013691601, 0.016282737, -0.0007180128, -0.012214411, 0.0013006628, -0.0004802189, 0.0040819203, 0.0038045952, -0.004507603, 0.0014228737, -0.00062317925, -0.00043159164, -0.00013682639, 0.0006417796, 0.00010499196, -0.001882964, 0.0011848513, 0.0023646397, 0.0010044038, -0.0020150202, -0.002918872, -0.0030254924, -0.001937288, 0.0012847328, 0.0033513582, 0.003063031, -0.0018612022, -0.00044757064, -0.001367261, -0.0027930166, 0.0031647137, -0.00048700455, -0.00050759525, -0.0013548138, 0.0012297498, -0.0052111433, 0.0027917896, -0.0029739058, 0.0030564922, -0.004625508, -0.0031280087, 0.0046553984, 0.0011713073, 0.007604249, 0.00051626266, -0.0003727846, 0.010244895, -0.00027303374, 0.005420945, -0.005561035, -0.0013095019, 0.0056455834, -0.014264873, -0.0037528411, 0.010772455, -0.0029793133, 0.0038901463, 0.007742432, -0.0019125149, -0.008382822, -0.0027669664, -0.0021567608, -0.007778302, 0.010245836, -0.00018230302, -0.008106121, -0.00013649254, 0.003807947, 0.00729113, -0.0035887316, 0.001633589, -0.008506564, -0.015274648, 0.010944845, 0.007684721, 0.0014648172, -0.0006952957, 0.003324689, 0.00071915885, 0.00248506, 0.016352946, 0.005280583, -0.00623929, 0.0018299418, -0.017918559, -0.007810682, 0.009660777, 0.0024407834, 0.0051533226, 0.0013164964, -0.007824114, -0.0037405496, -0.0037006158, -0.0026986594, -0.003241396, 0.016547903, -0.005873247, -0.020156447, -0.00041608175, -0.0043239878, 0.011550491, 0.008607218, -0.0075063016, 0.0012833863, -0.0033852458, 0.015302398, 0.0036514045, -0.009976092, -0.0094582625, 0.0019136795, -0.003816244, -0.0052521913, -0.005640759, 0.0064002993, 0.00021061004, 0.010246283, 0.004138455, -0.006357912, -0.006858885, 0.0023797571, -0.0028282825, -0.006424657, 0.0024597507, 0.0022808323, -0.0021765903, 0.0070077986, 0.004929678, -0.0017881694, 0.0022599087, 0.010701381, -0.0020467085, -0.012945915, 0.0012482868, 0.0018977162, 0.0045550587, -0.0027382753, -0.00016925554, 0.0035170163, 5.08097e-05, 0.0023047836, -0.0001387084, 0.00062005135, -0.00034675517, -0.0021051473, 0.0014323776, 0.0029199328, 0.0001469545, -0.002789509, -0.003140024, -0.002252282, -0.0024742507, 0.0014305915, 0.003456727, 0.0031863616, -0.002305421, -0.00046394134, -0.0009285136, -0.0032664395, 0.0029427893, -0.00023294397, -0.0015098042, -0.0012337321, 0.0016271105, -0.004712121, 0.0033915045, -0.0024254979, 0.0029926978, -0.004756955, -0.0028415914, 0.0044336487, 0.0015355654, 0.007807323, 0.00028486573, 9.294309e-05, 4.0304094e-05, -0.0018306443, 0.0014418224, 0.0026542696, 0.00092525635, -0.0023723934, -0.003042804, -0.002500411, -0.0018443377, 0.0015972295, 0.0027765457, 0.0035999904, -0.0021237715, 6.741664e-05, -0.0014306328, -0.0031477315, 0.0026800074, -0.00083089457, -0.001097284, -0.0014429512, 0.0018545598, -0.0052308724, 0.0026084112, -0.0024868692, 0.003054095, -0.004203107, -0.003381156, 0.0049214726, 0.0008281477, 0.0075385203, -0.0061326004, 0.0011841397, -0.002454173, -0.0053115925, -0.0075385757, 0.0023974972, -0.0026829182, 0.009395979, 0.0027879267, -0.0017060591, -0.006408508, 0.003156234, -0.00018888433, 0.00068803993, 0.0016600527, 0.0009081654, 0.0006970008, 0.0051394235, 0.004264407, -0.00047725654, -0.0007000485, 0.005949711, 0.0014616111, -0.0029483407, -0.0015934717, -0.002841943, 0.0034673843, -0.0019618473, -0.0028674968, 0.0039176866, 0.0018821673, -0.003143711, 0.0073068347, 0.0006083162, 0.005683525, -0.0026827771, 0.009803878, -0.0020681322, -0.009741264, 0.0003039497, -0.00820354, -0.005031355, 0.0006829422, 0.0013402709, 0.006167438, 0.004092201, -0.008320164, -0.0020070244, -0.00592449, -0.0077979052, -0.0011069793, 0.006044103, -0.008538142, -0.010993669, 0.001328527, -0.0012411003, 0.008381294, 0.013316455, 0.005269571, -0.004019792, 0.006347267, 0.0050116275, -0.00088575564, -0.0031261123, 0.0038324357, 0.001947425, -0.011934128, -0.0023514028, 0.018996991, 0.020850126, -0.0040943353, -0.015292408, -0.005557739, -0.008844888, -0.004829569, 0.014093887, 0.0013900932, -0.013033763, -0.007995188, 0.013022985, -0.011064979, -0.0015339954, 0.013059825, 0.005284045, -0.01853649, -0.010443499, 0.00091607013, -0.02471719, 0.013506429, 0.020138633, -0.0063441116, 0.010747587, 0.01715109, 0.0054799058, -0.008125365, -0.005718482, -0.009523921, 0.004031453, -0.0043424107, -0.003965478, -0.00019951258, 0.006821734, 0.00093463383, 0.014619145, -0.0016787152, -0.007243811, 0.0010624749, 0.0025674915, -0.004014319, -0.003234878, 0.004924042, -0.0012636965, -0.0040291576, 0.011717852, 0.003439488, 0.000371299, 0.0023751222, 0.0047646966, -0.0061449977, -0.011830248, 0.003249052, -0.004387985, -0.0071940525, 0.0016704071, -0.010485041, 0.013278592, 0.0042915833, -0.00058084494, -0.0074431146, 0.002333594, -0.0044081504, -0.008538434, -0.0075355805, 0.006104965, -0.001696859, 0.013865607, 0.004817524, -0.004306097, -0.0061886236, 0.0030608429, -0.0053610126, -0.0034890578, 0.007023988, 0.00031803636, -0.0028853614, 0.002532902, 0.0073304162, -0.00022468361, 0.000890851, 0.011014395, -0.001742674, -0.009258183, 0.0015422989, -0.0026274761, 0.003436381, -0.0010076303, -0.0032337934, 0.0005153236, 0.0014766905, 0.0036829172, -0.0061524822, 0.003731187, -0.015731474, -0.008085394, 0.0034807553, 0.016666021, -0.0064078295, 0.011071627, 0.0053878175, -0.007938213, -0.01083292, 0.0046372036, -0.0064755073, -0.0109631345, 0.005120757, 0.006312319, -0.010849294, 0.0057520308, 0.012223036, -0.0003140926, -0.008738218, 0.00982214, -0.0008818145, -0.022325821, 0.007838352, 0.007786551, -0.00024441, 0.008915944, 0.009170739, 0.0073079867, -0.005996983, -0.00328688, -0.006478942, 0.0016677654, -0.0053655775, -0.0074758073, -0.0069488916, 0.0047094105, -0.00090135884, 0.010370271, 0.004697619, -0.003948996, -0.0060759704, 0.0026943653, -0.0021532092, -0.0030956096, 0.0061715445, -0.000721114, -0.0029683285, 0.0047956416, 0.00649931, 0.0012805233, -0.00013637933, 0.010223877, -0.0023562838, -0.009451093, 0.0017906576, -0.0031774002, 0.0043046363, -0.0015691991, -0.003608795, 0.0039020905, 0.0005805611, 0.0027446835, -0.00027131848, 0.00034115725, 0.00015209209, -0.0016027483, 0.0009736757, 0.002345623, 0.00046584496, -0.0021532534, -0.002658103, -0.002475076, -0.0020159201, 0.0006034886, 0.0030376115, 0.0026023618, -0.0020206363, -0.00057931466, -0.00044583468, -0.0032225975, 0.002752818, -4.5936205e-05, -0.0008346307, -0.001210664, 0.002005679, -0.004408803, 0.003163653, -0.0021388005, 0.0026233909, -0.0039162305, -0.0024325135, 0.0035766829, 0.0012032001, 0.0065851025, -0.0041269287, 3.8468395e-05, 0.012427676, 0.00072730705, 0.0026115472, -0.0028470296, 0.0018645965, 0.006869727, -0.01077577, -0.0046981173, 0.010191354, -0.004546391, 0.0023100844, 0.0051555317, -0.0025883974, -0.002750759, 0.003066292, 2.0972919e-05, -0.0133760115, 0.01112469, 0.0012076324, -0.00996091, 0.00080124324, 0.002630883, 0.009449447, -0.0019397092, -0.0048384313, -0.00887307, -0.01576715, 0.009321123, 0.00793182, -0.0006617177, -0.0015204092, -0.002257922, 0.009030065, -0.0065865116, -0.0068558613, -0.010703899, -0.007219209, 0.016506331, -0.0021291971, 0.0011076706, -0.0018946701, -0.0017234617, 0.0027753932, 0.007608528, -0.0013772841, -0.0058183316, -0.00061465346, -0.001643983, -0.0037227229, 0.0048146225, -0.0008683875, 0.003066254, -0.00012366218, 0.0063434625, -0.0007604037, 0.0025837978, 0.013119856, -0.008245062, -0.008330839, 0.0055369684, 0.004306605, -0.0044030794, -0.0005743736, 0.001633583, 0.0041283104, -0.0010327334, 0.0045357114, 0.0040169964, -0.01845359, 0.01787856, -0.0034726663, -0.011659045, 0.008757364, 0.0009508793, 0.00741224, 0.0011030843, 0.00019457843, -0.0067174044, -0.016203582, 0.004426266, -0.0057167253, 0.013904303, -0.014548311, -0.012974346, -0.00028885272, -0.006254177, 0.016611833, 0.012248037, -0.0013852103, -0.003556108, 0.0042706225, 0.011828274, -0.0008948139, -0.0101687, 0.0014333529, 0.0012203243, -0.007598101, -0.0013477553, 0.012916556, 0.014260517, -0.0026293506, -0.008697799, -0.0058313264, -0.0058960486, -0.0053016627, 0.0070755845, 0.0036021685, -0.0040959623, -0.0064903297, 0.007466141, -0.008120704, -0.002459073, 0.009160128, -8.1901846e-05, -0.009597266, -0.006663139, 0.0008669612, -0.018750664, 0.008916349, 0.010690635, -0.003958025, 0.0029481016, 0.011524303, 0.0065623783, -0.0061902506, 0.005065857, -0.003409793, 0.002675483, -0.0039979583, -0.008161323, -0.005341731, 0.0033950328, -0.0028700826, 0.011468841, 0.004381638, -0.006028867, -0.007526343, 0.0036363895, -0.0038420435, 0.0007636803, 0.0068401145, -0.0031548336, 9.681657e-05, 0.0044379663, 0.0025413653, 0.0007811419, 0.000721812, 0.011469119, -0.0019921695, -0.008517038, -0.00012775627, -0.0012729589, 0.0053620148, -0.0014820083, -0.00461486, 0.001567703, 0.0036551727, -0.0014545261, 0.0002785001, -7.354087e-05, -0.00010248562, -0.0021608046, 0.0015937504, 0.0029274093, 0.00022074276, -0.0025149076, -0.0024873049, -0.0023078294, -0.0020453834, 0.0015194869, 0.0023359528, 0.0030427503, -0.0020016623, -0.00011978096, -0.0010572306, -0.0030333973, 0.0023379484, -0.0005352641, -0.0009927752, -0.0011600476, 0.0017491049, -0.0043684472, 0.002673278, -0.0019570505, 0.0029216507, -0.004052729, -0.0032503027, 0.0042403103, 0.0011351603, 0.007244899, -0.0058104615, 0.0020212007, -0.0066293525, -0.0073043164, -0.006554282, 0.0063734986, -0.0024966279, 0.0108885495, 0.006038948, -0.005249802, -0.00740461, 0.0013969456, -0.004723888, -0.001597235, 0.008390436, 0.0007247033, -0.0015648092, 0.0034749403, 0.004875688, 0.00017023474, 0.00015530875, 0.009726595, 2.8161914e-05, -0.008569835, 0.0008847199, -0.0032705776, 0.0052673314, 0.0005036001, -0.0030402658, 0.00016908161, 0.00040699553, 0.002719127, 0.00287232, 0.0026079598, -0.0068108784, -0.0019630392, 0.011233251, 0.010630335, -0.0025589848, -0.008222715, -0.0018606959, -0.0069654398, -0.0036020782, 0.0065878225, 0.001872299, -0.0019083449, -0.005323045, 0.0060045263, -0.0060108053, -0.0008941792, 0.006578467, -0.00056490983, -0.009410191, -0.005366108, 0.004692808, -0.013129914, 0.006326678, 0.008627204, -0.0027896813, 0.003855089, 0.007853349, 0.0031688404, -0.0031783637, -0.0023515709, 0.00024021795, 0.00013818666, 9.926234e-07, -0.0019419164, 0.0008458862, 0.0026998576, 0.00030665076, -0.0021104359, -0.0030192088, -0.0024569705, -0.002197013, 0.00090178725, 0.0028140298, 0.0029296803, -0.0021665262, -0.00031466343, -0.00065998116, -0.0030184037, 0.0026766844, -0.00034797308, -0.00092976086, -0.0019310719, 0.0011536151, -0.0047201863, 0.003471278, -0.002243467, 0.0034915255, -0.0037933562, -0.0026063381, 0.004207296, 0.00088558, 0.0076940064, 0.00976639, 0.0012086492, 0.0059515224, -0.0070492914, 0.012216285, -0.0042864224, -0.011265295, 0.00046861032, -0.012975898, -0.00085321534, 0.0030651095, 0.0035063615, 0.0057007656, 0.004605801, -0.005518389, -0.0012383781, -0.0063414588, -0.009968158, -0.0034043372, 0.013751285, -0.0117279, -0.013165627, 0.003967019, 0.003285985, 0.0075388155, 0.012254449, 0.00999081, -0.004329881, -0.00062858686, 0.0039661373, 0.00020441483, -0.008695564, -0.01117609, 0.0051179174, -0.01054573, -0.00862269, -0.0001401736, 0.016393416, -0.0052109514, 0.011858048, 0.0070129866, -0.0071242573, -0.010223047, 0.007985684, -0.0058464087, -0.009671124, 0.0043712957, 0.009066492, -0.007892078, 0.005985814, 0.008875767, -0.0023036376, -0.0048503755, 0.0071969936, 0.00018193678, -0.018898902, 0.0053178957, 0.008020586, -0.0038169418, 0.004626607, 0.0077785766, 0.001279098, -0.006098298, 0.0013515842, 0.006084554, -0.0046298667, 0.012680999, -0.0029684287, -0.0007275047, -0.01416393, -0.0066415207, 0.0076148678, -0.012155773, 0.002249981, 0.003698237, -0.004086202, 0.007294273, 0.012837814, -0.005056043, -0.0083685545, 0.0020243768, -0.0141644, -0.008069392, 0.009523456, -0.0006808713, -0.0060532964, 0.0054370137, 0.01542493, 0.0028928653, -0.0017622622, 0.013623863, -0.012950126, -0.010562262, 0.004182653, 0.006721361, 0.0007491871, 0.0043796003, -0.0019682185, 0.010981401, -0.0049833846, 0.0010528283, -0.007814195, -0.0045218384, 0.0021779584, -0.0067053447, 0.0011345851, 0.0025229445, -0.0015875715, 0.003778784, 0.0099495575, -0.0036062005, -0.004838287, 0.0013654598, -0.009582941, -0.0055645313, 0.0068218396, -0.002254496, -0.0033479072, 0.0034241003, 0.006149572, 0.003176182, 0.00021456694, 0.012853925, -0.00998006, -0.008737063, 0.0006867277, 0.004581357, 0.00024064211, 0.004225611, -0.0039556744, 0.011068136, -0.0035598301, -0.003771848, -0.009636549, -0.0031346534, 0.005866414, -0.008012846, -0.0007873754, 0.0024980842, -0.0016793059, 0.0036911294, 0.00828741, -0.00081296556, -0.004232429, 0.002127821, -0.012094717, -0.0059817396, 0.008802259, -0.0014865159, -0.0033026005, 0.0028502916, 0.008467596, 0.00384959, -0.0019855474, 0.009558726, -0.011924317, -0.00827813, 0.002316501, 0.006087031, 0.0049404376, 0.000887439, 0.00024858388, -0.0006157966, -0.0020909945, 0.0014784355, 0.0027916492, 0.0006724892, -0.0021008619, -0.0031865085, -0.0028533407, -0.002183182, 0.0017606411, 0.0029095726, 0.0035133876, -0.0022565946, 0.00032649765, -0.0014774983, -0.002876361, 0.002388194, -0.0009255558, -0.001121002, -0.001313985, 0.0014981374, -0.004686612, 0.0028620013, -0.0022985658, 0.0025133858, -0.0041368143, -0.003921854, 0.0052632536, 0.0011294718, 0.0078023886, 0.0007176959, 0.0006130941, -0.00036587688, -0.002111317, 0.000968499, 0.0028141902, -0.00017481088, -0.0014777328, -0.0030019938, -0.0025163568, -0.00211287, 0.0011453836, 0.0033463112, 0.0031255658, -0.0021719516, -0.00021565935, -0.0007925009, -0.0023929777, 0.002282394, -0.00084536144, -0.0013481308, -0.0015172648, 0.0011673993, -0.0038060755, 0.0024868245, -0.002131548, 0.002220585, -0.0033059937, -0.0028072158, 0.0044355355, 0.0012144556, 0.0065577035, 0.00033517976, 9.205692e-05, -0.00035893387, -0.0021329136, 0.0019009656, 0.0031388283, 0.00068071, -0.0029915946, -0.0030564284, -0.002665488, -0.0025471158, 0.0018062338, 0.0028803947, 0.003413861, -0.0024480945, -0.00015156186, -0.0014702755, -0.0035685312, 0.00291666, -0.00024742063, -0.0011735357, -0.001100023, 0.0017956098, -0.00533945, 0.0035853868, -0.0022697477, 0.0031322509, -0.0051302193, -0.0037659626, 0.0049262284, 0.0012584337, 0.008554495, -0.008918012, -0.002425724, -0.005380002, -0.0081583625, 0.0036556402, 0.0075651505, -0.009634226, 0.010840105, -0.0052590333, -0.0043396205, -0.00547905, 0.008068219, -0.0040829703, -0.0015390515, 0.0050701685, -0.003271369, -0.008273071, 0.011609446, 0.016119251, -0.00089563953, 0.002220049, 0.0037887713, -0.006672847, -0.010564556, 0.00056258147, 0.005155004, 0.00085339986, -0.0027339035, 0.0026953637, 0.004081999, -0.0027544494, 0.008096734, 0.0007499301, 2.9910013e-06, -0.00028399844, -0.0018324471, 0.0018256695, 0.002815859, 0.0006350474, -0.0026182, -0.003018003, -0.0023773946, -0.001920138, 0.0016878507, 0.0029521151, 0.0035132496, -0.0024823623, 0.00019045219, -0.001333904, -0.0031975012, 0.0024487718, -0.0011463219, -0.0017153688, -0.0012139737, 0.0022270998, -0.00451566, 0.0026316296, -0.0018780424, 0.0024978225, -0.004276236, -0.0037086862, 0.0048947614, 0.0011506982, 0.007294288, 0.0048748427, -0.0019554335, -0.0064288783, 0.0019329989, 0.014184961, 0.014422169, -0.0012565384, -0.011728388, -0.0074450313, -0.011684989, -0.0039037722, 0.012410587, 0.006467982, -0.0015258256, -0.0142733, 0.004957086, -0.0064462987, 0.00019889465, 0.008680752, 0.00097585755, -0.015874006, -0.010952647, 0.0041848253, -0.020912226, 0.013163977, 0.0194663, -0.004548863, 0.0023031244, 0.013726455, 0.0049346574, -0.0066488404, -0.0013004369, -0.00042701283, -0.00011169558, -3.6875074e-06, -0.0021161041, 0.0015416857, 0.0026218528, 0.0004946421, -0.0029119428, -0.0026743447, -0.0016082572, -0.0019589171, 0.0009542701, 0.0024671415, 0.002911989, -0.0021694428, -0.0005767482, -0.0003681543, -0.0032621045, 0.0025553675, -0.00035983368, -0.0014328742, -0.0012571189, 0.002063522, -0.004186249, 0.002871655, -0.0014956872, 0.0030899472, -0.0043049706, -0.0025391937, 0.0036900516, 0.001305988, 0.0071962285, 0.0002698057, 7.167885e-05, -0.00035575274, -0.0018463661, 0.0009735834, 0.0027338217, 0.0006053451, -0.0019731661, -0.0025991148, -0.0027744377, -0.0025126273, 0.00072156, 0.003428927, 0.0031567204, -0.002448692, -0.0004075608, -0.00057270785, -0.0030838777, 0.0026818882, -0.00047162175, -0.0012358986, -0.0010987468, 0.0022459626, -0.004585875, 0.0030824183, -0.0017394223, 0.0022945576, -0.0038800354, -0.0030308093, 0.0039874185, 0.0013819047, 0.006981118, -0.0012621798, 0.003073403, 0.0063935937, -0.012122964, -0.020222409, -0.009257796, -0.014305391, 0.03304799, 0.014500761, -0.012157507, -0.009399721, -0.009370865, -0.007807347, 0.007644711, 0.01974464, -0.005240816, -0.004368141, 0.011490372, -0.016266968, 0.011638305, -0.010275215, 0.02725153, -0.0029485947, -0.005270232, -0.0002522301, 0.007406287, 0.020192744, -0.0038480558, -0.009051812, 0.0008786861, 0.00014271855, -0.009977501, 0.00056362385, 0.0002541869, -0.00017798167, -0.0018467816, 0.001176424, 0.002708821, 0.00029104188, -0.0019082995, -0.0029174404, -0.0024369, -0.0021025524, 0.0007645086, 0.003366295, 0.002969441, -0.0025625841, -0.00036104332, -0.0004759863, -0.0028440186, 0.0025115765, -0.0006406618, -0.0012999126, -0.0011924814, 0.0015906399, -0.0039258962, 0.0026490246, -0.0016946257, 0.0022309604, -0.0037268954, -0.002888752, 0.0040505, 0.0010705611, 0.0068052113, -0.0010498636, -1.1601282e-05, 0.009884488, -0.0006051408, 0.0064786514, -0.004522288, -0.00086696853, 0.010882683, -0.0117623275, -0.0027444311, 0.012794863, -0.005642911, 0.00088609615, 0.007871915, -0.0042518745, -0.008205962, -0.0049285907, -0.0055895234, -0.0071403156, 0.007744984, 0.0036990524, -0.0080992365, 0.0005835998, 0.003571454, 0.009005109, -0.0052454197, -0.0031528373, -0.0074669383, -0.014977699, 0.010891873, 0.0093957465, 0.0025734142, 0.0071177953, -0.0076645967, 0.020112816, -0.00277334, -0.0034811117, -0.015971873, -0.008886022, 0.008515522, -0.008860389, -0.003919972, 0.00481707, -0.0013749637, 0.012228667, 0.013997253, -0.009086096, -0.008974741, -0.0012351132, -0.011276664, -0.0059794215, 0.0056286333, -0.0026417505, -0.014663347, 0.00079001463, 0.01451754, 0.0071595605, 0.010945, 0.010404471, -0.016760224, -0.0020245765, 0.0031603759, 0.0032848846, 0.0028946009, 0.00023738416, 0.00023473105, -0.00023828138, -0.0019542684, 0.0011541618, 0.0029781389, 0.0001236063, -0.0022027353, -0.0029665183, -0.0023489108, -0.0023407072, 0.001300514, 0.0030227746, 0.0035676167, -0.0023048955, -0.00012695957, -0.00082963856, -0.0031259519, 0.0025817784, -0.00038753994, -0.0012521402, -0.0010352802, 0.0017939192, -0.004601099, 0.0027301228, -0.0022969123, 0.0025228932, -0.003754175, -0.0031607966, 0.0043361154, 0.001191885, 0.007151171, 4.765373e-05, 8.49162e-05, -0.00030616947, -0.0020987298, 0.0010782973, 0.0027658641, 0.00066828955, -0.0024185868, -0.0025131786, -0.0025361623, -0.0025745623, 0.0011082533, 0.0030848933, 0.003322216, -0.002311526, -0.000278804, -0.00083664584, -0.0030040694, 0.0027401147, -0.00043859895, -0.0011914689, -0.0012279397, 0.0020578373, -0.004929436, 0.002900225, -0.0019654573, 0.0029045823, -0.003931063, -0.0030519066, 0.0042608585, 0.0011615361, 0.007428766, 0.0048490902, -0.002046424, 0.009946775, -0.0025807964, 0.0017161572, -0.005522685, -0.0064416286, 0.0005553493, -0.0065212683, -0.0037706855, 0.0002262711, -0.0013042956, 0.0064022215, 0.0070120655, -0.0008063016, -0.006950697, 0.0015051803, -0.005627674, -0.006767653, 0.008283224, -0.0024362984, -0.0062195435, 0.0021256383, 0.002203463, 0.003911863, 0.0034642387, 0.010521481, -0.010883953, -0.005703448, 0.0030239613, 0.0048005404, 0.0030358345, 0.000699086, 0.002387962, -0.009527735, 0.00047607673, 0.013156721, 0.014392342, -0.003462933, -0.008891825, -0.0034365351, -0.007584933, -0.0064538894, 0.007981909, 0.0064665005, -0.004707016, -0.010545989, 0.0048757573, -0.010051727, 0.0024295235, 0.010745063, -0.0051900363, -0.009149147, -0.006747576, 0.00040342426, -0.019604793, 0.008964578, 0.012419404, -0.00788454, 0.0024741958, 0.015829409, 0.011045376, -0.005910063, 0.004401397, 0.0002830573, 0.00017908934, 3.1403073e-05, -0.00158511, 0.0011116801, 0.002752691, 0.00043098384, -0.002157847, -0.0027189802, -0.0028915491, -0.002165893, 0.0011739561, 0.0033160357, 0.0031427022, -0.002184738, -0.00028342355, -0.0010671854, -0.0034092586, 0.0028737355, -0.00045730677, -0.0010408729, -0.0013769083, 0.002178974, -0.0050255377, 0.0031380267, -0.0024970465, 0.002816115, -0.0041632126, -0.0029921732, 0.0041289153, 0.0013363411, 0.007123341}},
    {"bert.embeddings.position_embeddings.weight_grad", std::vector<double>(bert_embeddings_position_embeddings_weight_grad.begin(), bert_embeddings_position_embeddings_weight_grad.end())},
    {"bert.embeddings.token_type_embeddings.weight_grad", {0.009861492, -0.0030909847, 0.013591753, -0.0023054278, 0.0058707986, -0.014464747, -0.0106031615, 0.007915597, -0.009053563, -0.0013863116, 0.005876172, -0.0033882926, 0.0043475777, 0.007257924, -0.0038289824, -0.006026322, -0.0012537953, -0.014294342, -0.011831209, 0.012194967, -0.0066924756, -0.010392958, 0.0039682346, 0.012561913, 0.007764792, 0.014275922, 0.008866439, -0.0067554764, 0.0024840808, -0.0033924747, 0.00055338116, -0.0086305225, -0.0044082655, 0.0022550726, -0.0078732725, -0.010640278, -0.0035971017, 0.0050297854, -0.009478568, 0.02547815, 0.012840041, -0.014007731, -0.008483045, 0.00537509, -0.012330426, -0.007031329, 0.010881772, 0.0048693954, -0.0056274254, 0.0077398717, -0.0015601134, 0.004838918, -0.011368475, 0.013950618, 0.0004504691, -0.011796904, 0.009869196, 0.02464096, 0.0003120536, 0.011567634, 0.010819629, -0.013375202, -0.009553628, -0.019786898, -0.026015956, 0.007938246, -0.026507601, -0.016323723, -0.01762755, 0.008817102, -0.026307564, 0.07222123, 0.018280337, -0.017263245, -0.020372959, 0.011089225, -0.01700878, -0.02449326, 0.019908598, 0.010436715, -0.017543968, 0.043500975, 0.009581541, 0.0041474975, -0.007507718, 0.027453853, -0.01756276, -0.020918682, 0.0032237307, 0.02903208, -0.013957954, 0.026368175, 0.02175815, 0.015069164, -0.0069283857, -0.05248654, 0.002168084, -0.00076877, 0.033151057, -0.013395623, -0.009311788, -0.024175376, -0.027121916, 0.032945216, 0.00074468297, -0.0053926758, -0.00017712219, -0.007199483, 0.0018561464, 0.009962061, 0.0064980076, -0.005447127, 0.0077884914, -0.015541087, -0.03484179, 0.030410945, -0.0071777566, -0.011565301, 0.007086238, 0.02244132, 0.013890794, 0.03238161, 0.015618763, -0.01798315, 0.0043046186, -0.017706642, 0.0022910896, -0.025733516, -0.009361861, 0.0031651908, 0.0027392562, -0.011642157, -0.0009564422, 0.001929264, -0.02544681, 0.032623984, 0.0016172249, -0.008757899, -0.003987152, 0.0077234055, -0.004132104, -0.017210549, 0.0028588213, -0.0026315348, -0.0029040503, 0.0019831192, -0.0015297756, 0.02294194, -0.009355533, -0.0046804277, -0.0012767883, -0.0051029613, 0.006177634, 0.03733815, 0.009306993, 0.0028611373, 0.02068811, -0.004864044, -0.0023681577, -0.037745994, -0.0041679516, 0.0015863172, -0.011717057, -0.005759027, -0.020311277, 0.00059181603, -0.011084055, 0.025824577, 0.019760914, -0.004142615, -0.01865638, 0.0026359046, -0.007735245, -0.005057967, 0.011681769, -0.0011424775, -0.004564693, 0.012951258, 0.0035222718, -0.003770749, -0.0009590378, 0.025996549, -0.0054898895, -0.0063981796, -0.009731363, 0.0039464016, 0.012707899, 0.00507726, 0.00625598, -0.002550175, -0.001164134, -0.008136647, 0.019111477, 0.005232859, 0.00495644, -0.004493946, 0.040123954, 0.0056162644, -0.03494628, 1.5479978e-05, -0.018604254, -0.008570064, 0.0029622077, 0.013375602, 0.003567865, -0.006246203, -0.021691928, 0.0043489044, -0.024660675, -0.013252768, 0.0038702954, 0.019245835, -0.033295676, -0.035311338, 0.0036338756, -0.011085553, 0.023488289, 0.05734553, 0.00078753894, 0.014398817, 0.039275408, 0.0026983707, -0.012919213, -0.038977116, 0.011858848, -0.003789204, 0.03332205, -0.015602473, -0.011496974, -0.03384818, -0.030712858, 0.034600638, -0.002576483, 0.0012814915, 0.011114152, -0.004078648, 0.009274085, 0.0179973, 0.007753067, -0.02269656, 0.005634091, -0.024006244, -0.026878338, 0.030132083, -0.0053250273, -0.022222953, 0.0032629974, 0.04098449, 0.0069683744, 0.02097217, 0.029564144, -0.019065196, -0.00511802, -0.019226434, 0.010999532, -0.029075911, -0.0008958073, 0.012643614, -0.05608506, -0.0072923894, 0.03937384, 0.059201065, -0.026361523, -0.0056958366, 0.011968542, -0.029491989, -0.02934218, 0.034619153, -0.013516829, -0.043380026, 0.003062591, 0.03267098, -0.034817535, 0.020511298, 0.035271104, 0.0023437233, -0.03587846, -0.0008190819, -0.0036933934, -0.07043845, 0.024075866, 0.060118526, -0.030619277, 0.05139529, 0.06954001, 0.0002973769, -0.025799345, -0.042965792, -0.019094355, 0.009590443, -0.007524764, -0.018022511, -0.0010530767, 0.005520784, -0.022753326, 0.05464682, 0.009793585, -0.005350517, 0.00027782447, 0.0052585956, -0.025627, -0.018606981, 0.016900247, -0.0020661352, -0.012528236, 0.00990032, -0.0013183856, 0.018476557, -0.001738183, 0.014049713, -0.0052055884, -0.008190643, 0.007980933, 0.01682345, -0.007466244, 0.01589565, 0.0066708564, -0.0013899824, 0.005107644, -0.03895749, -0.02189229, 0.0011266377, -0.0051833233, -0.020826835, -0.003332233, -0.00069175195, -0.037941422, 0.06965829, -0.0020412884, -0.012649458, 7.325434e-05, 0.009350402, -0.019709898, -0.015626293, 0.025077896, -0.009718373, -0.028073281, 0.02625593, 0.0055859196, 0.02481181, -0.005582753, 0.016053593, -0.0184639, -0.005281822, 0.011261847, 0.03434932, 0.0023175273, 0.009324018, 0.011064678, 0.0008713681, -0.0078909835, -0.032276582, -0.0025375588, 0.0007278591, -0.002141838, -0.0065759663, -0.00084148254, 0.0039617633, -0.010956049, 0.010969842, 0.0049345572, -0.004988917, -0.0034721987, 0.0018704375, -0.0036845226, -0.008076904, 0.0043729916, 0.0055188355, -0.0070880814, 0.00372977, 0.00034216698, 0.011311488, -0.009379438, 0.0029336133, -0.00018810271, -0.005563192, 0.00487982, 0.014203299, 0.0034711012, 0.0036783838, 0.011073518, -0.003862137, -0.0033037951, -0.015319267, -0.0059544602, 0.0077692666, -0.016279053, -0.0045934273, 0.026160419, 0.025655879, -0.015384896, 0.011700445, -0.005675628, -0.012599562, -0.0027165916, 0.01200662, -0.007479347, -0.02187929, -0.003792433, 0.0123486705, -0.021392513, 0.013935043, 0.0118260365, 0.009300662, -0.021519313, -0.010708839, -0.004828757, -0.031539194, 0.019091932, 0.037005752, -0.024503669, 0.024372987, 0.030933201, 0.0109671345, -0.0128225265, -0.029404549, 0.0047040824, 0.0031992306, -0.0057427445, 0.0030587176, 0.030159438, 0.0116053, -0.012182528, -0.0036444906, -0.013380468, -0.008974118, 0.00894435, 0.007580188, 0.0061287405, -0.009802819, -0.010905828, 0.0022288924, -0.01800173, 0.01182248, 0.0013798233, 0.009910165, -0.016020667, -0.01940729, -0.004925746, -0.016917888, 0.016901165, 0.02416109, -0.014958901, 0.009879685, 0.015272818, 0.014554979, -0.0068978188, -0.019728122, 0.0060340688, -0.0010410581, -0.001194492, -0.003636451, -0.00107297, -0.007724184, -0.009635925, 0.017968059, 0.0007841219, -0.00678654, -0.0023096113, -0.0026166206, -0.000832575, -0.0011826847, 0.0024341317, -0.004546971, -0.013568386, 0.008887105, 0.0008107559, 0.0015832921, -0.010033727, 0.008138211, -0.009574367, -0.004400424, 0.004787254, 0.019033518, 0.006824797, 0.0071763312, 0.006221891, 0.009308463, -0.00994106, -0.009893951, 0.015196445, -0.007118376, 0.03964389, -0.007868402, 0.020599354, -0.038666364, -0.048962843, 0.043257277, -0.033149265, 0.0057367184, 0.019187208, -0.0042767012, 0.019828873, 0.015786614, -0.030813446, -0.01174179, -0.017199056, -0.022331137, -0.032972716, 0.043932386, -0.018505244, -0.038241245, 0.0008711538, 0.046217036, 0.027597895, 0.055955917, 0.006168975, -0.013221774, 0.0161911, 0.01020639, 0.0076408144, -0.06894969}},
    {"bert.embeddings.LayerNorm.weight_grad", {-0.0021369501, -0.0015581558, 0.0010946481, 0.002412255, 0.003989072, 0.0027359652, -0.00016151473, -0.00083480123, -0.0029047574, -0.0021610183, 0.0012508894, -0.0003233871, -0.0023219283, -0.00026789223, -0.0027552636, -0.00035624453, 0.0016456329, -0.00014724248, -0.0029568055, -0.0003587525, 0.0051661264, -0.00451526, -0.0005047021, -0.0020318907, 0.0007076218, 0.0031790552, 0.00027941455, -0.0021429544, -0.0024273228, 0.0014925286, 9.05974e-05, 0.0068187974}},
    {"bert.embeddings.LayerNorm.bias_grad", {-0.0008091579, 0.0013487801, -0.00048883504, -0.004919336, 0.0029671811, 0.00020613123, -0.01184393, 0.0145161515, -1.0306255e-05, -0.004469541, -0.0013056969, 0.0028809786, -0.002462303, -0.004241116, 0.0016550634, 7.1290444e-05, -0.0064726267, 0.0024780787, -0.0013171267, 0.008034047, -0.0065535754, -0.0011969577, -0.0018098808, -0.0025135726, 0.005807951, 0.015669605, 0.0002959183, 0.004252731, 0.008501033, -8.851112e-05, -0.0022631388, -0.015858471}},
    {"bert.encoder.layer.0.attention.self.query.weight_transposed_grad", {-2.48301e-06, 1.88821e-06, -7.54167e-08, 2.2892e-06, 9.01317e-08, -2.60107e-06, 5.05286e-07, -1.66657e-06, 2.24583e-08, -1.94205e-06, -6.3223e-08, -1.04916e-06, -1.0173e-06, 3.24326e-07, 1.25927e-06, 3.81775e-08, 6.50228e-07, 5.52192e-07, -6.40031e-07, -3.45582e-06, 1.97231e-06, -4.97743e-07, 3.36068e-07, -2.64159e-06, 9.75928e-08, -1.43261e-06, 1.78048e-08, 3.32396e-07, -4.9941e-07, 4.22512e-07, -2.5403e-07, -2.17368e-06, 4.87577e-06, -3.78378e-06, 9.39387e-07, -3.71243e-06, 2.98022e-06, -1.72966e-06, 9.99721e-07, 2.62417e-06, -6.38187e-07, -2.25155e-07, 4.94047e-07, 8.61581e-07, -1.16235e-07, -6.15045e-07, -1.26095e-07, -3.95922e-07, 4.0195e-07, 4.05049e-08, 6.27295e-07, 3.81569e-07, 5.7868e-08, 3.76058e-07, -1.10349e-07, -1.31633e-06, -6.71208e-07, -8.50684e-07, -1.6507e-07, -9.07481e-07, -1.06576e-07, 9.91598e-07, 9.69573e-07, 1.25902e-06, 4.07041e-06, -1.01213e-06, 1.49591e-06, -1.42603e-06, -1.66042e-06, -1.07894e-06, -6.42906e-07, -3.68005e-07, -9.96009e-08, 1.24623e-06, 1.3036e-06, 4.48382e-06, 1.36087e-06, -1.60686e-06, -4.92821e-08, -9.83309e-07, -1.32092e-06, 7.00333e-07, -6.17351e-07, 8.59401e-07, 1.18912e-08, 1.60234e-06, 1.47124e-06, 2.059e-06, -4.39272e-07, -9.47439e-07, -3.6857e-07, 8.20205e-07, 1.46364e-07, -1.98234e-07, -4.62237e-07, -3.37501e-06, -3.10741e-07, -2.30197e-07, 6.75227e-07, 1.71785e-07, 1.88586e-06, -1.58441e-06, -1.34179e-07, 1.76492e-06, -1.63193e-06, -7.26866e-07, 1.01957e-06, 1.83881e-06, 2.50208e-06, -2.01462e-06, -4.74465e-07, -3.0233e-07, -2.20471e-08, 1.86429e-06, -3.13788e-07, -1.38556e-06, -7.68489e-09, 1.40413e-06, -1.3319e-06, -3.16133e-06, 2.28389e-07, 2.67267e-06, 4.86224e-07, 2.59015e-06, 1.81525e-06, -9.47379e-07, 2.23417e-06, -6.6648e-07, 4.34778e-07, -9.72809e-08, -5.85955e-07, -1.16285e-06, -1.51348e-06, 1.13438e-06, -1.10112e-07, -6.84097e-07, 1.90599e-06, 4.35006e-06, -1.69898e-06, -2.70454e-07, -2.02208e-06, 1.68436e-06, -1.08896e-06, -8.54717e-07, -8.00081e-07, 7.35934e-07, 2.49978e-07, 2.31889e-06, -9.42926e-07, 4.24083e-07, 1.11888e-06, 9.49397e-07, 8.57191e-07, -2.76056e-06, -1.43558e-06, -1.15445e-06, -1.07339e-06, 7.89267e-07, -9.21264e-07, -2.21596e-06, -1.41063e-06, 5.94071e-07, 6.57242e-08, 1.27613e-06, -1.24579e-06, 9.79603e-07, -9.66788e-07, -4.83277e-07, -1.79367e-07, 1.28029e-06, -9.25387e-07, 2.4515e-06, -1.7873e-06, 1.42031e-06, -5.51887e-07, -5.80791e-07, -1.97167e-07, -2.22411e-07, 1.17304e-07, 1.82398e-07, 2.29537e-07, -1.51144e-06, 1.2085e-06, 3.09274e-07, 1.62854e-06, 1.97668e-07, -6.77997e-07, 3.6235e-06, 5.29859e-07, -1.94102e-07, -1.14365e-06, -1.38722e-06, 3.78674e-06, -1.72797e-06, 7.90954e-07, -2.27328e-06, -5.5786e-07, 1.04539e-06, 3.49883e-07, 2.36844e-06, 2.83761e-07, -6.00731e-07, -4.80265e-07, -1.08642e-07, -1.98229e-07, 3.98594e-08, -4.53816e-07, 4.65538e-07, 4.49724e-07, -1.09359e-06, 3.1439e-09, 8.3665e-09, -1.18053e-06, 7.78656e-08, -7.1847e-07, -5.30099e-07, 6.36195e-08, 1.39923e-06, -5.31126e-08, 1.82731e-06, 8.98814e-07, -9.71298e-07, -7.73492e-08, -7.24783e-07, 2.81776e-06, 1.10998e-07, -6.11075e-07, -1.80155e-06, -6.68877e-07, 2.49251e-07, 8.05398e-08, 3.43823e-07, -5.87333e-08, 1.06202e-06, 9.78388e-07, -3.41457e-08, -1.48034e-06, -2.66026e-07, 1.31758e-08, -1.64008e-07, 4.74758e-07, -2.11815e-07, 8.83932e-08, -5.47758e-08, -4.48022e-07, 1.08675e-06, -2.52813e-06, -1.83416e-06, -4.48091e-07, 1.26105e-06, 1.4694e-06, 1.45248e-06, 3.05953e-07, -9.35752e-07, 3.81048e-07, 1.39977e-06, -2.55007e-06, 4.26698e-07, -2.17673e-06, 1.4105e-06, -1.96069e-06, 3.59875e-06, -1.03827e-07, -1.38409e-06, 2.8762e-06, 1.20263e-06, -7.8244e-07, -7.97523e-07, -3.19291e-06, 2.42148e-06, 3.65347e-07, -1.43094e-06, 1.08034e-06, 1.26799e-07, -2.04035e-06, -8.74051e-07, -2.94418e-07, 4.5119e-07, 1.94347e-06, 9.87799e-07, -9.50428e-07, -2.56792e-06, 1.80176e-07, -4.94781e-06, -8.68024e-07, 7.272e-07, -1.47668e-06, 7.27176e-07, -1.7854e-06, 5.12136e-07, -7.20401e-08, 2.8538e-06, -1.06012e-06, 4.84639e-07, -1.42827e-06, -3.088e-06, 1.56503e-06, -2.33361e-06, -6.6389e-07, -1.69193e-06, -8.42673e-07, 1.61066e-06, 4.38958e-07, 1.19628e-06, 1.82187e-07, -3.15024e-07, 7.49113e-07, -3.6954e-07, 7.94947e-07, 4.04411e-08, -5.415e-07, -5.05632e-08, 5.77662e-07, -2.84253e-06, -1.86622e-06, -3.84501e-06, -3.74133e-07, 1.09735e-06, -2.0533e-06, -2.94809e-06, -6.12207e-06, 3.38881e-06, -1.06215e-06, 4.53465e-06, -1.3108e-06, -3.22276e-07, -5.8194e-07, -3.03191e-06, -8.47663e-07, 1.36673e-06, -1.83517e-07, -4.92874e-07, 3.7375e-07, -6.82066e-08, -4.93179e-07, 2.32331e-07, 6.89995e-07, 7.96477e-07, -1.08978e-07, -7.89827e-07, 5.75957e-07, -9.96482e-09, 1.70954e-07, -1.09255e-06, 5.48205e-07, 6.17501e-07, -6.3885e-07, 3.068e-06, 2.33305e-07, -1.13907e-06, -7.00674e-07, -2.1276e-06, -5.05721e-07, 4.5855e-07, -1.07549e-07, -2.73753e-07, -7.12717e-07, 1.58484e-06, -1.22668e-06, -1.25972e-07, -1.36885e-06, 5.67887e-08, 5.91658e-07, -8.27906e-07, 1.59936e-06, -7.45163e-07, -3.4344e-07, 8.43044e-07, 5.13086e-07, 8.04004e-08, 1.41281e-06, 1.27752e-08, 1.05443e-07, -2.15518e-07, -1.73415e-06, -1.47873e-06, 8.96094e-07, 2.2996e-06, -3.7852e-07, 3.97837e-06, 1.00287e-06, -1.42863e-06, 7.75188e-08, 1.32087e-07, 7.17156e-07, -7.63364e-07, -1.20468e-07, -7.69195e-07, -7.33636e-07, 2.75449e-06, -1.33326e-06, 2.00722e-07, 9.5052e-08, -2.00903e-06, -6.10984e-07, -2.53235e-06, 7.85458e-07, 4.01827e-07, -4.18971e-07, 7.68082e-07, 1.29454e-06, -2.79235e-07, 7.37756e-07, -1.56304e-06, 2.55663e-06, -1.43718e-06, -6.56674e-07, -8.13429e-07, -6.5385e-07, 1.26302e-06, 7.65898e-08, -1.90961e-06, 7.21511e-07, -8.37554e-07, 4.08201e-07, 1.62955e-06, 2.846e-06, 8.04602e-07, 6.9696e-07, 2.59015e-07, 1.291e-06, -5.24885e-06, 4.52529e-07, -1.50879e-06, -7.18581e-07, -1.76616e-06, 8.35682e-08, 3.80824e-07, 1.45107e-06, -5.32841e-07, 4.89093e-07, -2.78165e-08, 1.58091e-07, 1.63298e-07, 3.11015e-07, -2.2557e-06, -2.37213e-08, 9.67317e-07, -8.70373e-07, -3.37521e-06, -1.75848e-07, 1.16225e-06, 1.54541e-08, 3.52562e-06, 1.03725e-06, -1.20325e-06, 1.38582e-06, -7.72928e-07, -3.83716e-06, 1.38502e-07, -2.59412e-07, -6.24401e-07, -1.78316e-06, 3.31372e-06, -5.84246e-07, -1.73022e-07, -4.31404e-07, 9.36986e-07, -6.78787e-07, -1.36261e-06, -1.60553e-07, 5.92878e-07, -9.97801e-07, 1.78163e-07, 5.43663e-07, 1.67031e-06, 1.51e-06, -1.62e-06, 1.93326e-06, 1.36213e-07, -1.00476e-06, -3.47785e-06, 1.01612e-06, -4.52852e-07, 3.0328e-07, -1.40468e-06, -1.30757e-06, -1.09113e-07, -2.78265e-07, 4.10397e-07, -6.94905e-07, -9.55451e-07, -7.19155e-07, 9.47642e-08, -2.6057e-06, 5.13829e-06, -6.85445e-07, 7.8811e-07, 5.13512e-07, -6.92007e-07, 5.21886e-07, -9.10439e-07, -4.88508e-07, 5.41224e-07, 1.63041e-06, -4.22127e-07, 7.81395e-07, -8.98068e-07, -5.48979e-07, -5.21259e-07, 9.74351e-08, 5.0348e-07, 9.36322e-07, 9.33063e-07, -1.6465e-07, -2.63422e-06, -8.18719e-07, -4.73741e-06, -1.10577e-06, 1.67155e-06, -2.09369e-06, -4.46714e-08, 1.97043e-06, -6.35044e-07, 1.39928e-06, -1.03591e-06, 6.46954e-07, -1.7225e-06, 3.61256e-07, 1.41818e-06, -1.50412e-06, 3.16255e-07, 9.77624e-07, 4.01882e-07, 1.70344e-06, -1.23827e-06, -1.0238e-06, 5.19707e-07, -1.95092e-07, 5.55922e-07, -3.64303e-08, 3.33321e-07, 1.98777e-07, 7.46836e-07, -1.61413e-06, 2.4939e-07, -2.15539e-07, 3.3515e-06, 1.18185e-06, 3.71108e-06, 9.56118e-07, -9.99487e-07, 1.08845e-06, 2.48785e-06, -3.78932e-06, 5.08403e-07, 7.16565e-07, 3.74967e-06, 3.05106e-06, -5.92696e-06, 1.39664e-06, -3.50898e-06, 4.47699e-07, -1.68657e-06, -8.7129e-07, -1.796e-06, 6.05946e-07, 8.42404e-07, -1.28994e-07, -1.17914e-07, 1.55285e-06, 4.41425e-07, 1.05294e-06, -3.74067e-06, 1.52451e-07, -1.33427e-06, -1.35458e-06, -4.23303e-06, -1.49848e-07, -2.79419e-07, 1.08164e-06, 2.15767e-08, -2.38501e-07, 1.50106e-08, -1.92949e-07, -9.94465e-07, 7.43765e-06, -1.07687e-06, 1.70714e-06, -2.93758e-06, 3.57018e-06, -6.42059e-06, 1.217e-06, 2.3169e-06, -1.97126e-06, -1.99691e-06, 1.77152e-06, 1.02397e-06, 1.20247e-06, -1.55621e-06, 6.41332e-07, 6.79511e-07, -1.75333e-06, 7.36177e-07, -1.08092e-06, 3.18252e-06, -1.80558e-06, 4.95903e-07, -1.20005e-06, 3.31351e-06, -4.14873e-07, -2.89165e-07, 8.2715e-07, -5.82768e-07, -4.67169e-07, 1.37889e-06, 8.59011e-07, 1.59362e-06, 3.76095e-06, -1.73261e-06, 1.47483e-06, -2.24168e-06, 3.03765e-06, -1.97913e-06, 1.08085e-06, 3.22297e-06, -1.16772e-06, -8.04659e-07, 1.94586e-06, 2.91112e-06, 1.91909e-06, -2.31283e-06, 5.55434e-07, 3.5123e-07, -1.58474e-06, -8.29941e-07, -3.79845e-07, 4.47874e-06, -1.30543e-06, -9.59315e-07, 2.09952e-06, 5.73123e-06, 2.34216e-07, 2.04608e-06, 2.50749e-07, 1.52477e-06, 8.33501e-07, 1.04082e-06, 9.04753e-07, 3.38524e-06, 3.30466e-06, -3.2892e-06, 1.27916e-06, -2.86273e-06, 6.66389e-06, -5.19487e-06, 2.30414e-06, 3.26937e-06, -2.27896e-06, -8.33952e-07, 1.77709e-06, -3.60666e-07, 2.43165e-06, -2.61487e-06, -9.89069e-07, 8.57501e-07, -2.73353e-07, 1.81515e-07, 8.13873e-07, 2.91912e-06, -2.56808e-06, 4.78897e-07, -2.08299e-06, 2.00199e-06, -1.64049e-06, 3.64995e-06, 1.44051e-06, 2.43205e-06, 1.23412e-06, -7.31724e-07, 3.16659e-06, 4.84085e-06, 9.57311e-07, 4.62271e-07, -1.09364e-06, -1.29633e-06, -5.15224e-07, 6.17128e-07, 8.76136e-07, 3.63421e-07, 1.57847e-06, 2.13685e-06, -8.40558e-07, 1.34937e-06, -2.03669e-06, 9.05471e-07, 1.56422e-07, -1.10999e-06, -3.12604e-07, -2.46257e-07, -1.09489e-06, -1.64955e-07, -7.78609e-07, 3.45482e-07, 2.27975e-07, 1.27553e-06, -5.65427e-07, -1.47098e-06, 6.13034e-07, -1.74382e-06, -7.22052e-07, 3.98606e-07, -3.00049e-07, 1.1589e-06, 8.57446e-07, -1.6548e-06, -7.30961e-08, -1.22041e-06, 2.86066e-06, -5.78523e-07, 1.15629e-06, 1.14831e-06, 7.65737e-07, -2.29001e-06, -4.65747e-07, -2.61455e-06, -2.73672e-07, 3.14256e-07, 1.26862e-06, 5.20518e-07, -9.83233e-07, -2.46607e-06, 9.42147e-07, 3.2474e-06, -2.81387e-06, -1.20858e-06, 1.66663e-07, 3.28233e-06, -1.10785e-06, 1.44586e-08, 5.01271e-07, -2.06029e-06, -7.88659e-07, -1.7152e-07, 1.03957e-07, 2.48073e-06, -6.9399e-06, 3.15465e-06, -2.13959e-06, 3.59017e-06, -7.89229e-07, 1.40344e-06, 4.50639e-07, -3.374e-06, 2.13117e-06, -6.05782e-07, -1.92174e-06, -1.62161e-06, -2.76534e-06, 2.36295e-06, 3.46785e-07, 7.71214e-08, 1.25393e-07, -2.10928e-07, -1.16726e-06, -1.79896e-06, 4.39347e-07, -3.23023e-07, 2.55835e-07, -4.49541e-07, 3.93631e-07, -1.96474e-06, 5.03621e-07, -2.03583e-06, -1.75389e-06, 9.77818e-07, -6.93751e-07, -1.18654e-06, -2.82618e-06, 1.00578e-06, -1.16138e-06, 1.56488e-06, 1.39798e-07, -2.9458e-07, 1.13188e-06, -1.35169e-06, 1.78218e-06, 8.4084e-07, -1.33163e-06, 6.08537e-07, -2.21785e-06, 1.41954e-06, -3.79354e-07, -7.3663e-07, 6.4102e-08, -1.91202e-06, -8.88375e-07, -1.26669e-06, -1.04355e-06, -7.15591e-07, -4.57754e-09, 7.2183e-08, -1.02501e-07, 1.47752e-06, 6.40037e-07, 2.92258e-06, 3.96616e-07, -1.89113e-06, -2.15564e-07, 6.34547e-07, -4.07205e-06, 2.3024e-06, 1.47228e-07, 2.45768e-06, -6.86425e-06, 6.7635e-06, -3.43224e-06, -1.01204e-07, 1.8588e-07, 1.19399e-06, -3.17807e-07, -1.15893e-07, 2.20251e-06, 2.16051e-08, 1.6251e-07, -2.55005e-07, -4.4899e-07, 9.95555e-07, -4.13782e-07, 1.45475e-07, 1.71072e-07, 1.29049e-06, 1.79177e-06, 5.15477e-08, 1.44678e-07, 1.38621e-07, -2.17171e-06, -9.44988e-09, 6.58844e-07, -2.14193e-06, -1.4282e-06, -4.14936e-06, -8.42763e-06, 3.26133e-06, -4.11948e-06, 2.44919e-06, -4.74071e-06, 1.04074e-05, -1.76301e-06, -2.36062e-06, 3.27286e-06, 3.68926e-06, -2.82771e-06, -1.79175e-07, -1.45659e-06, 2.15133e-06, -3.72191e-08, -7.48971e-07, 9.27806e-07, -1.23872e-06, 4.41695e-07, -6.53705e-07, 1.27719e-06, -2.04411e-06, 3.78169e-06, 1.34419e-06, 1.54619e-06, -1.46581e-06, -1.16479e-06, -3.62387e-06, -8.64931e-07, 9.05274e-07, -1.57568e-06, -1.98913e-06, 1.2217e-06, -1.94094e-06, 1.64742e-06, -1.16919e-06, 4.64429e-07, -1.13387e-06, 1.16448e-06, 1.05268e-06, 6.44057e-07, 3.28594e-06, -8.42455e-07, 1.36543e-06, -1.09645e-06, -2.84838e-07, -6.65733e-07, -1.18451e-06, -1.83921e-08, -6.24454e-07, 6.12511e-07, 1.35329e-07, 1.11451e-06, -1.69003e-06, 1.85662e-06, 1.73623e-06, -6.88537e-07, -1.32289e-06, -1.38507e-07, -8.43957e-07, -6.18471e-07, 8.93933e-07, 1.44251e-08, -1.3496e-06, 2.52557e-06, -8.32752e-07, 1.81004e-06, -8.51639e-07, 1.80197e-06, -2.92641e-06, -9.42574e-08, 1.66229e-06, -1.50197e-06, -7.10131e-07, 1.19847e-06, -1.88438e-07, 2.55186e-06, -1.54741e-06, -1.04068e-06, 5.27207e-07, -5.13013e-07, 3.02214e-07, 6.77027e-07, 3.96478e-07, 1.37257e-06, -3.68692e-07, -8.06326e-07, 8.74762e-07, 1.67266e-07, 1.82059e-06, -4.35796e-08, 1.50119e-06, 1.07348e-06, -9.87987e-08, 1.54543e-06, 1.88995e-06, 1.10879e-06, 2.6773e-07, -1.60253e-06, -6.65331e-07, -1.43784e-06, 3.40312e-06, -2.30721e-08, 1.80866e-07, -5.89416e-07, -4.072e-07, 1.12609e-06, -2.06263e-07, 3.44677e-07, -9.33627e-07, 9.74413e-07, 4.3503e-07, -8.36264e-07, -1.50084e-07, -9.64527e-07, 1.34893e-06, -1.81637e-06, 2.41973e-06, -8.84816e-08, -4.03596e-07, -9.41795e-07, -2.41102e-06, -5.85686e-07, -5.89163e-06, -6.89871e-07, 1.34099e-06, -2.40595e-07, 7.74311e-08, 3.99493e-07, -3.22782e-07, -1.34736e-07, 4.32747e-07, 2.81642e-09, 6.60261e-07, -7.72576e-07, -3.05311e-07, -5.09231e-07, -4.10019e-07, 1.19194e-06, 8.34229e-07, -8.33148e-07, -6.03668e-08, 6.69903e-07, 5.77666e-07, -8.03082e-07, -1.09918e-06, 5.35457e-07, 2.27112e-06, -6.68972e-07, -1.91549e-06, 6.54558e-07, 3.66195e-06, 9.57391e-07, -4.96465e-07, -5.12934e-07, 2.7042e-06, 5.7309e-08, 6.1576e-07, -9.57405e-07, -8.75273e-08, 2.66216e-06, 7.70035e-07, 1.26859e-06, -8.09879e-07, 1.67387e-06, -4.79555e-06, 3.5554e-07, 7.90369e-07, -2.57308e-06, -2.92402e-06, 5.25097e-07, -1.35045e-06, 9.51653e-07, -6.57305e-07, 2.91074e-07, 1.04787e-06, 1.72213e-07, 1.85445e-06, -5.86949e-07, -1.70727e-06, 2.63656e-06, 1.38374e-06, -1.37264e-06, -3.97535e-06, -2.65754e-08, 8.17579e-07, 1.43106e-06, -3.37417e-07, -4.22744e-07, 7.32392e-07, 1.9264e-06, 2.08591e-06}},
    {"bert.encoder.layer.0.attention.self.key.weight_transposed_grad", {1.05132e-06, 1.17221e-06, -4.26293e-08, -2.55166e-06, 4.75953e-07, -9.29231e-07, 1.79594e-06, 3.19847e-06, 4.04926e-07, -3.65889e-08, -1.2646e-06, -1.76126e-06, 1.63828e-06, 6.63524e-08, 4.1459e-08, 1.40998e-06, -2.86732e-06, -3.48976e-07, 2.66573e-07, 7.58403e-07, 2.2524e-07, -3.17942e-07, 2.95027e-06, 1.20455e-06, -2.97733e-06, 2.81201e-06, -2.99776e-06, -1.27092e-06, -7.9038e-07, 2.03798e-06, 2.06973e-06, 1.72349e-06, -4.99314e-07, 2.01473e-07, 2.50935e-06, 1.56043e-06, -2.54839e-06, 4.58843e-06, -7.24185e-07, -2.86716e-06, 7.95886e-07, 1.7364e-06, -7.61913e-07, -4.91553e-08, -7.68878e-07, 5.53778e-07, 6.18796e-07, 2.14687e-07, -2.22306e-07, -2.37357e-06, -1.16814e-07, 7.40218e-07, -2.5002e-07, 3.53303e-07, -1.67037e-06, 6.53004e-07, 8.10942e-07, 1.46227e-07, 2.44835e-06, -1.25191e-06, 5.87054e-07, -7.77433e-08, 1.08174e-06, -8.71929e-07, -2.76705e-06, 1.04708e-06, 1.05441e-07, 5.88087e-07, -1.42322e-06, 2.49302e-06, -1.18687e-06, -1.05212e-06, 2.07857e-06, 2.21389e-06, -8.78113e-07, -5.22608e-07, -5.87871e-08, 1.99203e-06, 1.04891e-06, 1.64734e-06, 4.25235e-07, -1.78499e-06, -5.70389e-07, -9.42222e-07, -3.5315e-07, 6.92156e-07, -1.63683e-06, 6.10235e-07, 1.45791e-07, 1.96176e-07, 1.9055e-06, -1.07995e-06, 6.93992e-07, 1.01343e-06, 1.67495e-06, -1.12399e-06, 1.88967e-06, 1.69728e-07, -7.67185e-07, -1.33775e-06, 1.35004e-06, -1.92711e-06, 6.97889e-07, 1.45006e-06, 8.16427e-07, 3.60975e-07, -1.18356e-07, -6.41533e-07, 4.82862e-08, 7.14952e-07, -1.05377e-06, 6.46718e-07, -2.57667e-06, -3.75562e-07, -1.73204e-06, -7.27827e-07, -7.0256e-07, -3.1148e-06, 1.99117e-06, 4.10085e-07, -1.22978e-06, 1.41676e-06, -7.2949e-07, -1.62021e-06, -3.71493e-07, 1.74141e-07, 4.48613e-07, -2.93376e-07, 6.7468e-07, -1.50633e-06, 1.32472e-06, 2.03932e-06, -2.27866e-06, 3.94933e-06, -7.21479e-07, -2.80701e-06, -6.81264e-07, -3.60163e-07, 5.87926e-07, -1.66342e-06, -2.39742e-06, -4.33519e-07, -1.62637e-06, 5.68583e-07, -1.00424e-06, -1.38414e-07, -5.84616e-07, -1.6365e-06, -9.56056e-07, -1.35741e-06, 3.31954e-07, 3.17498e-07, 1.1773e-07, -2.44487e-06, 2.96008e-07, 1.09998e-06, -2.94397e-07, -2.86714e-07, -4.06195e-07, 5.97084e-07, -2.88345e-06, 2.01831e-06, -2.11948e-06, -2.78399e-08, 2.22624e-06, -2.51917e-06, -3.07793e-08, -4.41929e-07, 1.04733e-06, 2.22153e-06, -2.27073e-06, 7.90871e-07, 1.50678e-07, 1.10836e-06, 1.32549e-06, 4.64019e-07, -9.71508e-07, -6.28546e-07, 8.48461e-07, 6.24963e-07, 1.82969e-06, -4.36313e-07, 1.08636e-06, -9.41351e-07, -9.41199e-07, 6.39884e-09, -9.71212e-07, -7.47846e-07, -4.34371e-08, 5.13961e-07, -6.08521e-07, -3.32759e-08, -2.28973e-06, -3.25665e-07, 1.7678e-06, 4.70766e-06, -2.73281e-06, 4.37761e-06, -1.34074e-06, -5.11672e-06, -1.63305e-07, 1.1981e-06, 3.62888e-07, -2.65646e-07, -1.13811e-06, -1.03948e-06, -1.46917e-06, 1.56736e-06, -3.89284e-07, -1.46943e-06, 2.70082e-06, 2.44527e-06, 1.52014e-06, 9.4396e-07, -6.11982e-07, 3.58752e-07, -4.50042e-07, 1.11644e-06, -1.50569e-06, 4.95024e-08, -6.98688e-07, 4.13003e-07, -3.91359e-07, -5.41973e-07, 3.75858e-07, -5.38111e-07, 5.50212e-07, -3.77303e-07, 1.32477e-06, -2.26789e-06, 2.13685e-06, 1.11586e-06, -5.3064e-07, 1.06635e-06, 9.52874e-08, 3.3448e-07, 4.5124e-07, 8.24681e-08, 8.15647e-07, -1.85564e-06, 8.7807e-07, 7.02758e-07, -2.49824e-06, -4.2148e-06, -1.81826e-06, -2.00293e-06, -1.80863e-06, 9.84342e-07, 3.41784e-07, 1.85972e-07, 1.0711e-06, 2.5682e-08, 1.53678e-07, 1.02485e-06, -2.69867e-07, -1.63602e-06, 4.54691e-07, -3.81409e-07, -8.65947e-09, -3.48706e-06, -5.28878e-07, 4.4668e-07, -2.22293e-06, 4.4073e-07, 5.55343e-07, 7.1586e-08, 2.31608e-07, 1.08127e-06, -2.3842e-07, 1.5879e-06, 3.0487e-06, -3.72361e-07, 5.71063e-07, -5.1667e-08, -1.65029e-07, 2.54746e-07, -4.12132e-07, 1.48235e-06, -1.03792e-06, -2.82587e-07, 9.568e-07, -2.47375e-06, 2.0148e-06, 9.22229e-07, 9.65583e-07, -1.65713e-06, -2.44307e-07, 1.01349e-06, 1.16182e-06, -1.15274e-06, 1.35266e-06, 2.002e-06, -2.35982e-06, 3.46825e-06, -1.97291e-06, -3.46817e-06, 2.9286e-07, 1.39974e-06, 3.93379e-07, -1.88473e-06, -1.11797e-06, -1.91333e-07, -1.14996e-06, 1.87872e-06, -1.63452e-07, -1.21454e-06, 2.35935e-06, 2.32052e-06, -1.8101e-08, 9.69122e-07, 4.06868e-07, -2.69262e-07, -6.62414e-07, 8.7766e-08, -4.61763e-07, 8.3774e-07, -8.9421e-09, -1.51022e-07, -1.04568e-06, -3.8296e-07, -1.50328e-06, 6.85591e-07, -8.36629e-07, -7.7114e-07, -3.81354e-07, 5.86522e-08, -7.32668e-07, 3.73841e-07, 3.20235e-07, -6.40589e-07, -4.32761e-07, -4.80187e-07, 4.49183e-07, 4.48956e-07, 6.2069e-08, 5.11148e-07, -1.2303e-07, 1.11834e-06, -9.99268e-07, -1.47943e-06, 4.95363e-07, -3.72294e-07, 6.66778e-07, 5.79358e-07, -9.47791e-07, -1.46723e-06, -8.00862e-07, -2.37842e-07, -3.38303e-07, 2.44622e-07, 1.30732e-06, 2.4652e-06, 2.87926e-06, -1.16082e-06, -1.75837e-07, -1.98637e-07, 1.45778e-06, -2.30029e-06, 1.94463e-06, 1.79061e-06, -7.07773e-07, -1.77965e-06, 2.52438e-07, -2.14033e-06, 6.67305e-07, -8.38326e-07, -1.61453e-06, -9.86959e-08, -7.30083e-07, 2.36626e-06, -9.48693e-07, -1.53697e-06, -2.97834e-07, -1.71445e-06, 2.10784e-06, -6.88968e-07, -1.07417e-06, 5.24407e-07, -1.82131e-06, 4.96624e-07, -4.65995e-07, 1.59491e-06, -4.86746e-08, 5.5104e-07, 2.24503e-06, -5.8759e-07, 2.77176e-07, -1.01491e-06, 9.10281e-07, -2.81525e-06, 1.35178e-06, 2.19213e-06, -7.36522e-08, -3.81075e-06, 4.05746e-07, 1.3393e-06, 1.54697e-06, -6.8226e-07, 1.37148e-06, -7.0381e-07, 7.05008e-07, 2.56948e-06, 3.15911e-07, 3.04373e-07, 9.29409e-07, 1.3436e-06, 5.72217e-07, 3.21482e-08, 3.47117e-07, 2.02864e-07, -4.42767e-07, 8.3357e-07, 3.46536e-07, -1.12207e-06, -2.08915e-07, 1.90016e-06, 6.38279e-07, 1.24869e-07, -1.13936e-06, 4.54136e-07, 6.17846e-07, -3.70962e-07, 2.60682e-07, 7.9155e-07, -1.26782e-06, 8.69592e-08, 8.29333e-07, 9.85447e-07, -1.40265e-06, -9.7518e-07, -1.82551e-06, -3.36696e-07, -1.16012e-06, -1.43887e-06, 5.85108e-07, 4.47867e-07, -1.39475e-07, -2.12293e-06, 4.17127e-07, 4.04553e-07, 5.84734e-07, 1.24995e-07, -8.4862e-07, 3.83009e-07, -8.441e-07, -2.2098e-06, -1.70304e-06, -8.10807e-07, -1.65739e-06, -3.98286e-07, 3.36521e-07, 2.93608e-06, -2.18896e-06, 3.68836e-06, -1.31288e-06, -2.07478e-06, 7.3131e-08, -1.3071e-06, 2.04031e-06, -4.53049e-07, -1.72676e-06, -6.94743e-07, -1.31338e-06, 1.08016e-06, 5.47887e-07, 6.56996e-07, 1.61266e-06, -1.21376e-06, -1.88647e-07, 1.30374e-06, -1.02332e-06, 3.9578e-07, 7.03731e-07, -1.86508e-06, 4.76554e-08, 1.53564e-06, -2.32996e-07, -2.35285e-06, -3.93724e-07, 1.44305e-06, 1.35517e-06, -2.1224e-07, 4.08711e-07, -1.18019e-06, 1.40911e-06, -1.95423e-06, 2.21007e-06, 2.59453e-06, -2.04601e-07, -1.49825e-07, -2.77692e-07, 3.93542e-07, 1.50583e-06, 2.95468e-07, 1.60032e-06, -1.14943e-06, -2.36352e-09, 7.23857e-07, -7.37062e-07, -1.73594e-06, -6.50807e-07, -5.36616e-07, -6.03264e-07, 1.26073e-06, -4.11361e-08, 6.76471e-07, -2.55597e-08, 6.64778e-09, 3.02385e-07, 7.60661e-07, -2.02093e-07, -3.84923e-08, -3.53387e-06, 6.63295e-07, -8.45136e-07, 2.348e-06, -1.51712e-06, 1.26798e-06, -3.08769e-06, -2.87849e-06, 1.43856e-07, -5.36426e-07, 2.8909e-07, 7.10989e-07, -6.25808e-07, -1.75918e-07, -1.24705e-07, 6.811e-07, 1.69881e-06, 9.4509e-07, 1.14547e-06, 1.46455e-06, 1.97723e-06, 1.33255e-06, 5.4623e-08, -1.34178e-06, 9.88733e-07, -1.31915e-06, 3.65704e-07, 1.70665e-06, 8.57472e-07, -1.33741e-06, -1.66583e-06, 8.39615e-07, -7.33152e-07, 4.60903e-07, -3.21012e-07, 1.92498e-06, -1.31629e-06, 2.78403e-06, -1.98368e-06, -2.97098e-06, -6.008e-07, -8.18604e-07, 1.17914e-06, -2.67717e-07, -1.19473e-06, -1.42695e-06, -2.79815e-06, 1.70409e-06, -9.24229e-07, -1.39338e-07, -1.3751e-07, -2.63139e-07, 3.99555e-07, -1.57835e-06, -4.67602e-07, 1.74298e-06, -2.23255e-07, 3.05388e-07, -1.55362e-06, 2.45377e-07, -5.99681e-07, -1.50578e-06, -5.72577e-07, 3.86453e-07, 5.5475e-07, 1.71158e-07, 2.15673e-07, -5.67306e-07, 2.05086e-06, -1.92062e-06, 1.91994e-06, 2.8721e-07, 7.03074e-07, 1.39715e-06, -1.09985e-06, -8.94083e-07, 1.32402e-06, 5.19214e-07, 3.81398e-07, 1.65331e-07, -1.06388e-06, 5.62895e-08, 3.63314e-07, 1.64323e-06, 6.66554e-07, -1.02195e-07, 1.43504e-06, -3.82545e-08, -1.2627e-06, 2.00015e-06, -8.50324e-07, -1.01496e-06, 1.99406e-07, 2.66535e-06, 4.83333e-07, -5.31231e-07, -1.58821e-07, 2.79046e-07, -9.43109e-07, -1.17956e-06, 1.77855e-06, -2.4983e-06, 4.42525e-07, 5.7217e-07, 1.19575e-07, 1.0208e-07, -1.11683e-08, 8.41682e-07, -1.74534e-08, 4.90353e-07, 1.10338e-06, -7.58012e-07, 1.26381e-06, 1.07059e-07, -3.27996e-07, 1.55739e-07, 2.48936e-07, 1.10237e-06, -5.16128e-07, -2.54243e-06, 1.77154e-06, 2.13001e-07, 2.52051e-06, -3.89836e-08, 1.33997e-06, 6.48668e-07, -9.83388e-07, -2.65589e-06, 1.81044e-06, 8.7423e-07, 3.85703e-07, -4.6686e-06, 1.29038e-06, -2.48155e-06, 2.50752e-06, 4.48302e-06, -5.19423e-07, -6.42049e-07, -6.98837e-07, 7.44241e-08, 2.32896e-06, -1.15013e-07, 4.26592e-07, -1.15385e-06, 6.48374e-08, 4.40604e-07, -2.40817e-06, -1.77589e-06, -1.76301e-06, -1.10337e-07, 9.60755e-07, 5.22291e-07, -1.41724e-06, 1.76849e-06, -5.73514e-08, -1.76995e-06, -4.31268e-07, 2.33121e-06, 3.42743e-06, 1.28199e-06, 7.09744e-07, 1.81301e-08, 9.62297e-07, -3.45337e-07, 1.34945e-06, -1.20741e-06, 2.3535e-06, 6.03141e-07, 6.77846e-07, 9.6323e-07, -7.58042e-07, -2.57397e-07, 5.67149e-07, 8.40026e-07, 1.0038e-06, -1.04919e-07, -1.34933e-06, -1.80675e-07, 1.78209e-07, 8.57655e-07, -3.12813e-07, -2.79801e-07, 6.27229e-07, 2.57374e-07, -5.85449e-07, 1.38174e-06, 1.691e-07, -1.30276e-06, 1.85221e-07, 1.99308e-07, -2.02508e-07, -6.99768e-07, 1.60968e-06, -1.64197e-06, 6.81871e-07, 6.00141e-07, 1.07737e-07, 4.11186e-07, 6.35588e-07, 1.44171e-06, -1.95832e-06, -4.24588e-07, 1.7405e-06, 2.50644e-06, -8.60312e-07, -1.57539e-06, -2.28507e-07, -4.00727e-06, 3.70531e-06, -9.40439e-07, 1.01676e-06, 5.61809e-07, -1.72625e-06, -3.04595e-07, -3.51601e-06, -1.61865e-06, 3.6519e-06, -1.10628e-06, 2.76313e-06, 2.25092e-06, 9.59963e-08, -2.11741e-06, -2.68646e-06, -3.42565e-06, -2.07192e-06, 3.02006e-07, -2.79656e-06, -6.43311e-07, 7.91175e-07, -1.99817e-06, -1.62579e-06, 1.94215e-06, -2.4997e-06, -1.48914e-06, 1.31053e-06, 3.4927e-06, -4.61315e-07, -1.86991e-06, -3.12885e-07, -3.09184e-06, 3.67455e-06, -1.20067e-08, 2.12474e-06, 1.90499e-06, 1.71186e-07, 2.30657e-06, -2.59875e-06, -2.16759e-06, 2.42735e-06, -1.82715e-06, -3.20292e-08, 1.93389e-06, -5.50456e-07, -2.80823e-06, -2.09274e-06, -5.63158e-07, 1.08763e-06, -1.44869e-06, -2.5148e-07, 2.55107e-07, 1.69503e-06, -3.24703e-06, 7.47759e-07, 1.31515e-06, -1.15874e-06, -1.10732e-06, 5.89582e-07, 2.9134e-06, 1.75472e-08, 1.3164e-08, 1.69892e-06, -4.00048e-06, 1.43304e-06, 5.70128e-07, -4.40724e-07, -1.86071e-07, -6.88821e-07, -6.56597e-07, -2.10066e-06, -6.43709e-08, 2.68219e-06, -1.63822e-06, 2.1413e-06, 1.18503e-06, 5.56035e-07, -2.09447e-06, -2.7477e-06, -1.79584e-06, 2.01679e-06, -6.10166e-07, 2.71661e-07, -4.24842e-08, -8.58448e-07, 6.2437e-07, -1.52952e-07, 9.02848e-07, 1.93362e-06, 5.01777e-07, -9.99906e-07, -2.46347e-06, 7.94778e-07, 1.36785e-06, -1.66684e-07, 3.12239e-06, -1.88886e-06, 4.40099e-07, 1.73459e-07, 9.98591e-07, 1.29863e-06, -7.12183e-07, 3.32335e-06, 3.66105e-08, -2.20662e-06, 2.38787e-07, -2.8862e-06, -2.24818e-07, -1.08297e-06, 7.43778e-07, 1.3943e-06, 2.01469e-06, -2.41124e-06, 6.42743e-07, -1.81352e-06, 1.33915e-06, 4.32388e-07, 2.89119e-07, -1.36909e-06, -1.77631e-06, 4.0381e-07, -3.18429e-07, 1.02386e-07, -1.77699e-06, -2.87616e-07, -2.09661e-07, -1.36218e-06, 2.58966e-06, -1.49645e-06, 1.13395e-06, 3.57812e-07, -1.76113e-06, -1.17557e-07, 6.27684e-07, 4.66631e-07, -1.37509e-07, -2.08744e-06, 5.49462e-07, -2.82857e-06, -8.58236e-07, -9.563e-07, 2.25638e-06, 1.46723e-06, 3.3318e-07, -3.51076e-06, 1.04578e-06, -2.17419e-07, 1.67417e-06, -1.30232e-06, 2.99603e-06, -1.88641e-06, -3.34072e-06, 1.10939e-06, 2.20941e-06, -5.09642e-07, -9.68136e-07, 1.11167e-07, 7.66153e-07, 2.51881e-08, 2.06887e-06, 7.93016e-07, -7.66993e-07, 9.82118e-07, 2.02601e-06, 1.87722e-06, 2.24228e-06, -1.435e-06, 1.0704e-06, -2.20186e-08, -3.05892e-07, -8.18556e-07, -3.13708e-07, -1.47952e-07, 1.11474e-06, 1.35054e-06, 9.16609e-08, 1.26455e-06, 8.95591e-08, 5.63617e-07, -4.71937e-07, -5.30058e-08, -2.2032e-07, 1.42806e-07, 9.344e-07, 1.95066e-07, -4.81273e-08, -3.42097e-07, -4.44007e-07, 7.07189e-07, 1.25539e-08, -2.45675e-07, 9.15337e-07, -8.85337e-08, -3.07419e-08, 9.44027e-08, 2.4001e-06, 5.12207e-07, 1.36875e-06, 1.61497e-06, -6.33033e-07, -3.78641e-07, 1.51581e-06, -3.47041e-07, -2.93974e-07, 2.7176e-07, 3.79518e-07, 8.27711e-07, 7.753e-07, 2.82776e-06, -1.56848e-06, 1.74404e-06, -2.40323e-07, -1.21871e-06, 8.2254e-07, 2.9112e-07, -5.02397e-08, -9.18786e-07, -4.32344e-07, 8.89995e-07, 2.95431e-07, -7.20735e-07, -2.80837e-07, 6.58144e-08, -2.23267e-06, 8.84834e-07, -7.366e-07, -1.72826e-06, -6.52694e-07, -1.6418e-06, -6.62577e-07, -1.57509e-06, 1.02811e-06, 1.69407e-06, -1.06501e-06, 3.01806e-06, -3.75445e-07, 7.57036e-07, -1.33023e-06, -5.64733e-07, -1.35207e-06, -1.75618e-06, 1.2728e-06, -1.1367e-06, -2.34133e-06, 1.64643e-06, -2.8518e-06, 7.55821e-07, 1.43206e-06, -1.24882e-06, 1.49806e-07, -3.84709e-07, -1.24801e-08, 5.93461e-07, -9.32041e-07, -5.49884e-07, -1.25673e-06, 9.14064e-07, 1.2063e-06, -1.77131e-06, -2.1026e-06, -5.16618e-07, 2.97317e-09, 9.00442e-07, -9.86746e-07, -1.08599e-06, 3.51703e-07, -2.72235e-08, -2.15466e-07, 1.21243e-07, 2.32709e-06, 1.20969e-06, 7.44572e-07, 1.16901e-06, 2.93604e-07, -4.27328e-08, -9.82596e-07, -2.06064e-07, -7.56251e-07, 1.56639e-07, 9.82992e-07, 8.62712e-07, -1.77728e-06, -4.91714e-07, 1.18621e-06, 1.14923e-07, 5.80996e-07, 1.20341e-06, -1.1309e-07, -5.37883e-07, -4.05853e-07, 4.0965e-08, 3.19938e-07, 4.0256e-07, 3.10913e-07, 6.87911e-07, -1.56272e-07, 3.68798e-07, -3.08389e-07, 1.24474e-06, -8.95502e-07, 4.23992e-07, -1.39273e-06, 2.95703e-07, 5.95451e-07}},
    {"bert.encoder.layer.0.attention.output.dense.weight_transposed_grad", {6.13277e-06, 1.79994e-05, 0.000216529, -0.000102692, 0.000102726, -0.000130988, -0.000291396, 0.000344709, -0.000151862, -7.73808e-06, 0.000154007, -9.31979e-06, -1.53569e-05, 2.61026e-05, 3.64236e-06, -0.000131661, -9.83954e-05, -0.000128087, -0.00016313, 0.000275247, -7.36182e-05, -0.000204263, -2.86125e-06, 0.000150928, 0.00016159, 0.000236464, 5.52563e-05, -5.73022e-05, 3.43714e-05, 6.46158e-06, 6.2068e-05, -0.000285564, 5.78563e-05, -0.000111187, 0.000112648, 0.000285651, -0.000465978, -0.000223055, 0.000763769, -0.000783878, 8.66715e-05, 0.000355334, 2.35381e-05, -0.000252676, 0.0001874, 0.000371379, 8.31793e-06, -6.39883e-05, 0.000521183, -0.000210455, -2.81946e-05, -0.000505384, 0.000514703, 0.000238433, 0.000121486, 0.000369815, -0.000510862, -0.00114686, 0.000151309, -0.000408826, -0.000684533, -5.39311e-05, 0.000195794, 0.00108452, 2.99227e-05, -1.93225e-05, 0.000302882, 8.16372e-06, -0.000115907, -0.000260567, 5.78293e-07, 6.96247e-05, -0.000108333, 0.000127718, 0.00018072, -0.000114532, 7.18978e-05, 0.000190732, 8.32963e-06, -0.000173319, 0.000112518, -0.000213543, -0.000205094, 9.18008e-05, 0.000121738, -0.000123028, 4.38805e-05, 0.000336222, -4.96794e-05, -0.000209361, 0.00013654, -0.000240409, -0.000253615, -1.94718e-05, 0.000153067, 0.000119845, -2.78858e-07, -3.54505e-05, -3.46032e-05, 7.5165e-05, -0.000140842, -4.28089e-05, 0.000229884, -0.000196925, 6.26639e-05, 7.86551e-05, -3.06648e-05, -6.70367e-05, 3.41836e-05, 8.32704e-05, 1.87435e-05, 4.87835e-06, 0.000130103, 5.72916e-06, 2.88331e-05, -0.00017595, 0.000143682, 0.000133594, 9.21653e-06, 6.08724e-05, -0.000145696, -0.000319548, 1.77822e-05, -6.86971e-05, -0.000177871, 3.29578e-06, 3.09226e-05, 0.000284898, -9.2113e-05, -4.86483e-06, 0.000131373, -0.000100891, -0.000378609, -0.000241814, -6.31339e-05, 0.000358588, 0.000135948, 7.5599e-05, -2.01357e-05, -8.40822e-05, -1.1769e-05, 7.14787e-05, 0.000209636, -0.000141557, 0.000135346, -7.85404e-05, -0.000144105, 7.86721e-05, 0.000172074, 0.000158372, 2.04845e-06, 0.000302547, -0.000144369, -0.000185358, 0.000216929, -0.000174295, -0.000188519, -0.000113831, 0.000135965, -1.6591e-05, -5.43146e-06, -2.29677e-05, 4.72811e-06, -2.48313e-05, -0.000200212, -0.000111251, 5.30722e-05, 2.49052e-05, 0.000107705, 5.57532e-05, -9.45759e-05, -2.44589e-05, -2.73965e-06, 8.05409e-05, 7.92439e-05, -1.17704e-05, 0.000116939, -1.51202e-05, -2.80184e-05, -6.73114e-05, 8.36612e-05, 0.000165338, 2.05607e-05, 0.000107157, -0.000148037, -0.000134486, 0.000122221, -7.67378e-05, -7.88066e-05, -8.40396e-05, 2.58079e-05, 8.31624e-05, 5.49805e-05, -5.26111e-05, -0.000106069, 0.000219875, -8.31401e-05, 8.86345e-05, 0.000521619, -0.000686656, 5.84789e-05, 0.000145424, -3.95924e-05, -8.40573e-05, 8.41893e-05, 9.34986e-05, -8.76575e-05, 9.11775e-05, 0.000212237, -2.49503e-05, 0.000155534, -0.000408392, 0.00020854, 0.000132275, 5.66826e-05, -4.54491e-05, -0.0002428, -0.000592218, -4.97512e-05, -7.81376e-05, -0.000251633, 2.60441e-05, 1.97713e-05, 0.000664153, -5.43656e-06, 6.58896e-05, 3.99497e-05, -0.000212087, 0.000269763, 1.03977e-05, -0.00056728, 0.000643244, -0.000125325, -0.000244352, 5.94233e-05, 0.000115624, -8.9988e-05, -0.000171486, 3.40108e-05, 2.7169e-06, -0.000374469, 4.78444e-05, -8.18957e-05, 0.000436809, -0.000350334, -0.000239846, -8.59895e-05, -9.77721e-05, 0.000408253, 0.000768399, -7.9202e-05, 0.000199311, 0.000400083, 4.63118e-05, -0.000108748, -0.00071382, -0.000145671, 9.55006e-05, -0.000221826, -0.000183956, 0.000118753, 0.000234963, -0.000350065, 0.000488193, 0.000123579, -0.000198322, -0.000156399, 0.00013896, -0.000239854, -0.000306246, 0.000113701, 9.52233e-05, -0.000265579, 0.000219544, 0.00013822, 0.000120617, -0.000138136, 0.000121991, -0.000125252, -0.000343877, 0.000151978, 0.000510085, -8.71892e-05, 0.000278641, 0.000374174, -7.31047e-06, -9.55247e-05, -0.000458917, 9.44741e-05, 2.20871e-05, -7.77137e-05, 6.44594e-05, 0.00046173, 0.000276935, -3.7965e-05, -0.000296155, -0.000210944, -9.82603e-05, 0.000105471, 0.000116492, 2.48513e-05, -0.00012197, -0.000200242, 0.000126185, -0.000194426, -5.58427e-05, 0.000137628, 5.04314e-05, -0.000231153, -0.000350469, 2.58036e-05, -0.000278644, 0.000281896, 0.000270695, -0.000267885, 0.000180432, 0.000268234, 8.78213e-05, -0.000121015, -5.29408e-05, -6.57157e-05, -1.11801e-05, 0.000236784, 3.1329e-05, -0.000123321, -0.000182246, 0.000128205, 2.36877e-05, -7.5648e-05, 0.000138105, 0.000213647, -0.000147926, -2.00199e-05, 0.000169458, 5.94476e-05, -0.00017488, 0.000145975, -9.77194e-05, -0.000125007, -1.86155e-05, 0.000281177, -4.41064e-05, -3.30433e-05, 0.000267828, -9.7137e-05, -0.00039879, 1.60474e-05, -0.000214892, -0.000368371, 1.86235e-05, 0.000200291, 0.000268013, -3.21315e-05, 1.66418e-07, -0.000174496, -1.99384e-05, -8.70526e-05, 9.27819e-05, 4.43539e-05, -5.21486e-05, 0.000154834, 1.0696e-05, -0.000179215, 3.59913e-05, -2.82401e-05, -8.19511e-05, 3.88288e-05, 7.66481e-05, 3.7497e-05, 6.67715e-05, 0.000111187, -0.000107373, 9.85344e-06, 0.000193784, 2.30049e-05, -9.59486e-05, -9.7651e-05, -2.81694e-05, 4.31322e-05, 7.62439e-05, 7.97956e-05, -5.78657e-05, -5.26901e-05, -7.00158e-07, -7.12944e-05, 2.71654e-06, 7.87848e-05, -0.000228412, -0.00037788, -0.000272902, -0.000318282, 0.000646057, 0.000212798, 8.83938e-06, -0.000195027, -3.8493e-05, -0.000107767, 4.73683e-06, 0.000256316, -0.0001055, 2.73578e-05, 1.24551e-05, -0.000158039, 0.000162814, 4.54701e-05, 0.000332623, -2.29601e-05, 0.000218414, -0.000150407, 0.00016206, 0.000375158, -0.00010071, 1.44307e-05, -0.000163252, 6.33018e-05, -0.000313408, -4.62488e-05, -5.04669e-06, -0.000215551, 0.000100263, -3.14644e-05, 0.000133321, 0.000265873, -0.000268402, 0.000100845, 2.82177e-05, -7.85497e-05, -1.92972e-05, -1.27233e-05, -4.91475e-06, -2.25937e-05, 7.99363e-05, 7.41563e-05, 0.000126885, 0.000151706, -0.000256, 0.000128709, 0.000164312, -2.26172e-05, -0.00012443, -0.000106982, -0.000258273, -0.000134065, 8.10637e-05, -7.40026e-05, 4.43905e-05, -3.70237e-05, 0.000238506, -7.167e-05, 1.97164e-05, 8.13364e-05, -0.000127924, -0.000205275, -0.000122498, -0.000138501, 0.000319775, 9.61346e-05, 3.73286e-05, -7.44207e-05, -4.38862e-05, -0.000118533, -2.96728e-06, 0.000172211, -5.65282e-05, 2.71215e-05, -3.30273e-05, -6.79714e-05, 6.24474e-05, 0.000108907, 0.000176959, -2.85363e-05, 0.000111985, -0.000103015, -1.60098e-05, 0.000178984, -8.65533e-05, -5.25254e-05, -9.48317e-05, 8.26373e-05, -3.08694e-05, -2.77457e-05, -4.60826e-05, 0.000132139, 9.55822e-05, -0.000199953, -0.00017675, 0.000274319, -0.000157838, -3.41207e-06, 0.000159852, 0.000117012, -0.000154595, 6.66352e-05, 0.000185659, 2.36933e-05, -0.000120165, 0.000205962, -4.94195e-05, -8.05179e-05, -0.000136911, 0.000262912, 6.90548e-05, 3.66905e-06, 0.000255533, -0.000174502, -0.000509219, 4.25067e-05, -0.00019491, -0.000393431, 3.70454e-05, 0.000140585, 0.000353291, 2.71088e-05, 7.09591e-05, -0.000176753, -4.7467e-05, 0.000335891, 0.000344204, -0.000239934, -1.02968e-05, -5.49158e-05, -0.000187502, -5.25223e-05, 0.00021207, -1.56052e-05, -0.000286329, -9.21408e-05, 0.000165502, -0.000247092, -1.52412e-05, 0.000155204, 0.000161407, -0.000332261, -0.000264741, 3.78313e-05, -0.000353431, 0.000288217, 0.000537508, -0.000176302, 0.000258694, 0.000485425, -2.22154e-05, -0.000167133, -0.000338138, -3.75665e-05, -9.57395e-05, 0.000158615, 0.00016014, -0.000495974, -0.00034842, 0.000506767, -0.00027262, 0.000101104, 0.00027138, 4.76896e-05, -0.000244247, 0.000126542, 0.000354645, 7.91451e-05, -0.000162993, 0.000424089, -2.205e-06, -0.000150072, -0.000301487, 0.000446215, 0.000304598, 1.49186e-05, 0.00043013, -0.000425954, -0.000868057, 0.000169112, -0.000344893, -0.000667661, 1.75271e-05, 0.000194579, 0.000610692, 0.000143102, -4.72458e-05, -0.000228209, 0.000315296, -3.09292e-05, 0.000251206, 0.00068544, -0.00109783, 6.67065e-05, 0.000210005, -0.000119861, -6.10874e-05, 0.000149503, 6.37459e-05, -0.000169071, 0.000208415, 0.000255717, -0.000252919, 0.000289772, -0.000572791, 0.000217005, 7.47676e-05, 0.000183568, -0.000135657, -0.000275706, -0.000743656, -7.149e-05, -7.27166e-05, -0.000153545, -5.06128e-05, -2.7361e-05, 0.000996439, 0.000124243, 1.02684e-05, 0.000231167, -3.10881e-05, 0.000252627, -6.32325e-05, -0.000236235, 5.96727e-05, -0.000230166, -5.44457e-05, 0.000222557, 2.87945e-05, 9.01006e-05, 2.13246e-05, -0.000106205, -6.1436e-05, -0.000137378, -0.000239107, -0.000119065, 0.000285947, -0.000211412, -0.000445033, 6.39748e-05, 0.000115298, 0.00026684, 0.000300624, -2.13898e-05, -4.12228e-05, 0.000144561, -1.36969e-05, 1.02473e-05, -0.000217137, -8.91593e-05, 7.86488e-05, -1.11788e-05, -0.000378423, 4.07963e-05, -7.43056e-05, -0.000804697, 0.00112657, 0.000108369, -0.000297906, -0.000135327, 0.000161912, -0.000204034, -0.000269375, 0.000195279, -4.42143e-05, -0.000389082, 0.00017697, -0.000105739, 0.000498299, -0.000372024, 5.51913e-05, -0.000130552, -0.000106074, 0.000288527, 0.000989653, 0.000163687, 0.000229263, 0.000519541, -6.7054e-05, -9.19348e-05, -0.00106163, -0.000156786, 0.000146814, -4.13398e-05, -0.000515913, 0.00031034, 5.05628e-05, -0.00117108, 0.00152759, 1.1421e-05, -0.000495921, -6.59697e-05, 0.000268295, -0.000301798, -0.000460131, 0.00020543, -1.64759e-05, -0.000675859, 0.000327147, -0.000101595, 0.000800255, -0.000613745, -0.000140455, -0.000228932, -0.000272966, 0.000614131, 0.00153572, -2.01832e-05, 0.00044785, 0.000805304, 1.50231e-05, -0.000182204, -0.00160453, -2.88599e-05, -4.15444e-05, 1.92688e-05, 0.000120642, 6.97394e-05, 3.65686e-05, 0.000288587, -0.000324091, -9.32264e-05, 0.000101968, 0.000129811, -8.73296e-05, 6.40108e-06, 7.70171e-05, -5.76081e-05, -2.96089e-05, 0.000100972, 7.01281e-05, 5.03972e-05, -0.000160796, 0.000181905, -1.01299e-06, -3.95851e-05, 4.63518e-06, -6.11184e-05, -0.000389532, -0.000140522, -4.5526e-05, -0.000277679, 0.000126452, 6.57662e-05, 0.000327782, -8.31038e-05, 4.27553e-05, -0.000179381, -0.000231344, -5.4279e-05, 2.67641e-05, -0.000400633, 0.000608317, 0.000217499, -0.000161329, -0.000242061, 9.57078e-05, -0.000178784, -0.000209971, 0.000153317, 4.09695e-05, -0.000197861, 0.000204374, 5.44898e-05, 0.000142331, -0.000163948, 0.000263698, -8.50152e-05, -0.00015692, 5.1244e-05, 0.000509358, 0.000128675, 0.000206865, 0.000339252, -7.4358e-05, -9.10138e-05, -0.000575615, 5.20249e-05, -4.3865e-05, 0.000134931, 0.000129101, -6.22162e-05, -5.66371e-05, 0.000303881, -0.00041565, -8.38719e-05, 0.000153479, 0.000123993, -9.8587e-05, 8.64552e-05, 0.000146416, -3.22897e-05, -3.45675e-05, 0.000183913, -0.000190138, -1.32517e-05, -0.00014308, 0.000188212, -8.94e-05, 6.69889e-05, 0.000156779, -0.000116577, -0.000473506, -1.43201e-06, -0.00019327, -0.000279922, -1.20667e-05, 0.000107636, 0.000506517, -0.000197453, 0.000155317, -5.70598e-06, -0.000493225, 0.000207061, -3.64973e-05, -0.00115488, 0.00163278, -1.68656e-06, -0.000459373, -3.53402e-05, 0.00022495, -0.000252781, -0.000385987, 0.00021334, -8.40901e-05, -0.000625954, 0.000327407, -0.000204248, 0.000823385, -0.000546736, -0.000114975, -0.000231378, -0.000157505, 0.000590401, 0.00146135, -1.26937e-05, 0.000394778, 0.000687263, 5.81046e-05, -0.000159627, -0.001616, -1.20604e-05, 1.57589e-05, 8.63889e-05, -2.07055e-05, -8.67107e-05, -0.000108935, -8.50254e-05, 0.000177222, -4.62844e-06, -1.71121e-05, 2.13973e-05, -2.05266e-05, 2.4378e-05, 4.54082e-05, 2.22261e-05, -5.55001e-05, 1.18891e-06, 1.41383e-05, -0.000118694, 9.09145e-05, -9.55279e-06, -6.07944e-06, -1.13155e-05, 0.000100942, -4.09367e-06, 8.12517e-05, 6.19608e-05, -5.46956e-05, -3.53276e-05, 2.66285e-06, 1.74922e-05, -0.000112369, 8.83261e-05, 2.65609e-05, -2.6673e-05, -7.26711e-05, 0.000365286, 8.93542e-05, -0.000347791, 0.000238348, -0.000166605, -0.000227551, 0.000104238, 0.000111692, 3.52392e-05, -0.000136616, -9.11922e-05, 5.17195e-05, -0.000325165, -2.31053e-06, -2.68591e-06, 0.000304065, -0.000371845, -0.000353013, -2.42861e-05, -0.000136952, 0.000413704, 0.000614193, -0.000167406, 0.000205537, 0.000381412, 7.10118e-05, -0.000146372, -0.000501554, 8.09521e-05, -0.00012748, 8.86236e-05, 0.000384801, -0.000405126, -0.00010311, 0.00103837, -0.00122578, 8.07835e-05, 0.000486316, 7.42663e-05, -0.000320301, 0.00016357, 0.000374165, -3.72504e-05, -3.31971e-05, 0.000615796, -0.000355269, 0.000130229, -0.000737299, 0.000696578, 0.000222482, 0.000168712, 0.000334879, -0.000612593, -0.0015605, 0.000101344, -0.000460476, -0.00081522, -7.77797e-05, 0.000277084, 0.00155243, 0.000159929, -2.41038e-05, 0.000147457, 2.74817e-05, 0.000194226, -4.94605e-05, -9.35083e-05, -0.000150095, -0.000179632, 1.19169e-05, 0.000115298, 3.0153e-05, 0.000137287, 6.66763e-05, -0.000147126, -2.05047e-05, -3.95245e-05, -0.000230368, -7.86224e-05, 0.000143412, -0.000181098, -0.00031324, 0.000113944, 9.32782e-05, 0.000144219, 0.000163104, 2.97701e-05, -5.27913e-05, 0.00010673, -2.44474e-05, -2.59442e-05, -7.44175e-05, 3.58276e-05, -4.86287e-05, -3.21852e-05, 0.000278093, -0.000224818, -1.99723e-05, 0.000607575, -0.000681421, 5.84607e-05, 0.000201527, 2.97982e-05, -0.000129524, 0.000174594, 0.000207473, -9.48095e-05, 8.71299e-06, 0.000320737, -9.81834e-05, 5.27652e-05, -0.000422579, 0.00030241, 9.44378e-05, 8.78538e-05, 0.000125052, -0.000301204, -0.000759202, -3.51231e-05, -0.000182523, -0.000401637, 2.40114e-05, 7.70863e-05, 0.000745396, 3.85233e-05, 3.65425e-05, -0.000156531, 1.25275e-05, 0.000319412, 0.000266304, -7.59188e-05, -0.000134678, -8.59081e-05, -0.000119608, -2.47287e-05, 0.000129054, -4.0055e-05, -0.000153357, -0.000109345, 0.000149339, -0.000182157, 3.48143e-05, 0.000147153, 1.6198e-05, -0.000196951, -0.000153767, -6.21892e-06, -0.000314142, 0.000195294, 0.000303629, -0.000201707, 0.000204482, 0.000294561, 4.87003e-05, -0.000135273, -0.000106188}},
    {"bert.encoder.layer.0.attention.self.value.weight_transposed_grad", {-1.36063e-05, -0.000362213, -3.56803e-06, -0.000200989, 0.000160526, 0.000255696, -0.000221898, 5.31866e-05, 0.000104947, -5.19056e-05, -6.15528e-05, 0.000285548, 6.30236e-05, 1.50094e-05, 0.000161725, 7.30607e-05, 0.000142684, 0.000148607, -0.000149024, -9.8951e-05, 6.43324e-06, -0.000135892, 8.36824e-05, -0.000113782, 0.000263475, 9.35297e-05, -3.3144e-05, 0.000121621, -0.000106638, 0.000123342, -9.70772e-06, 3.52127e-07, -9.7612e-05, 0.000121785, -5.21569e-05, -0.000318559, -0.000312135, -0.000479347, -9.14471e-07, -4.90588e-05, -0.00010296, 2.16889e-05, 0.00011473, -0.000542506, 0.000268415, 0.00029533, -0.000268263, -4.82424e-05, 0.000129938, -9.73167e-05, 0.000266038, -0.000107198, 4.76406e-05, -9.26428e-05, 5.65102e-05, 0.00026874, -0.000577562, -0.000344369, 8.10159e-05, 5.15367e-05, 3.42459e-05, -0.000181355, 0.000176696, 2.22933e-05, -3.91221e-05, -0.000131622, 7.06723e-06, -0.000185068, 8.00171e-06, 4.49848e-05, -9.30769e-05, 1.99971e-05, 0.000111058, -2.90132e-05, -3.36918e-05, 1.97241e-05, 2.7647e-05, 1.06484e-07, 0.000137622, 1.03937e-05, 8.85707e-05, -1.37713e-06, -0.000136276, -0.00015035, 2.6588e-05, -5.59636e-05, 0.000166702, 4.49846e-05, 8.83313e-05, 3.98889e-05, -5.43208e-06, 8.44034e-05, -2.81689e-05, 7.19047e-05, 4.93468e-05, -5.17198e-05, -0.000331514, 0.000446783, 9.61397e-06, -0.000222789, -0.000275305, -0.000984887, 0.000116078, -0.000232609, -0.000179821, 0.00016864, 8.67428e-05, -0.000992185, 0.000138022, 0.000205926, -0.000314177, -0.000143045, -0.00036248, -0.000353943, 3.55925e-05, -4.2689e-05, 5.62405e-05, 0.000117076, 6.33117e-05, 0.000656397, -0.00100058, -0.000291975, 0.000172218, -0.000200887, 0.000347752, -0.000392038, 0.000213895, 1.70966e-05, -0.000181035, 0.000317424, 0.000107108, -0.000104701, -0.000160982, -0.000585584, 0.000141689, -0.000127559, 1.98727e-05, 9.49628e-05, 9.10947e-06, -0.000548456, 1.09924e-05, 4.05794e-05, -9.89707e-05, -9.95462e-05, -0.00019304, -0.000289822, -0.000156713, -0.000111895, -2.05196e-05, 9.04855e-05, 0.000174299, 0.000470949, -0.000541213, -8.75832e-05, 2.73252e-05, -6.27041e-05, 0.00030145, -4.5945e-05, 0.000189497, 4.96484e-05, 8.81359e-06, 0.000416001, 0.000122228, 0.000542532, 0.000100641, -7.50502e-05, 0.000352612, -9.39367e-05, 1.014e-05, 8.38012e-05, -9.95745e-05, 2.79309e-06, -0.000360572, -0.000329074, 8.63804e-05, -8.87154e-05, -0.000425413, -0.000234342, -0.000188747, 0.000150146, -8.43868e-05, 0.000318129, -3.68263e-05, 8.5113e-05, 6.45742e-05, 0.000253355, -2.07725e-05, -0.000229793, 0.000261467, 5.1024e-05, -8.12466e-05, -2.79874e-05, 9.60257e-05, 0.000205731, -1.5742e-05, 0.000361066, 6.00942e-05, 0.000181307, 0.000152922, 3.0097e-05, -4.00356e-05, 1.65829e-05, 7.15255e-05, 0.00018553, -0.000192862, -0.000151051, -8.2288e-05, -2.14716e-05, -0.000115763, 3.58986e-05, 3.98557e-05, 0.000212274, -8.06162e-05, 8.76065e-05, -0.000198874, -0.0001892, 0.000192301, 4.92508e-05, -5.98614e-05, -5.3051e-05, 1.38446e-05, -4.43176e-06, -0.000131083, 6.22054e-05, -0.000163409, -0.000304147, -1.47819e-05, -0.000505508, -5.27854e-05, -0.000217717, -0.00025715, -4.38906e-05, 2.13418e-05, -1.09822e-05, -1.99621e-05, -0.000223218, 0.000276049, 0.000231744, 2.19205e-05, 4.64372e-05, 0.000152573, 1.45366e-05, -4.04408e-05, -0.000233306, 7.47209e-05, -0.000168781, 0.00021029, 0.000211901, -0.000245525, -0.000134779, 5.12403e-05, 0.000113301, -1.89904e-05, -4.03501e-05, 0.000172256, -2.55185e-05, 3.76567e-05, -0.000566018, 3.4107e-06, -0.000231443, 0.000176394, 0.000421964, -0.000313853, 5.5087e-05, 8.38371e-05, -9.2697e-05, -0.00016047, 0.000444442, 0.000124985, 4.54336e-05, 0.000308059, 0.000151248, 0.000230496, 0.000206384, -0.000123384, -0.00014229, 8.89934e-05, -0.000121987, 0.000149947, -0.000206286, 0.000419253, 0.000159273, -2.18276e-05, 0.000113174, -0.000215641, 0.000151588, -7.50396e-06, -0.000114453, 0.000236507, -9.44738e-05, 5.96965e-05, 0.000487678, 0.000260762, 0.000592464, 0.000139634, 6.12803e-05, 4.62623e-05, -4.85952e-05, -0.000148907, 0.000638883, -0.000253425, -0.000315132, 0.000240529, 6.24342e-05, -2.11825e-05, 0.000137967, -8.35969e-05, 0.00015423, -4.53209e-05, 0.000142716, -0.000118912, -0.000387838, 0.00061668, 0.00030883, -6.80505e-05, -7.70618e-05, -8.38257e-05, 0.000233842, -0.000214827, -5.11915e-05, -9.64265e-05, 7.36683e-05, 8.03654e-05, -6.53527e-06, 1.74903e-05, -0.000237489, 4.15743e-05, -8.76116e-05, 2.85895e-06, 4.37622e-05, -9.38621e-05, -0.00020059, -4.10714e-05, -3.71307e-05, 8.80989e-05, -7.18344e-06, -0.000193634, -0.000163213, -0.000135143, -6.01671e-05, 4.23936e-05, 0.000106851, 0.000106517, 0.00022404, -0.000172559, 9.2052e-05, 3.82477e-05, -0.000116105, 0.00012376, -1.91196e-05, 6.69242e-05, -5.756e-05, -2.18879e-05, 0.000216093, 1.44909e-05, 1.22283e-05, -0.000114173, -0.000276916, 0.000105456, -2.49241e-05, -6.00382e-05, 4.07966e-05, 5.90534e-05, -0.000282371, 1.33611e-05, 5.1905e-05, -0.000173222, -3.21647e-05, -7.83067e-05, -9.62815e-05, 9.96595e-05, 4.99641e-05, 1.03949e-05, 2.87743e-05, -6.74552e-05, 0.000132051, -0.000307292, -0.000104678, 2.29781e-05, -7.00542e-05, 6.79273e-05, -8.31479e-05, 2.51492e-05, 6.29154e-05, 6.58827e-05, -0.000259333, -6.74901e-05, -7.22801e-05, 7.01748e-05, 0.000240977, -0.000129486, 3.71387e-05, -6.08547e-05, -6.01368e-05, -1.82544e-05, 0.000204028, 9.08769e-05, 6.61213e-05, 5.49655e-05, 8.77052e-05, 0.00014416, 0.000169495, 0.000147178, 1.11489e-05, 5.19641e-05, -7.27773e-05, -8.36204e-05, -0.000194295, 0.000178043, -8.23785e-06, 2.47135e-05, 2.12259e-05, -0.000200872, -1.90991e-05, -5.10734e-05, -5.75951e-05, -0.000132357, 0.000426619, 1.31417e-05, 6.75246e-05, -0.000132117, -0.000446312, 0.000178671, -8.64585e-05, -4.25364e-05, 9.67685e-05, 0.000122103, -0.000442564, -8.2279e-05, -1.17934e-05, -0.000203258, -0.000127233, -0.00024074, -0.000211265, -4.04437e-05, 5.17802e-05, -6.97367e-05, 9.36393e-05, -2.767e-05, 0.00029374, -0.000407218, -0.000120489, 1.68086e-05, -7.70812e-05, 0.000246379, -0.00014373, 7.46927e-05, 8.62646e-05, -5.80019e-05, 6.133e-05, -1.16249e-06, -5.83788e-05, -9.23652e-05, -0.000254197, 1.70902e-05, -5.66287e-05, -6.21506e-05, 1.98276e-05, -2.51118e-05, -0.000248462, 6.99859e-05, 7.18598e-05, -1.57412e-05, -1.3516e-05, -5.9946e-05, -0.000118673, 7.88288e-05, -4.92763e-05, 4.35499e-05, 3.21951e-05, 5.15763e-05, 0.00017448, -0.000240459, -6.1243e-05, 6.02864e-05, -5.82741e-05, 6.33102e-05, -9.3493e-05, 8.16632e-05, -5.45914e-05, 0.000402751, -0.000512726, 2.8866e-05, 0.000519468, 0.000519186, 0.00132088, -7.36431e-05, 0.0002352, 0.000204846, -0.000181434, -0.000213496, 0.00136645, -0.000363283, -0.000440367, 0.000548521, 0.000189131, 0.000195395, 0.000398588, -0.000179923, 0.000147444, -6.24505e-05, 2.03823e-05, -0.000139641, -0.000850252, 0.0014068, 0.000578481, -0.000192776, 8.12917e-05, -0.000389476, 0.000476757, -0.000359118, -9.64491e-05, -0.000206707, -5.24117e-05, -7.52341e-05, -0.000651436, -0.000377553, -0.00063016, -0.000196223, -6.68868e-05, -8.74804e-05, 1.27575e-05, 7.3617e-05, -0.000733484, 0.000422611, 0.0004376, -0.000191321, -4.13373e-06, 0.00017573, -0.000124071, 0.000225634, -0.000257581, 0.000175209, -0.000165331, 0.000219507, 0.000402443, -0.000715157, -0.000387039, 0.00014376, 7.2432e-05, -2.41723e-05, -0.000271953, 0.000258327, -7.3451e-05, -4.31741e-05, 0.000169832, -7.32168e-05, 3.01855e-06, -0.000188963, -0.000312993, 2.40069e-05, -5.56024e-05, -0.000193558, 6.15577e-05, 8.29971e-05, -0.000334899, 0.000126614, 0.000156411, -0.000264101, -2.13785e-05, -7.80197e-05, -4.24693e-05, 0.000253327, 0.000128115, 7.38998e-05, 2.49665e-05, -0.000123529, 8.15946e-05, -0.00039254, -0.000227532, 8.70839e-05, -0.000100461, 3.8924e-05, -0.000274359, 3.55585e-06, 4.87088e-06, -0.0002391, 0.000155602, -5.96142e-05, -0.000580659, -0.000406946, -0.000779692, -8.77299e-05, -9.08727e-05, -0.000134308, 6.06099e-05, 0.000178078, -0.000858088, 0.000396943, 0.000470531, -0.000418253, -5.51736e-05, 0.000104873, -0.000134929, 0.000261885, -0.000148231, 8.83745e-05, -0.000160901, 8.06938e-05, 0.000454668, -0.00092805, -0.000488672, 0.000114902, 6.02132e-05, 6.68829e-05, -0.000310896, 0.000258093, 8.07147e-05, 0.000160586, 7.70042e-06, 2.58223e-05, 0.000213901, 0.000161767, 0.000439703, 5.09981e-05, 0.000129857, 0.00015315, -6.06876e-05, 3.76662e-05, 0.00043639, -0.000222169, -0.000216314, 0.000123457, -2.24893e-05, 8.27069e-05, 9.95644e-05, -0.000142098, 3.10708e-05, -0.000120762, -2.45398e-05, -5.81155e-05, -0.000252618, 0.000497163, 0.000195505, -0.000127514, 9.93477e-05, -8.72754e-05, 0.000240479, -0.000108049, 7.50834e-05, -0.000123334, -1.55346e-05, -0.000186429, -0.000647137, -0.000483033, -0.000667553, -0.000219563, -1.3559e-05, -0.00028701, 2.38334e-05, 0.000289645, -0.000774805, 0.000591469, 0.000638664, -0.000626917, 1.32676e-05, 0.000322632, 6.42552e-05, 0.000620891, -2.89962e-05, 0.000140452, -0.00030929, -0.00011973, 0.000227865, -0.000934905, -0.000695857, 0.000130957, 0.00011046, -0.000120572, -0.000422963, 0.000195502, 0.000131047, 0.000151699, -2.86793e-05, 3.53737e-05, 0.00036031, 0.000218059, 0.000488289, 7.59846e-05, 6.80525e-05, 8.01646e-05, -2.90304e-05, -3.88446e-05, 0.000528834, -0.000239047, -0.000254431, 0.000144744, 1.21689e-05, -2.27509e-05, 0.000124696, -0.000145054, 0.000131999, -9.89597e-05, 6.9126e-05, -0.000101514, -0.000310473, 0.000533019, 0.000233908, -0.000104813, 9.42004e-06, -4.04693e-05, 0.000193601, -0.000160731, 3.04543e-05, 0.000281681, -1.92386e-05, -8.36593e-05, 0.000341196, 7.14326e-05, 0.000611199, 7.18539e-05, 0.000187522, 4.31439e-05, -9.44636e-05, 8.12646e-05, 0.000571869, -0.000160615, -0.00015114, 5.31887e-06, 2.63846e-05, 0.000199832, 0.000219833, 0.000185392, 0.000188097, -9.1459e-05, -4.71983e-05, -0.000230823, -0.000517037, 0.000600218, 7.47695e-05, -0.000115896, 0.00010768, -0.0002264, 0.000147122, -0.00021352, 4.40945e-05, -9.90308e-06, 0.000315303, 2.85875e-05, 0.000239428, -1.7393e-05, -0.000138435, 0.000164131, -2.60339e-05, 2.71858e-05, 4.1858e-05, 2.26944e-05, -0.000119499, -0.000195592, -0.000164966, 3.64759e-05, -0.000127155, -0.000215285, -0.000198926, -9.40912e-05, 1.68018e-05, -7.89299e-05, 0.00013241, 2.50589e-05, 0.000137538, -5.3305e-06, 0.000102037, -9.65242e-06, -7.31832e-05, 0.000170534, -7.34632e-06, 1.47748e-05, -1.46209e-05, -1.39369e-05, 0.00011761, 3.27116e-05, 7.95234e-05, -1.21998e-06, -5.35419e-05, 5.35422e-05, -2.29901e-05, 1.54938e-05, 2.861e-05, 6.5826e-06, -3.61608e-05, -6.48403e-05, -5.70307e-05, 3.14962e-06, -6.13873e-05, -7.30988e-05, -5.91828e-05, -8.78232e-05, 4.51999e-06, -3.9406e-05, 5.17953e-05, 2.08441e-05, 7.00645e-05, -2.68326e-05, 3.71634e-05, -1.0194e-05, -2.18846e-05, 9.07072e-05, 1.05058e-05, 1.52227e-05, 1.84322e-05, 0.000168938, -0.000103468, 3.49308e-05, 0.000503929, 0.000385124, 0.000744937, 0.000104582, 8.24947e-05, 0.000140006, -5.06114e-05, -0.000138701, 0.000787485, -0.0003861, -0.000399052, 0.000328638, 6.38111e-05, -0.000122048, 0.000170367, -0.000255841, 0.000191929, -9.50735e-05, 0.000146105, -0.0001409, -0.000467107, 0.000833367, 0.000421518, -0.000109126, -4.70457e-05, -8.90886e-05, 0.000248007, -0.000284931, -4.49072e-05, 0.00047963, -0.000318804, 0.000113772, 0.00111114, 0.000857081, 0.00163728, 0.000183619, 0.000231738, 0.000306684, -0.000147086, -0.000305261, 0.00178613, -0.000790675, -0.000881377, 0.000735539, 0.000131642, -0.000149969, 0.000348532, -0.00048211, 0.000329781, -0.000233281, 0.000236783, -0.000259275, -0.00100422, 0.00187412, 0.000949477, -0.000272827, -4.9994e-05, -0.000216077, 0.000669781, -0.000555783, -5.40831e-05, -0.000177008, -0.000471696, -3.98932e-05, -0.000681066, -5.1856e-05, -4.98568e-05, -0.000375737, 2.52251e-06, 0.000112738, -6.05052e-05, -4.46853e-05, -0.000103847, 0.000333167, 0.000292326, 0.000128707, 7.39103e-05, 0.00030285, 9.4396e-05, -0.000107424, -0.000334709, 0.000102495, -0.000248224, 0.000313928, 0.000137153, -9.53693e-05, -0.000118303, 4.36091e-05, 0.000227705, -0.000130865, 4.46676e-06, 0.000178947, -7.93009e-05, -0.000328929, 3.32363e-05, -3.30804e-05, -0.000764634, -0.000338852, -0.000805771, -0.000168505, -0.000131161, -7.70238e-05, 5.95072e-05, 0.000126544, -0.000893801, 0.000429739, 0.000480316, -0.000288518, -4.19777e-05, 0.000109853, -0.000129511, 7.64826e-05, -0.000267419, 0.000109844, -0.000172677, 0.000189235, 0.000574193, -0.000960214, -0.000449416, 0.000141721, 7.09589e-05, 9.02446e-05, -0.000281664, 0.000313634, 5.00387e-05, 0.000206038, -7.34716e-05, 9.24452e-06, 0.000395577, 0.000147866, 0.000422805, 8.91238e-05, 6.49452e-05, 1.29058e-05, -1.87677e-05, -7.35848e-05, 0.000483496, -0.000157869, -0.000241154, 0.000102801, 3.27896e-05, 1.39731e-05, 0.000123781, -3.25181e-07, 0.000167795, -3.79486e-05, 7.62633e-05, -0.000116739, -0.000325915, 0.00044619, 0.000159392, -5.55801e-05, -3.96615e-05, -2.22992e-05, 0.000148545, -0.000184556, -2.74261e-06, 0.000110977, -0.000330074, 2.91411e-05, -0.000111857, 6.90556e-05, 0.000254029, -0.000163312, 8.00615e-05, 3.97131e-05, -6.31605e-05, -7.49908e-05, 0.000272273, 0.000104153, 3.89496e-05, 8.74987e-05, 0.000113109, 0.000212133, 0.000149613, 2.14323e-05, -5.5122e-05, 7.64001e-05, -0.000113235, 4.71252e-05, -0.000182156, 0.000223492, 6.66563e-05, -3.73323e-05, 7.11699e-05, -0.000179632, 0.000142934, -2.83037e-05, -7.75241e-06, -0.000130123, 0.000559193, -4.95433e-05, 0.000104523, -0.000277976, -0.000661007, 0.000237524, -0.000129396, -0.000208572, 0.000123512, 0.000188598, -0.000678939, 2.23458e-05, 0.0001112, -0.00039912, -0.000172682, -0.000256723, -0.000251189, 0.000236261, 0.000121083, -5.67428e-05, 0.000114136, -0.000135601, 0.000353267, -0.000686227, -0.000294912, 8.79318e-05, -0.000138699, 0.000263036, -0.000322009, 0.000102257, 7.84127e-05}},
    {"bert.encoder.layer.0.intermediate.dense.weight_transposed_grad", {3.41908e-05, -0.000192504, -0.000112533, -2.59823e-05, 5.23298e-05, 4.78255e-05, 9.32264e-05, 8.44374e-05, -2.6135e-05, -6.83309e-05, 6.98885e-06, -2.71645e-05, 1.90436e-05, 1.36984e-05, -2.44927e-05, 4.16041e-05, 4.47936e-05, 6.27947e-06, 0.000123291, -4.56149e-05, -0.000187925, 6.53819e-06, 3.28148e-05, -4.61406e-05, -8.28701e-05, 6.27186e-05, 7.82722e-05, -0.000189872, -5.73034e-05, -4.51538e-05, 0.000133947, 0.000111936, -0.000172791, -1.18549e-05, -0.000147374, 0.000115941, -9.07342e-05, -8.1465e-06, 0.000258943, 7.5036e-05, 8.62437e-05, -5.35076e-05, 3.97374e-05, 1.65995e-05, -0.000127455, 5.47454e-05, 0.000157635, 2.8489e-05, -5.80141e-05, -1.13737e-05, 2.71292e-05, 3.93608e-05, -9.91178e-05, -0.000176822, -1.19231e-05, -0.000124868, -0.000104084, 0.000278138, -0.000158312, -0.00018897, 8.40761e-05, -1.0764e-05, -8.75275e-05, -6.02101e-05, 0.000257004, -8.35006e-05, 7.33638e-05, -0.000132084, -7.66513e-05, 0.000130549, -1.50868e-05, 6.56602e-05, -0.000124959, 9.29501e-05, 0.000103166, 5.5382e-05, -9.51271e-05, 2.07315e-05, -2.14812e-05, 7.92862e-06, 0.000127362, -5.78207e-05, -8.53906e-05, -0.00014182, 6.70558e-05, 1.12912e-05, 6.76928e-05, 6.07087e-05, 2.28702e-05, -9.11677e-05, -0.000129915, -0.000162814, -7.33907e-06, -0.000149361, 4.90754e-05, -0.000128784, -0.000132213, 8.8337e-06, -7.67678e-05, 2.31054e-05, -1.19867e-05, 0.000110798, -0.000158907, -0.000130828, -4.79297e-05, 3.38323e-05, 8.46521e-05, -0.000114228, 3.97632e-05, 1.57797e-05, -9.6289e-05, -1.87065e-05, 4.41936e-05, -8.21591e-05, -0.00011077, 5.24187e-05, -0.000153547, 0.000217497, -0.000219266, -0.000101031, -1.38702e-05, 0.000155684, 0.000250663, 0.000129846, -0.000154754, 0.000132488, -8.2548e-05, -0.000185367, -6.67978e-05, -0.000132532, -0.00018899, 0.000209211, -7.20226e-05, -0.000269429, -8.04352e-05, 0.000121893, -4.97254e-05, -6.8749e-05, 2.0694e-05, 0.000183525, -8.50684e-05, 3.29006e-05, -1.32335e-05, 1.85789e-05, -0.00017825, 0.000264791, -2.95304e-05, -9.25998e-05, -0.000169118, -6.41725e-05, 4.30033e-05, 0.000127509, -0.000216363, -1.76462e-05, -0.000184352, 0.000115288, 0.000277224, 8.93632e-05, -0.000143929, -0.000150909, -0.000301816, 3.52943e-05, 6.57641e-05, -1.029e-05, -0.000130437, 7.38434e-05, 4.50166e-05, 0.000151802, -5.12062e-05, -0.000132971, -8.41032e-06, 5.80598e-05, 8.98332e-05, -1.05411e-05, -1.22129e-05, 8.89674e-05, -0.000202006, 5.19257e-05, -0.00018149, -3.99865e-05, -5.98225e-05, 0.000306388, -0.000103531, -0.00018707, 0.000111568, -4.99802e-05, -4.98772e-05, -4.87312e-05, -2.07083e-05, -4.86265e-05, -0.000118184, -2.1815e-05, -4.00558e-05, 6.58077e-05, -0.000105303, -0.000112918, 0.00010872, -3.20495e-05, -6.59349e-05, 8.77282e-05, -1.06906e-07, -4.35497e-06, 3.21113e-05, 1.35919e-05, 3.61818e-05, -4.22971e-05, 1.78583e-05, -3.77711e-05, -0.000144876, 0.000116698, 4.26029e-05, -2.31145e-05, 9.02219e-08, 7.21437e-05, -0.000102936, -4.87387e-05, -6.94184e-05, -8.39438e-05, 1.9165e-05, 0.000107916, -7.20785e-05, -9.76975e-05, -0.000100598, 4.96398e-05, 4.57089e-05, -4.33075e-05, -3.59845e-05, -8.93612e-05, -7.10648e-05, -2.35737e-05, 0.0001722, 7.58454e-05, -0.00015682, -5.1763e-05, -7.05565e-05, -0.000122666, 0.000159728, -3.90076e-05, 9.83994e-06, 5.50877e-05, -4.77627e-05, 0.000121832, -1.90187e-05, -6.51818e-05, -8.5178e-06, -3.42219e-06, 6.59409e-05, -5.45726e-05, -1.50203e-05, 1.34546e-05, 0.000101546, 8.44906e-05, -6.78903e-05, -3.93647e-05, -0.000124686, 0.000135353, -5.55411e-05, -9.91573e-05, 9.64966e-05, 0.000134887, 0.000174481, -3.56704e-06, 3.51074e-05, 9.89883e-05, -3.63371e-05, 8.38254e-05, -7.97243e-05, -0.000120559, -1.27941e-05, 1.59666e-05, 5.79453e-05, 0.000109293, 8.02616e-05, 6.10946e-05, -9.72828e-05, -0.000202034, -0.000141096, -0.000126903, -0.000173905, 0.000253163, -0.000137872, -0.0001237, 2.38565e-05, -5.27584e-05, -0.000101122, -2.08944e-05, 0.000124668, 1.9263e-05, -0.000128995, 1.14162e-05, -2.59132e-05, 0.000145452, -0.000123748, 0.000144435, 7.00225e-05, -6.20624e-05, 3.80364e-05, -3.3088e-05, 5.65315e-05, -9.89781e-06, -0.000104403, 3.00783e-05, -3.08319e-05, 9.01511e-05, 4.41473e-05, -6.81834e-05, -0.000122243, -0.000121598, -0.000157371, 4.23157e-05, -6.15855e-05, 6.66123e-05, -3.53329e-05, -1.08244e-05, 8.90706e-05, 4.49889e-05, -7.63675e-05, -0.000128951, 8.94751e-06, 5.31119e-05, -8.24318e-05, 4.53129e-05, -6.12407e-05, 8.87608e-05, -0.000128205, -8.00948e-06, -0.000133013, 2.81816e-05, 4.32424e-05, 0.000168397, -0.000230763, 1.06436e-05, -4.86826e-05, -0.000110821, -0.000270236, 3.63348e-05, 1.92995e-05, -0.000124142, 6.68665e-05, -0.000184813, 0.000263852, 0.00014452, -7.7277e-06, -0.000151829, -0.000143244, -0.000151954, 1.98667e-05, -0.000107411, 0.000199711, 0.000302958, 0.000156071, 0.000211555, 0.000293563, -0.000373538, 0.000165018, 0.000342378, -3.10776e-05, 1.90691e-05, 0.000107797, 3.60514e-05, -0.00020236, -7.51802e-05, 0.00013575, 3.59795e-05, 8.75838e-05, -0.000130154, 0.000303527, -0.000333297, -2.10443e-05, 4.69092e-05, -0.000109834, -0.000140018, -5.89899e-05, 3.04762e-05, -0.000141969, -0.000145703, 1.10006e-05, -1.292e-05, 0.000166823, -0.00013388, -0.000123229, 0.000116458, -0.000139694, -4.92009e-05, 0.000145082, -1.29206e-05, -0.000109656, -3.13664e-05, -8.966e-07, 7.47423e-05, -8.03263e-05, -5.3407e-05, -0.000160618, -9.5668e-05, 0.000182063, 6.01829e-05, -7.39474e-05, -4.54449e-05, 3.67294e-05, -0.000150078, -5.85637e-06, -6.03844e-05, -0.000209452, 0.000108783, 0.000110781, -7.60731e-05, -0.000152642, -4.54785e-05, -9.12468e-05, -7.44567e-05, -2.30998e-05, 3.71378e-05, -8.77203e-05, -2.80036e-05, -6.77329e-05, -3.20362e-06, -6.12863e-05, 3.26681e-05, 0.000199485, 7.27964e-05, -4.35009e-05, 0.000103454, 2.93847e-06, 2.60289e-06, -7.15852e-06, -3.92481e-05, 2.96817e-05, 1.77894e-05, 0.000128372, -3.82487e-05, -0.000129554, 0.000158229, 2.43004e-05, 2.91355e-06, -9.69133e-05, 0.000107476, -0.000114117, 6.55008e-05, -4.75295e-05, -6.79734e-05, -6.83885e-05, 0.000254317, -9.6394e-06, -6.0687e-05, -2.50273e-05, -0.000172523, 1.4754e-05, -0.000196559, 0.000149788, 2.27812e-05, 3.8684e-06, 3.37306e-05, -0.000125291, -2.9102e-05, 0.000108464, 0.000163428, 0.000209127, -9.10481e-05, -0.000110733, 0.000137728, 0.000324758, 0.000143951, 9.38863e-05, 0.000124668, -0.000120854, 0.000422421, 0.00020016, -0.000114194, 0.000105226, 0.000109497, 4.94563e-05, -0.000291215, 0.000337195, 0.000145026, 0.000176915, 7.25407e-05, -0.000108556, -7.66035e-05, -6.1387e-06, 7.55508e-05, 3.30419e-05, -6.94198e-06, -6.37491e-05, -8.19237e-05, -0.000111666, 3.37649e-05, -7.5756e-05, 0.000139141, -0.00010671, -7.83212e-05, -7.36572e-05, 8.96142e-05, 4.61255e-05, 7.08311e-05, -0.000117183, 4.53522e-05, -6.11841e-05, 2.97983e-05, -1.94117e-05, -2.9251e-05, -8.54729e-05, 8.94812e-07, 2.25108e-05, -5.34251e-05, -6.85377e-05, 2.82675e-05, 3.28247e-05, -1.58891e-05, -4.84936e-06, 8.61236e-05, 5.84659e-05, 5.26376e-05, 5.22136e-05, 9.07982e-06, -6.56767e-05, 4.42558e-05, -1.97249e-05, -2.46562e-05, -0.000241257, 6.79213e-05, 0.000196998, -5.69944e-05, -0.000140721, -0.00017141, -0.00025875, -1.86243e-05, 0.000392523, 0.000119244, -0.000257682, 2.31333e-05, -0.000232807, -0.000196147, 0.000194807, 5.95008e-05, 0.000125464, 0.000173725, -4.39579e-05, 0.000316831, 2.23165e-05, 0.00015654, -2.05889e-05, -0.00014139, 0.000361964, 1.29976e-05, -9.86319e-05, -3.34793e-06, 0.000435339, 8.71144e-05, -0.00022427, -0.000236243, -0.000288687, 0.000217512, 9.11875e-05, -0.000244506, 6.81604e-05, 3.02248e-05, -8.12646e-05, 0.000142841, 6.64238e-05, -5.27973e-05, 0.000135292, -0.000248723, 0.000274676, 0.000160157, 9.49321e-05, -0.000223104, -0.00029569, -0.000146436, 0.000106904, -0.000141739, 0.000151663, 0.000220269, 0.000137774, 0.0001574, 0.000146456, -0.000292869, 2.33712e-05, 0.000299976, 0.000108664, -0.000157465, 1.65019e-05, 7.8906e-05, -9.34175e-05, -0.000177634, 0.000148733, -5.72735e-05, 3.17709e-05, -2.3867e-05, 0.000210343, -0.000369506, 4.13098e-05, 0.000141466, -7.42125e-05, 0.000190154, 7.21187e-05, -8.8041e-05, 7.72538e-05, -0.000144856, -8.16888e-06, -0.000204707, -3.6264e-06, 7.81372e-05, 8.96532e-05, 0.000121926, 5.83504e-05, -0.000159412, 0.000121694, -5.36185e-05, 9.63075e-06, 6.42578e-05, -0.000154857, 5.63949e-05, 0.000229182, 0.000181186, -7.80438e-05, -7.85437e-05, 0.000187277, -5.54327e-05, -6.50458e-05, 7.22534e-05, 0.000341805, 5.93828e-05, -6.31782e-05, -0.000148432, 2.25508e-05, -7.14462e-05, 0.000240657, -8.49389e-05, 4.10427e-05, -0.000101936, -0.000157277, -2.28834e-05, -5.10151e-05, -6.69215e-05, -2.93814e-06, -1.28732e-05, 5.15274e-05, 0.000120391, 2.7291e-05, -4.95089e-05, 3.1907e-06, -6.81717e-05, -0.000148159, 4.03831e-05, 7.90566e-05, 7.72432e-05, 9.79018e-05, 0.000106356, 9.60185e-05, -0.00015238, -3.06559e-05, 5.6648e-05, -3.34466e-05, 9.54473e-05, 7.87049e-06, -1.6782e-05, -0.00015734, 3.1514e-05, 0.000138166, 2.22757e-05, 9.14556e-05, -0.000123241, 7.41661e-05, -0.000152951, -1.96052e-06, 5.57213e-05, 0.000135964, 0.000289443, -1.26807e-05, 8.46878e-05, 0.000173135, 2.85924e-05, 0.000206324, -0.000207454, -0.000261338, 9.22966e-05, 0.00027412, 8.80062e-05, 0.000262566, 5.6325e-05, -1.80591e-05, -0.000125878, -0.000195612, -0.000138611, -0.000231207, -0.000238681, 0.000426519, -1.88695e-05, -0.000271493, 5.68862e-05, -0.000112099, -0.000122779, 6.01682e-06, 0.000163416, 2.58593e-05, -5.78366e-05, 7.79633e-05, -2.93659e-05, 0.000279621, -0.000384475, 0.000267353, 9.27942e-05, -2.56117e-05, 0.000248398, 0.000126319, -0.000111491, -0.000121057, 0.000203248, 7.35516e-05, 0.000136659, -6.9951e-05, -0.000387238, -0.000111395, 0.000227048, 5.21128e-05, 0.000316179, 9.63284e-05, -0.000140771, -0.000113208, 2.52189e-05, -0.000187726, -6.76928e-05, -0.000208117, 0.000132836, 4.64677e-05, 1.51408e-05, 3.35902e-05, -0.000201686, 2.52841e-05, 8.9383e-05, 6.81357e-05, -4.76209e-05, -0.00014697, 0.000115042, 3.27623e-05, 0.000205525, -0.000362821, 0.00017407, 0.00015844, -6.40276e-05, 0.000173609, 0.000410844, -7.53849e-05, 4.9223e-05, 0.00017487, 4.07253e-05, 0.000297668, -0.000355219, -0.000328175, 0.000111946, 0.000391915, 0.000146912, 0.000306049, 7.16015e-05, 4.03767e-05, -0.000248732, -0.000365588, -0.000191091, -0.000287085, -0.000457716, 0.000593588, -7.1976e-05, -0.00045986, 7.92036e-05, -7.03404e-05, -0.000152637, -3.60169e-05, 0.000208098, 2.05639e-05, -9.62331e-05, 3.79227e-05, -3.55295e-05, 0.000306555, -0.000496814, 0.000442586, 0.000138886, -3.26837e-05, 3.37822e-05, 0.000179113, 0.000143829, 0.000134758, -3.49787e-05, 0.000124446, -0.00013049, 8.94142e-05, 5.93032e-05, 0.000244142, -3.26716e-05, -0.000279196, -0.000171754, 0.000111223, -5.2418e-05, 3.29914e-05, -8.11751e-05, 7.78253e-05, -3.25499e-05, -6.77556e-05, 4.7736e-05, -0.00020194, 0.000116475, 0.000208897, -0.000213595, -0.000126403, 2.77986e-05, 0.000141605, -0.000242022, 0.00017821, -0.000154977, 1.29599e-05, 0.0002507, 0.000105889, -0.000217632, 2.31723e-05, 0.000221756, 0.000106362, -4.50318e-05, 3.63545e-05, 2.65163e-05, 9.03202e-05, 0.000217166, -4.60763e-05, 0.000219733, -0.000147734, 5.78611e-05, 6.88054e-05, -0.000180862, 5.80671e-05, 0.000190868, -0.000345529, 8.72618e-05, 0.000168153, 4.54979e-06, 0.000122531, -3.52978e-05, -0.000194141, 8.38937e-05, 0.000236203, 0.000151278, -0.000282108, 3.0978e-05, 9.02365e-05, -5.06169e-05, -0.000210389, 0.000112448, 0.000119204, 0.000135044, 0.000106775, -3.22219e-05, -0.000226178, 0.000136328, 6.87588e-05, -8.09313e-05, -7.84301e-05, 9.68855e-05, 5.37967e-05, -3.37164e-05, 9.35912e-05, -6.4919e-05, 0.000138833, 7.48631e-05, 2.95872e-05, -1.5742e-05, -0.000172265, -0.000156341, 7.14644e-05, -0.000141077, 7.14315e-05, 0.000112195, 0.000124212, 5.55325e-05, 0.000158003, -0.000208542, 0.000135367, 0.000192213, 5.76695e-05, 3.9053e-05, 6.34395e-05, 6.09111e-06, -5.83218e-05, 8.74249e-05, 0.000140626, 3.24787e-05, -2.95144e-05, -0.000123208, 0.000146423, -0.000151756, 2.61542e-07, 4.83865e-05, -4.47349e-05, 2.85375e-05, 5.29488e-05, -3.94686e-05, -6.27687e-05, -7.20195e-05, -4.49993e-05, 6.92279e-06, 6.57727e-05, 5.12058e-06, -7.12571e-05, -8.37335e-05, -0.000117612, -0.000101234, 4.28705e-05, -1.42449e-06, -1.30109e-05, -3.48955e-07, -3.75036e-05, 6.29792e-05, -4.85769e-06, -7.58664e-05, 5.68108e-05, 3.75054e-05, 3.64175e-05, -1.96575e-05, -6.05366e-05, 0.000118195, 8.59299e-05, 4.0542e-05, -9.1479e-05, -5.63227e-05, -1.4149e-05, 0.000164667, -7.91278e-05, -6.89653e-05, -6.09307e-06, -0.0001434, -0.000383231, -9.8386e-05, -2.50196e-05, -0.000199711, -0.000135247, -0.000116002, 0.000187388, 0.000229893, -0.000187688, -0.00024503, 7.61088e-05, -0.000208823, -9.19254e-05, 7.82919e-05, 0.000149226, 7.04731e-05, 4.61403e-05, 0.000230554, 0.000205974, -0.000459128, -5.05077e-05, 0.000140379, -8.61865e-05, 5.73909e-05, 0.000111125, -9.06938e-07, -0.000213752, -0.000184526, -9.00038e-05, -2.60352e-07, 9.98747e-05, -0.000260872, 0.000345351, -0.000224224, -7.42269e-05, -0.00011047, 0.000116353, -0.000334187, -6.18383e-05, 0.000192128, -7.00342e-05, 0.000246667, -0.00017563, 0.000388116, 2.84617e-05, -0.000191826, -0.000238031, -0.000155233, -0.000141389, 0.000331064, -0.000221127, 0.000149405, 0.000181968, -1.26481e-05, 0.000318244, 0.000114572, -0.000600611, -0.000129816, 0.000360659, 0.000100503, -0.000280246, 9.49085e-05, 0.000146456, -0.000215489, -0.000476418, -0.00015894, 6.34824e-05, 0.000147071, -6.18925e-05, 0.000172652, -0.000309854, 0.000142952, 3.88396e-06, 0.000173153, 7.67735e-05, -5.07594e-05, 8.96484e-05, 9.66169e-05, 0.00019139, 8.62402e-05, 9.7597e-05, -0.000136356, -2.20381e-05, 5.50078e-06, -0.000114259, 4.1388e-05, 0.000193924, -0.000145637, -4.65827e-05, -6.68824e-08, -6.62577e-05, 9.636e-05, -0.000136373, -2.33857e-05, -0.000181641, 7.61906e-05, 0.000157278, -0.000274305, -3.12463e-05, 0.000103547, 4.98125e-05, -0.000353689, -7.06725e-05, 0.000104662, 9.48739e-05, 0.000165587, -0.000137631, -0.000145254, 0.000109313, 6.04163e-05, 3.92065e-05, 9.98114e-05, -3.43865e-05, -0.000129613, 0.000180223, -3.63453e-05, 0.000126948, -0.000213373, -0.00019228, 6.35996e-06, 0.000233604, 0.000203594, 0.000256165, -9.3361e-05, -6.38738e-06, -8.05023e-05, 8.98417e-05, -1.37343e-05, -7.61745e-05, -8.51853e-05, 0.000244957, 0.000213877, -0.000112918, -0.000101268, 7.26708e-05, -1.90133e-05, 2.07842e-05, 5.97392e-06, 0.000241944, -4.67844e-05, 0.000105711, -3.90477e-05, 6.95771e-05, -0.000291301, 0.000237619, 3.21954e-05, -1.7677e-05, -8.29217e-05, -1.74411e-05, 6.93516e-05, 4.53476e-05, -0.000128714, 1.45134e-05, -7.35894e-05, 3.0356e-05, 0.000105482, 9.27776e-05, -2.65602e-05, -7.43113e-05, -0.000110047, -3.52212e-05, 1.33372e-05, 3.6188e-05, -7.85535e-05, -4.95683e-05, -4.31727e-05, 9.30399e-05, 3.01478e-05, -0.00012822, 7.72958e-05, 7.00486e-05, -1.42188e-05, -3.16569e-05, -6.05925e-05, 6.96535e-05, -0.000121306, 0.000107261, -5.43205e-05, 2.68407e-05, 2.58283e-05, 0.000278578, -0.00014534, -9.30343e-05, 4.24255e-05, 0.000114677, -0.000111516, -0.000165875, 2.39174e-05, -9.75752e-06, -7.72853e-06, 0.00011112, 1.47641e-06, -0.000163753, -0.000206014, 8.5721e-05, 0.00010849, 0.000146867, 9.80254e-05, 3.68118e-06, -3.16716e-05, -5.28864e-05, -0.000158582, -4.8693e-05, -7.3972e-05, 3.88533e-05, 1.27746e-05, -9.14113e-05, -6.16911e-05, -1.27396e-05, 8.25603e-05, 2.43375e-06, -5.1453e-05, -0.000129761, -0.000206283, 9.89371e-05, 6.71746e-05, -1.02367e-05, -0.000159052, 0.000153641, 0.000117706, -0.000208584, -6.7962e-05, 0.000234235, 0.000108479, -3.26146e-05, 0.000126504, -8.6355e-05, 4.3622e-05, -0.000268912, -1.88236e-06, 0.000152377, 8.92572e-05, 0.000130654, 9.39348e-05, -0.000137255, 0.000118602, -7.00737e-05, -3.43966e-05, 7.62283e-05, -0.000131696, -7.72037e-05, 0.000313039, 0.0001508, -0.000156671, -7.30312e-05, 0.000186955, -9.16925e-05, -3.65693e-05, 7.2811e-05, 0.000434086, 7.74021e-05, -2.4213e-05, -0.000179179, -7.41609e-07, -0.000167595, 0.000259435, -7.43874e-05, 5.82138e-05}},
    {"bert.encoder.layer.0.output.dense.weight_transposed_grad", {1.05829e-05, 2.73153e-06, 7.41689e-06, 6.80126e-05, -1.49794e-05, 2.87617e-05, 0.000165734, -0.00022963, -9.23656e-06, 6.46277e-05, 4.99736e-05, -3.96984e-05, 5.45857e-05, 4.84501e-06, 1.10349e-05, -4.19692e-05, 6.69497e-05, -5.29011e-05, 3.49572e-05, -8.72878e-05, 9.02106e-05, -2.21416e-05, 2.51683e-06, 1.26784e-06, -5.74159e-05, -0.000240425, 2.03217e-05, -6.90835e-05, -0.0001347, 2.10617e-05, 2.42695e-05, 0.000269607, -6.09647e-05, 7.19724e-05, -0.000154054, -0.000106532, -1.61351e-05, 0.000124915, -0.000186599, 0.000251655, 0.000166579, -7.97533e-05, -0.000158531, 6.25496e-05, -0.000109944, -0.000105301, 0.000104596, 5.34656e-05, -0.000125148, 0.00013053, 7.05116e-05, -7.11665e-06, -0.000122646, 0.00015341, -1.71007e-05, -0.000178352, 1.41327e-05, 0.000201863, -3.1032e-06, 0.000175565, 0.000188498, -1.85809e-05, -8.09033e-05, -0.000239478, 5.13638e-05, -7.03721e-05, 0.00018912, 0.000120151, -4.19236e-05, -0.000167373, 9.77182e-05, -0.000192526, -0.000125687, 0.000114087, 0.000129881, -7.86724e-05, 0.000152279, 0.000170875, -9.7841e-05, -0.00012918, 0.000139323, -0.000143506, -0.000118225, 4.42024e-07, 0.000150992, -0.000151265, 4.57381e-05, 0.000262425, -6.34598e-05, -0.00022333, 4.18588e-05, -0.000230453, -0.000186797, 1.38041e-05, 0.000122157, 0.000218395, -0.000129887, -2.60606e-05, 0.00015794, -0.000163534, -0.000194017, -0.000263327, -0.000326647, 0.000942519, -7.88518e-05, -0.000198581, 0.000135953, -7.13238e-05, -0.000249716, -8.40447e-06, 0.00026712, -0.000139836, -0.00010252, 0.000304319, -0.000286877, 0.000424224, -7.73154e-05, 0.000198816, -0.00017881, 0.000124652, 0.00010134, 0.000296326, 7.54979e-05, 4.20081e-05, -0.00016081, 9.09341e-05, 0.000109604, -0.000614735, -0.000155544, 4.07058e-05, -0.000156158, -8.5958e-05, -3.91192e-05, 0.000115658, -7.19818e-05, 0.000300876, 7.59616e-05, -0.000104982, -3.67033e-05, 4.50559e-05, -0.000194599, -0.000168017, 0.000204476, -4.58791e-06, -8.04184e-05, 0.000199056, 6.29393e-05, 7.99107e-05, 2.36057e-05, 0.000202992, -9.18629e-05, -0.000176693, 1.08423e-05, 3.62013e-05, -4.95696e-05, 0.000111975, 2.34292e-05, -1.38597e-06, 2.98443e-05, -0.000145948, -1.74599e-05, -7.28853e-05, 0.000199756, -4.63594e-05, -3.64403e-05, -0.000200192, -5.79348e-05, 0.00012187, -0.000123366, 3.83456e-05, 0.000111407, -5.73197e-05, 2.78538e-05, 0.000147325, -7.57031e-06, -0.000141046, 1.87749e-05, -4.99213e-05, -5.64053e-05, 7.92884e-05, 0.000107702, -6.83326e-05, -4.07456e-05, 0.000261028, 3.32181e-06, 1.82137e-05, 7.99554e-05, -0.000179572, -0.000101836, -5.34933e-05, 2.03654e-05, 7.56732e-05, 6.25239e-05, -7.24598e-05, 0.000185289, 9.45304e-05, -6.46951e-05, -0.000160788, 9.52857e-05, -0.000107872, -0.000108111, 9.61804e-05, 0.000132807, -7.97552e-05, 0.00011383, 0.000149047, -0.000104875, -8.74899e-05, 8.53779e-05, -3.48985e-05, -9.42723e-05, 3.72587e-06, 9.89144e-05, -0.000120581, -3.32979e-05, 0.000212994, -5.73203e-05, -0.000187466, 5.96771e-05, -0.000170416, -0.000220733, 6.44847e-05, 9.92046e-05, 0.000151159, -3.45665e-06, -2.10468e-05, 0.000216311, -8.70721e-06, 3.17898e-06, -0.000211365, -0.000178196, 0.00028102, -0.000153084, -1.14189e-05, 0.000139239, -2.63277e-05, 4.41277e-05, 0.000102734, -3.73968e-05, -0.000113357, 2.36845e-05, -1.55417e-05, -0.000212371, 0.000215144, 1.0828e-05, -0.000180912, -2.8959e-05, 0.000232057, 6.33136e-05, 0.000130592, 9.28412e-08, -9.8754e-05, -7.44674e-05, 6.0068e-05, 0.000100781, -0.000247811, -5.16417e-06, -5.5604e-06, 5.74374e-05, -7.31766e-05, -6.52306e-05, -0.000108834, -8.14454e-05, 9.46873e-05, 1.92968e-05, 2.9697e-05, 9.28784e-06, -1.07148e-05, 2.41982e-06, 1.30054e-05, 8.64346e-05, -9.74008e-05, 4.42583e-05, -8.66431e-05, -3.51712e-05, 8.10733e-05, 7.31623e-05, -1.23076e-05, 1.04095e-05, 0.000139155, -3.30276e-05, 1.58586e-05, 0.000142302, -0.000111757, -5.42555e-06, -0.000126255, 5.06438e-05, -1.1015e-05, 2.52404e-05, 4.37316e-05, -0.000123259, -0.000141071, 0.000279297, 0.000153465, -0.0003568, 0.000228559, -3.30353e-05, -0.000143122, -4.01013e-05, 0.000178637, -7.69069e-08, -0.000236785, -0.000114022, 0.000127106, -0.000289466, 3.67253e-05, 0.000136697, 0.000190203, -0.000298225, -0.000217051, -1.68097e-05, -0.00018828, 0.000256203, 0.000601372, -7.72288e-05, 0.000203633, 0.000503441, -3.65861e-06, -0.000151539, -0.00053378, 6.80502e-05, -3.61083e-05, 7.69615e-05, -0.000143649, -6.54723e-06, -9.97067e-05, -0.000219931, 9.64903e-05, 6.14582e-05, -6.81698e-06, -9.73633e-05, 2.24089e-05, 3.55304e-05, -2.96688e-06, -9.5492e-06, -3.30116e-05, -6.52226e-05, -0.000144937, 3.45653e-05, 7.82763e-05, -9.98962e-05, -3.25322e-05, 4.07353e-05, 0.000103591, 4.61044e-05, 0.000317229, 0.000221854, -7.34415e-05, 0.000261602, -0.000194722, -0.000116296, -8.21591e-05, -0.000180579, 7.84927e-06, -0.000100324, -7.54393e-06, -0.000318093, -5.77499e-05, 0.000102988, 0.000134312, 0.000227589, 9.23087e-05, -0.000189988, -6.38298e-05, -5.58838e-05, 2.44119e-05, 0.000153221, -3.82788e-05, 0.000138748, 0.000182906, 3.39856e-05, -0.000246223, 0.000238849, 0.000381839, -2.06658e-05, 4.16268e-05, -0.000262129, -0.000329883, 4.41298e-05, -6.42063e-05, -0.000152782, 5.31485e-05, 5.76984e-05, 0.00017255, 1.39165e-05, 9.64622e-05, -0.000240932, 4.765e-05, 0.000396791, 0.000311977, -0.000186763, 1.80001e-05, -0.000126042, -0.000199758, -2.65968e-06, 0.000176588, 1.58051e-05, -0.000208444, -0.000135695, 0.000186796, -0.000240532, 0.000109954, 9.38886e-05, 0.000124865, -0.000210432, -0.000329467, -2.12123e-05, -0.000307495, 0.000305333, 0.000385464, -0.000396394, 0.000318072, 0.000330284, 0.000160743, -6.78168e-05, -0.000418947, -9.47346e-05, 8.45982e-06, -5.99176e-05, 5.23094e-05, -0.00013241, -1.90032e-05, 7.56669e-05, 0.000178619, 1.89408e-05, -4.17491e-05, -5.81289e-06, -3.8802e-05, -9.42551e-05, 5.77911e-06, 0.000118153, -7.27372e-06, 6.98494e-05, 0.000206866, -7.54336e-05, -1.09134e-05, 0.000104158, 0.000168024, -7.16478e-05, -1.94245e-05, -8.23354e-05, -0.000196432, -9.13617e-05, 4.75111e-05, -0.000211589, 0.000130626, 0.000111923, -4.37905e-05, -1.31856e-05, -2.66982e-05, 0.000155712, -0.00010203, -4.35557e-05, -0.000198221, -0.000261698, 0.000420353, -6.84218e-05, -4.57563e-05, 8.67167e-05, -2.47919e-05, -4.93003e-06, 1.61616e-05, 4.23053e-05, -0.000106218, -3.6021e-05, 3.29804e-05, -0.000175361, 0.000268194, -4.52749e-05, -8.18559e-05, -4.54373e-05, 0.000192175, 8.05909e-05, 0.000235957, 8.70739e-05, -6.64858e-05, 2.65401e-05, 1.21522e-05, 8.46222e-05, -0.000395592, -1.93137e-05, -5.30488e-05, 0.000223204, -6.7153e-05, -0.000284927, -0.000310336, -9.98187e-05, 0.000243352, 9.19044e-05, 5.66099e-05, -5.54653e-05, -9.02748e-05, 6.27294e-05, 0.000142137, 7.8333e-05, -0.000160146, 0.0001435, -4.39947e-05, -0.00018208, 3.49603e-05, 0.000106554, 9.74373e-05, 3.79957e-05, 0.000308534, -0.000115949, -1.5922e-05, 0.000223181, -0.000246302, -8.54785e-05, -7.83895e-05, 6.71235e-05, -8.9552e-06, -2.91652e-05, 4.95285e-05, -6.1689e-05, -8.24505e-05, 9.07779e-05, 0.000108807, -0.000187164, 0.000190551, 3.06526e-05, -0.000171861, -6.90096e-05, 9.64089e-05, -6.22746e-05, -0.000190378, 5.61916e-05, 5.55111e-05, -9.75016e-05, 2.67295e-05, -1.32686e-05, 0.00017417, -0.000200119, -1.91959e-05, 8.3358e-06, -0.000207472, 0.000165256, 0.000395088, 5.24055e-06, 0.000114766, 0.000273269, -6.58964e-05, -0.000116456, -0.000267382, -1.5948e-05, 3.47444e-06, -0.000131557, -2.48847e-05, -1.45896e-05, 9.69908e-05, 1.29231e-05, -0.000116732, 0.000120365, 5.17002e-05, -0.000175233, 5.49644e-05, 1.67315e-06, -3.10341e-05, -4.5343e-05, 9.18494e-05, -1.87382e-05, -1.91973e-05, 0.000165245, -0.000180634, -2.55285e-05, 0.000128719, 5.0112e-05, -8.42748e-05, -8.16794e-05, 1.91487e-05, 1.97535e-05, 6.02417e-05, 0.000164217, -5.72561e-05, -0.000117926, 9.9179e-05, 6.41319e-05, -8.71456e-06, 0.000155637, 4.92741e-06, 0.000175466, -7.00283e-05, -0.000204252, 0.000248773, -0.000250321, -0.000101637, 0.00020473, 5.50455e-05, 8.62952e-05, -1.60033e-05, -0.000143946, -2.08125e-06, -0.000135273, 4.5079e-05, -0.00015098, 0.000306704, -0.00019208, -0.000373059, -6.77296e-05, 6.04485e-05, 0.00026203, 0.000366663, -0.000141962, 4.64515e-05, 6.20429e-05, 0.000139656, 4.1089e-05, -0.000467102, -5.29703e-05, 8.24432e-05, -0.000193917, -0.000152556, 9.88429e-05, 0.000217592, -0.000286285, 0.000304133, 0.000142203, -0.000202013, -0.000169698, 0.000177653, -7.18424e-05, -0.000297709, 2.73497e-05, 0.000140289, -0.000271069, 0.000181979, 0.000145607, 0.000100435, -0.000323122, 3.7415e-05, -6.09707e-05, -0.000360716, 0.000203977, 0.000542309, -5.16168e-05, 0.000258325, 0.000460442, 7.57549e-06, -0.000215869, -0.000418215, 3.66925e-05, 1.59994e-05, 5.76114e-05, -0.000209338, 2.66732e-05, -0.000101051, -0.000285078, 0.000302817, 8.69053e-05, -2.20999e-05, -4.24339e-05, 2.73141e-05, -5.5477e-05, -5.09228e-05, 4.79471e-05, -6.81102e-06, -0.000108557, -6.68996e-05, -1.77181e-05, 0.000149417, -0.000130131, -2.45164e-05, 1.91887e-05, 9.69086e-05, 7.34003e-05, 0.000323158, 0.000149906, 3.21397e-05, 0.000201323, -0.000132074, -4.41041e-05, -0.000350191, 2.64532e-05, -2.16417e-05, 7.90382e-05, -1.05474e-05, -3.67274e-06, -6.76659e-05, -3.65697e-05, 1.8252e-05, -3.71372e-05, -2.51601e-05, 1.23158e-05, 1.27617e-05, 3.87449e-05, 4.37727e-05, -3.91654e-05, -8.43496e-06, 8.2639e-06, -4.42667e-05, -4.37879e-05, 4.34486e-05, -2.35179e-05, -7.51091e-05, 2.02448e-05, 6.33498e-05, 4.65538e-05, 0.000123882, 4.71448e-06, -5.34135e-05, 4.99041e-05, -5.2319e-05, -1.24881e-05, -3.68027e-05, -0.000100209, -4.27358e-05, -6.71325e-05, 6.59714e-05, -0.000256758, -3.38456e-05, 0.000249951, -0.000129023, 0.000158941, 0.000132319, -0.000169925, -5.83278e-05, 4.86619e-05, 5.46231e-05, -1.6608e-05, 3.68527e-05, 0.000121466, 9.13863e-05, 0.000104578, -0.000332497, 0.000188012, 0.000292833, 1.7626e-06, 3.66495e-05, -0.000231423, -0.000342921, 2.76636e-05, -7.86345e-05, -0.000139691, 5.99287e-05, -2.97466e-05, 0.000357879, 6.53737e-05, -6.18384e-07, 6.05564e-05, 9.03454e-06, 8.32564e-05, -3.58321e-05, -7.30244e-05, -4.6885e-05, -6.85174e-05, 2.20952e-06, 4.38373e-06, 2.5369e-05, 6.64875e-05, 2.99256e-05, -8.61482e-05, 1.77557e-05, 1.62709e-05, -7.06441e-05, -8.39414e-05, 9.65226e-05, -5.63355e-05, -0.00015775, 4.09571e-05, 6.05325e-05, 6.01593e-05, 0.00014744, -2.84929e-05, -6.5345e-06, 5.20355e-05, -3.98464e-06, 2.6406e-05, -0.000145968, -6.62881e-05, 5.34536e-05, -8.25945e-05, -3.96519e-05, -3.38875e-05, 9.77159e-05, 1.68629e-05, 0.000140779, 9.86982e-05, -7.78776e-05, -2.96983e-05, -2.87273e-05, -0.000168767, -5.19185e-05, 0.000164153, 2.2483e-05, -2.93456e-05, 0.00010238, -2.6112e-05, 2.76785e-07, -3.48334e-05, 0.000220993, -2.17683e-05, -0.000179978, -1.42963e-05, -2.48438e-05, -1.14195e-05, 0.000120926, -5.84969e-05, -1.14308e-05, -1.46202e-05, -3.21664e-05, -9.00645e-05, 1.14486e-05, -6.5874e-05, -6.93792e-05, -0.000157044, -3.51383e-05, -8.76521e-05, 0.00026081, 0.000128586, -4.48682e-05, -0.000118245, 8.81179e-06, -6.63234e-05, -4.9592e-05, 0.000108423, 1.06105e-05, -3.12086e-06, 0.000137838, 1.19258e-06, -3.71274e-06, 3.62095e-06, 0.000181922, -1.30874e-05, -1.09251e-05, -3.7416e-05, 6.28345e-05, -6.73109e-06, 2.69244e-05, 6.61762e-05, 1.04288e-06, 3.97338e-06, -0.000155041, 3.49359e-05, 5.00495e-05, -0.000220631, 0.000145572, 0.000139402, 0.000235714, 0.00021978, -0.000386411, -1.16171e-05, 1.03077e-05, -4.1802e-05, 5.07838e-05, 1.91375e-05, -1.10585e-05, -7.17531e-05, 0.000128947, 1.58904e-05, 1.18813e-05, 0.000145345, -0.000211523, 3.33875e-05, -3.47318e-05, 3.36488e-05, -0.000197071, -3.37335e-05, -0.000227954, -0.000217562, 0.00014733, -3.15588e-05, 7.40201e-05, -1.56412e-05, 0.000216916, -5.00907e-05, -2.42162e-05, -5.75602e-05, 9.83087e-05, -0.00017643, -6.60951e-05, 0.000197548, -0.00012649, 7.27279e-05, 0.000100522, -8.26065e-05, -7.29829e-05, 8.71369e-08, 0.000113226, 5.01447e-05, -1.63293e-05, 0.000176842, 3.75686e-05, -1.15201e-05, -0.000213739, 0.000212437, 0.000212911, 2.92154e-05, 8.53445e-05, -0.000225311, -0.000375805, 5.09604e-06, -6.96314e-05, -0.000214754, 3.94901e-05, 8.18312e-05, 0.00027026, -2.019e-06, 2.25122e-05, -4.7327e-05, 5.41098e-05, 0.00027912, 0.000116614, -0.000127996, 4.44643e-05, -0.000228083, -3.45729e-05, 0.000153081, 9.43799e-05, 4.00898e-06, -6.45479e-05, -0.000125618, 1.97428e-05, -0.000171231, 2.89535e-05, 3.42557e-05, 0.000156879, -9.53545e-05, -0.000247713, -5.00518e-05, -7.3619e-05, 0.000178497, 0.000129725, -0.000234143, 0.00014067, 7.09795e-05, 0.000171444, 3.65666e-05, -0.000233726, -2.88598e-05, -7.18333e-05, 0.000157603, 3.28238e-05, -0.000236159, -0.000183406, 0.000127026, 1.4526e-05, 3.46391e-05, 9.85425e-05, 3.91354e-05, -0.00011867, 2.72574e-05, 0.000151281, 6.57735e-05, -0.000139478, 0.000139301, -2.41226e-05, -9.31223e-05, -6.76286e-05, 0.000176752, 0.000152286, -2.22801e-06, 0.000224365, -0.000152757, -0.0003063, 0.000164282, -0.000206392, -0.000290949, -4.38889e-05, 8.72019e-05, 0.000273, -5.8033e-05, 0.000106431, -0.000291498, 5.00692e-05, 0.000332645, 0.000426393, 7.55107e-05, -8.52027e-05, -5.41522e-05, -0.000137283, 7.27562e-06, 0.000118506, -0.000164132, -0.000241631, -4.07879e-05, 0.000209917, -0.00024573, 0.000183841, 0.000208575, -5.58596e-05, -0.000174079, -1.21497e-05, -7.95775e-05, -0.000518089, 0.000183494, 0.000132211, -0.000360938, 0.000389491, 0.000115956, 0.000188831, -0.000130714, -7.92896e-05, -2.12039e-05, -1.04879e-05, -5.9099e-05, 2.91696e-05, -6.1523e-05, 1.2099e-06, 3.87574e-05, 4.53459e-05, 1.00928e-05, -2.39693e-06, -5.12663e-06, -3.55002e-05, -6.91694e-05, 2.95482e-05, 8.24036e-05, 4.97682e-06, 2.12042e-05, 6.24599e-05, -1.21181e-05, -1.68727e-05, 5.48939e-05, 0.000115638, -1.92608e-05, -5.89122e-06, -5.61511e-05, -0.000157877, -2.40188e-05, 3.78485e-05, -0.000107552, 4.02304e-05, 6.70616e-05, 2.34076e-05, -5.28731e-05, 8.8701e-05, -3.3164e-05, -6.81314e-05, 0.000165058, 6.96727e-05, -0.000320378, 0.000397899, -8.48445e-05, -0.000127507, 6.33656e-05, 7.33045e-05, -0.000107059, -0.000106418, 5.82921e-05, -1.92497e-05, -0.000174299, 7.10779e-05, -0.000102836, 0.000277975, -0.000165632, -8.98539e-05, -4.29264e-05, -0.000125862, 0.0001784, 0.000325909, -8.80851e-05, 0.000175331, 0.000137859, 8.83559e-05, 1.05549e-05, -0.000472637, 8.48156e-05, -2.98605e-05, 5.24303e-05, 8.42164e-06, 4.72737e-05, 3.56107e-05, 7.81512e-05, -0.000191237, 3.35453e-06, 1.2308e-05, 2.99059e-05, -1.49276e-05, 6.23504e-05, -3.87043e-06, -8.94936e-05, 5.70522e-05, -4.09872e-05, -7.21231e-05, 6.20286e-05, -5.03869e-05, -7.51097e-05, -9.15477e-05, -4.71422e-06, -3.96859e-05, 5.98123e-05, 1.80614e-05, 1.19157e-05, -1.06869e-05, 5.06289e-05, -2.19388e-05, -6.72834e-05, 0.000129732, -3.72131e-05, -2.72971e-05, -4.74094e-05, -0.00021474, -0.000100302, -0.000157092, -0.000424695, 0.000546574, 7.39125e-05, -1.92817e-05, -0.000158309, 7.12817e-05, -1.677e-05, -3.23797e-05, 7.62388e-05, -4.10985e-05, -0.000133126, 3.62421e-05, -1.1447e-05, 0.000178155, -0.000102024, 9.2983e-05, 1.53302e-05, 0.000178605, 4.78444e-05, 0.000360526, 0.000160596, 2.74537e-05, 0.000277684, -7.27898e-05, -1.57226e-05, -0.000531731, -0.00010766, 1.25453e-06, 0.000122046, -0.000250557, -0.000315794, -0.000253688, -0.000251282, 0.000606254, 0.000197355, 1.83735e-06, -6.4762e-05, -8.58036e-05, -0.000222777, 1.96563e-05, 0.000348911, -0.000184565, 3.98769e-05, 5.10936e-05, -0.000181462, 0.000186831, 3.30635e-05, 0.000396446, -2.98073e-05, 0.000174881, -0.000127611, 7.00432e-05, 0.000358104, -8.9908e-05, -0.000108949, -0.000170172, 5.6116e-05, -0.000218972, 5.73617e-05, -9.42021e-06, 3.40419e-05, 0.000107096, 0.000252888, 0.000133376, 9.35477e-05, -0.000291835, -0.000212572, 5.01338e-06, 0.000158751, 5.16428e-05, 8.19707e-05, -3.13373e-05, -0.000197071, 4.4265e-05, -8.26719e-05, -7.62096e-05, 7.36815e-05, 4.03586e-05, -6.80406e-05, -0.000281578, -1.94382e-05, -8.92502e-05, 0.000143191, 4.15836e-05, -0.000170436, 3.93121e-05, 1.39955e-05, 8.9917e-05, -2.84061e-05, 9.62729e-05}},
    {"bert.encoder.layer.0.attention.self.query.bias_grad", {-6.687611e-06, 1.6070469e-06, -2.2636264e-06, 3.287017e-06, -4.0472746e-06, 6.9241287e-06, -1.137259e-06, -3.1147995e-06, 4.1284006e-06, 2.6566624e-06, -1.8900233e-06, -1.4234862e-06, -3.3316949e-06, 2.8092402e-06, 8.8742564e-07, -1.1331476e-06, 3.4680312e-07, -9.158328e-07, 1.8031277e-07, -3.9002725e-07, 6.219236e-07, -8.178127e-07, 1.803843e-06, 1.0813702e-06, 3.2343445e-07, -4.5063643e-06, -1.6515295e-06, -5.289852e-06, -1.9071156e-06, 1.5904998e-06, -2.5572037e-06, -3.536081e-06}},
    {"bert.encoder.layer.0.attention.self.key.bias_grad", {2.842171e-13, 1.1368684e-13, 3.410605e-13, -8.526513e-14, 2.1316282e-14, 3.0553338e-13, 8.526513e-14, -2.842171e-13, 3.5527137e-14, 1.7763568e-13, -7.5495166e-14, 2.2737368e-13, 1.2789769e-13, 1.563194e-13, 1.4743762e-13, 5.684342e-14, 9.2370556e-14, 2.842171e-14, -5.684342e-14, -6.3948846e-14, -1.4210855e-13, -4.2632564e-14, -1.9895197e-13, 8.526513e-14, -8.526513e-14, 0.0, -1.563194e-13, 2.5579538e-13, -2.842171e-14, 5.684342e-14, 2.842171e-13, 1.7053026e-13}},
    {"bert.encoder.layer.0.attention.self.value.bias_grad", {0.00057624094, -0.00047878135, 8.8577726e-05, 0.0009442631, 0.0007354448, 0.0017502701, 7.223505e-05, 0.0003053092, 0.00029654088, -0.00020083057, -0.00028270247, 0.0018478695, -0.00063348596, -0.00074259046, 0.00069661805, 0.00019773474, 0.0001243585, 0.0004709375, -0.00032707484, 0.0002893001, -0.00014805578, 0.00012409233, -0.00024103886, -0.0011293433, 0.0018971524, 0.0008412835, -0.0002848398, 4.1687053e-05, -0.00039227042, 0.0006918115, -0.00054074195, -6.5177286e-05}},
    {"bert.encoder.layer.0.attention.output.dense.bias_grad", {-0.001011996, 0.0013538749, -0.00054694817, -0.00500788, 0.003035055, 0.00029621646, -0.011754515, 0.014552759, -2.4903222e-05, -0.0046350057, -0.0012315355, 0.0027969303, -0.002467833, -0.004145886, 0.001645589, 3.3092845e-05, -0.0064527187, 0.00252729, -0.0012987383, 0.007970087, -0.0065159807, -0.0013637806, -0.0016696017, -0.002436706, 0.00595138, 0.015636828, 0.0003398798, 0.0042760083, 0.008448417, -0.00014953746, -0.0022249399, -0.015924906}},
    {"bert.encoder.layer.0.attention.output.LayerNorm.weight_grad", {-0.002161685, -0.0015772326, 0.0010680347, 0.002511057, 0.0039658295, 0.002735712, -4.665814e-05, -0.00079445844, -0.0029298088, -0.0022334266, 0.0012493465, -0.0003449472, -0.0023380155, -0.00032200254, -0.0027609935, -0.00037444988, 0.0016762016, -0.00018718022, -0.0029554602, -0.00029747418, 0.0051684612, -0.004624505, -0.0004335977, -0.0020674763, 0.00074572663, 0.0031691934, 0.0003253296, -0.0021052791, -0.002402958, 0.0014774858, 9.5019685e-05, 0.006777113}},
    {"bert.encoder.layer.0.attention.output.LayerNorm.bias_grad", {-0.0010219681, 0.0013470608, -0.0005584109, -0.0050162417, 0.003028429, 0.00028960741, -0.011763587, 0.014548242, -3.2064167e-05, -0.0046441713, -0.0012405927, 0.002789599, -0.002475623, -0.0041555236, 0.0016392791, 2.632165e-05, -0.0064632646, 0.0025248802, -0.0013057371, 0.007961957, -0.00652379, -0.0013696277, -0.0016777646, -0.0024462417, 0.0059447493, 0.015631674, 0.00032953353, 0.0042711576, 0.008442477, -0.00015459588, -0.0022341348, -0.015937412}},
    {"bert.encoder.layer.0.intermediate.dense.bias_grad", {8.569097e-05, -0.00046115508, -1.0931424e-05, 9.8947974e-05, -9.187042e-05, 0.00030828713, -0.0002126639, 0.00055756606, 4.6170237e-05, -0.00010010071, -0.00020163044, -0.0003436142, -0.00020131283, 0.00029869514, -0.00035066006, 0.00026510097, 0.0003651092, 0.000112525944, 0.00040760223, 0.00020337396, -0.00072741805, 4.2356827e-05, 0.00061000447, 0.00012677252, -0.00032150713, 0.00016487658, 0.0001848111, -0.0003345033, -0.0005317721, 8.3710394e-05, 0.00015776796, 0.00025211033, -7.6616074e-05, 0.00031403473, -0.0006303935, 0.00016777264, 7.92013e-05}},
    {"bert.encoder.layer.0.output.dense.bias_grad", {-0.0009933115, 0.0013441184, -0.00056048133, -0.005016573, 0.0029939483, 0.00027168496, -0.011784379, 0.014511006, -3.0253344e-05, -0.0046344735, -0.0011812784, 0.0027781064, -0.0024605985, -0.0040754136, 0.0016635826, 0.00010168814, -0.006452206, 0.0025969704, -0.001320597, 0.008023983, -0.006534002, -0.0013302638, -0.0016038748, -0.0025183274, 0.0059764655, 0.015674405, 0.00036152697, 0.004238466, 0.008434725, -0.00024662036, -0.0023026455, -0.015925381}},
    {"bert.encoder.layer.0.output.LayerNorm.weight_grad", {-0.0021628214, -0.001584634, 0.0010565349, 0.0024727166, 0.0039084535, 0.0027616853, -4.9592112e-05, -0.0008504113, -0.0029128792, -0.0022161286, 0.0012399876, -0.00032820675, -0.0023235178, -0.00030222934, -0.0028086558, -0.00035982463, 0.0016344759, -0.000188269, -0.002921399, -0.00024124626, 0.0051348475, -0.0046238923, -0.00038340554, -0.0020702356, 0.0007433259, 0.0031642444, 0.00032947323, -0.0020907545, -0.0023834421, 0.0014596158, 9.977448e-05, 0.006796651}},
    {"bert.encoder.layer.0.output.LayerNorm.bias_grad", {-0.0009829698, 0.0013583333, -0.00054992083, -0.0050013945, 0.0030009728, 0.0002819069, -0.01177132, 0.014529376, -1.1825723e-05, -0.0046197437, -0.0011718741, 0.002791019, -0.002447052, -0.004058335, 0.0016757563, 0.000119306875, -0.0064390786, 0.0026010564, -0.001308443, 0.0080378, -0.006513807, -0.0013106484, -0.0015836508, -0.0024964449, 0.005994212, 0.01567529, 0.00037182684, 0.00424255, 0.008446889, -0.00023270406, -0.0022871862, -0.015907727}},
    {"bert.encoder.layer.1.attention.self.query.weight_grad", {1.0554689e-07, 2.8386805e-06, 2.4352817e-06, 6.439641e-07, -1.3317854e-06, 9.741295e-07, -1.2813054e-07, 1.7345354e-06, -1.3808052e-07, -2.1710614e-06, -2.079326e-06, -1.2258231e-06, -9.071227e-07, -6.032549e-07, -1.907661e-06, 1.0300497e-06, -1.3032637e-06, -2.5126637e-06, 3.21163e-06, 3.9395363e-06, 4.381249e-06, 1.0108921e-06, -7.0425455e-07, -1.6501093e-06, -7.6160626e-07, -4.8258494e-06, -3.2550536e-06, 1.3230638e-06, -2.7315673e-07, -1.9226763e-06, 1.4364302e-06, 2.6358946e-06, 3.225066e-08, 2.169274e-07, -6.862621e-07, -1.1034418e-06, -3.162299e-07, 9.2699537e-07, 1.5262222e-08, 2.6798728e-07, 2.8178212e-07, -7.65603e-07, -5.03944e-07, -2.3484406e-08, 3.6731635e-08, -1.0628581e-06, -2.988373e-08, 3.7858408e-07, -3.779488e-08, -1.3870063e-06, 6.425632e-07, 6.4971505e-07, -2.3222772e-06, 7.296241e-07, -4.154374e-07, 2.2652027e-06, 1.547942e-06, -8.7373166e-07, 2.3511939e-07, -1.0761786e-07, -3.4891548e-07, 9.315829e-07, 2.9707127e-07, 5.291458e-07, 2.3206897e-07, -3.3874826e-07, -1.2455023e-06, -2.486593e-06, -1.3888983e-07, -1.820688e-07, 4.627505e-09, -1.3068847e-06, 1.8393989e-06, -1.0951085e-07, 7.733936e-07, -5.269944e-07, 7.7415297e-07, -8.9532097e-07, 1.331745e-06, 1.0654652e-06, 1.4364554e-07, -4.7649382e-07, -1.0172513e-06, -6.0795344e-07, -1.969358e-06, 4.513083e-07, -4.5897373e-08, 1.7789325e-06, 1.3310006e-06, 3.5943307e-07, 1.2885633e-06, -3.024187e-07, 6.6338295e-08, 7.7332874e-07, -3.431042e-07, -2.204129e-07, 7.7336196e-08, -8.9927727e-07, -1.3018196e-06, -3.1217178e-07, 8.153505e-07, -6.8137376e-07, 7.9345305e-08, -1.8509552e-07, 1.2646042e-07, 1.7562434e-07, 1.730703e-06, 7.748808e-07, -4.1681452e-07, 1.7250333e-06, -1.5649915e-07, -9.764046e-07, 8.276889e-07, 1.3425541e-06, -4.380963e-07, -2.3218845e-06, -1.4549326e-07, -7.925673e-07, 6.60563e-07, -5.7260723e-07, 2.6486973e-07, 1.4628993e-06, -9.3421943e-07, -4.0988363e-07, 6.987452e-07, 3.900916e-07, -8.674636e-08, -5.2119117e-07, -1.9168376e-06, 1.3438529e-06, 1.067322e-06, 3.6456836e-06, -7.455424e-07, -9.5022733e-07, 5.6176566e-07, 1.6730745e-06, -3.0044005e-06, -1.3370101e-06, -2.2343206e-06, 7.6510986e-07, -3.2509507e-07, 3.45942e-07, -5.5115987e-07, -1.1232577e-06, 4.7870213e-07, -1.0180722e-06, 2.0779864e-06, 2.5775566e-06, 3.1825105e-06, -6.8776654e-07, 9.992249e-07, -1.5514798e-06, -1.2642762e-06, -1.1343876e-06, -2.6812006e-06, 5.5536226e-08, 1.147235e-06, -2.566197e-07, -9.722254e-07, 1.832377e-06, 3.5244568e-07, 1.2613921e-07, 9.655546e-07, 2.2439729e-06, -2.093872e-07, -3.1414143e-07, -1.4397153e-07, -1.3178077e-07, 6.391827e-08, 7.2320523e-07, -6.714724e-08, -6.170803e-07, -3.7124394e-07, -2.9802766e-08, -1.3692425e-06, 7.806113e-08, -4.911046e-07, 3.3068542e-07, -5.972207e-08, 5.919693e-07, 1.5991159e-06, -4.1362878e-07, 9.42282e-07, -1.3832846e-06, -1.509849e-06, 1.0390692e-06, -1.2593452e-07, -3.1772984e-07, -4.3792102e-07, -5.368131e-07, 6.132835e-08, -5.879622e-07, -2.1940953e-07, 1.307896e-06, 2.553292e-07, -4.7312117e-08, -6.7326624e-07, 4.00139e-07, 4.943817e-07, 1.14302e-06, -7.980259e-07, -1.5111499e-06, -1.8558688e-06, -3.1577048e-07, -2.9616425e-07, -1.0781389e-06, 5.6754146e-08, 7.484033e-07, -4.380263e-07, -1.1066309e-06, 1.1497893e-06, 3.3777e-06, 1.7507705e-06, 3.6450965e-07, 3.650866e-07, -9.920419e-07, -2.0624361e-07, -2.1608173e-06, -5.3779337e-07, 5.293805e-07, -4.8788513e-07, -8.1097045e-07, 1.7311243e-07, 1.4192425e-06, 4.1980462e-07, -7.4457193e-07, -2.4506392e-08, 2.7995998e-07, 6.544106e-07, -3.887463e-07, -8.09913e-07, -5.3973105e-07, 3.7115672e-07, -3.020564e-07, 2.699859e-06, 7.5309583e-07, -4.54495e-07, 1.10998e-06, -7.358591e-07, -1.235006e-06, 1.4421232e-06, 5.449788e-07, -3.876572e-07, -2.0552138e-06, 1.2161236e-06, -7.925729e-07, 7.636755e-08, -1.0686294e-06, -7.391958e-07, 1.5825356e-06, -9.951196e-07, -7.547295e-07, 6.27231e-07, 2.9859894e-08, 1.3211746e-06, -1.1006575e-06, 1.5141633e-06, -6.544809e-07, 3.2102025e-07, -1.9554805e-06, -2.5508436e-07, -8.535586e-07, -8.7813913e-07, -1.4855401e-07, 7.750071e-07, 1.805073e-06, 4.1006338e-08, 4.95126e-07, 7.449178e-07, -2.995101e-07, -8.835577e-07, 1.1616872e-06, -1.5449342e-06, 1.0739794e-06, -4.3617167e-08, 1.1747469e-07, 1.871168e-07, -1.7197407e-06, 1.4029275e-06, -1.7149607e-06, -1.98016e-06, 1.2699721e-07, 1.134829e-06, 8.8060204e-07, -1.7911663e-07, 6.177714e-07, 2.0836203e-06, -1.3724245e-06, 3.3109097e-07, -4.771345e-07, 1.5277591e-07, 4.7850284e-07, -8.504398e-07, 1.247526e-07, -6.901709e-07, -5.484415e-07, -5.623957e-07, 3.3934745e-07, 5.8784434e-07, 1.4951851e-07, 3.4307078e-07, 1.4064669e-07, 7.385503e-07, -3.2657226e-09, 6.8185574e-07, 9.616732e-08, -1.2959768e-07, -5.4941876e-07, -8.56925e-08, -3.9232523e-07, -4.6267718e-07, 5.569033e-07, -5.753185e-07, 3.5902974e-07, -6.183039e-07, -2.3476544e-07, 4.9077886e-07, 1.3565098e-07, 1.628087e-07, 3.1065264e-07, -1.3400552e-07, 1.0945402e-07, -1.0609659e-06, 1.5162013e-06, -4.9259717e-07, -1.6185997e-07, 5.84196e-07, 5.9023284e-07, -3.2255411e-06, -3.614578e-07, 1.5669589e-07, 1.1478454e-06, -2.1618263e-07, 7.9306733e-07, 2.8413338e-06, -1.6194823e-06, 9.991884e-07, -4.018519e-07, -5.8218194e-07, -6.132112e-07, -3.1959146e-07, -4.997268e-07, -8.3930945e-07, 4.9434874e-07, -2.6557336e-07, 3.159191e-07, -1.1367375e-06, -6.39194e-07, 9.0242264e-07, 6.030817e-07, -7.206885e-07, 2.2361712e-06, 6.032393e-07, -1.14432176e-07, -1.485481e-07, 9.082815e-07, -8.4696944e-07, 1.6934194e-07, -3.0845862e-07, 8.824975e-07, -8.5511783e-07, 1.8908302e-08, 6.1906024e-07, 1.0668406e-06, -1.843193e-08, -4.3845947e-08, -1.6975304e-07, -1.3412443e-07, -8.1016324e-08, 8.965426e-07, 4.1267833e-07, -6.5631895e-07, 1.020451e-06, -6.73772e-07, -8.838584e-07, -1.3800611e-06, -1.7287706e-06, 8.938361e-08, -4.0575e-07, -2.4551598e-08, 2.1583914e-07, 3.1270534e-07, 4.949535e-07, 7.6305696e-07, -4.3485562e-07, 3.7626515e-07, -1.0871288e-06, -7.0970816e-07, 2.1602949e-07, -2.1892984e-07, 3.4233508e-07, 7.911782e-07, -2.0223172e-06, -1.1768582e-06, -9.884565e-07, 1.1809217e-06, -4.1087415e-07, -2.9956328e-07, 1.4209044e-06, -1.956013e-07, 5.0740556e-07, -1.1490135e-06, 6.184476e-07, 2.0017123e-06, -1.8221597e-07, -3.100853e-07, 2.5652787e-07, -8.059896e-07, 4.848709e-07, -7.6591647e-07, -3.5150856e-07, -2.6271837e-07, 1.241301e-06, 4.986493e-07, 4.17174e-07, 1.0180173e-06, -1.0038659e-06, 6.952849e-07, 2.2347568e-09, 5.8162334e-07, 5.062709e-07, 7.604541e-07, 1.6170708e-07, -3.9950146e-07, -5.899209e-07, -1.6709166e-06, -4.6478252e-07, -4.5264318e-07, -8.345952e-07, -8.381108e-08, 5.5237206e-07, -2.1118194e-07, 8.235128e-07, -8.114941e-07, 2.6826408e-08, 1.0912405e-06, -8.143117e-07, 1.1434428e-06, -5.423971e-07, 1.1186406e-06, 1.5025121e-06, -5.3183676e-08, -2.1203165e-07, -3.4255683e-07, 2.7252742e-07, -1.9619276e-07, -1.2836423e-06, 7.283794e-07, 4.5733447e-07, -6.401577e-07, -2.7877653e-07, -4.0359947e-07, -9.293716e-07, 1.7668704e-08, -5.0790834e-07, 4.6714268e-07, 4.0168612e-07, -7.997726e-08, 3.161234e-08, 2.3969744e-07, -2.066717e-07, -3.953049e-07, -8.496097e-08, 3.0081083e-07, 2.2857151e-07, 2.4515847e-07, 5.2012405e-07, 3.4622997e-07, 3.6232132e-07, -8.8195705e-08, 4.1907e-07, -1.7672501e-07, -1.4279726e-07, -3.4098457e-07, -5.0351065e-07, 6.63418e-08, 1.9217183e-07, -2.7705948e-07, 9.873715e-07, -2.2731176e-07, -2.507235e-07, 6.8537577e-07, -1.7100924e-06, 1.1627442e-06, -2.5225768e-07, 2.2349121e-07, 3.9568414e-07, 1.1847892e-06, -3.90844e-06, -1.2187196e-06, -3.4203717e-07, 2.0032376e-06, -6.09018e-07, 7.461383e-07, 1.9873692e-06, -8.486847e-07, 9.652751e-07, 2.3537805e-07, 5.020584e-07, 5.0370795e-07, 5.857811e-07, -8.3964477e-07, -1.4817185e-06, -9.889983e-07, -6.781255e-07, -1.3465909e-06, -1.1122372e-06, -9.736582e-07, 1.6976651e-06, 8.304405e-07, 1.4211906e-08, 2.8375978e-06, -2.0471872e-07, 7.084352e-08, 5.0043286e-07, 6.0920644e-07, -1.1175997e-06, -8.509667e-07, -1.2354853e-07, -1.1979656e-06, -2.1902868e-06, -3.0351876e-07, 1.2170281e-06, 8.4939586e-07, -2.6405553e-07, 1.733373e-06, 1.2495599e-06, -1.1154802e-06, 8.952975e-07, 1.4823752e-06, -4.8603596e-07, -4.3628108e-07, 1.3634199e-06, -6.4882795e-07, 3.5768488e-07, -4.1669793e-07, -2.559235e-07, 1.1132537e-06, -2.9585021e-06, -8.548266e-07, 1.2457829e-06, -2.6345288e-07, -7.298946e-07, 1.7309308e-06, 4.4886275e-07, 1.0772055e-06, -4.6552472e-07, 1.7050983e-08, 1.0432922e-07, 6.5634447e-07, 4.5154692e-07, -2.129469e-06, -5.329213e-07, -4.984337e-07, -2.1905126e-07, -1.0895221e-06, -1.3676805e-06, 1.592777e-06, 1.235629e-06, -1.4329689e-07, -4.5735842e-08, 2.1927312e-06, -1.4337712e-06, -8.8272503e-07, -3.0566957e-07, 6.512203e-07, -5.2392215e-07, 2.0251946e-06, 2.3900616e-06, -2.0819857e-06, -2.3135474e-06, 2.525986e-07, 8.897013e-07, -1.1274085e-07, -8.172272e-07, 9.779717e-07, -1.12858956e-07, 2.850651e-07, 1.0345008e-07, -1.4229114e-07, 6.2163974e-07, 2.9519123e-07, 6.863802e-07, 1.5423435e-08, 6.5638693e-07, -3.0662153e-07, -4.5785873e-07, -4.9474045e-07, -2.7034474e-08, -1.3622383e-06, -1.882978e-07, 1.5315323e-06, -4.471775e-07, 3.0539507e-08, -1.281155e-06, -7.156143e-07, -1.3633579e-06, 9.4029957e-07, -7.3010824e-07, 5.8348877e-07, 3.077253e-07, 9.616106e-07, 2.2794795e-06, 1.4309719e-06, -1.0379281e-06, 4.4483337e-09, -9.028518e-07, -1.1634979e-06, -1.0387323e-06, -1.5801643e-07, 1.0605304e-06, 2.3736844e-07, -6.6176904e-07, 5.1115154e-07, 5.306895e-07, 2.5358627e-06, -2.009983e-06, -1.0348605e-06, -1.2101154e-06, 1.344637e-06, 9.358986e-07, -5.0248474e-07, 6.217308e-07, -1.4819932e-06, 7.7266556e-08, -2.3075495e-06, 5.750673e-07, 9.625076e-07, -9.2595207e-07, -6.266624e-07, -6.4470817e-07, -1.3742701e-07, -1.0139312e-06, 7.5416654e-07, 4.1924557e-07, -9.893556e-07, 3.8350433e-07, 1.6312301e-06, 1.1275268e-06, 1.0351573e-06, -1.0069614e-06, -1.812875e-06, 3.4786356e-07, -7.435582e-07, -3.9331507e-08, 1.989482e-06, -9.906973e-07, -1.2964328e-07, -1.6897706e-06, -9.923388e-07, 2.2901047e-06, 1.6072908e-06, -1.1833156e-06, -6.601932e-07, -1.0929558e-07, 3.3595393e-07, 1.5372507e-06, -2.1206993e-06, -1.3682738e-07, 9.130646e-07, -5.95628e-07, 1.1426376e-06, -1.8387502e-06, 2.8987478e-07, -1.5705778e-07, 1.299126e-06, 1.40781e-06, -4.389939e-07, 1.1262516e-06, -6.1523343e-07, 1.6837727e-06, -7.0931384e-07, 4.4098937e-07, 8.153017e-07, 9.642966e-07, 1.8315207e-07, -1.2772779e-06, -1.6165083e-06, 8.1709794e-07, 1.2683838e-06, -9.0717435e-08, 6.3125253e-07, -1.1738671e-06, -7.284317e-08, 9.505857e-07, 2.8171428e-06, -2.1354567e-06, -9.4432147e-07, -1.2894813e-07, 1.1107356e-06, 2.7840772e-06, -1.1160232e-07, 2.2666152e-06, -8.745489e-07, 1.4747994e-06, -2.3624373e-06, -1.2204315e-06, -1.0038844e-06, -3.104945e-06, -1.4052403e-06, -2.4974332e-07, -4.9002546e-07, 7.828832e-08, 1.6600841e-06, 9.7993e-07, -2.5690363e-07, -5.21133e-07, -5.540261e-07, -8.8041537e-07, -2.3069946e-07, -5.231444e-08, 4.6494918e-07, -1.1389817e-06, -1.9388666e-07, -1.1009408e-07, -1.8725581e-07, 2.3668494e-07, -5.062995e-08, 3.5364533e-07, -7.0174997e-07, 3.54656e-07, 3.765391e-07, 1.2440254e-06, -7.651275e-08, -2.9285263e-07, 8.284546e-08, -3.4125833e-07, 1.1120886e-06, -2.753038e-07, -9.034146e-07, -1.0879922e-06, 3.4138398e-07, 3.9200793e-07, -1.4456143e-07, -1.8467242e-07, 2.2459024e-06, 9.880808e-07, 1.6748907e-06, 2.864371e-06, 7.214241e-07, 1.6311099e-06, -1.6233906e-06, 6.9669346e-07, 1.0897796e-06, -1.5571284e-06, -9.420148e-08, -2.3936275e-06, -1.3214288e-06, -2.000708e-06, 7.974756e-07, -1.6624483e-06, -2.1820445e-06, -2.2803415e-06, 2.5160975e-06, 2.0667007e-06, 8.417019e-07, 7.090182e-08, -1.2477902e-07, -1.0869802e-06, -5.4010985e-07, -7.596754e-07, -1.5650514e-06, 6.8188925e-08, 2.323186e-06, -5.2849134e-07, 1.9562256e-06, -1.4914613e-06, 9.0503886e-07, -1.2085095e-06, -1.1470771e-06, -2.490814e-08, 6.4067694e-07, -1.1678826e-06, 1.6539401e-06, -1.244164e-06, 2.4879654e-08, -1.1555204e-06, -1.7254832e-06, 6.4428747e-07, 1.034613e-06, -3.7916513e-07, -2.2520262e-06, 1.2142343e-06, 1.0579168e-06, -4.3918118e-07, -1.7659219e-06, 1.4278548e-06, 1.8914395e-06, 2.0420377e-06, 9.797105e-07, -4.5053312e-07, -5.121668e-07, -1.162603e-06, -6.270019e-07, 1.3187808e-06, -4.3541453e-07, -3.7320368e-07, -5.1186476e-07, 1.413896e-06, 1.2383582e-06, -2.0175166e-07, 6.911033e-07, -4.4280063e-07, -1.3099435e-06, 2.1203207e-06, -9.2483623e-07, 1.3813149e-06, 1.4581875e-06, 3.071042e-06, 9.603332e-07, -1.7079889e-06, -2.4671867e-06, 7.8399603e-07, 1.5026302e-06, 6.7980494e-07, -5.9231724e-07, -3.5506932e-07, 5.8600085e-07, -1.376843e-06, -3.5406615e-06, -4.061399e-06, 1.6410585e-06, -3.8343714e-07, 1.2397429e-06, 8.8712534e-07, 3.8305436e-07, 8.267419e-07, 1.0821759e-06, -6.551809e-07, 1.8941163e-06, -2.8584768e-06, -3.108567e-07, -1.5869306e-06, 2.6640527e-07, -2.7725403e-07, 1.1410328e-06, -4.1642684e-07, -4.3759007e-07, -9.227547e-07, -9.1247195e-08, -1.2241211e-08, -7.342778e-08, -1.3193286e-06, 1.1975242e-06, 2.4336841e-06, -1.4327101e-06, 4.5237567e-07, 2.0136595e-06, -1.2787139e-06, -3.9519973e-06, -1.2572784e-06, 1.5797648e-06, -6.939443e-07, -3.6403839e-07, 7.10081e-07, 5.080474e-07, -9.819106e-07, 2.5154004e-06, 3.211007e-06, -9.957342e-07, -6.9304156e-07, 1.2486865e-06, -8.280583e-07, 3.3695844e-07, -1.9633983e-06, 2.0832806e-06, -7.436727e-07, -8.631159e-07, -1.8714661e-06, -2.0316877e-06, -2.5898632e-06, 1.5343671e-06, 2.4106268e-06, -3.1111774e-06, -3.1660024e-06, -2.0064577e-07, 3.6107e-07, -2.8582017e-06, -6.127494e-07, 4.898132e-06, -3.4378997e-06, -4.1201247e-06, -9.33396e-08, 5.1773213e-06, 1.5050458e-06, 1.2889033e-06, 3.2880046e-06, 2.6052403e-06, -1.4566038e-07, -2.4734366e-06, 3.5162398e-06, -5.1287395e-07, -3.3602096e-06, 3.978837e-06, -3.021756e-07, 1.8106313e-06, -3.5202666e-07, 2.5418124e-06, 6.347196e-08, -9.931464e-07, -3.2150356e-06, -1.5626132e-06, -1.1791885e-06, 8.867709e-07, 2.1362996e-06, -2.0327989e-06, -2.2388058e-06, -6.387413e-08, -1.1066253e-06, -2.8069571e-06, -1.6686164e-06, 5.571159e-06, -2.8242132e-06, -1.4291057e-06, 2.5530161e-07, 4.357835e-06, 1.9280023e-06, 4.871016e-07, 2.9563566e-06, 4.0967623e-07, 1.5362776e-08, -3.0849121e-06, -5.964551e-07, -1.0587928e-06, -1.8849719e-06, 4.2589836e-06, 1.3870034e-06, 8.430042e-07, 3.7961436e-07, -2.4622104e-06, -2.3048337e-06, -4.704223e-07, 3.357554e-06, 1.9407976e-06, 7.301642e-07, -1.0227097e-07, -9.3355044e-07, 1.1766085e-06, 1.892268e-06, -1.3649345e-07, 3.0181735e-07, 1.3266448e-06, 1.4539039e-06, -3.3078923e-06, 1.7860516e-06, 7.456731e-07, -4.3782745e-07, -3.4309437e-06, -1.6441475e-06, 6.1792167e-07, -1.3397596e-06, 6.982214e-07, 1.3449325e-06, 1.4032512e-06, 3.1843566e-08, 2.6181272e-07, 1.0264318e-06, -2.9566504e-06, -5.5508906e-07, -3.934215e-07, -1.0810121e-07, -9.411832e-07, -1.3741777e-07, -1.50986e-06, -1.7816852e-06, -1.0477077e-06, -9.10103e-07, 2.8682273e-06, 2.4588255e-06, -2.284526e-06, 1.1841468e-06, 1.2845251e-07, -1.3983287e-06, -2.3215832e-06, -1.2443779e-06, 1.4229065e-06, -7.4800823e-07, -9.654578e-07, 1.6821415e-06, 7.103946e-07, 5.144297e-06, 9.4623107e-07, 1.1224677e-06, -1.2910824e-06, -1.0681849e-06, -2.5988697e-06, 1.1024619e-06, 1.2618307e-06, -8.497662e-07, -1.0473176e-06, 2.360881e-06, -1.3970529e-07, -4.0923226e-07, 9.926003e-07, 3.9815225e-07, 1.2415559e-06, -4.831018e-07, -2.2707372e-06, 1.0088796e-06, 1.1405383e-06, 2.0577052e-06, -2.1992432e-06, -2.7689514e-06, -1.9822478e-06, 2.0367988e-06, 5.297419e-07, 9.3308665e-07, -1.0789875e-06, -1.720203e-06, -9.119317e-07, -1.146939e-06, -1.5920838e-06, -1.5334108e-06, 1.1147506e-06, 1.054635e-06, 2.2547601e-06, 1.5159e-07, 1.8194202e-06, 2.4133335e-06, 1.0931237e-06, -1.509804e-06, 2.0553027e-06, -4.0603554e-06, 1.371254e-06}},
    {"bert.encoder.layer.1.attention.self.query.bias_grad", {-2.5402737e-06, 6.9874386e-07, 5.298064e-07, -7.4051883e-07, -2.3802904e-06, 1.3321382e-07, -1.283958e-06, -1.0656142e-06, 2.7093156e-06, -2.7353525e-07, -2.6628452e-06, -2.3648681e-07, -1.1735074e-06, -9.102369e-07, -1.2513524e-07, -2.2763347e-06, -2.8583645e-06, -1.388264e-06, 2.0848745e-06, -1.0232004e-06, 4.1296985e-08, -2.997051e-06, -1.1027156e-06, 2.399796e-07, 2.0670704e-07, 8.468021e-09, 1.9353015e-06, 2.9730181e-06, 2.6473697e-06, -1.5338271e-06, -1.8117197e-07, -2.7791452e-07}},
    {"bert.encoder.layer.1.attention.self.key.weight_grad", {-3.9980912e-07, 7.559022e-07, -2.3871834e-07, 1.0346491e-06, 2.1948892e-06, 3.4066596e-07, 2.4055964e-06, -1.6738251e-06, -2.6717166e-06, 2.592763e-06, -8.684701e-07, -4.761708e-08, -1.4519975e-06, 2.6354544e-06, 1.5613922e-06, -1.3626053e-06, 3.6537335e-07, 2.5944687e-06, -1.9578755e-07, -1.248945e-06, -2.747458e-06, -1.6043667e-07, 4.2570598e-08, -1.2888213e-06, -1.3557072e-06, 7.7826616e-07, 6.6861145e-07, -2.5239325e-07, -4.507582e-08, -2.6243316e-07, -1.8159997e-06, 1.17213006e-07, -2.9030952e-07, -8.171446e-07, 7.4782264e-08, -1.6951265e-06, -9.539636e-07, -2.2925633e-06, -7.130433e-07, 1.424596e-06, 1.1839958e-06, -1.8829293e-06, -1.2327298e-07, 3.340845e-07, 1.7344247e-06, -2.2822435e-06, -2.9614458e-07, 1.336187e-06, 5.191997e-07, -2.48982e-06, -9.223142e-07, 2.1081469e-06, 7.350709e-07, 4.1242836e-07, 9.686678e-07, 2.8559311e-06, 1.633891e-06, -1.5138448e-06, -7.7068296e-07, 2.8852787e-07, -1.0156957e-07, 1.440467e-06, -1.0377984e-07, 1.9835038e-07, -1.5922773e-06, 5.6111105e-07, 8.4840417e-07, 9.3567866e-07, 3.3872448e-06, 2.4928813e-06, -9.7083486e-08, -1.4859535e-07, -3.614181e-07, 2.5085542e-06, -2.2331365e-07, -5.9436803e-07, -2.3899956e-06, 9.834487e-07, 1.9126055e-06, -1.2298858e-06, -1.1940716e-06, 8.858248e-07, 1.9944027e-06, -1.8434439e-06, -1.3210284e-06, -1.5894832e-07, 4.1013988e-07, -3.1967436e-06, -1.1472898e-06, -5.962155e-07, 2.605977e-06, -7.34659e-07, -1.3340017e-06, -1.247018e-06, 7.224694e-07, -8.383866e-07, -2.0612426e-07, 3.791153e-08, 6.4062516e-07, -7.3993294e-07, 6.1590123e-07, -1.2564865e-07, -4.4066564e-07, 9.53676e-07, 6.5242244e-07, 3.701106e-07, 8.3187706e-07, 3.9498389e-07, -5.012759e-07, -1.5281447e-06, 4.2079176e-08, 7.811002e-07, -6.503104e-07, -7.1481315e-07, 1.1761016e-06, -4.4412778e-07, 1.7608677e-06, -8.2544545e-07, -8.145354e-07, -2.2980705e-06, -3.0814763e-07, -1.0413561e-07, 5.7940065e-07, 3.9731444e-07, 3.7358956e-09, -5.181687e-07, 2.1324954e-06, -1.1510567e-06, -3.215003e-07, -1.4107574e-06, -2.6515295e-07, -3.2036831e-07, -1.1351963e-06, -2.2634197e-06, -1.2880299e-06, 1.1671272e-06, 3.2455994e-06, -2.4410913e-06, 9.602469e-07, 1.2983566e-07, 8.9320855e-07, -2.5233776e-06, 4.1518572e-07, 3.201653e-07, 8.8336424e-07, -1.7519118e-06, -2.5392192e-06, 1.7122479e-06, 1.6686208e-07, 2.2255323e-07, 8.919427e-08, 4.624404e-06, 2.447433e-06, -1.5973505e-06, -1.8284591e-07, 2.2855986e-07, -1.3058975e-06, 1.5031644e-06, -3.8839293e-08, 3.7580608e-07, -1.2393161e-06, 1.3031914e-07, -2.5553604e-07, 1.1348402e-07, 1.7142983e-06, 1.0898857e-07, 1.8746637e-06, -7.2567184e-07, -5.534318e-07, 2.249607e-06, -1.1810963e-06, -7.024343e-07, 1.1250828e-07, 1.1204157e-06, 2.690622e-06, -1.2486632e-06, 4.605498e-07, 2.2810773e-06, -4.4181365e-07, -6.7214694e-07, -2.883993e-06, 5.9722066e-07, 1.0277144e-07, -6.73777e-07, -4.5525383e-07, -1.2501508e-06, 1.9022938e-06, -6.1173114e-07, -8.435584e-07, -4.4736126e-07, -1.5405187e-06, 2.6763513e-07, -7.559714e-08, -5.441998e-08, -7.01219e-07, -4.5506792e-07, 4.8486993e-07, -1.6581963e-06, 9.518679e-07, -1.1173985e-07, -3.1508387e-07, -8.1084366e-08, 1.0014483e-07, 2.4977814e-07, 7.628672e-07, 2.476548e-07, 8.089135e-07, -1.1430535e-07, 5.540013e-07, 6.2642437e-07, -1.4417403e-06, -2.238873e-07, -7.129882e-07, -4.7821624e-07, 1.17875395e-07, 1.4278437e-06, 9.489907e-08, 7.8868e-08, -5.79779e-07, 1.6621021e-07, -1.8500434e-07, 1.110926e-06, -9.449931e-07, 3.501775e-07, 3.370666e-07, 9.408853e-08, 1.4989232e-07, 1.265773e-07, 1.2951297e-06, 7.3867614e-07, 7.171851e-07, -8.6796007e-07, -1.4388214e-06, 1.126536e-06, 4.1720634e-07, 6.6188557e-07, -1.7092591e-06, -4.6001935e-07, -2.7377814e-07, -7.947716e-07, -2.91285e-07, 4.580413e-08, 2.0737718e-06, -1.2803244e-07, 9.20661e-07, -3.439427e-07, -2.4354372e-07, -2.4973197e-06, -2.0424366e-06, 1.0831767e-06, 1.2553496e-06, 7.8700054e-07, 2.2439286e-07, -1.5666061e-06, 1.7725067e-06, -1.1691307e-06, -4.056519e-07, 4.6122395e-08, 5.980585e-07, -5.683021e-07, 1.8772104e-07, -1.2415949e-06, 2.7534668e-07, 6.163001e-07, 1.869274e-07, -3.952646e-07, -8.044413e-08, -2.1746014e-07, -2.7728552e-07, -2.0952871e-07, 5.4643895e-08, 2.0556075e-07, -1.6604287e-07, -6.163283e-07, -4.772245e-07, 3.106658e-07, 5.567527e-07, -9.321297e-08, 1.1093932e-06, 6.6933853e-07, 1.6298064e-07, -8.933856e-08, -2.2647146e-07, 1.0519848e-07, -2.5350019e-08, 4.447472e-07, 8.79151e-08, -5.2817205e-07, -4.619544e-07, 1.0633912e-06, 2.4459234e-07, 8.483805e-07, -7.767256e-07, 1.4383632e-07, 4.668008e-07, 1.3228339e-07, 1.1397885e-06, 7.0880205e-08, -3.2814756e-07, -1.2521402e-06, -8.8978106e-07, 1.5744092e-07, -1.5690376e-06, -4.94866e-07, -3.9196158e-07, 2.1351008e-07, 3.8590187e-07, 1.398745e-07, -2.3443394e-07, 1.2556544e-06, -4.872449e-07, -1.983683e-07, 7.6133387e-07, -7.3574637e-07, -1.1611911e-06, 4.3743674e-07, 3.5206563e-07, 1.4285151e-06, -1.8889774e-07, -7.119035e-08, -8.8632765e-07, -5.679699e-07, 5.790001e-07, -2.024056e-06, -4.7071683e-07, 1.5596664e-08, 3.796811e-07, -5.384174e-07, 8.5842674e-07, 3.5734914e-07, 6.65318e-07, -6.709508e-07, 3.7831757e-07, -6.4649885e-07, 1.67524e-06, -2.5065257e-08, 1.4557664e-06, -8.287894e-07, -1.2269824e-06, 1.9053265e-07, -1.199008e-08, -1.1037038e-06, -8.644874e-07, 1.8695052e-06, -5.189841e-07, -2.526603e-07, 1.4028262e-06, 3.5577136e-07, 8.1158134e-07, -1.0327468e-06, 1.0389447e-06, -3.6350895e-07, -4.761851e-07, -1.5107938e-07, 1.6379778e-07, 5.8713823e-07, -3.5074834e-07, 7.420999e-07, 2.7728032e-07, 4.657839e-07, -8.108712e-08, -8.700391e-07, -1.391088e-07, -3.7107105e-07, -4.924217e-07, -3.403676e-07, -1.3500088e-06, -4.2931944e-07, -5.9095218e-08, -3.7050802e-07, 5.1020055e-07, 1.027785e-06, -4.1816955e-07, 2.853794e-07, -1.262633e-07, 6.37588e-07, 3.0395745e-07, -2.9945377e-07, 4.816788e-07, 9.688521e-07, -4.983916e-07, 2.4109917e-07, 4.0635445e-08, 9.004104e-08, 2.3845863e-07, 1.2725372e-06, 1.8774456e-07, 1.6191893e-06, 3.7135922e-07, 7.635587e-07, -2.0262735e-07, 8.8570494e-07, 2.4679656e-07, 9.266548e-08, -9.009934e-07, -9.981813e-07, -1.822022e-06, 1.4856225e-06, -8.7103837e-07, -5.072458e-07, -1.1529501e-06, -1.9717608e-07, -9.8713755e-08, -4.3814052e-07, -3.6797104e-07, 1.8501214e-06, 1.2606268e-06, -2.038138e-07, 6.1311164e-07, -2.5718833e-07, -1.3800928e-06, -1.2242997e-06, -4.5918895e-07, 1.1705561e-06, -1.1183108e-06, 1.4190125e-07, 9.9256525e-08, -7.2708326e-07, -5.225527e-07, -1.4610872e-06, -3.292728e-07, -6.5451184e-07, 5.419681e-08, -1.3565956e-06, -4.634741e-07, -3.8937316e-08, 5.581007e-07, 8.515457e-07, 2.2397578e-06, -1.8646484e-06, -2.5485804e-07, 3.8190205e-07, 9.40241e-07, -5.292341e-08, 7.1565506e-07, 4.6305095e-07, -2.2833254e-07, -3.3195494e-07, -1.6330017e-06, -1.8474742e-07, -7.069959e-07, 1.7036508e-07, 1.4957933e-06, 1.6913217e-06, 9.949692e-07, -1.8588004e-07, 8.8310586e-08, 2.523907e-07, -5.178615e-08, -2.0448074e-07, -3.5429537e-07, -5.3268067e-08, 8.7720827e-07, 7.236222e-07, 6.757869e-08, 6.886067e-08, -7.3070885e-07, -9.2025357e-07, 1.515241e-07, 2.5806034e-07, 1.3520217e-07, -1.0615021e-07, -1.41826e-07, -3.7808258e-07, 4.1143018e-08, -5.6955923e-07, 2.408315e-08, 1.8840142e-07, -5.4937385e-07, 2.929768e-07, 6.4937e-07, 7.223961e-07, 2.024354e-09, 4.7069827e-07, 4.5892642e-07, 1.9809575e-07, -7.209378e-07, -3.5204235e-07, -6.600493e-07, 4.626421e-07, -1.932916e-07, 4.4282078e-07, -9.486827e-07, 5.895619e-07, -6.975554e-07, 4.5407725e-07, 1.840614e-06, -2.3589443e-07, -1.2839365e-07, 9.967683e-07, -1.0981154e-06, -6.111223e-07, -5.7717875e-07, 1.0557436e-06, -1.7578587e-07, -7.705441e-07, -3.539868e-07, 1.9335232e-07, 2.221669e-07, -3.4847466e-07, -2.0072173e-06, 1.1047509e-06, 8.4203344e-07, 9.144606e-07, 5.9487326e-07, 1.1836162e-07, -2.4274559e-07, 2.481509e-07, -5.167881e-07, 9.519981e-07, -1.5869024e-06, -7.7055276e-08, -7.074595e-07, 1.3406584e-06, -2.500373e-06, 2.3477698e-07, -3.718079e-07, -6.085987e-08, 4.50178e-07, -1.4690869e-06, 2.2454245e-08, 2.872499e-06, -1.1062248e-06, 3.210459e-07, 2.468562e-06, 3.7595487e-07, 3.2060976e-07, -1.0353245e-06, 1.1918033e-06, 2.041698e-06, 5.246072e-07, -1.5834605e-06, -2.174926e-06, -9.574209e-08, -9.723101e-07, -1.8911567e-06, 1.0543972e-06, -2.6146722e-07, -2.1293877e-06, -1.3858357e-06, 1.5260625e-06, 2.7063363e-06, -1.3567831e-06, 1.6505602e-06, 2.6763703e-07, -1.7033298e-06, -2.007079e-07, 4.18672e-07, 3.3878683e-07, -6.2119204e-07, -1.7476415e-07, -6.432185e-07, -1.145074e-06, -1.0233305e-06, 1.2336174e-06, 8.3490204e-07, -7.8038045e-07, 8.801914e-07, 2.1721604e-07, -9.895588e-08, 1.4996408e-06, 1.2653479e-06, -5.6227634e-07, 3.179648e-07, 1.9552692e-07, -2.0334637e-06, -4.3576782e-07, 7.9004485e-07, 3.8194937e-08, 9.1811256e-07, 3.262127e-07, 1.0643395e-06, -5.250446e-07, -6.5186777e-07, 4.6421096e-07, -4.7124516e-07, 4.1126686e-06, -1.327437e-06, -4.2060697e-07, -3.6810565e-07, 1.8469578e-07, -1.7551754e-06, -1.0947499e-06, 1.4272678e-06, -2.5829152e-06, -1.0727909e-07, -8.0268256e-07, 2.8031693e-06, 6.697988e-07, -2.119104e-06, -3.4258765e-06, 2.1764156e-06, -1.73095e-07, -2.8600164e-06, 3.1245875e-06, 6.0667446e-07, 3.2327455e-06, 1.6670954e-06, 1.4996563e-07, -3.2835007e-06, -1.3472714e-06, 2.2964584e-06, -2.6570137e-06, -3.2478198e-08, 2.153687e-06, 4.5803063e-07, 3.379711e-07, -1.0439231e-06, 9.693697e-08, -2.7660127e-07, 3.991261e-07, -3.5981213e-07, 3.7449942e-07, -6.277345e-07, 5.0410097e-07, -1.0771859e-06, 1.5667304e-07, -3.4917116e-07, 5.310007e-07, 4.5446976e-07, -1.0654393e-06, -9.684161e-07, 7.116051e-07, -9.840631e-07, 8.7783826e-07, -4.772006e-07, -5.911892e-07, 8.433429e-07, 8.496073e-08, -7.228339e-07, -5.750198e-07, 1.1712752e-06, -1.0657368e-06, 8.512691e-07, 1.3854677e-06, 6.485125e-07, 7.420053e-07, -8.303887e-07, 8.4856447e-07, -7.10855e-07, 1.787712e-08, 4.6653405e-08, -4.878333e-07, -3.3462993e-07, 1.6398133e-07, -7.0410664e-07, 2.326078e-06, 9.0975703e-07, -2.4048788e-06, 7.074159e-07, -1.14604255e-07, 4.4513604e-07, -6.3778106e-07, 4.1466078e-07, 2.9319324e-07, 2.139937e-07, 2.6844762e-07, 6.8897447e-07, 3.4318293e-07, -6.788526e-07, 2.0724632e-07, -6.0002765e-07, -3.7411115e-07, -8.6512983e-07, -1.7069603e-07, 1.8638057e-07, -3.9160082e-07, 8.352624e-07, -1.3959823e-07, 3.1134937e-07, 5.3120647e-07, -1.0069461e-06, 1.6834866e-06, -7.354221e-07, 8.422529e-09, 1.2208471e-06, 6.458896e-07, -1.0441744e-06, -1.1477434e-06, -1.083747e-06, 9.881211e-07, 2.0255961e-06, -1.7333349e-06, 8.589313e-07, 5.0028746e-07, 1.5799149e-06, 1.7941586e-06, -2.7811842e-07, -1.6945013e-06, 1.5464825e-06, -1.258964e-06, 2.7170204e-09, -9.574451e-07, 2.7495474e-07, -2.71463e-08, -5.974048e-08, -2.6021678e-06, -3.5520127e-08, 3.3554634e-06, -2.724397e-06, 8.1571454e-07, -1.04412e-06, -1.0108743e-06, 1.3642637e-07, 1.0055517e-06, -1.7112112e-06, 2.6694903e-07, -1.8565287e-07, 3.952336e-07, -1.245708e-06, -1.0509837e-06, -5.27196e-08, 1.4462607e-06, -3.548637e-07, -1.2882293e-07, 6.170068e-07, 4.2879924e-07, -1.0223952e-06, -2.169819e-07, 4.2071767e-07, -3.273965e-07, -9.148097e-07, -3.080943e-07, 9.760882e-07, 6.103718e-07, 4.881643e-07, -3.1854972e-07, 8.0762527e-07, -7.8653403e-07, 3.409357e-07, 2.0166708e-06, -9.774419e-08, 7.1942407e-07, -1.1912367e-06, 1.6607679e-07, -7.9217256e-07, -4.4631835e-07, 3.681157e-07, -8.811752e-07, -2.3033549e-07, -2.2813729e-06, 1.9992344e-06, -4.685317e-07, -5.6842396e-08, 6.749534e-07, 6.011195e-07, 1.3016573e-07, -1.1011427e-06, 2.959581e-06, 3.028577e-07, -6.404315e-07, 9.732639e-07, -3.578413e-08, 1.8064239e-06, 1.4676801e-06, -1.490971e-06, -8.683769e-07, 5.4090066e-09, -1.533703e-06, -1.5601827e-06, 1.1220757e-06, -1.6132113e-06, -6.2249853e-07, 2.3052442e-07, -5.131686e-07, 3.138791e-07, 1.16602905e-07, 1.2721598e-06, -2.1412414e-07, 1.6538246e-07, 1.5389023e-06, -1.836654e-07, -1.3236431e-06, -1.1625087e-06, 1.4889925e-07, 2.636097e-06, 1.2152559e-06, -3.218118e-07, -1.6795781e-06, -9.562614e-07, -3.0689541e-06, -1.0691014e-06, -1.8149631e-06, 6.602573e-07, -2.3016114e-06, -2.0754976e-06, 1.1433087e-06, 2.1094588e-06, 2.634447e-06, 9.854979e-07, 2.7258607e-06, 1.4624064e-06, 6.616166e-07, -2.9640555e-06, 1.2821794e-06, 2.7074822e-07, 4.8604537e-08, -1.3237736e-08, 2.5185102e-06, -3.0584188e-06, -1.0777251e-06, 1.0481004e-06, 1.7743615e-06, 5.5481246e-07, 3.703238e-08, -1.3964188e-07, 1.4831871e-06, 8.5295267e-07, -1.1116052e-07, 8.705885e-07, -9.907626e-07, -2.5638374e-06, -2.1621654e-06, 1.1149638e-06, 5.18936e-07, -5.151282e-07, -1.3921518e-06, 3.561284e-07, -2.4505204e-07, -9.528535e-07, -2.1763461e-07, 9.78989e-07, 3.1522238e-06, 6.007022e-07, 3.111869e-07, -5.5100173e-07, -3.9032133e-07, 2.1139701e-07, -9.361859e-07, -5.2016166e-08, -8.729592e-07, -6.9496394e-07, -3.7545826e-07, 8.522448e-09, -1.5332365e-06, 9.649215e-07, -2.778969e-07, -7.3733105e-07, 6.452071e-07, -1.17141525e-07, 9.432364e-07, 8.176583e-07, -1.1376211e-06, -2.475316e-09, 3.341328e-08, 5.566487e-07, -3.5908604e-07, -2.905127e-07, -6.187174e-07, 2.544853e-07, 1.0355664e-06, 4.1213184e-07, 9.224334e-07, 8.16349e-07, -6.2078556e-08, -9.468759e-07, -7.5223085e-08, -1.3861452e-06, 4.3728508e-07, -1.3963938e-06, 6.1909503e-07, 5.075569e-07, 1.0398476e-06, -6.9816497e-07, -2.8819917e-07, 1.0168343e-06, -7.4945086e-07, -2.2140793e-07, -2.4292208e-07, 4.10116e-07, -4.5258795e-07, -1.8922634e-06, -6.4201527e-07, -2.978159e-07, 7.464223e-07, -3.7879963e-07, 7.206282e-07, 3.444476e-08, 1.1876057e-06, -6.032508e-07, -2.2191523e-07, 4.770514e-07, -3.2143348e-07, -2.562959e-07, -1.1899611e-07, -8.424895e-07, -1.2488495e-07, 5.6834136e-07, -6.1024605e-07, 1.2350037e-07, -5.4977704e-07, 1.3694328e-06, -2.7098017e-07, 1.0763564e-06, -3.872452e-07, 1.7422432e-06, -1.9888412e-06, 2.3089722e-06, 9.507723e-07, -2.6959208e-06, -1.05457e-06, 7.224052e-07, -2.7567687e-06, 2.5126435e-06, 3.462969e-06, -1.6656284e-06, -8.6358204e-07, -1.8078919e-06, 1.6271495e-06, -1.6710611e-06, -4.5383447e-07, 1.856495e-06, -1.5050496e-06, -3.4069676e-06, 1.1840143e-06, 1.3140536e-06, 2.2073204e-06, 9.686172e-07, 3.3307301e-06, -9.839808e-07, 3.0289577e-06, -3.3966055e-06, -2.9015755e-06, -9.37044e-07, -6.307362e-07, 1.5472258e-06, 1.1915511e-06, 5.0618115e-07, -2.3575329e-07, -1.7937064e-06, -4.857927e-07, 8.186228e-08, -9.961669e-07, 1.5801912e-06, 2.5958877e-07, -1.5515778e-06, -1.63873e-06, 7.326316e-07, -7.30414e-07, 1.4140817e-06, 5.7609884e-07, 1.3875409e-06, -2.7345438e-08, -3.641062e-07, 1.951979e-06, 1.301944e-06, 3.021903e-07, 6.8839586e-07, -3.1649854e-06, -3.6734838e-07, -1.4037325e-07, 1.0586759e-06, 5.8954066e-07, 1.217394e-06, 1.6920684e-06, 2.5023434e-07, 7.761755e-07, -2.217483e-06, -1.898879e-06, -2.4793073e-07, 9.107831e-07, 7.373302e-07, -3.289009e-07, -2.2840825e-06, 2.261939e-06, -4.960336e-07, 2.6754872e-06, -3.4947058e-07, -7.494966e-07, 1.917815e-06, -2.9558558e-07, 5.258912e-07, -1.062e-06, -6.095845e-07, -1.6191024e-07, 4.13909e-07, -1.8236935e-07, -2.91714e-07, 1.9583972e-06, 1.7739666e-08, 1.3138015e-06, -1.3880478e-07, -8.404507e-07, -3.2914468e-06, -2.3245248e-06, -6.105237e-07, 1.7895985e-06, 2.5837608e-07, 4.8039146e-07, -1.4472733e-06, 2.2691204e-06, -2.0664083e-06, -1.1441495e-06, 2.9309606e-07, -8.7398035e-07, 5.366453e-07, -7.929436e-07, -1.5224734e-06, -4.6659505e-07, 1.6617206e-06, 1.8912946e-06, -4.716269e-07, -1.5835195e-06, -6.814047e-07, 1.363794e-07, 1.4967385e-07, -4.8711416e-07, 2.7948238e-07, -1.0347431e-06, -1.0182516e-06, 8.551922e-07, 1.0186004e-06, 2.1384342e-06, 1.3521899e-06, 2.044502e-06, 4.9732193e-08, 1.714082e-06, -2.7336118e-06, -2.0187636e-06, -1.7045834e-06, 4.4717513e-07, 1.4544391e-06, 1.3934276e-06, -8.8230587e-07}},
    {"bert.encoder.layer.1.attention.self.key.bias_grad", {1.9895197e-13, 0.0, -1.7053026e-13, -4.2632564e-14, -7.1054274e-14, 0.0, -1.4210855e-14, 2.842171e-14, 5.684342e-14, 1.0658141e-13, 4.2632564e-14, 1.7053026e-13, 1.2789769e-13, 5.684342e-14, -1.6342483e-13, 2.1316282e-13, 1.9895197e-13, 3.0553338e-13, 0.0, 2.842171e-14, 6.3948846e-14, -3.0553338e-13, -1.9895197e-13, 3.4816594e-13, 5.684342e-14, -1.4210855e-14, 4.973799e-14, -5.684342e-14, 2.5579538e-13, -1.4210855e-14, 1.4210855e-14, 7.1054274e-14}},
    {"bert.encoder.layer.1.attention.self.value.weight_grad", {-5.3047097e-05, 6.721157e-05, 2.7943528e-05, 0.00015796348, 0.000176764, 8.4658546e-05, -2.5629139e-05, 3.6562813e-06, -0.00013966887, -0.00010210618, 5.4951033e-05, 6.2759565e-05, -0.00012073506, 0.00012683791, 1.9329229e-05, -0.00022574794, 5.746274e-05, -3.7522488e-05, 0.00011461118, 2.567229e-05, -2.852698e-05, -5.2387837e-05, -9.234606e-05, 9.6073054e-05, 3.905793e-05, -9.3769835e-05, -0.00019517267, -5.817546e-06, 0.00013108345, -0.00010621785, -7.3648436e-05, 0.000106308085, 8.154381e-05, -4.3643417e-05, -2.3026674e-05, -0.0003319105, -0.00020494264, -0.00017512967, 6.220669e-05, -2.3722987e-05, 0.00012902368, 0.00012502845, -0.00016085865, -5.2845677e-05, 0.000104688384, -0.00015579392, -0.00012415265, 0.0003156869, -0.00011201651, -2.5741598e-05, -7.205783e-05, 9.9212935e-05, 0.0001097637, 0.00012599594, 0.00023114066, -0.0001877442, -4.071253e-05, 0.000113551156, 0.00024297132, 3.10779e-05, -0.00012358108, 0.00012433261, 0.00014871523, -0.00018705885, -0.00016104218, -0.00011080707, -7.2714036e-05, 9.103117e-05, 0.0001795667, 0.00043145267, 0.00013833512, -0.00022246217, -0.00019771136, 0.00017835699, 0.00010811585, 4.3831467e-05, -0.00016301328, 0.00016175052, 1.4137025e-05, 2.5704705e-05, -0.00029370887, -3.4884648e-05, -0.0002044773, 3.8899107e-05, -0.00042294618, 0.00013538306, -1.6362239e-05, 0.00018313093, 8.222781e-05, 0.00018347411, 0.0003523616, -0.00033598224, -0.00024867943, 0.00012526051, -0.00014431289, 0.00015608416, -6.277967e-05, 0.00039043845, -5.3606593e-05, 0.00026373658, 3.071056e-05, -0.000360912, -8.3591614e-05, 0.00016114814, -0.00015373617, -0.00036554685, -0.00010965685, 0.00014934133, 4.6709643e-05, 6.0854232e-05, 6.472715e-05, -0.0005787294, 0.0004557315, 0.0002358467, 0.0005705348, -0.00017272722, 0.00084756926, -0.00029325555, -3.7686703e-05, -0.00013353542, -7.24636e-05, -0.00048432502, -0.0010034239, 0.00015005044, 0.00049511663, -0.00022626128, 1.0661995e-05, 0.00025906033, 7.2927185e-05, -8.277679e-05, -2.6819544e-06, -0.00015617427, -0.00012623526, -5.7549372e-05, 4.5931796e-05, 4.4477615e-06, 8.134439e-05, 5.2225743e-05, -5.9171856e-05, -5.6212346e-05, 6.40825e-05, -6.3353145e-05, -5.4156877e-05, 0.00019915073, -9.8083736e-05, -3.378256e-05, -0.00010566687, 5.7954472e-05, -3.239801e-05, 7.681478e-05, 9.984395e-05, -5.0634502e-05, -2.488429e-05, 0.00010683385, 0.00024400397, 1.5536474e-05, -0.00012598345, 5.7144625e-05, 4.6807185e-05, -9.530403e-05, -2.3234179e-05, -4.08535e-05, 5.945324e-06, -0.00026135225, -8.944528e-05, -4.2626366e-06, 6.335532e-05, -0.00014310578, -3.541579e-05, 0.00014021163, -9.172928e-05, 1.10403025e-05, -3.3000229e-06, -5.9397524e-05, -7.476756e-05, 0.00025790287, -0.0001290705, -7.3166404e-05, -0.00013073282, 0.00019415593, -8.048611e-05, 0.00011364375, 0.0002455725, 2.158168e-05, 7.4458485e-06, 9.3406095e-05, 0.00030011148, -0.00012643353, -0.00020308315, 0.00012723834, 7.972445e-05, -9.1499314e-05, -9.558407e-06, -0.00041752768, -0.00012895794, -0.000340816, -0.00038754212, 0.00031048968, 0.0002544936, -0.00034793114, 7.546371e-05, 0.0004939676, -2.7456288e-05, -0.000107797576, 0.00016403072, -0.0001500902, -7.352176e-05, 0.00076260837, -0.0005657031, 8.470513e-06, -0.0006522475, 0.00010516515, -0.0005663638, 0.0003229998, 0.0003132217, 4.4072698e-05, -2.205165e-05, 0.0006176877, 0.0012405164, -0.00042117143, -0.0007434454, 0.00039801118, -1.2048564e-05, -0.00013696827, 0.00011488729, -2.125925e-05, 1.9672541e-05, -0.00026335224, -0.00013420977, -0.00019440248, 5.573362e-05, 1.9219651e-05, 5.744039e-05, -1.3707568e-05, -0.0001711848, -4.1029707e-05, 1.6827997e-05, -6.6442866e-05, -0.00014523411, 0.00017420587, -6.741664e-05, -5.316868e-05, 1.4052277e-05, 0.00015156627, 0.00013556328, 9.946016e-05, 0.00020973569, -0.0001230255, -2.1653274e-05, 5.8975522e-05, 0.0001329603, 0.00010089271, -4.7356392e-05, 3.7821057e-05, 0.00010371563, -0.00013928702, -4.1011775e-05, -7.6183336e-05, -2.6156018e-05, 0.0003428433, 0.00030866842, 0.00031277566, -1.7038175e-05, -3.4035575e-06, -0.00013146685, -2.9742827e-05, 0.00021842173, 7.795405e-05, -0.0001810364, 0.00019512836, 6.37619e-05, -0.00026116733, -0.00011530787, -4.0073766e-05, -1.3518777e-05, -7.2559975e-05, -0.0002822072, -2.3244727e-05, -0.00032049383, 0.00012987, 6.819857e-05, 1.9340043e-05, 1.4533087e-07, -0.00012553617, 8.023463e-05, -6.484681e-05, -0.00012845815, 0.00013611146, 1.6422e-05, 8.2396975e-05, 1.6108286e-05, 7.925491e-05, -5.8733083e-05, -0.00015321067, -3.2582095e-05, 9.152894e-05, 3.7745365e-05, -0.00013936729, -3.7225305e-05, -1.2624106e-05, 4.9676935e-05, -1.4474002e-05, 1.2849122e-05, -0.00014524146, 0.00019431915, 0.0001092913, 0.00015679702, -8.960748e-05, 0.0002462441, -9.190574e-05, -3.3936976e-05, -4.901838e-05, -2.1783979e-05, -0.00013086783, -0.00032676625, 0.00014057284, 0.00014620791, -8.734433e-05, 1.1579248e-05, 3.369495e-05, -0.00014210417, 0.00019851998, -1.9007824e-05, 0.00013219508, 0.00014663243, -1.0897973e-05, 9.072921e-05, -4.8330698e-05, -0.00028681333, -0.00021595467, -7.7245655e-05, 0.00010989436, -0.00013139301, 0.00021409348, -2.0069416e-05, -0.00034294216, 0.00012361995, 5.5363682e-05, 0.00028113343, 6.831923e-05, 0.00027335872, -5.904297e-05, 9.090646e-05, 9.1191585e-05, 2.5639718e-05, -0.0002093433, -0.00044927793, -6.2262094e-05, 0.00016668122, -0.0001484239, -0.00010777566, 0.00026260634, -3.9664374e-05, 0.00023184401, -4.046319e-05, -4.0165134e-05, -7.94919e-05, -0.00027247725, 7.818382e-06, 4.6896046e-05, -5.4512973e-05, -0.000119597535, -0.00018646035, 2.625337e-05, 5.740141e-05, -1.9128336e-05, -1.7785076e-05, -0.00018620813, 0.00019513266, 0.0001387458, 0.00026151026, -3.8946066e-05, 0.0005139894, -7.5462645e-05, 0.0001522556, -0.00011204481, -2.7577911e-05, -0.00023908801, -0.00047248794, 7.38185e-05, 0.0001679126, -3.7480622e-06, 3.5386398e-05, 0.0001163452, 0.0001717038, -1.3279939e-05, 3.648433e-05, -0.0006909255, -0.00045246936, -0.0004875712, 2.2329627e-05, 5.450096e-07, 0.00030851958, 0.0001642739, -0.0003247958, -0.00012292931, 0.00025241415, -0.00036251283, -0.00017678215, 0.0006148231, -2.1498607e-05, -6.0058752e-05, -0.00010114653, 0.00021436384, 0.00029160667, 0.00014721256, 0.0004909722, -0.00029818312, -9.3193084e-05, 9.85258e-05, 0.0003078181, 0.00017436431, -0.0001829473, 0.00018627798, 0.00031031584, -0.00040425741, 6.3899635e-05, 0.0001264353, 5.2607204e-05, 1.391038e-05, -1.3085874e-05, -0.00022128293, -0.00011712893, 0.00017699541, 0.00012613871, -9.663702e-05, -3.689418e-05, -3.38812e-05, 6.9556314e-05, -8.007941e-05, 2.5363901e-05, -0.00012427197, 0.00022110813, 3.055539e-05, 0.00016569208, -0.00011896172, 0.00025301345, -0.00011119739, -7.734587e-05, -0.00014345709, -4.488347e-05, -0.00015434, -0.00035881557, 0.00023925255, 0.00022824766, -5.239246e-05, 5.7301124e-05, -6.542212e-05, -0.000108958244, 0.00029877236, 4.761244e-05, 0.00082966813, 0.00058160844, 0.00011952126, -0.00025509682, 0.0002940192, -0.00019060302, -0.00047949792, 0.00032617882, 0.00015639554, -0.00024160653, 0.00032328576, 0.00026874023, -0.0010241676, 0.0004931225, 0.00011281689, 0.00052308076, -0.0003539905, 0.00022633614, -0.00041035927, -0.00069024495, 0.00019011169, 7.002727e-05, -0.0005710371, -0.001186521, 0.00018529085, 0.0006738157, -0.00040958935, -0.00019705447, 0.00039832277, 0.000118489166, -0.00012625685, -4.8344096e-05, -0.00030258676, -0.0002842859, -0.00013823691, 3.6433383e-05, -2.265664e-05, 0.00019076031, 0.00015016143, -8.880169e-05, -6.2419385e-05, 0.00017689483, -0.00020764416, -6.544694e-05, 0.00041032906, -0.00013876097, -1.6233755e-05, -0.00016866253, 6.2596904e-05, 2.5946872e-05, 0.00010069791, 0.00018117811, -0.00014664137, -6.27183e-05, 0.00016574444, 0.0004177182, -5.4682914e-06, -0.00021259049, 0.00011389922, 0.00015773754, -0.00021083232, -0.0004473024, 0.00018370822, -0.00019383256, 0.0003460022, 0.00028884245, 0.00046346305, 0.00026018135, -0.00040071624, -0.0006516958, 4.6152378e-05, -1.3017855e-07, 0.00023775428, -0.00025293464, 0.0003952819, 6.596055e-05, -0.00044585732, -0.00016131962, 0.00017916887, 9.721883e-05, 2.3847966e-05, 2.1100985e-05, 2.1751437e-05, 0.0001368677, 0.00031166643, 9.942165e-05, -8.9287074e-05, -0.00019999553, -0.00063067005, -0.000109319844, 0.000101094956, -0.00032166406, 0.00062524003, 3.51643e-05, -0.00027348264, 2.580139e-05, -0.000249603, -2.8249004e-05, 0.0002907111, 6.930068e-05, -0.0001696854, 4.33867e-05, 0.00031852289, 3.476223e-05, -9.888132e-05, -5.252924e-05, -4.321423e-05, -7.381617e-05, 0.00045429185, -0.0004116715, -0.00022560757, -0.0004488857, 0.00021653462, -0.0006571803, 0.00025886588, 0.000106608146, 0.00013647001, 7.2484596e-05, 0.0003751194, 0.00085556944, -0.00017173156, -0.0004176598, 0.00020848976, -1.9001578e-05, -0.00016088424, -0.00011668741, -7.641916e-05, 3.7970007e-05, 0.00046544557, 0.00036490452, 0.00044086587, -1.9627516e-05, -5.0294155e-05, -0.0002194571, -8.050533e-05, 0.0002608656, 4.4645414e-05, -0.00024233856, 0.0002962605, 0.00010616521, -0.00036093636, -5.666899e-05, -4.8992995e-05, -4.6775855e-05, -5.3943273e-05, -0.00047793274, -4.1351384e-05, -0.00035057418, 0.00033069876, 0.00012402378, 2.7006454e-05, -4.035059e-05, -0.00012254453, 6.9820715e-05, -0.00013069426, -0.0002832696, 0.00025069164, 5.716386e-05, -2.5196294e-05, 8.1419304e-05, -0.000117480005, 5.5238088e-05, -2.2179884e-05, -2.8759832e-05, 4.1210038e-05, 3.104076e-05, -2.0713827e-05, -7.664193e-06, -2.7623764e-05, -5.546287e-05, -3.1291663e-08, -4.781211e-05, 7.75582e-05, -1.7175687e-05, -0.00015249728, -2.6544076e-05, 0.0001407715, -0.00013413138, 4.5343353e-05, 2.4105771e-05, 3.3743774e-05, 2.3950384e-05, 7.860262e-06, 8.956094e-05, 9.180914e-05, -2.4143153e-06, -4.5179346e-05, 4.0571875e-05, -0.00011048105, -4.6268236e-05, 3.4920326e-05, -3.937897e-05, 0.00013002005, 0.000111517016, 8.8658344e-05, 5.866328e-06, -1.5845384e-05, -9.119449e-05, -2.6908161e-05, 4.590899e-05, 6.28533e-05, -7.3569914e-05, 7.143504e-05, 1.9691344e-05, -0.00015583592, -2.9330158e-06, 3.7122336e-05, 7.3754636e-05, -5.088837e-05, 2.914726e-05, -2.9441208e-05, -7.971126e-05, 1.1634452e-05, 1.37278375e-05, -4.814873e-05, -0.000115530005, -6.5551474e-05, 5.5887318e-05, -1.4720524e-05, -2.5256524e-05, 8.903763e-05, 8.136374e-06, 0.00014589692, 4.5112138e-05, 0.00035362755, 0.00030773308, 4.6450365e-05, -0.00024638994, 0.00025265221, 0.00010478263, -0.00015300915, 0.00023872647, 4.396466e-05, -7.089769e-05, 1.2943304e-05, 0.0001635129, -0.00041570156, 0.0002954295, 1.3191448e-05, 0.00024270236, -0.0002958925, 6.538147e-05, -0.0002336054, -0.00047346533, -5.0014518e-05, -2.019621e-06, -0.00028212983, -0.00058522687, 0.00022327862, 0.00037311373, -0.00017959843, 3.9385002e-05, 1.19299975e-05, -5.0426697e-05, 0.00022892676, -2.3893428e-05, 7.241301e-05, -5.6053548e-05, -0.00025381387, -1.0713535e-05, 7.17629e-05, -7.370473e-05, -0.00019681026, -0.00010895124, 7.319311e-05, 6.0076476e-05, 2.1317974e-06, 1.0115229e-05, -0.00025832772, 0.00028662654, 0.00016187633, 0.0003250102, -8.043967e-05, 0.000533875, -0.00015016887, 6.4564934e-05, -0.00010649779, -5.6463563e-05, -0.00026641917, -0.0005733228, 9.444269e-05, 0.00024057156, -0.000116064606, 4.1920597e-05, 0.00011456432, -0.00015745859, 0.00041204604, -1.54173e-05, 0.00071325665, 0.00039131867, -7.871428e-05, -0.00014753573, 0.00021339064, -0.00031059375, -0.00049769634, 0.00012170766, 0.00020546568, -0.00014089755, 0.00030260455, 0.00017475593, -0.0010076006, 0.0005260012, 0.00021440543, 0.000661057, -0.00028506012, 0.00059925934, -0.00039612435, -0.00042032156, 6.85458e-05, 1.9281746e-05, -0.00059328583, -0.0013051373, 0.00013366461, 0.00071221415, -0.00039601026, -0.00018479984, 0.00046767842, -1.8579027e-05, -3.8048544e-05, -1.4840438e-05, -0.00015119922, 1.9202613e-05, 5.855929e-05, 3.8921746e-05, -8.6290485e-05, -2.2141365e-05, 0.000116417614, -1.593073e-05, 2.7992535e-05, -4.1220726e-05, -2.0924037e-05, -2.92902e-05, 0.00015106362, -0.00012541984, -5.9051687e-05, -0.00010183447, 9.074793e-05, -9.174203e-05, 7.61922e-05, 0.00010735017, -5.1750277e-07, 1.2904944e-06, 6.0985738e-05, 0.00021617087, -0.00012282019, -0.00014868792, 0.00011984958, 6.8254325e-05, -6.446035e-05, -4.6695888e-05, -0.000113356524, -6.602713e-05, -7.6106917e-06, -0.00010184077, 0.0001441225, 6.420398e-05, -0.00011743309, -3.61705e-06, 0.0001686838, 3.8256218e-05, -5.7612565e-06, 6.415424e-05, -3.8304606e-05, 3.1946183e-05, 0.00016611847, -0.00014591374, 6.178626e-05, -0.00020216929, -4.559449e-05, -0.00015455286, 5.4805267e-05, 3.5719386e-05, 3.305277e-05, -1.5124888e-05, 0.00015400983, 0.0003230542, -0.0001948382, -0.0002283722, 0.00014789852, -1.834774e-05, 1.7748847e-05, -5.8764348e-05, 0.00015211778, -4.3862724e-06, 0.00044896803, 0.00025150966, 7.971438e-05, -0.00015166432, 0.00016504122, -3.721243e-05, -0.00020029227, 0.00019871545, 6.771007e-05, -6.131112e-05, 0.00010579015, 0.00017119198, -0.00049244467, 0.00027116042, 9.9556404e-05, 0.00025775682, -0.00027866592, 0.00012328164, -0.00023236661, -0.000398944, 4.18722e-05, 6.435168e-06, -0.00026935455, -0.0005943616, 0.00010638302, 0.0003372496, -0.00020399308, -8.5081614e-05, 0.00018438885, -8.256661e-05, -0.00020894899, -4.5288918e-05, -0.00014685636, -7.137396e-05, 0.0002833137, 0.00018565747, -0.0002604091, -0.000113784125, 0.0002349061, -1.0382548e-05, -1.9420584e-05, -3.4799792e-05, 5.0457307e-05, -7.6513454e-05, 0.00032733858, -0.00035318185, -7.202554e-05, -0.00032587972, 0.00018583381, -0.00043020232, 0.0002218842, 0.00019220452, 0.00014624624, 5.4334905e-05, 0.000321605, 0.0006473843, -0.00030114144, -0.00038303802, 0.00015608846, -8.530261e-05, 1.3860984e-05, 3.1422856e-05, 0.0002182793, 5.2590644e-07, 3.6499823e-05, -8.188342e-05, -0.00031036668, -0.00013030542, 0.00017769734, 0.00014940061, -0.0001284658, -6.178213e-05, -4.827594e-06, 0.00012563005, -0.00014123842, 5.710436e-05, -0.00018187735, 0.00034411077, 0.00016148154, 0.00028456238, -0.000221195, 0.0004994656, -0.00018317142, -5.4819127e-05, -0.00021701411, -7.824193e-05, -0.00025360173, -0.0005804219, 0.000252437, 0.0002804042, -7.3081654e-05, 0.00011310469, -2.9832496e-05, -0.0002223181, -6.346311e-05, -9.8694225e-05, 0.0002575138, 0.00017741765, 0.0004288962, 0.00013885836, -0.00025068884, -0.00028125528, 0.00011669117, 0.00011314255, 9.0045876e-05, -0.00016139317, 0.00021151855, 4.1279527e-05, -0.00014644217, -0.0001930673, 9.2204835e-05, -0.000105616455, -3.891563e-05, -0.00029974116, 6.59736e-05, -6.146194e-05, 0.00020727051, 9.016005e-05, 0.00012275291, 0.00013218341, -0.00036461267, -0.0001479116, 8.4155356e-05, -0.00020878208, 0.00027429918, -0.00018770866, -4.3037275e-05, -0.00011265449, 0.0003408187, 0.0002511817, 0.00039836764, 0.00012669296, -0.00019253789, -0.0003448116, 1.00624075e-05, 0.00014003084, 0.00015064742, -0.00019162963, 0.00027720493, 3.9553805e-05, -0.0002729028, -0.00018471421, 5.6722376e-05, -1.0927291e-05, -2.0136395e-06, -0.00020734654, 2.3548786e-05, -0.00013019699, 0.0002136904, 8.383146e-05, 3.3877346e-05, 3.7931957e-05, -0.00036793388, -4.7591995e-05, -9.34201e-06, -0.00019441619, 0.00031560234, -2.4041496e-05, -0.000126921, -6.391302e-05, -3.9779792e-05, -0.00010355345, 0.00011943508, 0.00011739636, -0.00011761499, -1.1006943e-05, 0.00014318028, -2.9118883e-05, -4.10668e-05, 2.0759824e-05, -1.18120624e-07, -3.5264842e-05, 0.00015262303, -0.00019065164, 7.526446e-05, -0.00018601387, -1.3774636e-05, -0.00013750038, 0.00011531593, 7.893542e-05, 1.49475645e-05, 1.5069999e-05, 0.00018479749, 0.0003125137, -0.00015549986, -0.00022758229, 0.00016578038, -4.33673e-05, 3.0769777e-05}},
    {"bert.encoder.layer.1.attention.self.value.bias_grad", {-0.0002499849, 0.00039443103, 0.00020218678, -0.00086993387, 0.00024441208, 0.00039980936, 0.0011049673, 0.00022627263, -0.00022378415, -0.00027336302, -0.00042279702, -0.00030427083, 0.0006823707, -0.00025931542, -0.0013740305, 0.00048671232, -0.00033106175, 0.0007314325, -0.00034934928, 0.00010904957, -0.00015447194, -0.0006055928, -0.000427154, -0.001370071, 0.0002663445, 0.0002577236, -0.00069437077, 0.00055093993, -0.00039024817, -2.6082193e-05, -0.00017709425, 0.00025645614}},
    {"bert.encoder.layer.1.attention.output.dense.weight_grad", {0.000108369706, 0.00019117142, 0.00012087095, 0.00014745697, 0.00023306938, -9.8428674e-05, 2.3705617e-05, -0.000101206344, 3.6466514e-05, -0.00012317715, -0.00012352048, -1.879098e-05, -6.0505008e-05, -6.1326555e-06, 3.8081325e-05, -2.2821754e-05, 7.088798e-05, -5.365659e-05, 3.0112324e-05, -1.84209e-05, -4.6957135e-05, 1.1993587e-05, -4.691877e-05, 0.00011191124, 7.9163845e-05, 4.4790224e-05, 1.639833e-05, 1.1398981e-05, 0.00014250947, -0.00010394345, 0.00011388967, 9.241671e-06, -7.8232544e-05, -5.070398e-05, -4.534479e-05, -1.175237e-05, -4.8798873e-05, 3.669214e-05, -2.4464873e-05, 3.649045e-05, -4.3094547e-05, -2.690188e-05, 4.5183333e-05, 6.5732784e-05, -3.2368625e-05, -6.518683e-05, -1.0258087e-05, 1.6557937e-05, -4.792056e-05, -3.3058022e-05, 7.595496e-06, 4.7347967e-05, 8.491845e-06, -4.4431086e-05, -4.3969663e-05, -9.4353025e-05, -3.0525887e-05, -6.782569e-05, -1.184409e-05, 4.438456e-05, -6.175325e-05, 2.9743718e-05, 2.8706603e-05, -9.40098e-05, 5.6944096e-05, -6.223925e-05, 0.00031079885, -0.0001104783, -0.00024717176, 1.672041e-05, 6.0291128e-05, 1.7777018e-05, -0.0001805503, 0.00018315326, -1.4085308e-05, -4.4072047e-05, -5.9259008e-05, 9.52387e-05, -8.862389e-05, -7.0169626e-05, -1.9239833e-05, 0.00012530223, -9.558495e-05, 2.459954e-05, 3.1645002e-05, -1.4751717e-05, -0.00014870355, 6.0358183e-05, 0.00011516878, 6.440992e-05, 1.8098031e-05, 7.160638e-05, 0.00011417663, 0.0001328308, -0.00025331075, -0.00015070914, 0.00020718687, 0.00016725055, 0.00014798436, 0.00023651398, 0.00039136657, -0.00010066096, -0.000102336126, -4.19927e-05, 0.00016514857, -3.5278306e-05, -0.00014909277, -0.00013903088, 0.000101056874, 0.00012135759, 2.2681628e-05, 6.248521e-05, 0.00023744248, 9.0090114e-05, 7.672995e-05, -0.00018653063, -0.00022416873, 1.6663578e-05, 0.0001649445, 0.00020926331, 8.3566105e-05, 0.00017219948, 9.4278275e-06, -6.994888e-05, 0.00024527992, -0.00024272717, -4.7235695e-05, 0.0005214245, 2.5259205e-05, 0.00027886167, 0.0001051386, 0.0004037014, 0.00037897937, -9.8497585e-05, -1.3904587e-05, -0.00012752014, -5.9001522e-05, -0.0004346174, -0.00016044705, 0.00029281434, -0.00033257488, -0.00017759521, 4.8182705e-05, 7.7392106e-05, -0.00015579065, -0.00012939429, 8.037409e-05, 2.1003252e-05, -0.00013997656, -0.00014897586, -0.00017627598, -0.0001904982, -2.2763157e-05, -0.0003486481, 4.0968815e-05, 0.00018478175, 0.00018458646, -7.031561e-05, 0.00039071517, -0.00017425542, 4.4612323e-05, 0.00015967093, -0.00019418453, 0.00030886542, 0.00041648652, -9.080546e-05, -7.983483e-05, -7.051645e-05, 0.00015127278, -0.00031957967, -5.799418e-05, 0.00011701469, -5.5512217e-05, -0.00017218088, 0.000101465186, 0.00012206058, 1.987148e-05, -0.00010759201, 0.00012177763, -2.3570965e-05, -0.00016241, -0.00010196774, 6.6181616e-05, -8.1681224e-05, -4.125811e-05, -0.00018190421, -1.8177652e-05, 7.7781086e-05, 4.401313e-05, -0.0001992563, 0.00035179485, 0.00018104524, 0.0004805793, 0.00026790265, 0.00015621712, 0.00032020712, 0.00065335736, -0.00017559693, -0.00014829959, -9.087637e-05, 0.00041483992, 9.8894445e-05, -0.0001970826, -0.00044128127, 0.00037330974, 0.00031270264, 8.047243e-05, 9.8762306e-05, 0.00050195213, 0.00024868618, 9.249473e-05, -0.00039925147, -0.00038069516, 0.00012016204, 0.00047606236, 0.000521097, 0.0001642042, 0.00044904865, -5.0333485e-05, -0.00020981373, 0.00039293832, -0.00046796532, -0.00021151104, 0.0012175237, -0.0007903678, -0.0006779833, -0.0002731295, -0.00079230726, -0.0013397153, 0.00043854985, 0.00013208887, 0.00031334304, -0.0005841686, 0.00030815662, 0.00045100102, 0.00044118057, -0.00026790897, -0.00021958574, -0.00020243385, -0.00013554415, -0.000646702, -0.00015761719, -0.00020109676, 0.00045266224, 0.0006160759, -7.404262e-05, -0.00046280518, -0.00070879055, -0.00029528697, -0.0004365723, 3.4160992e-05, 0.000102848426, -0.00070492574, 0.00079303037, -0.00015766166, -0.0014340081, -4.974735e-05, -0.00012519084, -0.00028527598, -0.00020098401, -0.0001368145, 4.24605e-05, 3.4806588e-05, 4.027546e-05, 9.685556e-05, 0.00011201361, 0.00013148008, -9.744802e-05, 0.00016257263, 4.500117e-06, 2.618187e-05, -3.6568246e-05, 4.1790695e-06, -5.3553456e-05, -1.0455599e-05, 3.3174525e-05, 0.00013481546, 0.00011667806, 0.00015084242, 1.7790098e-05, -6.8081834e-05, 0.00013211707, -4.517388e-05, -0.00010740948, -0.00021603306, 7.821697e-06, -1.3239244e-05, 2.0111727e-05, 0.00021986885, 2.8850905e-05, 0.0001399358, 1.4175898e-05, 9.004687e-05, -7.157898e-05, -3.4580912e-06, -2.723659e-06, 9.46418e-05, 6.967088e-05, -4.3293243e-05, -0.00018302341, 0.000176378, 0.00016496108, 1.7536426e-05, -2.7995336e-05, 0.00017969246, 0.00015837813, -1.6451628e-05, -9.0367605e-05, -0.00012496828, 7.7348544e-05, 0.00014676795, 0.00025392647, 0.00011657918, 0.00023438991, 4.6632475e-05, -2.4756282e-05, 0.00011284841, -7.115312e-05, -0.00018552873, 0.00036803604, 3.6691556e-05, 6.685112e-05, 0.0003317215, 0.0001389699, 4.320733e-06, 4.603573e-06, -7.380413e-05, -1.3297291e-05, -0.00011000687, 5.9873673e-05, -9.16267e-05, 1.5267437e-05, -0.000116296884, 8.499759e-05, -6.40668e-05, 4.7061283e-05, 1.7731454e-05, 0.00011456102, -2.1011105e-05, -8.011436e-05, -0.00011478349, -9.290403e-05, -8.586638e-05, -6.6322227e-06, 9.9863486e-05, -5.59608e-05, 1.5348123e-05, 4.688442e-05, 0.0002300762, 2.3423006e-06, -0.00014479434, 0.00010658649, -7.9702644e-05, -6.3391974e-07, -0.00012819875, 4.317474e-05, 4.5044122e-05, -2.9996661e-05, 1.1251244e-05, -1.3560269e-05, 1.4313259e-05, -0.00016443321, -1.8339152e-06, 0.00015176558, -0.00010838571, -0.00015590253, 1.9914627e-05, -1.0890773e-05, -9.832508e-05, -0.0001296067, 3.997202e-05, 9.8575154e-05, 3.5034154e-05, -7.507253e-05, -9.230931e-05, -0.00012254955, -5.4978405e-05, -0.00015600331, 1.2218129e-06, 7.212805e-05, -5.5538327e-05, 5.299881e-06, 0.00022005061, -0.00023095285, 6.3052365e-05, 0.00010397956, 0.00016822704, 0.00013439618, 0.0001980293, -7.0989976e-05, -5.9247726e-05, -3.6971964e-05, 5.8900765e-05, -2.594496e-05, -0.00014462463, -6.4261025e-05, -2.260723e-06, 5.553752e-05, -9.129649e-06, -5.303081e-06, 0.00016621675, 7.0936685e-06, 4.3182336e-05, -7.088821e-05, -8.72892e-05, -2.7492342e-05, -8.069606e-06, 0.00013660561, 9.1558286e-05, 0.0001161778, 4.396179e-05, -5.1055325e-05, 0.00017717574, -0.00012998028, -8.740375e-06, 0.00017341472, 0.00015766826, 2.8875425e-05, 0.0002687643, -2.1227504e-05, 2.4757417e-05, -3.7483183e-05, -9.041941e-06, 9.424777e-06, 3.381926e-05, 0.00016039595, -7.115187e-05, -0.00017490747, 0.000119257216, 0.00021076044, -4.657478e-05, -5.1122635e-05, 0.00013986406, 0.00015513986, -3.451086e-05, -0.000103263366, -8.429882e-05, 8.347664e-05, 6.865851e-05, 0.00022997169, 9.291264e-05, 0.00022913219, 1.8448303e-05, -7.724023e-05, 0.00015989545, -3.9519782e-05, -0.0002758729, 0.00025369992, -0.00014193481, -0.00019671605, -0.00015458552, -0.00028156568, -0.0003842182, 0.00011838653, 4.6810037e-05, 6.254257e-05, -6.792523e-05, 0.00022767055, 0.00017125119, -5.0807095e-05, 8.2135266e-05, -7.222825e-06, -1.7898157e-05, -2.1234173e-05, -8.006973e-05, 2.1509804e-05, -8.2860315e-05, 7.379541e-05, 0.00017256585, 2.8577793e-05, -8.737508e-06, -6.708373e-05, -4.2815e-05, -2.2484157e-05, -6.0891947e-05, -3.817829e-05, -0.00021650564, 0.00016157074, -0.00013235585, -0.0001739268, 3.7181107e-05, 0.00014287212, -0.00015114898, 0.00015878752, 0.00029244047, -5.4262808e-05, -1.0906703e-05, -7.6486795e-05, 0.00011648666, -0.00017779326, -3.521239e-05, 1.620635e-05, -1.0611511e-05, -0.00011837721, 8.1956496e-05, 4.3250366e-05, 3.6349178e-05, -0.00011072459, 6.549421e-05, -1.161185e-05, -4.7151017e-05, -2.7807293e-05, 3.200194e-05, 2.951887e-06, -3.411603e-05, -5.8127385e-05, -5.790015e-05, 1.1405948e-05, 5.721052e-06, -0.00015055176, 0.00023577754, 8.9057634e-05, 0.00026344412, -1.032081e-05, 9.3059236e-05, -2.8151317e-05, 0.00010758297, -9.61871e-05, -1.1221813e-05, 2.6296157e-06, 0.00019529862, 0.0001865931, -4.9562128e-05, -0.00029358952, 0.00028048985, 0.00022760089, 2.3261944e-06, -3.2271684e-05, 0.00025126306, 0.00019047451, -9.582121e-06, -0.00014079225, -0.00012371082, 0.00012154432, 0.00024290176, 0.00034219472, 0.00011236062, 0.0003390471, 7.381197e-06, -0.00011994353, 0.00013185167, -0.00014377561, -0.00025974694, 0.0005149189, -0.00011814569, -0.00016144183, -0.0002790444, -0.00013242065, -0.00013142581, 0.000111890324, 6.088835e-05, 7.32909e-05, -1.6093776e-05, 9.082957e-05, 9.433223e-05, 6.8327856e-05, -6.013725e-06, 1.2264156e-05, -6.461484e-05, 3.692015e-05, -0.00020418022, -1.51533e-05, -6.913513e-06, -5.231855e-05, 0.00013733088, 7.999152e-05, 0.00011277753, -0.00022296737, -0.00027345642, -9.034496e-05, -5.7452035e-05, -0.00012051877, -0.00016687126, 8.038731e-05, -4.133174e-06, -8.398824e-05, 0.000106378386, 0.00017689793, -0.00018077003, 0.00020322354, 0.00033695373, -7.781472e-05, -3.2215423e-05, -9.649001e-05, 0.00018535048, -0.0001846318, -3.0613286e-05, -2.1483933e-05, 3.7908292e-05, -6.637709e-05, 0.00011499023, 6.977947e-05, 6.1750696e-05, -7.1824776e-05, 7.190042e-05, -6.239442e-05, -9.304372e-05, 7.788568e-06, 0.00015176435, 4.0533287e-05, -7.670108e-06, -3.026872e-05, -4.556784e-05, -9.486323e-06, 2.8545965e-05, -0.00018757956, 0.0002353034, 0.0002820226, -0.0003533683, -0.00018463275, 3.5819183e-05, -0.00018248643, -0.0004884239, 0.00012747801, 8.59548e-05, 5.0661543e-05, -0.00035515148, -9.356281e-06, 8.007529e-05, 0.00030287815, -0.00032491697, -0.00020263746, -9.9002726e-05, -5.4122236e-05, -0.00032989043, -0.00012782216, -8.464065e-05, 0.0002574421, 0.0002476898, -0.00016120909, -0.00042519718, -0.00036648996, -6.861458e-05, -0.00035621173, 3.5265748e-05, 0.00015686722, -0.0001713152, 0.00033373752, 8.404157e-05, -0.00086357095, 0.00021602421, -7.2429255e-05, 9.569822e-05, -8.420683e-05, -2.9961075e-05, 4.6243117e-06, -6.493541e-05, 6.299523e-05, 0.00013288221, 0.00029402616, 5.0544906e-05, -0.0003136146, 0.00033750254, 0.0002800454, -3.8015853e-06, 3.6212045e-05, 0.00023047287, 0.0002828815, -4.11875e-05, -0.00018238752, -0.00015194443, 0.0001319416, 0.0003076804, 0.00028165418, 9.6562326e-05, 0.0003063342, -1.841961e-05, -0.000120460805, 6.735995e-05, -7.450801e-05, -0.00040471076, 0.0006337728, 3.1386768e-05, -0.00021626997, -0.00035160178, -0.00035297874, -0.0002147118, 8.2747414e-05, 9.414145e-05, 0.000103730286, 0.00012985109, 0.00022638695, 0.0001909071, -0.00019095364, 0.00032760474, 0.00013566235, 2.0139576e-05, -5.6749963e-05, 1.6939608e-05, 7.022625e-05, -4.2421594e-05, -4.218084e-05, 0.0001460421, 0.0002484964, 0.00030808686, 9.81784e-05, -0.00014705778, 0.00025984427, -2.6961116e-05, -0.00018164965, -0.00029459986, 7.442081e-05, -0.00018619414, 0.00017489941, 9.5914795e-05, 9.242754e-05, 6.62676e-05, 9.428491e-05, 0.00016599317, -9.70875e-05, -7.760032e-06, -5.0845938e-05, 7.2165356e-05, -9.6038566e-05, -7.9471436e-05, -4.509294e-05, 2.3851724e-05, -7.0612787e-06, 3.9191058e-05, -2.797566e-05, 0.00011649075, -2.141947e-05, 2.9949335e-05, 1.2632594e-05, -6.774696e-05, -7.4555264e-06, -7.063019e-06, 0.0001348974, 9.943617e-05, 8.643877e-05, 4.1792573e-05, 2.3559736e-05, 8.273686e-05, -9.696445e-05, 6.7392044e-05, 7.539693e-05, 1.5808964e-05, -0.00012327301, 0.0003112291, -0.00022608865, -0.00035112968, 5.470467e-05, 2.3370772e-05, 5.2199048e-05, -0.00012246093, 0.00034253066, 1.30098e-05, -0.00020046515, 0.00010404654, 0.00022178185, -9.476827e-05, -9.7023054e-05, 0.00010024123, 0.00017555241, -0.00012302911, -1.1972423e-05, 6.699207e-05, 6.6028755e-05, -4.6098598e-05, 0.00018266, 0.00014543861, 0.00024188973, 3.582306e-05, -7.5431206e-05, 4.9871927e-05, 0.0001271855, -0.00041945628, 1.6194077e-05, -0.00026367925, 6.480353e-05, 6.543253e-05, 0.00014029721, -4.9951395e-05, 6.43117e-05, -4.1840525e-05, -3.0693187e-05, -0.00020585307, -0.0002064256, -3.3023152e-05, 0.00031014672, -0.0003428789, -0.00022108016, -1.79837e-05, 5.0393537e-05, -0.00020953828, -0.00016098225, 1.4254014e-05, 0.00012359748, 4.9222657e-05, -0.00021344262, -0.0003204116, -0.00032195874, -4.2903954e-05, -0.00040062872, 1.1662814e-05, 0.00014374166, -2.8145907e-06, 0.0001110453, 0.0002510909, -0.00047020393, -0.0005984608, -0.00017260332, -0.0002973863, -0.00015573725, -0.00043399743, 0.00013968587, 0.00015614, 4.2756168e-05, -0.00041626664, -0.00037446618, 0.00012715535, 0.0006725945, -0.000591378, -0.00051798986, -7.0298665e-05, -7.369033e-05, -0.00064553093, -0.00046820153, -2.9701703e-06, 0.00046796934, 0.00041266883, -0.00020158678, -0.0006088105, -0.0007312985, -0.00029813385, -0.00067622244, 3.4481036e-05, 0.00025638254, -0.00040520827, 0.00040864444, 0.0005685688, -0.0015284608, 1.3886901e-05, -0.00014606612, -5.9140257e-05, -0.00031322744, -0.0003114911, 3.017654e-06, 0.00015613712, 3.0939013e-05, -6.118323e-05, 0.00014009756, 8.685442e-05, -8.492187e-05, 9.030465e-05, 4.5413566e-05, -1.4016906e-05, -0.00014334676, -2.0928006e-05, -7.0504702e-06, -7.5680095e-05, 0.0001186906, 0.00019893501, 0.00014599769, -2.2459215e-05, 9.956114e-05, 3.474221e-05, 0.00019622858, 5.033964e-05, -1.8541761e-05, -0.00016273819, 0.00015525441, -0.00010669615, -0.0002977874, -0.00017069968, 2.8444458e-05, -0.0002239075, 9.195014e-05, 7.700546e-05, 3.7942515e-05, -1.5082889e-05, -1.0632327e-05, -1.1625618e-05, -0.00022443464, 2.8370983e-05, 0.00021823584, -0.00015351128, -0.00018436371, 3.3798533e-05, 4.677601e-05, -0.00017169116, -0.0001742459, 5.4937864e-05, 6.7948255e-05, 5.2440788e-05, -7.26375e-05, -5.92501e-05, -0.00025451454, -0.00014924904, -0.00025301642, -1.4309702e-05, 4.237465e-05, -0.00012388657, 1.6183429e-05, 0.0002964755, -0.00021960025, -0.00029310482, 5.4152108e-05, -0.00029397002, 7.214845e-05, 2.0176418e-05, -7.6020165e-06, 5.3332482e-05, -5.9137106e-05, -9.431593e-05, -0.0004159217, 3.697788e-05, 0.00039252057, -0.00032792063, -0.00040469944, 6.658389e-05, -1.6390817e-05, -0.0002934728, -0.00038238222, 6.69305e-05, 0.00028904295, 0.00017074413, -0.00014109678, -0.00030426477, -0.00036687, -0.00012577992, -0.00041115715, 8.324339e-06, 0.00017567197, -0.0002241473, 8.355227e-05, 0.000571391, -0.000766511, -5.9851395e-06, 2.4633726e-05, 9.39234e-05, 9.5915544e-05, 8.65191e-05, 4.7338857e-05, -6.2770574e-05, 3.4311623e-05, -3.2916516e-05, -4.241695e-06, -5.1371713e-05, 4.0245624e-05, -4.0275736e-05, 5.8070756e-05, -3.6758927e-05, 6.0730974e-05, 7.863597e-06, 6.746156e-05, 2.2878292e-05, -0.00011612314, -8.2955055e-05, -3.3433644e-05, 3.278865e-05, -5.5202505e-05, -5.2983884e-05, -3.4956163e-05, 1.8728988e-05, -2.4043014e-05, 9.348323e-05, -1.0936541e-05, -6.314998e-05, 0.00017396368, 7.797681e-05, -7.0413036e-05, 0.00011641705, -9.396266e-05, -0.00015474265, 1.432985e-05, -5.3716303e-07, 3.2259268e-05, -2.389486e-05, 0.00017886367, 3.5359313e-05, -0.000114051785, 9.167597e-05, 0.00012522255, -3.0147756e-05, -1.4777766e-05, 5.2250092e-05, 0.00013587523, -5.415386e-05, -3.7740767e-05, -1.829703e-05, 4.208221e-05, 6.0335184e-05, 9.787074e-05, 8.150522e-05, 0.00011907121, 5.446234e-06, -1.05704585e-05, 3.8750975e-05, 4.5186614e-05, -0.00022536355, 0.00013985328, 0.00068519404, 0.00039327177, 0.00029018344, 0.00038350665, 0.00080042426, -0.00023849157, -0.00017725608, -0.00014267548, 0.0004862162, 0.0001440855, -0.00020849607, -0.0006271354, 0.0005244847, 0.00037027564, 0.00015687637, 0.00012961605, 0.00071182096, 0.0003610523, 8.396667e-05, -0.000458552, -0.0005302979, 0.00013953597, 0.0005454171, 0.0007694648, 0.00034261326, 0.0005892133, -8.6880325e-05, -0.00016276965, 0.0005045159, -0.0005790603, -0.00031549585, 0.0015368216}},
    {"bert.encoder.layer.1.attention.output.dense.bias_grad", {-0.0011397324, 0.0014757499, -0.0005726193, -0.005017972, 0.0030308191, 0.0003273218, -0.011744375, 0.014527449, -4.6619567e-05, -0.0045497688, -0.0011790594, 0.0026538621, -0.0024186035, -0.004009099, 0.0016167489, 6.425183e-05, -0.0064762523, 0.0026540833, -0.0013671067, 0.008003639, -0.006513169, -0.001440852, -0.0016650083, -0.0024905687, 0.0058951215, 0.015705124, 0.00040426166, 0.0042844233, 0.008414131, -0.0003567122, -0.002186653, -0.015882818}},
    {"bert.encoder.layer.1.attention.output.LayerNorm.weight_grad", {-0.0021672673, -0.0016109276, 0.0010628186, 0.0025107244, 0.0038688248, 0.0027355477, -6.8801673e-06, -0.00083966437, -0.0029247017, -0.0021775363, 0.0012368922, -0.00032488385, -0.0023277365, -0.00029736018, -0.0027983407, -0.00040734577, 0.0016843915, -0.0001948232, -0.0028797865, -0.00028827548, 0.005119318, -0.004653156, -0.00042266696, -0.0020617633, 0.000754453, 0.0031935493, 0.00034922743, -0.0020532906, -0.0023718257, 0.0014274254, 0.00010224797, 0.0067368974}},
    {"bert.encoder.layer.1.attention.output.LayerNorm.bias_grad", {-0.001147763, 0.0014670056, -0.0005779783, -0.005027523, 0.0030200016, 0.0003156292, -0.0117571745, 0.014526467, -5.6052133e-05, -0.0045612208, -0.0011865477, 0.002645017, -0.002427641, -0.0040167947, 0.0016085722, 5.286414e-05, -0.0064858426, 0.0026464364, -0.001379393, 0.007998802, -0.0065232287, -0.0014519616, -0.0016756504, -0.002497437, 0.0058883857, 0.015702425, 0.00039644394, 0.0042752316, 0.008405314, -0.00036551087, -0.0021947515, -0.015898563}},
    {"bert.encoder.layer.1.intermediate.dense.weight_grad", {-5.5128243e-05, 7.3848525e-05, 5.2141353e-05, 4.713666e-05, 2.345368e-05, -2.3287841e-05, -1.6906077e-05, 9.419234e-05, 5.121202e-06, -0.00014956889, 1.2365042e-05, -1.1539543e-05, -0.00010822825, -5.911247e-06, -5.396717e-05, -7.714204e-05, 4.1025334e-05, -8.381363e-05, 0.00012912617, 5.0467355e-05, 0.00016025457, 2.7755832e-05, -2.1056616e-05, -2.183584e-05, 2.9749031e-05, -0.00010297132, -9.62141e-05, 2.0227784e-05, 1.9137959e-05, 1.5915492e-05, 1.3711192e-05, 1.1941243e-05, 0.000121020996, -7.2884264e-05, 1.2175829e-05, -0.00016244884, 0.00016329897, -9.383203e-06, -7.056612e-05, -0.000117436415, 0.00014389778, 0.0002118875, 0.00016412865, -2.4725008e-05, -7.8643374e-05, -7.8983605e-05, -1.7895098e-05, 8.962311e-05, -0.00020409218, 1.4257717e-05, -0.00018009616, -0.00017758079, -0.0002818625, -2.8469078e-05, 4.539451e-05, 0.00016993092, -4.0279236e-08, 0.0002545369, 0.00030843884, 4.703325e-05, -0.00021169444, 0.00011486614, 0.00010683263, -0.00025052248, 7.018201e-05, -3.1984066e-05, 5.3011822e-06, -0.00020222973, 0.00034626373, 0.000104405204, 7.5427255e-05, -0.00010518796, 0.00023627467, 0.00027202157, 0.00020938444, -0.00012590103, -0.00023852977, -6.41531e-05, 0.000103427126, 0.00023014208, -0.00026219428, 0.00013753034, -0.00034577138, -0.0004926772, -0.0004933564, 0.00015726115, 2.081592e-05, 0.00013234213, 0.0001621755, 0.00045010826, 0.00030521478, -6.017503e-05, -0.0004651889, 0.00022556636, -7.295494e-05, -0.00028353996, 0.00021340259, -0.000226777, -4.5111778e-05, -1.7168586e-05, -0.00027098882, -2.8429065e-05, -8.683929e-05, -9.5157855e-05, -8.069803e-05, 0.0001545201, -2.6115571e-05, 4.535702e-05, 0.00035659625, 0.00013808136, -0.00015075297, -1.680846e-05, 5.295255e-06, 4.4512315e-05, 2.8541855e-05, 0.00010528696, -0.00010165209, -0.0002569604, 0.00011446995, 0.00011784003, -7.4970674e-05, -3.367036e-05, -9.017782e-06, -6.383475e-05, 0.00019376121, -8.2394006e-05, 0.00015307662, -3.3941906e-06, -0.00011191741, -1.3965918e-05, 8.229305e-05, 0.0003000384, -0.00017020317, 8.5779495e-05, 2.939649e-05, 0.00022076412, -0.00018906659, -0.00037678317, 7.477145e-05, 0.00022485372, 2.599028e-05, 7.344632e-05, 4.039231e-05, -0.00037782537, 0.00032808608, -0.0001425678, 0.00024109667, 0.00024441784, 0.00036655122, -0.00021290757, -0.0004110797, -0.00022160214, 1.2491668e-05, -0.00012955694, -0.0004316196, -0.00010540581, 0.00032027173, -0.00013431605, 9.809386e-05, 0.00026008236, 0.00019691483, -0.00016931788, 4.770447e-05, -0.00021951861, -0.00015000446, -0.00016328527, -0.00014735592, 2.4780718e-05, 0.00018102376, 0.00014382205, -0.00014074393, -0.00014480368, 9.2971335e-05, -0.000112886046, -0.00034382858, 0.00024240105, -0.00030079798, -3.830158e-05, -3.2406533e-05, 0.0002021401, -9.159408e-05, 9.957599e-05, 0.0003383457, 7.8850666e-05, -4.1923533e-05, 7.26124e-06, 0.0004621639, 0.0002719268, -0.00011759706, -5.0871336e-06, 0.00013656485, -0.00030699492, 5.198777e-05, -3.660155e-05, -0.0001628864, -0.00017637142, 0.00025463212, 9.518008e-05, 0.00012330609, -0.00030613394, 0.00011839582, 0.00034625153, 0.00018996125, -1.13350425e-05, 0.0001151745, -4.012471e-05, 0.00045082343, 0.00011547757, 4.3079737e-05, 0.00015117094, -0.00040932058, -0.00045594168, -0.00055286696, -9.184128e-05, -8.7606066e-05, 0.00027826388, 7.874995e-05, 0.00027708264, 0.00010555108, -0.00019195814, -0.0001425365, 5.8766498e-05, -0.0001462085, -4.2122123e-05, 9.149577e-06, -3.5694407e-05, -2.02736e-05, 2.569199e-05, -6.8888716e-05, -5.3353237e-05, -2.9283554e-05, -7.759442e-05, -7.233835e-05, 3.4787303e-05, -7.326301e-05, 1.14003815e-05, 7.899223e-05, 4.1326333e-05, -0.00012523565, 2.5017081e-05, -3.2468145e-06, 8.349169e-05, 3.611887e-05, 1.8032293e-05, 5.9623068e-05, 1.3074071e-05, 8.5506435e-05, -3.089829e-05, -6.8726105e-05, 1.707698e-05, 3.2854754e-05, 4.5396027e-05, 8.6361964e-05, -1.764766e-05, -3.7587815e-05, 1.0130597e-05, 0.00015012252, -0.00023520821, 9.4843535e-06, 0.00013750109, -0.00030098332, 5.758744e-06, -5.44039e-05, 2.3183427e-06, -0.00016230182, -1.9969666e-05, 3.032877e-06, 0.0001143342, 0.00023988142, 0.00010802867, -0.00025316406, -0.00016542159, 4.226174e-05, 4.464412e-05, 0.00013449686, 0.00015704737, 9.8842196e-05, -0.00023952423, 2.8398315e-06, -0.00012798299, -8.476918e-05, 6.72367e-05, -2.9492297e-05, 9.118749e-06, 0.00025514825, -8.367232e-05, 0.00017541886, -6.233205e-07, 0.0001299053, -2.590808e-05, 0.00013565389, -0.0002734419, 0.0001269068, -0.000105440566, -0.00010946645, -5.6318364e-05, 5.989214e-05, 7.197936e-05, -3.733485e-05, -0.00011237402, -0.00019789187, -0.00012004194, -0.0003688731, 0.00022676577, -0.00032412566, -3.828904e-05, -6.289911e-05, 0.00015207885, -2.447201e-06, 0.00020614432, 0.00029700334, 5.7540405e-05, -0.00012067667, 6.992046e-05, 0.00055165414, 0.0003243741, -0.00022613598, -2.1063353e-05, 0.0001265322, -0.00033362283, -5.036661e-05, 0.00012342694, 0.00018492989, -3.5407356e-05, -3.8971546e-05, -6.681487e-05, -4.2873544e-05, 0.00012938457, 8.965492e-06, -0.00013210214, -9.8967794e-05, -0.0001394934, -0.00026229187, -7.467958e-05, -0.00035064665, 4.169488e-05, -0.00017014846, -2.937967e-05, 0.00019495042, 0.00017280215, 0.00028311205, 0.00019110882, 0.00014628303, -0.000118406664, -9.8588396e-05, -0.00012373402, 0.00029105207, 0.0002508967, -0.00012892732, -1.8011428e-05, 8.638692e-05, -0.00012518228, -1.3632556e-05, -6.36227e-06, 1.1285287e-05, 7.936632e-05, -1.36366325e-05, 4.2129635e-05, 2.5283309e-05, 5.9196238e-05, -4.728474e-05, -7.8779296e-05, 7.713621e-05, 5.4872802e-05, -3.8217568e-05, 3.0465018e-05, 2.3588536e-05, -0.000112244285, 5.183772e-05, -4.1262934e-05, 6.84973e-05, 7.851022e-06, 2.7186308e-05, -7.977984e-05, -7.766719e-05, -3.0055036e-05, 1.202006e-05, 1.0199659e-05, -9.069369e-05, -4.456232e-05, 2.9570318e-05, -1.2984923e-06, 2.2285787e-05, 4.2705276e-05, -0.000110162175, 0.000116481584, 4.602609e-05, 0.00018707092, -4.7214635e-05, 7.868024e-06, 6.7373185e-05, 9.471158e-05, 5.542843e-06, -0.00017794865, -4.7321755e-05, -6.421662e-05, -0.00014379184, 0.00015531387, -7.736307e-05, -0.00013398178, 9.688109e-05, 1.8471672e-05, 0.00011773205, 2.4266345e-05, 0.00016088717, 8.235906e-05, -6.0579387e-05, -0.000115491486, 9.578353e-05, -8.1432176e-05, -0.0002581281, -3.4521738e-05, 2.6897218e-05, 5.881097e-05, -0.00010348469, 9.316089e-05, 1.110643e-05, -2.0808338e-05, -9.94688e-05, 1.1943847e-06, 7.811569e-06, -3.79013e-05, 7.13495e-05, -8.155926e-05, -1.7730903e-05, 0.00011182585, -3.0942556e-05, -2.7974103e-05, 8.696756e-05, 4.3355652e-05, 5.3023916e-05, 5.531963e-05, 4.50842e-05, 0.0001060914, -5.6731657e-05, -0.00012635608, -0.00013238014, 3.2479144e-05, -3.927521e-06, 2.301028e-05, 4.2462125e-05, 7.728943e-05, -6.939627e-05, -5.74453e-05, -1.456614e-05, 9.631966e-05, -0.00011341556, 2.5913154e-05, 5.073972e-05, 4.0837378e-05, 4.047903e-05, -0.00012004483, 0.00015700854, -2.2323859e-05, -8.13958e-06, -3.119177e-05, 0.00011572149, 4.7889196e-05, 4.4348853e-05, -8.5983236e-05, -0.00017439965, -0.00010100666, -4.4437493e-05, 0.00012811589, -0.00016406714, 1.113971e-06, -8.398788e-05, -8.296861e-05, -0.000101935955, 0.00012347562, 3.093413e-05, 5.329465e-05, 3.916921e-06, 8.27568e-05, 0.00024131627, 0.00014528906, -0.000171593, 4.249274e-05, -5.8525943e-06, -0.00015179794, -8.101737e-05, 7.892652e-05, 7.0520226e-05, 0.00033959394, -2.1353583e-06, 0.0001276921, 9.70009e-05, 7.400284e-06, -0.000108241096, -0.00013124953, 0.00018732365, 0.00011432101, -0.0001003478, 0.00019407304, 6.584729e-05, -0.00033301243, 0.00018286322, 0.00010160534, 5.813941e-05, -0.00016215081, 0.00015452038, -0.00019042184, -0.00030715376, -0.00017261153, 2.2116224e-05, 0.00010147221, -0.00041336313, -0.00021834079, 0.00011176252, 5.25475e-05, 1.1929823e-06, 0.00015112638, -0.00015122387, 0.00018673121, 0.00011626741, 0.00027351012, -7.1433424e-05, -8.5822874e-05, 2.4293971e-05, 0.00021045975, -0.00010901291, -0.0004134563, -3.9730803e-05, 1.9631569e-05, -0.00021006711, -2.6746431e-05, -0.00020155923, -0.00027322205, 0.0001162592, -0.000117775126, 0.00038553006, 0.00015892556, 0.0005963554, 5.2219446e-05, -0.000111959074, -0.00020986614, -5.0841445e-05, -0.00022698082, -0.00022066724, 0.00012562041, 0.00015654012, -3.0481238e-05, -1.0807658e-05, 0.00013930969, -1.1158082e-05, 1.632223e-05, 3.236619e-05, 0.00018851692, -0.00012479046, -2.5230329e-05, -3.89518e-05, 0.00013424615, -0.00013875248, -0.00020943453, 5.2891995e-05, 0.00013512307, 1.748589e-05, 2.0467547e-05, -0.00010886904, -0.0002413151, 9.9777324e-05, -6.757103e-05, 0.00023368138, 0.00011414282, 0.00033767673, -0.00014071094, -0.00012234683, -0.000117023694, -9.377763e-05, -0.00011978826, -0.00019450401, -1.3130939e-05, 0.00019690154, -6.1081584e-05, 0.00010858128, 0.00014025554, -6.123403e-05, 0.00023031347, 0.00013227771, -2.6596774e-05, -0.00016102122, -0.00025694078, -7.717597e-05, 0.00022128593, -5.5735613e-06, -0.0002942895, -0.00027745284, -0.00016529058, -0.0002045155, -7.2183786e-05, -0.0004574315, -2.8760223e-07, -3.2445096e-05, -0.00020589943, 0.00040751384, 0.0003615384, 0.0005734867, 0.00021649782, 0.0002994329, -7.894946e-05, -8.480263e-05, -0.00043484365, -1.6505184e-05, 0.0003511718, 6.744123e-05, 3.6447538e-05, 4.3384396e-05, -2.7352173e-05, -9.260214e-06, 6.5972777e-06, -3.339734e-05, -0.000110101144, 0.00026657537, 9.020185e-05, 0.00018415834, -0.00011087501, 8.38733e-05, 0.000117972166, 0.00017306888, -5.7254816e-05, -0.00021507996, -5.8530815e-05, 0.000251864, 0.0001695904, -5.4446664e-05, 0.00014832543, -0.00031019072, -0.00033846285, -0.0003800114, 9.027492e-05, -9.2076494e-05, 5.081841e-05, 0.00012777222, 0.0003681936, 0.00014403407, -6.0948325e-05, -0.0002865903, 0.00011702956, -0.00013297216, -0.00014015139, 2.40778e-05, -3.2428386e-05, 8.518749e-05, 0.000230359, -2.3373448e-05, 9.2250586e-05, 4.498958e-05, 8.6721986e-05, 1.2113184e-05, -9.3285176e-05, 0.00019026887, 8.956886e-05, -4.592004e-05, 8.3000974e-05, 2.0288655e-05, -0.00025990905, 6.361848e-05, 1.3006342e-05, 1.8151868e-05, -8.812584e-05, 3.6257567e-05, -0.00021763014, -0.00022910495, -0.00012710148, 2.4842795e-05, 0.00013138608, -0.00018681335, -0.00015692406, 2.1771708e-05, 6.096743e-05, 0.00014402113, -1.2234507e-05, 2.9065219e-05, -0.00017603725, 3.329364e-05, 5.527161e-05, 0.00015275525, 0.00020951939, 9.2096154e-05, -6.32821e-05, 0.00012367197, 0.00016606406, 0.00029272443, 4.724441e-05, -1.00736e-06, 4.285896e-05, 0.00021199764, -3.1748605e-05, -3.269126e-05, 8.6886044e-05, -0.00033741296, -0.00029591867, -0.0005012041, -0.00023539009, -0.00020136504, 4.2649067e-06, 0.00011863326, 0.00051863166, 9.859181e-05, -0.00019453245, -0.00019051108, 0.00010533761, 1.8601188e-05, -0.00014640874, -0.00011105523, 5.9665384e-05, 1.9827827e-05, 0.00016389246, -8.516127e-05, -9.640717e-06, -3.8148366e-05, 5.8296828e-05, -9.3031595e-05, -0.00010709933, -3.6102647e-05, 4.7731584e-05, 5.6359536e-06, 7.68693e-05, -0.00012238466, -0.0001600659, 8.1619386e-05, 4.616037e-05, 0.00019182476, 5.768254e-05, 0.00024695692, -8.168778e-06, -4.2464555e-05, -0.00012516437, 3.6140743e-06, -0.00011086982, -0.00022048515, -2.9620573e-05, 0.00010799086, 2.1952059e-05, 5.103244e-05, 5.871014e-05, -1.3481054e-05, -0.00013566205, 6.739507e-05, 0.00021898621, -0.00016931849, 0.0002592097, -8.1116414e-05, 5.371888e-05, -0.00010096986, -1.35295095e-05, 0.00016904481, 0.00025158277, 9.477608e-05, 0.00012491603, -1.0890379e-05, -0.00028067874, 4.0837826e-05, 6.391554e-06, 2.8638002e-05, 0.00013418714, 2.6009073e-05, -0.0003926461, -0.00014916236, -0.00027489263, -6.495247e-05, 0.00020816136, -0.00012261355, -0.00021300807, 0.00011484461, -8.499209e-05, 0.00029183173, 1.7382763e-05, -4.2756357e-05, 3.967501e-05, 0.00017224238, -8.356417e-06, -0.00028132074, -0.00017280932, -0.00022029983, 0.00013196851, -5.7548186e-06, -0.00022372819, -0.00031700154, -9.7275704e-05, 0.0001126123, -1.3657369e-05, -0.00046140054, -2.1210157e-05, -0.0001264039, -0.00011253283, 0.00027435485, 0.00052469503, 0.0004536314, 0.00011460474, 0.00033611272, -9.1608454e-05, -0.00010152974, -0.00036970657, 0.00011207244, 0.00028465176, 0.00013053759, -8.923638e-05, 0.000106934305, -3.7503964e-05, -4.2263408e-05, 0.0001567012, 8.358208e-05, 0.00017421842, 3.0240057e-05, -4.8578077e-08, 1.8352413e-05, 0.0001774502, -4.4424636e-05, -0.00023906898, 5.53249e-05, 3.0775744e-05, -0.00016555336, 4.0418166e-05, -5.438218e-05, -0.00022446478, 7.692968e-05, -5.000205e-05, 0.00021977596, 1.6162001e-05, 0.00033379774, -3.251973e-05, -0.00018408877, -0.00014971299, 3.4759244e-06, -0.00015109027, -0.00032692833, -2.5907375e-05, 5.7811743e-05, 3.8471648e-05, 8.397654e-05, 9.299103e-05, -5.8834743e-05, 3.1844942e-05, -4.3313677e-05, 0.00017384192, 3.065917e-05, 0.000102854996, 0.00016938797, 1.9183928e-05, -1.698102e-05, -0.00010365894, 8.52907e-05, 2.3944933e-05, -1.227369e-05, 5.7083937e-05, 0.0002812036, -0.000100956764, 0.00021795169, 1.3850014e-06, -2.6148924e-05, -0.00014436465, -8.707465e-05, -4.9882092e-05, -0.000271664, -4.329987e-05, 0.00012916741, 5.5328048e-05, -0.00034324807, -0.00020673635, 3.2795837e-05, 2.8598894e-05, -0.00012187243, 0.00018978679, -0.00028223064, 0.00039689455, 2.2706343e-05, -2.6859036e-05, 0.00019083799, -7.899307e-05, 8.440644e-06, 0.00017131577, 0.00020776292, -0.00019483993, -0.00013982019, -0.00016366909, -0.00043374937, -0.0002054568, 4.9659215e-05, 0.00016038107, -9.36106e-05, -2.0391915e-05, 9.577022e-05, -7.0464244e-05, 0.00038773892, 0.0005567363, 3.7597332e-05, -0.00015669574, 4.368581e-05, -0.00023338698, -2.72821e-05, 0.0001319829, -0.0002574413, 0.00010540766, -0.0002940967, 0.00011206976, 4.3218683e-05, 5.030751e-05, -3.900453e-05, -0.00013294772, 0.00014397404, -4.5700395e-05, 8.2751074e-05, -7.852653e-05, 7.1996204e-05, 8.9717556e-05, -3.5998986e-05, -0.00012361388, -0.000114045055, -8.875184e-05, 2.7386184e-05, 0.0002140011, -0.00011221387, 4.192653e-05, -0.00010494096, -0.00013705008, -0.00016184061, 0.00017463631, 0.00010635921, 9.056403e-05, 2.6156229e-05, 9.798121e-05, 0.00018699953, 8.164013e-05, -0.00018432582, 5.181008e-05, -0.00013231522, -9.015e-05, 6.582414e-05, -5.005911e-07, 4.4623383e-05, -5.890857e-05, -0.000115718445, -0.00013129768, -0.00010642254, 7.313617e-05, 3.2254207e-05, -6.0538623e-05, -0.00013536184, -7.275844e-05, 2.0086381e-05, -2.8981653e-05, -0.0002697657, 5.8502814e-05, -0.00010986863, -5.3715463e-05, 0.00014334438, 0.00018794482, 0.00017288486, 9.188324e-05, 0.00017773037, -2.4307421e-06, -8.5386106e-05, -0.00015242801, 0.00015332723, 0.00021819421, 1.3381553e-05, -5.8032492e-05, 6.119653e-05, -7.219882e-05, -4.2237552e-05, -7.620919e-05, -6.1846404e-05, 5.7770892e-05, 6.4874235e-05, 0.00015208576, 5.7561978e-05, -2.2286922e-05, -4.92152e-05, -1.8294379e-05, 0.00015955314, 0.00013697927, 3.145753e-05, 1.1105099e-05, 0.00027643374, -8.137375e-05, 0.0001678376, -2.6950485e-05, -0.000105502695, -5.6602723e-05, -0.00016231966, -0.00014895797, -0.0002060721, 1.430014e-05, 8.147138e-05, 0.00015070172, -0.0001621212, -0.00023175486, 2.9055082e-05, -3.731108e-05, 9.225878e-06, 8.8642504e-05, 3.21213e-05, 1.3486117e-05, 5.3475684e-05, -1.1676294e-05, 5.727775e-05, -6.1281076e-05, -1.2023072e-05, 1.6638554e-05, 2.424567e-05, -7.2165375e-07, 2.0034684e-06, -5.6245106e-05, -9.773978e-05, -5.4165384e-06, -0.00018145562, 1.2587852e-05, -0.00014683935, 2.818073e-05, 2.4635652e-05, -1.3221991e-05, 2.0290749e-05, 7.728432e-05, 6.5820896e-05, -2.466842e-05, 7.906384e-06, 9.4857896e-05, 0.00012926849, 0.000113565984, -0.00011210596, 7.998339e-05, 6.154106e-06, -0.00013639008, -9.280123e-05, 4.6877416e-05, 2.0951094e-05, 0.00035114976, -0.00017076537, 0.00026094695, 0.0001232774, 0.0001412125, -0.00014097907, -0.00023759351, 0.00013431054, 0.00019244084, -5.9906226e-05, 0.000112772424, 0.00020708187, -0.00031197004, 0.00026902562, -2.7414122e-05, 0.00014281082, 9.414177e-06, 0.00020649131, -0.00023823172, -0.00037137215, -0.00026026284, 6.391331e-05, 3.782024e-05, -0.00048389906, -0.00035842456, 0.00016518227, -6.8152076e-05, 6.761464e-05, 0.00026847867, -0.000121171055, 6.702766e-05, 8.117585e-05, 0.00040869304, -0.00015600372, 0.00015351055, 5.847227e-05, 0.00020111898, -0.00023929791, -0.0004043535, 0.00013343785, 0.00022353882, -0.00012828036, 0.00010658271, 5.884628e-05, -0.00042747156, 0.00024175964, -2.030121e-06, 0.00037487003, 0.00010461048, 0.0004979192, -0.00020385174, -0.0004156066, -0.00030579208, -8.867764e-05, -0.00018026412, -0.0004127787, -0.00014246248, 0.00026068112, -0.00017319717, 0.00012630879, 0.0003026856, -1.4990752e-05, -4.072137e-05, -7.056491e-05, -7.959682e-05, 0.00011311956, 1.1406872e-05, -8.039125e-06, -0.00012480734, -3.4747045e-05, 0.00011587848, 1.7673998e-05, 1.0993945e-05, 8.088143e-05, 3.681493e-05, 7.459462e-05, 5.869264e-05, 4.7843245e-05, 3.1701074e-05, -9.647059e-05, -0.0001305068, -0.000113059956, 2.5932253e-05, 2.3078941e-05, 0.00013758035, 5.6505458e-05, 5.4347132e-05, -4.331347e-05, -9.4554955e-05, -7.300875e-06, 1.5361491e-05, -5.2003536e-05, -1.7289516e-06, -8.300245e-05, 8.54442e-05, 2.545833e-05, -5.377905e-05, 0.00014978347, 4.198119e-05, 2.6371745e-06, -5.136019e-06, 7.91008e-05, -3.2480508e-05, 4.246375e-05, -1.875603e-05, -0.0001857595, -8.731298e-05, 8.193954e-05, 3.024379e-05, 1.641989e-05, -6.339057e-05, 1.4543806e-05, -8.138335e-05, -6.2004307e-07, 0.000115316034, -6.9297894e-05, 2.3130719e-05, 6.806541e-05, 9.4335e-06, 5.0866507e-05, -1.6921396e-05, -0.00010657377, 2.0603202e-05, -1.7407603e-05, -3.5610192e-05, 9.997896e-06, -0.00012798162, -0.00013594903, -5.7975336e-05, 0.0001619092, 0.00018554629, 0.00016910711, -0.00018169735, 6.892462e-05, 0.00029571203, 0.0002745598, 7.513189e-05, 0.00010191451, -4.0594023e-05, 0.0005009638, 5.40111e-05, 0.00010263837, 0.00010142187, -0.00030675126, -0.00038876833, -0.00052099436, -0.00020835511, -0.00026057212, 9.3127135e-05, 9.946858e-05, 0.00033945934, -7.910821e-05, -0.00031613084, -9.633509e-05, 9.844969e-05, -3.816172e-05, 2.7031192e-05}},
    {"bert.encoder.layer.1.intermediate.dense.bias_grad", {-0.00016324568, 0.00038648097, 0.00044216675, 0.0001845273, -0.0006862493, 0.0006359244, 0.0002443675, 5.357293e-05, -2.9214825e-05, 0.00057559833, 8.814903e-05, -0.0001630865, -0.00032532794, 5.6387064e-05, 0.00024304456, -0.00053598854, -0.00053898245, -0.00035970673, -5.288151e-05, 0.00014440356, -0.00030204872, 8.37394e-05, -0.0002660363, -0.0002474514, 8.056518e-05, -0.00041897976, -0.000395995, -0.00020708244, 0.00023611462, 0.00017206397, -0.00021606791, 0.0001266443, -0.0007252986, -0.0008507894, 9.917558e-05, -6.937763e-05, 1.3778885e-05}},
    {"bert.encoder.layer.1.output.dense.weight_grad", {2.9001852e-05, 2.9425728e-05, -6.342572e-05, 9.033986e-05, -2.1750227e-05, -5.6968885e-05, 4.099039e-05, -2.3770312e-05, -0.00010048445, -5.960577e-06, -0.00011904312, -2.9566716e-05, -9.3450435e-05, -3.9872528e-05, 4.6684916e-05, 2.3454659e-05, 0.0001231053, 3.5667596e-05, 2.606844e-05, -9.17491e-05, 0.00011109417, -6.329524e-05, 1.4807582e-05, -7.322964e-06, 8.776442e-05, -0.00015629339, 7.1771516e-05, -3.8260194e-05, -3.9251736e-05, -1.8022098e-05, 5.028381e-05, 3.6552847e-05, 2.2855222e-05, 8.277673e-05, 1.7788077e-05, -2.8188226e-05, -3.3858083e-05, -3.4068094e-06, 6.173036e-05, 1.3359883e-05, 4.284365e-05, 1.7783648e-05, -1.9770448e-05, 1.06698135e-05, 1.4025205e-05, 7.2021736e-05, 3.6654936e-05, 2.7765847e-05, -1.281498e-05, 2.6031153e-06, 8.0914424e-07, -1.5340207e-05, 1.6225727e-05, -4.2672207e-05, -2.1906494e-06, -5.1313884e-05, 3.3727807e-05, 5.099612e-05, -8.2021625e-06, 0.0001036125, 7.888594e-05, 6.108299e-06, 5.302547e-05, -7.554289e-05, 8.284465e-05, 6.0104494e-06, -1.3200513e-05, -8.478778e-05, 6.0473565e-05, 3.1378888e-06, -3.8997245e-05, -7.5894525e-07, 2.0373429e-05, 2.243263e-05, -4.0237686e-05, -0.00018436297, -0.00014694362, -8.515821e-05, -0.00016408411, 3.7480542e-05, -8.371175e-05, -1.8867806e-05, -7.375597e-05, -0.00012919425, -4.9144073e-05, -3.3757235e-05, 1.3589782e-05, -5.2572654e-05, 2.4217303e-05, 0.00012253741, 6.0730214e-05, 7.237725e-05, 0.00015324747, 0.0001229937, -3.979276e-05, -9.849726e-05, -0.00016681709, -0.00011780901, 3.378639e-05, -0.0003058042, 0.00014597698, -0.0002660193, -4.5441597e-05, 0.00010672467, 0.00018929954, -0.00021606777, 0.00024341137, 5.0868453e-05, -2.050647e-05, -0.00024767223, 8.961012e-05, 0.00010064732, 9.1444435e-06, 0.0001105113, -6.48677e-05, -6.882104e-05, 3.7052276e-05, -0.00015354181, 1.4252691e-05, -0.0001916289, 4.6571427e-06, -0.00012921501, 2.4455037e-05, -9.735792e-05, -7.749821e-05, 8.0073965e-05, -0.00020543936, 0.00012212421, 0.00015210682, 0.0001418713, -7.737438e-05, -6.39422e-05, 1.6891996e-05, -0.00012349336, 5.5056225e-05, -8.133933e-05, -0.00011194728, 4.8493548e-05, -6.153619e-05, -0.00012636055, -6.118787e-06, 3.7217178e-05, 1.2805927e-05, -2.3010802e-05, -1.1108871e-05, 6.2146223e-06, 0.00011266693, -0.00021804126, -5.5898632e-05, 0.00041048496, 0.00012732677, 0.00017892818, 7.003473e-05, -6.0511167e-05, 3.0643718e-05, 3.867653e-05, -0.00017114618, 0.00023247815, 0.00011065839, -0.0001111925, -0.00010118409, -0.00016879235, 8.6167005e-05, 4.340035e-05, 6.378842e-05, 3.728677e-05, 7.074879e-05, 5.657066e-05, 0.00025992608, -0.0001938604, 0.00034576858, 0.00026467457, 0.00012366139, 2.3941744e-05, -0.00013484286, 0.00023765459, -0.000112269365, 2.1467325e-05, -9.460711e-05, 0.00037821115, -6.448366e-05, 0.00017168948, 0.00010039785, 7.614162e-06, -0.0001480213, 5.533607e-05, 0.00031887065, 0.00017981588, 0.00013123252, 7.2380615e-05, -1.55282e-05, 1.4111803e-05, 2.25524e-05, -9.6793565e-06, 0.00018464036, 8.712469e-05, -2.9771322e-06, -8.847962e-05, -5.468533e-05, 3.180848e-05, -0.00011094646, 2.0950089e-05, 1.4049719e-05, -9.637855e-05, -7.7271165e-05, 0.00014969884, -7.598261e-07, 0.00021905673, 0.0002685044, -2.2648059e-05, 0.00023525883, -0.00023663275, 0.0003242066, -3.472677e-05, -0.00011209821, -0.00022341708, 0.00029005998, -0.00022931899, -6.5908316e-05, 1.4804839e-05, 0.00022987754, -0.00022771246, 0.0002067564, -0.00010897348, 0.000106513326, -4.9153517e-05, -0.00026668745, 9.4271985e-05, -0.00016252889, -6.359903e-05, -0.00021815691, -0.00015227449, -0.00029925889, 0.00010627034, -0.00014645506, -1.5941743e-05, 9.7493954e-05, -0.0004005814, 0.00020255467, 0.00023122705, 9.369302e-05, -0.00021008508, -0.00027817726, 0.00010149748, -0.00036836875, -9.9974146e-05, -0.00012956621, -4.323326e-05, 4.224048e-06, -0.00011057376, -0.00013763033, -0.00014615225, 4.7213707e-05, -0.00022170293, -0.00011505397, -0.00017859788, -7.347755e-05, 0.0002926206, -0.00039608445, -0.000279285, -9.3023904e-05, -0.0002008343, -0.00012421046, 0.00032102564, -5.447425e-05, 0.0002166695, -4.6603045e-06, 0.00039884917, 7.898714e-05, 0.00046591164, -5.9688056e-05, 0.00040944433, 0.00016922271, -0.00022130956, 0.00038682373, -0.00043074496, -0.00037514546, -0.00011588885, 0.00041391936, -3.9697137e-05, -3.4865214e-05, 0.00028624292, -9.456997e-05, 2.2296474e-05, 0.00018491501, -1.13820415e-05, -4.7235473e-05, 0.0002830963, 0.00021073113, 7.9612255e-07, -0.000126364, 0.000273122, 9.517841e-05, -3.729068e-05, -0.0002556705, 0.00061018125, 3.401138e-05, -0.0001261268, -3.2859352e-05, 2.552076e-05, 3.2966564e-05, -3.429901e-05, 8.094879e-05, -2.184023e-05, 0.0002522051, -8.132468e-05, -3.8678998e-05, 5.867715e-05, 2.630971e-05, 0.00014084062, -0.00010429624, 4.3938485e-06, -6.0634084e-05, -6.634191e-05, -0.00022867676, -0.0001229143, -1.9221754e-05, 0.00014234975, -7.761063e-05, -7.4017735e-05, -1.9295361e-05, 0.00013476473, -6.245717e-05, 5.8797923e-05, 0.0001631504, -0.00012222961, -0.00010023991, -9.255237e-05, -0.00013095327, -0.00018114645, -4.1515927e-05, 9.906301e-05, 9.926635e-05, 4.406174e-05, -0.00018939553, -1.4136381e-05, -3.375666e-05, -0.00016342894, 3.0314644e-05, -8.907469e-05, 3.848059e-06, -5.4225904e-05, -0.0001202766, -0.00016444467, 2.3135251e-05, -2.2112365e-05, -1.3356333e-06, 4.628979e-05, -4.0873954e-05, 1.5211468e-05, 9.3697774e-05, 3.227358e-05, -8.455803e-05, -0.00012648258, 8.468915e-05, -0.00019341796, -0.0001575649, -6.3346815e-05, -5.0443403e-05, 0.00010072719, -6.061732e-05, -6.3322106e-05, -8.040792e-06, 8.344624e-05, -9.366522e-05, -4.5960416e-05, -1.3778241e-05, 1.1592414e-05, -2.4561896e-05, -8.0902e-05, -3.485745e-05, 2.1099937e-05, -6.128984e-05, -1.8937626e-05, -0.00013194529, 2.6779284e-05, -5.8278652e-05, -7.039413e-05, -0.00018980751, 4.0558243e-05, -2.5872692e-05, -6.1825616e-05, -1.8923725e-05, -0.00012873691, 9.695209e-05, -3.3960256e-05, 5.2860898e-05, 8.7635955e-05, 0.0002168606, 0.00017557427, -5.653647e-05, -0.00012796723, -1.4498929e-05, -4.2123338e-05, 1.1980276e-05, -0.00017032797, 4.7656682e-05, -0.00014218735, -0.00014141612, 0.000102032536, 7.4570584e-05, -0.000120205135, 0.0001728548, 4.268444e-05, -4.626223e-05, -0.0001480121, -4.978008e-05, -3.0123045e-05, 0.00016524081, 7.8360696e-05, 6.227991e-05, 0.000101709215, -9.3627034e-07, 2.1078338e-05, 4.8355327e-05, 2.225898e-05, 9.254684e-05, 8.19186e-05, -1.0535333e-05, -1.5160749e-05, -2.4042723e-05, 4.5232287e-06, 6.658129e-05, -1.6084057e-05, -5.323695e-05, -6.350382e-05, 1.9581477e-05, 0.000162845, -3.4571115e-06, 0.00018195511, 0.00016047785, 2.6816038e-05, 0.00012242311, -5.5119915e-05, 0.00019955944, -6.1241576e-06, -5.294195e-06, -7.2119925e-05, 0.00022371176, -8.0132915e-05, 7.108116e-05, 4.7499536e-05, 1.4743815e-05, -3.983499e-06, 2.3194561e-05, 1.2052904e-05, 0.00010093582, -1.8615363e-05, -5.8262854e-06, -1.5207884e-05, -8.5885666e-05, 6.0830214e-05, -0.0001789303, -1.3916664e-05, -0.00012401387, 2.3236578e-05, -0.00014018644, -5.76483e-05, 8.7484455e-05, -3.1477222e-05, 0.00014946678, 0.0001235562, 0.000110791036, -4.0591567e-05, 7.346657e-05, 6.3146804e-06, -8.199714e-05, 3.3176493e-05, 3.588053e-05, -0.00018701784, 0.00013734607, -3.127504e-05, -8.316588e-05, 3.5349705e-05, 0.000105696054, 0.00013382237, 8.580563e-07, 0.00013928612, 0.000101831196, -5.6644356e-05, -8.334674e-05, 3.292129e-05, -0.00028540476, -0.000101440266, -0.000100134166, -0.00012578533, 1.436841e-05, -8.74169e-05, -8.945563e-06, -8.9938636e-05, -0.0001822468, -0.00017129249, -1.8705216e-06, -9.802954e-06, 4.861911e-06, 1.988479e-05, -2.373701e-05, 5.2788695e-05, 7.1635004e-05, 9.358335e-05, -9.0311296e-05, -0.00010785222, 1.1127956e-05, -0.00022867475, -0.00016901921, -4.5104178e-05, -0.00020377121, 0.00017218465, -0.00026998395, -6.287722e-05, 1.00686975e-05, 0.0001603289, -0.00018266663, 7.6154705e-05, 1.1333608e-05, 8.663352e-06, -5.7182308e-05, 6.793861e-06, -5.5599153e-06, -0.00016075272, -0.00018347966, -3.537837e-05, -1.8981782e-05, 9.157114e-06, 9.739311e-05, -9.493747e-05, 0.0002216069, -5.648086e-05, 1.8999084e-05, 1.9998128e-05, 0.00012195701, 0.00010183389, -6.085031e-05, 1.7498074e-05, -0.00012837471, -0.00011105989, -9.685461e-05, 5.7116576e-05, -0.00011840705, 6.176394e-05, -5.1331925e-05, -0.00014117814, -5.567195e-05, 9.6704636e-05, -5.710237e-05, -0.00010049094, 0.00011499841, -2.308976e-05, -8.099617e-05, -0.00028215328, 7.658641e-05, -0.00023624781, -0.00015065022, -4.4008808e-05, 0.00020367635, 3.020685e-05, 0.00017644415, 0.00013915333, 0.000102473685, 0.00010177844, -4.6092035e-05, 4.1093874e-05, 3.6688263e-05, 5.556103e-09, 5.467752e-05, 4.0690305e-05, 1.4533639e-06, -5.89424e-05, 2.3230647e-05, -1.6064518e-05, -5.5563884e-05, 3.6063793e-05, 3.1369964e-06, -0.000112485744, -0.00011696977, 9.5901945e-05, 1.5515525e-06, 0.00012340165, 0.0001423137, 3.293444e-05, 0.00014796229, -0.00010570865, 0.00021163971, 3.1900134e-05, -9.117754e-05, -8.711156e-05, 0.00021021166, -0.00014505934, 4.5920948e-05, 5.565498e-05, 0.00021860936, -0.00014049136, 7.740209e-05, -0.00028083858, -2.4540477e-05, -0.000114053604, -0.00017037701, 7.102966e-05, -0.00014209693, -1.7542941e-05, -3.307472e-05, -0.00020487301, -0.00025295667, 6.577419e-05, -4.8734495e-05, 9.7787615e-06, 2.6269125e-05, -0.00014315224, 0.00010735354, 0.00015238783, 6.371481e-05, -7.826646e-05, -0.0001529864, 8.572832e-05, -0.00033315903, -0.0001327626, -9.506012e-05, -0.0001497336, 0.00014219676, -0.0001970914, -5.000811e-05, -3.5025874e-05, 9.26534e-05, -0.00026030434, 5.498117e-05, -0.00016082844, -5.208793e-05, -6.6389307e-06, -5.438131e-05, -1.2484287e-05, 6.964594e-05, 7.650254e-05, -7.10659e-05, 0.00016536818, 2.96806e-05, -1.080288e-05, 2.2703969e-06, 9.140965e-05, 9.24426e-05, 0.00019564368, 5.39687e-05, 0.00013647818, 7.4089476e-05, -0.00010113872, -6.14048e-05, -0.00015604382, -0.000101863654, -1.5580794e-05, 8.5551175e-05, -0.00012959573, 7.257486e-05, 7.721465e-05, 4.44743e-05, -9.5318836e-05, 0.00017142846, -7.0091584e-05, 6.862884e-05, 6.853464e-05, 5.280666e-05, -8.070406e-05, -7.443886e-06, 7.2151596e-07, -3.670762e-05, -5.4462358e-05, 0.0001536259, 4.3514003e-05, 5.2603496e-05, 0.00017550195, 0.00015912206, 0.00011889461, 4.3150358e-05, 6.4110445e-06, 4.4145254e-05, 2.9368326e-05, -1.48579e-05, 8.985536e-05, 3.165294e-05, 4.702096e-05, -9.6799755e-05, -2.7477427e-06, 3.6968333e-06, -7.083094e-05, 1.0176866e-05, -2.5770176e-05, -0.000106489475, -0.00013544282, 2.1994398e-05, 9.18451e-05, 8.6829146e-05, 8.4369865e-05, 1.2317349e-05, 0.0002504155, -0.0001294569, 0.00023993646, -3.907981e-06, -9.988912e-05, -0.00011653423, 0.0002277785, -0.00027589803, 1.3365218e-05, 5.236012e-05, 0.00019285499, -0.00019233307, -0.00015454036, 0.0001160886, -0.00014291325, 1.7104295e-06, 0.000107909684, -2.3979523e-05, 9.785687e-05, -2.9818631e-05, 2.6026994e-05, 0.00013575064, 0.00020662526, -0.00010338725, 0.00010920888, -5.3313164e-05, 3.3295662e-06, 0.0002377794, -6.871663e-05, -0.00012485911, 8.002361e-05, 0.00028884583, 0.00017493925, -0.00018690711, 0.00025261677, 7.62716e-05, 0.00010340832, -9.242012e-05, 2.8127453e-05, -3.083375e-05, 8.407822e-06, 0.00016530699, 2.1313444e-05, 2.629327e-06, 0.00027601686, 0.000120879486, -2.4405337e-05, -0.00032635778, 0.0002744805, 6.3995554e-05, -0.00029551465, 3.4659246e-05, -0.00015257683, -0.00017669574, 9.1099784e-05, -0.00014174457, -3.841977e-05, -6.4293585e-05, -0.0001531145, -0.00018701563, 6.282541e-05, -3.132035e-05, 1.0695741e-05, 2.755719e-05, -0.00019371761, 2.783663e-05, 0.000119593045, 9.939136e-05, -9.841798e-06, -0.00030462263, 0.00013405822, -0.0003334996, -0.00021199703, -0.00013479966, -1.9469611e-05, 8.4526015e-05, -0.00022148472, -8.1036116e-05, 9.1526084e-07, 7.5478696e-05, -0.0002570089, -6.1976057e-06, -0.000171964, -4.4929828e-05, -6.427403e-06, -4.8475587e-05, 7.306229e-05, -0.00025936076, -0.00013499516, -8.57264e-05, -4.1018808e-05, 5.669828e-05, 7.5430195e-05, -5.496406e-05, 0.00030398578, -0.0001657412, 5.8006e-06, 9.568644e-05, 0.00024119676, 0.00021329298, -0.00014304076, -7.615157e-05, -0.00019521912, -0.00013494623, -0.00021955611, -0.00014641533, -0.0003060164, 0.00020166225, -0.0002251714, -0.0002453723, -0.00015748039, 0.00023827719, -6.116643e-05, -4.1175575e-05, 0.0001934526, -0.00012898087, -5.7359404e-05, -0.00034652004, -0.00011131636, -0.00026776397, -0.00015631726, 0.00020660686, 6.912684e-05, 6.470432e-06, -3.9143946e-05, -1.574685e-05, 1.2039798e-05, -3.0195035e-05, -2.1317464e-05, 1.7754842e-06, 2.6098889e-05, -5.075248e-06, -4.9773473e-05, -9.850342e-05, -2.8324457e-06, -4.9642324e-05, -6.1746355e-06, 2.120554e-05, -4.0055593e-06, 6.01644e-05, 5.683347e-05, -3.1453907e-05, -9.112942e-05, 8.1885955e-05, -3.2638823e-06, -4.8992457e-05, 1.6313761e-05, 2.3606488e-05, -4.5051704e-05, 4.6158388e-05, 9.852989e-06, 6.0597117e-06, -6.5842665e-05, 2.373673e-05, 2.516165e-05, -4.450739e-05, -4.1389712e-06, 4.46748e-05, -3.4034383e-07, -2.2712316e-05, -6.698503e-05, -0.00039264307, -0.00013713364, -0.00014710579, -0.00011184614, 1.8093593e-05, -5.0440845e-05, -1.9567997e-05, -7.658357e-05, -0.00020692036, -0.00016861824, -8.450559e-06, 6.391392e-06, 5.5123064e-06, 2.5251953e-05, 7.6640295e-05, 2.9288753e-05, 5.3143434e-05, 0.00014913385, 6.0811944e-05, -0.00014688293, 3.555102e-05, -0.0002676748, -0.0002876609, 1.1844619e-05, -0.00025207305, 0.0003121503, -0.00036414617, -2.7907856e-05, 0.00010068713, 0.00027099333, -0.0002621575, 0.00018355732, 9.822099e-05, 4.8066882e-05, -0.00030428945, 0.00019331308, -9.99363e-05, 0.00031750815, 5.1472776e-05, 8.208122e-05, 0.00013293454, -6.843589e-05, 9.481963e-05, 1.7209893e-05, -5.2854113e-05, 0.00017004028, 0.00021335969, -9.4121875e-05, -3.9697625e-05, -5.7230012e-05, 2.685955e-05, 0.000106204585, 8.977151e-06, -7.617439e-05, 6.5190725e-06, 0.00014500348, 0.00024704836, -0.00018076593, 0.00032453996, 0.0002148513, 0.00013656112, 1.2769917e-05, -0.00011374472, 0.00012180943, 1.0623728e-05, 4.377937e-05, -4.0322397e-05, 0.00024715753, 5.685393e-05, 0.00017773252, 7.703829e-05, -5.924909e-05, 5.3750613e-05, -0.00023543322, 0.00047487183, 2.9391979e-06, 0.00015557707, 0.0004222676, -0.000112283684, 0.0002504248, 0.00013197711, 0.00014841999, 0.00027472462, 0.0004803923, -0.00010436523, 0.000107171254, -5.055227e-07, -0.00013311688, 0.00049495586, -0.000102453036, -0.00029261535, -0.00014127162, 0.00019129502, 0.00053997873, -0.00026299525, 0.00060338684, 0.00036334494, 0.0002884074, 5.3842166e-05, -0.00012633213, 0.00032442866, 0.00015575773, 0.00011763545, -8.7316665e-05, 0.0005160424, 8.842973e-05, 0.00036151975, 0.00016038909, -0.00018163916, 0.00031561826, -1.5602463e-05, -0.00025166632, -0.00025895436, 2.4679413e-05, -0.0001018995, 1.4997703e-08, 0.00013253669, -5.8568123e-05, 0.00015618559, -0.00014891542, -0.00011111172, 1.32296855e-05, 0.00011108585, 5.961212e-05, -4.094287e-05, 0.00019095415, -1.0429834e-05, -7.292055e-05, -7.503273e-05, -1.8224322e-05, -6.0301318e-05, 4.1761257e-05, -0.00017791375, -0.00027170032, 3.2046664e-05, -0.00012902553, 0.00012627554, -0.00014896295, 0.0001007554, 1.2352126e-05, 8.497487e-05, -0.00026984894, 9.000006e-05, -8.286609e-05, -0.000111178815, -0.00021002545, 0.00019465691, -8.615799e-06, 0.0002660051, 7.591903e-05, 0.00012434143, 0.00017787896, -7.109565e-05, 0.00010194317, 2.454538e-05, 8.866696e-05, 0.00016470975, 0.00017682735, -3.986305e-05, 4.366931e-05, 2.008117e-05, -5.133886e-05, 1.7048726e-05, -0.00010709304, -0.0001040287, -0.00013410876, -2.2063341e-05, 0.00013246009, -2.9885367e-05, 0.0003359531, 0.00020803146, 2.5874751e-05, 0.00023638635, -0.00018120783, 0.0002642198, 4.88e-05, -4.9855254e-05, -0.0001737763, 0.0002529852, -0.0001051076, 5.2189178e-05, 3.0899915e-05, 0.00018593595, -3.4478984e-05, -0.0001138863, 0.00038337265, 0.0001260965, 0.00018465982, 0.00033008566, -0.00010959213, 0.0001767248, 0.00013185522, 0.0001313528, 0.00021822366, 0.00025243332, -4.3748845e-05, -6.2047744e-05, 1.7136108e-05, -6.427974e-05, 0.00026228142, -2.9639912e-05, -0.00017562769, -0.00020798783, -4.0575476e-05, 0.00043936618, -9.706382e-05, 0.00040016847, 0.00028567328, 0.00020573847, 0.00016591793, -0.00014981859, 0.00038654084, 0.00013411982, -1.946443e-05, -0.00015141332, 0.0005290451, -0.00018379398, 0.0002129445, 0.00016377994, -1.6271508e-05, 0.00010021558, 3.2211417e-05, 0.000114624505, 0.0001367952, -6.3725114e-05, 4.8583966e-05, 8.892508e-06, -0.00013671057, 5.5351913e-05, -0.00011124765, 0.000107038555, 7.614581e-05, 1.28653655e-05, 1.834822e-05, -3.3898126e-05, 1.8562849e-05, -0.00012482908, -6.399276e-05, 6.5887834e-05, 0.00014346266, 6.5149245e-05, -0.000117287345, 8.1976646e-07, 5.872833e-05, 8.110975e-05, -7.3814736e-05, -6.1918613e-06, -5.3754557e-06, 2.2713873e-05, -7.453685e-05, 0.00010112681, 7.765673e-06, 0.00010507474, 4.7714424e-05, 9.573092e-05, 2.828822e-05, 0.000115365016, -0.00012440002, -2.9996604e-06, -0.00020164967, -5.990082e-05, -0.000111169684, -6.926402e-05, 2.45537e-05, -9.5812604e-05, -6.422407e-05, -6.464809e-05, -4.2736094e-05, -9.876374e-05, -2.2650734e-06, 1.718814e-05, -7.931601e-06, 3.59553e-05, -6.846417e-05, -1.813172e-05, 5.2084273e-05, 0.00012114349, 8.0491445e-05, -0.00012770861, 2.8606131e-05, -0.0001274773, -0.00012629166, -8.312303e-05, -7.263382e-05, 0.00011496557, -0.00016138199, -7.58433e-05, 7.339803e-05, 6.416442e-05, -0.0002024085, 0.00010797051, -6.636913e-05, -4.702322e-05, -0.00012528429, 7.434325e-05, 0.0002979693, -0.00025325536, 5.911023e-05, -6.1966966e-05, -0.00047725096, 0.00015459405, -0.00023120941, -6.77854e-05, -0.00021260635, -0.0002642369, -0.00043401637, 0.00011466579, -0.00024434392, -6.8070396e-05, 0.00014145076, -0.0004216438, 0.00028678804, 0.0002944737, 9.405696e-05, -0.0003428484, -0.00034609067, 0.0001729923, -0.00059418357, -0.00019816513, -0.00016446473, -0.00013259535, -6.7985e-06, -0.00025957768, -0.00015984113, -0.00020989997, 6.077324e-05, -0.00031065417, -0.00021443164, -0.00032697886, -0.00010907731, 0.00024850658, -0.000491977}},
    {"bert.encoder.layer.1.output.dense.bias_grad", {-0.0011901726, 0.001477443, -0.0006302249, -0.005021364, 0.0031095366, 0.00030485436, -0.01178473, 0.014494289, -3.770199e-05, -0.004548219, -0.0012286713, 0.0026756437, -0.0023948709, -0.0039811004, 0.0016045893, 3.1720527e-05, -0.006503141, 0.0026984273, -0.0014175046, 0.007973733, -0.006459796, -0.001457903, -0.0016464435, -0.0025207591, 0.0058921985, 0.015664697, 0.00045160204, 0.0043228776, 0.00841115, -0.00024063974, -0.0021882989, -0.015861215}},
    {"bert.encoder.layer.1.output.LayerNorm.weight_grad", {-0.0021690752, -0.0016190098, 0.0011002307, 0.0025151432, 0.0038982283, 0.002728161, 1.0869531e-05, -0.0008533497, -0.0029092664, -0.0021815712, 0.0012482418, -0.00033267483, -0.0023770332, -0.00033224898, -0.0027822969, -0.00041142182, 0.0016568667, -0.00020069776, -0.0029070692, -0.00029949745, 0.005081255, -0.004628254, -0.0004019529, -0.002047555, 0.000741772, 0.0032168438, 0.0003873832, -0.0019925134, -0.002410084, 0.0014376534, 9.642485e-05, 0.006736472}},
    {"bert.encoder.layer.1.output.LayerNorm.bias_grad", {-0.0011862022, 0.0014805936, -0.0006299383, -0.005024904, 0.0031147983, 0.00030772842, -0.011795064, 0.014506995, -1.9933232e-05, -0.0045520123, -0.0012211839, 0.0026807678, -0.0023873765, -0.00398832, 0.0016177419, 3.909647e-05, -0.006504222, 0.0027102935, -0.0014194261, 0.007970838, -0.006455572, -0.0014543273, -0.0016509148, -0.0025252437, 0.005899768, 0.015685065, 0.00044869113, 0.0043336125, 0.0084200725, -0.00022582212, -0.0021835684, -0.015867764}},
    {"bert.encoder.layer.2.attention.self.query.weight_grad", {3.0797924e-07, -4.3122708e-07, 1.0086804e-07, 4.5199877e-07, 8.3584456e-07, -8.8584017e-07, -8.0723174e-07, 1.1434795e-06, 4.269787e-06, 4.1538433e-07, 1.3004219e-06, -1.056885e-06, -1.8616781e-07, -7.1878156e-07, 1.5310718e-07, 6.9802286e-07, -1.8285119e-06, 1.4789215e-06, -3.3773456e-06, -4.6020687e-06, 7.8971357e-07, 1.3106019e-06, 6.8008696e-08, 5.474206e-07, 8.385328e-07, 9.630064e-07, 4.071249e-06, 1.3900038e-06, -1.83298e-06, -7.230831e-07, -4.6912942e-07, -4.215099e-06, -2.2997375e-07, 6.462689e-08, 6.199947e-08, -5.251195e-07, -3.0688523e-06, -2.5029092e-06, 1.2172773e-06, 1.2437688e-06, -1.4734197e-06, -1.3993059e-06, -7.083299e-07, 8.622186e-07, 1.100388e-06, -8.213389e-08, -2.5829245e-06, -3.8717168e-08, 1.4601536e-06, -1.2307987e-06, 2.3419652e-06, 1.9264885e-06, 3.4263132e-06, -4.687382e-07, 9.987515e-07, -1.1421105e-06, -8.679664e-07, -1.0440925e-07, -7.555418e-07, 2.6394198e-07, 9.0591385e-07, -2.5180574e-07, 3.8178666e-07, 1.1774631e-06, -4.153345e-07, -1.97833e-07, 1.4913121e-07, -7.8186883e-07, 8.960904e-07, 6.633937e-07, 5.0848087e-08, 1.0574507e-06, 7.240802e-07, 1.3363756e-06, -2.2161038e-07, 4.7518174e-07, -3.8038564e-07, 5.714824e-07, -1.5922056e-06, 1.4688111e-06, -8.278899e-07, -1.0399118e-06, -9.900457e-07, -3.4221577e-07, -3.2596895e-06, 1.8944545e-06, -1.956427e-06, 8.524733e-07, 2.1709252e-06, -4.5249368e-07, 1.7351106e-06, -1.0913529e-06, -5.6642244e-07, 1.0756294e-06, -3.3996278e-07, -6.657899e-07, -9.677858e-07, 1.5909859e-06, 9.957402e-07, 2.9158714e-06, 2.6617386e-06, 1.1164617e-06, -3.2790425e-07, -1.454149e-06, -1.9166077e-06, -1.2891326e-07, 2.9783143e-07, 2.2045009e-07, 8.25241e-08, -1.5209453e-06, 4.338419e-06, -1.0913808e-06, -1.3452836e-06, 5.698928e-07, -1.6165045e-06, -1.4243125e-06, -3.891806e-07, -1.9899182e-06, 1.5552871e-06, -1.6981753e-06, -3.2340693e-06, 4.153098e-06, -1.1832229e-06, -3.3030852e-07, -4.1767163e-07, -8.87518e-08, -2.5310186e-07, 8.7988724e-07, 5.562918e-07, 3.9239817e-06, 2.6466016e-06, 4.6033597e-06, -5.967495e-08, -1.3801296e-06, 4.6145527e-08, -1.1516055e-06, -1.7500314e-06, -3.554427e-06, -1.6978175e-06, -1.0561349e-06, -1.2696636e-06, -1.23719e-06, 7.6484974e-07, -5.265899e-07, -3.2929265e-06, 1.7942039e-06, -1.1390631e-06, -3.641786e-07, 1.2459674e-06, 5.056473e-07, 1.123059e-06, -2.278809e-06, -3.487022e-06, 4.3563878e-06, 9.185695e-07, 2.5480108e-06, -1.772373e-06, 1.6430911e-06, -2.0626264e-06, 1.4040935e-06, -8.990254e-08, -2.6789445e-07, -2.4320536e-07, 1.4631823e-07, -4.910779e-07, 4.75064e-07, 4.0747364e-07, -1.148552e-06, -2.3483356e-06, 1.0328787e-06, 1.2796925e-06, 1.1767496e-06, 1.3035982e-07, 9.042053e-07, 3.1116592e-06, -2.704463e-07, 6.115184e-07, 8.538401e-07, 5.334023e-07, -1.0206635e-06, 1.19808705e-08, -2.8764339e-06, 1.5129987e-07, -1.7688737e-06, -2.322516e-06, 2.5392499e-06, -1.9041034e-06, -2.3177536e-06, 1.059451e-06, 3.9847703e-07, -3.6837483e-07, 2.6145094e-06, -8.6138726e-08, 2.275212e-07, 9.972634e-07, -7.34493e-07, 6.675867e-07, 6.96536e-07, 4.7267042e-07, 3.4327047e-07, -8.6670025e-07, -2.506789e-07, -8.021558e-07, -4.112261e-07, -1.1423809e-06, 7.7598713e-07, -1.5331702e-06, -4.770625e-07, -2.8173775e-07, 8.933362e-07, 4.462753e-07, 1.7320898e-06, -1.0462983e-06, 1.4578185e-07, -1.3939153e-06, 3.2064014e-07, 6.349303e-07, -1.9515016e-06, -1.7210051e-07, 1.142489e-06, 2.1134787e-07, 1.4341152e-06, -1.6084226e-07, 1.6856123e-07, 2.1614833e-06, -9.500248e-07, -9.661733e-08, -1.4825716e-06, -1.4815697e-06, -2.076023e-06, -1.0687479e-06, 1.8780972e-07, 2.6909797e-06, 2.6784164e-08, 5.5983384e-07, -1.2623832e-06, -6.519618e-07, 1.0356309e-06, -1.9622216e-06, 9.787817e-07, 7.2603507e-07, -2.3075182e-07, 1.709094e-08, -7.788108e-07, 3.0859354e-07, 3.6752404e-06, -1.6266533e-06, 2.205692e-06, 2.9647467e-06, -2.6925286e-06, 2.0752784e-06, 2.0980547e-06, -4.4087602e-07, -2.1455212e-06, -6.1364983e-07, -2.151121e-06, -6.734123e-08, 7.415558e-07, -3.1817544e-07, 1.6354222e-06, -8.064837e-08, -1.1495277e-06, 2.941604e-08, -5.6994594e-07, 4.6757276e-07, 7.923665e-07, 6.2381633e-07, 4.2330208e-07, 5.842353e-07, 1.0044139e-06, 1.2600036e-06, -1.909448e-07, -1.8842758e-07, 5.7635555e-07, -6.0385736e-07, -9.686651e-07, 1.1195775e-06, -1.8532833e-06, -6.297014e-07, -1.2818098e-06, -1.7335271e-06, 6.0063223e-07, 1.37291405e-08, -9.036559e-07, -1.12301095e-07, 1.2809938e-06, -9.76779e-07, 4.751977e-07, 1.0831228e-06, 5.3231327e-07, -8.88172e-07, 3.143087e-06, -6.0870775e-07, -3.0776832e-07, -3.5811948e-07, 1.1814375e-07, -7.9977684e-07, 3.789337e-07, 4.2463182e-07, 1.1840881e-06, 5.888734e-07, 2.1108378e-06, 1.6646258e-07, -1.6943353e-06, -3.4434743e-07, 1.9852782e-06, -9.189419e-07, -8.48766e-07, 1.205588e-07, -2.1004244e-06, -1.4135755e-06, -1.386495e-06, -2.5956983e-06, 4.684236e-07, 3.3697535e-07, -1.5177004e-07, 1.8183194e-07, 1.2150697e-06, -1.0630015e-06, 1.441267e-06, -1.5436056e-07, -1.7473057e-07, -2.1137609e-07, -1.3842322e-06, 4.523962e-07, 3.1894186e-07, -4.4253315e-07, 3.021635e-07, 1.0327459e-06, -1.9477407e-06, 6.492174e-07, -1.05277586e-07, -1.2396454e-06, 5.484763e-07, -1.4112031e-07, -9.0729554e-07, 2.2352192e-06, -9.0470036e-07, 2.4201875e-06, 1.8234655e-07, 2.460813e-06, 1.4910186e-06, -9.4084737e-07, 1.800521e-07, 1.6825342e-06, -2.9655598e-06, -2.7865385e-06, -9.758202e-08, 1.2511751e-06, -1.5134532e-06, 1.0292486e-06, -3.1954215e-07, -1.0092779e-06, 7.477314e-07, 1.1130662e-07, 7.3505237e-07, 3.1184075e-07, -6.0719884e-07, 9.817901e-07, 9.94614e-08, -1.0491198e-06, 1.0691806e-06, -2.9348385e-07, 4.4371257e-07, 1.1878574e-06, -5.0232705e-07, 2.1977257e-06, -1.5621168e-07, -5.810117e-07, -5.0752607e-07, -1.6874891e-06, -1.1105744e-06, -1.0861319e-06, -8.188224e-07, 4.6644493e-07, -3.7711197e-07, -8.61965e-07, 2.1848823e-06, 1.0557246e-06, -5.402758e-07, -6.0966005e-07, 7.691754e-07, -1.2190748e-06, 6.55377e-07, -1.806554e-07, -8.4797273e-07, 3.2928136e-07, 5.199694e-07, -6.025553e-07, 2.0222464e-07, -7.239594e-07, -1.0765733e-06, -2.9607273e-07, 3.226059e-07, -4.701658e-07, -2.7768325e-08, 9.771862e-07, -1.3176546e-06, -2.110281e-08, 1.6609368e-06, -1.5357149e-06, -1.026965e-06, -8.178861e-07, 1.3383042e-06, -7.304883e-07, 7.143344e-08, 1.325565e-06, 1.4069856e-06, -2.7190458e-07, 1.3631719e-06, 2.5627692e-06, -6.1413414e-07, -6.094851e-07, -7.251527e-07, -7.6547275e-07, 5.812517e-07, -3.2843022e-07, 8.8403294e-07, 2.7843808e-07, -1.293577e-07, 1.0985129e-06, -1.1807567e-06, 1.2750163e-06, 6.161499e-07, 5.167605e-07, 4.4863327e-07, -8.3934346e-08, -5.9562485e-08, -6.85108e-07, 4.1210124e-09, 9.091121e-07, 1.9549053e-07, -1.5704874e-08, -4.7338946e-07, -5.6970936e-07, -8.763067e-07, -5.1361184e-07, -5.0730284e-07, -8.4214076e-07, -1.2948404e-06, -7.032832e-08, 8.360478e-07, -5.125615e-07, -3.746244e-07, -3.3626782e-07, 2.4502096e-06, -1.0604334e-07, -5.525457e-07, 4.470824e-07, 4.331148e-07, -8.0948945e-07, 3.6957842e-06, -1.1056351e-06, 5.0305863e-07, 1.9921951e-07, -2.5865955e-07, -2.5728261e-06, -2.3183043e-06, -1.0743775e-06, 6.0065975e-07, -1.6353479e-07, 1.5161331e-06, -1.3534979e-06, -2.1724709e-06, -6.186659e-07, 6.860047e-07, 1.49119e-06, 1.969307e-06, 2.2262477e-06, -8.655407e-07, 3.7872798e-07, 6.3719847e-07, 3.3961484e-08, -7.488211e-07, -5.1998995e-07, -2.5310717e-07, 9.975175e-07, -1.1022566e-06, -2.2242134e-06, 2.3461835e-06, 1.6091014e-06, -6.796562e-07, -1.3056459e-06, -1.0365342e-06, -2.030748e-06, 7.459389e-07, -1.3783794e-06, -4.067487e-07, 7.3997103e-07, 1.0721747e-06, 7.3784285e-08, -7.7802224e-07, 8.0944415e-07, 2.0221428e-07, -1.785688e-06, 7.540229e-07, -4.0823352e-08, 1.8467352e-06, 2.5613213e-07, 3.8554825e-07, -7.1563204e-07, -6.287465e-07, 1.0399242e-06, 1.296162e-06, 7.827845e-08, -2.021156e-06, -1.6730316e-07, 1.4649813e-06, -7.425493e-08, -4.1153504e-07, 1.0699727e-06, 1.6487839e-08, -2.2020138e-06, -1.1280746e-06, 1.154152e-06, 1.878175e-06, 1.9136644e-06, 6.114672e-07, 7.681593e-07, 1.9970148e-06, -1.1442298e-06, -2.9185803e-06, 1.1292623e-06, 1.8809768e-06, -4.7044878e-08, 1.0851251e-06, 4.0439695e-06, -2.583668e-06, 2.1720932e-06, -3.2041871e-06, -3.8429692e-07, -5.8562887e-07, 4.408224e-09, -4.5057163e-07, -1.9075733e-06, -2.144954e-06, 6.020831e-08, 2.5368065e-06, -1.8510586e-06, -2.041699e-06, 1.3819838e-06, -5.2495963e-08, -9.817394e-07, 1.0103477e-06, -1.2957115e-06, -1.7389466e-06, -1.2979396e-07, 1.8430162e-06, 6.7690195e-08, -4.932602e-07, -6.536676e-08, 2.3005764e-07, -1.3387223e-06, 9.766584e-07, 5.4594364e-07, 2.2335894e-06, 2.7554486e-07, 6.606358e-07, 1.4195488e-06, -1.692023e-06, 7.626584e-07, -9.886104e-07, -2.4984638e-07, -7.1708064e-07, 2.921734e-07, -5.9282814e-07, 5.734541e-07, -1.6502174e-06, -1.3327635e-06, 2.7997944e-06, 1.1163551e-06, -2.648604e-06, 1.209616e-06, 8.8912415e-08, 1.928853e-07, -3.5476072e-07, -3.803583e-06, 4.9473897e-07, -1.1081643e-06, 2.57323e-06, -1.5461301e-06, -8.340125e-07, 8.408513e-07, -1.5201543e-07, -3.2651267e-06, -3.8078517e-06, -2.2372847e-08, 1.5162915e-06, 1.4991658e-06, 4.0331395e-07, 4.803231e-07, -2.592389e-06, 4.9749474e-06, -3.1423651e-06, 5.4212205e-06, 3.3341903e-06, 7.770487e-06, -6.4038255e-07, -1.4546434e-06, -4.926924e-06, -5.78488e-07, -1.1069943e-06, -5.3447848e-06, -2.558591e-08, 4.553044e-06, -1.7140535e-06, -9.856673e-07, 3.1897328e-06, 3.7876978e-07, 1.0371093e-06, -1.5619503e-06, -2.2154413e-06, -5.4380433e-07, 5.3916587e-08, 3.1970248e-07, -2.4104686e-06, 2.6402054e-06, 1.0015004e-06, 1.7374438e-07, -2.0772861e-06, -1.9802371e-06, -1.0459025e-06, 8.901625e-07, 2.6763516e-06, 7.29343e-07, 1.6634436e-06, 8.170227e-09, -1.8739237e-07, -9.862787e-07, 7.138037e-07, -3.2439465e-07, 2.4696851e-06, 2.1432954e-06, -4.424067e-06, -5.3027895e-07, 1.0147847e-06, -4.1160345e-07, 1.0444056e-06, 1.0304948e-06, -1.2897826e-06, 1.2677995e-06, -2.6743157e-06, 5.730925e-07, -2.4219123e-06, 6.4004547e-07, -5.598424e-08, -5.359651e-07, 1.2662731e-06, 8.62273e-07, 1.5322796e-06, 1.2756817e-06, 7.1274775e-07, -1.8988655e-06, -3.98225e-07, -2.3125554e-06, 1.4840067e-06, -1.0827999e-06, 2.2753507e-06, -9.544508e-07, -1.2097124e-06, -1.6302283e-06, 1.2662176e-06, -6.0353267e-07, 1.4109288e-06, -7.6012776e-07, 1.607225e-06, 3.4782895e-06, -7.6582546e-07, -2.101326e-06, -4.4292626e-08, 1.19588e-06, -1.3979723e-06, 2.5107754e-06, 3.7326964e-07, -2.3175958e-06, 1.7298554e-06, -4.217485e-06, -2.2159531e-06, -5.82762e-07, -9.871432e-07, -4.935942e-07, -1.6997839e-06, 5.4591305e-07, -4.3129026e-07, -1.0254727e-06, 1.2155236e-06, -8.900464e-08, -2.4561753e-06, 1.299352e-06, 4.1335165e-06, 1.4736851e-06, 1.0800652e-06, 2.9464145e-06, -1.0260114e-06, 7.474448e-07, 3.5367677e-06, 2.9346434e-06, -4.1794387e-06, -3.7153743e-06, 6.686627e-08, 2.418231e-07, -2.4415652e-07, -1.6864714e-06, 2.5317981e-06, 7.619945e-07, -1.075634e-07, 4.7552493e-07, -1.7320383e-06, -3.3324577e-07, -1.3863084e-06, 2.11803e-07, 8.189868e-07, 2.1271624e-06, 1.5465777e-06, -7.8799246e-07, -7.4592083e-07, 4.5143432e-07, -4.1668505e-07, -3.9815523e-06, 2.7583637e-06, -1.4570396e-06, -5.0685793e-07, -3.8752356e-07, -2.7889232e-07, -3.589363e-08, 6.981843e-07, 8.4309926e-07, -1.961813e-07, -3.0819012e-07, 1.5318446e-07, 2.259027e-06, 7.5367365e-07, -1.2795199e-06, 1.2297928e-06, 9.3946755e-07, -2.086871e-06, -2.383351e-06, -9.860087e-07, 3.4958407e-07, 6.362097e-07, 2.0368323e-06, 1.4400481e-06, 9.227797e-07, 7.9494106e-07, -4.2396084e-07, -5.6005774e-07, 3.9471183e-07, 1.0649868e-06, 4.2559853e-07, -9.943914e-07, 2.8809704e-06, 5.607207e-07, 5.6927956e-07, -2.6681653e-06, -8.2412885e-07, -1.6065492e-06, -1.2305102e-06, 3.5504792e-07, -1.4199865e-06, -1.9657073e-06, -1.9175047e-06, 3.6272834e-06, 1.9444424e-06, -1.1514371e-06, -1.1117483e-07, 9.96565e-08, -3.3047812e-07, 4.7031935e-07, -2.3656264e-06, 2.9964222e-06, 1.7939446e-06, -1.021792e-06, -1.1052579e-06, -2.023627e-06, 6.051071e-07, 3.364115e-06, -2.7574251e-06, -1.5209796e-06, -2.6049033e-06, 5.8655775e-07, -1.2934263e-06, -2.7090575e-06, -7.245023e-08, 2.0616171e-06, 2.2678869e-06, -2.7489289e-06, 4.53431e-06, 3.1110535e-06, 6.1710875e-06, 1.220674e-06, 1.8993544e-06, -2.6871764e-06, -3.4045604e-06, -3.8380454e-06, -5.2699224e-06, 1.9328756e-06, 1.260163e-06, -1.224798e-06, 3.9873532e-07, 2.4440744e-06, -6.0029004e-07, 2.1136957e-06, -3.3938164e-08, 9.02406e-07, -1.8020711e-06, 4.7481856e-07, 9.143495e-09, 1.4227098e-06, -3.2057735e-06, -2.1562082e-06, -2.2258762e-06, 6.5915754e-07, -7.213116e-07, -6.5004593e-07, 3.5977783e-07, -8.386496e-08, 1.5727427e-06, -1.3697602e-06, 3.9755164e-06, 2.4528406e-06, 2.5828465e-06, 4.1335116e-07, 1.6641575e-07, -1.1087175e-06, -1.1070928e-06, -3.89674e-06, -4.170827e-06, 7.3878465e-07, 1.7906846e-06, -4.70949e-07, 1.3035639e-06, 2.6650139e-06, -9.0600224e-07, -1.1814367e-06, 2.6307487e-07, -4.1873557e-07, 2.0254424e-06, 1.7444508e-07, -4.2972712e-07, -7.097783e-07, -1.6629422e-06, 1.12141e-07, 1.4300725e-06, 1.1465668e-06, 6.513244e-07, -9.540369e-07, 8.95516e-07, 5.7012954e-07, 2.1148229e-07, -2.8304344e-06, -1.3096276e-06, 1.37884e-06, -5.469422e-07, -9.241161e-08, 6.502701e-07, -1.4129585e-06, -1.2802864e-06, 3.4900988e-06, 2.6185462e-06, -1.263376e-07, 4.3073084e-07, -1.4982661e-06, -1.4601785e-07, -5.4273926e-07, -1.6349363e-06, 5.6764947e-07, 1.3886715e-07, 8.0844336e-07, -1.9963606e-07, -7.942394e-07, 1.2020229e-06, 3.0281043e-07, -2.6719479e-06, 3.061141e-07, -1.0752541e-06, 9.1291264e-07, 1.2285178e-06, 4.4879908e-08, -1.3064256e-07, -2.2511874e-06, 2.692014e-06, -2.5984372e-07, 3.4948082e-06, 9.231805e-07, 3.2670143e-06, -8.9279916e-07, -3.8812626e-08, -1.4034088e-06, -1.5830433e-06, -1.6471558e-06, -3.5006444e-06, 1.5004708e-06, 2.3909306e-06, -2.6473554e-06, -6.7620095e-07, 1.6264709e-06, -1.2823659e-06, 1.0745887e-06, 4.401083e-07, 2.514909e-07, -4.2985656e-07, 6.393711e-07, 4.1898437e-07, 1.910026e-06, -6.900108e-08, -2.2185416e-06, -1.5047686e-07, 4.98028e-07, -1.6910567e-06, -4.1092034e-07, 3.7611534e-07, 7.56808e-07, 6.322119e-07, -1.5152034e-06, -1.169912e-07, 9.607328e-07, 1.5258242e-07, 1.0433354e-06, -2.392948e-07, -2.098764e-06, -6.4480406e-07, 3.3203685e-07, -3.238607e-08, -1.7222108e-07, 2.3355428e-08, 1.0985856e-06, 2.998533e-07, 1.6366701e-07, -1.1140479e-06, 4.3432013e-07, 8.540046e-07, -1.8075411e-07, 9.131592e-07, 4.599753e-07, 6.732776e-07, 9.84378e-07, 2.2655106e-08, -6.409516e-07, 1.5365933e-07, 4.2959542e-07, -9.3346415e-07, -2.6847138e-07, -5.4261545e-07, -2.3345096e-07, 8.3485355e-07, -7.135451e-07, 8.323491e-07, 4.1397126e-07, 3.7331526e-07, 6.2727753e-07, -1.6547846e-06, -1.748677e-06, -5.046671e-07, 2.6674894e-07, -1.15845815e-07, 6.0085165e-07, 4.1017614e-07, -2.8270705e-07, -1.7188118e-07, -1.787037e-07, -4.956524e-07, 1.5150921e-07, 4.8517e-07, 3.9302915e-07, 7.6136047e-07, -1.6524791e-06, 5.128395e-07, 1.0033325e-06, -1.0398234e-06, 1.0409431e-06, 7.335175e-07, 4.6150558e-07, -5.507795e-07, -3.4325672e-07, 1.2089426e-06, 7.784868e-08, -3.415855e-07, -1.0040104e-08, -4.1133833e-07, -6.5901435e-07, 2.1345652e-06, -5.989814e-07, 1.8310827e-06, -1.2789502e-06, -1.7951129e-06, 4.6330493e-07, -1.6082356e-06, -6.950425e-07, -1.561521e-07, -6.113695e-08, 6.7626144e-07, -2.37633e-07, 5.0309825e-07, 1.163395e-06, -1.3044877e-06, 1.648455e-06, -8.889056e-08, 1.3537347e-06, 8.444297e-07, -1.7949332e-06, -2.2113666e-06, 1.6564248e-06, -1.0883049e-06, -3.8340772e-07, 1.0956476e-06, 1.1035419e-06, 5.412946e-07, -1.4238358e-06, -6.2903763e-07, 1.9105985e-06, 1.1254566e-06, -6.4147355e-07, -1.4085126e-06, -7.5661893e-07, -6.762754e-07, 2.6494536e-07, 1.5555864e-07, -1.8719614e-06, -1.441315e-06, 5.2172726e-07, 8.360072e-07, -8.241732e-07, -4.565179e-08, 1.8659331e-06}},
    {"bert.encoder.layer.2.attention.self.query.bias_grad", {3.0487995e-06, -1.9909503e-06, 1.2684893e-06, 3.9916574e-07, 8.1222004e-07, -1.7129437e-06, 2.2979702e-07, 8.9923003e-07, -8.818338e-07, -3.4934513e-07, -2.8770694e-06, -6.4741016e-08, 1.941914e-06, -3.1740018e-07, -2.1257986e-06, 2.3132952e-06, -3.6579263e-06, -5.4336294e-07, -8.495292e-06, 8.056095e-07, 3.3443453e-06, -2.912373e-06, 2.8027498e-06, -5.7495515e-07, -2.7887816e-06, -2.6810999e-06, 1.3366421e-06, -3.527224e-06, -5.8834706e-07, -1.1094686e-06, -3.522092e-07, -1.2081748e-06}},
    {"bert.encoder.layer.2.attention.self.key.weight_grad", {2.6629367e-08, -1.359518e-06, -1.3960187e-06, -2.1525584e-06, -1.9461015e-06, -1.3771239e-06, 1.5877063e-07, -5.1869755e-08, 2.3023492e-07, -2.2540134e-07, -1.1221554e-06, 2.454742e-07, 2.7692251e-06, -1.1791888e-06, 9.49708e-07, 1.6318866e-06, 2.7197865e-07, -1.4394151e-06, -1.2442457e-07, 2.1658884e-06, 1.0060708e-06, -3.3377597e-07, 2.1213875e-06, 2.5010634e-06, 2.401465e-07, -1.0152256e-06, -6.32838e-07, -5.7045753e-07, 5.365331e-07, -7.472607e-07, 4.1710933e-07, 4.0122603e-07, -9.1615016e-07, 6.488927e-07, -2.804427e-07, -7.78221e-07, 2.8612312e-06, -1.8457525e-06, 1.05418e-06, -1.1896976e-06, 1.0693371e-06, 1.9525617e-06, 1.0048183e-06, 1.2162333e-06, -1.2560087e-06, -1.702934e-06, 4.5079406e-07, -1.2616307e-06, 8.498429e-07, 6.201873e-07, 5.0471124e-07, -1.1905524e-06, -3.7813172e-07, -1.3873184e-06, -1.5271958e-07, -1.5871854e-06, -1.1763568e-06, 1.249945e-06, 1.783674e-06, 1.5696636e-06, -3.3131536e-07, 3.5396948e-07, -1.6739774e-07, -1.5882256e-06, -2.0395596e-06, -9.938881e-07, -1.1885185e-06, -6.435733e-08, 1.8529331e-06, 3.2391497e-07, 1.0846599e-06, -3.071951e-08, 1.396246e-07, 8.9037485e-07, 3.0528108e-07, 2.155796e-07, -1.5860818e-06, 2.8050113e-07, 4.3485218e-07, -4.54278e-07, 1.3948621e-06, 8.738006e-07, 1.3436397e-07, 4.408778e-08, -1.7698068e-06, -6.6967516e-07, 1.5206236e-06, 1.0233558e-06, 1.0913013e-06, -3.083907e-07, 9.1300177e-07, 4.138058e-07, -1.475606e-06, -8.253655e-07, -1.5219642e-07, -1.3784816e-06, 2.0256282e-07, 3.3319072e-06, 2.4511692e-06, 2.9263e-06, 1.9352494e-06, -2.6036219e-07, 1.95813e-06, -4.4695614e-07, 1.1173469e-06, 2.3432362e-06, -6.834397e-09, -3.4913023e-06, -3.961538e-06, 2.3368086e-06, -4.9212733e-08, -2.308258e-06, 6.434631e-07, 4.1266085e-06, -2.9132786e-06, -3.4042107e-06, -1.2599979e-06, -1.3070131e-06, 1.2656534e-06, -1.0279437e-06, -1.4111672e-06, 2.543993e-06, -2.6050084e-06, 5.980273e-07, -1.524833e-06, 1.168902e-06, -4.127337e-06, 1.1558983e-06, -1.7402118e-07, -2.232191e-06, -7.1822507e-07, -1.4296273e-06, -3.331622e-06, 3.0314376e-07, 6.0973485e-07, -2.3685145e-07, -9.965745e-07, -4.585464e-08, -1.0580566e-06, 2.0960506e-07, 1.9246818e-06, -4.825803e-07, 4.7873175e-07, 3.479994e-07, 2.208724e-06, 2.2642381e-07, -3.3713238e-07, 2.3084178e-06, -8.6639766e-08, -7.2483743e-07, 1.0740108e-06, 3.1943478e-06, -4.6684914e-07, -6.474621e-07, 1.177317e-06, 4.2714478e-07, 4.1283218e-07, -2.2944114e-06, 4.3255937e-07, -7.273943e-08, -3.3955555e-06, 1.3685233e-06, 1.5570316e-07, -1.8248301e-06, 2.4577025e-06, 3.878186e-07, 1.061621e-06, 1.750494e-07, 2.3906177e-06, 4.2768255e-07, 8.884936e-07, -1.1226076e-06, 5.852554e-07, -2.187901e-06, 1.5449921e-06, -9.856426e-07, 1.691624e-06, -9.8770194e-08, -1.3342735e-06, 6.776295e-07, -1.7320564e-06, -1.3825962e-06, -7.543519e-07, -1.2559833e-07, 3.482433e-07, -8.815534e-07, 7.302088e-07, 1.2711679e-06, -1.3993761e-06, 3.870889e-07, -1.7728426e-07, 8.5297523e-07, -4.035786e-07, 1.8249183e-06, 1.2092323e-06, 1.850857e-06, 2.5303148e-06, -2.0094278e-06, 2.3755506e-06, 9.896928e-08, 9.523444e-08, 2.9229932e-06, -2.5656445e-07, -1.4376021e-06, -4.201259e-06, 3.1459645e-06, 8.396885e-07, -8.578086e-07, -2.1912557e-07, 2.377783e-06, -2.1166345e-06, -3.458497e-06, -2.3625805e-06, -1.3073522e-06, 3.732865e-06, -1.1548366e-08, 8.126891e-07, 2.3644914e-06, -2.559435e-06, -2.5972167e-07, -1.7982716e-06, 2.0197697e-06, -4.1467874e-06, -7.951275e-07, 2.5182004e-07, -7.8008776e-07, -2.0394748e-06, -1.2356084e-06, -1.3229926e-06, 3.6877805e-07, -2.0301404e-06, -4.914823e-07, 3.7332293e-06, -1.3530296e-06, 8.0501707e-07, -4.3288506e-07, 1.030759e-06, -2.8942713e-06, -1.6524842e-06, 1.2275184e-06, -1.1064471e-06, -1.9836007e-06, 2.728776e-06, 1.3455401e-06, 2.7925944e-06, 8.954591e-07, -6.435193e-07, 1.0381563e-06, 5.5433384e-07, -3.112391e-06, 1.0403994e-06, 1.1946661e-06, -1.2051994e-07, -2.8590168e-07, 3.5938147e-06, -1.1160266e-06, 1.0163831e-07, 1.525161e-06, 4.6815367e-07, -1.2476942e-06, 1.0555535e-06, -8.393051e-07, -2.4408974e-08, 1.3037712e-07, 4.204468e-07, 4.8466944e-07, -1.4246673e-07, 2.646714e-07, 6.8498025e-07, -1.3361013e-06, 5.107396e-07, 2.4944117e-07, -6.299377e-07, -5.88183e-07, -2.2804225e-07, -1.3592388e-07, 5.5846726e-07, -5.2515443e-08, -5.419229e-07, -1.6777875e-06, -8.938263e-07, -1.6886425e-07, 5.511928e-07, 1.4031652e-07, 3.2852995e-07, 8.3470496e-07, -2.2510955e-07, 4.2304575e-07, -6.0380137e-07, 3.8432574e-08, 5.7726743e-07, -7.025106e-09, -1.6631308e-08, -2.9296444e-07, 5.1188624e-07, -1.15729186e-07, -2.33471e-06, -6.137604e-07, -9.815317e-07, -6.181664e-08, 4.996931e-07, 5.140045e-07, 8.249149e-07, 7.596175e-08, -6.5979195e-09, -2.5680438e-07, -7.7230936e-08, 1.4113722e-06, -1.1755254e-07, 2.8070227e-07, 1.3126335e-06, 3.23696e-07, -6.2530654e-07, 5.1509467e-08, -1.994888e-07, -6.580812e-07, 7.644114e-07, -6.2201434e-07, -3.1007056e-07, 7.146319e-07, -1.4817729e-06, 1.3931034e-06, 6.0574894e-07, -6.3359454e-07, 6.537983e-07, -1.1227319e-06, -1.0155824e-06, 9.835394e-07, 1.8611888e-06, -1.0920908e-06, 1.3271196e-07, -1.01348746e-07, -1.5934467e-07, -1.3023928e-06, 9.551498e-08, -1.7393592e-07, -4.2817632e-07, -1.6898396e-06, -7.753753e-07, 1.1225733e-06, 1.1959353e-06, -4.1374327e-07, 1.3095591e-06, -3.596647e-08, 8.230126e-07, -4.16867e-07, -6.3264207e-07, -6.301446e-07, -1.0537828e-07, 1.3686065e-06, 4.5930827e-07, 2.0632602e-07, -3.6133645e-07, 5.7458374e-07, 9.493869e-08, 1.8519517e-06, 5.408603e-08, -6.4449625e-07, -6.2817344e-07, -6.6202495e-07, 9.0320174e-07, 5.636547e-07, -5.632376e-07, -7.5402454e-08, -1.0971279e-06, 6.469016e-07, -7.6728156e-08, -1.2696071e-06, -1.2773347e-07, 1.191431e-07, -1.0569607e-06, -3.821007e-07, -7.744298e-07, 6.67781e-08, 1.586335e-06, 1.0679674e-06, 5.474695e-07, 1.3719583e-06, -1.0593068e-06, -1.1928254e-06, 5.5684575e-07, 1.122385e-06, -1.6691929e-06, 5.1248213e-07, -1.4986428e-07, 6.621224e-07, 8.77302e-07, 1.6332619e-08, -1.8041588e-07, -1.3226816e-07, -1.0355423e-06, 3.0970625e-07, 2.1897702e-06, -6.656318e-08, -2.8913885e-07, -1.141763e-06, -9.3570645e-07, 2.9841934e-07, -1.4402653e-07, 2.2749303e-07, -6.4402934e-07, -6.074969e-07, -8.9545944e-07, 2.9988905e-07, 2.0029283e-07, -1.4212411e-07, 1.3220322e-06, 1.1239773e-06, 3.8509708e-07, -5.875897e-07, -4.4510833e-07, -4.7239013e-07, -2.2051928e-07, 5.192938e-07, -1.9656775e-07, -1.4515498e-07, -1.3737059e-07, 1.4671249e-06, 9.575476e-07, -2.0906416e-06, 1.0186192e-06, -1.5102613e-06, -9.735053e-07, -8.339874e-07, 2.8901643e-06, 1.9473563e-07, 5.155772e-07, -1.0864005e-06, 1.3684055e-06, -2.0729892e-06, 8.35962e-07, 4.7201706e-07, 2.8052557e-07, -1.4767173e-06, -1.0948354e-06, 2.936074e-08, 8.049633e-07, -7.8881243e-07, 4.85232e-07, 8.8159986e-08, -5.8158093e-07, 2.3458297e-07, -1.3127058e-06, 1.758518e-07, 7.419389e-07, 8.74495e-07, -5.5409777e-07, 1.0786416e-06, 1.3938609e-06, -7.307696e-07, -1.4640052e-06, 5.413169e-07, -1.4812811e-06, 1.2297326e-06, 1.0641779e-06, -3.1909383e-07, -7.425219e-07, 5.2138154e-07, -7.531247e-08, 1.5517915e-07, 1.2861326e-06, 9.001174e-07, -1.174289e-07, -1.2004014e-07, -5.3499747e-09, 1.9767085e-06, 9.4412746e-07, -1.5750496e-06, -4.45542e-07, 8.572218e-07, -1.5425069e-06, -8.253731e-07, -1.5938255e-08, -4.5325368e-07, 7.452717e-07, 2.2660979e-07, -5.838854e-07, -1.1672265e-06, -1.3875307e-07, -3.8506208e-08, -4.5469383e-07, 4.2981605e-07, 3.3552527e-07, -2.2624777e-06, 1.4432705e-06, -6.549155e-07, 5.2745787e-07, 6.824305e-07, -1.1483221e-06, -3.445395e-07, -2.5528752e-08, 7.7453444e-07, 6.53684e-07, -1.514823e-06, 4.269525e-07, 1.0847195e-06, 1.1808908e-08, -2.0175323e-06, 4.1739713e-07, 1.4322699e-06, 3.552694e-07, 1.17777994e-07, -2.8543428e-07, -9.967176e-07, -3.4205362e-07, -5.162456e-07, -2.2243245e-07, 2.5281918e-07, 3.45296e-07, 5.5082126e-07, 9.3903407e-07, 4.832579e-09, 5.451766e-07, 5.5137053e-07, 2.5466966e-06, 5.0566705e-08, 5.671302e-07, 1.10474424e-07, 9.100061e-07, -2.5995998e-06, 3.032513e-06, 1.5599666e-08, 1.5570934e-06, -3.5517287e-06, -2.2433853e-06, 2.757373e-07, -6.3675024e-08, -1.7025753e-06, 3.2691478e-06, 2.7141232e-06, -1.2511678e-06, -1.0112587e-06, -1.1783295e-06, -2.0321347e-06, -1.8282194e-06, 1.7146486e-06, -1.1979398e-06, -1.9870727e-07, -2.326646e-08, 2.424659e-06, 5.641428e-07, -1.6416666e-06, 1.0831201e-07, -4.3374382e-07, 3.8158294e-07, -7.194561e-08, 1.7616393e-06, 2.0096202e-06, 3.4699578e-06, -4.7654297e-07, -2.3041446e-06, -1.7667888e-06, 1.8614941e-06, 6.7145294e-07, 2.4044712e-06, 5.546943e-07, -2.3696728e-06, -1.109998e-06, -2.0692012e-06, -1.1631143e-06, -6.625572e-07, -9.079235e-07, 3.6482052e-07, -2.8390522e-07, 2.8177283e-07, -7.1060606e-07, -3.594558e-06, -3.1159527e-06, -2.9734615e-06, 4.6530827e-06, 4.8055904e-07, 1.2215312e-06, 9.083712e-07, 1.946917e-06, 3.1917136e-07, 2.8923378e-07, 9.565634e-07, -1.4890778e-06, -2.1506085e-06, 4.3165468e-07, -2.6081455e-06, 1.0570448e-06, 1.1831295e-06, 1.6559253e-06, -5.9683834e-06, 7.89326e-08, -2.9032392e-06, 3.024635e-06, 1.916404e-06, 2.0099196e-06, -3.425412e-07, 1.0949007e-06, -9.176229e-08, 1.1171537e-06, 1.3187416e-06, 1.377807e-06, -3.5460323e-07, 1.5489206e-06, 1.9282634e-06, -4.2380702e-07, 9.175663e-07, -1.2093084e-06, -8.435918e-08, -1.977349e-06, 2.478949e-07, -1.4579359e-06, -1.050558e-06, 2.4622324e-07, -2.7045248e-06, -3.5431557e-07, -3.5818439e-06, -2.626524e-08, 2.2887466e-06, 7.313462e-07, 1.5022979e-06, 3.009428e-06, -5.7898205e-06, -3.5056195e-07, -1.7594667e-06, 3.9938886e-06, 1.8946456e-06, 2.6905755e-07, -1.1529093e-07, 7.4532653e-07, -1.7412973e-06, -2.097337e-06, 1.538599e-06, 1.6296908e-06, -1.2511057e-06, 1.8490889e-06, 1.7079652e-06, -1.8736162e-06, 1.2189912e-06, 7.7343367e-07, -4.473931e-07, -1.8795016e-06, -4.5114447e-07, 1.4624273e-06, -5.417366e-07, 3.50286e-07, -1.1774586e-06, -1.4399659e-06, -3.2896937e-06, 1.0823854e-07, 5.7049135e-07, -9.90547e-07, -1.5762677e-06, -4.3679566e-07, 1.8365989e-06, -1.1124213e-06, 6.584957e-07, 7.1095855e-07, 1.8829904e-06, -3.482272e-07, -1.2492271e-06, 7.2415435e-07, -9.827819e-07, -7.512578e-07, 8.1698033e-07, -1.8182328e-07, -6.964405e-07, 5.7477683e-07, 1.0694395e-06, 1.9193649e-06, 2.3375967e-06, 3.170722e-07, -8.365875e-07, 2.9951536e-07, 4.0946336e-08, 1.9135687e-06, -4.877379e-07, -2.2395609e-07, 3.3553683e-06, 5.9761004e-07, 1.2594444e-07, 2.77385e-06, 2.2393242e-06, -1.5253352e-07, 5.315642e-07, -2.407344e-07, -4.15546e-06, 2.7925562e-06, -1.5161008e-06, 2.475331e-06, -1.1725352e-06, 1.3207884e-06, -8.824249e-07, -6.601915e-07, -1.2671983e-06, 9.927338e-07, 9.063597e-07, 3.0861267e-07, 1.0809546e-06, 6.87401e-07, -3.7017312e-06, -5.8260043e-06, -5.1206157e-06, 1.6165619e-06, 1.0249356e-06, -2.0411464e-06, 1.6517445e-06, 6.073809e-07, 9.763572e-07, 6.712993e-07, 1.6341444e-07, 9.994593e-07, -1.6134686e-07, 8.926435e-07, 1.997819e-06, 7.4006795e-07, 1.221723e-06, 2.3491269e-07, -2.8831464e-06, 1.3625998e-06, -6.402458e-08, 1.5457941e-06, -1.1150934e-06, 4.8529984e-07, 2.7688958e-07, -4.4265613e-07, -8.4670717e-07, 7.0373966e-07, 5.030461e-07, -5.7449665e-07, -6.7341e-07, 4.700397e-07, -1.7731807e-06, -3.590902e-06, -1.8339377e-06, 1.4504938e-06, 1.900835e-07, -4.480144e-08, -2.5595656e-07, 8.302893e-07, -2.0362297e-07, 3.9496655e-07, 2.5256893e-06, 2.754185e-06, 2.583412e-06, 2.0768493e-06, -2.3865587e-07, -1.3021844e-06, -2.4922863e-06, 5.3135926e-07, 2.6476853e-06, -1.1659693e-06, 1.01832114e-07, -2.0833013e-06, -1.6547955e-07, 7.2680484e-07, -9.429443e-07, 8.515911e-07, -2.170766e-06, -3.0202645e-07, -2.232807e-06, -1.7299292e-06, 1.6611034e-06, -8.898033e-07, 7.786224e-09, -1.0601603e-06, -4.5438014e-07, 2.245262e-06, -3.1437016e-06, -1.7767492e-06, 1.0490284e-06, 2.2904774e-06, -2.1590602e-06, 2.2571405e-06, 6.484816e-07, 8.5774957e-07, 1.4578394e-07, 1.3665524e-06, -1.7049047e-08, 2.2878107e-06, 2.076841e-06, 8.1184584e-07, -1.6709845e-06, -1.7307872e-07, -1.0420489e-06, -1.1264717e-06, -3.2310825e-06, 1.9381978e-06, -1.5297494e-06, 7.76713e-07, -1.799261e-06, 1.4720003e-06, 2.7768147e-06, -5.5485334e-08, -1.6120421e-07, 3.6940844e-07, 1.3641088e-06, -1.1586079e-06, -1.629417e-07, -1.5511353e-06, 2.3717992e-07, 1.1325036e-06, -1.56253e-06, -1.7310318e-06, 4.4978393e-07, -1.7391151e-06, -3.5164453e-07, -6.3068654e-07, -1.0360408e-06, 1.5683466e-07, -7.759609e-07, 4.1638478e-07, 1.3058543e-06, 6.817619e-07, -7.2414764e-07, -1.6588885e-07, -1.0664899e-06, -3.545392e-08, -4.7888756e-07, 8.575195e-07, -1.2022733e-06, 1.6182487e-07, 9.08736e-08, 2.919818e-07, 8.9911856e-07, 5.472513e-07, -4.701949e-07, 5.424041e-07, 1.9578226e-06, 1.0664934e-06, 1.3087808e-06, -7.4997547e-07, -3.0638373e-07, -4.9434647e-07, -6.0714065e-08, -6.9040124e-07, 5.577091e-08, -1.1011871e-06, 5.072495e-07, -5.9143963e-07, 5.8024574e-07, -1.0343259e-06, -1.8643013e-06, -1.5676867e-06, -1.0470949e-06, -5.0539853e-07, 1.9908357e-06, -1.1522023e-06, 1.4085376e-06, -3.199813e-07, 2.1208516e-06, -1.5139822e-06, 1.5024925e-06, 2.0765793e-07, 4.1516026e-07, -6.46546e-07, -1.3127209e-06, -1.1008535e-06, 1.7644492e-06, -1.5720954e-06, -3.5394373e-07, 1.5601477e-06, -3.8697038e-07, 1.2103922e-06, 8.4400364e-07, 3.4127288e-07, 8.999269e-08, -3.254262e-07, 2.1063639e-07, 5.410431e-07, 6.7767553e-07, -7.42675e-08, -1.2768149e-07, -4.506208e-08, 1.8016732e-06, -1.6673544e-06, -2.324549e-06, -7.3178114e-07, 1.967242e-06, -6.4785206e-07, 2.2692857e-06, 8.7313293e-07, 2.006727e-06, -1.7194791e-06, 1.1153558e-06, -9.928664e-07, 7.0227844e-07, 4.32612e-07, -2.2779723e-06, -1.8050472e-06, 5.6456867e-07, -1.4805676e-06, -1.444858e-06, -7.991355e-07, -7.283519e-07, 2.263695e-06, -2.546513e-07, -3.925248e-07, -2.7232235e-07, 1.6113281e-06, -5.890543e-07, 2.0898053e-06, -4.288055e-07, 2.5349084e-07, -7.251113e-07, 6.300731e-07, -2.1433513e-07, 5.443911e-07, 1.7681203e-06, 4.5744025e-07, -9.897392e-07, 5.2803244e-07, -5.679862e-07, -3.2121346e-08, 1.5089853e-07, -3.4639115e-07, -1.1959401e-06, -6.4945687e-07, 8.748998e-07, 4.1243504e-07, 3.5536289e-07, 1.6914944e-08, -1.3224538e-06, 8.627214e-07, 6.293632e-07, -7.261177e-07, 9.782625e-07, 4.505992e-07, -6.497049e-07, -4.5908965e-07, -5.500488e-07, 2.4417088e-07, -6.7460445e-07, 3.7473e-07, 7.8404014e-07, 2.2134651e-07, 5.3610773e-07, 1.5034103e-06, -4.909655e-07, -1.6599781e-06, -4.1155045e-06, 2.1998158e-06, 3.5245205e-06, -2.1197638e-06, 4.8227696e-07, 6.1520694e-08, -6.7580237e-07, -6.2662866e-07, -3.1007535e-06, 6.086952e-07, -2.1962983e-06, -2.3177677e-06, -1.0719119e-06, 7.0008906e-07, 2.642692e-06, 9.147341e-07, 1.3518089e-06, 7.992974e-07, 2.5727277e-06, -3.4247572e-07, -3.8764356e-06, -1.4456484e-06, 4.5990067e-08, 3.839994e-06, 7.2110953e-07, 5.29757e-07, -1.16179265e-07, -2.803434e-07, -7.1918544e-07, -6.366233e-08, 6.3389035e-07, 1.3053946e-07, 4.235683e-06, -1.4093808e-06, -2.7742317e-06, 2.1538426e-06, -1.1199292e-06, 3.8381484e-07, -3.8904344e-07, 2.3355153e-07, 6.148148e-07, -1.4704187e-06, 1.6909013e-06, 2.1095498e-06, 1.5526359e-06, 5.6739236e-07, -1.669711e-06, 2.8047268e-07, -2.0118548e-06, -1.7847352e-06, -2.4820763e-06, 4.0913477e-07, 1.993842e-06, 1.4674554e-06, 1.0904693e-06, -2.1435735e-06, 4.150045e-08, -1.1551648e-06, 1.4072798e-06, -4.772461e-07, 1.3095804e-06, 1.3112857e-06, 5.825639e-07, 8.7905056e-07, 6.256299e-07, -1.0329906e-06, -2.5953084e-06, 7.3115166e-07, 1.28214e-06, 1.288973e-06, -1.1544586e-06, 4.781932e-07, 7.0440606e-08, -2.0387034e-09, -2.988385e-07, 1.693915e-06, 8.981799e-07, -1.2013109e-06, 1.5112334e-08, -7.105072e-07, -3.8881767e-06, -3.2525752e-06, -3.1496884e-06, 2.6336818e-06, 2.9585551e-06, 1.8117645e-06, 9.8617754e-08, -1.9407576e-06, 1.3463972e-07, -5.0685594e-07}},
    {"bert.encoder.layer.2.attention.self.key.bias_grad", {-9.2370556e-14, -2.842171e-14, 1.9895197e-13, 8.526513e-14, -1.4210855e-13, 1.6520119e-13, 2.842171e-13, -1.7053026e-13, -2.2737368e-13, 2.1316282e-14, -1.4210855e-13, -2.4868996e-13, 3.5527137e-15, -2.842171e-14, 2.842171e-14, -9.947598e-14, 9.2370556e-14, -1.4210855e-13, 4.973799e-14, 1.3500312e-13, 1.7053026e-13, 4.902745e-13, -3.5527137e-14, 1.0835777e-13, 9.947598e-14, 1.9184654e-13, 1.2079227e-13, -7.1054274e-14, -4.2632564e-14, -1.2789769e-13, 8.526513e-14, -5.684342e-14}},
    {"bert.encoder.layer.2.attention.self.value.weight_grad", {0.00035877962, 4.423311e-05, 0.00018431307, -0.00064930046, -0.00033278723, -0.0006681113, -0.00021591326, 0.0003422479, 0.00056984235, 1.4614765e-05, -0.00025157726, -0.00021068905, 0.0002635145, -0.00046015365, -0.00015979983, 0.00048635548, 0.00023281513, -0.00017628408, 5.3594358e-05, 7.601941e-05, 0.00032042392, 2.7210603e-05, 0.00020080766, -0.00044989426, -0.00012508448, -3.9754486e-05, -1.0906107e-05, 0.0006455306, 0.00012861972, 1.8007562e-05, 0.0004212575, -0.0006379317, -2.1524513e-05, 9.7581906e-05, 4.419492e-05, 0.00026454052, 0.00018721692, 2.9637618e-05, -0.00012869258, 0.00012032484, -2.7682925e-05, -0.00015883746, 0.00014308507, 5.7047695e-05, -5.331656e-05, 7.3135234e-05, 0.00011115765, -0.000299102, 0.00020487989, -1.5246081e-05, 0.00017221902, -0.00010414158, 3.0114057e-05, -0.00016848654, -0.00025512438, 6.543177e-05, 7.972639e-06, -0.00018806387, -0.0003772922, 9.617373e-05, 0.00026087996, -0.0001892344, -5.2808366e-05, 7.396008e-05, -0.00016663263, 0.0001804412, -3.2539585e-05, 0.00037617795, 0.00031504413, 0.00016532493, 2.8837474e-06, -1.8515166e-05, -0.0002836296, -0.00018957851, 8.866127e-05, 0.00013913994, -0.0002086408, 0.00025061224, 7.7219076e-05, -0.00052265334, 0.00013127054, 8.1761245e-05, 0.0002703863, -6.967733e-05, 0.0001216706, -0.00012456896, -0.0001794468, 0.0001508353, 7.139986e-05, -0.00025252777, -0.0005371782, -0.000108254935, 0.00023826571, -0.00014188876, -0.0001484618, 0.00032310025, -8.85397e-05, 2.3832803e-05, 5.91803e-05, 0.0004886475, 0.0004887495, 0.00037846115, -8.874189e-05, 6.476616e-05, -0.00019644202, -0.00015547937, 0.00028477734, 8.146892e-05, -0.00029980612, 0.0002937201, 0.00011603548, -0.0004994978, 3.6055266e-05, -0.000104578634, 9.913169e-05, -6.2897016e-05, -0.00035733802, -0.000105622625, -0.00044759494, 0.00027013727, 0.0001247624, -0.00013260811, -0.00028431395, -3.3253036e-05, 0.00023079607, -0.00019890482, -0.00020421403, 0.00021931053, 0.00040474263, -9.646827e-05, 0.00011931937, -0.00068769837, -0.0005056361, -0.0006485907, -0.00015497283, 0.0002671757, 0.0006041298, 9.9961006e-05, -0.00026657552, -0.0002523206, 0.0003671842, -0.0004978619, -0.00016973005, 0.000680195, 6.099979e-05, -0.00015328969, -0.0001186827, 0.00010606443, 0.00022147673, 0.00010050876, 0.00026424727, -0.0004240319, -0.00012779696, 0.00013577545, 0.00034532807, 0.000544338, -3.084929e-05, 7.43685e-05, 0.00036853153, -0.0006298417, -6.1298255e-05, 0.00010468273, -0.00012091331, 0.000117879514, -8.1182145e-05, -0.0001070654, 8.242894e-05, -9.506739e-06, -9.0920825e-05, -9.282467e-05, -7.222401e-05, 6.564746e-05, 8.355204e-05, 4.0869876e-05, 1.9711859e-05, -0.00016989412, 6.6111774e-05, 0.00020088081, 0.00017430255, -0.00011910884, 0.0004030696, -6.6483844e-05, 4.4483568e-05, -9.439073e-05, -5.1236904e-05, -0.000115586365, -0.0002883024, -8.951174e-05, 8.967507e-05, -1.8525201e-05, -3.1629894e-05, 0.0001873095, 0.00016904506, -0.00013169351, 7.662771e-05, -0.000522636, -0.00029122553, -0.0001644092, -5.1211042e-05, -1.0356605e-05, 0.00029318494, 0.00024883577, -0.00014419634, -0.00016874251, 0.00014383395, -0.0003028337, -0.00010078796, 0.0005888162, -0.0001309514, -0.00016075994, -0.00029010477, 0.00015142467, -0.00020027539, 0.00016427152, 0.0002774198, -0.000116951414, -3.5288143e-05, 0.00024787273, 0.00059220486, 0.0001614556, -0.0002937961, 0.00019924909, 0.0001855073, -0.00038352975, 2.702969e-05, -0.00037071624, 1.1892498e-05, -0.00038403837, -0.00010740493, 0.0003343902, 0.00012528447, -0.0002541464, 0.00011154607, 0.00044908508, 3.7532827e-05, -0.00013057077, -1.7218586e-05, -9.9005105e-05, -9.238141e-05, 0.00067861716, -0.0005210324, -0.00022020414, -0.00061683764, 0.00022334882, -0.00078190234, 0.00033453785, 0.00019474253, 0.000112080044, 5.7913872e-05, 0.0005271528, 0.001121955, -0.0002456775, -0.0005979222, 0.0003218825, 1.9872645e-05, -0.00024980592, -8.185714e-05, -0.0003051494, -5.8368505e-06, 0.00030451478, 0.00032857366, 0.0006594059, 4.8575486e-05, -0.00016362204, -0.00013982743, 0.0001781235, 0.0003390757, 6.2599283e-06, -0.00025230076, 0.00023660301, 7.886333e-05, -4.96185e-06, -0.00039344473, -0.00016174681, -0.00039305203, 3.3432767e-05, -0.0008920135, 0.00012483563, -0.00032344388, 0.00037284446, 0.00015110536, 0.00029343204, 0.0006078533, -0.00032056015, -0.00027509395, 5.883997e-05, -0.00022727095, 0.00011784302, 2.4720346e-05, 0.000101611484, 4.6395704e-05, -0.00022209292, -0.00014942736, -0.00025188882, -5.9973718e-05, 6.6449145e-05, 0.00014520397, -5.4195207e-06, -9.905045e-05, -3.7260605e-05, 0.00013104336, -0.00017024789, -4.557357e-06, 0.00014097903, 0.00018356516, 7.5708094e-06, 6.736157e-05, 1.0324379e-05, 0.00023846376, -4.060469e-05, 0.00014122193, -0.000120082885, -6.204665e-05, -0.00011558986, -0.00015207352, 0.00014757297, 2.8495444e-05, -1.5107555e-06, 0.000157364, -0.00014651618, 0.00017053864, -0.00032041193, 5.662319e-07, -0.0007039198, -0.00039905217, -6.2783976e-05, 0.00013217884, -0.00015893189, 0.0002738579, 0.00041918614, -0.0001802965, -0.00017593228, 0.00018365745, -0.00029261733, -0.00018874483, 0.00090390566, -0.0004542073, -0.00019222975, -0.00053543085, 0.00026217842, -0.00036628434, 0.00034609647, 0.00044628754, -0.00015244019, -5.7457073e-05, 0.0005140134, 0.0011208265, -6.785903e-05, -0.0005842778, 0.00035543158, 0.0001957252, -0.00043157302, -0.00011034372, 0.00030332914, 3.7825887e-06, 0.00017659669, 0.00012601355, -0.00014676024, -4.7407066e-05, 9.243636e-05, -0.00012517715, -0.00024445218, -4.9954655e-05, 0.00010187886, -5.8821668e-05, 6.947019e-05, 3.6528487e-05, -0.0004311198, 0.00036226326, 0.00014269493, 0.00043074833, -0.00011794636, 0.00048570527, -0.0001827129, -4.3313576e-05, -6.774065e-05, -2.033883e-05, -0.00036239435, -0.00079002284, 0.00012283864, 0.0003416241, -0.0001799879, 1.965534e-05, 0.00016292809, -8.9402914e-05, 6.3768166e-05, -4.7115827e-06, 0.00030630757, 0.00018428123, 0.00015170407, -2.3361164e-05, 1.8069044e-05, -0.00012596478, -0.00011554255, 0.00012429562, 6.564556e-05, -0.000102154794, 0.0001446352, 9.5914445e-05, -0.00031530348, 0.00010761015, 6.858523e-05, 0.00011725205, -0.00012916556, -1.2793549e-05, -0.000115885436, -0.00019579289, 0.0001058787, 2.0856967e-05, -0.000107373846, -0.00028818805, -4.0901945e-05, 0.00013339505, -9.8294084e-05, -0.00012306715, 0.00017970477, 0.000110694134, -0.00012533549, 3.4432298e-05, -0.00026554486, -7.32356e-05, 8.458055e-06, -2.6161115e-05, -1.2506884e-05, 0.00014059176, 0.00018753439, -3.394255e-05, -8.316479e-05, 1.8639908e-05, -0.00013230076, -6.680731e-05, 0.00032394376, -0.00018765718, -0.00014779215, -0.00022302105, 0.000102117396, -0.00024868624, 0.00013182595, 8.7981214e-05, -5.2842322e-05, 2.645003e-06, 0.00019377423, 0.00046163346, 3.9694936e-05, -0.00019208658, 0.00015344251, 9.451845e-05, -0.00022084259, 0.00011333405, -0.000105778025, 9.5624804e-05, -0.00020453792, -2.4796755e-05, -3.155e-05, -5.8737285e-05, 3.168627e-05, 0.00012752839, 7.995488e-05, -7.29128e-06, -8.13692e-05, -3.6701226e-06, -8.286927e-05, -6.5373584e-05, 0.00024063447, -9.428128e-05, -0.00019417802, -0.00015855915, 0.00016486987, -0.00026167947, 9.433888e-05, 3.34979e-05, 1.9694296e-05, 3.1224743e-05, 0.000114538794, 0.00031484864, 0.000113800066, -7.734733e-05, 2.0399175e-05, 6.714454e-05, -0.00021110103, 0.00019873999, -0.00032846976, -1.3435416e-05, -0.0009581967, -0.00058226497, -0.00020372693, 0.00019139356, -0.00021714754, 0.00032815692, 0.00049651385, -0.000330406, -0.00021169572, 0.00026121776, -0.00040057124, -0.00027751335, 0.0011267953, -0.0005000468, -0.00017155969, -0.0005769364, 0.00034548278, -0.00024720147, 0.00043267247, 0.0006811562, -0.0002547392, -8.5871055e-05, 0.0005841811, 0.0012644768, -5.8270824e-05, -0.0007034503, 0.00045266876, 0.0002892618, -0.000531214, -0.000106142295, -0.00012547811, -7.4119e-05, -9.840464e-05, 3.138808e-05, 0.0002807722, 0.00015638255, -0.00024264373, -0.00014570986, 0.00023286119, -2.1512421e-06, 1.7348886e-05, -7.670804e-05, 7.660638e-05, -4.978183e-05, 0.00019731514, -0.00033394113, -5.561883e-05, -0.00024580324, 0.00012754819, -0.00033007647, 0.00018704482, 0.00014432565, 0.000100302175, 5.283212e-05, 0.00023826177, 0.00048463576, -0.00031430853, -0.00030049504, 0.00018319134, -7.5594544e-05, 6.615996e-05, -3.9781753e-05, -8.311496e-06, -6.079714e-05, 0.00012908145, 3.344187e-05, 7.629049e-05, 7.354056e-05, -3.3298234e-05, -0.00010943753, -4.301747e-05, 8.31431e-06, 2.8262855e-05, -2.6949243e-05, 0.00010609137, 5.0842727e-06, -0.00011982308, -6.5243104e-05, 5.4656488e-05, 2.3437036e-05, -1.37653915e-05, 2.6007343e-05, 1.0185974e-05, -2.9966692e-05, 5.3823707e-05, 2.0598967e-05, -7.069241e-06, -2.6907112e-05, -0.00010593566, -4.2435254e-06, -2.1025715e-05, -8.777999e-05, 0.00015453568, 4.1526044e-05, 4.1800147e-05, 3.09908e-05, -8.0816135e-05, -1.7971033e-05, -0.000115590774, -2.7572807e-05, 5.629247e-05, 4.2812164e-05, -4.8943588e-05, -4.3272117e-05, 7.3939495e-06, 6.381336e-06, -4.7576024e-05, -4.373369e-05, 9.804747e-06, 7.7838595e-05, -1.923729e-05, 8.785253e-05, 3.067482e-05, 0.00012253341, -1.4318578e-05, 3.280827e-05, -8.029798e-05, -2.120566e-05, -5.9552734e-05, -0.00010482241, 0.00010404752, 6.772843e-05, -4.1813924e-05, 9.538958e-05, -8.914998e-05, -8.51763e-05, 0.00023812402, -3.8487775e-05, 0.00053946633, 0.00024431114, -4.002608e-05, -8.7751905e-05, 0.00018005294, -0.00013699016, -0.0003582898, 0.00012829424, 0.00013400197, -7.3057185e-05, 0.00018486685, 0.00013791384, -0.00068169134, 0.00036862027, 0.0002065107, 0.00046122877, -0.00027439313, 0.00043569464, -0.00028480394, -0.00036651283, 4.393801e-06, -4.818602e-07, -0.0004060771, -0.0009190611, 9.407235e-05, 0.0004909621, -0.0002948642, -0.00010180571, 0.00030095645, -0.0001918232, 0.00017440462, -2.8192298e-05, 0.00065322284, 0.0004070686, 0.00027994954, -3.070687e-05, 3.8574093e-05, -0.00030294168, -0.00029751178, 0.00021879694, 0.00015214302, -0.00024029711, 0.0003366451, 0.00016159815, -0.00073382666, 0.00023648179, 0.00015348817, 0.0003410213, -0.00022789404, 6.744375e-05, -0.00022706452, -0.00039924015, 0.00021213986, 7.261657e-05, -0.00028392335, -0.0007300068, -6.7546294e-05, 0.00035774207, -0.00026677773, -0.0002585894, 0.00042300552, -0.00021280022, 0.00039837265, -4.379908e-05, 0.0009607543, 0.00050907384, 0.00014832438, -0.00018976443, 0.00022433279, -0.0003234473, -0.00047698602, 0.0002812138, 0.00021617259, -0.00019354268, 0.0003501483, 0.00031226515, -0.0011553529, 0.00053685455, 0.00026834384, 0.0006256596, -0.00045943924, 0.00043620524, -0.00047385742, -0.00063861033, 0.00016853207, 3.3163662e-05, -0.0006106512, -0.0013468345, 4.5042885e-05, 0.00070450077, -0.00038832054, -0.00028940671, 0.0005838524, 0.00021942603, 3.2170497e-05, 0.00014138427, -0.00032181345, -0.00020253517, -0.00041106774, -0.00018867083, 0.00024355944, 0.00037111124, -3.512112e-05, -8.9614914e-05, -0.00012410135, 0.00018748284, -0.00029704804, -5.0430186e-05, 0.0002660513, 0.0002201922, -0.00012302386, 4.5842375e-05, 2.8006169e-05, 0.00016778834, -4.6558347e-05, 4.5799126e-05, -0.0002296675, -7.894919e-05, -6.0406957e-05, -5.624408e-05, 0.0004316347, 0.00013779112, -7.194249e-05, 0.00024446278, -0.00039550703, 0.0001445551, -1.2898194e-05, 6.1123894e-05, -0.00024602198, -0.00021792308, -0.00029521185, -3.68631e-05, 0.00010753135, 0.00020192654, -2.6283644e-05, -0.00013341698, -9.37993e-05, 0.0001398512, -0.00016677663, -8.45384e-05, 0.00021320306, 7.630289e-05, -2.8791896e-05, 8.513798e-06, 5.698115e-05, 0.00016318774, 2.4777126e-05, 0.0001325783, -0.00015391326, -4.9269758e-05, 1.945661e-05, 3.8226226e-05, 0.00023406703, 2.3025605e-05, -1.421267e-05, 0.00012783302, -0.00021321986, 0.0002011322, -0.00030926443, 3.2131087e-05, -0.0006086463, -0.00041139836, -9.9975085e-05, 5.352082e-05, -8.044397e-05, 0.0003504879, 0.00036632133, -0.0001358114, -0.0001996768, 0.00020288919, -0.00033460773, -0.00015712454, 0.000824965, -0.00032946872, -0.00014422524, -0.00048648045, 0.00017951055, -0.00033621019, 0.00027837863, 0.00032772718, -0.00015472382, -5.112987e-05, 0.0004446099, 0.00096823665, 4.4104014e-05, -0.00050130894, 0.00030077167, 0.0002233599, -0.0004576505, -0.00017887466, -0.00014411048, -3.4617628e-05, 0.00016461847, 0.00017244412, 0.00047290427, 0.00013247451, -0.0002489128, -0.00021322118, 0.00015491986, 0.00013411696, 2.09281e-05, -0.00019279857, 0.00019806052, 2.9300127e-05, -1.26374e-05, -0.00025061646, 4.378971e-06, -0.0002415277, 3.3565764e-05, -0.00050963653, 0.00012273635, -4.379281e-05, 0.00028110927, 0.000116012685, 0.00019477023, 0.00032786393, -0.00033146967, -0.00027152465, 0.00011941955, -0.0001952723, 0.00018938919, -4.298108e-05, 0.00026715358, 2.5623309e-05, 0.00034238523, 0.00020593802, -0.00012298246, -0.0001791429, 0.00022848848, 1.0511799e-05, -0.00022873381, 8.549087e-05, 6.228762e-05, -2.6355743e-05, 3.513011e-05, 0.00013826357, -0.0005182271, 0.0003978339, 0.00013130161, 0.00037771635, -0.00028177342, 0.0003801978, -0.00026529818, -0.00031180735, -8.10723e-05, -1.9959134e-05, -0.00038688947, -0.00083769497, 0.00020839446, 0.00044891206, -0.00016593843, -5.4451716e-06, 0.00012867305, 1.0499518e-05, 7.9177335e-05, -2.6286814e-06, 2.2230142e-06, 5.181347e-06, -0.00011081182, 2.0456073e-05, 3.5079116e-05, -5.139317e-05, -7.965965e-05, -8.838003e-05, 7.068001e-06, -1.0767281e-05, 4.347084e-05, -2.9169994e-05, -0.00011245625, 4.0818537e-05, 2.6422269e-05, 0.0001121991, 1.1323436e-05, 0.00018657476, -1.49433945e-05, 5.178867e-05, -4.2902553e-05, -7.3949404e-06, -7.1525654e-05, -0.0001728356, 4.6320016e-05, 9.877778e-05, -1.3320665e-05, -3.1569693e-05, 6.237954e-05, 4.4833803e-05, -2.6491332e-06, 1.6470305e-05, 8.7277935e-05, 5.8674977e-05, 1.9097315e-05, -0.00010302106, 0.00010294454, 0.00010223413, -2.9080486e-05, 0.000108206834, 2.2250597e-06, -4.5098063e-06, -5.533162e-05, 6.144492e-05, -5.865848e-05, 8.948694e-05, 2.3974906e-06, 2.9347515e-05, -0.00011110258, -1.9641171e-05, -7.7886616e-05, -0.00017638301, -2.4372142e-05, -1.205216e-05, -6.883946e-05, -9.4643416e-05, 8.790401e-05, 6.0063037e-05, -4.179198e-05, 7.5520686e-05, -6.816626e-05, -0.0001514734, 0.00020181303, -0.00012314352, 7.3030154e-05, -8.6425425e-06, -9.114662e-05, 0.00010588317, -0.00011251185, -0.00024696044, -8.587228e-05, -0.0001374821, 0.00013488918, -1.2419449e-05, 9.550448e-05, 3.521382e-06, -0.0002510546, 8.405323e-05, 0.00019863609, 0.00024305057, -1.89226e-05, 0.00047135964, -5.973018e-05, 0.00017054418, -2.7771992e-05, -1.7328211e-05, -0.00019939609, -0.00039121546, -0.00018789941, 8.4744206e-05, 2.07819e-05, -3.214326e-05, 0.00026730253, -6.107186e-05, 7.1367285e-05, -2.5300233e-05, 0.0003127357, 0.00018361508, 9.66084e-05, 2.4836088e-05, 4.4223845e-05, -0.00016330059, -0.00016266371, 6.6052075e-05, 6.2284504e-05, -9.256302e-05, 0.0001971903, 2.9846859e-05, -0.0003589727, 5.2178053e-05, 4.4766355e-05, 0.00018198136, -7.732365e-05, 6.120783e-05, -7.428952e-05, -0.00018595213, 5.342214e-05, 3.0574272e-05, -9.832739e-05, -0.00032091624, -1.3513105e-05, 0.00022404254, -0.00015732943, -0.00016382446, 0.00021841528, 0.00014635052, -0.00038948574, -2.0904663e-06, -0.0007535867, -0.00045106374, 1.4970214e-05, 0.00018102836, -0.00021245057, 0.00031141422, 0.0004976609, -0.00017898767, -0.00023262495, 0.00019825123, -0.0003052589, -0.0002026403, 0.0010267531, -0.00052990776, -0.0001845925, -0.00065732346, 0.00027155352, -0.00051096035, 0.00041847443, 0.0004844377, -0.000112553666, -3.400098e-05, 0.00060520397, 0.0012876691, -0.000111041474, -0.0007228122, 0.00041125432, 0.00017899313, -0.0004426336}},
    {"bert.encoder.layer.2.attention.self.value.bias_grad", {0.0003954346, -0.00043550288, -0.00060858275, -0.00054137176, 0.0006461505, -0.00026378734, 0.00072767906, 0.0010362313, 0.00020991603, 6.695021e-05, 0.0012137591, -0.00063058967, -0.00039420841, 0.00046924257, 0.00032564675, 0.0014903108, 0.00041307523, -0.00012340827, -1.43513025e-05, -0.0009680072, -0.00092137384, -0.0015539571, 0.0001606179, 0.0001689919, 0.0010659616, 0.00015283986, -0.0007700434, -0.000151404, -0.00010701551, -0.00029617528, -0.00045138018, 0.0013757006}},
    {"bert.encoder.layer.2.attention.output.dense.weight_grad", {-5.533125e-06, 1.1882099e-05, 5.6295372e-05, 1.8196157e-05, -1.1868811e-05, -2.476579e-05, 6.564158e-05, -1.060805e-05, 0.000110930996, 2.177251e-05, -5.965645e-05, 5.5004395e-05, 7.402688e-05, -5.2350926e-05, 1.8302158e-05, 5.3998803e-05, 8.8293884e-05, 7.686419e-05, 4.971718e-05, -1.079907e-05, -0.000107316395, -1.1373109e-07, 6.471588e-05, 7.6452845e-05, 2.0058935e-05, 9.708826e-05, 1.14203085e-05, 3.2796175e-05, -0.00013121402, -0.00017421873, 2.2401508e-05, 2.9466202e-05, 8.1926526e-05, -2.5960917e-05, 6.8057845e-05, 3.1127145e-06, 0.000118568154, -7.2588505e-06, -7.9345926e-05, -1.5858808e-05, 3.531794e-05, 3.605764e-05, -1.09096245e-05, -7.397497e-05, -5.2172883e-05, -1.9083156e-05, -5.4665297e-06, -5.057061e-05, -4.638457e-05, 2.0897535e-07, -0.000102435835, 3.834963e-06, -5.071431e-05, -4.909038e-05, -3.021074e-05, 7.543545e-06, -4.9839116e-05, -0.000108811786, -3.772877e-05, -2.2352386e-05, 0.00010854329, -3.7423117e-06, -2.976705e-05, -1.8265291e-05, -7.419715e-05, 3.0630013e-05, -0.0004425916, -0.00016981241, -9.81749e-05, -6.74645e-05, 4.756085e-05, 0.00013631526, -6.195368e-05, 9.513439e-05, 0.00014336561, 0.00014385529, 9.4779796e-05, 0.00016357015, -0.00013581359, -0.00019096147, 0.0002411777, -2.0466321e-05, 0.00015477884, -0.00017500657, -2.8507286e-05, -0.00011255286, -4.6939113e-05, -5.9118138e-05, 0.0002958037, 0.00014801473, 4.75221e-06, -8.9606554e-05, -0.0002740171, 0.00015251394, 5.8413436e-05, -2.19615e-05, -0.00020108037, 7.777038e-05, -0.00018794995, 7.352317e-05, -0.0003510077, -7.290711e-05, 0.00015389494, -9.7227085e-06, 9.009378e-07, -0.00016833415, -3.123733e-05, 0.00014943004, 0.00027856388, -0.00018554428, 0.00020072954, 0.00025304264, 1.9277013e-06, -3.256443e-05, 0.00015846979, 0.00019050782, -4.874393e-05, 0.00018371444, 0.00025044993, 4.7912043e-05, 4.013288e-05, 0.00032973444, 0.000117793235, 0.00018793502, -0.0003064986, -0.00019490355, 0.0001312416, 5.1032725e-06, 0.00045385907, -0.000101305995, 0.00045000762, 0.0001304433, 0.00038852438, -0.00017664196, -0.00038869827, -5.7993882e-05, 0.0004625101, 0.00028705964, -0.0003021405, -0.00035031265, 7.8488985e-05, -0.00017768377, 0.0001563697, 3.3398475e-05, 1.630507e-05, 0.00030777507, -0.0003281532, 0.00021249801, -0.000489763, -4.508509e-05, 0.00013435929, 0.00022519028, -0.0001232365, -0.00025196647, -0.00013949077, -9.2889306e-05, 0.00022519726, -0.00031743725, -3.5854468e-05, -9.5697746e-05, 0.00017171091, -6.0754737e-05, 0.00043953, 0.000174778, 0.0001648643, -6.138972e-05, -0.0002183322, -0.00014992313, 0.00023981182, -1.454962e-05, -0.00018270325, -0.00024035048, 2.7902877e-05, -0.00024496025, 0.00025095316, 0.00023249144, -0.00019488149, 7.362427e-05, -0.00031450286, 0.00028825662, -0.00022297945, 8.623706e-05, 0.00020594899, 0.00011313996, -0.00031587767, -0.00016186744, -3.9684965e-05, 0.00010716942, 0.00022631793, -0.00032726483, -2.6918064e-05, -2.908688e-05, -0.0006066487, 0.00018048378, -0.00045641453, 0.0001148688, -0.000905959, -7.1205126e-05, 0.00040715473, -1.9904992e-05, -0.00021854372, -0.0004697668, 7.88917e-05, 0.00038894612, 0.00049896055, -0.00031179786, 0.00037278852, 0.0005614094, -2.7838118e-05, -0.00018166652, 0.00040220996, 0.00034405367, 0.00012792551, 0.00045699766, 0.0005057781, -1.728536e-05, 3.969832e-05, 0.0007259152, 0.00031020102, 0.00042303832, -0.0006583803, -0.00023031948, 0.0002344591, 5.8427457e-05, 0.0005396661, -0.00016483631, 0.00020533122, -0.00023382547, 0.0008717373, 0.00019006632, -0.00033861696, 0.00012630678, -0.000106196014, 0.0004614548, 0.00010301182, -0.0003402044, -0.000673892, 0.00055303087, -0.0006270173, -0.0008275898, -1.4568154e-05, 1.5409161e-05, -0.0002654994, -0.00053828384, 0.00021060037, -0.0005112456, -0.0008123813, -0.00013593605, 9.568772e-05, -0.00082933204, -0.00030199962, -0.0005610965, 0.0008024862, 0.00074010756, -0.00025786227, -7.283845e-05, -0.00016384057, 1.2767567e-05, 0.00010285493, -1.6446439e-06, -4.54745e-05, 0.00016224475, 0.00011981088, -6.214895e-05, -0.00019684086, -0.00014516612, 0.000105629966, 4.238176e-05, -0.000212399, 6.9977745e-05, -4.7990743e-05, 2.4264884e-05, -0.00012453481, -0.00010144191, 6.3258212e-06, -8.2142076e-05, 0.0002813513, 4.2112362e-05, -0.000110607056, -0.000112126676, -0.00015391654, -6.2326966e-05, 2.03882e-05, 6.4431275e-05, 0.00012477092, 0.00012371695, -7.7061624e-05, 6.6411776e-05, -0.0002751624, 6.722168e-05, -0.00032532704, -5.1630726e-05, -0.00036059355, -2.095597e-05, 0.00015363451, 2.36994e-05, -0.00014677334, -0.0001642264, 0.00015223553, 0.00025779675, 0.00015623942, -8.901224e-06, 5.632179e-05, 0.00012782245, 6.941611e-05, -0.0001550857, 0.00023894341, -1.6405513e-06, 0.00017536969, 0.000114307426, 0.00014539105, -7.815628e-05, 0.00013517337, 0.00027009094, 0.000109933666, 9.8290664e-05, -0.00031872062, 3.5656667e-05, 7.021196e-05, 1.0883895e-06, 2.0518555e-05, 2.0362615e-05, -0.0003196019, -5.2314026e-05, -0.00015551863, -0.00015066797, -3.120117e-05, 0.0001232613, 6.0658633e-05, 9.8385564e-05, -8.43076e-06, 5.1779658e-05, 0.00026404703, -4.499503e-05, 3.1534622e-05, -3.361371e-05, 0.00014971901, 5.4381613e-05, 0.00010917159, 8.473642e-05, -0.00021491793, 2.9217792e-05, 0.00012423625, 8.030357e-05, 0.0002110296, 0.00019208144, 3.2841177e-05, -3.6413952e-05, -0.00023424644, -1.1414761e-05, 0.000108908825, -6.853942e-05, 0.00019893526, -6.331966e-05, 0.0002986013, 4.1426156e-05, 0.0003055176, -2.1977924e-06, -0.00016652013, -7.106176e-05, 0.00015993563, 8.605405e-05, -0.00010254, -0.00020103116, -0.000120018674, -1.0433013e-05, 4.0343413e-05, -3.2450822e-05, -7.89974e-05, 9.3862545e-05, -0.0002341559, 2.7550901e-05, -0.00015669875, -0.000106625994, -5.6546694e-05, 4.1555322e-05, -0.0001580071, -0.00021914738, -0.00010525025, -2.5443707e-05, 0.00022167154, -0.0001567189, -6.2480845e-05, -9.566846e-09, -7.66746e-05, 4.2831434e-05, -0.00015575833, 4.20422e-06, -0.00014183445, -2.9665278e-05, 0.00015450103, 3.8798014e-05, 2.4864792e-05, -6.958755e-05, -4.3637538e-05, 0.00015624412, 0.00017280967, -7.419345e-05, 6.67605e-05, 7.480753e-05, 4.7881756e-05, 1.8688124e-05, 0.00017223707, 5.2297364e-05, -8.49678e-05, 3.0671155e-05, 8.3731305e-05, 6.9644615e-05, 0.00010769141, 0.00024238936, 6.326052e-05, 7.323234e-05, -0.00023212217, -0.00017555871, 9.6492025e-05, 3.3152017e-05, -0.00025874024, 9.4386356e-05, -0.00044464716, -6.978501e-05, -0.00036700658, -3.5752633e-05, 0.00022633844, 8.673493e-05, -0.00014913088, -0.00010131539, 0.00010583562, 0.0002554148, 0.00018488965, 2.5508509e-05, -8.0754535e-06, 3.3144464e-05, 0.00014198087, -7.641764e-05, 0.00031134888, -6.170308e-05, 9.973959e-05, 6.2525454e-05, 5.817077e-05, -5.4587457e-05, 0.00024500611, 0.0003434685, 9.429286e-05, 5.8940856e-05, -0.00039200153, 6.4967026e-05, 9.728125e-05, 9.150385e-06, -5.7988316e-05, -1.0251229e-05, -4.905844e-05, -7.232015e-05, 1.5683901e-05, 9.688263e-05, 4.21219e-05, 3.2180833e-05, -0.00018814616, -1.3767033e-05, 0.00012474516, 1.5349098e-05, -0.00016004287, 0.00014492289, -0.0001690945, -0.0001256989, -2.587929e-05, -0.00011638411, 5.692402e-06, -0.00014122154, 0.00020424862, -4.653496e-05, -0.00015310745, -0.000102865175, -8.828931e-06, -9.1837974e-05, 6.0568364e-06, -7.0004644e-05, 0.0001128738, 0.0002547835, -5.383096e-05, 2.6451851e-05, 7.178426e-05, -2.51206e-05, 0.00033224252, 0.00012092936, 0.000106626736, 2.8986133e-06, -4.5997353e-05, -0.00010432024, 0.00012085895, -4.018205e-05, -0.00012323573, -0.000121518366, -2.7571383e-05, -0.00015953141, 0.00011400873, 0.00013844718, -0.000115114104, 6.6874425e-05, -0.00016788747, 0.000121593504, -0.00012787571, 3.7261456e-05, 8.967849e-05, 7.2186864e-05, -0.00021978133, -7.531007e-05, -3.6824713e-06, 8.648409e-05, 0.00011904598, -0.00022753494, -3.5776873e-05, 4.1484975e-05, -0.0004434428, 0.00011415946, -0.00047441563, -5.40582e-05, -0.00052911794, 1.651196e-05, 0.0002927671, 2.7941207e-05, -0.0002598886, -0.0002801968, 0.0001868316, 0.00032355107, 0.000180087, 1.2159423e-05, 0.00010116798, 0.00019980887, 4.6548983e-05, -0.00019767077, 0.00031118418, 1.2192162e-05, 0.0002564316, 0.00016085422, 0.00015586706, -0.00013917508, 0.00013627339, 0.00042160542, 0.00014830145, 0.00018719406, -0.00043147846, 2.88641e-05, 0.00010982263, 3.9072715e-05, 8.9614936e-05, 2.0411076e-06, 0.00013984328, 9.987235e-05, 9.867113e-05, 7.9197016e-05, -7.66312e-05, -2.4574005e-05, -7.5734075e-05, 6.7553183e-06, -0.00011403552, -0.00023784657, -0.00017624504, 7.947849e-05, 3.687398e-05, -1.5965663e-05, -0.00013840385, 0.00013094765, -0.00013375696, 7.032156e-05, 0.000108594155, 4.426094e-05, -0.00014930568, -8.3753504e-05, -9.245961e-05, -0.00017731916, -5.4127955e-05, -3.8770402e-05, 0.0003001003, 0.00021162798, -4.841791e-05, -3.2944877e-06, -4.029004e-06, -2.105225e-05, 0.00033167028, 0.00012997763, -3.0654646e-05, -1.8149552e-06, -6.121303e-05, -0.00011583609, 8.468578e-05, -7.929997e-05, -7.9667254e-05, -9.6028794e-05, 1.7754237e-05, -0.00018159291, 0.00016960205, 0.0002340814, -0.00013123653, 2.9440343e-05, -0.00013359787, 0.00019673162, -5.6982783e-05, 0.00015399902, 0.00017824459, 6.581581e-05, -0.00025950623, -3.7997925e-05, 2.9135821e-05, 0.00012502317, 9.595873e-05, -0.00019933618, -3.0346435e-05, 1.690885e-05, 0.00046411878, -0.00012087289, 0.00014070241, -0.00011500884, 0.00061313174, -3.0192996e-06, -0.00026969484, 9.495352e-05, 0.0001694576, 0.00037025762, -8.421582e-05, -0.00023896625, -0.00024024725, 0.00022552906, -0.0002653357, -0.0004413428, 8.3929954e-05, 0.00016395311, -0.00022429836, -0.00021805409, -0.00020888093, -0.00035762737, -0.00033529417, 4.7445348e-05, 0.00010097153, -0.0004051196, -0.00020162757, -0.0003357032, 0.00035873736, 0.00014088693, -0.00010318665, -4.524216e-05, -0.00046752597, 0.00011647365, -0.0005446309, -5.5997843e-05, -0.00063642306, -6.687963e-06, 0.00025280254, 5.377201e-05, -0.0003352956, -0.0002731639, 0.000250638, 0.00032541607, 0.00021870642, -1.6960954e-05, 5.7163346e-05, 0.0001889393, 2.906298e-05, -0.0002903459, 0.00032818195, 4.306497e-05, 0.00034126535, 0.00024372045, 0.00019143986, -0.00015084395, 0.00015322844, 0.00039508392, 0.00018660212, 0.00015779352, -0.00039615956, 0.0002149253, 0.00011256953, -1.6899434e-05, -0.0003116434, 6.424456e-05, -2.0434793e-05, 1.2261455e-05, -0.0002301339, 0.0002068939, 0.00020190263, -6.799458e-05, -0.00036344316, -0.00025364087, 0.00017902676, 0.00012174622, -0.00022648126, 0.0001453647, -7.1504044e-05, 7.367547e-05, -0.00012857324, -0.00020294037, 0.00013763446, -0.0001264733, 0.00056536845, 0.00012746743, -0.00013549415, -0.00023469236, -7.6170974e-05, -1.4352672e-05, 7.867947e-05, 7.642597e-05, 7.710968e-05, 0.00035260565, -6.2030325e-05, 6.558877e-05, -4.8706912e-05, 3.9859706e-06, -7.239963e-06, -1.3033836e-05, -2.6849591e-05, -8.231426e-06, 5.6894078e-05, -2.0984644e-05, 4.6837686e-05, -4.55084e-05, 1.0872913e-05, 0.00010090207, 4.933953e-05, -4.3246237e-05, 4.0758798e-05, 6.172796e-05, 2.6142168e-05, -2.4917297e-05, 4.7261543e-05, -7.910495e-06, -3.2196953e-05, -1.2878061e-05, 6.914344e-05, 2.7267635e-05, 3.5880707e-06, 8.7161454e-05, 1.5965965e-05, 5.2562245e-05, -0.00011674876, -0.00016225473, 1.5439713e-05, 2.2198916e-05, -0.0002671958, 7.907475e-05, -0.0006319554, -0.00020680256, -0.00033662358, 2.4694351e-05, 0.0002883201, 0.0001901431, -0.0002825493, -5.3537908e-05, 0.00023326978, 0.00038450945, 0.0001057425, 0.00018206752, -0.0002022201, -0.00016629082, 0.00021571989, -0.00014746502, 0.00042925053, -0.00023481707, 0.00021542441, -3.2879037e-05, -8.703996e-05, -9.7064076e-05, 0.00038849478, 0.00033395286, 0.00010259949, -6.452651e-05, -0.00039699796, 0.00027295787, 7.752183e-05, 2.2422311e-05, 0.00048663816, -0.00011657455, 0.0003514463, 3.8077702e-05, 0.0004884822, -9.5684234e-05, -0.00030090223, 2.888574e-05, 0.00032050945, 0.00031183712, -0.00023166541, -0.0002900527, -3.017292e-05, -6.527302e-05, -5.5607434e-05, -0.00018884784, -2.4753415e-06, 0.00022451708, -0.0002560523, 5.8875605e-05, -0.00041270017, -0.00016850469, -7.9025674e-05, 0.00020845972, -4.6270106e-05, -0.0003050904, -0.00013382659, -0.00019860115, 0.00031229598, -0.00013688994, -5.0136077e-05, -5.6448134e-05, 0.0009337843, -0.00024777345, 0.00093518617, 2.100032e-05, 0.0013324876, 6.056221e-05, -0.0005985914, -7.8227305e-05, 0.00051327277, 0.00061502645, -0.00034948642, -0.0007123981, -0.0006233192, 0.00022534521, -0.00028277276, -0.00056848634, -7.7192475e-05, 0.00043257303, -0.00072295236, -0.00024603854, -0.00042477957, -0.00056174636, -0.0005689638, 0.00014174862, -0.00025244965, -0.0009931694, -0.00045122392, -0.0004476074, 0.00097452675, -3.5017772e-05, -0.00029793603, -5.3264874e-05, -0.00014119303, 1.3725861e-05, -0.000103030994, -0.0001451714, 4.8401544e-05, 0.00015146041, 0.00013883054, 1.2901847e-05, -0.0001657695, -1.04123e-05, 0.00019684613, 0.00016277422, -0.0002357908, 0.00028524105, -0.0002349639, -0.00017624372, 0.00011004193, -0.000106577485, 0.00011492526, -0.0003389162, 0.00032879313, -0.00013372317, -0.00023308436, -0.0001595719, 9.680506e-05, -6.0302293e-05, -2.741389e-05, -7.411343e-05, -1.7515626e-05, 0.00023581754, -6.688843e-05, 5.2711377e-05, 0.00031390012, -8.5445405e-05, 0.0004947651, 0.00012166272, 0.00036740216, 1.1572711e-05, -0.0002348071, -8.603628e-05, 0.00018699012, 0.00011773044, -0.00019497694, -0.00029861598, -0.00015640863, -8.685723e-05, 5.436079e-05, -1.2652603e-05, -0.00016166265, 0.00016133164, -0.0002828273, 0.00011320467, -0.00016321831, -3.5814122e-05, -6.148467e-05, 9.849237e-05, -0.00023489357, -0.00032968662, -0.00010357313, -6.218096e-05, 0.00040239055, -0.00010303974, -9.9951954e-05, -1.7269647e-05, 0.0005667081, -0.00017852384, 0.00086141634, 8.912282e-05, 0.0008407024, 4.581552e-05, -0.00038504764, -0.0001518574, 0.00040814208, 0.0003076463, -0.00025808747, -0.00046007658, -0.0003813818, -1.4697089e-05, -6.554767e-05, -0.00018107098, -0.00014570203, 0.0002516554, -0.0005395935, -4.6077712e-05, -0.00032450588, -0.00027605155, -0.00021944204, 0.00015947726, -0.00037081112, -0.00063529477, -0.00026096546, -0.00016714164, 0.0006474159, -0.0002652873, -0.00021482614, -2.3479813e-06, 5.447828e-05, 2.2175253e-05, -6.8679044e-05, 6.397838e-05, -8.333745e-05, -7.2309434e-05, -2.9006576e-05, 3.4999095e-05, 3.1072188e-05, 3.1708385e-06, -8.915748e-05, -2.7148533e-05, 0.00015154494, -8.680364e-05, 7.7996214e-05, 4.452276e-05, -9.557614e-06, 5.5334833e-05, 5.674504e-05, 0.00013817076, -7.89516e-05, 8.304839e-05, 7.01537e-05, 5.461821e-05, 8.068329e-05, 6.828491e-05, 4.1891413e-05, 2.4173812e-06, -3.683193e-05, 1.7232907e-05, 7.356742e-05, -3.61408e-05, -0.00019451199, 4.2371466e-05, -0.00033470828, -9.701245e-05, -0.0002506618, -1.4683061e-05, 8.6956934e-05, 6.690402e-05, -0.00015196665, -5.31157e-05, 0.0001667897, 0.00016033732, 8.650018e-05, 7.728866e-05, -4.157687e-05, -1.3570881e-05, 9.367375e-05, -0.00012342681, 0.00015784011, -5.7049314e-05, 0.00013349153, 4.8480804e-05, 3.943422e-05, -8.214935e-05, 0.00013936587, 0.00016242458, 6.0799917e-05, 1.5131566e-05, -0.00020833894, 0.00015638051, 4.9137187e-05, -2.0041638e-05, -0.0008495292, 0.00022520378, -0.0006415063, 8.0982245e-05, -0.0011995615, -0.00012549749, 0.00053547334, -3.0744108e-05, -0.00027452596, -0.00058257184, 0.0002277929, 0.00059308676, 0.00067576015, -0.0004045786, 0.0003669514, 0.00068977405, 6.118003e-05, -0.00038007132, 0.00051379495, 0.00032824275, 0.00018609683, 0.000545597, 0.00071218377, -2.9928791e-05, 7.235588e-05, 0.0009416372, 0.0004256797, 0.0005375858, -0.0009581698, -0.00028210494, 0.0002958041, 6.7708796e-05}},
    {"bert.encoder.layer.2.attention.output.dense.bias_grad", {-0.001347517, 0.0015119386, -0.00068828743, -0.0049543995, 0.0031629507, 0.00034337482, -0.011643458, 0.014579443, -8.5043066e-05, -0.004601357, -0.0012483814, 0.002777835, -0.002387698, -0.003936719, 0.0015158368, 7.9548496e-05, -0.006465027, 0.002780526, -0.0013905573, 0.008118777, -0.0064431042, -0.0015278049, -0.0015590218, -0.0025578192, 0.005856789, 0.015577178, 0.0005008283, 0.0042633833, 0.0084192855, -0.0003320947, -0.0023061987, -0.016013203}},
    {"bert.encoder.layer.2.attention.output.LayerNorm.weight_grad", {-0.0021865284, -0.0016314037, 0.0010583926, 0.0024815237, 0.0038946054, 0.0026745559, 4.9378286e-07, -0.00075472746, -0.0028941927, -0.0021841703, 0.0012549163, -0.0003704272, -0.00236779, -0.00037823085, -0.0027864606, -0.0003803774, 0.0016288835, -0.00022233343, -0.0029249259, -0.00022394597, 0.005061248, -0.0046469993, -0.00038791858, -0.0020592497, 0.00078318396, 0.003229579, 0.00046695812, -0.0019607488, -0.002407029, 0.0014043798, 4.828915e-05, 0.00674609}},
    {"bert.encoder.layer.2.attention.output.LayerNorm.bias_grad", {-0.0013376966, 0.0015230133, -0.0006734445, -0.004945123, 0.003165945, 0.00034769022, -0.01163167, 0.014596535, -7.002531e-05, -0.004586503, -0.0012380017, 0.0027865996, -0.0023769354, -0.0039224164, 0.0015318908, 8.6604545e-05, -0.0064488035, 0.002788965, -0.0013811082, 0.0081295, -0.006426022, -0.0015105696, -0.0015474055, -0.002537817, 0.0058630994, 0.015581222, 0.0005193319, 0.0042693573, 0.008425344, -0.00032379356, -0.0022926286, -0.015996734}},
    {"bert.encoder.layer.2.intermediate.dense.weight_grad", {-0.00011499912, 4.606256e-05, -6.149444e-05, 0.00017800283, -6.452773e-05, 9.877223e-05, 7.612808e-05, 6.9608584e-05, -4.4721746e-05, -0.00011396719, 6.926884e-05, 0.00011162646, 9.859352e-05, 5.3340922e-05, 0.00032631075, -0.00018036086, 0.00028995247, -1.7727241e-05, 6.1490944e-05, -5.8887348e-05, 8.1339625e-05, -0.00015029726, -0.00029558843, -2.616947e-05, 8.9934685e-05, -0.00011079192, -0.00047786013, -0.00029088382, 0.00015893222, -3.274127e-05, -3.9727416e-05, 0.00027138062, -3.0773648e-05, 5.4461365e-05, 2.4169254e-05, 0.00013622537, -0.00011408111, -3.4613746e-05, 2.8061082e-05, 0.00016874712, -7.767327e-05, -0.00020504296, -8.4469335e-05, -2.7633746e-06, -2.7170612e-05, 5.974981e-05, -0.00018787949, -0.00015597566, 5.5304954e-05, -3.3120265e-05, 0.0002566545, 0.00019810497, 0.00024950795, -4.087318e-06, -1.0080107e-05, -0.00011539651, 1.1859899e-05, -0.00019803249, -0.00021859413, 0.000100461475, 9.738047e-05, -4.6659003e-05, 5.6121575e-05, 4.960305e-05, 0.00010213767, -0.00017649277, -7.443474e-05, -2.5816391e-06, -5.5272565e-05, 6.8268964e-05, 8.83436e-06, 2.963155e-05, -4.6947793e-05, 1.566276e-05, 0.00012738582, 0.00013218605, 0.000120078046, -3.4495857e-05, 0.00015317957, -8.091892e-06, 3.5970847e-05, -4.0410727e-05, -0.00010015826, 3.023826e-05, -0.00011092693, -0.00019971246, -0.00010147962, 6.658507e-05, -1.1776593e-05, 8.260687e-05, 5.608613e-05, -7.832544e-05, 4.8163784e-05, -0.00014840721, 6.85524e-05, 4.394654e-05, 1.1392938e-05, 2.697928e-05, 1.2393843e-05, 4.6252513e-05, 4.1773223e-05, 2.0777072e-06, -2.5398727e-05, 5.7649477e-06, 1.8449457e-06, -1.4498677e-05, 5.2378626e-05, 3.8430266e-05, -2.6810692e-05, 3.6539482e-06, -7.4866075e-06, -7.358253e-05, -4.2724096e-07, 1.2508234e-05, -1.8486922e-05, -6.532108e-05, 4.8440328e-05, -4.7151756e-05, -4.102392e-05, -1.8608383e-05, -1.1385735e-05, 3.3681605e-05, -2.9921415e-05, -8.4532e-06, 1.939897e-05, 1.9219655e-05, 1.2247009e-05, 1.1883326e-07, -0.00017185931, 0.00016865473, 6.497075e-05, 8.880159e-05, -1.4686254e-05, -7.4827512e-06, -1.0598523e-05, 0.00014908034, 7.837781e-05, -0.0001753268, -9.266737e-05, -6.280066e-05, -9.4200885e-05, 1.1332442e-05, -6.0169827e-05, -0.000105952466, 7.999136e-05, -8.8049215e-05, 0.00017366235, 0.000132127, 0.00025680644, 6.485461e-05, -1.3106904e-05, -0.000152819, 3.4417506e-05, -0.0001898783, -0.00022791303, -1.0860194e-06, 6.914012e-05, 2.9288703e-05, -2.9977643e-06, 7.008916e-05, -0.00010610335, 0.000114264396, 4.9652583e-05, 0.00025882976, 5.0697254e-05, 0.000108684275, 0.00010378428, 0.00011118403, -0.00010046159, -0.00024252034, 9.649759e-05, 6.0460407e-05, -0.00015202643, 9.581921e-05, 7.3012045e-05, -0.00026170874, 0.00019925633, 1.3167263e-05, 0.00017124087, -0.00011352368, 0.00024825573, -5.613515e-05, -0.00028622686, -0.00015037598, 2.2291037e-05, -3.3122826e-05, -0.00030676267, -0.00011812152, 9.248492e-05, -7.305033e-05, -5.2876792e-05, 0.00018343421, 0.00011438477, -3.5201007e-05, -4.259235e-06, -0.00016875035, -2.5354862e-05, -5.705109e-05, -1.5344427e-05, -7.186222e-05, 2.0593256e-05, 0.00015481038, -0.000112692294, -7.153927e-05, 3.700073e-05, -3.6939895e-05, -0.000104376355, 0.00021712792, -0.00016510095, 3.889374e-05, -9.7595934e-05, 3.1644973e-05, -0.000115046256, 9.842663e-05, 0.00020232596, 2.2725239e-05, -8.256727e-05, 3.6096113e-05, 0.0002800887, 0.00012384368, -7.220934e-05, -1.9378813e-05, -1.8432203e-05, -0.00010426023, 5.200943e-05, -9.317277e-05, -8.500057e-05, -3.9369294e-05, 3.0448296e-05, 8.820783e-05, 3.003929e-05, -0.000108657456, -3.4885346e-05, 0.0001397931, 7.434989e-05, 2.8739276e-05, 0.00014656849, -8.059132e-06, 0.0001914147, 2.5947926e-05, 5.0208662e-05, 3.6938214e-05, -0.00014047058, -9.125506e-05, -0.00027238816, -0.00014273297, -5.762575e-05, 0.00016044299, 6.98347e-05, 6.896488e-05, 1.3872213e-05, -0.00016356817, -1.5848102e-05, 1.8650746e-05, -7.3336655e-06, 3.393635e-05, -0.00012497816, 4.380886e-05, 4.1410898e-05, 0.00024516231, -0.00010386608, 0.00014680097, 6.929744e-05, 4.875222e-05, -8.760712e-05, -0.00011529189, 5.9594397e-05, 7.720546e-05, 1.15203175e-05, 0.00010861582, 9.488781e-05, -0.00021518112, 0.00019077392, 4.1057575e-07, 0.0001357753, 9.168641e-06, 0.00011626609, -0.00015614823, -0.00019938868, -0.00016790738, 1.1447307e-05, -1.6386077e-05, -0.00033803436, -0.00017968609, 0.0001520276, -4.3635493e-05, 4.607747e-06, 0.00018057696, 7.8516634e-05, -0.0001506761, 7.0642304e-06, -0.00013056434, 3.4969144e-05, 3.2362903e-05, -4.904768e-05, -8.1789985e-05, 2.1887716e-05, 0.00015863313, 6.7237816e-05, 4.77778e-05, 9.604022e-05, -6.145924e-05, 2.7751269e-06, 0.00011728012, -0.000106151565, 1.2116136e-05, -0.00020885505, -2.5884847e-05, -0.00025693834, -5.1692405e-05, 9.3007686e-05, 4.6230605e-05, -2.684742e-05, 0.00024206759, 0.00028224065, 2.4653962e-05, -6.929976e-05, -3.84365e-05, 3.0327092e-05, -0.00013754542, -2.2258435e-05, 4.5729153e-05, -3.7924117e-05, -9.4325536e-05, -7.2484574e-05, -0.000108612774, -3.206302e-05, 8.068343e-05, 4.7342233e-05, -7.155792e-06, -0.00017627602, -0.00012758859, 4.5749675e-05, -4.67235e-05, -4.8378664e-05, 0.00012777433, -5.483388e-05, -4.5938465e-05, 0.000115563715, 7.345015e-05, 2.1681048e-05, 0.00013670388, 0.00016448753, 5.464598e-05, 7.89628e-06, -0.00020816072, 7.899319e-05, 0.00013924073, -3.793391e-05, 3.860555e-05, -9.447908e-05, 3.6590165e-05, 7.200647e-05, -5.173839e-05, 4.182381e-05, 2.2607708e-05, -0.00012076709, -1.1876444e-05, -0.000100225225, -8.3492805e-06, 5.7293622e-05, 9.040886e-06, -1.4868843e-05, -7.387122e-06, 7.665868e-05, 1.857117e-05, -0.00020384681, -2.7280224e-05, -0.00012983748, 3.087854e-05, 1.7965966e-05, 7.375894e-05, 5.185908e-05, -7.167983e-05, 9.5809795e-05, -3.730142e-05, -5.6175762e-05, 7.4132666e-05, 0.00016277234, 8.802874e-05, -1.4642868e-05, -2.5346908e-05, 6.985867e-05, -8.174332e-05, 2.781823e-05, -4.255262e-05, 5.7999816e-05, 1.1439905e-05, -0.000104411236, 1.4676537e-05, -6.353473e-05, 8.9954865e-06, 9.138567e-05, 3.951708e-05, -3.6890895e-06, -4.0633393e-05, 2.9747278e-05, 2.9984367e-05, -8.5756816e-05, -1.5588337e-05, -7.727224e-05, -5.3231084e-05, 3.0086185e-06, 8.607712e-05, -7.475926e-05, -6.6641114e-05, 0.000118283155, -1.6427331e-06, 3.2848842e-05, 4.3848224e-05, 4.6451743e-05, -3.270764e-05, -2.9440833e-05, 6.23117e-05, 8.128354e-05, -9.381613e-05, -8.516061e-05, 0.00014215586, 5.5651442e-05, 0.00012476149, -2.7146061e-05, -1.193521e-05, -1.06556545e-05, 0.00014080231, -4.9153914e-05, -0.0002065268, -4.9865157e-05, 8.1231165e-06, -0.00013068267, -3.775705e-05, -4.672108e-05, -0.000116450836, 5.6719357e-05, -8.754176e-05, 0.00020868276, 7.208853e-05, 0.00028019235, 4.9075712e-05, -3.916762e-05, -9.9490404e-05, -3.8562695e-05, -0.00017505835, -0.000104955776, 5.433835e-05, 7.294694e-05, -3.080927e-05, -3.9955597e-05, 0.00012205814, -0.00018460554, 0.00017348981, 7.340515e-05, 0.000398263, 1.3149479e-05, 0.00020152875, 7.223297e-05, 0.00023805078, -0.000135185, -0.00040142814, 0.00015332052, 0.00016106134, -0.0002348973, 0.00010327737, 0.000115457915, -0.00044933028, 0.00027887296, -8.6902866e-05, 0.00027409583, 3.4694276e-06, 0.00043912197, -0.0001180356, -0.00037520335, -0.00020911533, 6.911299e-05, -0.00017740543, -0.000522931, -0.0002268606, 0.00014681867, -9.372911e-05, 5.163137e-05, 0.00024926913, -0.0002502273, 0.0003551795, 5.220322e-05, 9.489445e-05, 0.00017619306, -0.00012968999, 6.455744e-05, 0.00010310123, 6.202601e-05, -0.00021845638, -9.455108e-05, -0.00017043958, -0.00032527096, -6.135051e-05, -5.4929227e-05, -4.503647e-05, 3.5477697e-05, 3.6039382e-05, 0.00019062644, -0.00010116558, 0.00042768713, 0.0003321377, -2.4488982e-05, -0.00013931768, 4.0711243e-06, -0.00021506037, -0.00015896594, 0.00014549168, -0.00011873484, 0.00016312236, -0.00018634, 5.1216033e-05, 3.4822772e-06, 6.172032e-05, 8.4453444e-05, 6.482265e-05, -0.00019381731, -9.5286654e-05, -0.00013257975, 0.00017254202, -3.811655e-05, -0.00020426775, -9.234739e-05, -6.2102044e-06, 4.0197316e-05, 2.4604704e-05, -0.0002654945, -0.00012105486, 1.4877604e-05, -0.00016624795, 0.0003100889, 0.00024853388, 0.0003665325, 4.2843344e-06, 0.00010017699, -6.325154e-05, -9.157547e-05, -0.0002779248, -0.00017874224, 0.00011584975, 0.00017831888, -5.6821384e-05, 0.00013880793, 5.4444787e-05, -0.00017135384, 0.00020238603, 9.766991e-05, 0.0002618214, -0.00022782129, -1.6490312e-05, -5.5952016e-05, 0.00023275097, -0.0001426272, -0.0003513199, -8.735847e-05, 6.707493e-05, -8.014698e-05, 4.9024304e-05, -0.000114429764, -0.00028704284, 0.00018453959, -0.00016803338, 0.00042229495, 0.00026857, 0.0005597504, -3.8513514e-05, -9.112878e-05, -0.00018446553, -2.4220522e-05, -0.0004046068, -0.00038470508, -4.385066e-05, 0.00024299994, -4.2819178e-05, 6.0435195e-05, 0.00026756863, 0.00015387515, -0.00017130528, -6.637756e-05, -0.00016503892, 0.00019117729, 5.2812297e-06, 6.279525e-05, -0.00014385121, 4.4235472e-05, 0.00021871517, 0.00013220609, 2.6993495e-05, 4.0309915e-06, -0.00011601586, 0.00016448187, 0.00023149564, -0.00015482433, 0.00010971148, -0.00033705804, -0.00023186459, -0.00038648868, 8.342556e-06, -3.3877877e-05, 0.000103095124, -5.0114536e-06, 0.00035879295, 0.00039457678, -4.3464388e-05, -0.000186425, 4.0119544e-06, -4.59155e-05, -0.00012629994, -0.00025781034, 0.0003443638, 0.00014169251, 0.00011831623, -3.141923e-05, -1.8483774e-05, -8.714128e-06, 0.0002558133, 5.787048e-07, -0.00036747922, -5.3701508e-05, 3.696193e-05, -0.00027727487, -8.718232e-05, -0.00010195099, -0.00026498517, 0.00019222952, -0.00020734173, 0.0004252558, 0.00015241164, 0.000560246, 8.286391e-05, -0.00014301065, -0.0002643791, 1.3485181e-05, -0.00035244846, -0.00039869637, 6.89986e-05, 0.00017001081, 3.015026e-05, 9.565791e-05, 0.00014584172, 5.274413e-06, 3.107341e-05, -2.0759504e-05, -1.9268755e-05, -0.00015575236, -0.00015123532, -0.0001422886, 2.4366893e-06, -0.00011378403, -1.0871964e-06, -0.00018512916, -1.6395066e-05, 0.00017436293, 3.1508585e-05, -0.00021344144, 1.5003791e-05, 7.2770717e-06, -1.0261843e-05, 0.0001981474, 0.0001266264, 0.00028021267, 4.45294e-05, 0.00022025366, 5.7958587e-05, -0.00013802113, -0.00028791372, -3.4610708e-05, 7.808166e-05, 0.00015991754, -3.431117e-05, -1.6946741e-06, 9.329044e-05, 4.856607e-05, -9.707064e-05, -7.2371775e-05, -1.2319979e-05, 0.00010261247, 6.0411563e-05, 1.2816578e-05, -0.000110571484, -3.6247693e-05, 0.0001376203, 0.000166334, 0.000121663, 7.954875e-05, -3.679489e-05, 0.00013276476, -7.0357173e-06, 3.5068242e-05, 3.4458928e-05, -0.00011049935, -0.00018999916, -0.00019702138, -0.00014956221, -8.8440516e-05, 5.586692e-05, -2.737544e-06, 0.0002372418, -1.6112079e-05, -0.00017632959, -8.7343915e-06, 5.1416024e-05, 5.136733e-05, -1.590832e-05, -6.45277e-05, 6.8741765e-06, 6.274264e-05, 3.0894094e-05, -4.870603e-05, 1.7214394e-05, -2.7093132e-05, 4.8494567e-05, -1.1318242e-05, -5.937422e-05, -4.163913e-05, 3.8397244e-05, -1.1025032e-05, -1.1282708e-05, -3.2223597e-05, -1.9065405e-05, 1.6080341e-05, -4.51793e-06, 6.413106e-06, 9.6779535e-05, 0.00011271374, 4.0870273e-06, -2.7337066e-05, -0.000120235934, -4.7900918e-05, -7.956349e-06, 4.8655707e-05, 2.6303867e-05, 5.802898e-05, -6.592982e-05, 2.9665904e-05, -3.2121375e-06, 8.238497e-05, 1.1748646e-05, 5.7108165e-05, -8.5365646e-05, -6.3223684e-05, -8.2630526e-05, -8.120388e-05, 4.6690952e-06, 4.1560983e-05, 4.856434e-05, -0.00012216879, -6.889895e-05, 4.188446e-05, -2.713146e-07, -0.00021704056, 6.946671e-05, -0.00013731064, 2.3980754e-06, 7.250094e-06, 0.00011454003, 4.244003e-05, 7.083704e-05, 0.00018173881, -2.7040273e-06, -7.738696e-05, -7.5467346e-05, 0.00016712856, 0.00015287369, -2.0872849e-05, -3.2064027e-06, 6.5349945e-05, -0.00012419203, -7.095669e-05, 7.846994e-05, 1.8624109e-05, 3.8487244e-05, 0.00024042034, 6.585694e-05, 8.401747e-05, -5.0368486e-05, 3.871407e-05, 4.8611973e-06, 0.0001492293, -1.2750627e-06, -0.00020520839, 3.3321547e-05, 0.00013505422, -4.442779e-05, -7.8942674e-07, 4.911882e-05, -0.00011198575, -0.00020547443, -0.00014588378, 3.9224044e-05, -0.00013077092, -1.9913572e-05, 0.00010899265, 0.00017807558, -7.807573e-05, -8.891861e-05, -0.00013277298, 0.00013126532, -4.433035e-05, -6.2580846e-05, 0.00014751471, -7.136455e-05, -3.9507704e-05, -7.875336e-05, 9.982649e-05, 9.097483e-06, 4.6701145e-05, -5.9965714e-05, 2.7024445e-05, 7.5880336e-05, 0.00010616386, 4.9473288e-06, 2.3466066e-06, -3.846032e-05, 7.986554e-05, 6.333813e-05, -6.126508e-05, 8.368627e-06, -0.00011314904, -0.00010958591, -0.00021972477, -5.8266727e-05, -3.521627e-05, 0.000107705964, 4.7671536e-05, 0.000111615445, 6.552204e-05, -2.7308264e-05, -7.861323e-05, 3.20837e-05, 4.6585832e-05, -9.107851e-05, -6.9063935e-05, 2.0726378e-05, 0.00012625058, 8.514063e-05, -2.6797745e-05, 7.5596115e-05, -0.00011605545, 0.0001847382, -8.425558e-05, -0.00024108346, 8.767287e-05, 0.00016254843, -0.000109006694, -6.3379e-05, -0.0001556986, -0.00020567211, 3.272777e-05, -0.0001751194, 0.00019222603, 0.00019399235, 0.00035148032, -9.986522e-05, -0.00012281032, -0.00013683276, -7.679723e-05, -8.0270525e-05, 5.1385377e-06, -3.46682e-05, 0.00010168496, -9.7465716e-05, 0.00022684176, 4.807689e-05, -0.00014824764, 8.378885e-05, -4.0691986e-05, 9.493933e-05, -0.000118663265, 8.284423e-06, -1.4522063e-05, 6.5661465e-05, -8.2548235e-05, -0.00015228557, -0.000120459, 2.7298403e-05, 6.354995e-05, 6.5097124e-06, 5.5965855e-05, -0.000101285164, 0.00022127635, -5.6748886e-05, 0.00018048762, 8.14171e-05, 0.00024247901, 5.3291766e-05, -2.736405e-05, -2.5700123e-05, -9.3443505e-06, -0.00025115788, -0.00020377077, -4.2572974e-05, 0.00018873444, -0.00010236681, -0.00011421656, 0.00023826095, -7.102982e-05, 8.16322e-05, -8.791655e-05, 8.005579e-06, 0.00016566126, 6.967313e-05, 6.368509e-05, 1.2918363e-05, -8.776771e-06, -4.0642208e-05, 9.17605e-05, 5.3467928e-05, -9.729507e-05, -5.3111104e-05, 0.00026841846, -1.1478839e-05, 0.00015286052, -7.2061295e-05, -2.513592e-05, -0.00021155765, -4.342145e-05, 4.8588612e-05, -0.00016533752, 7.533764e-05, 9.515824e-05, 2.232469e-05, -0.00016464636, -0.00018097136, -2.5077126e-05, 3.0094785e-05, -0.00012465095, 0.00014352302, -0.0001418506, 0.00030475168, 0.00012264254, 2.136402e-05, 9.832353e-07, -0.00017078266, -7.862238e-05, 0.0001730318, 7.6039556e-05, -0.00025478125, -0.00019306623, -9.035888e-05, -0.00020934669, -0.000108708635, -0.00018203788, -2.6006799e-05, 5.251237e-05, -0.00013689249, 0.00037454977, 0.00015044483, 0.0005247446, 0.00020123686, 7.4632626e-05, -0.00017476542, -8.657462e-05, -0.00035251965, -0.00022173178, 0.00011583242, 0.00010696153, 5.465608e-05, 1.0480906e-05, 6.3180865e-05, -5.0946383e-05, 5.3310265e-05, 5.339672e-05, 9.079153e-05, -1.792431e-05, -3.877668e-05, -5.2546224e-05, -6.0570273e-06, 1.7940632e-05, 1.4726724e-06, -1.7555978e-05, -5.9522386e-05, -4.6661e-05, 9.090258e-05, -0.00015413343, -0.000104889645, -4.0796356e-05, 5.450941e-05, 6.490208e-05, -2.5150577e-05, 0.00010414083, -2.027902e-06, 6.586218e-05, -3.7429567e-05, 2.6672938e-05, -2.833165e-06, -5.53202e-05, 2.3453347e-05, 1.0390487e-05, 0.00011216962, 9.504097e-06, -6.6848595e-05, 7.25326e-05, -0.00021167456, -0.00017096559, -0.00023010066, -3.5164998e-05, 2.7301041e-05, 2.4705543e-05, -0.0001728856, 8.0526485e-07, 0.00034900891, -3.153237e-05, 2.7059546e-05, 0.0002817974, -0.00011552803, 0.00019570105, 0.000291902, -4.7445483e-05, 8.553974e-05, -0.00024079838, -8.610986e-05, -0.00043094033, -2.028516e-05, 0.00011712691, 0.00012595173, -2.4641497e-05, 0.00018371643, 0.0003141738, -7.4125885e-05, -6.607043e-05, -4.0203806e-05, -2.4609988e-05, -7.4239375e-05, 9.972647e-05, -0.00011104334, -1.4533431e-05, -0.00018851705, -1.9119534e-05, -0.0001142373, -5.021677e-05, -6.256724e-05, 9.9316334e-05, 0.00019194682, -9.5463445e-05, -0.00012803615, 9.647174e-05, -2.4433728e-05, -0.00019840743, 0.00018810092, -0.00018656912, 1.9968204e-05, -9.642872e-05, 6.2131534e-05, -0.00019253718, 9.7933436e-05, 0.0002839609, 0.000114154354, 1.6742428e-05, 7.905511e-05, 0.00025813933, 0.00014465454, -0.00012640056, 5.952332e-05, 3.6142177e-05, -0.00023945665, -9.321031e-06, 0.00013595016, 2.605225e-05, -1.2337963e-05, 0.00015309022, -6.455627e-05, 7.341071e-05, -5.891311e-06, 2.9405324e-05, 8.4548565e-06, 2.5314734e-05, -8.925124e-05, -0.00019994128, 1.2658075e-05, -1.6146625e-05, 1.0012281e-05, -8.8220484e-05, 5.411673e-05, 4.6558876e-06, -0.00013141993, -4.019051e-06, 0.00014227023, -1.050094e-05, 1.9077132e-05, 2.2492699e-05, -1.4850704e-05, 9.798675e-07, 7.835407e-05, -0.00013825043, 0.00012029697, -6.737927e-05, -6.45056e-05, -8.272224e-05, 8.944137e-05, -1.9398756e-05, -0.00013377353, 0.00018848009, 5.649818e-07, -5.696806e-05, -1.8282659e-05, 0.00012492358, 9.201753e-05, -4.9036575e-05, -7.767008e-05, -0.00010906217, -0.00010416448, 4.523011e-05, 0.0001407355, -6.116585e-05, -2.6203375e-05, -8.8508474e-05, -7.031714e-05, -7.656349e-05, 0.00018484368, 8.322554e-05, 6.3806954e-05, 3.8830192e-05, 2.0944852e-05, 0.000119965305, 9.938486e-06, -0.00015374707, 7.228483e-05, -4.6278594e-05, -0.00010137043, 0.00018018534, -9.993037e-05, -7.5034346e-05, -0.0003033584, 8.667421e-05, -0.00018870737, 2.1238853e-05, -0.00017400132, 5.319739e-05, 0.00027045555, -0.00012412138, -0.00014786296, 9.170572e-05, -8.509846e-05, -0.00010937214, 0.0004158307, -0.00020826195, 6.0079186e-05, -0.0002130033, -0.00011128585, -0.00028642046, 0.0002644978, 0.00021805834, 0.00022826102, -2.5374806e-05, 0.00011988261, 0.0003810089, 0.0001791824, -0.0001992432, 6.191881e-05, -0.000104762425, -0.00017633838, 2.6029136e-05, -8.672015e-05, -5.580472e-05, -0.00022696464, 0.00018792329, 3.670186e-05, 5.3442664e-06, -0.00012389226, 9.0675734e-05, 0.00024485466, 0.0001113271, 2.3290002e-05, 5.3379277e-05, -0.000109526314, 0.00017693869, 0.00018870062, -0.00012839586, 2.4452744e-05, -0.00025826064, -0.00016458707, -0.00039319939, -1.0657258e-05, 4.3927645e-05, 0.00014268124, 2.1618467e-05, 0.00020247327, 0.00023236538, -4.3346972e-05, -0.00017998042, 7.923823e-05, 6.284679e-05, -0.00017343265}},
    {"bert.encoder.layer.2.intermediate.dense.bias_grad", {-0.0005405136, -0.0002519085, 2.5293379e-05, -4.6660854e-05, -0.00031389116, -0.0005628957, 0.00037433402, 7.994454e-05, -0.00046579534, 0.0003331464, 0.00012488414, 0.00012253612, 8.3907136e-05, -0.0002791169, -0.00085616246, -0.00029039048, -0.0001686307, -0.00059582025, 0.0004123329, -0.00064608187, 5.3466785e-05, 3.9832456e-05, -6.205922e-05, 0.0002602441, -0.00010851465, 0.00015235496, -0.00026240706, -0.00032368553, -0.00021014441, -0.00033141935, -4.671784e-05, 0.0004678015, 0.00048696753, 5.091267e-06, 0.00017348703, 0.0006847567, 0.00035478582}},
    {"bert.encoder.layer.2.output.dense.weight_grad", {-1.5351535e-06, 3.1607735e-05, -4.1280782e-05, 2.8573584e-05, -0.00018114706, -5.7585054e-05, -4.606773e-05, 0.00010824376, 4.917708e-05, -2.4067409e-05, 0.00010584955, 1.1287197e-05, 0.00012261237, 7.687094e-05, 6.268782e-05, -3.896679e-05, -0.00012975346, 1.5101683e-05, -3.1674062e-05, -0.00012083742, -4.6870085e-05, 3.7131158e-06, -9.309101e-06, -2.4657427e-05, -2.2292495e-05, 9.1548136e-05, -7.268002e-05, -4.1161165e-05, -0.00010228428, -2.1062087e-05, 1.717927e-05, 6.961304e-05, -3.996257e-06, -0.00010417352, -4.0903327e-05, -1.4687442e-05, 5.2433003e-05, -4.0677543e-05, 9.961112e-06, 4.3560503e-06, -9.386215e-05, 8.011982e-05, 6.620485e-06, -2.9328907e-05, -9.006385e-05, 2.1012867e-05, -0.00013853489, -5.334741e-05, 2.0758838e-05, 7.2729636e-06, 3.133825e-05, -6.775193e-06, -2.1848226e-05, 3.9413302e-05, 4.4971042e-05, 4.4812696e-05, 0.00010805718, -2.9332288e-05, -3.328289e-05, -7.1201525e-06, 1.10382725e-05, -4.0983075e-05, -1.0715971e-05, 1.4089915e-05, 9.199993e-05, 2.2772707e-05, 4.6754838e-05, -3.51613e-05, -2.2567294e-05, 1.4791357e-06, 3.7062207e-05, 2.477816e-05, 1.0202153e-05, -2.7566102e-05, 0.00019561763, -8.080718e-05, -8.5272884e-05, 0.00017923427, -0.0003075647, -6.602485e-05, 4.2702486e-05, 0.00010774008, 8.7032395e-06, 0.0004262889, 0.00018640817, -0.00013726538, 9.598594e-05, -0.0001140106, -3.8020033e-05, 0.00010199471, -0.00017099858, 0.00023303299, -0.00019380325, -0.00032785407, -3.0851457e-05, 1.465954e-05, -5.7337656e-06, -7.430864e-05, 0.00012362856, 6.148567e-05, -3.350983e-05, -0.00013446236, -0.00017014265, -0.0002323614, 7.868584e-05, 4.8666938e-05, 0.00013950888, -5.6035587e-05, -8.968363e-06, -0.00016555369, 0.00013022133, 7.111929e-06, 8.729458e-07, 3.6088315e-06, 0.00011090504, -0.0001461074, -1.244428e-05, -8.411041e-05, 0.00018441456, 8.457958e-05, -0.00011018583, -5.3132462e-05, -5.1809766e-05, -3.440156e-05, 6.881757e-05, -8.220653e-06, -7.193332e-05, -1.552649e-05, -0.00012749335, 4.7327634e-05, 4.4502853e-05, -3.940862e-05, -3.614709e-05, -0.00013847568, 1.9747742e-05, 6.715655e-05, 0.00012718071, -8.620813e-05, -6.0846523e-05, -6.0285038e-05, 2.1452206e-05, -7.268449e-05, 9.433636e-06, -5.8616184e-05, -4.2327127e-05, -7.35717e-05, 0.00019536584, -1.543272e-05, -7.779553e-05, 6.3102624e-07, -1.5897263e-05, -0.00035951444, -7.69953e-05, -0.00021505331, -0.00011030389, -0.00016065147, 0.00015174155, -0.00034508953, -9.852576e-05, 0.0001964764, 7.1425384e-05, 0.00017400736, -3.0342238e-05, -4.1294858e-05, -0.00015202728, 0.00014904361, 0.00019975202, 0.00026945063, -0.0001646682, -0.00020855371, -2.2821963e-05, -2.1783619e-05, -0.00011156108, 9.537096e-05, -0.0001998579, 0.00024314932, 4.833632e-05, 0.00016418482, -0.0003276703, -7.846629e-05, 8.833936e-06, -4.567001e-05, 0.00020636989, 4.0276667e-05, -1.9814193e-05, -0.00021572587, 6.2177e-05, 7.674361e-05, -0.0002466113, 0.00019653332, 3.774454e-05, -0.00013046371, -0.00010818421, 0.000108816894, -0.00058980705, -0.00018289336, 9.7152915e-05, -8.902903e-05, 0.00020063105, 9.239676e-07, -7.654688e-05, 8.668967e-05, -0.00017659813, 0.00027020217, 0.00032830282, -3.5089306e-05, -0.00010296545, -6.996186e-05, 6.684635e-05, -0.00015153796, 5.7854995e-05, -6.5349064e-05, 0.00017603741, 0.000109088716, 0.0002474314, -0.00022244231, -9.403475e-05, -0.00014450763, 4.9509163e-05, 3.8659105e-05, 0.00021335871, -0.00011408294, -4.4867553e-05, 5.931102e-05, 0.00010634147, 0.00030745205, -7.1953036e-05, 0.00026092256, -0.00020695766, 0.0004588561, 5.8375448e-05, -0.00025734497, 5.098808e-05, -0.00027092063, -0.00014685503, 0.00016729109, 2.1176127e-05, -6.451905e-05, 7.923497e-05, -0.00057793164, 5.34355e-05, -0.00011817902, 2.409953e-05, 1.261004e-06, -0.00021156645, 4.020009e-05, 0.0001400099, 0.00021193152, 2.5599924e-05, -0.0003408876, -0.00021822167, 2.3265413e-05, 2.542583e-05, 4.5102624e-05, -0.0001676796, -6.775833e-06, -0.00026758213, 0.00033669517, -0.00010520927, 0.00017537097, -0.0001259779, -8.2909755e-06, -0.0002555043, 0.0003406797, -0.00013923214, 0.00039237118, -0.0005803438, -0.00028368694, 0.0005301585, 6.152159e-06, 0.000105953775, -0.000102516104, -0.0003663779, -7.7845994e-05, 0.00014174166, 6.79926e-05, 0.0006082825, -0.00021089961, 0.00011760523, 8.146943e-05, 3.4859815e-05, 0.00025478107, -2.9025352e-05, -2.7342961e-05, -0.00039610933, 0.00019919398, 0.00021320298, 0.00028615326, -0.0001451368, 0.00012639648, -8.655669e-05, 0.00033146303, 0.00017651515, 0.00024735587, -0.0005057285, -2.7339347e-05, -0.000105803825, 8.398033e-05, 1.9631101e-05, 8.4227875e-05, 0.00025157176, 0.00021616173, 3.491198e-05, 1.391561e-05, -7.719559e-05, -6.724851e-05, 3.1403238e-07, -3.811564e-05, -2.296303e-05, -3.1345193e-05, 5.719782e-05, -1.4213728e-05, 0.00017121348, -0.0001442579, -5.4518132e-05, -7.41199e-05, 8.6432156e-05, 9.797978e-05, 7.728059e-05, 3.6027428e-05, -6.539434e-05, -6.283282e-05, 0.0001560894, -5.780053e-05, 1.1384194e-05, 3.6297493e-05, 0.00018232307, 5.3003787e-05, -7.901008e-05, 4.490634e-05, -0.00015037866, 2.3421693e-05, -4.835186e-06, 7.00016e-05, -2.2796187e-06, -1.603659e-05, 0.00023383423, -0.00011262898, 2.2544067e-05, -2.1998092e-05, 0.000231506, 8.324464e-06, 0.00010300723, -2.35068e-05, -6.3128e-05, 1.6702521e-05, -4.3914803e-05, 6.7705055e-06, 1.5633785e-05, 0.00010064521, -0.00020093948, 2.4726899e-06, -0.00014409095, 8.109753e-07, 4.7486177e-05, -5.055272e-05, -2.7490867e-05, 6.0562772e-05, 3.051154e-05, 1.3727045e-05, -0.00010119698, -7.308524e-05, -4.2389795e-05, 4.6322977e-05, 2.4642131e-05, -1.3859405e-05, -6.226169e-05, -5.3758406e-05, 7.942955e-05, 2.6905755e-05, 0.00014576163, -6.9323454e-05, -1.7640477e-06, 5.9419904e-07, -0.00021610064, -0.00012166913, -6.138956e-05, 7.3576804e-05, 5.4008924e-05, 9.9995e-05, 3.9646384e-05, -0.00011611932, 7.0882843e-06, 7.667673e-06, -8.269108e-05, 5.1890645e-05, -0.000117185344, 9.875636e-05, -1.9761941e-05, -1.1696352e-05, -7.252675e-05, -7.820056e-05, -0.00013948216, -4.461759e-05, 0.00010799966, 0.00010575196, -8.3562016e-05, -7.478607e-05, -0.0001449872, -9.934048e-05, -0.00016090756, -7.854022e-06, 0.00012554228, -2.9503359e-05, 5.3622323e-05, -2.3849932e-05, -2.8897826e-05, -9.111189e-05, -1.17326745e-05, -1.0177648e-07, -0.00018071677, 5.8946298e-05, -6.901102e-05, -1.6625709e-05, -0.0001787917, 2.6467846e-05, -0.00014119425, -8.597965e-05, 0.00015517039, 1.634484e-05, 5.597489e-05, 5.0911367e-06, -6.1031847e-06, -4.2270262e-06, 7.066511e-05, 0.00012093347, 0.00013686132, -1.0124279e-05, -1.2022781e-07, 4.754444e-05, 1.0158887e-05, -9.357703e-05, -4.4572917e-05, -4.958294e-05, 0.00019531329, 0.00013584447, 6.909942e-05, -7.4483876e-05, -4.8078968e-05, -6.5408574e-05, 1.6843436e-06, 0.000113942406, -3.3043856e-05, 1.1231326e-05, 1.2288815e-05, -6.83821e-05, -0.00014945884, 8.615006e-05, -0.00025840686, -0.0001070557, -4.0604642e-05, 0.00011962054, 6.650835e-05, 9.780413e-05, -1.4963631e-05, 5.653715e-05, 0.0001408855, 2.2166003e-05, 1.0932826e-05, -1.1954606e-06, -9.7903525e-05, 5.8360325e-05, -3.3440654e-05, -0.00012625394, -2.5443216e-05, 3.1135085e-05, -1.28482e-05, -4.928869e-05, 1.9108022e-05, 9.754994e-05, -0.00016736581, -3.5302186e-05, -3.1991713e-05, -6.860096e-05, -8.547018e-06, 4.4457316e-05, -4.381707e-05, -0.000106933745, 5.4224215e-06, 1.6181779e-05, 0.00013238277, 0.00016179359, 1.34194015e-05, -3.6896126e-05, 0.0002560572, -0.00022927337, 1.48118e-05, 2.0789059e-05, 0.00023598336, 1.0226204e-05, 0.0002688737, 0.00011325003, -6.92859e-05, 7.226825e-05, -7.5113494e-05, 3.1794272e-05, -3.4046934e-05, -6.2917556e-05, -6.129658e-05, -0.00012059103, -0.0002005029, -2.0091673e-05, 4.3912936e-05, -3.267453e-05, -1.0204177e-05, 0.00013718718, 3.3024146e-05, 1.0016085e-05, -0.00013837691, -0.0001029367, -0.000117370975, 0.00013513309, 0.00011228263, 7.403898e-05, -7.637044e-05, -0.00011386479, 5.6601616e-06, 5.04232e-05, 2.375562e-05, 7.3023795e-05, 0.00010772177, 6.0854843e-05, 0.0002492866, 0.00016255019, 5.8488728e-05, -4.7392725e-05, -0.00011420673, 7.75913e-05, 3.0350144e-05, -0.0001395673, -8.891227e-05, -8.53671e-05, -7.042955e-06, 2.0448959e-05, 0.0001095786, -5.054661e-05, -7.7839606e-05, 2.4471088e-05, 9.901061e-05, 8.412263e-05, -8.292133e-06, 6.074612e-05, 2.90143e-05, -8.6539905e-05, 0.00021291745, -7.553351e-05, -5.066845e-05, -9.1670645e-06, 0.00012750858, 2.6494217e-05, 2.6169366e-05, 0.00010927281, -9.704712e-05, -3.3713757e-05, -9.117594e-05, -0.00014267156, 3.7646525e-05, 1.5671692e-05, -0.00014076095, 0.00010896831, 2.4674653e-05, -6.128221e-05, -4.927509e-05, 2.4206887e-05, -0.00034343652, -4.187426e-05, 0.00011594893, -5.74042e-05, 0.00013728524, 5.6804107e-05, -6.902249e-05, 3.753056e-05, -8.840864e-05, 0.000120479344, 0.000101753416, -2.657484e-05, -6.702456e-05, 2.287326e-05, 1.6258451e-05, -0.00011844566, 1.8771969e-05, -3.091003e-05, 7.213259e-05, 0.00011100879, 0.00012832199, -5.2461237e-05, -3.216079e-05, -0.00010727281, -7.233143e-07, 8.518987e-07, 6.325632e-05, -5.384369e-05, 6.464407e-05, 2.3072862e-05, 1.3424064e-05, 0.00031176876, -0.000101602825, 0.0001275647, -4.533889e-05, 0.0002803327, -3.0131512e-06, 0.00015941028, 4.3184467e-05, -0.0001663289, -3.5316318e-06, -1.6585682e-05, 1.34536e-05, -1.3458926e-05, 1.0527589e-05, -0.00016780624, -0.000101468024, -0.00020031772, 3.7800193e-05, 9.4342664e-05, -9.021396e-05, 5.910161e-06, 0.00013093102, 8.5335e-05, 6.8414185e-05, -0.00019564046, -0.00016263087, -9.612022e-05, 0.00016538004, 9.2330745e-05, -9.006812e-05, -1.3120568e-05, -0.0001780918, 9.067751e-05, 5.146872e-05, -2.0769852e-05, -6.0515827e-05, 7.631191e-05, -9.276636e-05, 0.00022757651, 2.2444272e-05, 8.6884866e-05, -0.00015909428, -7.9124184e-05, -5.2866108e-05, -8.224749e-05, -1.0558499e-05, -0.00016673167, -6.642846e-05, -6.535707e-05, -1.2972354e-05, 0.00012819956, 3.3354783e-05, 8.761774e-06, 0.00024409937, 2.739325e-05, -2.0526206e-05, -1.6612992e-05, 2.3840556e-05, 1.7276627e-05, -0.00013386215, 3.3305976e-05, 4.904271e-05, 0.00014342766, 6.0284772e-05, -6.072517e-05, -8.3170205e-05, 4.6825982e-05, 0.00010010618, 4.3009775e-05, 4.3648674e-06, -0.000111027686, -0.00017737116, 2.4023875e-05, 4.494626e-05, -0.00012621537, 0.00012312291, 6.619797e-05, -0.000106135696, -1.9140482e-05, 3.9795184e-05, -0.00033483686, -0.00010284036, 9.1793496e-05, -1.3699848e-05, 0.00013089372, 4.9096134e-06, -9.232696e-06, 0.00011894634, -0.00029102503, 0.00019861586, 0.00013756518, 3.3053642e-05, -6.2077975e-06, 2.3329996e-05, 1.9296256e-05, -9.792427e-05, -9.954316e-06, -2.643021e-05, 3.9173505e-05, 0.000105481486, 0.00015962192, -0.00010248856, -7.323886e-05, -0.0001464148, -2.9220107e-06, 1.8147815e-05, 0.0001490939, -6.580263e-05, 0.00010924196, -5.108341e-05, -3.0563195e-05, -0.00021299203, -3.9723433e-05, -0.00024469153, 0.0001288488, -0.0003228183, -1.9695002e-05, 0.00026322098, 3.0158111e-05, 7.151193e-05, 5.4572887e-05, -9.336633e-05, -4.733822e-05, 9.383925e-05, -0.00018109125, 0.0004934735, -6.3525134e-05, 7.005802e-05, -2.4072182e-05, -2.9111372e-05, 4.908368e-05, -2.3877503e-05, -2.9808361e-05, -9.170399e-05, -3.6120746e-05, 0.00018632862, 3.6582845e-05, -9.3021255e-05, -0.000102677375, -4.8721577e-05, 0.00016349381, 3.9941413e-05, 0.00021793599, -0.0002846214, 3.3593977e-05, 9.987088e-05, 3.8612103e-05, 3.695392e-05, 0.00029735581, -3.8445738e-05, 0.00012275805, -4.8711667e-05, 0.00026130516, -2.2817168e-05, 0.00021637091, -3.6657657e-05, -0.00015602875, -6.351264e-05, -6.7756024e-05, -6.529622e-05, 2.5877307e-05, 0.00011238174, -0.00027877287, -6.109621e-05, -6.351772e-05, 5.6053224e-05, 6.360259e-05, -0.000105488885, 1.8220395e-05, 0.00019201534, 1.6645197e-05, 9.795069e-05, -0.00023248974, -0.000119653116, -7.895044e-05, 6.827033e-05, 3.5849032e-05, -4.3966782e-05, 3.697325e-05, -0.00015543205, 0.0001534381, -3.8688344e-05, -4.1699328e-05, 7.8119774e-05, 0.00019398877, 0.0002171414, 0.00040389178, 0.0003353396, 0.00012705995, 0.00010599464, -0.00018863553, -1.2541139e-05, 6.550061e-05, -0.00019377713, -0.0002405049, -0.000121365694, 5.4249827e-05, -2.7281798e-05, 0.0002871808, -0.0003943062, -4.920585e-05, -7.0441296e-05, 0.00016637791, 0.00011782946, 5.3858406e-05, 8.123462e-05, 2.930262e-05, -0.00014426131, 0.00030279846, -0.00016794763, 1.5074784e-05, 6.21972e-05, 0.00027470826, 2.3157074e-05, -1.7722085e-05, 0.00011318078, -0.00018068308, 7.703531e-05, -0.00012318588, -1.8075656e-05, 3.778469e-05, -3.7588772e-05, 4.780714e-05, -4.4875986e-05, 1.9094088e-05, -3.062749e-05, 7.136653e-05, 1.4923806e-05, -3.2339387e-05, -7.2066323e-06, 4.7813723e-05, 4.7302103e-05, 2.3002582e-05, 5.983779e-05, -4.4327673e-05, -2.8820547e-05, -2.4436087e-05, -1.31914685e-05, -9.7868535e-05, 8.921728e-07, 2.1395052e-05, 2.7118876e-05, 3.3414985e-06, -3.1116924e-05, 5.1906965e-05, -6.834948e-06, -3.8857513e-07, -1.8189636e-05, -6.204232e-06, 6.493619e-05, 4.8496142e-05, -5.465506e-05, -4.4725744e-05, -2.8620078e-05, 9.859794e-06, 6.259212e-05, 0.00026386423, -5.3026244e-05, -0.00012633628, 0.000309731, -0.00030474053, -9.618621e-05, 0.00010190223, 0.00017657639, -6.163547e-05, 0.00066579774, 9.755451e-05, -5.6062694e-05, 0.00014858805, -0.0001915576, -1.46639295e-05, 7.646482e-05, -8.385441e-05, 0.00011415923, -0.000248437, -0.00034314362, 3.210036e-05, 0.000118099546, 3.9880684e-05, -7.826912e-05, 0.00019324063, -3.814442e-05, 3.9269107e-05, -0.00019736173, -0.00010686474, -0.00028510866, 0.00018198625, 0.00011555786, 0.00012808197, -8.8351604e-05, -4.505076e-05, -0.00017133084, 0.0001282522, -4.4476878e-05, -2.3635997e-05, -7.805734e-05, -0.00031790385, -1.4527372e-05, -0.00015045214, -1.28743195e-05, -0.00028088005, 4.2927633e-05, -0.00011758032, -1.9754357e-06, 0.00015118004, 4.1622716e-05, 8.8721754e-05, -9.593226e-07, 1.7428772e-05, -0.00017271459, 0.00032244256, 4.2522763e-05, 0.00012593657, -6.5858185e-05, -0.00011316989, 6.474584e-05, -1.4349971e-05, -9.966574e-05, 1.5121022e-05, -0.00010699504, 0.00017056454, 0.000102280464, 8.567595e-06, -0.00015528401, -6.505046e-05, 6.2532046e-05, 2.0206096e-05, 0.00015499233, -0.000120278426, 8.783908e-06, -0.00012626564, -9.2921095e-05, -0.00012507792, -0.000614909, 7.9906604e-05, -0.00026437538, 0.00015974882, -0.0006716076, 1.4584054e-06, 9.283915e-06, 7.879486e-05, 0.0004165147, 0.00018024001, -1.8484499e-06, 3.784209e-05, 6.2291365e-05, -0.00030318258, 0.0007249115, 6.046975e-06, 0.00013941793, -6.013593e-05, -7.97235e-05, 0.00033561265, -5.4802193e-05, -0.00027131953, -0.0001785339, -0.00017910957, 0.00048418, 0.00030029065, 4.824853e-05, -7.617736e-05, -0.00010765114, 9.495138e-05, 2.9089419e-05, 0.000402539, -0.00044112193, 0.0001662119, 5.2665924e-05, -3.4300547e-06, 2.1286209e-05, 0.00020209268, -9.922989e-06, 6.0785642e-05, 0.00014054679, 0.00013067872, -0.00010618827, 0.00033650786, 0.00020574214, -0.00014965165, 7.013963e-05, -0.00014689936, 3.07371e-05, 0.0001052619, -2.4234383e-05, -2.4597872e-05, -0.00016958319, -0.0003461841, 8.675296e-05, 0.00016990259, 0.00011109297, -5.033003e-05, 1.1331477e-05, -4.4917942e-05, 9.460006e-05, -0.0001456982, -0.00017390845, -0.00010046051, 0.00024214039, 8.748967e-05, 6.501228e-05, -4.7979804e-05, -4.7711772e-05, -0.00017661336, 0.00012082685, -0.00013248395, 3.611968e-05, 6.949518e-05, -0.00030485177, 0.00023221354, -4.003876e-05, -2.4988717e-06, -0.00024810663, 2.3891664e-05, -0.00041410216, -0.00010865385, 0.00015105204, -7.2624134e-05, 0.00010942462, 2.8247943e-05, -9.260223e-05, 7.8419806e-05, 3.0596002e-05, 0.0001795524, 0.00032857835, -5.521936e-05, -0.00011258074, 2.5736806e-05, 4.0591327e-05, -0.00015462982, -6.8942645e-05, 9.794247e-06, 0.00023591187, 0.00018505284, 0.0001915626, -0.00013059597, -7.8137e-05, -6.2173053e-06, 5.2008403e-05, 9.3869356e-05, 2.7566548e-05, -0.00013596266, -0.00022342612, -1.8655108e-05, -0.0001324846, -0.00043416535, 0.00012036985, -0.00013989829, 2.2274713e-05, -0.00040296058, 2.2436658e-05, -0.00021908242, -7.794699e-05, 0.00039589577, 0.00016299293, 6.606902e-05, 6.258437e-05, -8.074099e-07, -9.573567e-05, 0.00031325748, 0.000110974484, 0.00014117273, -1.2566881e-05, -4.2657237e-05, 0.00023621801, -1.1513981e-05, -0.00029132038, -9.129288e-05, -0.00015994122, 0.00034926657, 0.00027936205, 0.00016104117, -8.327509e-05, -5.579881e-05, -9.9603174e-05, -2.9895855e-05, 0.00022306878, -0.00015431513, 0.00012951059, 3.902253e-05, -0.00010013614, -2.1473223e-05, -3.094322e-05, -5.764215e-05, -0.00013146513, 1.0294781e-06, -1.8167128e-05, 3.104805e-05, -8.4987994e-05, -0.00012512875, -3.4266193e-06, -6.8784204e-05, -1.7749286e-05, -6.9465335e-05, -5.245903e-05, 7.559844e-05, 8.419508e-05, 5.1267187e-05, 0.00020827257, -7.40248e-05, -0.00011488574, -0.00010466441, -1.6583994e-05, 3.4590943e-05, 5.618525e-06, -8.633585e-05, 4.4962748e-05, 7.341621e-05, 4.207307e-05, -0.0001575881, -8.145778e-05, 7.239288e-05, 9.715369e-07, 6.321306e-05, 9.284028e-05, -6.8414025e-05, 0.0001515504, 2.0694111e-05, 1.02756885e-05, 0.00017718089, -7.112058e-05, -4.85797e-05, 1.8361996e-05, 0.000106766995, -1.9647287e-05, 0.00023464538, -6.507547e-05, -7.0428505e-05, -3.7515532e-05, -9.143724e-05, -4.9091628e-05, 1.6108934e-05, 4.7240508e-05, 9.100946e-06, -5.5783847e-05, 2.0353134e-05, 3.0703177e-07, 2.8783945e-05, -0.0001318421, 1.3049426e-05, 0.00011288818, -1.4618466e-05, 3.9525443e-05, -7.380718e-05, -6.253711e-05, -9.791159e-05, -2.5431513e-05, 3.087228e-05, 3.1524894e-05, 1.1322378e-05, -4.4327302e-05, 1.4849363e-05, -4.407912e-05, -6.780431e-05, 0.00013084877, 0.00010582417, 0.00050075597, -0.00019040813, 0.0004035484, -0.00028060167, 0.0006705999, 0.00012721475, -0.00020371079, 0.00010806266, -0.0003925726, -4.7058573e-05, 0.00017096146, 1.7868762e-05, -3.614909e-05, 8.937935e-05, -0.0007952882, 4.766242e-05, -0.00030145084, 6.0304843e-05, 7.2070936e-05, -0.0002114962, 6.4595595e-05, 0.0002006757, 0.0003113947, 7.350124e-05, -0.00047757878, -0.00036717052, 2.2801814e-05, 0.00011220479, 9.549556e-05, -0.00022903597, -6.497921e-05, -0.0004217868, 0.00052128464, -2.9480036e-05}},
    {"bert.encoder.layer.2.output.dense.bias_grad", {-0.001371546, 0.001489157, -0.0007347015, -0.0049441685, 0.0031250021, 0.00032142733, -0.0117126405, 0.01458511, -7.441617e-05, -0.0046393573, -0.0011912996, 0.0027483068, -0.0023575367, -0.0039138487, 0.0015199606, 9.528891e-05, -0.0064888466, 0.0028178347, -0.0014149504, 0.008110492, -0.0064378805, -0.0015559314, -0.0016047853, -0.0024853516, 0.0058039087, 0.015625697, 0.0005605989, 0.004300374, 0.008456991, -0.0003007004, -0.0023465941, -0.015985593}},
    {"bert.encoder.layer.2.output.LayerNorm.weight_grad", {-0.0022015278, -0.0016190947, 0.0010854099, 0.002497902, 0.0039268862, 0.0026741538, -1.6201746e-05, -0.00077170983, -0.002901324, -0.0022070054, 0.0012788924, -0.00039067946, -0.0023230105, -0.00040014047, -0.0028182194, -0.00038604223, 0.0016352248, -0.00022181156, -0.0028989473, -0.00023309782, 0.0050923945, -0.0046770656, -0.0004382672, -0.0020319792, 0.0007832764, 0.00321557, 0.00050152757, -0.0019571327, -0.002430371, 0.0014185118, 5.504927e-05, 0.0067611155}},
    {"bert.encoder.layer.2.output.LayerNorm.bias_grad", {-0.0013802076, 0.001481538, -0.0007351146, -0.0049555656, 0.0031112167, 0.00031057277, -0.011717005, 0.014574576, -8.286875e-05, -0.004639906, -0.001199301, 0.0027334362, -0.002368673, -0.003919624, 0.0015150821, 7.9332065e-05, -0.006487628, 0.0028119255, -0.0014249185, 0.0081090545, -0.0064506666, -0.0015597928, -0.0016200972, -0.0024895782, 0.005792449, 0.015613063, 0.000563331, 0.004293361, 0.008448608, -0.0003114559, -0.0023522992, -0.015992207}},
    {"bert.encoder.layer.3.attention.self.query.weight_grad", {-4.3061982e-07, -2.4688455e-07, -1.17964916e-07, 7.5904154e-07, 1.3757952e-07, 5.16419e-07, 9.9990636e-08, -1.3392312e-06, -2.5420418e-06, 7.63806e-07, 2.452779e-07, 9.882851e-07, 1.3189883e-07, 8.98901e-07, 9.5226545e-07, -1.8108601e-06, 9.571015e-07, 7.2953554e-07, 1.9311854e-06, -2.241597e-07, 5.6491846e-08, -1.0413711e-06, -5.3502725e-07, 6.615665e-08, -5.759316e-07, -3.4330318e-07, -1.4021347e-06, -5.880142e-07, 1.1849662e-06, -3.8988946e-07, 2.5001236e-07, 9.185192e-07, -3.7764045e-07, 1.0300563e-06, 7.925401e-07, 3.841194e-07, 1.2162753e-06, 2.8582303e-07, -7.3065297e-07, 4.449762e-08, -1.5673634e-06, 5.6290924e-07, -4.891553e-07, -4.2651496e-07, -1.7093325e-07, -6.6580594e-07, 1.5380066e-06, 5.0871602e-08, -1.0903681e-06, -9.208173e-07, 6.630263e-08, 3.0778764e-07, -1.3247792e-06, -3.9372014e-07, 7.9700413e-07, 6.1289114e-07, 2.2822151e-07, 4.619825e-07, -1.1320388e-06, -6.813559e-08, 4.4193212e-07, 4.6077972e-07, -1.2482071e-06, 1.3241287e-06, -8.2768645e-07, 5.143138e-07, -3.8614118e-08, 1.3414399e-06, -3.9275494e-07, 1.3719253e-07, 9.814713e-07, 9.853076e-07, -1.2129585e-06, -1.2583579e-06, -1.3490145e-06, 5.9945165e-07, 6.4467336e-08, -1.818306e-07, 1.2411351e-06, -2.2379318e-06, 2.0689602e-06, -3.0329016e-07, 2.2501958e-06, 1.2971411e-06, 2.0909451e-06, -8.518139e-07, -1.0839651e-06, -8.573111e-07, -9.884671e-08, -1.8852966e-06, -3.3629724e-06, -7.3911497e-07, 1.1267294e-06, 1.6538544e-07, 3.5071878e-07, 1.4669048e-06, 1.2512135e-07, -2.0418385e-07, 6.7584807e-07, 3.6817605e-07, 3.6158212e-07, 7.79805e-07, -3.7347147e-07, -8.740849e-07, -1.732009e-07, 1.3849684e-07, 1.9416016e-06, -2.5517755e-07, -2.961768e-07, 8.357533e-07, -6.090924e-07, -1.9621207e-07, -7.5418865e-07, -2.6036622e-07, -1.0848381e-06, -1.3724921e-06, -1.2990762e-06, -2.0745613e-07, 1.4894385e-07, 3.9238347e-07, -1.6591381e-06, 2.2265212e-06, 2.6071725e-06, 9.723109e-07, -5.072393e-07, -7.733309e-07, -3.345096e-07, -3.3948191e-07, -6.237224e-07, 1.3947292e-07, 1.1470948e-06, 1.7578992e-06, 3.9505176e-07, 3.482647e-07, 9.2498595e-07, 2.848461e-07, -1.620316e-06, -9.0149086e-07, -2.711787e-07, 5.638361e-07, -6.1240564e-07, -1.0486144e-07, 9.025058e-07, -2.0936443e-06, 7.712536e-07, -1.705472e-06, 9.919626e-07, 4.0896612e-07, -2.2640145e-07, -7.592146e-07, -1.4382559e-07, -4.0526194e-07, -1.3567326e-06, 1.8659655e-06, -2.9858288e-07, 4.9114965e-07, 1.5854934e-07, -4.1641872e-08, -7.186037e-07, 7.31556e-07, -1.077127e-06, 1.9554077e-08, -3.588955e-07, -1.6930703e-06, 2.3475073e-07, -6.0098166e-08, 1.0134088e-06, 1.4789005e-06, 1.6915622e-07, 1.0579105e-08, -2.2158506e-06, 6.0166536e-07, -3.3862527e-08, -1.2203923e-06, 5.3345804e-07, 6.934448e-07, 1.9523477e-06, -1.4555102e-06, 1.0787179e-06, 2.6320745e-06, 1.2155083e-06, -1.4500145e-07, -1.9142594e-07, -5.8264203e-07, 1.2775076e-06, -2.6241935e-06, -2.5166805e-06, -8.135414e-07, 8.496993e-08, 1.1383619e-06, 1.2931542e-06, -4.392673e-07, 1.1166338e-06, -5.807113e-07, -8.7227164e-07, -2.3832708e-07, -3.9306985e-07, -1.2149006e-06, -1.0086413e-06, 1.0637744e-06, 2.7787432e-06, 1.4819881e-07, 8.1867364e-07, -4.3917163e-07, 2.216475e-07, 4.3992195e-08, 5.954551e-07, 1.9486388e-06, -1.5505649e-06, -5.2854836e-07, -1.7412066e-06, -2.1038502e-06, 7.3475866e-07, 3.5278228e-07, 1.3402085e-06, -9.392538e-08, -1.22098e-07, 1.3788493e-06, 7.217691e-07, -7.312249e-07, -1.0276524e-06, 2.509459e-07, -3.164399e-07, -5.524673e-07, 1.9876497e-07, -5.7965633e-07, -1.2805571e-06, -3.070302e-06, -1.30914e-06, -1.4559428e-06, -3.2961938e-07, 9.939029e-07, 2.1078647e-06, 5.5734995e-07, -1.8524598e-06, 8.201722e-08, 1.2963077e-06, -1.0272751e-06, 1.8416633e-06, 2.7824935e-06, 8.780546e-07, -9.5549815e-08, -9.5103127e-07, 1.3935437e-06, 1.2848902e-06, -1.4619988e-07, 1.8755129e-06, 7.690434e-07, 1.6297455e-06, -2.6915304e-06, -2.1695037e-06, -1.4761338e-06, -5.427274e-07, 9.176787e-07, 8.848113e-07, -5.1601324e-07, -1.0150507e-06, -1.6331076e-06, 1.0951575e-06, -4.5102593e-07, -4.2342316e-07, -1.5876021e-06, -5.744203e-07, -1.9048497e-06, 3.09143e-07, -9.605749e-07, -2.5688337e-07, -3.9625394e-07, 1.1103986e-06, 6.1476925e-07, -1.8048088e-06, -8.7388975e-07, 1.330874e-06, -8.302344e-08, 1.0484739e-06, 1.5360151e-06, 2.1697479e-06, 4.4419681e-07, 3.140773e-06, -3.8844826e-07, -4.9303935e-07, 1.7954035e-06, 1.4360154e-06, 1.3562259e-06, 1.7751511e-06, -2.9052728e-06, -9.43899e-07, -2.466773e-06, -3.1522047e-06, 1.0275992e-06, -3.6117834e-07, 7.5219145e-07, 1.7350302e-06, -3.2564574e-07, 2.784313e-06, -3.0303048e-07, -8.355702e-07, -3.970241e-07, 4.5085866e-07, 9.796295e-07, 9.3224976e-08, 4.0302663e-07, 3.3007932e-06, -2.2226095e-06, 2.4102817e-06, 1.7499624e-06, -9.612282e-07, -2.3748087e-06, 1.2718239e-06, -1.6401971e-06, 4.0477263e-07, -2.700514e-06, -1.0965267e-06, 2.6177097e-06, -1.1379835e-06, 1.3475133e-07, 3.400221e-07, -7.3547756e-07, -2.4806118e-06, 2.6861846e-07, 1.015205e-06, -1.798876e-06, -7.686157e-07, -2.7702424e-06, -2.7972226e-06, 1.3709833e-06, -2.3998907e-06, -2.4862802e-06, -7.222519e-07, -3.2735605e-07, -7.977861e-07, -9.416741e-07, 4.128012e-07, 3.081681e-07, -4.052819e-06, 1.5150232e-06, 6.1395474e-07, -1.2618159e-06, 2.919013e-06, 4.7063404e-06, -9.898637e-07, 2.2683878e-06, 3.3746633e-06, 3.7782208e-06, 1.0604905e-06, -2.7365818e-06, 1.4107543e-06, 8.538258e-07, 5.793561e-07, -2.3649861e-06, 1.4282414e-06, -3.9916367e-07, -8.8075853e-07, 8.891848e-07, -1.3467762e-06, 1.3466105e-06, -1.1958443e-06, 1.0045796e-06, 9.116957e-07, 2.864683e-06, -1.6313447e-06, -1.9791028e-06, -2.4030695e-07, 1.5179567e-06, -1.2613425e-06, 1.08957764e-07, 3.0298936e-06, -7.8826605e-07, 1.108732e-06, 1.3306807e-09, 4.096844e-07, -8.318545e-07, 4.886623e-07, 4.3391378e-07, -1.6373157e-06, 1.6938827e-07, 5.1655763e-07, -2.0678199e-06, -1.8675015e-06, -1.3862305e-06, -8.528565e-07, 7.275327e-07, -5.842524e-07, 3.0222097e-06, 2.3607618e-07, -3.9165198e-07, 4.6077767e-07, -3.1668603e-07, 8.250254e-07, 4.4880525e-07, -1.052835e-06, -1.4381594e-06, 2.8999116e-07, 1.0771741e-06, 5.171421e-07, -6.584341e-08, 1.3796905e-07, -4.0401252e-07, -2.9483041e-07, -8.386376e-07, -4.247338e-07, 1.0991716e-06, -1.9639894e-07, -5.0588644e-10, -4.0668044e-07, 1.0144796e-07, 2.433794e-07, 1.3307649e-08, -3.7613395e-07, 3.9241712e-07, 1.5783987e-06, 6.387004e-07, -1.3853849e-08, -9.3605814e-07, 4.16836e-07, -1.3195977e-06, 2.708878e-06, -1.4183863e-06, -1.2797785e-06, -9.967279e-07, -1.5589343e-06, 1.9632785e-06, -1.5296702e-06, 3.9992062e-07, 1.5856339e-06, -2.3141965e-06, -1.6032725e-06, -2.0874388e-06, -2.1456328e-06, -5.199824e-07, -8.0050677e-07, 4.7619454e-07, -1.0182283e-06, 1.7050326e-07, 2.3012935e-06, 2.4763299e-06, -2.8718198e-06, 2.992982e-06, -1.9851288e-06, 5.054758e-06, 4.1634275e-06, -6.10084e-06, 3.1772245e-07, 1.5208743e-06, -1.3465616e-06, 1.4485289e-06, 1.5657597e-06, 4.310248e-07, 9.959095e-07, -3.7738587e-07, 3.2018363e-07, 3.2861124e-07, 4.0925755e-07, -7.992592e-07, -7.8355947e-07, -6.836438e-07, 8.723957e-07, 1.229592e-06, -3.1675097e-07, -5.7474847e-07, 1.2222002e-07, -1.647722e-07, -1.0359641e-06, 8.159812e-07, -1.4850468e-06, 2.578844e-07, -4.888569e-07, -2.3647107e-07, -5.9468243e-07, -7.690293e-08, 1.1490176e-06, 3.7109345e-07, 2.3438108e-07, 9.877141e-07, 4.1620623e-07, -4.2453055e-07, -2.0037837e-07, 9.3503e-07, 7.4380216e-07, -1.9463257e-06, -9.700764e-07, 5.6449653e-07, 1.1209504e-06, 8.633059e-07, 2.7621245e-06, -2.0740438e-06, 1.408104e-06, 6.517598e-07, 3.066404e-06, 4.0803232e-07, -5.0859647e-08, -8.778869e-07, 1.1430358e-06, -1.0832132e-06, 1.0876255e-06, 6.250374e-07, -1.791828e-06, -5.125646e-08, -3.392393e-06, -2.0518762e-06, 4.648792e-08, -7.943761e-07, 3.995075e-07, -3.2338505e-06, -5.0357585e-07, 4.8476436e-06, 1.437561e-06, -1.4447238e-07, -7.645153e-07, 1.469217e-06, -1.9306872e-06, -2.1863837e-06, -1.3015101e-06, 1.4536828e-06, 4.9656105e-08, -1.4760344e-07, -1.588569e-07, -3.8205528e-07, -1.6175045e-06, 3.667434e-07, 3.3351664e-06, -2.6936298e-06, 1.0624907e-06, -4.0737726e-07, -1.2817175e-06, -1.4404146e-06, 1.4164581e-06, 2.0293694e-06, 1.9864072e-07, -1.3971621e-06, -1.8662095e-06, -1.3455222e-06, 4.126316e-06, 7.911732e-07, 1.7586385e-06, -1.201577e-06, -1.3139571e-06, 7.366871e-07, 9.4886985e-08, 4.396839e-07, -3.6411532e-07, 2.5023539e-08, 4.528976e-07, -1.4182992e-06, -9.817379e-07, 7.7790673e-07, -5.1744416e-07, 1.1152271e-06, -3.1037395e-08, 2.0126085e-06, -1.97314e-06, -2.4709122e-06, -1.7031741e-06, 2.0836985e-06, -5.6989956e-07, 2.3686621e-07, 6.431134e-07, -2.3820412e-07, 2.697063e-07, 1.0179648e-06, -5.254039e-07, 9.736129e-07, 6.1802416e-07, 9.308197e-07, -3.140003e-07, 3.968662e-07, 4.030556e-07, 2.8744208e-07, -6.5677364e-07, -1.4661753e-06, 3.4503597e-07, -5.666391e-07, -2.7662819e-07, -8.5637333e-07, 8.4728924e-07, 1.8830465e-07, -4.7612113e-07, 3.6969516e-06, 2.2834454e-06, 2.465603e-06, -1.9013667e-06, 7.68736e-09, -2.1728496e-07, 2.7677886e-06, 6.744394e-07, -3.9364336e-06, -3.1943093e-06, -1.92787e-06, -2.9662153e-06, -4.965508e-07, -1.6236647e-06, 8.545445e-07, -1.3348154e-06, -7.182528e-07, 1.370987e-06, 1.298182e-06, 2.6939986e-06, 1.8524067e-06, 1.914023e-06, 8.987327e-08, 5.558096e-07, -3.2509813e-06, -3.86725e-06, 6.679646e-07, -1.1673818e-06, 2.41767e-06, 2.8708625e-08, 1.4384151e-06, 1.042892e-06, 2.274291e-06, 6.913726e-07, -9.3097236e-07, -2.8482586e-06, -2.598888e-06, 1.1983997e-06, 3.912581e-06, 3.3324025e-07, -5.9398335e-06, -3.2873974e-08, 3.6173438e-07, -3.103599e-06, -9.84882e-07, -1.422582e-06, 2.5559286e-06, 1.0448795e-06, -3.2040762e-06, 2.2961826e-06, 1.8080248e-06, 5.2257583e-06, 1.4739574e-06, 1.9462125e-07, -2.0915897e-06, -1.1433156e-06, -1.6436121e-06, -4.7875524e-06, 7.048361e-07, 3.445695e-07, 1.2593227e-06, 8.815152e-07, 3.1279274e-06, 1.7844251e-06, -1.6587766e-06, -1.7593995e-06, -1.5174138e-06, -1.6508129e-06, -1.1683903e-06, 1.2207279e-06, 3.3264035e-07, 1.9757733e-06, -1.6895406e-06, 2.4770545e-06, 1.9198481e-07, -1.2452209e-06, 7.2877235e-08, 1.3028914e-07, 1.4788676e-06, 1.8774516e-06, 6.316146e-07, -1.2487569e-06, -1.3492827e-06, 1.226201e-06, -1.3783468e-07, 1.0439959e-07, -2.3283366e-07, 1.0397894e-06, 7.7136536e-07, -1.7440617e-06, -1.2579386e-08, 2.2027738e-08, -5.3807643e-08, 8.5957873e-07, -7.2835763e-07, -1.13790016e-07, -5.4968655e-07, -8.9404415e-07, 9.716484e-07, -9.145169e-07, 8.9411526e-07, 3.019213e-07, -3.110776e-07, -2.197061e-06, -7.465663e-07, -1.728301e-06, -3.349934e-07, -5.1154507e-07, 2.086538e-06, -2.02609e-06, -3.0436872e-06, 1.3956367e-06, 7.6191327e-07, 3.8978324e-06, 2.3178943e-06, 9.38693e-07, 1.8954101e-07, 2.692255e-07, 1.1289693e-06, 2.2079464e-06, -3.6686072e-06, -2.9645414e-06, 3.965237e-07, 1.8184115e-06, -8.5367066e-07, -7.7901866e-08, 1.3592713e-06, 1.04692226e-07, -1.3463493e-06, -1.3025357e-06, -2.3134796e-06, 1.5821896e-06, -1.6983824e-06, 1.4287202e-06, -2.048057e-08, 1.7492667e-06, 1.391696e-06, 1.5771332e-06, 1.1525437e-06, 1.0783974e-06, -7.651145e-07, 1.6809986e-06, 2.8074985e-06, -1.3056238e-07, -1.1121103e-06, -2.8044549e-06, -1.3197478e-06, -1.6452022e-06, -9.805377e-07, 9.5989044e-08, -1.9978825e-06, -1.1559616e-06, 3.996492e-06, 1.2963347e-06, -1.3936817e-06, -4.3336587e-07, 1.6378824e-06, 2.0422775e-07, -1.3642143e-06, -8.583029e-07, 5.9838726e-07, -2.1635609e-07, -1.0700694e-06, -3.5566867e-07, 3.1686432e-07, 2.318488e-06, 2.6194941e-06, -3.8892126e-06, -1.7658485e-06, -2.119753e-06, 1.580999e-06, -9.237009e-07, 2.2515035e-06, -5.386619e-07, -1.9711208e-06, 2.289623e-06, -9.78971e-07, 4.671686e-06, 3.1244217e-06, 1.6874e-06, -2.2100772e-07, -1.0554663e-06, -1.4115735e-06, 5.261295e-07, -4.2337015e-06, -4.9239275e-06, 4.8272625e-07, 1.2355392e-06, -8.6255403e-07, 5.511405e-07, 3.1414932e-06, 1.5625985e-06, -4.9217317e-07, -8.8826866e-08, 1.0563687e-06, 7.6873863e-07, 3.6103916e-07, -1.1606829e-06, -6.477542e-07, -6.8390574e-07, -4.3228079e-07, 1.7370651e-07, -2.5872362e-07, -2.6936682e-08, 2.053412e-06, -1.3658935e-06, -9.1458355e-07, -5.503815e-07, -3.9956234e-07, 5.107783e-07, -1.3673775e-06, -1.7994347e-07, 1.1883214e-06, -4.96795e-07, 9.904173e-07, 2.1804288e-08, 3.1499786e-07, 7.4623404e-07, 3.740637e-07, -3.3084337e-08, -7.421517e-07, -5.4090435e-07, 2.5948162e-07, 6.1340336e-07, 1.08378586e-07, 1.153481e-06, 7.6664764e-07, 1.5675316e-06, 9.760342e-07, -5.446265e-07, -9.859988e-07, -2.3354005e-06, 5.687527e-07, -2.4783301e-07, 3.7740552e-08, -4.0998376e-07, 9.152568e-07, -6.0538736e-07, -6.3936034e-07, -8.736516e-07, 4.723384e-07, -7.503975e-08, 5.559449e-07, -2.450249e-06, 1.6642971e-07, -8.8045095e-07, 6.502172e-07, -5.661871e-07, 1.0005981e-06, 6.8614946e-07, 1.1028457e-06, 2.7814076e-07, -8.666012e-07, -8.444994e-07, 7.0537897e-07, 8.692826e-07, -2.7300285e-07, 3.4196023e-07, 8.3461777e-07, 3.7874517e-07, 6.4722224e-07, -1.1772252e-06, -6.096698e-07, -2.376941e-06, 1.487145e-06, -1.1015862e-06, 9.566121e-08, 1.3907145e-06, 3.9052924e-07, -6.2417746e-07, -9.629454e-07, -1.5256668e-06, 1.6048921e-06, -2.832993e-07, -4.3206254e-07, -2.7507863e-06, -1.7957335e-07, 4.1583263e-07, 1.1912929e-06, -7.288572e-07, 1.5415476e-06, 9.267678e-07, 1.6304608e-06, 7.651283e-07, -1.7553219e-06, -1.1372521e-06, 1.4065661e-06, 2.173932e-06, -8.205305e-07, -5.2465924e-07, 4.2216857e-06, -1.4246706e-06, 2.2114318e-06, -1.9556094e-06, -3.1303164e-06, -1.5330766e-06, 1.1973833e-06, 5.313732e-07, -3.3407576e-07, 3.2181522e-06, 7.0939484e-07, 2.2806676e-06, -2.737955e-06, -7.200992e-07, 2.785453e-06, -1.8993034e-06, -3.0993684e-07, -3.593768e-06, -1.5811568e-06, -1.2113162e-06, 2.9177181e-06, 8.793527e-07, 1.1653019e-06, 1.718491e-06, -4.128945e-07, 2.136493e-07, -4.807721e-06, -1.6284226e-06, 2.401524e-06, -7.6264257e-07, 1.5466054e-06, 1.1018363e-07, -8.15308e-07, -9.659489e-07, 1.5101755e-07, 1.3782814e-06, 1.5202145e-06, 5.2125023e-07, -1.4899406e-06, -1.4937017e-06, -3.4184748e-07, -1.2514073e-06, -3.509018e-07, -7.9991e-07, 1.1893096e-06, 3.158628e-07, -2.1674302e-07, 1.5196898e-06, 1.2091417e-06, 7.8279317e-07, 6.643912e-07, 1.9090213e-07, -8.540513e-07, 7.09572e-07, -2.409857e-06, -2.6520966e-06, -3.001977e-07, -2.6817942e-08, 1.9333456e-06, 4.8496435e-07, 5.038457e-07, 2.3774187e-06, -2.7307658e-06, 4.0133122e-07, 2.5398896e-07, -7.677239e-07, 2.053351e-06, -1.3795947e-06, -9.655364e-07, -1.9592044e-06, 3.1919475e-07, 4.9556223e-07, -8.352368e-07, 8.8327215e-07, 1.5220799e-06, -2.741348e-06, -3.4389204e-06, -1.8456016e-07, 9.398211e-07, 8.953056e-07, 6.610964e-07, -4.590009e-06, 8.195071e-07, -4.070438e-07, 4.71324e-06, 2.1816522e-06, -2.9909452e-07, 3.3805518e-06, 2.7947501e-06, 1.18457514e-07, -3.710838e-06, -6.521795e-07, -1.4852439e-07, 2.3369923e-07, 6.7003896e-07, -2.884002e-07, 6.91288e-07, 2.0838681e-06, -5.8560786e-08, 2.0757338e-07, 9.016261e-07, -1.3187793e-06, -6.580391e-08, -3.2899754e-07, 1.2372169e-06, -8.9198744e-07, 1.4079171e-06, -1.1176401e-06, 2.773244e-07, -3.288954e-07, -5.9601075e-07, 1.2814842e-06, -2.1555309e-08, 1.5026509e-06, 6.3023185e-07, -1.6541464e-06, -1.788296e-06, -1.2889013e-06, -1.02447e-06, -9.44891e-07, -5.7733894e-07, 7.0207244e-07, -4.292466e-07, 1.6549797e-07, 7.3143184e-07, -3.497376e-07, 1.4974827e-06, -1.898235e-07, 2.9287466e-07, -8.697536e-07, 1.3457228e-07, 1.4098821e-06, 8.4658194e-07, 2.5601623e-06, -1.9353654e-06, 8.2469946e-08, -9.578998e-07, -1.8004777e-06, -5.701819e-07, 2.9061667e-07, 8.88047e-07, 4.0898558e-07, 2.2390144e-07, 5.1656076e-07, 2.0123836e-07, 1.5688951e-06, 4.0988334e-07, -1.262524e-06, -6.667654e-07, 1.1550792e-06, -2.2548795e-06, -2.6009764e-06, -1.0368811e-06, -9.3245416e-07, 2.4250958e-06, 4.0450055e-07, 1.10891406e-07}},
    {"bert.encoder.layer.3.attention.self.query.bias_grad", {-1.7317752e-06, 5.260034e-07, -3.8041708e-06, 1.3360445e-06, -1.3978178e-06, -9.963713e-07, 1.2775556e-06, 5.323583e-07, 1.688783e-08, -3.4408033e-06, 2.5990805e-06, -2.8404359e-06, 9.920725e-07, 7.569619e-07, 2.0739021e-06, 5.558684e-07, -5.622681e-07, 1.2942032e-06, -1.0686506e-06, -4.029108e-06, -8.359159e-07, -2.481688e-06, 1.1594736e-06, -4.5986226e-06, 4.5536154e-07, 1.480933e-06, 1.8517617e-06, -9.335727e-08, -1.0732598e-06, 1.8835524e-06, -6.2646075e-07, -2.0991602e-06}},
    {"bert.encoder.layer.3.attention.self.key.weight_grad", {1.189412e-06, 1.935832e-06, 1.7556331e-07, 6.5640455e-07, -7.109539e-07, -3.0089456e-07, 5.4894866e-07, 1.949741e-06, 2.1364324e-06, -4.087769e-07, -2.5813466e-07, -9.490063e-07, -1.4799248e-06, -3.502434e-07, -1.5330986e-06, 1.3352924e-06, -2.7859392e-06, 3.499403e-07, 7.451938e-07, -7.368571e-07, 1.807208e-06, 7.152544e-07, 2.4584762e-07, -2.1696503e-06, 1.3277888e-06, -1.5545512e-06, -6.1229537e-07, 6.505025e-07, -1.5617942e-06, 6.667378e-07, -6.1427286e-08, -9.625536e-07, -1.3995744e-07, -1.6396115e-07, 6.044101e-07, -3.722478e-07, -3.0761993e-07, -2.5753272e-07, -2.865871e-07, 1.7893865e-07, 6.245653e-07, 1.0203142e-07, -2.574867e-07, -3.0544288e-07, 1.7867917e-08, -3.6517363e-07, -9.23497e-07, 3.8617986e-07, -1.8654606e-07, -8.247465e-07, 4.2211246e-07, 7.893265e-07, 6.2649825e-08, 3.69362e-07, 6.3897625e-07, -5.167174e-08, -2.593573e-09, 2.7441214e-07, -8.6012756e-07, 2.5587985e-07, 2.925148e-07, 3.9264353e-07, 1.367372e-07, -2.4341543e-07, 3.501486e-08, 9.865223e-07, 8.1906177e-07, -1.2124899e-06, -8.2572063e-07, 7.5286823e-07, -1.3767321e-06, 9.053347e-07, 9.547015e-07, -1.1030938e-06, 2.889109e-07, -1.0476103e-07, -6.304193e-07, -1.0794151e-06, 9.588379e-07, -2.418495e-08, -1.2123186e-06, -2.3366545e-06, -5.633056e-08, 5.9404704e-07, 2.45196e-06, 1.7572037e-07, 1.0165397e-06, 7.7050345e-07, 4.4944278e-07, -1.4793875e-06, 2.7584213e-07, 1.8330037e-07, -8.448026e-07, -4.0758235e-07, 1.0870377e-06, -1.17512045e-08, 1.8725892e-07, -4.7134475e-07, 1.2807139e-07, 1.8868923e-06, -1.3863456e-06, 1.2188078e-06, 3.3320505e-06, -1.7686933e-06, -1.5149872e-06, 1.8379181e-06, -1.3228685e-06, -9.976951e-07, -5.094619e-07, 5.020602e-07, -9.1083575e-07, -1.4864222e-06, 7.6750723e-07, 3.589617e-06, 9.209717e-07, 1.2810742e-06, -1.7394634e-06, 1.5703089e-06, -2.0523182e-06, -1.2016278e-06, -1.516194e-06, -6.535171e-07, 1.6006803e-06, 1.1860851e-06, 2.7845994e-07, -2.3321418e-06, -8.0964054e-07, 3.8579248e-07, 7.1674737e-07, -3.7339666e-07, 5.7768126e-08, -6.6273195e-08, -6.067376e-07, -1.7476614e-07, -2.6489334e-07, -1.1849961e-06, -7.346629e-07, -2.9562824e-07, 6.056353e-07, 6.978895e-07, 1.7321234e-07, -4.6882994e-07, -6.181671e-07, -4.2097008e-07, -1.9638068e-07, -4.850755e-07, 4.382064e-07, 2.0194712e-07, 6.2734983e-07, -7.848346e-07, 8.590114e-08, 5.4847163e-07, -1.8172899e-06, 2.1191797e-06, 4.504204e-07, 8.477951e-07, 4.2000994e-07, -9.590922e-08, 2.3909192e-07, 3.5918652e-07, 6.485917e-07, -6.1331826e-07, -4.391301e-07, 1.475997e-06, -1.1478062e-06, -1.6426324e-07, 3.4370842e-07, -1.1190806e-06, -2.4243317e-07, -5.9391095e-07, 4.866296e-07, -3.9264427e-07, 6.2034997e-07, -1.15929204e-07, -1.708007e-06, -3.8666272e-08, 2.4092762e-07, 1.8564093e-06, 4.99527e-07, -1.9100416e-07, -9.054416e-08, -1.3704242e-07, -1.0721726e-06, -2.857158e-07, -1.0361133e-06, 1.1434892e-06, 1.589317e-07, 8.866403e-07, 5.542742e-07, -7.9259024e-08, 8.732074e-08, 4.6424373e-07, -2.6857757e-07, -1.0345477e-06, -6.8937464e-07, 1.4720786e-07, 1.8451934e-06, 5.862205e-08, 1.2769335e-06, -1.8057757e-06, -4.110353e-06, 7.700232e-07, 3.9554666e-07, 1.4435627e-06, 6.150325e-07, 9.4290624e-07, 1.4089054e-06, -1.2711786e-06, 2.2489266e-06, 1.0826914e-06, -1.9871486e-07, -4.820026e-07, -2.229965e-06, -6.5014393e-07, -1.0894908e-06, 5.5480108e-08, -2.2053264e-06, 2.3673892e-06, 7.5083733e-07, 5.966409e-08, 8.053811e-07, -2.9673558e-07, -7.690496e-07, 8.269325e-07, 8.477465e-07, -1.8668894e-07, 2.6768225e-07, 1.2868469e-06, 1.4720699e-06, -1.0290606e-07, 2.2142362e-07, -8.7229307e-07, -2.9628493e-06, -4.493778e-07, 1.1437985e-06, 1.0299465e-06, -7.6689236e-07, 7.531575e-07, 1.0738319e-06, -1.2288945e-06, 5.4274557e-07, 1.5796585e-06, -2.3781755e-07, -1.7789116e-06, -7.998072e-08, -1.1576517e-06, -9.492692e-07, -7.6701696e-07, -1.5400936e-06, 1.9719043e-06, 9.842726e-07, 5.9664205e-07, -1.2108626e-07, -5.158943e-07, -4.0353916e-07, 3.4943648e-07, 4.964606e-06, -5.0462604e-06, -2.999585e-06, 3.267964e-06, -5.233047e-06, 4.393247e-06, 3.5344772e-07, -8.7215165e-07, -4.52059e-06, -1.8907783e-06, -2.125399e-06, 1.6525764e-06, 4.9378044e-09, 4.2267793e-06, -4.4994335e-06, 9.4955465e-07, -1.0557698e-06, 1.3423668e-06, 5.067207e-06, 1.6989371e-06, 1.27578685e-08, 2.4953854e-06, -1.3282819e-06, 1.4351416e-06, -7.3606964e-07, 5.447388e-07, 1.300952e-06, -1.7984718e-07, 1.390318e-06, -4.645448e-06, 1.4537186e-06, -1.4219746e-06, 2.3987436e-06, -1.33011e-06, -1.1708278e-06, 7.450321e-07, -1.4901199e-06, -1.6940669e-06, -2.3365728e-06, 1.0592287e-06, 2.0407654e-06, -2.5685601e-06, 5.8150005e-07, 6.662346e-07, 1.3948589e-06, -5.85465e-07, -1.3103888e-06, 5.128249e-07, -1.2125337e-06, -1.8801271e-06, -9.825051e-07, 9.595302e-07, 2.7237127e-06, -1.7218355e-07, -1.0551039e-06, 1.896786e-06, -2.870245e-07, 6.2622513e-07, -4.408792e-07, -1.4071234e-06, 4.1813433e-07, 1.8098888e-06, 1.4274075e-06, 6.6271906e-07, -1.9044292e-06, 1.7343957e-06, 3.6361774e-07, 6.978272e-07, 2.3355194e-06, -9.059725e-07, 2.1506974e-06, -7.848398e-07, -1.758977e-06, 3.573082e-06, -1.2691373e-06, -1.933895e-07, -7.0916036e-07, 1.6852215e-06, 1.6317482e-06, -3.4278767e-07, 5.1508135e-07, 2.3716248e-06, -7.120074e-07, -2.1020267e-06, -3.410366e-06, 3.1354475e-07, 1.2649842e-06, -2.1209999e-06, 1.1104028e-06, 7.411034e-07, -1.6666656e-06, -2.8640457e-07, 1.8814764e-07, 1.2063291e-06, -4.2477823e-06, 5.31619e-07, 9.757304e-07, 3.0796323e-06, 1.2364321e-06, 1.975524e-06, 2.0607927e-06, -4.81134e-06, 7.774886e-07, -7.943726e-07, -1.9601152e-06, 2.4154112e-06, -1.5279093e-06, 6.8740667e-07, 6.699867e-08, 1.7712038e-06, 1.0219654e-09, 6.2719e-07, -8.574889e-08, 2.2183021e-06, -2.0211805e-06, -1.5728065e-06, -1.3940692e-06, -4.801215e-07, 2.0959496e-06, -3.6923436e-06, -6.6114876e-07, 3.3103374e-06, -4.603011e-06, -1.5793386e-06, 1.6295563e-06, 4.133035e-06, -5.673504e-06, 1.7949985e-06, 3.0711037e-06, -8.105703e-06, -3.7098278e-06, 3.512363e-07, -4.6525533e-06, 1.53279e-06, -2.2473891e-06, -1.562161e-07, -1.8788126e-06, -4.302056e-06, 2.0554958e-06, 3.5481635e-06, 2.6310558e-06, 2.6989105e-07, -1.5378454e-06, 1.9674014e-06, -7.5765917e-07, -3.4740833e-07, 2.6206035e-06, 1.2175896e-06, 3.9577712e-06, 6.440217e-07, -4.975813e-06, 4.502786e-06, -2.2195454e-07, -1.2543412e-06, 6.412085e-06, 1.0697354e-07, 1.3266388e-06, -5.3199833e-06, 6.008088e-06, -2.7561282e-06, -1.2539553e-07, -8.8065065e-07, -6.998613e-07, 2.7320522e-07, 8.6533555e-07, -8.0285946e-07, 1.5040749e-06, 8.56593e-08, -6.380924e-07, 2.0542875e-06, -1.2329085e-06, 2.281021e-07, -2.591678e-07, 1.2066531e-06, 6.8148944e-07, 3.6149373e-07, 3.3905272e-07, 7.9947023e-07, 4.5867975e-07, -6.115794e-07, -1.9404526e-06, 5.371374e-07, 1.0234347e-06, -4.5197694e-07, 7.240515e-07, 4.631317e-07, -6.17478e-07, -5.3046614e-07, -1.2261602e-07, -3.40527e-08, -2.2730733e-06, -3.846281e-07, -1.5891636e-06, 1.0040726e-06, 1.3509515e-06, -1.4331883e-06, 1.4375833e-06, 4.5894868e-07, 3.182059e-06, -1.0217278e-06, -3.0299102e-06, 2.6820703e-06, -1.2993801e-06, -7.143763e-08, -6.8032756e-07, -4.8947334e-07, 1.9241377e-06, -1.1208579e-06, 1.9752235e-06, 1.2785626e-06, 2.0437302e-07, 9.1277275e-07, -1.6321802e-06, 4.3054587e-07, -5.377819e-07, -1.5984144e-06, -1.7966893e-06, -1.0334837e-06, 1.5141062e-06, 8.804965e-07, 7.8816e-07, -2.1192686e-06, -7.270899e-08, -4.980709e-07, 5.0015484e-07, 2.401959e-06, 1.0300452e-06, -1.4308879e-06, -8.8404886e-07, 4.3157405e-07, -8.115991e-07, 2.057542e-08, 1.5595233e-06, -5.5674394e-07, -7.9068127e-07, -1.3485904e-06, -1.5158952e-07, -1.0283836e-06, -6.3661093e-07, -8.4303645e-07, 2.1764288e-08, -1.9890206e-06, -5.963058e-07, 1.3618036e-06, 1.2675262e-06, 2.6172916e-07, 2.609256e-06, 8.8189836e-07, -2.7526195e-07, -1.0556025e-06, -1.8369046e-06, -2.8753308e-07, -3.771882e-07, 9.739556e-07, 6.1800785e-07, 9.602163e-07, 1.0819095e-06, 1.4948346e-06, -3.322952e-07, 1.745676e-06, 5.439839e-07, 1.1073444e-06, 2.1293035e-06, -3.8746684e-06, 2.377317e-06, 2.7238968e-06, 7.2580724e-07, -2.8914374e-06, -2.339563e-06, 2.789834e-06, 1.8143046e-06, -1.7902435e-06, 7.137096e-07, 4.2045485e-06, 2.8318658e-07, -4.2708734e-06, -1.4447351e-06, -2.4287176e-06, 6.8082e-07, -9.2887063e-07, -2.7651831e-06, 2.0882217e-06, 4.5673949e-07, 1.8101687e-07, -7.2517815e-07, -1.8834179e-06, -9.929148e-07, -4.7435418e-07, -1.822651e-06, 1.4803295e-06, 1.2087092e-07, 1.2583284e-06, -6.071146e-08, -3.854613e-07, 7.308414e-07, 2.6624389e-06, 5.7662027e-07, 1.5472558e-06, -2.8055592e-06, -1.3371472e-06, -1.7642634e-06, 1.8860563e-06, -7.005818e-08, 1.9495339e-07, -9.447516e-07, -1.2040591e-06, -1.0561965e-06, 5.4120636e-07, -1.7823154e-06, 2.9989542e-06, 3.3274496e-06, 4.3078379e-07, 3.4802656e-06, -1.3423153e-06, -4.1713533e-06, -3.156527e-06, 3.2066464e-07, 2.7459218e-06, -2.1800513e-06, -2.1951881e-07, -1.0091405e-06, 3.141108e-06, 7.570166e-07, 1.4889699e-06, 3.0699948e-06, -2.0464684e-06, 3.1007264e-06, -2.3365133e-06, 2.2668475e-08, 5.1128873e-06, -1.9033702e-06, -1.7394375e-06, -2.3848218e-06, 3.72451e-06, 2.822843e-06, -2.5043387e-06, 7.6597513e-07, 3.0905292e-06, -3.3624751e-06, -3.177893e-06, -4.6921396e-06, 6.471518e-08, 2.1412436e-06, -7.4737466e-07, -8.585445e-07, 2.7982978e-06, -2.065598e-06, -1.8920157e-06, 1.5679678e-06, 2.232699e-06, -5.7631423e-06, 5.811214e-07, 2.0280966e-07, 1.0887818e-06, 6.7497166e-07, -7.258434e-07, 2.2281527e-06, -1.1605616e-06, 3.8097164e-07, -1.7425881e-06, 3.8886287e-06, 1.8757661e-06, 8.687649e-07, -1.5701737e-06, -1.3917959e-06, -2.076543e-07, 8.5034026e-07, -9.0510105e-07, 1.3027804e-06, 8.34382e-07, -1.5258458e-06, -1.4474095e-06, -6.6614126e-07, -2.1112119e-06, -7.156166e-08, 2.4044196e-08, -1.7330514e-06, 1.7553184e-06, -3.5645166e-07, 2.3848872e-07, 2.4524152e-07, 1.4121744e-07, -5.9447433e-07, -3.9079305e-07, -6.0712944e-07, 6.000449e-07, -1.2806535e-07, -1.9757094e-06, 2.0301268e-06, -2.381843e-06, -1.8670607e-06, 9.835487e-07, 2.0076982e-06, -4.1674232e-07, 1.9751327e-07, -2.5757444e-07, -1.6325833e-06, 1.3449724e-06, 2.2037585e-07, 2.1715919e-06, -9.4924434e-07, -2.945495e-06, -2.9500413e-06, 8.529989e-07, 1.3625266e-06, -2.5864247e-07, 4.0673885e-06, 3.6510007e-06, 1.7972245e-06, -1.0127984e-06, -3.720781e-06, -2.1084588e-06, -2.6761825e-07, 2.6927858e-06, 3.5153818e-08, -5.3516396e-07, 1.4579545e-06, -2.240867e-06, -2.1071157e-06, -8.7411587e-07, -9.715912e-07, -1.4088945e-06, 3.8359536e-07, -1.2633752e-06, -5.823302e-08, 6.114511e-07, 5.367122e-07, 1.2942659e-06, 8.8656515e-07, 1.1049606e-06, 6.810724e-07, 1.8634977e-06, -2.4876138e-07, 8.248886e-07, 1.647197e-07, -9.886143e-07, 9.272343e-07, -1.1105823e-06, 1.2390152e-06, 1.2422942e-06, 2.4977288e-07, 3.992218e-07, 5.2057027e-07, -3.0793123e-07, -4.3805602e-07, -1.5237094e-06, 3.287566e-07, -1.1746998e-06, 1.445071e-07, 1.4545301e-06, 9.547534e-09, -1.8378938e-07, 1.2710843e-06, -8.05375e-07, 5.2283883e-07, -4.842316e-07, 1.6565089e-06, 7.5888374e-07, -2.7658166e-07, -9.875497e-07, -4.4698842e-07, 1.0345715e-06, 4.2961136e-07, 7.2863725e-07, -1.6559812e-07, 7.286719e-07, -8.872464e-07, -3.4801099e-07, 5.6982003e-08, -5.11734e-07, 3.9677317e-07, -6.9057563e-07, -1.011578e-06, 3.0300941e-07, -1.9215975e-06, -6.931584e-07, 4.9864084e-08, 3.950743e-07, -7.429835e-07, 2.1590355e-07, 4.8292037e-07, -9.153793e-08, 2.2063177e-06, 1.4711864e-06, -2.2741851e-06, 2.3425978e-06, -2.877216e-07, -2.3998373e-07, 7.625633e-08, -2.879516e-07, 8.716637e-07, -1.3651381e-06, -2.663959e-06, -1.4235987e-07, -1.4989653e-06, -1.3558703e-06, -5.7668603e-07, 1.4407799e-07, 1.9101483e-07, -3.2852455e-07, 1.4703628e-06, 5.81147e-07, -1.6226577e-06, 1.2135802e-06, 5.047135e-07, -1.2325548e-06, 2.3844614e-06, 1.8637545e-06, -6.907849e-07, -1.7528158e-06, 1.1555958e-06, -5.4795277e-07, 1.2239045e-06, 1.0646653e-06, 1.3215713e-06, -9.833027e-07, -7.2110396e-07, -1.6484857e-06, -1.0279143e-06, -1.4233871e-06, 1.6573471e-06, -3.953585e-07, 1.3021333e-06, -4.769079e-07, 1.767661e-06, -2.465396e-06, 1.8956865e-06, -3.991013e-07, 5.9917653e-07, -2.125584e-07, -1.2489345e-06, -1.8178822e-07, 2.0615964e-06, -1.9092824e-06, -1.2669311e-06, -8.564813e-07, -2.5927548e-06, 1.2777464e-06, 6.0955733e-07, 7.228448e-07, 5.888402e-07, -2.5919886e-07, 3.3985864e-07, 1.6362986e-06, -2.1272174e-06, 2.5323652e-06, 1.6183018e-06, -1.8600633e-06, 1.3971296e-06, 5.1636135e-07, 3.657641e-07, 1.444803e-07, 5.251831e-07, 9.13396e-07, -9.370289e-07, -1.5763488e-06, -1.7666332e-06, -3.597522e-07, 1.430302e-06, -6.061478e-07, 6.3361375e-07, -1.6743683e-06, -3.8984618e-07, 4.9317873e-07, -1.1633291e-06, 1.026635e-07, 3.0662436e-06, 5.354962e-07, 4.7181788e-07, -1.4414254e-06, -5.299417e-07, -3.9226993e-08, -7.631417e-09, 5.3949003e-07, -2.2487015e-07, -5.8195553e-07, 3.1471947e-07, -8.3184307e-07, -1.3660818e-07, 6.168732e-07, -6.1849516e-07, 3.24867e-07, -5.65105e-07, 6.762895e-07, 4.5949042e-07, -6.300266e-08, -5.392042e-07, 9.866983e-08, -3.892903e-07, 2.4079506e-07, -1.1635722e-06, 5.2766893e-07, -1.5032641e-06, -6.73649e-07, 5.490932e-07, 1.864652e-07, 9.1008116e-07, 1.786292e-06, -7.334966e-08, 5.0930794e-07, 5.987291e-07, -7.496186e-07, 1.0982448e-06, -1.120519e-06, 2.871425e-07, -4.5229356e-07, 4.772988e-07, -7.822139e-07, 2.4448311e-06, -4.0531594e-07, -1.982021e-06, 3.6650356e-06, -1.6543255e-06, 1.7469022e-06, -4.662153e-08, -1.0332301e-07, -1.8321217e-07, -8.214858e-07, 7.094397e-07, 3.7790647e-07, -9.253614e-07, 1.8614255e-06, -3.0130066e-06, 2.1961846e-07, -1.474528e-06, 1.1238216e-06, 1.247946e-06, -5.992527e-07, 7.206391e-07, -8.5785146e-08, -1.8805694e-06, -1.392463e-06, -3.2977164e-07, 2.1091985e-06, -1.6630346e-06, -2.100859e-07, -6.7096994e-07, 2.0895556e-07, 3.3404874e-07, 6.7136443e-07, 2.2430156e-06, 1.1774184e-06, 1.5203632e-07, 1.5342447e-06, -9.214782e-08, -2.7865651e-06, 2.4521128e-07, -2.228837e-07, -8.3774324e-07, -5.2397826e-07, 7.1872313e-07, 1.060732e-06, 4.7144212e-07, -5.9133714e-07, 2.0749887e-07, -3.7022335e-07, -2.0674922e-06, 1.0506612e-06, -7.956642e-07, -8.7200857e-07, 2.5671893e-06, -1.7105504e-06, -1.2300757e-06, -2.1494955e-06, -2.5431937e-06, 2.6491307e-06, -3.8403704e-07, 5.7292044e-07, -3.965892e-08, 1.6129874e-06, -6.005527e-07, 1.5543977e-06, -1.8681286e-06, -1.3441594e-06, -1.8404626e-06, -1.4199628e-06, 1.5484424e-06, 2.7879904e-07, 5.779062e-07, 1.3720158e-06, -5.049392e-07, 1.683206e-07, -5.3777036e-08, 2.0738114e-06, -6.290962e-08, -3.8867164e-08, 5.6356265e-07, 5.873089e-07, -6.7390955e-09, -9.338003e-07, 6.389197e-07, -1.2141709e-07, -9.662525e-07, -5.055986e-07, 6.928998e-07, 4.666208e-07, 1.6286443e-06, -2.5390284e-07, 1.3047098e-06, -1.9368894e-08, -5.952751e-07, -1.7951335e-07, 6.531648e-07, -1.8400525e-06, 1.8659598e-06, -1.6317789e-06, -7.896099e-07, 1.1443756e-06, -1.297282e-06, -1.0434972e-06, -1.1250393e-06, 4.666011e-07, 2.9908801e-07, -1.2742377e-06, 9.931739e-07, 1.0552321e-06, 1.3075986e-06, 6.4175964e-08, -2.644173e-06, 1.5003791e-06, -1.0277389e-06, 1.225261e-06, 2.2052754e-07, 2.5606337e-07, 1.9887013e-06, -8.1351565e-08, -2.2011457e-06, -7.549736e-07, -1.7411134e-07, 8.0706644e-07, -7.4709163e-07, 2.2707826e-07, 2.0437669e-07, 3.5391375e-07, 5.4453477e-07, 2.6792281e-07, 1.5554775e-06, 2.1063929e-07, -1.0413653e-06, 2.3160867e-06, -1.2229027e-06, 9.726164e-07, -8.6798104e-07, -4.4663392e-07, 1.699542e-06, -6.0068396e-07, 1.0002314e-06, -7.0448624e-07, 1.598289e-07, 5.1798065e-07, -2.4697174e-06, 6.0373605e-07, -1.0410257e-06, 1.1042002e-06, 7.252116e-07, -8.3623326e-07, 8.6277856e-07, 4.8474885e-07, -1.7609029e-06, -1.616315e-06, 1.12017105e-07, 1.2219808e-06, -1.9361814e-06, -1.2826465e-07, -2.1533131e-07, 4.2038272e-07, 2.626308e-09, 9.179388e-07}},
    {"bert.encoder.layer.3.attention.self.key.bias_grad", {1.4210855e-13, 3.5527137e-15, 1.4210855e-13, -1.4210855e-14, -1.1368684e-13, -9.2370556e-14, -4.2632564e-14, -9.947598e-14, 1.2789769e-13, -5.684342e-14, -5.684342e-14, 1.1368684e-13, 7.1054274e-15, 7.1054274e-14, -3.7303494e-14, -2.344791e-13, 1.1368684e-13, -1.7053026e-13, -3.9790393e-13, -5.684342e-14, -1.7053026e-13, 5.684342e-14, 1.1368684e-13, 2.2737368e-13, -1.7763568e-13, 5.684342e-14, 7.1054274e-14, 5.684342e-14, -1.1368684e-13, 4.2632564e-14, 1.6342483e-13, 2.842171e-14}},
    {"bert.encoder.layer.3.attention.self.value.weight_grad", {0.00017832701, 0.00014200108, 7.564491e-05, 0.00016154208, 0.00015585589, -0.00024103427, -0.00023811836, 0.0003430435, 0.0001718549, -0.0002494799, 6.544374e-05, 5.6336917e-06, -2.4545961e-06, -5.1290295e-05, 3.015746e-05, -0.000301019, 0.0002688348, -6.859646e-05, 0.00031010617, -0.00012443984, 0.0002527359, -0.00018223068, -0.00032514683, -0.0001617613, -2.8057108e-05, -0.00026599088, -0.00051265466, 0.00039879407, 0.0004579161, -0.00023941838, 8.8099674e-05, -0.000114298244, -4.8379028e-05, 0.00019129312, 2.3906836e-05, 0.00031136113, 0.00026363158, -2.7514172e-05, -0.000100840625, 0.00014748934, -8.2865525e-05, -0.00022337251, 8.427401e-05, 9.165224e-05, -0.00010629264, 0.00012499509, 6.271938e-05, -0.00046267215, 0.00024008511, 5.019464e-05, 0.00031918375, -0.000135367, 0.00022355594, -0.00017138412, -0.00026025152, -1.5796604e-05, 1.26059085e-05, -0.00028751788, -0.0006329972, 0.000117981916, 0.00038172127, -0.00018116992, -4.6147466e-05, 0.00013591691, -0.00018679703, -3.6891342e-06, -0.00018978004, 0.00016739384, -0.00019167559, 0.000103417704, 0.00018164756, -0.00019525614, -0.00014655961, 7.500386e-05, -3.3138629e-06, 8.891404e-05, 0.00013484646, 2.2524919e-05, 6.7731926e-05, -3.5938192e-05, -2.4445597e-05, 0.00032864846, -8.930279e-06, -0.0001959822, 0.00024229934, -3.691375e-05, 9.120374e-05, -2.317995e-05, -7.171435e-05, 4.495274e-05, -3.0179903e-05, -0.00033357873, -0.00015564656, 0.000102770944, -6.753711e-05, 0.00024976255, -0.00017021288, 0.0003462769, -4.7404814e-05, 0.00054913526, 0.00031637674, -1.1699089e-05, -9.855661e-05, 0.00013809084, -0.00022163363, -0.00036877015, 0.00011351121, 0.00016756865, -0.00011210107, 0.00021614697, 0.0001741213, -0.00076211133, 0.00039856372, 0.00020040467, 0.00050443836, -0.00024545795, 0.00046772775, -0.00030578588, -0.00031627796, 8.8678775e-05, 1.49663065e-05, -0.0005110005, -0.0010292288, 3.1625787e-05, 0.0004915143, -0.00028253868, -0.00013919223, 0.00040282434, 0.00010052167, -6.589198e-05, 4.3725035e-05, -0.00014050728, -9.181209e-05, -0.00013006262, 1.3741623e-05, 4.666478e-05, 8.454155e-05, -3.0716146e-05, -5.8879523e-05, -4.2107065e-05, 4.7763424e-05, -4.531373e-05, -8.6638756e-05, 0.00014651426, -2.6027854e-05, -7.5719334e-05, -1.947825e-05, 0.000109252396, 2.587352e-06, 5.5049728e-05, 6.47719e-05, -6.210377e-05, -1.2743914e-05, 6.513172e-05, 0.00011928254, 0.00011341608, 8.436863e-06, -5.4545937e-05, 5.7857855e-05, -0.00013671057, 8.090046e-05, -0.00025005304, 9.419833e-05, -0.00064143393, -0.00019453815, 4.803472e-05, 9.399322e-05, -0.00017490592, 0.00014808212, 0.00039008664, -0.00013503133, -0.00016463734, 4.854586e-05, -0.00016544246, -0.00016226797, 0.0007579595, -0.00039124046, -0.0003268396, -0.0005022936, 0.00036767527, -0.00055277074, 0.00033345207, 0.0003993013, 1.0268562e-05, 2.8896342e-05, 0.00042790908, 0.0009737297, -7.019432e-05, -0.0004939734, 0.00027466446, 0.00011079466, -0.00036287028, 0.00024445052, -0.00011526935, 0.0001150903, -0.00022693221, -0.0001131022, -0.00024001094, -0.00011628866, 0.0001929355, 0.0003006821, -8.56508e-06, -1.971248e-05, -0.00011287224, 0.000108226435, -0.00017323898, -7.9239966e-05, 0.0002678597, 1.3232494e-05, -0.00017676753, -7.348924e-05, 7.8623285e-05, -7.430752e-05, 3.4065622e-05, -4.3593307e-05, -0.00015915325, -3.7456244e-05, 9.295193e-05, 0.0001984035, 0.00031835414, 7.243153e-05, -6.198544e-05, 0.00014796473, -0.000353287, -3.4541667e-05, 1.0708836e-05, -3.4417517e-05, -4.5672885e-05, -6.333541e-05, -2.5333644e-05, 5.3228217e-05, -6.246984e-05, -4.7330028e-05, 1.1757976e-05, -4.6483387e-05, 2.4670655e-05, 2.730902e-05, -1.1971333e-06, -1.268199e-05, 3.9912415e-05, -1.9501724e-05, 3.852824e-05, 1.72208e-06, 3.5082834e-05, 8.264674e-05, 1.578316e-05, 0.00010302266, 1.756549e-06, -1.2376282e-05, 1.6961042e-06, 2.3271567e-05, -7.9074656e-05, -5.2902033e-05, 2.1530594e-05, 6.9515927e-06, 3.773895e-05, 0.0001546815, -0.0002680936, 2.1293361e-05, -0.0003339439, -0.00024233568, 9.923935e-06, 5.0448005e-05, -4.3249358e-05, 0.0002219208, 0.00025694226, -5.8271686e-05, -0.00016796342, 0.000103972176, -0.00016767853, -8.725043e-05, 0.00051387073, -0.00028539792, -0.000102209495, -0.00039680727, 9.210361e-05, -0.00034125813, 0.00020441525, 0.0001505301, -5.2939937e-05, -4.890938e-06, 0.0003548142, 0.0007279054, 9.972849e-06, -0.00037051804, 0.00023358951, 7.673579e-05, -0.00026031112, -0.00012064857, 0.00025160983, -3.7243466e-05, 0.00037384572, 0.000145115, -9.234266e-05, -4.10544e-05, 8.4035004e-05, -0.00015232807, -0.0002893072, 2.7117529e-05, 0.00012322362, -4.4341617e-05, 0.00013666495, 8.471189e-05, -0.0005355299, 0.00032870338, 0.00021106633, 0.00040806006, -0.0001751968, 0.00045375113, -0.00021880033, -0.00016994972, 1.2521125e-05, -2.178601e-06, -0.00036490726, -0.0008083423, 4.72932e-05, 0.00038400132, -0.00021285396, -8.258253e-05, 0.00027588746, 4.9742237e-05, 0.00022152254, 9.385046e-06, 0.00023903238, -1.4646494e-05, -0.0003347356, -9.355159e-05, 0.00022010638, 1.2755041e-05, -0.00033554836, -6.218029e-05, 5.0277795e-05, 6.6709596e-05, 1.5778034e-05, 2.09326e-05, -0.00041482624, 0.00037172867, 0.00017545377, 0.0004223738, -0.00015690392, 0.00058123394, -0.000219431, -0.00013382804, -0.00013067815, -5.369765e-05, -0.00033047918, -0.000757643, 0.00026970071, 0.0004489564, -0.00023712979, -5.039282e-06, 0.00010462968, -1.9167055e-05, 0.00023807015, 1.283723e-05, 0.00034030495, 0.0001383222, -0.00016805103, -9.109502e-05, 0.00018761748, -7.7753284e-05, -0.00031594574, 6.6502366e-06, 7.574352e-05, -2.9471961e-05, 0.000107416185, 6.0398364e-05, -0.0005199786, 0.0003375104, 0.00014373241, 0.0004095917, -0.00018464694, 0.00043546516, -0.00022434388, -0.0002072955, -5.7464218e-05, -2.7223048e-05, -0.00032281326, -0.00077018293, 0.00019778083, 0.00044920383, -0.00022593708, -8.363528e-05, 0.00018436064, -0.000245552, 0.00025209435, -3.5594276e-05, 0.00029172614, 0.00023429238, 9.6834985e-05, 0.00012165033, -0.00011697596, -0.00041834445, -0.00023564376, -5.792398e-05, 0.00015189807, -0.0001907522, 0.00031654525, 1.1656127e-05, -0.0005117162, 0.00013201091, 0.0001135989, 0.0003361721, 3.0667925e-05, 0.0002577617, -8.07957e-05, 5.8314497e-05, 0.00016019082, 4.956085e-05, -0.00022964393, -0.00058383605, -0.00015985878, 0.0002291694, -0.00016159854, -0.0002388683, 0.00042295933, -1.2934746e-05, -0.0002718922, 6.7067085e-05, 0.00012450608, 0.00037098528, 0.0005296482, 4.5495068e-05, -0.00010955502, -0.00014674524, 0.00012779694, 0.00023329981, -2.1102294e-05, -0.00029546706, 0.00025688176, -2.3559525e-05, 3.853214e-05, -0.00039632502, -0.00031053682, -0.000327244, 0.0002036692, -0.000860632, 0.000191116, -0.0002208246, 0.00030841, 0.000164985, 0.00027906362, 0.0005868104, -0.00019192217, -0.0001920459, 9.612228e-06, -0.00017143885, 1.4346481e-05, -0.00028198503, 0.0002812771, 2.131912e-05, 0.0009382984, 0.0006971924, 0.0004148388, -0.00010815133, 9.918964e-05, -0.0004409477, -0.00042862952, 0.0003487616, 0.00022030956, -0.00037478225, 0.0004992246, 0.00022322306, -0.0010831843, 0.00035354504, 0.000106732215, 0.00048896135, -0.00025780793, -1.555849e-05, -0.00032453163, -0.00063484063, 0.00034230485, 0.00012592257, -0.00046409588, -0.0010766083, -5.137146e-05, 0.00058576046, -0.00041153695, -0.00035773244, 0.00056490337, 0.00030552177, -8.0258345e-05, 8.650886e-05, -0.00083603256, -0.00055840437, -0.00057655567, -3.8141414e-05, 7.604268e-05, 0.00044226524, 0.00021096563, -0.0003588104, -0.0001885403, 0.00030600396, -0.0004871812, -0.00021623727, 0.00078872906, -4.215892e-05, -0.00012956989, -0.0001857239, 0.00021873525, 0.00023476563, 0.00017327043, 0.00051939924, -0.00038576341, -0.00013111894, 0.00021010272, 0.0005315849, 0.0003322209, -0.00024568176, 0.00022396828, 0.00038768013, -0.0005875863, -5.444446e-05, 0.00035137514, -2.293798e-05, 0.00019569865, 4.2766615e-06, -0.00035204185, -0.0001066577, 0.0001555255, -3.6629925e-05, -0.00027519712, -9.367569e-05, 0.00010327886, 6.719592e-05, -2.154398e-05, 8.244169e-05, -0.00045575364, 0.00044696018, 0.00024284558, 0.0004711876, -0.00021167769, 0.00073572306, -0.00026887486, -4.6488796e-05, -0.00014281094, -7.717201e-05, -0.0004418023, -0.0009151246, 0.00017612241, 0.00043266692, -0.00013509263, 3.1632957e-05, 0.00016099533, 0.00022315279, -0.00011858079, 0.00010517164, -0.00030542814, -0.00014897488, -0.00021065479, -8.016415e-05, 0.00014509229, 0.00028765274, 7.716086e-05, -7.6320226e-05, -0.00015004493, 9.557943e-05, -0.00018577048, -9.009652e-05, 0.0003317605, -5.447163e-05, -0.00016197447, -0.00015581868, 8.9947534e-05, -0.00011478541, 8.9804606e-05, 5.174528e-05, -0.00014021588, -2.4754145e-05, 0.00013333483, 0.00030826827, 0.00026295971, -5.5239114e-05, 6.770402e-05, 0.00013863387, -0.0003346739, -1.9956866e-05, -0.00029610525, -2.3625575e-05, -0.00020209259, -7.966664e-05, 0.00031012524, 0.00017912233, -0.00023971686, -3.396744e-05, 0.0002670152, 1.7031827e-05, -7.628752e-05, -4.3779222e-05, 3.6643043e-05, -8.282412e-05, 0.00042520114, -0.00041312329, -0.00011735669, -0.00041943465, 0.00018123604, -0.0005594987, 0.00026031616, 0.00017466917, 0.00013192152, 6.0905862e-05, 0.00042180804, 0.000805499, -0.00025673304, -0.00045611383, 0.00017953527, -6.728067e-05, -6.346692e-05, 9.5191754e-05, 2.1453227e-05, 4.2590815e-05, -0.00017680669, -0.00017584929, -0.00022315995, -0.00010817059, 0.00011035912, 0.00024880358, 5.4689983e-05, -4.242566e-05, -6.8440655e-05, 0.00016043877, -0.00022802809, 1.0966163e-05, 0.0001912656, 0.00014177003, 1.1986145e-05, -7.344506e-06, -8.101424e-05, 0.00013625437, -4.7560334e-05, 2.767062e-05, -0.00017050153, -7.234717e-05, -2.0190166e-05, -2.6583126e-05, 0.00019994247, 2.8600309e-05, 3.5630554e-05, 0.00015743743, -0.00022662886, -2.3914745e-05, -0.00015468341, 1.7546223e-05, -0.00027772272, -3.0844963e-05, 0.00012085948, 0.00014706465, -0.00020082424, -8.135918e-05, 0.00016985256, -7.077102e-05, -2.139092e-05, -6.6173314e-05, 4.4887813e-05, -0.00011838811, 0.00032871735, -0.00029505673, -0.00015364349, -0.00025177738, 0.00027565102, -0.0003144382, 0.00021737945, 0.00025847886, 8.5312815e-05, 4.9468938e-05, 0.00024998435, 0.0005289775, -0.00019012902, -0.00028967683, 0.0001301987, -8.562723e-06, -7.502265e-05, 0.00012246042, 0.00014466216, 5.0231123e-05, 0.000117685064, -0.0001236871, -0.0003760775, -0.00016449632, 0.00026379983, 0.00021605194, -0.00024418626, -3.43313e-05, -4.0986335e-05, 0.00014042798, -0.0001323406, 6.503596e-05, -0.0002108955, 0.00039838188, 0.00016823488, 0.0002693077, -0.00021278007, 0.00046664965, -0.00021751477, -0.00014505781, -0.00013948994, -7.098803e-05, -0.00027598543, -0.00058781746, 0.000358822, 0.0003196666, -0.00014738554, 8.0340054e-05, -5.7737034e-05, -4.9039056e-05, -7.671649e-05, 2.5252739e-05, 0.00023709763, 0.00029963203, 0.00032502966, -2.2466658e-05, -1.6958773e-05, -0.00012718866, -3.0399195e-05, 0.00020706734, 4.594357e-05, -0.00018866244, 0.00018732308, 5.324525e-05, -0.00016468734, -9.945595e-05, -0.00013306797, -5.3576972e-05, 3.799321e-05, -0.00039794782, 4.5660854e-06, -0.00024672065, 0.00020506248, 8.880811e-05, 2.3411405e-05, 7.752877e-05, -9.8934725e-05, 1.73846e-05, -0.00010976016, -0.00011396172, 9.419853e-05, 3.3581386e-05, -0.00024525443, 1.6554694e-05, -2.8690858e-05, -2.7595293e-06, 0.0002687011, 7.144291e-05, -8.627147e-05, 2.3789025e-05, 0.00018370854, 6.6540844e-05, -0.00011595046, -4.0778614e-05, 5.2266652e-05, -2.1626853e-05, 0.00022700198, -0.00030048116, -0.00010899998, -0.0003472601, 5.4201795e-05, -0.00053307565, 0.0001671736, -2.588702e-05, 0.00012406432, 6.3315776e-05, 0.00032837925, 0.00058556505, -0.00010116954, -0.0002759884, 0.0001304136, -0.00013157315, -3.0933144e-05, -0.00015381227, 0.00025653336, 7.176953e-05, 0.0007916212, 0.0006406628, 0.00024514028, -0.00014739555, 0.00017382325, -0.00035696043, -0.0004758928, 0.00029414287, 0.00020826838, -0.00034724473, 0.00043549173, 0.00015217194, -0.00097000727, 0.00035473378, 3.4581112e-06, 0.0005128383, -0.00014822446, 4.4488217e-05, -0.00031008193, -0.00058154005, 0.0002545473, 9.654897e-05, -0.00044280585, -0.0009992365, 8.389666e-05, 0.00064537954, -0.00046487726, -0.0002710664, 0.0004036296, 0.00026858714, -0.00031938704, 7.781277e-05, -0.00079555175, -0.000569608, -0.00024582155, 4.2373567e-06, -2.9246283e-05, 0.0005271115, 0.00041931894, -0.00018786894, -0.00028204595, 0.0003182172, -0.0004884408, -0.00016244329, 0.0010297613, -0.0002507628, -0.00016909059, -0.0005296913, 0.00016343484, -0.00030539703, 0.0002789236, 0.00040453605, -0.00025536565, -8.404254e-05, 0.00049710297, 0.0010254887, 0.00019824199, -0.0005226787, 0.0003083077, 0.00030213853, -0.00062577834, -3.1250158e-05, 0.0001700391, 1.6394606e-05, 0.0002698954, 0.00017623942, -1.2914697e-05, -0.00017286335, 0.00016312375, 1.9051804e-05, -0.00010703035, 0.00012217296, 5.9975795e-05, -2.1252285e-05, -8.465056e-06, 0.00010949332, -0.00034342468, 0.000253383, 5.7994253e-05, 0.00022376618, -0.0002045677, 0.00016526264, -0.00019022902, -0.00029294382, -4.5298217e-05, -8.727618e-06, -0.0002636123, -0.000507054, 0.00012622097, 0.0002939817, -0.00010589955, 3.2279426e-05, 5.6258334e-05, 0.0003015107, -0.00022422372, 0.00014537176, -0.0006982898, -0.00036139824, -0.00030853748, -4.523735e-05, 6.0681887e-05, 0.00039734197, 0.00023778346, -0.0001929788, -0.00021615345, 0.00018693169, -0.00034609987, -0.0001890604, 0.000768851, -0.0001855177, -0.0002837214, -0.0003508713, 0.00027784248, -0.00023142443, 0.00022685973, 0.00032526974, -0.00020457695, -5.631268e-05, 0.0003385371, 0.00076895667, 0.00028120677, -0.00028392414, 0.00017090858, 0.0002586533, -0.0005683791, -0.00024765596, -0.0001503919, -0.00014480621, 0.00027948184, 0.00021331619, 0.00059932086, 0.00017884182, -0.0003090542, -0.0003198263, 0.00019259738, 0.00020284897, 9.127341e-05, -0.00016744705, 0.00026171, 0.000100204015, -6.852922e-05, -0.0003462923, 2.0039066e-05, -0.0002496077, -1.20430295e-05, -0.0005033296, 0.00010089803, -8.4005886e-05, 0.00030458556, 9.722537e-05, 0.00020551994, 0.0004013236, -0.0005322722, -0.0003001975, 0.00010659478, -0.00024743736, 0.00032711553, 0.00018741397, -0.00028841768, 7.360414e-05, -0.00049501244, -0.00026901162, -3.5247904e-05, 6.2626656e-05, -7.019438e-05, 0.0002223049, 0.00022413216, -0.00010246289, -0.00017025846, 7.653845e-05, -0.00018190464, -0.00015453242, 0.0006456057, -0.00029250217, -0.00021229588, -0.00039393202, 0.00026155665, -0.00039920435, 0.00025435886, 0.00027116397, -2.358079e-05, 4.0542977e-06, 0.00038743162, 0.00083772506, 6.453734e-05, -0.000403247, 0.00014950667, 0.00012860095, -0.00035935646, -1.3130962e-05, -0.00015192872, -7.437695e-06, 2.1313372e-05, 2.443359e-05, 0.00022342353, 1.9201141e-05, -7.208247e-05, 1.7999093e-05, 0.00016280288, 0.00010054394, -3.8760845e-05, -3.1082156e-05, 7.771156e-06, 3.2554868e-05, 0.00012985869, -0.00016901121, -3.181155e-05, -0.00023979477, -2.7364265e-05, -0.0003419289, 7.023648e-05, -6.596301e-05, 8.128501e-05, 2.968725e-05, 0.00017541638, 0.00035453698, -0.00012760736, -0.00020756897, 0.00013316546, -3.2839154e-05, -2.5917838e-05, -7.0385036e-06, -3.4407585e-06, 1.1293183e-05, 0.00049037073, 0.0003806214, 0.00027277062, -0.00012580189, 0.00016239563, -4.4122575e-05, -0.0001850632, 0.00029885198, 4.4367447e-05, -0.00017584722, 0.00019829259, 0.00013110884, -0.0004348451, 7.194862e-05, -4.7900074e-05, 0.0001224837, -0.00016378859, -0.00023506767, -0.000133847, -0.00051624136, 0.00015710128, 8.272225e-05, -0.00014716829, -0.00030257372, 5.8809434e-05, 0.0002594347, -0.00024112685, -0.00013140982, 0.00015271024}},
    {"bert.encoder.layer.3.attention.self.value.bias_grad", {-0.0005067495, -0.00062830804, -4.7599566e-05, -0.0010615214, 0.00015348724, 0.0010717923, 0.0002517164, 5.509948e-05, 0.0006965286, -0.0007703582, -0.0006904175, -0.00076891243, -0.0006044944, 0.0002791064, -0.0013460063, 0.0008911939, -0.00073278806, 0.00037358867, 0.00068516267, 0.00012802987, 0.0005456803, -0.00048130844, -0.00011839533, 0.00038674142, -0.0012271464, 0.0012362847, -0.0004925508, 0.00093796354, 0.00012013159, 0.00085671776, 0.00024645642, -0.0005542576}},
    {"bert.encoder.layer.3.attention.output.dense.weight_grad", {-8.404835e-05, -0.000120940305, 3.7427753e-06, 7.555403e-05, -5.4884502e-05, 3.980203e-05, 7.737318e-05, 5.135496e-05, 3.698406e-05, 7.8875295e-05, -1.9791934e-05, 2.7199694e-05, 4.777102e-05, 3.3319317e-05, -5.965014e-06, 5.818675e-06, -0.0001699083, -0.0001080971, 2.3314273e-05, -0.000102315484, -0.00010888309, 0.00011045742, -0.00011318973, 4.8020305e-05, -0.00011208389, -2.0021616e-05, -1.5344103e-05, 3.744566e-05, -7.4486205e-05, 7.2675895e-05, 3.7588612e-05, 0.0001080465, 4.042237e-05, -7.000741e-05, 2.1610114e-05, -5.1930863e-05, 4.856239e-06, -7.1807124e-05, 1.6659874e-07, -2.1563266e-05, -8.893962e-06, -2.5326015e-06, -6.301108e-05, -9.493193e-05, -3.1169322e-05, -9.086617e-05, -2.1856084e-05, -1.207565e-06, 4.364101e-06, 2.2417437e-06, -0.00012038617, 6.2352156e-05, 0.00011049842, -8.899267e-05, 5.9111517e-05, -5.624166e-05, -2.818396e-05, 4.627981e-05, -8.789162e-05, -1.2394492e-05, 5.1477335e-05, 2.315946e-06, -3.834387e-05, -0.00012611666, -0.00019407361, 8.6442575e-05, -0.00016597232, -8.4903746e-05, 0.00010333444, 0.00016104571, 8.269111e-05, -0.0001916821, 0.000112748836, 7.047157e-05, 0.00025173003, 7.3355266e-05, 0.00029839226, -1.4341633e-05, 0.0002150388, 0.00013956237, 1.5492586e-05, 7.061297e-05, 0.00020973133, -6.194663e-05, -3.853612e-05, 0.0002405971, -6.3093226e-05, -0.00010058969, 8.270283e-05, 3.6908456e-05, 0.0001272491, -0.00015249936, -0.00015076576, 0.00013480744, 0.00026580383, 0.00028013406, -4.568585e-05, 0.00014302577, -4.4394505e-06, 0.00023132881, -0.00015769868, 8.305008e-05, -0.000118138436, 6.366648e-05, -0.00011947533, 0.00012429207, 0.00022797419, 0.00028195785, -5.9936898e-05, 0.00030030997, -4.509661e-05, -0.00011143127, -7.4650015e-05, -6.6628556e-05, 0.0003484781, -0.00011201778, -0.00037216189, 0.00039084663, -9.8347875e-05, 0.00017874269, 1.3039355e-05, -0.00021220518, 0.00010812494, 0.000100097095, -0.00015672565, 1.2717412e-05, 2.3466762e-05, 0.00021400806, -0.00013509458, -0.000670575, 0.00025141294, -0.0002292705, -0.0002961459, -0.00011218091, 0.00016954174, 2.56843e-05, -0.00013273627, 0.0004357485, -0.0002664218, -0.00023677958, -0.00018015543, -0.0003759518, -8.385213e-05, -5.025539e-05, -0.0005056106, -0.00025086117, -0.0004987386, 0.0001096769, 0.00017061435, -0.00010015276, 3.7355396e-05, -4.5122288e-05, -0.00053743366, 0.0001819678, -0.0003235888, 6.622125e-05, 0.00022187835, 0.00018583528, -0.000107604144, -0.00030646892, 0.00013759291, -0.000291531, 0.00020032203, 7.007244e-06, -0.00024383653, -0.00017235093, -3.4044566e-05, 0.00020425845, -0.00019930232, 0.00020225195, -0.00024602388, -4.6920522e-05, -0.00035267894, -0.00010699226, -0.00021147443, -0.00015843908, -0.0002055938, -0.00015756066, -0.00021290347, 0.00010608916, -4.484002e-06, -0.00012798795, 5.8685753e-05, 0.00010315623, -0.0002645646, -2.64519e-05, -0.00021304196, 0.00018157593, 0.00013657768, 4.675373e-06, -0.00029763643, -0.00032091918, 1.2456956e-05, 0.0005603384, -0.00012937038, 0.00048535803, -0.00019799381, 0.00020809364, -0.0003369853, 0.00019682698, -0.0002319654, 8.787884e-05, 0.000508193, 0.0007203857, -0.0001275964, 0.0007119558, -0.00010047709, -0.0002262918, 8.4627485e-05, -1.9998135e-05, 0.00091901486, -0.00023231268, -0.0008181902, 0.00072280905, -0.00023494803, 0.00044705352, 0.00021898972, -0.00050239015, 0.00038088794, 0.00022966778, -0.00038262698, -7.1588576e-05, 1.07870555e-05, 0.0005084894, 7.9287296e-05, -0.00020271915, 2.0130328e-05, -0.00059329695, 0.00046676793, -0.00021750174, 0.00019368516, -0.0004224503, 0.00031525863, -0.00044213043, -0.00037064304, -0.00082558196, 0.0002611263, -0.0007108239, 0.00019930731, 0.00034560772, 0.00034749947, 0.00029331114, -0.0009522234, 0.00032663273, 0.0010468996, -0.0009057824, 0.0004084842, -0.00061932753, 0.00011308723, 0.00056276814, -0.00026749703, -0.00040502124, 0.00044337267, -7.208939e-05, 0.00010918482, -0.0005279373, 0.0002099905, 0.00024648922, -4.8737384e-05, 0.00011216378, 0.00010962615, -7.0405025e-05, -9.1861206e-05, 0.00012636014, 4.4456527e-05, -0.00029056278, -9.1945025e-05, 1.1045994e-05, -6.409767e-05, 9.362909e-05, -7.2216244e-05, -4.2420037e-05, 0.0002742332, 0.0001010182, 6.4573884e-05, -1.5093955e-05, 3.127269e-05, -0.00021694587, 2.579732e-05, 5.768152e-05, 0.00021057816, -5.572999e-05, 9.687601e-05, 3.1249143e-05, 1.4825245e-05, -0.00016949522, -0.00011752721, -6.4815795e-05, -3.405678e-06, 0.00033439073, -0.00015343569, 0.000107253894, 3.686069e-05, 0.00015604017, -5.7404995e-05, 3.6893653e-05, 7.649838e-06, 3.3122014e-05, 0.0002667229, 0.00029010026, 7.3933654e-05, 0.00027862086, 8.239138e-05, -4.442486e-05, 9.000814e-05, 4.470267e-05, 0.00046902153, -9.936001e-05, -0.000255103, 0.000288413, -0.00014268242, 0.00015801373, 0.0002067627, -0.0002025719, 0.00020563771, 2.5407888e-05, -0.00022153174, -3.2893637e-05, 0.000106773026, 0.00030144118, -0.00020743377, -5.172783e-05, -3.471893e-05, -5.2095107e-05, -8.659904e-05, 6.527438e-05, -3.7803464e-05, -0.00017843183, -4.7223282e-05, 0.00022081209, 0.00024158634, 0.000101853926, 0.00012130929, 4.223171e-06, 0.000108315544, 4.8445232e-05, -0.00013646737, -3.1099986e-05, 0.00013743118, -2.8054901e-05, -0.00012543761, 0.00032953682, -2.2573338e-05, -4.0455765e-05, -0.0001061577, -1.2998611e-05, 2.1675884e-05, -7.121221e-05, -8.4862e-05, 0.00016632046, 0.00019096363, 0.00017659915, 4.709733e-05, -0.00026689598, 0.00012387424, -8.929823e-05, -7.942213e-05, -0.000102674596, 0.00012130287, 5.9531063e-05, 1.6891315e-07, 4.751503e-05, -0.00022361756, -0.0001766168, -0.0001031101, -0.00019074524, -7.8342295e-05, -2.4926312e-05, -0.0001055269, -6.826492e-05, -0.00033187584, 0.00010299791, 0.000171273, -0.00022441596, 6.938664e-05, -7.7002165e-05, -0.00016269548, 0.00011633504, -0.0001852962, 2.8257491e-05, 0.00016226184, 4.4052762e-05, -0.00015219604, -0.00023559849, -0.00012589173, 2.5268126e-05, 4.3605964e-06, 0.00016428025, -6.672376e-05, 6.642257e-05, 5.889302e-06, -3.755424e-05, 8.695161e-06, 3.25089e-05, 0.00013702134, 0.00013560156, 7.247094e-05, 0.0001814955, 3.4177916e-05, -1.4120441e-05, -0.000115450086, -7.506255e-05, 0.00015820813, -0.00010747591, -0.00019156972, 0.00027572722, -6.93288e-05, 3.9746395e-05, -9.616521e-06, -8.084678e-05, 1.1315622e-05, 7.118178e-06, -9.698838e-05, 5.7423535e-05, 9.427355e-05, 0.00020160642, -0.00013184408, 0.00028285882, -0.00014563894, 0.000116130715, 4.870736e-05, 0.00019303904, -1.5624826e-05, -7.7696386e-05, 6.715328e-05, 7.2771218e-06, 0.00032324443, 0.00023198128, 0.0002032804, 0.00027688706, 0.00011055628, 1.1299815e-05, 7.1261966e-05, 5.5172764e-05, 0.00038583518, -0.0001300449, -0.0002584825, 0.00035915754, -0.00013982467, 5.6218374e-05, 0.00017512724, -0.00012458122, 0.00021900734, -4.430616e-05, -0.00020313576, 2.3059776e-05, 0.00020858175, 0.000364517, 9.314151e-05, 0.00018229155, -9.180183e-05, -6.0462597e-05, 0.00020902242, -2.1926387e-05, -6.051586e-05, -4.77115e-05, 7.5697986e-05, -0.0002290075, -3.1802483e-05, -5.3457683e-05, 6.51263e-05, -4.0028197e-05, 3.2458665e-05, 9.7531876e-05, 0.00026033894, 0.000148746, 3.3974684e-06, 4.1784635e-05, 0.0001204227, -0.00019094095, 5.8432448e-05, -7.8258614e-05, 0.00018201566, 4.3468157e-05, 7.137621e-05, -6.675854e-05, 2.5772679e-06, -7.8515775e-05, 2.4509116e-06, -2.7858967e-05, 7.985353e-05, -0.00019267606, 9.56353e-05, 5.607996e-05, -9.821972e-05, -9.310665e-05, -1.7737184e-06, 0.00015357512, -8.4826686e-05, 2.5407859e-05, -0.00019604016, -3.155742e-05, -0.00018605113, -4.1742886e-05, -0.00016666402, -7.6764525e-05, -0.00011692418, -0.000105987914, -0.00015259629, 2.7673526e-05, -1.6253623e-05, -0.000114147064, -3.824744e-06, 7.128448e-05, -0.0001514887, -4.5721026e-07, -0.00013210071, 0.00013371599, 5.8291313e-05, -1.4003255e-05, -0.00019255446, -0.00017558821, 6.6381945e-06, 0.00051750994, -0.00017206727, 0.0002462734, 3.3040127e-05, 0.00020263792, -0.00010275239, 6.9350805e-05, 1.4075596e-05, -5.137444e-05, 0.0003530054, 0.0004192479, 8.998659e-05, 0.0004435342, 6.9620706e-05, -7.296679e-05, 0.00021179079, 9.7689015e-05, 0.00064388796, -0.00014822616, -0.00041557243, 0.00038531024, -0.00015540591, 0.00019136307, 0.00032550094, -0.00026773845, 0.0003397099, 3.371732e-05, -0.00026031717, -6.60864e-05, 9.1585694e-05, 0.00040985816, 2.8811706e-05, -2.5651567e-05, 0.00017371083, -2.3855611e-05, -6.9146736e-05, -2.4134164e-05, -4.7591115e-05, 8.657969e-06, -0.00012123562, -0.0001177018, -0.0001214201, -9.583425e-05, -0.0001648632, -8.894008e-05, -8.074731e-05, -6.388207e-05, 0.00010915474, 9.0235626e-05, -0.00023524191, 9.0537396e-05, 0.00013253104, -0.00023673574, 0.0001937337, -3.2791155e-05, 6.728148e-06, 0.00013463947, 6.00853e-05, -5.0847e-06, 0.00028576067, -0.00015916346, -0.00013313092, -0.0002403661, 0.00014460656, -0.000100492834, 8.3106024e-05, 5.870658e-05, -0.0001445189, -0.00011108572, -8.648132e-05, 0.00021716175, -0.00013593126, 6.5422886e-05, -0.00016154617, 5.3655636e-05, -0.0002602024, 4.6837495e-06, -0.00018235725, -0.000126277, -7.678016e-05, -9.785206e-05, -3.545494e-05, 1.9773934e-05, -8.353473e-05, -0.000100758785, -2.2663511e-05, 0.00016343419, -0.00013774264, -8.389391e-05, -6.597216e-05, 0.00017081316, 3.999256e-05, -3.9410563e-05, -0.00022185876, -0.00016038229, -0.00016423748, -0.0004298052, 9.0418675e-05, -0.000345642, 0.00012997216, -8.732835e-05, 0.00025482487, -0.0002638026, 0.00016097692, 7.0990716e-08, -0.00025300542, -0.00045045442, 0.00018584315, -0.00049201236, 0.00015268411, 0.00021558694, -0.0001355525, 3.0198119e-06, -0.00059142965, 0.00014805951, 0.0005219151, -0.00033878812, 0.00017325729, -0.00037451656, -0.00018628739, 0.00038537174, -0.00026922516, -0.00021897863, 0.00024251436, 0.00013539879, 9.773284e-05, -0.00024432782, 7.6225515e-05, 0.00061726605, -0.0002238847, 0.00017396668, 8.869722e-05, 0.00015810346, -0.00025540133, 1.704893e-05, -4.9868155e-05, -5.0040697e-05, 0.0004175473, 0.00040826498, 5.448831e-05, 0.00042118796, 6.363191e-05, -5.3802636e-05, 0.00031657188, 0.00016547226, 0.0006955748, -0.00010465569, -0.00038551932, 0.00037291477, -0.00011433668, 0.00020009557, 0.0003725624, -0.00030628685, 0.00036873826, 2.1497486e-05, -0.000291123, -0.0001095053, 0.000117883836, 0.00035926315, 0.000258213, 0.0005002692, -9.947819e-05, 0.00012224866, 0.00018742536, 6.693881e-05, -0.0001438789, 0.00014988382, 1.1371155e-05, -0.0003652018, 2.8855004e-05, 0.000114262424, -7.9923826e-05, 0.00023274503, -4.9366354e-05, -6.322693e-05, 0.0004327856, 0.00021058359, 0.00023308827, -2.43322e-05, -2.9240296e-05, -0.00019762579, 9.590506e-06, 0.00014682105, 0.00040694003, -0.00012707652, 0.00027628973, 4.6557398e-05, -2.0805572e-05, -0.00031494643, -9.067087e-05, 2.6843305e-05, -1.1289227e-05, 5.7319544e-06, -3.0150748e-05, 7.3091e-05, -7.81437e-06, 2.1750573e-05, 6.2277875e-05, 5.4855125e-05, 5.3772324e-05, 3.609899e-05, 6.314752e-06, 6.037511e-05, 3.7532944e-05, 7.910718e-05, 2.0086543e-05, -1.7553946e-05, -7.3398485e-05, -6.3381456e-05, 0.00010482054, -6.109315e-05, -7.927415e-05, 9.070914e-05, -9.020054e-05, 4.6867266e-05, 3.384808e-06, -6.2532104e-05, -1.6411364e-05, 2.7160142e-05, -9.094165e-05, 3.5825113e-05, 1.4590673e-05, 9.884422e-05, -0.00018135883, 0.00040537305, -0.00025839682, 6.6126624e-05, 0.00024138331, 0.00020017184, -1.8005958e-05, -0.00022418317, 0.00019333838, -0.00014775353, 0.00036988745, 0.0002001053, 0.00039390198, 0.00024132087, 0.00026164931, 0.00014146589, 0.00018628573, 0.0001378716, 0.00045783783, -0.00015806443, -0.0001379964, 0.00033258792, -0.00012098208, -4.58648e-05, 0.00031476805, -7.514909e-05, 0.00025272113, -0.00017717232, -0.00025763566, 2.4816496e-05, 0.00036302418, 0.00046717183, -0.00012810774, -0.0005711778, 0.00018360818, -0.00025025752, -8.30336e-05, -0.00016861838, 0.00012317157, -0.00014880819, -2.0316445e-05, 0.00016397766, -0.00026288195, -0.00035287155, -3.590464e-05, -0.0004070907, -2.549959e-05, 8.810257e-05, -0.00032300784, -0.00014673697, -0.0005954596, 0.00014144536, 0.00033408593, -0.00021198907, 0.00012949783, -0.00021645037, -0.00039490595, 0.00026025996, -0.0003763255, -5.1437437e-05, 0.00022540042, 0.00016456244, -2.3524872e-05, -0.00031293638, -2.9529936e-05, -0.00103413, 0.00038076748, -0.00052354345, 1.25254855e-05, -0.0003475897, 0.00048199785, -0.0001273443, 0.00017828553, 3.6659878e-07, -0.0008366104, -0.0009906442, -3.9170933e-05, -0.00096251856, -4.5935216e-05, 0.00017506108, -0.00034009296, -0.00012963617, -0.0014396447, 0.00031451037, 0.0010033598, -0.00096642994, 0.00034121156, -0.0005364902, -0.0005380257, 0.0006908222, -0.00063616596, -0.00017581764, 0.00064479053, 0.000118649106, -0.00020095614, -0.00084440695, 5.2261305e-05, 0.00021738793, -0.00014928174, 1.964409e-06, 0.00024056865, 8.834083e-05, 0.00012033749, 1.0121065e-05, 0.00022454975, -0.00023060336, -1.7222628e-05, -5.7529327e-05, 0.00021173651, 6.7378774e-06, 0.00014365143, 0.000110740446, 0.00020168549, 0.00011712146, 0.00010100243, -8.9359826e-05, 0.00011187527, -0.00014299103, -5.894672e-05, -4.508421e-05, 0.00025126623, 2.6304037e-05, 0.00015418818, -0.00010513254, -8.3566076e-05, -7.473221e-05, 0.0001076398, 0.0001464556, 7.908331e-05, -0.00037668488, 0.00021237279, -0.00012944425, -0.000116250725, -0.00019482976, 4.255454e-05, 6.0704366e-05, -8.697938e-05, 2.665979e-05, -0.0003398398, -0.000271001, -0.00023011836, -0.000273694, -0.00015250887, -6.0090904e-05, -0.00014972659, -9.6007236e-05, -0.00051158963, 0.00014813233, 0.00028117216, -0.00036141253, 0.00014131727, -6.136435e-05, -0.0002557639, 0.0001616092, -0.00027009685, 6.033739e-05, 0.00027995236, -2.4559564e-05, -0.00021240413, -0.00041249357, 0.00011907436, -0.0007119476, 0.0002669379, -0.0002443525, -6.5319226e-05, -0.00032256485, 0.00026796098, 0.00010861208, 7.262429e-05, 2.2135056e-05, -0.00066603953, -0.00058652763, -0.00018435034, -0.00056287425, -0.00016550715, 2.2755137e-05, -0.00027792805, -0.00018204555, -0.00090553245, 0.00018681194, 0.0005542663, -0.0006737454, 0.00015005037, -0.00021483008, -0.00042180932, 0.0003370841, -0.0004893731, 2.6918884e-05, 0.00037275426, 6.630843e-05, -0.00029209207, -0.0006160177, -9.1070506e-05, -3.903851e-05, 6.574368e-05, -5.003295e-06, -0.00010419314, 4.158148e-05, -8.026311e-05, -9.157001e-05, -0.00013563893, 9.638933e-05, 0.00013208644, 5.588706e-05, -5.857091e-05, 4.0280513e-05, -7.747262e-06, -3.2688156e-05, -8.865072e-05, -1.9975307e-05, -4.8939864e-06, 2.3692997e-05, -5.7650668e-05, 0.00015879257, 5.3175143e-05, 2.1832551e-05, -6.517479e-05, -1.6378404e-05, -1.8638126e-05, 1.0505214e-05, 3.6404126e-05, 1.6606806e-06, 4.9616225e-05, 9.751886e-06, -9.492673e-06, 0.00027678828, -0.00015149129, 1.8498085e-05, 7.2606395e-05, 9.0745336e-05, -8.19468e-05, -5.196538e-05, 2.6148324e-05, -4.0379055e-06, 0.00023347416, 0.00017086063, 0.00011758608, 0.00013185522, 0.000103258324, 3.2756223e-05, 0.0001510485, 9.686452e-05, 0.00033498963, -5.427173e-05, -0.00013894748, 0.00019101077, -5.60635e-05, 3.8363374e-05, 0.00017270313, -0.00010794043, 0.00018506547, -5.1269963e-05, -0.00015914315, 9.196963e-06, 0.00012916011, 0.00021977737, 7.780769e-05, 0.0007545693, -0.00031888802, 0.0005673248, -0.00011359299, 0.00027506636, -0.0004333017, 0.00027021646, -0.00022956263, 0.00015366443, 0.00067021995, 0.00091456797, -7.658506e-05, 0.000876729, -0.00010121534, -0.00019396452, 0.00013811987, -1.5467582e-05, 0.0012977638, -0.0003215452, -0.0010733492, 0.0009509717, -0.00040267518, 0.0005756953, 0.00031577778, -0.0006985677, 0.00048802004, 0.00029882186, -0.00068417634, -3.331222e-05, 5.9392365e-05, 0.000723427}},
    {"bert.encoder.layer.3.attention.output.dense.bias_grad", {-0.0013739341, 0.0015589454, -0.0006861603, -0.004989182, 0.0032584332, 0.00028189918, -0.011687614, 0.014709857, -0.00014642508, -0.0046723606, -0.0012100532, 0.0027722414, -0.0023598461, -0.0038098132, 0.00147678, 6.8827256e-05, -0.0065249577, 0.0028740126, -0.0012797068, 0.00801019, -0.0063593276, -0.0015389104, -0.0015528527, -0.0026274673, 0.0057583423, 0.015556114, 0.00048975355, 0.004452868, 0.008336011, -0.00030878794, -0.0024815132, -0.015995357}},
    {"bert.encoder.layer.3.attention.output.LayerNorm.weight_grad", {-0.0022200658, -0.0016372054, 0.0010776401, 0.002508189, 0.003865556, 0.0026989155, 1.08679815e-05, -0.0007848297, -0.0028880525, -0.002209559, 0.0012709522, -0.0004186844, -0.0023377, -0.0003855512, -0.0028338796, -0.0003824113, 0.0017341975, -0.00020414681, -0.0029825168, -0.00028366403, 0.0049970145, -0.0046638497, -0.00037439578, -0.0020348986, 0.00077978557, 0.0032636807, 0.00041794608, -0.0019762253, -0.0023806978, 0.0014205878, 3.8572543e-05, 0.006885873}},
    {"bert.encoder.layer.3.attention.output.LayerNorm.bias_grad", {-0.0013588212, 0.0015726573, -0.0006662843, -0.004977704, 0.0032717492, 0.00029209763, -0.011677878, 0.014734947, -0.00013305624, -0.0046597645, -0.0011930282, 0.002785931, -0.0023467091, -0.0037951728, 0.0014933287, 8.239513e-05, -0.0065106065, 0.002886739, -0.0012676533, 0.008032457, -0.006346019, -0.001524349, -0.00153808, -0.0026084625, 0.005776367, 0.015575866, 0.00050811213, 0.004466021, 0.008352829, -0.00029706905, -0.002465272, -0.015987739}},
    {"bert.encoder.layer.3.intermediate.dense.weight_grad", {0.00015583333, -0.00016788366, -0.00012231327, -0.0001674698, 1.272374e-05, -3.7246975e-06, 2.9625802e-05, -0.00015671195, -7.006188e-05, 0.00022187435, 5.3329153e-05, 9.30513e-05, 0.00023268315, -0.00011984176, 0.00013723444, 0.000118722106, -4.3572487e-05, 2.28947e-05, -0.0001900954, -8.757669e-05, -0.00023823835, -0.00011016705, 2.7608483e-05, 0.00015742637, -5.2853484e-05, 0.0001637081, 0.00020391203, -3.5689365e-05, -9.8356495e-06, -6.746196e-05, 3.55185e-05, -2.2647953e-05, -7.621478e-05, 0.00020676953, 8.6316715e-05, 9.050368e-05, 0.00011216867, 9.936613e-06, -1.2679971e-05, 0.00017209351, -1.3554525e-06, -0.00030055505, 8.154135e-05, 3.5858484e-05, -0.00030991805, -6.517105e-05, -8.9008535e-07, -0.0001378713, 3.0201862e-05, -0.00011685893, 0.00017920401, 1.4354534e-05, 0.00032460626, 3.152062e-05, -0.00013274093, -0.00012212193, 1.4997329e-06, -0.00016014917, -0.00013270689, 4.8485246e-05, 1.8447412e-05, 2.0889815e-05, 4.315251e-05, 6.168283e-05, -3.468652e-05, 0.00011475189, -1.4541256e-06, -7.671251e-05, 0.00018628112, -8.176913e-05, 1.9979521e-05, 6.2047957e-06, 9.529226e-05, -2.6452557e-05, 6.538172e-05, -7.800667e-05, -0.00021241103, -0.00010656121, 0.00014206886, 8.508111e-05, -2.5908098e-06, -3.2030308e-05, 1.0414313e-05, -0.00022122788, 5.048207e-06, 0.00015680437, -6.5885615e-05, 0.00013378124, 5.530578e-05, -5.2782594e-05, 9.013435e-06, 2.3621133e-05, -9.808944e-05, 6.4406e-05, -0.0001008065, 1.8031113e-05, 9.0415306e-05, -0.00019983287, -9.685131e-05, -0.00029544404, 8.221681e-05, -5.4752403e-05, 2.467755e-05, -0.0001255285, 9.208096e-06, 0.00028533032, 1.264576e-05, 2.4931136e-05, 0.000121487996, -0.00012146591, 0.00011797412, 0.00030411608, -0.00016428216, 2.8276885e-05, -0.00029865856, -6.5063205e-06, -0.0004066151, 3.019051e-05, 0.00010621937, 0.00015042844, -3.24899e-05, 0.00019140328, 0.00045642164, 7.113003e-05, -0.00013523505, -7.208382e-06, 2.7784738e-05, -0.00018998758, 9.542239e-05, -1.1913204e-06, 7.563406e-05, 0.00010209414, -2.2165825e-05, -1.46833145e-05, -1.3008017e-05, 4.8140457e-05, 1.9389076e-05, -9.5531635e-05, 7.496588e-05, -2.4019704e-05, -0.00012847077, 2.0947018e-05, -0.0001252638, -8.8244924e-05, -4.768952e-05, -5.9176623e-06, 5.017564e-05, 8.694994e-06, 5.823382e-05, -6.435049e-05, -5.3123484e-05, -4.495935e-05, 8.976637e-06, 6.469155e-05, -2.804782e-06, 6.121428e-05, -9.339646e-06, 5.029487e-05, 5.3977274e-05, -5.208789e-05, 5.015047e-05, 7.741787e-05, 5.9345504e-05, 7.873417e-05, -0.00030268187, -0.00025693708, -0.00016988341, 5.216568e-05, -5.0563987e-05, -0.00014175462, -0.00029829223, -0.0001482989, 5.3674616e-05, 2.2697172e-05, -0.00048101516, 1.3822047e-05, -5.7968646e-05, -5.1745283e-05, 0.00035985597, 0.00028237482, 0.0005305066, 0.00015996763, 0.00035709303, 2.0171407e-05, -0.00015241421, -0.00038092906, 3.064953e-06, 0.00020488094, 0.00018699949, -8.864643e-05, -2.3332435e-05, 9.154094e-05, -9.006167e-05, 5.2046238e-05, -7.1365655e-05, 2.871508e-05, 7.5090946e-05, 3.5412828e-05, 0.00013817653, -3.483753e-05, -2.5224439e-05, 2.3513072e-05, -8.740017e-06, -6.242012e-06, -1.0709699e-05, 5.886532e-05, 0.00023683903, 5.3864965e-06, 0.00013647547, 4.1276548e-05, -4.121933e-05, -7.797415e-05, -8.2082355e-05, 2.1295175e-05, -9.6318734e-05, 1.6232301e-06, 0.00010867231, -5.272666e-05, -0.00026832838, -0.0001514462, 5.6624476e-06, 7.239157e-05, -9.9450386e-05, 7.528499e-05, 8.384251e-05, -9.3260576e-05, -0.00010092535, -2.9315399e-05, 1.6803709e-06, 2.5189038e-05, 1.8336576e-05, -8.42665e-05, -2.6527994e-06, 0.00012683314, 2.8686067e-05, 1.6553124e-05, 0.00015071567, 1.0939834e-05, 0.00011315598, 4.320253e-05, 2.5584735e-05, 5.273052e-05, -0.00013393386, -0.00013213782, -0.000165775, -5.9948678e-05, 4.698354e-06, 0.000114467075, -1.4146174e-05, 9.016017e-05, 3.7119866e-05, -4.4410226e-05, -5.079308e-06, -4.012403e-05, -6.61173e-05, 2.8197566e-05, 9.9044744e-05, -7.742934e-05, 1.9026591e-05, -0.00027740494, -1.3621964e-05, -0.0001619879, -9.084361e-05, -0.00011977261, -5.5305107e-05, 0.00017191535, -0.00019006105, -9.064359e-05, -1.3709938e-05, -6.669801e-05, -0.00032607414, 0.0002877154, -0.00023989493, 2.4472765e-05, -2.8797396e-05, 0.00016624502, 2.0522984e-05, 0.00022877737, 0.00036712197, 6.7853354e-05, -0.00015050951, 1.9271843e-05, 0.00048250429, 0.00031606303, -6.7592046e-05, -0.00010150505, 2.4565501e-05, -0.00022324905, -4.3843513e-05, 5.1284824e-05, -6.1928346e-05, 0.00018379577, -9.854486e-05, -7.865148e-07, -1.0161895e-06, 2.240585e-05, -0.00011827667, -9.7931246e-05, -0.00010741672, 4.4992867e-05, 0.0001865743, 0.0001172514, 2.6503343e-05, -0.0001840388, 0.00021288685, 1.7080036e-05, 0.0001856822, 1.2338205e-05, 0.0002433012, -4.028748e-05, -9.012849e-05, -4.5663102e-05, 3.21485e-05, -0.00020842487, -0.00043953647, -0.0001535137, 0.00023280643, -4.306429e-05, -6.760364e-05, 0.00023295323, -9.336391e-05, 0.00013525871, 0.0001085116, 0.00012872671, 8.512439e-05, 5.4951273e-05, 2.8012078e-05, 6.129584e-05, 3.1600466e-05, -0.000118233474, 6.270491e-05, -2.7783182e-05, -0.00017100519, 1.637238e-05, 1.5783937e-05, -0.00012832665, 4.1440864e-05, 2.829844e-05, 4.116244e-05, -7.2346375e-05, 0.00014496078, -8.333092e-07, -0.00014940681, -0.00014238223, 2.489454e-06, 2.6868243e-05, -0.00012934071, -2.0221782e-05, -6.657211e-06, 3.7309364e-05, -1.8253037e-05, 2.7281822e-05, -6.75858e-05, 0.00013721053, 1.2573494e-05, -1.1222406e-05, -4.5186025e-06, -2.4108895e-05, -6.6387793e-06, 7.856694e-05, 2.4034862e-05, -0.00010716576, -0.000114154136, -7.842931e-05, -9.278169e-05, -4.3414348e-05, -4.38925e-06, 4.561733e-05, 8.5094484e-07, -6.115795e-05, 8.6456166e-05, 5.6303896e-05, 0.00017045418, 0.00014646842, 4.760437e-05, -9.305789e-06, 1.0627514e-05, -0.0001756418, -2.5910489e-05, 6.742761e-05, -2.5571856e-06, -4.3837324e-05, -0.00011408431, 0.00010270749, 0.00016509187, -0.00025811663, -7.832942e-05, -0.00020530875, -7.494582e-05, 3.7792808e-05, -9.22305e-05, -0.00016896367, -2.4409783e-05, 0.0002797782, -2.3424798e-05, 3.1858755e-05, 0.00035307824, -4.4643304e-05, -2.0569678e-06, 0.000119467164, -6.0340055e-05, -4.8658952e-05, -0.00015587913, 5.3817857e-05, -0.00034137632, -0.00015079715, 0.00020236136, 0.00020271422, -4.4324875e-05, 0.00015183915, 0.00024286288, 1.7775725e-05, 3.670772e-05, -0.000112113295, 9.446768e-05, -0.00010369383, 2.3466217e-05, -8.062687e-05, -8.296523e-06, -0.00015083795, 9.178823e-05, 5.8273217e-05, -5.921784e-07, -8.071687e-05, 1.4331213e-05, 0.00013388116, 7.288191e-05, 3.702702e-05, -3.3787535e-05, -9.031354e-05, 0.00011736872, 0.00013345342, -0.00010776817, -3.4449964e-05, -0.00016109855, -1.1633255e-05, -0.00021411305, -8.3645555e-06, 3.8283874e-06, 7.753389e-05, -2.747534e-05, 0.00011372568, 0.00028855124, 1.4262328e-06, -0.00010029166, -2.6408823e-05, 6.5596934e-05, -9.635864e-05, -0.00015762247, 0.00016492268, 0.0001024788, 0.00017666347, -1.1405701e-05, 3.103135e-05, 3.6956957e-05, 0.00012654686, 5.504074e-06, -0.00021458753, 1.5384062e-06, -5.1173993e-05, -0.00020974089, 5.1731462e-05, -4.734673e-05, -0.00011987496, 0.00010619339, 1.6976192e-05, 0.00013271396, 7.705053e-06, 0.00025257937, 8.1750164e-05, -0.00016191055, -0.00019037773, 4.017536e-05, -7.2904375e-05, -0.00018380635, -4.5469136e-05, -7.182854e-06, 9.011296e-05, -3.826222e-05, 8.6084896e-05, -9.261821e-05, 8.514249e-05, -9.3833325e-05, -3.6609777e-05, 5.974679e-05, 1.7588842e-05, 3.372281e-05, -1.1204237e-05, -0.00012410892, -1.3958611e-05, -4.094375e-05, 9.5347415e-05, 7.781541e-05, -4.361187e-05, 0.00027593138, 2.6955102e-05, 0.00019173091, -6.387692e-05, 2.8099597e-05, -3.5227666e-05, 9.321645e-05, -6.538484e-06, -9.162071e-05, 6.185168e-05, -4.8334838e-05, -0.00021051876, -0.00021016621, -0.00014013359, 0.00013237644, -7.6539094e-05, -7.642076e-05, 0.00023674047, 2.7575175e-05, 8.437592e-05, -7.917782e-05, -0.00016565909, 4.625134e-05, -0.00019765351, -3.3167823e-06, -2.0261155e-05, 6.2824256e-05, 4.4049924e-05, -0.0001869203, -0.00017854557, -2.4448967e-05, -9.90985e-05, -0.00011133489, 0.0002351338, -6.711696e-05, 2.0304615e-05, 4.9367598e-05, -2.5558884e-05, 6.241504e-05, 0.00031194036, 0.00018463997, 0.00017212552, 2.042253e-06, -0.00019457215, 8.686926e-05, 0.00017377478, -9.1381255e-05, 3.478263e-05, -0.0001647463, 1.1319587e-05, -0.00010067145, 9.5765245e-05, 0.00012746431, 4.096164e-05, -0.0001565572, -0.0001977993, -0.00017567642, 0.000174718, -1.95607e-05, -0.00020318611, -0.00016975895, 2.0933398e-05, -6.8699155e-05, -0.00010301847, -0.0004298485, -8.8363115e-05, -7.607451e-05, -0.00019652204, 0.00038563, 0.00037493772, 0.0005044587, 5.975358e-05, 0.00017708972, -0.00016200534, -0.00012995482, -0.00022547798, 5.829927e-05, 0.00022698296, 0.0001712777, -1.9310775e-05, 0.00015427046, -5.0057744e-05, -4.8269667e-05, 4.904701e-05, 3.314161e-05, 0.00021234341, -7.2984956e-05, 4.4508735e-05, 5.0876562e-05, 8.819956e-05, -0.00010684913, -0.00016551027, 8.855978e-05, 9.358465e-05, -3.2307213e-05, 9.585489e-05, 1.7057035e-05, -0.00023773847, 0.00011828072, 5.6082163e-06, 0.00017378671, 2.1042653e-05, 0.0002171519, -0.00013828311, -0.00017841138, -0.00011661092, -6.900291e-07, -7.5729164e-05, -0.00030603484, -0.00012869705, 0.000120165496, -1.8673221e-05, 6.4834785e-05, 0.0001327458, 5.125458e-05, -0.00010862197, -4.12274e-05, -0.0001395553, 1.9184042e-06, -1.3485803e-05, 9.554461e-08, -6.2491505e-05, 2.3485505e-05, 0.00013018763, -4.349694e-05, -4.1362696e-07, 0.000106648506, -3.238298e-05, 2.6681886e-05, 0.0001610739, -7.126889e-05, 1.5415793e-05, -0.00013301893, 3.3195018e-05, -0.00016848765, 5.287016e-05, 6.819439e-05, 6.382983e-05, -1.7746628e-05, 5.6635938e-05, 0.00017187207, 5.8359783e-06, -4.1695133e-05, -4.4745444e-05, -1.9913289e-06, -4.8565646e-05, 1.7553595e-05, -2.634333e-05, -4.978591e-05, 9.705002e-05, 1.9354546e-05, 6.921931e-05, 5.915676e-05, 6.747505e-07, -7.9431185e-05, -3.486621e-05, 9.117193e-05, 9.679711e-05, 2.3511322e-05, 4.859159e-05, 9.6944466e-05, -0.000108331886, 0.00010444926, 1.2056433e-05, 6.1662076e-06, -9.698847e-05, 1.0549063e-05, -9.9021185e-05, -0.00014649535, -8.442981e-06, 7.647709e-06, 5.1302803e-05, -0.00016600052, -0.00011530759, 6.29944e-05, -4.6091936e-05, -5.1033962e-06, 0.00010701879, 4.1513198e-05, -7.394895e-05, -0.00013011762, -0.00023490726, 0.00017064494, -3.1386164e-05, 5.660346e-05, -0.00018361742, 8.125927e-05, 0.00029506854, 3.9221184e-05, -3.647475e-05, 4.5382956e-05, -0.00018020633, 0.00028907286, 0.00028090132, -0.000105699015, 6.6419474e-05, -0.0002616055, -0.00022786246, -0.0003886019, 5.8989805e-05, 1.0643814e-05, 0.00022051216, 3.8741973e-07, 0.00016877372, 0.00036153285, 1.6830034e-05, -0.000168712, 1.834599e-05, -9.58709e-05, -0.00010309235, -0.00019626909, 8.986727e-05, 1.5757862e-05, 0.00021152473, 9.428791e-05, 0.00014837127, 8.0083366e-05, 2.353046e-05, -4.3349784e-05, -0.00014546522, 0.00020590855, 0.00013094387, -4.0959014e-05, 7.341003e-05, 0.000355034, -0.00027482194, 0.00024047193, -1.8080598e-05, -2.2136082e-05, -0.00011934782, 4.2642023e-05, -0.0001839136, -0.00032387665, -4.7891896e-05, 9.153719e-05, 2.2218204e-05, -0.00036775277, -0.00031476698, 4.5427485e-05, 4.5703706e-05, -5.3870376e-06, 0.00018729872, -0.00021689227, 0.0003415941, 0.00010029163, 0.00025069728, -1.762944e-05, 1.38638425e-05, 9.360964e-05, 0.00020633206, -9.3327246e-05, -0.00044659767, -8.186515e-06, 3.86493e-05, -0.00027617748, -2.1718008e-05, 5.359812e-05, -0.00028916355, 0.00024392862, -0.00017557043, 0.00040963956, 0.00012173317, 0.0006241255, 6.154817e-05, -0.0002671027, -0.00026651812, -1.9843766e-05, -0.00036808304, -0.000526186, -4.7588794e-05, 0.00018387317, -9.996158e-06, 9.648656e-06, 0.00029744813, 1.0151184e-05, -8.178243e-05, -0.0001431657, -0.00017408957, 6.6948895e-05, -7.950695e-05, 5.024377e-06, -0.00022464691, -7.987413e-06, 0.0003208224, -9.67054e-05, -5.1142626e-05, 0.00020080102, -3.5302484e-05, 7.6349235e-05, 0.00021322399, -3.398115e-05, 0.0001637723, -0.0001649035, -0.00017717296, -0.0002906182, 7.312709e-05, 0.00019724606, 0.0001568253, -3.801664e-05, 9.7535434e-05, 0.0001900449, 2.2952094e-05, -4.076516e-05, 5.435016e-05, -0.00015105915, -5.832821e-05, -3.4698263e-05, -1.3736227e-05, 1.5926964e-06, 9.577041e-05, 0.00010615232, 0.00014623102, 8.2268816e-05, 1.4818319e-07, 5.6770565e-05, 3.308407e-05, 0.00019308557, 8.443437e-05, -6.1711056e-05, 5.6493736e-05, 0.00024715747, -7.388533e-05, 0.00010619548, -4.2678832e-05, -0.00015837127, -0.00017383396, -0.00015135201, -0.00011386955, -0.0002228279, -4.3712633e-05, 7.889542e-05, 0.00019282677, -0.00019143565, -0.00029040838, -2.9912104e-05, 6.73708e-05, 1.5727732e-05, 3.822778e-05, -1.9049965e-05, -1.9545258e-05, -2.8877494e-06, -5.4517554e-05, 2.2371962e-05, 8.5174644e-05, 1.6419148e-05, -1.1390958e-05, 4.9051014e-05, 2.8649318e-05, 4.033665e-05, 8.101667e-06, -8.983798e-08, -4.92001e-05, 0.00014067676, 5.1320945e-05, 3.4122557e-05, -3.428592e-05, -7.8402496e-05, -4.0492778e-05, -0.000112399786, -3.1981912e-05, -6.531507e-05, 3.954201e-06, 3.705919e-05, 6.859465e-05, 2.2640079e-05, -7.307487e-05, -8.590484e-06, -2.2237396e-05, 1.014233e-05, 4.847025e-06, -5.9586262e-05, 8.2013656e-05, 9.944143e-05, 0.0001987955, -0.0002558106, -6.1605e-05, -9.896374e-05, 0.00019454102, -0.00010907162, -0.00027456638, -0.0001390511, 5.882685e-05, 4.1927477e-05, 4.4529108e-05, -0.00026639955, -0.00020033037, 9.616902e-05, -0.00015291382, 0.00035961732, 0.00033348674, 0.0005080367, -2.3399865e-05, -2.3358101e-05, -0.0002067099, -9.433646e-05, -0.00029192172, -0.00025524158, 4.3259788e-05, 0.00025876402, -8.932394e-05, 8.354907e-05, 0.00019963263, -0.00013998662, 0.0002262972, 2.7326782e-06, -2.8150993e-05, 0.00029308573, -1.32952555e-05, 7.8302764e-05, -5.878887e-05, 0.00011082156, 2.285222e-05, 3.133693e-05, -0.0001334788, -0.00027815005, -8.499451e-06, 0.00010976166, 3.253939e-05, 5.2815426e-06, 4.565618e-05, -4.6976846e-05, -0.0002331502, -5.104792e-05, 0.00017626079, -4.7160356e-05, 1.9347508e-05, 0.000121709454, 1.3525488e-05, -0.00010735268, -9.5117605e-07, -0.00017336101, 0.0002235746, -0.00013818931, -5.454632e-05, -0.00011138143, 0.00019518443, 3.396784e-05, 0.00049691397, -0.00018367455, 0.00011395271, 0.00010979521, 0.0002615539, -0.00021896015, -0.00046878913, 1.7467155e-05, 9.053448e-05, -0.00015206894, 0.0002426257, 1.2891826e-06, -0.0005046452, 0.00031945456, -3.5943283e-06, 0.00045533624, 7.5304866e-05, 0.00060282525, -0.00011043575, -0.00031576576, -0.0002282199, 1.8114797e-05, -0.00036812024, -0.0007173222, -0.0001256121, 0.00023894219, -0.00013177344, -6.181026e-05, 0.00042891118, -0.00018195207, 0.0002239036, 8.999597e-06, 0.000116788666, -0.00010259781, -4.4806988e-05, -2.1157333e-05, 0.00015027884, -8.031649e-06, -0.00023979766, -9.989655e-05, 1.964246e-05, -3.1063657e-05, -6.479006e-05, 7.030761e-05, -8.840751e-05, 0.0002005053, -0.00014446127, 0.0002494183, 0.00010608061, 0.00035829848, 4.023571e-05, -0.00011792854, -0.00012390812, 1.9352622e-06, -0.000298041, -0.00034725346, -2.188362e-05, 0.00018654615, 2.0713893e-05, -9.432412e-05, 0.00027664672, 8.205153e-05, -1.673135e-05, 0.00012616273, 8.2627615e-05, -0.00018848026, -0.00014941703, -0.00015967626, 9.1106114e-05, -8.4916275e-05, -9.888976e-05, -0.00013058355, -2.7180506e-05, 1.4518022e-05, 6.509146e-05, -0.00051134836, -0.00011620282, -0.00014193474, -4.6484296e-05, 0.00025608068, 0.0002709579, 0.0003235486, 4.996381e-06, 0.00021969537, -0.00010443559, -0.00011684459, -0.00013370387, 6.4999214e-05, 0.00023232024, 0.00010823467, 1.9981951e-05, 0.00013682325, -7.2366915e-05, 2.1685606e-05, 7.75299e-05, 3.934483e-05, -8.3361956e-05, -7.809666e-05, -0.00010330877, -3.470062e-05, -3.7725763e-06, 1.8365174e-05, 1.0670074e-05, -0.00014575021, -8.030709e-05, -3.2547716e-05, -2.7267071e-05, -0.00017223426, 9.247722e-05, -8.5085194e-05, -5.809921e-06, 9.423678e-05, 7.306483e-05, 0.00020431967, 0.00013700963, 0.00016338551, -3.353179e-05, -6.283201e-05, -0.00014160427, 5.799515e-05, 9.012268e-05, 6.996914e-06, -1.72443e-06, 3.1099393e-05, -2.6369014e-05, -4.0730533e-06, 0.000198696, 0.00013446124, -4.4335866e-05, 0.0002719204, -0.00013209617, 4.5472967e-05, -7.012799e-05, 0.000107488646, -3.183959e-05, -1.6172431e-05, -0.00019597136, -0.00039538564, 1.676358e-05, -0.00023208576, 7.861193e-05, -0.00021299234, 5.0942555e-05, -3.70344e-05, -9.7502954e-05, 4.2037187e-05, 0.00029525647, 0.00014669646, 1.6372811e-05, 7.214918e-05, 0.00012553972, 8.25099e-05, 0.00019617316, -0.00027699876, 0.00021859189, -9.07733e-05, -0.0002622943, -1.7001297e-05, -2.6355538e-05, 2.8721583e-05, 9.823545e-05, -0.000262441, -6.538683e-05, -0.00018467064, 6.875051e-05, -0.00013415549, -0.00013668706, -0.000176329, 9.7777964e-05, 0.00010757206, 2.0949037e-05, -0.00025541248, -0.00010700174, 6.7388006e-05, -5.4087926e-05, 0.00027342586, 0.0003693095, 0.00032032575, -3.6082478e-05, 6.680562e-05, -0.000113959315, -0.00015973921, -0.00024390689, 2.4766161e-06, 0.00015856692, 0.00028511634, -0.00019979117, 0.00013359838, 7.398873e-05, 9.577483e-05, -6.721144e-05, -3.7071604e-05, -0.0001594942, -0.00019619432, -0.00012849273, -4.028434e-05, -7.309543e-05, 1.563539e-05, 0.0001304757, -0.00031668812, -0.00015166077, 0.00017955617, 2.859283e-06, -0.00024520862, 0.00027129106, -0.00013017807, 6.11572e-05, 1.6921977e-05, 0.00020832304, -2.83038e-06, 0.00018688507, 0.00032446315, 9.366195e-06, -4.9827766e-05, -0.00010730423, 0.00021176138, 0.00017527456, 5.442167e-06, -4.8027858e-05, -4.8813836e-05, -9.280337e-05, 6.9349764e-05, 3.7060447e-05, -4.0338597e-05, -8.717361e-05, 0.000100534744, -7.7473574e-05, 6.944605e-05, -1.4520936e-05, 4.4656586e-05, 3.4120574e-05, -1.0307954e-05, -8.161351e-05, -7.0951595e-05, -5.402116e-05, 2.7481174e-05, 0.000109821696, -8.3469364e-05, 6.104659e-05, -3.6013298e-05, -0.00011190967, -5.8941514e-05, 0.00013345057, 5.917156e-06, 6.383644e-05, 3.3412845e-05, -8.3163695e-06, 4.876141e-05, 9.3827955e-05, -0.00012475207, 5.1466126e-05, -7.657216e-05, -4.7814814e-05}},
    {"bert.encoder.layer.3.intermediate.dense.bias_grad", {0.00030120122, -0.00035978254, -2.3428905e-05, 0.0005559667, -4.536307e-05, 3.5266006e-05, -0.00019369996, 0.00013904017, 0.00057323754, -0.00036337582, -0.00025524566, -9.622546e-05, 0.0004562644, 0.0002358243, -0.00035705196, -0.00020444552, 0.00023176413, -0.00010520201, -0.00042604998, 0.00025361386, -0.0001838291, 0.00038522086, -0.00054001017, -0.0007986337, 0.0003954099, -0.00020819553, -6.079144e-06, -0.0003716259, -7.601775e-05, -0.0009696202, -0.00046583783, 9.745578e-05, 7.5482894e-05, 0.00018667987, -7.6511424e-05, 0.00040424056, 0.00012733656}},
    {"bert.encoder.layer.3.output.dense.weight_grad", {-9.679302e-05, 0.00010579729, -0.00010155724, -9.37287e-05, 0.00014795433, 6.125742e-05, -5.8370097e-05, -0.00011038815, -0.00011905678, -0.00010785968, -1.566563e-05, 7.0644215e-05, 2.0423493e-05, 2.381321e-05, -0.00026824008, -0.0001951229, -1.0993538e-05, 6.734739e-05, 0.00014106363, 1.3688985e-05, 2.7612748e-05, 1.3040348e-05, -8.186501e-05, -0.00013064478, 4.7632075e-05, 5.9355312e-05, 1.8604378e-05, -6.3518884e-05, -8.466961e-05, -2.0689784e-05, -1.8895173e-05, -4.1600193e-05, -0.00023173404, 0.00015377806, 2.8019462e-05, 1.4518999e-05, 5.861125e-05, 5.656665e-05, -4.6726553e-05, 7.442194e-05, 6.987579e-05, -3.4186156e-05, -4.1753323e-05, 8.802591e-06, 5.5442117e-05, 4.5445217e-05, 2.9647646e-05, 1.0395919e-05, -2.0827167e-05, 2.0795242e-05, 3.2463773e-05, 3.579217e-05, 6.749634e-05, -2.7131618e-05, 4.9573922e-05, -1.4014826e-05, -8.735376e-05, 6.321192e-05, 4.0641546e-05, 3.1194788e-05, -3.293081e-05, -7.987464e-06, 2.6870222e-05, -1.5483964e-05, 4.1748328e-05, 1.0300518e-05, 2.4045514e-05, 9.020426e-05, 2.7626193e-05, -8.1757696e-07, -4.2845175e-05, -6.5344448e-06, -2.2082355e-05, 6.755164e-05, 5.026114e-05, 0.00012221216, 5.566642e-07, -8.62723e-05, 0.00023969806, 0.00021094373, -1.6181644e-05, -0.00019222524, -0.00022378624, -3.741023e-05, 3.201684e-05, 4.8052425e-05, 1.2408329e-05, -2.2115208e-05, 6.428443e-05, -8.651915e-05, 0.00010774731, -0.00012493866, 3.7736772e-05, 0.0002269434, -0.00010645353, 0.00014703823, -0.00010553045, 0.00012169224, 6.132458e-05, -0.00011026137, 7.145984e-05, -0.00010858374, 0.00018023653, 1.5707577e-05, -0.00031007384, -0.0001306069, -0.00018334368, 0.00020597348, 5.0205486e-05, 1.3085289e-05, 0.00014777764, -0.00018426297, 2.399206e-05, -2.5002242e-05, -5.3280204e-05, 1.7352619e-05, -5.9882816e-05, 7.534121e-05, -0.000121061166, 2.0857105e-05, -0.00012431167, -7.745388e-05, -9.704006e-05, -1.4007909e-05, -5.488693e-05, -0.00033328813, -0.000101609054, -3.0764477e-05, 6.643709e-05, 1.146883e-05, 5.4268537e-05, -0.00017410786, -0.00012806169, -5.1005838e-05, -8.346916e-05, -0.000110182445, -1.7291619e-05, 1.3209361e-06, 1.151548e-05, -0.00012603465, -0.00010123565, 0.00012007397, 1.12536745e-05, -8.514298e-05, 0.00011354692, 7.4042428e-06, -1.8275457e-05, -7.9868434e-05, -6.6068584e-05, -3.0085259e-05, 0.00010178865, 5.8432805e-05, 0.00024196626, -0.00014568216, -0.00012341244, -8.161619e-05, -1.1253274e-05, 2.8422107e-07, 4.14943e-05, 0.000100110155, 9.4108356e-05, 6.685407e-05, -0.00028245847, -2.2365417e-05, -0.0002256482, 0.0002137921, 0.00025046137, -0.00016753393, 0.00023713814, 5.878982e-05, -6.9464564e-05, -0.00019327123, -0.00012005757, 0.00014010684, 9.541683e-06, -5.91489e-05, -3.8474944e-05, -2.0564434e-05, 0.00030511824, 5.574906e-05, -0.0002830665, -6.743682e-06, 9.394033e-05, -0.00010092378, 0.00023933203, -6.0447906e-05, -0.00015867998, 2.1347922e-05, 0.0001498519, -0.000105875675, -0.00022230424, -3.842432e-06, 1.5102827e-05, 0.00016151193, 2.7048236e-06, 3.1695716e-05, -8.272551e-05, -3.2928328e-06, 2.0045773e-05, -0.00017651681, 3.810705e-05, -0.00019552419, 0.00015176188, 2.9924628e-05, -0.0002284339, 0.00014773657, -0.00014756956, 5.0765848e-05, -0.00021026499, -0.00019543937, 0.00010678032, -4.4680794e-05, 0.000115937626, -0.00017879962, -4.8354086e-05, 0.00042127437, 0.00014117015, -0.00010237763, -0.00014178808, 2.1442433e-05, -8.738996e-05, -7.029351e-05, -0.00018601275, 1.9888545e-05, -0.0002585642, -8.638907e-05, -0.00017156788, -9.7599484e-05, 0.00012937868, -0.00025553643, -2.265899e-05, -0.00018609742, 2.1135496e-05, -0.0002316209, -9.626239e-05, -0.00015718641, -0.00040816277, -0.00025045712, -6.3814165e-05, -5.262043e-05, -6.135485e-05, 8.148336e-05, -0.00027739335, -0.00033015647, -2.0268115e-05, -0.0001499508, -0.00011233265, -8.279257e-05, 1.6237838e-05, 0.00016557678, -0.00028200308, -9.699153e-05, 9.960412e-05, 3.2041005e-06, -0.00021438263, 0.0001273378, -1.2878797e-05, 2.3980381e-05, -0.00032968758, 0.000511942, -0.00013344103, 0.00043093262, 0.00013324246, -3.2667933e-05, 0.00024381153, -1.6126924e-06, 0.0004404484, 4.1620413e-05, 0.00041537595, -2.4561272e-05, 0.00011948201, -2.0399739e-05, 0.000102952006, 0.0010805227, 0.0005391425, 0.00017672172, -0.00017716923, -0.00015588965, -2.3400156e-05, 0.0001316768, 0.0004864414, 0.00011999774, 0.00050997117, 0.0002304837, -8.049704e-05, 6.1375606e-05, -8.63108e-05, 0.0006434972, 0.00020791219, -0.00040285898, -7.3002448e-06, 0.0006594598, -0.00032477226, -0.00015928224, 4.5183242e-08, 0.00029607298, 4.408519e-05, -4.310895e-05, -0.00010752507, 3.955738e-05, -0.0002526224, 1.6237236e-05, 2.4156856e-05, 0.00016192991, 0.000113000315, 1.3676293e-05, 3.3970933e-05, -4.1970216e-05, -5.0289724e-05, 1.3431596e-06, 0.00016834245, 3.997695e-05, 7.901157e-05, -3.833218e-05, -0.00015507336, -9.430365e-05, 1.7610822e-05, -6.166234e-05, 0.00010674719, 8.704932e-06, 5.5238055e-05, -8.538703e-06, -5.7465655e-05, 0.00012032161, -9.2621245e-05, 1.3355916e-05, -2.6885698e-05, 1.5215016e-05, 0.00015956661, -7.3741554e-05, -3.868019e-05, 5.9504884e-05, -0.0001499998, -6.2218605e-05, 7.158513e-05, -0.00017026275, -7.9891826e-05, -4.337943e-06, -3.7603542e-05, -3.570496e-06, -0.000116980664, 1.750759e-05, -2.6597756e-05, -3.5200497e-05, -1.9939944e-06, -8.151116e-06, -3.963843e-05, -0.00020055051, -0.00014483536, 2.5714466e-05, -7.656039e-05, -6.0029524e-05, 0.00010617928, -9.328779e-05, -0.0001444008, -2.1427919e-05, 1.4430991e-05, 2.5512145e-05, -3.3225886e-05, -8.086952e-05, -2.5654293e-05, -0.00011042105, 2.4438721e-05, -9.46357e-05, -5.4110656e-05, -2.760381e-05, 0.00010579265, 9.88582e-05, 4.4526572e-05, -0.00010383144, 8.80113e-05, 3.5298035e-05, 8.971828e-05, -8.449074e-06, 0.00021105958, 3.876475e-05, 1.2328039e-05, -0.00022769005, -0.00018403491, 1.9013047e-05, 2.1354663e-05, -5.7090678e-05, 1.3956566e-05, 1.1050267e-05, -8.649811e-05, -6.858264e-05, -6.643173e-05, -4.0834868e-05, 8.6868014e-05, 9.424673e-05, -0.000103725884, 0.00010535406, -8.2266626e-05, 1.67747e-05, -4.0269446e-05, -9.048186e-05, 5.6869772e-05, -3.8709277e-05, 0.00015182632, 4.1871845e-06, -8.618694e-05, -4.8268936e-05, -0.00021907275, 0.00015397124, 3.482834e-05, -4.50179e-05, 0.00024188982, -3.8175942e-05, -3.5383375e-05, 4.674592e-05, 5.278203e-05, 2.8641367e-05, -8.9097455e-05, -6.902763e-05, 5.432352e-05, 8.651681e-05, 2.8836976e-05, -2.4564945e-06, 6.317022e-05, 4.581635e-05, 8.749317e-06, -5.308643e-06, 5.135256e-05, -8.550716e-05, 7.367556e-05, 6.31094e-05, -8.030823e-05, 0.00016677572, -2.1557635e-05, 1.6007109e-05, -5.7544996e-05, -3.445067e-05, 7.8888595e-05, -2.9675315e-05, -2.8601085e-05, -5.0239887e-05, -1.0474953e-05, 0.00017862357, 7.13248e-05, 3.6849022e-05, -0.00010785674, 1.5993479e-05, -3.4206612e-05, 1.922377e-05, -0.00021613948, 0.0001364919, -0.00010089217, -0.0001406232, 0.00016458945, 3.0080973e-05, -2.5075065e-05, -0.00011801063, -1.1992691e-05, -0.000108323016, -3.5739162e-05, 8.2321036e-05, 7.5696735e-05, -2.5823581e-05, -0.0002994598, -0.00017482054, 2.7272737e-05, 4.907758e-05, 9.065194e-05, 0.00010623445, -5.1528194e-05, -0.00010930493, -9.5144176e-05, -2.0664536e-05, -7.767351e-06, 3.209519e-05, -3.2329156e-06, -9.136638e-05, -0.00010627081, -9.2643415e-05, 1.7913308e-05, -3.888195e-05, -0.00010464389, 0.00015116698, 9.889229e-05, 1.0626405e-05, 2.6052223e-05, -6.782631e-05, 0.00013236911, -7.105164e-05, -0.00010781146, 0.00010804306, 6.5221095e-05, -5.8355886e-07, -8.31066e-05, -0.00011995876, -0.00013208827, -0.00011204132, 2.1016926e-05, -3.5730256e-05, -2.5185333e-05, -0.00016495344, -0.000103599144, 0.00012423444, -4.3300715e-05, -5.8400925e-05, 0.00016299846, -0.00020237752, -2.4345638e-05, -5.6961624e-05, 6.768422e-06, 8.388409e-05, -7.042347e-06, -2.0457042e-05, -0.00010405717, 6.0182965e-06, 6.054702e-06, -0.00022503771, -0.00010126276, -4.186271e-05, 0.00018217169, 7.1293657e-06, 7.369721e-05, -7.1986804e-05, 0.0002443501, -6.178648e-05, 8.9855865e-05, 0.000113992406, -0.00024228677, 3.6597776e-05, 6.789461e-05, 0.0001412594, -3.4057084e-05, 7.942461e-05, 4.1218293e-05, -0.00011445536, -5.435621e-05, 8.160538e-05, 0.0003595118, 0.0001377442, 8.597152e-05, -9.990393e-05, -0.00016751187, -3.1694504e-05, -7.1815135e-05, 0.00012382232, 0.00013894665, 4.655679e-05, 8.639606e-05, -9.17399e-05, -1.2877445e-05, 0.00010728568, 0.00014069978, 7.067352e-05, -0.00013569227, -1.2132484e-05, 0.00015709335, -7.214169e-05, -0.00012895511, 3.0244204e-05, 1.4636592e-05, -0.00012002677, -6.2169995e-05, -5.33142e-05, 9.369196e-07, -6.246055e-05, -0.00010038169, -2.263897e-05, 4.5178844e-05, 0.00013966954, -2.430086e-05, -8.76201e-06, 8.992412e-06, -2.6020121e-05, -6.215641e-05, -0.00013144723, -8.6481505e-06, -9.414747e-05, 0.00011428948, 7.1932554e-05, -0.00012604504, 0.00011601155, -0.00010077569, -1.3023385e-05, -6.4531676e-05, -4.8097903e-05, 9.593497e-05, -1.9267545e-06, 4.1841573e-05, -0.00016521549, -4.4408487e-05, 0.000215379, 8.66855e-05, -3.5467452e-05, -0.00010983811, -1.85576e-05, -3.204664e-05, -0.0001433422, -0.00012838004, 6.613202e-05, -0.00010107383, -0.00010735298, -0.000101234495, 9.934585e-06, 6.280626e-05, -9.25115e-05, -5.7546178e-05, -0.00014483678, -4.534981e-05, -8.6296524e-05, -2.5376015e-05, -9.089719e-05, -0.00018805143, -0.00012767507, 0.000110075925, -4.0410225e-05, -9.709754e-05, 0.00015458642, -0.00023674688, -0.0001233384, 8.123947e-06, -1.1529762e-06, 3.8411967e-05, -0.00012338685, -1.583101e-05, 4.5221215e-05, -0.00015042046, -7.3940006e-05, -8.2135906e-05, -5.266349e-05, -2.8807384e-05, 0.00015544471, -4.260214e-05, 6.727066e-05, -0.00016179308, 0.0001040802, -0.00015928828, 0.00019240715, 7.582052e-05, -0.00016461227, 3.552301e-05, 0.00015807101, 0.0001609646, 0.00017534701, 0.00014946131, -3.1769112e-05, -0.00015003754, -8.40922e-05, -2.1728158e-05, 0.0003524477, 0.00022916685, -1.2996027e-05, -2.2703329e-05, -8.461509e-05, -6.225497e-05, -6.537358e-05, 8.564165e-05, 5.272969e-05, 0.00019050571, -6.8774476e-05, -4.8760056e-05, 4.8760878e-05, 0.00011336641, 0.00015201097, -1.1328598e-05, 2.3939652e-05, 7.1724775e-05, 0.0003218185, -0.00019487547, -9.447251e-05, -4.1801926e-05, -1.0625338e-05, -9.433934e-05, -5.8140427e-05, -0.00015936288, 6.194712e-05, -9.789559e-05, -0.00017681187, -2.908727e-05, 7.5984294e-06, 0.00014494332, 6.143885e-06, 7.315736e-05, -5.1027087e-06, -1.5306136e-06, -1.9730769e-05, -0.00010521154, -4.040048e-05, -0.00014309748, 2.5290772e-05, 1.2547749e-05, -0.00012822347, 0.00015379691, -0.00023104029, 3.8690636e-05, -0.00013471801, -0.00011137464, 0.00012078475, -6.483876e-05, 7.025152e-05, -0.00021287329, -5.985385e-06, 0.00025479257, 9.466656e-05, -1.3222406e-05, -0.0001503982, 7.4272415e-05, -3.5145156e-05, -0.00019520047, 0.00021972944, -2.3276236e-05, 0.00028214132, 5.828528e-05, 0.00020060664, 0.00012960371, -7.2852235e-05, 3.4357112e-05, -0.00016845392, 0.00015336032, 1.7194083e-05, 0.00010452537, 6.741694e-05, 0.00010538929, 0.00029437838, 0.00014895326, 1.8998957e-05, -1.1597357e-06, 0.00013651878, 3.213519e-05, 0.00014200652, 0.00033374177, -4.4673772e-05, 0.000121887315, 5.4542965e-05, -4.3795033e-05, 8.431974e-05, -0.00012581756, 0.0003332382, 6.704215e-05, -0.00012083639, -2.7155178e-05, -1.1939242e-05, -1.1613995e-05, -3.775037e-05, -4.4813347e-05, 0.00038253918, -5.7110745e-05, 4.968244e-05, -6.8972826e-05, -3.8737166e-05, -0.00016378815, -9.732797e-05, 9.418969e-05, -5.0695922e-05, -8.938559e-06, -7.55662e-05, -1.9685353e-05, -0.00013998536, -3.4204484e-05, -8.2115344e-05, -9.486025e-05, -3.1442727e-05, 6.457371e-05, -7.8780016e-05, -0.00016662988, 0.00015037724, -0.00027628537, -0.00017591337, 5.0955292e-05, 6.03814e-05, 7.035467e-06, -0.00011852472, -6.159416e-05, 6.449345e-05, -7.845198e-05, -4.037929e-05, -7.3181436e-05, -5.118068e-05, 0.00010751178, 7.3975745e-05, 1.2826685e-05, 5.8959595e-05, -0.00015174175, 0.00019967834, -0.0001422975, -0.00010169203, 6.1929444e-05, -0.00042668037, 4.944122e-05, 0.00012394847, 0.00020320278, 0.00012251083, 0.000110043766, 8.610746e-06, -0.0001411504, -0.00015883632, -1.7608396e-05, 0.00040746666, 0.00013906008, 0.00011918611, -0.0001981737, -0.00029115, -5.8407983e-05, -0.0001113259, -4.8089452e-05, 0.00017097741, 9.9141376e-05, 5.7867972e-05, -0.00010741564, -1.6665395e-05, 0.00018705027, 8.695632e-06, 0.00010592238, -0.00017772155, 1.1489477e-05, 0.00035554945, -0.00018073253, -0.00013800313, 9.607525e-05, -0.00034184067, -0.00010631323, 4.7446832e-05, -8.154529e-05, -5.3999498e-05, 3.108154e-05, -3.195902e-05, -8.520453e-05, -1.0385835e-05, -8.517625e-06, -7.231051e-05, -4.4667235e-05, 8.4506646e-05, 1.88386e-05, -6.938667e-06, -0.00019192902, -8.37026e-05, 3.0513813e-05, 3.1966963e-05, 4.6037067e-06, -9.820915e-06, 1.1962398e-05, -7.208283e-05, 2.3675591e-07, -9.0926915e-05, 3.0888343e-05, 3.4477063e-05, -3.30294e-05, -3.767553e-05, -0.00011797693, -2.5028776e-05, 2.9826704e-05, -1.2762617e-05, -7.515277e-05, 5.8996513e-05, 2.3482587e-06, 3.1774e-05, -5.717148e-05, -4.5932382e-05, 0.0002129874, -7.682288e-05, -0.00020221219, 0.00015725412, 0.00013115189, -4.6860856e-05, -6.6909684e-05, -0.00017089059, -5.1234983e-05, -9.259199e-05, 0.000118446245, 1.2731778e-05, -3.9704435e-05, -5.5400244e-05, -0.0001249485, 0.00020972377, -0.00013332385, -5.192326e-05, 0.000287846, -0.00020646343, 4.627651e-06, -7.302778e-05, 0.00019437967, 0.00019370674, -8.33144e-05, -2.9708353e-05, -0.00017280552, 0.00010128326, 5.3327667e-06, -0.00039121715, -0.00015418464, 6.239076e-05, 0.00021912523, 4.1189553e-05, 0.00010683599, 3.7609003e-05, 5.446011e-05, -1.1167989e-05, 0.00015528903, 4.0096387e-05, 0.00017295305, -7.400327e-07, -8.9789966e-05, 3.0147487e-05, -3.2721997e-05, 4.6540936e-05, 3.609449e-05, 0.00010897318, 7.3486575e-05, 4.306069e-05, 5.8594618e-05, 7.023308e-05, -8.947368e-05, 9.7881275e-05, 0.00017043426, -9.017158e-05, 0.00019979918, 0.00014906077, -5.827695e-05, -1.9494977e-05, -2.9604587e-05, 0.000108800145, 6.184056e-05, -8.715591e-05, 0.00015222207, -6.663982e-06, 0.0001050448, 4.5696695e-05, -0.00012716191, -6.383653e-05, 8.275944e-06, -8.1512764e-05, 0.00022895003, 0.000109792694, -4.5481484e-05, 0.00025168617, 9.435217e-05, 0.00031481875, 0.00015644624, -0.00020799162, 0.00023450873, -1.3810035e-05, 0.0001384627, 0.00010436764, 0.00035660132, 0.00015609873, 0.00011525864, 0.00046199403, 0.00026480068, -4.19113e-05, 0.00015541025, 0.00029321105, -0.00019393855, 0.0005573925, 0.00036764846, -4.3712265e-05, 4.375765e-05, 6.385579e-05, 0.0002121463, 0.00014175799, -0.00017156459, 0.00024324274, 7.72053e-05, 7.163429e-05, 6.237988e-05, 4.6865905e-05, -0.0002491626, -1.1463395e-05, -8.812209e-05, 0.0003413667, 0.00017032094, 7.4057316e-05, -0.00015919076, -5.67595e-05, 8.803078e-06, 0.00022255773, -3.1256717e-05, -3.2107913e-05, -0.00019573804, 4.1608204e-05, 0.00010861551, 8.7838474e-05, 1.1645289e-05, 9.527002e-05, 0.00022405869, -0.000101178906, 0.00013033634, -0.0001709008, -2.266008e-05, 8.7924636e-05, 3.8879705e-05, 9.7904354e-05, 2.6534157e-05, 3.6279573e-05, 0.00016886287, -0.00011218498, 3.402298e-05, -1.1869453e-06, 6.159644e-05, 0.00011158213, -0.0003315089, -0.00012051436, -4.3368986e-05, 9.507971e-05, 1.7744855e-05, 9.5988915e-05, 1.6084836e-05, 6.428889e-05, -0.00014894277, 0.00013399444, 0.00012180104, -6.51976e-05, -0.000105142084, -1.3065858e-05, 0.0001669967, 0.00016410631, 9.77192e-05, -2.9661758e-05, -6.727402e-06, -3.0730916e-05, 4.1977626e-05, 6.0892664e-05, 0.00014922225, -0.00012422554, 0.00013345637, 4.149025e-05, -0.00023576137, 0.00019723462, 5.1891937e-05, 3.332527e-05, -6.276113e-05, -4.8787864e-05, 0.00012974215, -1.2463224e-05, 4.354596e-05, 5.2318705e-06, 3.921984e-05, 0.00023428389, 0.000114464216, 8.6183376e-05, -0.00019817112, -5.5352335e-05, -6.184476e-05, 1.3129544e-05, -0.00010639877, -2.6802914e-05, 9.223706e-07, 6.0751434e-05, 0.00010582223, -6.1868996e-05, -0.0001908498, 0.00019797115, 0.0001425595, 3.453002e-05, 7.242067e-05, 0.00026429733, 0.00013765409, 7.637164e-05, 7.524516e-05, 0.000101603575, -7.580991e-05, 0.00017228245, 0.00017008766, -0.00022556212, 0.00043132357, 5.0731946e-05, 2.224127e-05, -9.966051e-05, -2.6666383e-05, 0.00021641348, -2.115391e-05, -9.6639866e-05, -0.000112750604, -1.2579203e-05, 0.0002540692, 0.00010119278, 3.966698e-05, -0.00020622638, 5.7663277e-05, -4.4093696e-05, 7.122668e-05, -3.443755e-05, -5.970681e-05, 0.00014757366, -1.1838704e-05, 8.522853e-06, -4.433541e-06, 0.00014406792, 5.0643807e-06, 0.00015044413, 6.4176325e-05, -9.879582e-05, -0.000109776636, -2.0613972e-05, -3.303747e-05, -3.757712e-05, 6.636558e-05, -4.6142126e-05, 4.356205e-05, -5.2943865e-06, 1.3908056e-05, -0.000115985684, 4.035448e-05, -5.3092997e-05, 0.00011618329, -9.607484e-05, -1.9109139e-05, 1.8740293e-05, 1.5473677e-05, 7.407986e-05, -3.509033e-05, 8.617583e-05, 3.4712397e-05, 0.00011494572, -2.031939e-05, 1.7038619e-06, -6.636668e-05, 5.7095967e-05, 1.4177875e-05, 3.181728e-05, 8.189462e-05, -2.8055507e-05, -2.8638995e-05, -3.3797663e-05, 4.00242e-05, -4.999728e-05, -3.6971316e-05, 1.0862943e-05, -8.8170214e-05, -0.00010218807, -3.1984506e-05, -2.7150052e-05, -7.7255456e-05, -7.1020844e-07, 4.549981e-05, -4.1128325e-05, -6.3817664e-05, 0.00013128512, -0.00020727779, 8.960198e-06, -5.534998e-06, 0.00010122233, 2.1445861e-05, -0.00011928222, -5.00146e-05, -2.8048102e-05, 5.2995005e-05, -2.3507011e-05, -0.00011099067, -4.3350374e-05, 0.00010121048, 0.00010198938, -1.4613756e-05, 2.167539e-05, 7.809104e-05, -0.00026086037, 0.0001167284, -0.00046444687, -3.8253384e-05, -0.00020511425, -0.00013118693, 0.00015026439, -0.00034527312, -0.00010565329, -0.0003509359, 0.000108828965, -0.00024998945, -6.519772e-05, -0.000100302124, -0.00053636264, -0.00037660694, -2.1963577e-05, -0.00010556465, -0.00015664753, 0.00013910825, -0.00034002194, -0.00044739188, 7.802695e-06, -0.0003366502, -0.00016922095, -6.4750944e-05, -5.2884323e-05, 0.00018321494, -0.00040995088, -0.00010281488, 7.990069e-05, -5.2579864e-05, -0.00041994365, 0.00025671345, 8.640756e-05, 5.483416e-05, -0.0004698587}},
    {"bert.encoder.layer.3.output.dense.bias_grad", {-0.0014016663, 0.0015529087, -0.0006819683, -0.00495541, 0.003243065, 0.00029174372, -0.011741764, 0.014732865, -9.607794e-05, -0.0047085555, -0.0011410448, 0.0027900133, -0.002312078, -0.003757866, 0.0014878131, 0.000109716784, -0.006502017, 0.0028491474, -0.0012858078, 0.008020126, -0.006449641, -0.0015827195, -0.0015048836, -0.0026594484, 0.0057984116, 0.015483224, 0.0004912264, 0.004462483, 0.00826992, -0.000311023, -0.0024534026, -0.016037297}},
    {"bert.encoder.layer.3.output.LayerNorm.weight_grad", {-0.0022296193, -0.0016252191, 0.0010976368, 0.0025017613, 0.0038385617, 0.0027127806, 4.1776584e-06, -0.0008189614, -0.002883804, -0.0022168758, 0.0012835744, -0.00041698752, -0.002365801, -0.0003984262, -0.002826103, -0.00035474813, 0.0017151863, -0.00021019872, -0.002971114, -0.00027542686, 0.0050609116, -0.004647764, -0.0004126955, -0.0020405783, 0.00082310836, 0.0032413614, 0.0004246743, -0.0019591087, -0.00236744, 0.0014248904, 4.6058616e-05, 0.0068453676}},
    {"bert.encoder.layer.3.output.LayerNorm.bias_grad", {-0.001382304, 0.0015534931, -0.0006775833, -0.004952703, 0.0032358493, 0.00029335413, -0.011731568, 0.01473656, -8.716924e-05, -0.00470511, -0.0011362951, 0.0027968725, -0.0023050623, -0.0037475063, 0.0014923539, 0.00012236068, -0.006497353, 0.0028491253, -0.001279169, 0.00802912, -0.0064382884, -0.0015756147, -0.0014972871, -0.0026525622, 0.0058014314, 0.015491152, 0.0005100649, 0.0044609243, 0.008276663, -0.00030957934, -0.002441897, -0.016029274}},
    {"bert.encoder.layer.4.attention.self.query.weight_grad", {-8.0684015e-07, -2.7040942e-06, 1.1597378e-06, 1.3521822e-06, -2.1069359e-06, 8.4489324e-07, 1.12669916e-07, 8.185218e-07, -2.2666582e-06, -3.267227e-06, -5.9206275e-07, 1.0367046e-06, 1.2383268e-06, 2.054423e-06, 1.3447145e-07, -4.680843e-06, 3.23853e-06, -2.8934116e-06, 2.4265632e-06, 9.027565e-07, -1.40142e-06, 7.8506747e-07, -5.778933e-07, 1.7988723e-06, 3.0847825e-06, -1.4351225e-07, 9.174273e-07, 1.5631488e-06, 3.1375594e-06, -4.111505e-06, -1.3420232e-06, 2.877873e-07, -2.2184032e-07, -3.85154e-07, -4.2259717e-07, -1.5590821e-07, -1.0370741e-06, -2.2033973e-08, 2.1911663e-07, -6.8718754e-07, 7.2851026e-07, -5.4300926e-07, 2.0457071e-07, -7.929553e-07, 4.352868e-07, -1.8777875e-07, -2.4839425e-08, -6.879471e-08, 8.399517e-07, 9.2520673e-07, -1.0941785e-06, -4.382159e-07, 2.097644e-08, 8.440518e-07, 8.075381e-07, 4.2042421e-07, 6.4828237e-07, 4.5796307e-07, 5.892274e-07, 3.7925162e-07, 1.2499646e-07, -7.018832e-07, -7.94627e-07, -6.7277945e-08, -8.227693e-07, -9.304639e-07, -3.7231212e-07, -1.6851205e-06, 1.7068203e-06, 1.5980129e-06, -8.18198e-07, -1.173528e-06, -2.2343077e-06, 2.606334e-06, -1.8828036e-06, 9.603945e-07, 2.099159e-06, -5.11001e-07, -9.558105e-07, 8.575638e-07, 1.8826863e-07, -1.6309872e-06, 2.5927613e-07, 1.1749986e-06, -2.5715653e-06, 5.309278e-07, 1.575347e-06, 5.650683e-07, -7.867363e-07, 1.4199717e-06, 1.382402e-06, -7.672693e-08, 1.8081066e-06, -1.5910081e-06, -1.3458179e-06, 6.5650744e-07, 8.3359726e-07, -1.2299703e-06, 6.5709884e-08, 4.9012874e-07, -1.7933514e-06, -8.604306e-07, -3.311902e-07, 2.2353464e-07, -1.4888366e-07, -1.5424685e-07, -8.5013284e-07, 1.8467696e-07, 1.2361455e-06, 1.8419584e-06, -2.9752011e-06, -1.075188e-06, 5.2359053e-07, 1.6354666e-07, 6.545214e-07, 1.11453595e-07, 1.598712e-06, 3.3853863e-07, 1.2563031e-06, -1.3671205e-07, -3.890112e-08, 4.4664066e-08, 6.075862e-07, 3.3371398e-07, 8.5795165e-07, -1.2911129e-06, 5.2992483e-08, -5.340055e-07, 5.3127997e-07, 1.9177623e-06, 3.0740367e-07, 1.5041668e-06, -8.0872303e-07, -9.4125306e-07, 3.3472506e-07, -3.061873e-07, -2.1263513e-06, -3.6636396e-07, -2.529474e-07, 1.8183836e-07, -1.4838837e-06, 5.893723e-07, -4.4829343e-07, 2.7211635e-07, -8.785631e-07, 1.5874224e-06, 1.2355226e-06, 6.4324104e-07, 2.9789749e-06, -1.3485929e-07, 3.5913533e-07, -1.5598375e-06, -1.7442828e-06, -9.744668e-07, -2.183279e-06, -5.046962e-07, -1.8251355e-07, 5.656289e-07, 2.761493e-07, 1.6117609e-06, -2.3718808e-06, -1.0290944e-06, 2.0397824e-06, 4.2877107e-07, -1.9867682e-06, -5.2125245e-07, 4.477358e-07, -8.875634e-07, -1.233169e-06, -1.6468116e-06, -3.7684694e-07, -8.471519e-07, 8.7269615e-07, 4.300966e-07, -2.3431462e-06, -2.36346e-06, 3.4004834e-06, -3.117015e-06, 1.7893367e-06, 1.730799e-06, 1.734689e-06, 6.419549e-07, 1.6435528e-06, 1.0590899e-06, 1.6776213e-06, 7.8776145e-07, -1.9664937e-07, 1.7182437e-06, 3.0752035e-06, -2.7839546e-06, -1.5698356e-06, -2.0321652e-07, 1.027623e-06, -1.8087997e-06, -1.6213486e-06, -1.6957232e-06, -5.483541e-08, -4.2048683e-07, -1.2175308e-06, -1.1264517e-06, 1.264531e-06, 4.7776703e-06, -7.4175534e-07, -1.8040699e-07, 4.6609875e-06, 6.777473e-07, -6.53996e-07, 1.0563203e-06, -1.3916231e-06, 2.4540593e-06, -2.1822807e-06, -2.2172756e-06, -1.5084884e-06, -1.0301184e-06, 2.0364641e-06, -2.1000264e-07, -1.8486178e-06, 1.1146525e-06, 2.2562713e-06, -5.7927525e-07, 4.1306528e-08, -6.497832e-08, 2.7657515e-07, -1.0902127e-06, -6.7533995e-07, 1.7775156e-06, 1.6025166e-06, 1.5898644e-06, -5.8492463e-07, -1.3952662e-07, 8.2320935e-07, 1.6689862e-06, -2.478091e-06, -3.2593935e-06, -1.5605538e-07, 7.771261e-07, -1.498713e-06, -4.1565744e-07, 9.3318783e-07, -7.350099e-07, 2.555866e-07, -2.257193e-06, 2.3303292e-06, 1.4636472e-06, 1.7897668e-06, -8.3340765e-08, -2.0699508e-06, -7.516778e-07, -1.3806911e-07, -1.3161583e-06, -1.4186853e-06, 2.4405296e-07, 9.559411e-08, 1.472126e-07, 2.3746654e-07, 2.2417232e-06, 6.931718e-07, -2.8419201e-06, 1.5532881e-06, -2.7745657e-06, 2.8202574e-06, 9.0271715e-07, -3.3503989e-07, -8.334481e-07, 2.4270962e-06, 6.855874e-06, 2.4522726e-06, 4.5796207e-07, 2.9346022e-06, 1.6615462e-06, 9.09032e-07, -1.749797e-07, -2.4867913e-07, 4.6943913e-07, -3.301323e-06, -4.095702e-06, -4.472479e-06, -1.5730903e-06, -1.8705549e-06, -1.0202798e-06, -5.8019447e-07, 2.5989407e-06, 3.3389601e-06, -3.2790094e-06, 5.962054e-07, -7.3530094e-07, 1.6970733e-06, -4.2318684e-06, 1.4478411e-07, 1.5488174e-06, -2.5561446e-06, -6.984133e-07, -6.3387375e-07, -1.0294e-06, 3.3839135e-07, 1.7057578e-06, 1.0120563e-06, -1.9025114e-06, -3.0092929e-06, -1.5410294e-06, -8.313203e-07, -1.2152715e-06, -1.186773e-06, 1.2220379e-06, -1.6491515e-06, 9.872658e-08, 5.066322e-07, 6.57569e-07, -8.3453335e-07, 2.0644538e-06, 2.0650766e-06, 2.7923672e-06, 2.4216024e-06, -2.309548e-06, -6.2732096e-07, 1.3880632e-06, -1.0530317e-06, 3.3372069e-06, -1.9722377e-06, 1.7463105e-06, -2.339399e-08, -3.818716e-06, -2.6268e-06, -6.7464117e-07, 2.8012475e-06, 1.8034052e-06, -7.169791e-07, 2.4212175e-06, 3.2957983e-06, 3.441633e-06, 1.850979e-06, -2.5610058e-07, 1.9376118e-06, 2.6715447e-06, 3.8551804e-07, -4.2503907e-06, -5.4348214e-07, 1.262603e-06, -3.2458365e-06, -4.8154334e-06, -4.7557546e-06, -2.6048423e-07, 3.3855633e-07, 3.2949197e-06, 3.188723e-06, 1.4958827e-06, 3.6866084e-06, -2.1299809e-06, -1.7691136e-06, -4.1365558e-07, -1.0967257e-06, -2.4787576e-06, 7.1299337e-07, -1.3157985e-06, 1.5804619e-06, -5.588577e-07, -8.599135e-08, 7.952734e-07, -8.111406e-07, -1.954948e-06, 2.7217735e-07, 1.1787762e-06, 8.7296587e-07, -3.7210017e-07, 4.822131e-08, -6.2301285e-07, -8.5760286e-07, 8.598526e-07, -1.7127849e-06, 8.3018904e-08, -1.1581615e-06, 1.6821593e-06, -3.3149145e-06, -3.3284465e-08, -1.6650293e-07, 2.706454e-07, 1.4203529e-07, 3.2751607e-06, 4.8709508e-06, 8.231539e-08, -7.8291083e-07, -1.0212549e-06, -3.4452537e-08, -1.9232873e-06, 2.948754e-07, -1.4281322e-06, -5.9018464e-07, -4.3290905e-07, 1.0513758e-06, 2.6523148e-07, 1.8581702e-07, -6.971884e-08, 1.4901613e-06, 3.375573e-06, 2.049029e-06, 4.4371728e-07, 1.5233974e-06, 1.2667223e-06, 2.3429227e-06, -3.625761e-07, 1.1862729e-06, 8.3569984e-07, -2.6430614e-06, -5.305403e-06, -1.3588027e-06, -1.3080213e-06, -1.1475352e-06, 1.07178266e-07, -3.489545e-07, 1.7705004e-06, -1.1289023e-06, -2.534029e-06, 6.0533665e-07, 7.8739504e-07, 8.405408e-08, -1.0070287e-06, -3.5494563e-07, 2.9857947e-06, -3.422047e-07, -2.1757112e-06, -3.3312342e-06, -2.832071e-06, 8.641717e-07, 1.9378274e-06, 1.2919339e-06, -2.7419433e-06, -2.5459776e-06, -2.803977e-07, -3.5060688e-07, -9.730632e-07, -2.1103447e-06, 3.2871874e-06, -7.1010413e-07, -8.833431e-08, 8.4277934e-07, 8.360363e-08, 3.893804e-06, 2.0796638e-06, 2.9965713e-06, -7.1396875e-07, -5.275516e-07, -2.4944861e-06, -2.4446563e-06, 7.850118e-07, 4.8651475e-07, 2.3878708e-06, -5.391119e-07, 1.6339785e-06, 9.647788e-07, -9.548916e-07, 2.2121208e-06, 1.4424232e-06, 4.8865486e-06, 1.4532853e-06, -7.6280776e-07, -6.5774776e-07, -3.3213128e-06, 6.858655e-06, -3.3259565e-07, 5.722897e-07, 2.346048e-06, 1.2906291e-06, 2.4876078e-06, -4.2297156e-06, -4.0641032e-07, 1.5437344e-06, -5.829743e-07, -1.6622589e-06, -6.7072438e-06, -2.008043e-06, -4.614856e-06, 8.0568554e-07, -1.3108556e-06, 1.2868413e-06, 1.6171913e-06, -2.0121329e-06, 1.2710772e-06, -5.9537416e-07, -6.2245033e-07, -2.5724069e-07, 1.2510123e-06, -4.738869e-06, -2.7281637e-06, -1.3963627e-06, 7.8036754e-07, 1.3229175e-06, -2.3358532e-06, -3.7747472e-07, 2.9131095e-06, 3.0435874e-06, 1.4537692e-06, -1.2193151e-06, 1.3784482e-06, 3.494735e-06, -1.868907e-06, -3.6063705e-06, -5.093521e-07, 2.7727108e-06, -1.9768925e-06, -1.6797474e-06, -3.9128154e-06, 6.1816576e-07, 1.7202593e-06, 4.8249644e-06, 3.9707234e-06, -1.3415305e-07, 4.2857073e-06, -7.324942e-07, -7.8370107e-07, -1.9982515e-06, -1.1194394e-06, -2.7123128e-06, 7.9633867e-07, -3.1781133e-07, -6.7980875e-07, -9.923953e-07, -8.746264e-07, -1.3353196e-06, 5.886711e-07, 5.80461e-07, 1.1431827e-06, 1.3335289e-06, -9.35758e-08, -3.418604e-07, 1.5441861e-06, 5.5496764e-07, -4.829931e-07, -4.7597638e-07, 3.6169556e-07, 2.547731e-06, -1.4532527e-06, -2.6342298e-06, 1.396548e-06, -7.2330374e-07, 1.1292905e-06, 1.6429512e-06, 8.4344066e-07, -1.8775828e-06, -7.702981e-07, 9.3603035e-08, -6.9571695e-07, 3.338214e-07, 5.4426164e-07, -1.6859283e-06, 3.4594572e-07, 4.704811e-07, -3.8273572e-07, -1.3535117e-06, -2.245928e-06, -1.2486141e-06, 2.7101493e-07, -3.890722e-07, 2.7142141e-06, 6.35403e-07, -7.953994e-07, -2.1187452e-06, 9.466884e-07, -1.2835743e-06, 3.1580154e-07, 2.1417611e-06, 6.4974377e-09, 8.3715787e-07, -3.783722e-07, -1.3728078e-06, 2.8417136e-07, 8.049932e-07, 2.2860445e-06, 1.8584112e-06, -7.4471465e-08, -1.8020746e-06, -1.3320914e-06, -2.1491256e-07, -8.357422e-07, 1.4553245e-06, 4.5834398e-07, -4.201231e-09, -2.295737e-07, -6.418778e-08, -6.7693867e-07, -1.8621388e-06, 3.2907392e-09, -9.0770556e-07, 2.4808924e-07, 1.361512e-07, 7.944764e-07, 6.464037e-09, -5.8813674e-07, -7.6834914e-07, 9.1477847e-07, -1.1140585e-06, 1.2939295e-09, 1.091418e-06, -1.07069994e-07, -5.2896917e-07, -7.006459e-07, -4.3753838e-07, 1.0807282e-06, 5.1067815e-07, 1.5491265e-06, 8.7245263e-07, 6.551064e-07, -1.0829161e-06, 9.123364e-07, 1.413171e-06, -3.9370084e-07, 3.6378236e-08, 5.829982e-07, -1.3470082e-06, 4.5311475e-07, -2.1611052e-06, 1.6762514e-06, 1.0738831e-06, -1.3599569e-06, -7.370498e-08, 5.6497715e-08, 9.705365e-07, 3.2504926e-07, 3.4595317e-07, 3.363259e-07, 5.8757115e-07, 6.589599e-07, 1.2325819e-06, -3.6610782e-06, -3.3213533e-07, 4.1858098e-07, -2.2658407e-06, -2.918261e-07, 1.482957e-07, -1.78682e-06, 3.5180588e-07, -2.3249962e-07, -5.593084e-07, 7.419752e-07, 3.346805e-06, 1.0981469e-06, -1.9315466e-07, 1.8462006e-06, -1.2361329e-06, -7.586133e-07, -7.563608e-07, -1.0362272e-06, -2.385604e-06, -3.4785348e-08, -1.8583371e-07, 1.4707896e-07, 1.1424127e-06, -4.1202938e-07, 5.436188e-07, 1.2938614e-06, 1.371302e-06, 1.9985434e-06, -1.3147454e-07, 2.768778e-06, 1.3799103e-06, 1.1670821e-06, -3.5531189e-06, 2.0049927e-06, -3.3768436e-07, -1.7585545e-06, -1.5459821e-06, -2.062173e-06, -6.803812e-07, -9.4132554e-07, -4.0404e-07, 6.0585063e-07, 2.1542855e-06, 1.6383619e-06, 6.989836e-07, 8.474219e-07, -2.2791266e-06, -1.5692312e-06, -4.4491233e-07, -4.3132496e-07, -1.073218e-06, -2.7053959e-08, -1.3825276e-06, -1.6515556e-07, -4.0655138e-07, 7.2575136e-07, 1.2998479e-06, 1.3900301e-06, -5.709519e-07, 1.253869e-06, 5.704189e-07, 9.009519e-07, 1.5881579e-06, 1.086903e-06, -1.3232909e-07, 1.1452812e-06, -1.7221753e-07, -1.0681423e-06, -1.7821695e-06, -1.2153941e-07, 9.943301e-07, -1.4489675e-06, -6.983928e-07, 7.258854e-07, -1.6507938e-07, 5.320873e-07, -3.7362665e-07, -3.069728e-07, -8.7214164e-07, -8.304726e-07, -1.8467979e-07, -1.0163736e-06, -4.5650492e-07, -1.269675e-06, -1.2057473e-06, 1.0586341e-06, 8.0439906e-07, 2.0179947e-07, 4.973895e-07, 1.7320303e-06, 1.1875383e-07, 1.3693755e-06, 4.270393e-07, -1.1251831e-06, 2.9822183e-07, 1.4610167e-06, 1.062577e-06, 1.1665153e-06, -5.0154128e-08, 3.6907295e-07, -1.848758e-07, -1.4093821e-06, 4.1924432e-07, -1.5306933e-06, -5.8010676e-07, -1.7205025e-07, -1.974074e-07, -6.416238e-07, -2.5620784e-06, -1.2022651e-06, 1.64376e-06, -1.06243576e-07, 1.0805359e-06, -3.4763435e-08, 7.531786e-07, 2.2742933e-07, 2.7784486e-07, -2.1675588e-07, 7.349066e-08, 1.4378031e-07, -3.8992414e-07, 2.744484e-07, -6.8991505e-07, -1.1725364e-07, -4.2827786e-08, -1.2952547e-06, 2.3943113e-07, -1.1493246e-07, 9.838233e-07, -2.8612453e-07, 6.4902576e-07, 6.784989e-07, -2.2997359e-08, -2.2000798e-08, 2.461282e-07, 4.2555914e-07, 1.49477e-07, -4.8141743e-07, -1.4635938e-07, -1.078914e-06, -1.3752001e-06, -6.964027e-07, 1.252357e-06, 2.0213446e-07, 4.3443623e-07, -7.37177e-07, 1.5878434e-06, -1.4526005e-07, 6.227348e-07, -5.786107e-07, -1.5954145e-06, 4.291076e-07, 3.228199e-07, -1.3491475e-06, -2.2991185e-07, -1.3200923e-06, -1.6467372e-07, -1.7570324e-07, -1.1814776e-06, -3.7351012e-07, -6.3362137e-07, -2.8906803e-07, -5.903194e-07, 2.718213e-07, 1.5963819e-06, 5.201772e-07, -1.5389487e-06, 1.7630468e-06, 1.1370248e-06, -2.5661086e-07, -3.6221329e-07, 1.6545886e-06, 1.1247115e-06, -1.0874588e-06, 2.329378e-06, -1.5973261e-06, 8.469089e-07, -3.1723496e-07, -3.0763758e-07, -2.3053979e-06, -1.8920178e-06, 8.077865e-07, 1.2256147e-06, -1.7899863e-06, -1.8438916e-06, 2.2748698e-06, 2.2084375e-06, 1.2790449e-06, 1.788595e-07, 1.0686232e-06, -1.9343513e-06, 2.0304349e-06, 2.7661963e-06, -1.0358888e-06, -8.570767e-08, -2.6234354e-06, -1.2784396e-06, -1.9584218e-06, -1.3416209e-06, 1.2594288e-06, 1.7730753e-06, 5.748049e-07, 1.4431364e-06, 2.2158229e-06, -1.9295253e-06, -7.7618756e-07, 5.292666e-07, 7.6829275e-07, -9.839501e-07, -1.1605543e-06, 1.5266975e-06, 1.2848298e-06, 4.7450726e-07, -9.8556384e-08, -8.039444e-07, 1.0451852e-06, 5.5488107e-07, -1.1465867e-06, -7.9419226e-07, -7.540442e-07, 1.732954e-07, -4.5453024e-07, 1.0401541e-06, -1.5457054e-07, -8.391578e-07, 2.2474062e-06, -1.1061221e-06, 1.4482852e-06, 1.4506729e-06, 1.5482755e-06, -1.0891689e-07, -1.1359e-06, -2.4530382e-06, -6.108477e-07, -1.3911996e-06, -3.5985456e-06, 5.5953296e-07, 1.9811987e-06, 5.4426124e-07, 3.8456974e-07, 3.4695066e-07, 1.5869409e-06, -5.391723e-07, -2.3443213e-06, -3.1318004e-06, 2.4513332e-07, 2.7263056e-06, -1.9483327e-06, -2.0794052e-06, 2.81844e-06, 3.4771963e-06, 1.3885656e-06, -4.377925e-07, -1.4772055e-06, -1.8320782e-06, 1.1660655e-06, 6.2592403e-06, -1.7463494e-06, 7.4529316e-07, -4.018016e-06, -2.3278099e-06, -2.8781833e-06, 2.361357e-06, 2.829537e-06, 1.7969422e-06, 2.8184755e-07, 1.4193206e-06, 2.1193455e-06, -2.3782409e-06, -3.4005216e-06, -5.979856e-07, 3.1471066e-06, -3.2314233e-06, 4.0910123e-07, -1.1038114e-06, -6.498991e-07, -5.354904e-07, -1.0874904e-06, 2.0075503e-07, -2.96318e-08, -2.504078e-07, 5.433271e-07, -3.3429458e-07, 9.301456e-08, 4.590119e-08, 8.1915715e-07, 4.5155443e-07, 3.4143278e-07, 6.5010134e-08, 4.5033715e-08, 8.49276e-08, 3.7648874e-07, 3.0706252e-07, 8.518256e-07, 7.32761e-07, 7.9634026e-07, -3.20388e-07, 3.7929178e-07, -5.8331867e-08, -1.2246055e-07, -4.1556763e-07, 2.3795005e-07, -1.7809463e-06, -5.217684e-08, -4.0037886e-08, 3.3743368e-07, -2.1564929e-06, -5.833622e-07, -1.996971e-06, 1.1350348e-06, 1.2513865e-06, -7.0186115e-07, -1.0513157e-06, 1.9751064e-06, 9.55007e-07, 6.6968636e-07, -6.3593495e-07, 1.4082179e-06, 5.9365817e-07, -3.8089289e-07, 5.988581e-08, -1.19041e-06, 3.7296473e-07, -4.787516e-07, -1.1908038e-06, -2.418565e-06, -3.5991978e-09, -1.7165615e-07, 2.0593507e-06, 1.496269e-06, 1.4134781e-07, 2.3512612e-06, -2.4096618e-08, -7.11602e-08, -1.1051693e-06, 4.0934148e-07, -1.0549085e-06, -1.5094122e-07, -1.3150028e-06, -2.030393e-06, -1.7916699e-06, -2.972933e-07, 2.585573e-07, -8.690487e-07, -5.333733e-07, 2.3973862e-06, 1.0470233e-06, 2.017197e-06, 4.830681e-07, 7.877944e-07, -4.1939046e-07, -4.5554992e-07, 9.490718e-07, 6.4679375e-07, -9.2815765e-07, -1.942629e-06, -1.1467896e-06, 1.1856308e-06, -2.5175183e-07, 2.747043e-06, 1.8360126e-07, 1.7184439e-06, 1.3797451e-06, -8.355472e-07, -1.1561815e-06, -2.8186466e-07, -9.99235e-07, 1.4500619e-06, -1.8465983e-06, 5.0073635e-07, -1.1597124e-06, 4.844442e-07, -1.7294458e-06, 4.726233e-07, 7.0134837e-07, -6.8767184e-07, -4.4614262e-07, 1.3772677e-06, 2.4537765e-06, 1.0439575e-06, 1.732991e-08, 5.3557534e-07, -5.9367824e-07, -1.7407793e-06, 1.7536343e-06, -1.1513803e-06, -3.3798116e-08, -3.4214426e-07, -9.019338e-07, 1.01885576e-07, 2.6783908e-09, 8.6983493e-07, -1.0531105e-06, -6.252978e-07, 1.5091932e-06, -3.3913388e-09, -5.6611987e-07, -3.6951437e-07, -8.837592e-07, 2.1511057e-06, -1.6875118e-06}},
    {"bert.encoder.layer.4.attention.self.query.bias_grad", {-3.264201e-06, 1.213613e-07, 2.5528514e-06, 4.028237e-07, -1.0674827e-06, -1.4728141e-06, 3.7801947e-06, -3.2428786e-06, 4.025939e-06, 7.5790666e-07, 2.1575215e-06, 2.8159009e-06, 1.0198695e-06, -9.67773e-07, 3.3957601e-06, 2.7624021e-06, 1.8475257e-07, 3.5398415e-07, 1.0676085e-06, 9.5039286e-07, -2.2554316e-07, -1.3291545e-06, -1.0719584e-06, -7.0866383e-07, 6.1358304e-07, 2.9173002e-06, -3.3624583e-06, 5.8579913e-06, -2.8343783e-07, 2.2838828e-06, 1.1550495e-06, 2.3834555e-06}},
    {"bert.encoder.layer.4.attention.self.key.weight_grad", {2.3654218e-07, 2.8674274e-06, 1.0764988e-06, -4.5308035e-08, 2.604947e-06, 4.4647862e-07, 3.4093534e-06, 3.9597012e-07, -4.0682244e-06, 1.7204294e-06, -1.7374248e-06, 1.3387348e-07, -3.0257754e-06, 1.7176038e-06, -8.2459945e-07, -1.2398718e-06, -4.1754652e-07, 5.764841e-07, 6.3077536e-08, 7.7546656e-07, -1.7059846e-06, 2.8975796e-07, 2.8890415e-06, -2.2174647e-06, -1.1931592e-06, 9.731363e-07, -2.4317346e-06, 8.5965536e-07, -1.4524002e-06, 9.214604e-07, -2.0649227e-06, 4.672125e-07, -1.1924533e-06, 2.7988318e-07, 2.95472e-07, -2.5551965e-06, 1.7955718e-06, -1.3696165e-06, 6.427002e-07, -1.4135094e-06, -1.0440083e-06, 1.3426879e-06, -1.1696913e-07, 5.5594535e-07, 4.3550466e-07, -1.1073428e-06, 1.9258528e-06, -8.420974e-08, 1.6799029e-06, -3.8123278e-07, -1.016744e-07, 1.640496e-06, -5.4082454e-07, -5.556767e-07, -1.7211205e-07, -6.128119e-07, -1.925534e-06, -3.853103e-07, 3.5636555e-07, 7.825208e-07, 1.4016368e-06, -1.6024767e-08, 7.168495e-07, -2.7688333e-07, 1.7693511e-06, 5.2648073e-07, -7.778877e-07, 3.1093336e-06, -4.6285837e-07, -8.427243e-07, 1.0621302e-06, 9.857333e-08, -1.157704e-06, -2.2024369e-07, -5.8360297e-07, 5.913908e-07, -1.4950375e-06, 1.5519164e-06, -9.2348716e-07, -2.7448223e-07, -1.4197972e-06, 1.3810154e-06, 7.8483495e-08, -8.0993834e-07, 9.962818e-07, -5.002169e-07, 1.8610885e-06, -2.0855944e-07, -3.144891e-07, 1.1884986e-06, -5.101767e-07, -1.2315476e-06, -1.1783071e-06, -3.7237604e-07, -9.59796e-07, 2.868796e-08, 2.7466285e-07, -2.1699732e-06, -1.3026104e-07, -4.1709302e-07, -5.706292e-07, 3.5673543e-07, -1.2408482e-06, 1.0235071e-06, -2.3077588e-07, -1.8447038e-06, 1.4284964e-06, 8.7988474e-07, 5.6355503e-07, -3.550664e-07, 2.0118235e-07, 6.952885e-07, -2.6853425e-07, -1.0550219e-06, -3.074909e-09, -7.854168e-08, 1.3801853e-06, -6.1255514e-07, -8.4390484e-07, 1.2557256e-06, -7.236979e-07, 1.3329822e-06, 1.3498524e-06, 3.8840966e-07, -3.3565968e-07, -1.0380091e-06, 1.4351386e-06, -6.472562e-07, -1.6109037e-06, 4.075417e-06, 1.5327543e-06, -2.6448317e-06, 3.131888e-06, -1.9636207e-06, 3.0372155e-06, -1.3636894e-06, -1.2025067e-06, 3.2499581e-06, -1.4370394e-06, -1.4945748e-06, -1.5252699e-06, 1.0376127e-07, 1.9257052e-06, -9.946294e-07, 1.439847e-06, 4.5177455e-07, -1.3768297e-06, 7.869974e-07, -1.726853e-06, -5.0291277e-07, 2.5818672e-06, -1.5037126e-06, -1.3607647e-06, -1.1376834e-06, -2.6447708e-06, 8.9981256e-07, 3.0599503e-07, 2.0481896e-06, -1.7476367e-06, 6.6704564e-07, -1.7861444e-06, -8.1137614e-07, -4.264306e-08, -2.1726944e-06, 1.7456789e-06, -8.592121e-08, 1.7703712e-06, -8.2012195e-07, -1.0051396e-06, 2.1105557e-06, -7.274385e-07, 7.2750396e-07, -8.988969e-07, -5.972486e-07, 1.354803e-06, -1.595064e-06, 1.699136e-06, -8.9070636e-07, -3.791817e-08, 1.7349672e-06, -1.889011e-06, -4.1223333e-07, 6.421311e-07, 1.4328889e-06, -3.0841445e-09, -1.1492452e-06, 1.2128417e-06, 9.856969e-07, 2.9948605e-08, -6.2937113e-07, 1.2767572e-06, -1.169023e-06, -2.492867e-06, 2.4068731e-06, 2.3529142e-06, -1.7781185e-06, 1.7535123e-06, 5.4862443e-08, -3.7076794e-07, 5.265452e-07, -1.6445925e-07, 6.2087463e-07, -1.3185945e-06, -1.1812049e-06, -1.941337e-06, 1.3511124e-07, 5.718747e-07, -6.5936416e-07, 1.4878276e-06, -1.0704679e-06, -1.4333364e-06, 3.0282981e-06, -1.5599823e-06, -2.2312892e-07, 3.931851e-06, 7.612133e-07, 5.9790307e-07, -2.420011e-06, -3.0670103e-06, 1.5168197e-07, -5.5100213e-07, 1.6188923e-06, -3.3943687e-07, 5.708535e-07, 8.5627494e-07, -2.1124795e-06, -9.911555e-07, 1.545404e-07, -2.5625883e-07, 4.0124638e-07, 4.3456242e-07, -4.4553033e-07, -2.0018824e-06, -8.6277817e-07, 9.89061e-07, 1.3848723e-06, 3.9388618e-07, 1.722989e-07, 3.488724e-07, -4.67273e-07, 5.1246104e-07, 3.0554892e-07, 4.356774e-07, -1.9147808e-07, 7.5680964e-07, -9.349275e-07, -6.8516187e-07, 1.0925179e-06, -1.2504895e-06, 1.0435092e-06, 1.5929807e-06, 6.99069e-07, -5.4634046e-07, -1.9302634e-06, 1.5857723e-06, -4.839424e-07, -5.2877624e-07, 1.715882e-06, 6.673533e-07, 1.1204503e-08, -8.746078e-07, -1.1846759e-06, 7.9951883e-07, -1.156391e-06, 2.9287173e-06, -4.370769e-07, 2.6961325e-07, -2.9526361e-06, 4.81474e-07, 1.4332022e-06, 3.085259e-06, -6.2542165e-07, 1.2318907e-06, 1.5163583e-06, -2.4718327e-06, -1.3506459e-06, -5.002866e-07, 7.421415e-07, -2.49286e-08, 1.6884957e-06, 7.2968265e-07, -2.07007e-06, -2.2073582e-06, -1.6040141e-06, 2.90244e-07, 4.174333e-07, -6.2350733e-07, 6.0375834e-07, -9.3826173e-07, -2.2734648e-06, -2.8956285e-06, 1.0639673e-06, 1.3245452e-06, 2.036091e-06, 5.5678333e-07, -1.4403299e-06, 1.5767272e-07, 2.759853e-06, -7.4010956e-07, -2.6565278e-08, -7.3619873e-07, 4.747096e-06, 1.3487377e-06, -6.9185785e-07, 1.7868122e-06, 3.460892e-06, -1.6254045e-06, -2.1611565e-06, -4.457555e-06, -3.7772838e-07, 4.560144e-07, 2.293988e-06, 1.9289266e-06, 6.3090106e-08, 6.508235e-07, -2.1576132e-06, -2.8051804e-07, -1.0245512e-06, -2.3050834e-06, -5.03267e-07, 1.2435608e-07, -9.701058e-07, 2.0760722e-06, 5.3777103e-06, -1.0629351e-06, 4.096978e-06, -4.809958e-06, 3.070453e-06, 1.3948337e-06, 1.0905204e-06, -1.358016e-06, -2.142962e-06, -4.8793954e-06, 3.9968927e-06, -5.038957e-06, 3.9025284e-07, -3.978705e-06, -6.6099545e-07, 7.3243075e-07, -2.865697e-07, -5.539095e-07, 2.012931e-06, 4.273525e-06, 1.433111e-07, 2.3720854e-06, 1.2166423e-06, -3.1839859e-06, -2.1709052e-06, -1.9217555e-06, 1.4399432e-06, -8.7779324e-07, 8.801234e-08, -1.317466e-06, 3.2836624e-07, 1.2960702e-07, -4.376899e-06, 2.6420576e-06, -2.1130128e-07, -1.2687482e-06, 2.4278095e-06, 3.4261905e-06, 1.7395425e-07, -4.9099157e-07, 3.0416751e-07, -1.8992151e-06, -1.392972e-06, -1.1786503e-06, 2.9296157e-06, -1.7230726e-06, -4.794058e-06, 1.1365512e-06, 3.2304522e-06, 2.2265576e-06, 6.021374e-07, -7.215107e-08, -4.371568e-07, 7.922368e-07, -3.8134551e-06, 7.039011e-07, -1.0228609e-06, 1.1218343e-06, 7.129726e-07, 4.3510368e-06, -3.240452e-06, 1.8166752e-06, 9.952104e-07, 1.502059e-06, -1.6530167e-06, -1.5185037e-06, -2.1636547e-06, -1.0594513e-06, -3.7756948e-07, 1.2002115e-06, -2.58793e-06, 2.9760947e-06, -3.40853e-07, 4.096103e-06, -4.6035207e-06, 1.9086867e-06, 3.6079106e-07, -2.8338533e-07, -7.858001e-07, -1.0357425e-06, -1.7836422e-06, 3.1655666e-06, -1.8640596e-06, -3.173524e-06, -1.2292355e-06, -2.4869157e-06, 2.044085e-06, 1.0059617e-06, 2.7078474e-06, -5.1690625e-07, 7.525497e-07, 3.9885998e-07, 2.533009e-06, -6.546553e-07, 3.0422866e-06, 2.444754e-06, -1.9756717e-06, 8.834579e-07, -3.6348315e-06, -8.1310776e-07, 1.6558616e-06, 1.5972039e-06, -5.6217783e-07, 1.1487575e-06, 1.0184265e-06, 1.6874719e-07, -5.017457e-06, 2.6024455e-07, 4.1520133e-07, -1.0453426e-06, -2.864499e-06, 5.302148e-07, 1.423363e-06, 2.9682742e-06, -1.0385239e-06, -8.6972966e-07, -3.5189012e-06, -2.0061727e-06, 6.647734e-08, 1.3768897e-07, 2.3308799e-06, -6.0707646e-07, 3.2993098e-06, 1.5421834e-06, -3.2518508e-07, -1.022933e-06, -2.4857513e-07, -5.5689617e-07, 9.0069705e-08, -4.011435e-07, 3.5995762e-07, 1.436108e-06, -2.746028e-06, -1.2646772e-06, -3.6747429e-07, 3.6820185e-07, 3.8196356e-07, -3.0919657e-07, 1.2270453e-06, 2.570756e-06, -1.9606746e-06, 2.730385e-06, 1.5837322e-06, -5.903112e-07, 1.4185024e-06, -8.8723027e-07, -1.2625999e-06, 5.206383e-07, 2.4526594e-06, -7.489559e-07, -1.0485148e-06, -1.1965048e-07, 2.0681097e-07, -3.9313073e-07, -2.3435866e-06, 6.661029e-07, 2.586442e-07, -4.7499012e-07, -1.3350129e-06, -1.8349688e-06, -9.122082e-07, 1.240768e-06, 2.302378e-06, 1.8972419e-06, 2.6670323e-06, -9.776275e-07, -1.1943255e-06, -5.482881e-07, 1.7654247e-07, -3.987805e-06, 5.2545624e-06, 3.774171e-07, 2.0877455e-06, -2.0744808e-06, -1.7410015e-06, -4.9639686e-07, 2.4255291e-07, 9.3292704e-07, 7.442314e-07, 1.0620208e-06, 3.3429053e-06, 2.0913876e-06, -2.6073176e-06, -1.56324e-07, -3.2867774e-06, -1.7587365e-07, -2.039821e-06, 3.2030034e-06, -3.779496e-06, 2.9752266e-07, -1.2345598e-06, -1.13597e-06, -3.938055e-09, 3.0522395e-07, 7.0715123e-07, 6.8680885e-07, -4.837318e-08, 3.7080627e-10, 3.8242817e-07, -4.565926e-07, 5.91787e-07, 2.3482079e-07, 1.0301496e-06, -1.1294273e-07, -5.7504998e-08, -6.628259e-07, 6.356172e-07, 2.925825e-07, -1.0222601e-06, -1.0664305e-06, 8.4451233e-07, 6.5399985e-07, 5.2410536e-07, 7.164774e-07, 3.648655e-07, 2.0838315e-06, -3.9946528e-07, -7.382222e-07, -1.4087612e-06, -1.310515e-06, -6.9389216e-07, -8.38182e-07, 1.4209198e-06, 2.19218e-06, -4.18764e-07, 1.8495604e-07, 1.2729611e-06, -4.4500094e-08, -4.217143e-07, -2.4667406e-07, -1.6304372e-07, -1.5853264e-07, -8.000676e-07, -4.8695154e-07, -2.681233e-06, 2.3698053e-07, -1.1087488e-06, 1.1188247e-06, -1.500465e-06, 3.828202e-09, 2.8256966e-06, -4.379778e-08, 9.419889e-08, -2.4980656e-07, -2.455727e-07, -1.5223687e-06, -9.1630653e-07, 4.5365627e-07, 1.3090864e-06, -5.900332e-07, -7.997952e-07, 5.7446863e-07, 1.5488006e-06, 4.1029426e-07, -1.7824318e-06, -1.0302113e-06, 1.3072155e-06, 1.1657614e-07, 1.6382852e-06, 9.802181e-07, -1.1807541e-06, 6.798268e-07, 1.2741889e-06, -3.3526075e-07, 3.245078e-08, 6.422887e-07, 1.5571722e-07, -2.8786667e-07, -1.4645627e-06, 9.724898e-07, 2.241393e-06, 3.4083155e-07, -1.1009361e-06, -2.352792e-06, -4.6563855e-09, -1.8764017e-06, 6.161171e-07, -6.17726e-07, 9.848092e-07, 2.525578e-06, 5.3348015e-07, -2.7826192e-07, -2.1281373e-06, -1.1428366e-06, 1.3107629e-07, -6.4247155e-07, 6.534198e-07, -5.973594e-07, 3.4057425e-07, 7.7006865e-07, -5.174443e-07, 9.1459583e-07, 5.808339e-07, -1.2627931e-06, 7.757452e-07, 1.1315542e-07, 5.386734e-07, -1.1626747e-06, 8.886348e-07, -3.5637834e-07, 1.9482898e-07, 8.404732e-08, 7.444683e-07, 5.733441e-07, -9.013499e-07, -5.5535634e-07, -1.0149699e-06, 5.0306375e-07, -9.672426e-07, 4.3796985e-07, 1.5632891e-07, -9.883296e-07, 3.5452518e-07, -2.946536e-07, 1.3567794e-06, 4.7639858e-07, -1.196432e-06, -3.4424255e-07, -1.670646e-06, -2.2595502e-07, -4.954584e-07, -6.576704e-07, -2.9204804e-07, -1.3505697e-06, 2.3858158e-07, 1.3622529e-06, -2.7771154e-07, -5.6666337e-08, 4.5606956e-07, 1.1230139e-06, -1.0954857e-06, 9.2419936e-07, 1.327804e-07, 4.385089e-07, -9.281861e-07, -8.1898816e-07, 9.364094e-07, -1.9501542e-07, -1.2537494e-07, 1.4446862e-06, 2.4722394e-06, 6.0260214e-07, -5.096636e-07, 9.143491e-07, -5.5147956e-07, -8.084795e-07, -7.791208e-07, -1.1720439e-07, 2.5427377e-07, -5.095414e-07, 7.2917743e-07, -3.3666092e-07, -8.0034414e-07, 3.005215e-07, 2.9105854e-07, -4.035661e-08, 7.0574157e-07, -1.4603388e-06, -8.2518596e-08, -6.1627514e-07, 8.99554e-07, -6.386007e-07, -1.6037324e-08, -1.035427e-06, 7.2268796e-07, -5.1192785e-07, -1.9279182e-06, 1.0523755e-06, 1.3418694e-06, 5.9983e-07, 6.827088e-07, 1.8829389e-06, -6.2046627e-07, 1.1078885e-06, -9.956159e-07, -1.0417937e-06, -5.187725e-07, -1.3832775e-07, 6.5459136e-07, 6.5091444e-07, -3.3093568e-07, -7.0192635e-07, 3.333809e-07, 6.9503363e-07, -5.4189803e-07, -4.254878e-09, -1.4972443e-07, -1.8431094e-06, 2.1218848e-06, -1.0380294e-08, -1.4061532e-06, 1.0466914e-07, 6.1845213e-07, -3.9509413e-08, -9.050781e-07, -3.8810904e-07, 8.26933e-07, -8.3329286e-07, -2.3767152e-06, -1.4380552e-07, 1.4909057e-06, 1.4536996e-06, 1.1750399e-06, 5.91966e-07, -3.5815364e-07, 1.0767187e-06, -1.3758039e-06, -9.232179e-07, -1.4276294e-06, -2.4532473e-10, 1.4699056e-06, 1.4080172e-06, 6.240068e-08, -9.861268e-07, -1.1413309e-07, 6.178075e-07, -9.023243e-07, -2.2246317e-07, -2.6838563e-08, -2.0718162e-06, 9.4284104e-07, 1.965189e-06, -7.2321956e-07, -5.976475e-08, -2.5925328e-07, 1.3309076e-06, -3.2580372e-06, 9.891891e-07, 7.4510496e-08, -9.437643e-07, -2.523911e-06, 2.566317e-08, 1.8346587e-06, 1.2591752e-06, 1.3983813e-06, 7.0343685e-07, 8.3137803e-07, -2.2802944e-08, -1.6556106e-06, 1.7530286e-07, -2.1957668e-07, -5.395501e-07, 2.9939142e-07, 1.0463003e-06, 1.0350604e-06, 4.0027524e-07, -1.5488047e-06, -1.7208769e-06, -8.289828e-08, -5.3746777e-07, -8.0112227e-07, -1.9110213e-07, -1.0604389e-06, 2.7173721e-06, -1.0663633e-06, 1.6822065e-06, -4.306041e-07, 1.2155768e-06, 1.4554926e-06, 1.4029599e-06, -1.5389323e-07, 3.3893045e-07, 2.0204468e-06, -2.3328923e-06, -1.792715e-06, 1.4942302e-08, -1.758497e-06, -1.4878315e-06, 3.1408492e-06, 3.587636e-07, 1.2939698e-07, 1.3569028e-06, 2.1159477e-07, -9.377204e-07, -3.4447478e-07, -4.341581e-07, 2.3614973e-07, -1.6739568e-06, 1.3608528e-07, 2.010212e-06, -1.2712948e-06, 2.8612224e-06, 3.453183e-06, -8.26779e-08, 1.0611988e-06, -9.0176013e-07, 2.5824463e-06, 6.0418574e-07, 7.528903e-07, -1.5447888e-06, -1.0813588e-06, 2.8260301e-06, -3.1120103e-07, 7.323542e-07, -1.7545436e-06, -3.223939e-07, 1.3890578e-07, -2.0170182e-06, -1.8153029e-06, -6.068454e-07, -1.4097872e-06, -1.4970349e-06, 8.694396e-07, 1.4698529e-06, -6.5358165e-07, -1.9153094e-06, -2.1763196e-06, 1.3138481e-06, 2.2332037e-07, 4.904055e-07, 1.4811694e-06, 7.8365434e-07, -1.0752036e-07, 2.2912895e-06, -3.7261836e-06, 1.0247287e-06, -1.4756622e-06, 1.4517924e-06, 9.866997e-07, 7.484148e-07, -3.653436e-07, -1.2439671e-06, -1.1648314e-06, -4.2812374e-07, -1.4188912e-06, -5.951505e-07, 8.387952e-07, -1.3407683e-07, -1.2998994e-06, 1.6456812e-06, -7.0050845e-07, -2.1677026e-07, -1.6982002e-06, -2.3945904e-06, 1.7647303e-06, 2.5137223e-07, 2.1473668e-06, 7.806597e-07, 1.6583614e-06, -4.409354e-07, -9.344668e-07, 2.2230759e-06, -1.6615435e-06, -1.9361535e-06, 1.02127e-06, -1.7508578e-06, -2.2431925e-06, 2.0125442e-07, -1.8107594e-06, 4.0824325e-06, -1.8014725e-06, 1.1315893e-06, -1.618755e-06, 1.8953201e-06, 1.0065568e-06, 1.2698435e-07, 1.8874533e-07, -6.2514016e-07, 2.504402e-06, -1.6667095e-06, -2.2875658e-06, 9.1934396e-07, 1.14221464e-07, -2.1137207e-06, 3.030521e-06, 8.3579266e-07, -5.916805e-08, 1.2195152e-06, 4.079241e-07, 3.7394938e-07, -4.6761008e-07, -1.3271289e-06, 8.6880114e-08, 2.3381235e-06, -2.1492974e-06, 1.1612605e-06, -9.37035e-07, 3.7752793e-07, 9.486338e-07, 9.706301e-07, -5.836945e-07, -1.8708209e-06, 2.900338e-07, 8.1499655e-07, 1.1243382e-06, -1.4371897e-06, -6.891348e-07, 1.7276716e-07, 3.7331372e-07, 1.4389478e-06, -1.6931884e-07, 8.1978067e-07, 4.8601316e-07, 4.8137775e-07, -1.6385821e-06, -3.33637e-06, 4.2922957e-07, -3.1789154e-06, 9.60184e-07, 3.8034402e-06, 1.8185956e-06, 4.468753e-07, -3.5578917e-06, 2.071479e-06, -1.7792989e-06, -1.3617239e-06, 1.4190983e-06, -9.584354e-07, -1.8704704e-06, 9.459186e-07, -2.896707e-06, -1.0888708e-06, -1.461142e-07, 5.7590223e-06, 3.450048e-07, 7.144239e-07, -1.6306948e-06, 1.6647094e-06, -4.010006e-07, 1.125417e-06, 3.0781956e-07, -7.112007e-07, 2.4461008e-07, -2.5895597e-06, -1.3860525e-06, 8.9880047e-07, -1.364608e-06, 1.664837e-06, 8.5869686e-07, 1.6635479e-06, -1.2106241e-06, -1.6061999e-06, -7.881139e-07, -4.801891e-07, 2.8077895e-06, -4.4266505e-07, 5.135339e-07, -1.1705086e-07, -2.00747e-06, -1.2267024e-06, -3.8877363e-07, -6.409821e-07, 3.5706582e-06, 1.1143495e-06, 7.7079324e-07, -5.267476e-06, 7.667011e-07, -1.338642e-06, 1.911608e-06, -5.204457e-07, 1.7130402e-06, -6.5301197e-07, 6.4918805e-07, -3.8317445e-08, -1.1098552e-06, 3.0097842e-06, 1.4488779e-06, -1.0939186e-06, 1.0112295e-06, 2.2147441e-07, -2.6691222e-07, 2.9666597e-07, -7.0224905e-07, 2.695438e-07, -3.8558986e-07, 6.460334e-08, -2.0137059e-06, 1.8362854e-06, -8.8370075e-07, -4.901118e-08, -3.898059e-06, -9.0064543e-07, -1.7317722e-06, -4.114623e-07, 2.6084647e-06, -2.3879552e-06, -2.6118e-06, 3.8006717e-06, 1.1416487e-06, 1.916523e-06, -1.7359042e-07, 1.4930176e-06, 4.428889e-07, 2.9953285e-06, -1.5445283e-07, 2.3380073e-06, 1.0528631e-06, -1.7853345e-06, -8.855088e-07, -1.6070774e-06, -2.94197e-06, -2.2588183e-06, 4.2958304e-06, -9.2165715e-07, -7.475139e-07, 4.940298e-06, -5.612443e-07, -3.764363e-07, -4.380359e-06, 2.2453087e-06, -4.861822e-07}},
    {"bert.encoder.layer.4.attention.self.key.bias_grad", {7.1054274e-14, -2.6467717e-13, 8.526513e-14, -2.1316282e-14, -7.81597e-14, -2.842171e-14, -5.595524e-14, -4.973799e-14, -2.2737368e-13, 4.5474735e-13, -5.1159077e-13, 8.526513e-14, 2.2737368e-13, -1.1368684e-13, 1.1368684e-13, -1.1368684e-13, 7.460699e-14, -1.1368684e-13, 7.1054274e-15, -1.563194e-13, 2.1316282e-14, 2.842171e-14, -1.7452706e-13, 1.7053026e-13, 8.526513e-14, -3.410605e-13, 2.2737368e-13, -1.8474111e-13, -8.526513e-14, 1.1368684e-13, 4.2632564e-14, -5.684342e-14}},
    {"bert.encoder.layer.4.attention.self.value.weight_grad", {0.0001250716, -0.00024293727, -8.471536e-05, -0.0007891128, -0.0006794401, -0.0002462545, 0.00015370997, -0.0002123679, 0.00033421296, 0.0004689471, -0.0003074693, -0.00018548717, 0.00036559984, -0.00047023877, -0.00016431639, 0.000981189, -0.0003159589, 3.9473794e-05, -0.0004823375, 0.00015161678, -4.530196e-06, 0.00029886072, 0.00062035065, -0.00024802994, -9.092673e-05, 0.00043902005, 0.00096684723, -8.634831e-05, -0.00064500916, 0.0004242579, 0.00029669137, -0.00041036838, 0.00017879535, 5.698887e-05, 8.1205515e-05, -3.9096056e-05, -4.7786623e-05, -0.00024000084, -0.000208241, 0.00027811277, 0.0003042149, -6.542074e-05, 2.3373852e-05, -8.4261745e-05, 0.000110798566, -0.00019992192, 2.4248791e-05, 4.016923e-06, 0.00022586744, -2.5155261e-05, 0.000110499976, -0.00016115348, 0.00014845577, -0.0001152625, -0.00018551588, -0.00021244124, -6.587479e-05, -0.000114799484, -0.00022499944, 0.00038084434, 0.00021749856, -7.006617e-05, 0.000156886, -0.00024181044, 8.0605285e-05, -0.00021118557, -7.7199766e-05, -0.000506605, -0.000301647, -5.248018e-05, 0.00014813025, -0.00015547806, 0.00015770225, 0.00029603593, -0.00013624589, -6.32874e-05, 0.00014900067, -0.00021804418, -0.0001334905, 0.00063831103, -0.00033507505, -7.13516e-05, -0.0003237986, 0.00018034583, -0.00011130732, 0.00024626305, 0.00035597436, -0.00014316435, -4.0803807e-05, 0.00030919947, 0.0007352864, -0.00015120528, -0.0004359656, 0.000228766, 0.00021454445, -0.00027182983, -4.0263676e-05, -8.797501e-05, -6.825992e-05, -0.00014207023, -0.00017220686, 2.7756764e-06, 0.0001882897, -0.000181598, -0.000111802765, 6.2264655e-05, -0.00014079794, -1.2486841e-05, 2.7746904e-05, 4.1408177e-05, -9.731023e-05, 0.00017388018, -0.00019478604, 4.858684e-05, -0.000119978075, 0.00016359735, 7.1644295e-06, 0.00015047666, 0.00027270775, 6.434731e-05, 3.0558433e-05, 0.00014539331, 0.00028449157, -0.00018965824, -0.00022665082, 8.717593e-05, -5.032638e-05, 8.5306056e-05, -0.00015105853, 0.00015096834, 3.8268336e-05, 0.00051282294, 0.00039666292, 0.00023315982, -0.00010896018, 7.144752e-05, -0.00019573497, -0.00021047394, 0.00023604247, 0.00012291255, -0.00021039136, 0.00023899568, 0.00014703628, -0.00057848153, 0.00023781875, 4.5870926e-05, 0.0002556965, -0.00016093746, -4.256836e-05, -0.00020566405, -0.00039892577, 0.00018121689, 6.253596e-05, -0.00027668217, -0.0006039763, -1.0875637e-05, 0.00032631145, -0.00021087128, -0.00014948443, 0.00025731852, -0.00021353131, -0.00031845178, -0.00013683696, 0.00018684137, 9.080492e-05, 0.00065448094, 0.000216447, -0.0003602411, -0.00020465933, 0.00033115584, 0.00023622658, 3.8079044e-05, -0.000102531696, 0.000167537, 7.03116e-05, 0.00018724936, -0.0004567003, 3.2336146e-05, -0.00045227414, -1.4581012e-05, -0.00069311034, 0.00017805332, -7.4380376e-05, 0.00027432424, 9.060027e-05, 0.0004028727, 0.00072759663, -0.0005690763, -0.00048165227, 0.00019259183, -0.00018038828, 0.00018090646, 0.00010694232, -0.00011325284, 0.00010327823, -1.140876e-05, 9.7778764e-05, 0.000113832895, -8.2683015e-05, 7.907356e-05, 9.160519e-05, 5.1198414e-05, 6.715902e-05, -0.0001165002, -8.442024e-05, 1.7247325e-05, 6.422051e-07, 6.710501e-05, -0.000102071994, -0.00017157591, -0.00017672186, 3.8258797e-05, -0.00039755268, 5.8758887e-05, -0.00012547178, 9.6783646e-05, 5.9778013e-05, 0.00012894814, 0.00026599196, 0.00012295961, -6.0803017e-05, 4.016274e-05, -6.227693e-05, -0.000102765436, 5.945067e-06, 0.00014674276, 2.916016e-05, -0.00014086453, -5.8155794e-05, -0.00020131451, -6.157391e-05, 6.493406e-05, 5.8894562e-05, -2.1625008e-05, -0.000104768675, -1.6135966e-05, 6.614901e-05, -9.815914e-05, -2.6813293e-06, 7.1540094e-06, 0.00014258668, -8.351628e-06, 0.000104643404, 1.4805408e-05, 0.00022977944, -4.1015584e-05, 0.000107814136, -7.8505785e-05, -2.9546542e-05, -0.00014993554, -0.00020841643, 0.00011732128, 8.052773e-05, 9.732495e-06, 8.079908e-05, -4.5938905e-05, 2.6630044e-06, -3.2186115e-05, -7.085067e-05, -0.00032529113, -0.0002861214, -0.000111980786, 9.940898e-05, -0.00012102911, 7.753199e-05, 0.00017773775, -0.00017057425, -4.776093e-05, 0.00014400913, -0.00017686679, -6.630325e-05, 0.00034905787, -0.00010832837, 7.013383e-05, -0.00013153785, 4.387406e-05, 0.000121368044, 0.000111090485, 0.0003223053, -0.000119024284, -5.090915e-05, 0.00013880922, 0.0003023112, -7.410842e-05, -0.00026275413, 0.0001833263, 0.000109110275, -9.7110904e-05, 3.7049824e-06, -0.00021026777, -3.8159844e-05, -4.9978924e-05, -8.638613e-05, 0.00023914193, 3.7848215e-05, -8.758915e-05, 0.00011694383, 0.00022375895, 0.00011656935, -7.4371455e-05, 5.2081177e-05, -8.430207e-05, 3.707887e-05, 0.00029938185, -0.00020246994, -1.3875651e-05, -0.00030841792, -6.25078e-05, -0.0003835725, 9.524609e-05, -4.400447e-05, 4.0140174e-05, 3.7097918e-06, 0.00025984136, 0.00051197776, -0.0001274738, -0.00030551504, 0.00012165169, 1.7691029e-05, -9.787451e-05, -0.00017293956, 0.0002278838, 4.857422e-07, 0.0006124058, 0.00037074526, 0.00014911164, -8.7778906e-05, 9.495451e-05, -0.00024864048, -0.00032624742, 0.00021323227, 0.00017394059, -0.00018062102, 0.00027453134, 0.00017167118, -0.0007264663, 0.00034273678, 0.00015349904, 0.00039679898, -0.00023148337, 0.00020923966, -0.00028570415, -0.0003972401, 0.00014616345, 1.9684388e-05, -0.00038121693, -0.0008483536, -1.4652317e-05, 0.00042804377, -0.00026826453, -0.00017396227, 0.00035844292, 0.00016494395, 9.135836e-05, 6.11893e-05, -0.0003392084, -0.00026396778, -0.00047160694, -0.00013583971, 0.00018185684, 0.00033059024, -4.1847707e-06, -0.0001525001, -7.695262e-05, 0.00024049178, -0.0003194324, -3.594413e-05, 0.0002467632, 0.00023170214, 1.449618e-05, 7.982523e-05, -3.6451227e-05, 0.00038651697, -6.246463e-05, 0.00013684397, -0.00029249277, -0.000111650384, -0.00011073233, -0.0001533528, 0.00032568155, 0.000108403154, 2.2889057e-05, 0.0002580147, -0.00031478595, -0.00015123536, -0.00019183407, -8.1101614e-05, 0.00013798324, 0.00015073785, 0.00047346964, 0.00019104268, -0.00026433013, -0.00024046603, 0.00015911758, 0.00011622122, 3.183244e-05, -0.00017457112, 0.00022912212, -3.9053616e-06, 3.684153e-05, -0.00037081947, -3.9446608e-05, -0.0002516904, 9.172065e-05, -0.0004941447, 0.00016894688, -1.0532849e-05, 0.00024561517, 0.00010600968, 0.00026355754, 0.0004620442, -0.00039408795, -0.00028596653, 8.972927e-05, -0.00019710469, 0.00019724529, 1.0861279e-05, -0.0003568285, -2.987155e-05, -0.00048829045, -0.00022878483, 0.00027672874, 0.00019233818, -0.00030074455, 9.181502e-05, 0.00046841116, -4.5909772e-05, -0.00012614571, 4.44484e-05, -0.00013834673, -0.00011196302, 0.00076875143, -0.0005238134, -0.00016413233, -0.000600581, 0.00021877732, -0.0006311813, 0.00034603395, 0.00035025718, 4.8311773e-05, 2.0035566e-05, 0.0005653657, 0.0011549125, -0.00029017497, -0.00067689933, 0.0003445206, 6.86253e-05, -0.0002565272, -0.00015893886, 6.9574635e-05, 1.7453356e-05, 0.0004810503, 0.00041035208, 0.00037824613, -9.0072215e-05, 2.8475231e-05, -0.00015689526, -9.891162e-05, 0.0002967234, 8.52096e-05, -0.0001982792, 0.00022751532, 0.00015764845, -0.00043740758, 0.00010058315, -3.2297434e-05, 0.00012309641, -0.00015697886, -0.00027735892, -0.00013735864, -0.00042918778, 0.00020307272, 7.753076e-05, -0.00013923558, -0.0003470336, -7.208834e-05, 0.00022526775, -0.00019592697, -0.00018140284, 0.00022757445, 0.00026380035, -1.1788432e-05, 0.000116064206, -0.00054103637, -0.00033151766, -0.0005078305, -0.00011641455, 0.00018178312, 0.0004087486, 4.8137343e-05, -0.00022653711, -0.00017536413, 0.0002324579, -0.0003531708, -0.00012353508, 0.00046355397, 9.773544e-05, -0.00011597897, -6.454072e-05, 0.00011868243, 0.00019732062, 6.495693e-05, 0.00024766164, -0.00026506843, -7.2269526e-05, 3.0070412e-05, 0.00015779863, 0.00040142206, -1.6886403e-05, 6.300242e-05, 0.00026813414, -0.00043939138, -0.00014679186, -1.0712989e-05, -0.00012099304, -3.9733433e-05, -9.222899e-05, 0.00010493796, 0.00016674728, -0.00022424887, -0.00015965514, 0.00012863087, -6.76977e-05, 7.210468e-05, 2.367625e-06, 2.5778008e-05, -2.064733e-05, 6.350398e-05, -0.00012814983, 0.0001531591, -6.1460356e-05, 1.2614958e-05, 9.235674e-05, 7.2812094e-05, 0.00019948417, 1.7781631e-05, -1.891845e-07, 6.3015126e-05, 0.000118983735, -0.00030302448, -0.00021234067, 0.00015740238, -3.0076276e-07, 0.00013649423, -0.00016767706, 0.0004415806, -5.20935e-06, 0.0006830482, 0.00040867866, -9.894326e-05, -0.00014847291, 0.00023884508, -0.00024944678, -0.00049922505, 0.00013123036, 0.00021748806, -0.00014619298, 0.00027592614, 0.00017403578, -0.0009955631, 0.0005748415, 0.00023567898, 0.0007000891, -0.00031618995, 0.00064933806, -0.00040741012, -0.0004360795, 5.0567755e-06, -1.8477389e-05, -0.00065080036, -0.0013969714, 0.00014861398, 0.00073566975, -0.0003666693, -0.00014229018, 0.000425498, -0.00018495001, 0.00028406296, 8.238182e-05, 0.0006325863, 0.0004737207, 0.00016606516, -0.00012832372, 0.00013012876, -0.00027917116, -0.00039903252, 0.0002096126, 0.00013908144, -0.00025724387, 0.00034455297, 0.0001723137, -0.0008162232, 0.0004137564, 6.3975196e-05, 0.00044563288, -0.00017552257, 0.00010402225, -0.000296135, -0.00041675218, 0.0002378211, 6.102866e-05, -0.00042216526, -0.00096291106, 9.376525e-05, 0.00051531056, -0.0003546905, -0.00026035894, 0.00038366133, -9.835121e-06, 0.00020958562, 5.581325e-05, 0.0002807805, 0.00025368264, -9.33884e-05, -0.000101871876, 0.00018542308, -9.1084104e-05, -0.0003039312, 4.4273893e-05, 7.153451e-05, -0.00011676888, 0.00015670933, 3.2533884e-05, -0.00048065145, 0.00027062118, -2.378638e-06, 0.00037092713, -6.292866e-05, 0.00024874206, -0.0001670343, -0.00022831085, 3.6818806e-06, 1.6459146e-05, -0.00031327448, -0.0006707291, 0.00019880268, 0.00043097106, -0.00025834946, -7.2063325e-05, 0.00014205811, 0.00017782113, 0.00010344378, 4.788478e-05, -0.00027154837, -0.00023337037, -0.0004603613, -0.00014761361, 0.00020472945, 0.00028523762, -1.8297831e-05, -0.00015580248, -6.571451e-05, 0.00021671191, -0.00028857344, -4.827543e-05, 0.00015986452, 0.00020561033, 7.185023e-06, 0.000111887886, -3.6239242e-05, 0.00040218054, -6.5473876e-05, 9.422129e-05, -0.00029173482, -9.64241e-05, -0.00012880635, -0.00017697853, 0.00032526607, 0.00015251618, 2.5961695e-05, 0.00023839479, -0.00027370255, -4.6619105e-05, 2.903167e-08, -1.9496638e-05, 0.0001510376, 9.867525e-05, 0.00011043504, -2.0959425e-05, 2.1426438e-05, -5.3996378e-06, 5.8607675e-06, 0.00010871331, 2.3768793e-05, -1.4631236e-05, 3.906849e-05, 6.5745655e-05, -0.00010163397, 1.5378024e-05, 2.5969874e-05, 5.2213054e-06, -0.00010442066, -5.8378668e-05, -4.545523e-05, -0.0001580253, 1.5614663e-05, 2.473902e-06, -3.494855e-05, -8.4545696e-05, -4.856892e-05, 4.4872555e-05, -1.8032528e-05, -2.703014e-05, 5.385496e-05, 3.3661097e-05, -0.0004995075, -3.1280695e-05, -0.00079744856, -0.00031978238, 0.0003035625, 0.0003465713, -0.0004714074, 1.7867704e-05, 0.00062652945, -0.00019712088, -0.00017058391, -4.3093223e-07, -0.000118302385, -0.00026387084, 0.0010805541, -0.0008420359, -0.00029468944, -0.00083343865, 0.00052185263, -0.0008385508, 0.0005890356, 0.00065040553, 0.00011655743, 8.755444e-05, 0.0007807263, 0.0016737571, -0.00045123516, -0.0009652888, 0.00050432334, 7.9981044e-05, -0.0003179655, -4.272705e-05, 6.959208e-05, -1.8835864e-05, -3.200407e-05, 0.00011619846, -1.0915319e-05, 7.4557385e-05, -6.039016e-05, -0.00015872452, -5.9001337e-05, -7.186647e-05, 8.633165e-05, -0.00011288576, 0.00011382617, -8.6080254e-05, -0.00010127589, -5.3435986e-05, -4.535787e-05, 0.0001373374, 0.00013174301, 0.00011040806, 4.606369e-05, 9.51043e-05, -2.2670647e-05, 2.3595889e-05, -4.5312292e-05, -0.000114415976, -6.506892e-05, 9.165277e-05, -4.79262e-05, -9.337027e-06, 6.182072e-05, 0.0003033597, -0.0003349551, -1.7726856e-05, -0.00091703207, -0.00068272825, -0.00035348302, 8.984563e-05, -8.9146946e-05, 0.00045957565, 0.00043714303, -0.00030117625, -0.00022744609, 0.00038977744, -0.00051820395, -0.00022995289, 0.0011287556, -0.00038815898, -0.00015089633, -0.0005343359, 0.00027029484, -0.00011373345, 0.00033772874, 0.0005799214, -0.00031443883, -0.00010928961, 0.0005192883, 0.0011867371, 7.509536e-05, -0.00060019153, 0.00034799977, 0.0003669335, -0.0006095599, 5.4069293e-05, -0.00032427997, 1.7434715e-05, -0.00051598286, -0.00025462042, 0.00013792735, 0.00012384637, -0.00025323348, 0.00013413905, 0.00042265854, -6.8636364e-05, -0.00011048805, 7.212078e-05, -0.00019540043, -0.00013458657, 0.0007550493, -0.000409724, -0.00017288295, -0.00052263564, 0.0002536975, -0.0005340658, 0.0003031501, 0.00034114099, 1.9429265e-06, 1.3626574e-05, 0.0004948283, 0.0010234693, -0.00018004423, -0.0005534365, 0.0002891197, 0.00013622228, -0.0003444256, 7.847874e-05, -0.00017245857, -5.2251562e-05, -0.0004033844, -0.00031826485, -0.00012256647, 0.00013759175, -0.00014517893, 0.000106785905, 0.00019742877, -0.000172929, -6.873077e-05, 0.0001336791, -0.00016278218, -0.0001298039, 0.0004902584, -0.00024168697, 1.7200781e-06, -0.00025363485, 0.00017020149, -1.2227134e-05, 0.00019764915, 0.00034910502, -8.5692176e-05, -2.0585045e-05, 0.00024589337, 0.0005494198, -0.000105349216, -0.0003456945, 0.00020225841, 0.0001331302, -0.00018037975, 8.934215e-05, -0.0003529122, -1.605789e-05, -0.0006018305, -0.00035185087, 0.00011355252, 0.0001848731, -0.00025252052, 0.00015942738, 0.00044526233, -0.00014440836, -0.00018371218, 0.00012857113, -0.0002023555, -0.00016199703, 0.0008546153, -0.0005165158, -0.0001941467, -0.0005931812, 0.00028869387, -0.0005465337, 0.00037739295, 0.00043300216, 4.5241395e-06, 1.6646214e-05, 0.00056914496, 0.0011917517, -0.0001785807, -0.00065210013, 0.00031623594, 8.30504e-05, -0.00030738325, -5.7700436e-05, 0.0005101344, 4.15194e-05, 0.00073082827, 0.00030821955, -0.0003006101, -0.00035730356, 0.00045116068, -1.2682168e-05, -0.0005572951, 0.0001764056, 0.00015742586, 6.6263997e-06, 8.168444e-05, 0.0002537674, -0.0010275407, 0.0008190527, 0.00026818275, 0.0007858142, -0.00047775812, 0.00080553634, -0.00055704557, -0.0006096105, -0.00010356802, -6.359692e-05, -0.00079396734, -0.0016264855, 0.00042152163, 0.0009132118, -0.00044622424, -3.927606e-05, 0.00029957303, 0.00011954782, 8.382737e-05, -1.18802e-05, 7.52192e-05, -0.0001545487, -0.0003172836, -8.753972e-05, 0.00019024061, 0.000147016, -0.00016924675, -5.817937e-05, -1.6117845e-05, 0.00016011694, -0.00010452752, 1.33474605e-05, -0.0001249758, 0.00022486119, 0.00014225778, 0.00020093733, -0.00015600659, 0.00042478647, -0.0001384301, -7.776353e-05, -0.00018608317, -7.9093974e-05, -0.00014942799, -0.0003589629, 0.00023554568, 0.00024290114, -9.676503e-05, 5.408062e-05, -2.7852737e-05, -1.8460341e-05, -0.00013451852, 1.1566994e-05, 3.159564e-05, -5.5288438e-05, 0.00017529061, 5.496693e-06, -4.2846e-05, 0.000118051335, 0.00013525075, 9.619735e-05, -8.687027e-05, 1.8638984e-05, -6.110686e-05, 4.7500856e-05, 0.00014246987, -3.869892e-05, 6.8034475e-05, -0.00019792769, -0.00013617564, -0.00028058502, 3.1088468e-05, -8.39713e-05, 3.581647e-05, 9.8557775e-06, 0.00016979114, 0.0002200938, -1.27943495e-05, -0.00018128137, 9.768638e-05, -1.9059959e-05, -6.4841006e-05, 0.00011666988, -0.00020151005, 7.730909e-05, -0.00040629637, -0.00021467007, -3.4961024e-05, 1.3197448e-05, -5.0560255e-05, 0.0002269106, 0.00022341426, -6.570183e-05, -0.00015387735, 9.759924e-05, -0.00019464939, -8.675712e-05, 0.0005430341, -0.00017705721, -0.00015733558, -0.0003379204, 0.00016138615, -0.00033937482, 0.00017922804, 0.00020261951, -2.144148e-05, 4.5226443e-07, 0.000286884, 0.0006185916, 6.751361e-05, -0.0003152447, 0.00014314282, 0.00011675946, -0.00031735454}},
    {"bert.encoder.layer.4.attention.self.value.bias_grad", {0.0012304657, -0.00014042029, 0.0008596741, 0.00028086276, -0.00072209624, 0.00045555434, 0.0001266064, -5.6376393e-05, 0.00043926513, 0.00041352725, -0.0009558173, 0.00013557496, 0.00023929263, 0.0011349332, -0.0005278955, 0.000431268, 0.00017105341, -0.0013863, -0.0010874914, -0.0006789809, 5.902221e-05, -0.00013096633, 0.0016656817, -6.0804243e-05, 0.0014017244, 0.001086, 0.0006566432, 0.0011942195, -0.0015733843, -0.00030810383, 0.00017763233, 0.0006890645}},
    {"bert.encoder.layer.4.attention.output.dense.weight_grad", {-3.601852e-05, 2.9779847e-05, -7.067637e-05, 0.00014974335, 0.00013515675, 8.693947e-06, 0.00016675507, 0.00014108568, 5.065765e-06, 4.472464e-05, 3.5633905e-06, 3.2910739e-06, 0.000103850216, 3.370388e-05, 5.612865e-05, -6.9431306e-05, 9.556357e-05, -1.2630551e-05, 9.4348776e-05, 5.082779e-05, 5.4537835e-05, 5.422657e-05, -0.0001484998, 2.0628742e-05, 3.9394563e-06, 3.044429e-05, -0.000106013, -5.753511e-06, -0.00012839393, 6.235778e-05, -6.302635e-05, -7.270731e-05, 4.0411534e-05, -2.3962793e-05, 7.6328455e-05, -0.00010871142, -0.00011204506, -2.0045474e-05, -0.00015333008, -0.000103939725, 4.2116358e-06, 0.00017140844, 8.697848e-05, -2.3779185e-05, -9.549599e-05, 1.8146673e-05, -1.3731314e-05, -7.793065e-06, -0.000130818, -1.8647646e-05, -5.5216165e-05, -6.805781e-05, -5.886335e-05, 1.7933351e-05, 0.0001532159, -1.9614768e-05, 6.653349e-05, 6.2947925e-05, 5.0674946e-05, 2.5008032e-05, 3.904182e-05, -7.6096716e-05, 4.006592e-05, 9.933841e-05, -0.00021216286, 0.00033432717, 7.7728737e-07, 1.7015362e-05, -1.8136192e-05, 3.7795093e-05, 9.1690956e-05, 0.000109321256, -0.00011141578, -2.0251058e-05, -0.0001681875, 0.000111826856, 9.061331e-05, -8.319318e-05, 0.00035141478, 0.00023510407, 0.00025815744, 0.000121818906, 0.00011968825, 0.00019789912, -7.598512e-05, -0.00020148668, -0.000120362325, -1.9580988e-05, 2.7888795e-05, -0.00015749861, -4.1540232e-05, -8.9207395e-05, -0.00014854566, -3.4913315e-05, 9.8088785e-05, -0.0002188428, 7.697704e-07, 5.9953814e-05, -0.00032612443, 0.0003846634, 0.0002570694, 0.00011368881, 0.0003006654, 0.00013471808, 0.0001741239, -0.00040155093, -0.00012508144, 0.00018642723, 0.0002816059, 3.449488e-05, -5.77111e-05, -0.00016128468, 0.00019276787, -1.953443e-05, 0.0001244184, 9.033422e-05, 0.00015645719, -5.268268e-05, -0.00032206273, -4.5852084e-05, -0.00026084943, -7.910397e-05, -0.0001918518, -4.02148e-05, -9.491995e-05, 0.00015154347, -0.00014373686, -0.00026273157, 0.00016889631, 3.263461e-05, -1.757512e-05, -0.00015265193, -0.00023123268, 4.6398083e-05, -0.00031201026, -0.00018218676, 8.673599e-05, 0.00079611107, 0.00037947198, -0.000130739, -0.00016359854, 0.00037215807, 7.005701e-05, -0.00027168708, -0.00035133466, -7.81098e-05, 0.0001654552, -0.00014333258, -0.00015350647, 0.000108338434, 0.00033365062, -9.187368e-05, 0.00027973112, 0.00027267405, -1.856483e-05, 0.00018602362, -0.00010193861, -0.00025320795, -0.00013176774, 0.00024336985, 0.00027227824, -0.00024688628, -9.436904e-05, -6.2797308e-06, -2.9509312e-05, 2.6755455e-05, -0.00016686817, -0.00012335787, 0.00023503753, 0.000255684, 0.000256904, -0.00014015732, -9.209072e-05, 0.00025082234, -0.00024903513, -0.00037209372, -0.00032906272, -0.00012149432, -2.2580532e-05, -0.00018360939, -2.532016e-05, 0.00019600503, 0.00018186183, -4.264309e-05, -2.4557814e-05, 0.00025770525, -2.4631188e-05, 0.00015440927, 5.8871916e-05, -0.000101270314, -0.0001425266, 0.0002211291, 2.2319098e-05, 2.514429e-05, -0.00070587214, 0.00086663157, 0.0006499564, 0.00019072309, 0.0007411646, 0.00038001512, 0.0003628758, -0.0012224447, -0.0004267455, 0.0003010694, 0.00063387933, 4.823306e-06, -0.0002054267, -0.00028440572, 0.00050500163, -2.1599597e-05, 0.00021429335, 0.00021584661, 0.00039659592, -5.919131e-05, -0.0008129472, -3.620785e-05, -0.00069313863, -0.00023952013, -0.00036610442, -8.980752e-05, -0.00012635365, 0.00037369123, -0.00030599796, -0.0005700091, -0.00013780176, 4.8298745e-05, 0.0009266707, -0.0011061275, -0.0008763733, -0.00026302366, -0.00094198965, -0.0005700933, -0.000549344, 0.0010144081, 0.00027038215, -0.0001912709, -0.0007557526, -0.00028027873, 0.00023468786, 0.0006684306, -0.0004725835, 8.667056e-05, -0.00038284832, -0.00022878722, -0.00042368122, -0.00014197198, 0.00097010063, 3.5880017e-05, 0.00074253965, 3.0428315e-05, 0.0005596962, -1.598961e-05, 0.00035406862, -0.00038138134, 0.00053769717, 0.0005935382, 4.7293142e-05, -0.0002589392, 9.75897e-05, -4.766294e-05, 7.498728e-05, -7.6053926e-05, 2.0674932e-05, 3.1110994e-05, -1.0587813e-05, -0.00028944341, -6.0067116e-05, -0.00010066685, -4.599627e-05, -0.000121933466, -0.00023469362, 3.468167e-05, -4.295085e-05, -3.7715825e-05, -0.0001669024, -7.898902e-05, 5.185912e-05, 0.00010041239, -2.9919354e-05, 8.0160076e-05, -8.6484615e-05, -1.8722629e-05, 9.501734e-05, -1.1834491e-06, 0.00016551594, 0.00010607297, 3.306692e-05, 9.065313e-05, -7.0012706e-05, 9.806041e-05, -0.00019735382, 0.00027300313, 0.00027883597, 9.8629374e-05, 0.00032468236, 0.00025107668, 8.0377926e-05, -0.000492177, -0.00027113705, 9.469986e-05, 0.0002457212, -5.8509846e-05, 3.997152e-05, -3.2444852e-05, 0.0002629842, 5.7547517e-05, 7.883743e-05, 0.00015422412, 0.00011831286, -3.511408e-05, -0.0003661494, 3.0123425e-05, -0.00025763313, -0.00015494651, -0.00011394972, -9.725834e-05, -9.852153e-05, 0.00012257756, -8.342991e-05, -0.00026774625, -9.8535085e-05, 0.000324276, -0.00017783798, 0.00014659212, -3.1490115e-05, 8.306307e-05, 3.8920032e-05, -2.4313276e-05, 3.5626083e-05, 2.3941318e-05, -8.8628534e-05, 0.0001819206, 0.00016915749, 6.364264e-05, 0.0002483458, 6.151033e-05, 0.0001705476, 3.3057437e-05, 0.00018798985, 0.00011666321, 1.8121158e-05, -0.00018667677, -8.2480554e-05, -8.973202e-05, -1.675068e-06, -0.000118377, -0.00010873072, -2.6521056e-05, -0.00011952812, -4.589085e-05, 6.286925e-07, -0.00020325126, 0.00010267576, -0.00015023451, 0.00013646632, -0.000223572, -0.00015807817, -4.4249606e-05, -0.00020818094, -0.00012743594, -5.757741e-06, 0.00039811453, 0.00023544536, -0.00015145788, -0.00021070462, 0.00010161948, -4.926832e-05, -0.000100273915, -0.00024927588, -2.635362e-05, -7.727655e-05, -0.00011504288, -0.00011593748, 0.00010412193, 0.00026144466, 8.033262e-06, 0.0001588789, 0.00018812246, 6.99626e-05, 9.018126e-05, 4.242881e-05, -0.00013373865, 2.06397e-05, 0.00022575656, -9.638963e-05, 9.412292e-05, -0.0001395106, 0.00021832174, 0.00014809347, 4.5476252e-05, 0.00024073893, 9.14304e-05, 2.0751188e-06, -0.00014489736, -7.4419026e-05, 0.00016057877, 0.00018700057, -4.7629943e-05, 4.9513917e-05, -1.7073073e-05, 0.00019654717, 1.2171898e-05, 7.722837e-05, 0.000103481114, 0.00012348345, -7.710598e-05, -0.0001988699, -1.230345e-05, -6.8056244e-05, -7.914746e-05, -0.00013025315, -7.215987e-05, -0.000105753, 0.00014620386, -1.4517241e-05, -0.00021332088, -0.00017718934, 0.0002237616, -0.00017304548, 0.00026696874, 0.00021280936, 7.105304e-05, 0.0003362028, 0.00019481081, -3.1075386e-05, -0.00044999082, -0.00026349621, 0.00019423375, 0.00025280638, -0.00010549019, 0.000160073, 0.000113849565, 0.00036009992, 8.720479e-05, 0.00010175215, 0.00020111159, 0.000116831645, -0.0001373475, -0.00036385923, 1.41309265e-05, -0.0001701407, -0.00021942411, -0.0001151851, -0.00012527134, -0.00014165528, 0.00012909679, -3.8729977e-05, -0.00032916965, -3.3617394e-05, -4.88303e-05, 0.0001668734, -0.00014180165, -7.286147e-05, -9.874969e-05, -8.120248e-05, -4.2402185e-05, -0.00010434016, -9.675855e-05, -7.9725796e-05, -6.822448e-05, -9.4638264e-05, -0.00014180987, -9.2298e-06, 0.00019486027, 2.3882714e-05, 2.653976e-05, -0.00013409647, -7.105305e-06, -1.7917735e-05, -5.3354925e-06, 7.100793e-05, 5.0779916e-05, 1.9975636e-05, -5.352705e-05, 0.00011488886, -2.9153169e-05, 0.00012197317, -1.1577195e-05, 0.00012665347, 7.99912e-05, 0.00016061166, -0.00021244903, -3.5329882e-05, 4.8110167e-05, 3.3840726e-05, -4.09285e-05, -2.707989e-05, -2.2972825e-05, 9.421911e-05, 0.00012681299, 0.00017326097, -0.000115620656, -5.6225224e-05, 0.000115995696, -0.00018071006, -0.00022004922, -0.00017034434, -8.053893e-05, -2.8620383e-05, -0.000113925074, 1.888166e-05, 0.00017757359, 6.499773e-05, -1.5214273e-06, -1.3064804e-05, 0.00019300907, -2.7745678e-05, 9.4431496e-05, 8.128653e-06, -1.1111475e-05, -8.7662e-05, 0.00014501333, -0.000111086476, 5.8610956e-05, -0.00026782064, 0.0003614409, 0.00038103625, 9.8870354e-05, 0.00047716463, 0.0002958622, 8.794408e-05, -0.0008042151, -0.0003616935, 0.00014483741, 0.00032417566, -0.0001231862, -1.5745682e-05, 1.2662622e-05, 0.00040448728, 7.841803e-05, 4.0476025e-05, 0.00021630609, 0.0001744822, -8.611584e-05, -0.0005096077, 5.311911e-05, -0.00038079967, -0.00024112767, -0.00013647838, -0.00012436206, -7.249649e-05, 0.00022206097, -8.8038956e-05, -0.00037538435, 8.129225e-05, -0.00015241759, 5.4965007e-05, -0.00021530324, -0.00020188793, -1.5750698e-05, -0.00020684094, -0.000232356, -5.66462e-05, -4.1766038e-05, 0.00014894876, -1.3694869e-05, -0.00019321074, 3.401112e-05, -0.00022134068, 6.373142e-05, -0.00018394335, -1.878161e-05, -5.380611e-05, -0.00011257034, -0.00010870122, -0.00010011518, 0.00022528383, -6.550711e-05, 4.958782e-05, -1.00104235e-05, 0.00015886348, 9.539118e-05, 0.00018735931, 1.0588155e-05, -2.2231561e-05, 0.00013559083, 0.00021507664, -0.00024633654, -0.00011602213, 0.00010169966, 9.185998e-05, -7.3124547e-06, -1.6198195e-05, 5.765867e-06, 0.00018294386, -5.960412e-06, 0.00010628072, -0.00014885896, 4.9789064e-06, 0.00016666276, -0.00024121355, -0.00028199152, -0.00017780453, -0.000112005466, 7.041314e-06, -0.00013560499, 6.302038e-05, 0.00020966645, 4.2530164e-06, 6.343347e-06, -8.7067536e-05, 0.00016072456, -3.7016514e-05, 0.00011823142, 5.6673685e-05, -6.4481715e-06, -0.00014480004, 0.00014473347, -0.00010680478, 0.00014923852, 0.0004349145, -0.0005528926, -0.00047848767, -0.00011404349, -0.0004573974, -0.00028685198, -0.0002976004, 0.0008734323, 0.00026075824, -0.000103087616, -0.00037109197, -1.6767637e-05, 0.000282203, 0.00028106614, -0.00021368414, 5.8033787e-05, -8.231641e-05, -5.33326e-05, -0.0002636843, -8.8231645e-05, 0.0005355223, -1.4974088e-05, 0.0005035692, 9.563182e-05, 0.00020635055, 2.939231e-05, 1.5826523e-05, -0.00024501793, 0.00025795578, 0.00026784078, -7.0934286e-05, 0.00012802894, -0.00030424076, 0.0003940402, 0.00033445426, 0.00011033778, 0.0003674473, 0.00022731286, 0.00015376147, -0.00088952814, -0.00043278662, 0.00019323554, 0.0003497621, -0.000125483, -2.4624262e-05, 4.1279138e-05, 0.00037413085, 4.9550523e-05, 4.6165558e-05, 0.0001758706, 0.00019226066, -0.000111075635, -0.00048199258, 1.3674862e-05, -0.0004359079, -0.00028639115, -0.000118399636, -0.00012982452, -5.5505384e-06, 0.00017063563, -8.9752946e-05, -0.0003580674, 3.5357512e-05, -0.00025768424, 4.4267785e-05, 1.0943891e-05, 0.00016463223, -2.5532489e-05, 0.0001320807, 0.00012609309, -2.1100852e-05, -0.0006432278, -0.00019254183, -5.0061793e-05, -1.1946939e-05, -0.00019587622, -0.00030061934, 6.907455e-05, 4.1660147e-05, 1.4115576e-05, -0.00015361297, -2.613163e-05, 6.552203e-05, 4.6649842e-05, -0.00016986729, 8.237936e-05, -0.00023625439, -0.00011836489, 0.00010812085, -5.422524e-05, 0.00018768878, 0.00018029158, -3.220107e-05, 1.479248e-06, -2.2616428e-05, -1.5271904e-05, -2.9122963e-05, 8.895779e-05, 0.00013319719, 1.8178785e-05, 0.00014381221, 0.00012676835, 2.5871428e-05, -1.0368179e-05, -2.9431018e-05, -1.5544787e-05, 7.6554345e-05, -2.9845762e-06, 1.8557257e-05, -7.926278e-05, 6.387245e-05, 3.2856253e-06, 6.9762527e-06, 4.4021417e-05, 5.1335675e-05, 6.74768e-05, -0.000118376185, 4.3419772e-05, -3.4233166e-05, 2.1561946e-05, -6.6495246e-05, -2.9824998e-05, -8.296111e-05, 4.9751507e-05, -2.4733135e-05, -5.890073e-05, -0.00031941623, 0.0003356132, -2.9837807e-05, 0.0001792433, 0.00016617912, 1.6163116e-05, 0.00033140116, 0.0002030628, -0.00017841387, -0.00045397234, -0.0003936011, 0.00022202183, 0.00026332456, -0.00026880475, 0.00028801968, 0.00035388122, 0.0004880456, 0.00012987318, 5.532837e-05, 0.0002664797, 0.00013431087, -0.00022116392, -0.0003531936, 4.914454e-05, -8.862719e-05, -0.0003461641, -5.3966396e-05, -0.0002077249, -0.0001196168, 0.00017261156, 0.00012501693, -0.00037894357, 5.9443235e-05, 6.986855e-05, 0.00019054169, -0.0002897958, -0.00037399316, -7.2943636e-05, -0.00041132484, -0.00030906472, -8.9167865e-05, 0.00084942876, 0.000338737, -7.156242e-05, -0.0002434244, 0.00015461422, 0.00013386935, -1.1281554e-05, -0.0003031099, -5.2583047e-05, 1.592011e-05, -0.00014537842, -0.00012775196, 2.8980852e-05, 0.00046887627, -7.019946e-05, 0.00039529603, 0.00020523851, 7.257601e-05, 0.0001022023, -6.363395e-06, -0.0002329186, 9.3560164e-05, 0.0002780046, 0.00010143654, -0.000193915, 0.00080807833, -0.0010665033, -0.0008440272, -0.00023105266, -0.0009774268, -0.00057304464, -0.0003701977, 0.0017502768, 0.00079467136, -0.00040550358, -0.0008597907, 0.00015713013, 9.589202e-05, 0.00013531196, -0.0008157102, -5.1387167e-05, -0.00024537108, -0.000376241, -0.00052202615, 0.0001470987, 0.0011256067, -4.1293733e-06, 0.0009127975, 0.0004770053, 0.0004145704, 0.0002246742, 0.00014922122, -0.00047000562, 0.0002743142, 0.00081837457, -0.00015164845, -2.2894355e-05, 0.00022546822, -0.00013972312, 7.432029e-05, -4.6047284e-05, 9.851815e-05, 0.00020292241, -0.00017271783, -0.00010601399, -0.00014278256, -8.2248116e-05, -4.94186e-05, -0.00021241096, 7.21337e-05, 0.00021459883, 0.0001255772, 7.609686e-05, -8.390141e-05, 8.387913e-05, -5.8167218e-05, 6.7464504e-07, -9.8175726e-05, 0.00011515719, 3.6063535e-05, -9.0607435e-05, 7.973536e-05, -9.567062e-05, 5.59602e-06, 8.4754596e-05, 0.000112294445, -2.1110616e-05, 0.00019163387, -0.0002188192, 0.000158552, -0.00027623837, -0.00025876984, -6.794163e-05, -0.00036514224, -0.00026610398, 1.4859245e-07, 0.00051695376, 0.0003328884, -0.00016737718, -0.0002741237, 0.00015638309, -0.00017545822, -0.00014033842, -0.00041206714, -9.8044286e-05, -7.98454e-05, -0.00023951319, -9.706137e-05, 0.00014475505, 0.00040923778, -3.024084e-05, 0.00023211981, 0.00023098134, 0.00012879712, 0.00014670253, 0.00012564556, -0.0001432491, -7.756418e-06, 0.00035379725, 0.0002047296, -0.00033386186, 0.00045303482, -0.00056099874, -0.00039151387, -0.00017139851, -0.00056053634, -0.00029177876, -9.729334e-05, 0.0010983635, 0.0005520871, -0.0003835966, -0.0005071924, 0.00017892603, -0.00010815489, -0.00014442642, -0.000612439, -0.00011785861, -0.00019470314, -0.00032597219, -0.00023540304, 0.00031300852, 0.00065882324, 4.8132006e-05, 0.0005014914, 0.00043881856, 0.00020754022, 0.0001950578, 0.000109230044, -0.0002769201, 8.867871e-05, 0.0006154655, 8.935665e-06, 0.00012189037, -0.00014129496, 9.64314e-05, -5.6502307e-05, 6.990512e-05, -1.9171654e-05, -9.4575305e-05, 3.647514e-05, -4.087845e-05, 1.1781409e-05, 0.0001676518, 6.0436465e-05, 4.0029136e-05, 8.0683985e-06, -2.603964e-05, 3.801382e-06, -1.2285433e-06, 0.00011099569, 6.7174806e-06, 2.132426e-05, -0.00013561448, 1.1273877e-05, -0.00010643491, -3.3994394e-05, -4.766395e-05, -4.9249284e-05, -5.649799e-06, -1.4305751e-05, 1.3494458e-05, -4.2275107e-05, -9.574483e-05, -8.6020664e-05, 0.00014453319, -9.038625e-05, 0.00011473759, 9.661694e-05, 4.7093676e-05, 0.00012522729, 0.00011058219, 2.9211371e-05, -0.00031007268, -0.0002220723, 7.77799e-05, 0.00014610306, -7.043119e-05, 0.00010794152, 0.00010203719, 0.00019985136, 5.110557e-05, 4.952123e-05, 0.00011407558, 3.4619123e-05, -9.957751e-05, -0.00019137711, 5.561882e-06, -0.00013723498, -0.00015724143, -4.060104e-05, -6.707525e-05, -2.0872632e-05, 3.12892e-05, 1.8004823e-05, -0.0001738957, 1.7093935e-05, 0.00010435955, -0.0008581073, 0.0011697179, 0.00090186286, 0.00021224859, 0.00096755323, 0.0006185385, 0.00049895426, -0.0014961417, -0.0006197626, 0.00032387805, 0.00083473226, -2.8373459e-05, -0.00012991506, -0.0003622025, 0.00069814967, -1.6976574e-05, 0.00026466104, 0.0003158558, 0.00049205084, 2.1884618e-05, -0.0011074158, -5.8533487e-06, -0.0009206931, -0.00024745494, -0.0005200176, -0.00015482794, -0.00023949351, 0.00039672563, -0.00036348193, -0.00071425}},
    {"bert.encoder.layer.4.attention.output.dense.bias_grad", {-0.0014535093, 0.0016062759, -0.0005972672, -0.004879067, 0.0032174152, 0.0001810943, -0.0117534315, 0.014772967, -9.142463e-05, -0.0046732468, -0.0012365037, 0.0028884388, -0.002299388, -0.0037637334, 0.0014479961, 2.5490546e-05, -0.0064291344, 0.0027623835, -0.0011267938, 0.007885013, -0.00655171, -0.0015992735, -0.0014704401, -0.0026619856, 0.005794457, 0.015311979, 0.00041136533, 0.0046019563, 0.008260107, -0.00028467432, -0.0023223078, -0.015973046}},
    {"bert.encoder.layer.4.attention.output.LayerNorm.weight_grad", {-0.002212538, -0.0016524178, 0.0010882107, 0.0024238029, 0.0039203516, 0.002626025, 3.948325e-05, -0.0007070326, -0.002907555, -0.0022028373, 0.0012958532, -0.00046321438, -0.0023597463, -0.00037705712, -0.0028146906, -0.0004321279, 0.0017566762, -0.00019453203, -0.0030078401, -0.0003159774, 0.005045805, -0.004649236, -0.00039609443, -0.0020156584, 0.0008563332, 0.0031787308, 0.00028369014, -0.0019722031, -0.002253639, 0.0014314825, 2.9275456e-05, 0.006921175}},
    {"bert.encoder.layer.4.attention.output.LayerNorm.bias_grad", {-0.0014571499, 0.0016062463, -0.0006001807, -0.0048805745, 0.0032197062, 0.0001857093, -0.011754697, 0.0147724245, -9.455707e-05, -0.004675364, -0.0012364822, 0.0028900225, -0.0023025787, -0.0037682005, 0.001446926, 2.559497e-05, -0.006432231, 0.002763356, -0.0011243003, 0.007885073, -0.006552303, -0.0016025174, -0.0014730231, -0.0026684983, 0.0057957536, 0.015311883, 0.0004051684, 0.0046031275, 0.008260309, -0.0002849943, -0.002322894, -0.015975375}},
    {"bert.encoder.layer.4.intermediate.dense.weight_grad", {-6.488342e-05, 7.155116e-05, -3.2705457e-06, -7.9090314e-05, 0.00010309271, -3.9981216e-05, 3.3153926e-06, -2.6436559e-05, 3.1996042e-06, 2.1216787e-05, -3.34249e-05, -1.8668698e-05, -5.3067444e-05, -7.361784e-05, 5.3688196e-05, 7.2488285e-05, -1.8950204e-05, -2.0168356e-05, -1.9474635e-06, -4.0322895e-05, 4.6312878e-05, 0.000100704645, 5.882005e-05, 2.1267328e-05, -3.3077482e-05, -5.2785934e-05, 6.151102e-05, 1.4335036e-05, -5.528138e-05, 2.5993711e-05, -3.6021363e-05, -6.5006902e-06, -1.3744705e-05, -9.556687e-05, -2.9401315e-05, 0.0002024878, -0.0001924252, 6.5492335e-05, 2.250264e-05, 2.9371293e-05, -0.0001422543, -6.7583125e-05, 4.267652e-05, 0.00014476947, 0.00020847266, 0.00011068994, 7.9542195e-05, -0.0002242427, 0.00018983868, -1.1295029e-05, 7.804882e-05, 5.0037565e-05, 8.998642e-05, -0.00025155809, -0.00012557794, -5.71084e-05, -1.3870806e-05, -3.978768e-06, -0.0002703823, -0.0001723653, 0.00022898777, -8.219554e-05, 2.338486e-05, 0.00018726112, 1.8665083e-05, 0.00011200771, 7.90119e-05, -0.00014433592, 0.00015059036, -0.00012158448, -6.311206e-06, 7.234551e-05, 0.00014001732, -8.419449e-05, -4.270148e-05, -0.00016502097, -0.0002630538, -0.00011952533, -0.00020175139, 0.00013097009, -0.0002102127, -6.545646e-05, 2.1690172e-05, 2.1536618e-05, 9.8265606e-05, 0.00023550067, 0.00016404383, 3.2501244e-05, 7.2932344e-05, -8.039829e-06, 0.00020252385, 0.00019380162, -0.0002137601, 0.00010712364, -5.427143e-06, -0.00020215222, 8.964383e-06, -0.00011568377, -7.0939794e-05, 7.687751e-05, -0.00024605577, 3.6989743e-05, -1.7024318e-05, -4.2115073e-05, -0.00015672825, 4.497086e-06, -9.486652e-05, 9.4152e-05, 0.00030482266, 7.8831734e-05, 5.64988e-05, -4.660477e-05, 0.00014566672, 1.0222682e-05, 4.0756615e-05, 0.0001657605, 7.84814e-06, -0.00015728264, 3.073443e-05, -1.8562154e-05, -5.0722712e-05, -9.162041e-05, -0.00011714746, -7.078296e-05, 0.00022046898, -0.00012560093, -1.8684612e-05, 0.00015733017, 4.4150573e-05, -1.0888046e-05, 3.8312995e-05, 0.00022925831, -0.00010317085, 4.898479e-05, 2.8445671e-05, 0.000107367836, -8.3825405e-05, -0.00019272833, 0.000114772185, 0.00011970753, 4.216454e-05, 7.511879e-05, 2.2033742e-05, -0.00027180352, 0.00017354201, -1.6776341e-05, 0.0001725279, -1.5460326e-05, 0.0002445917, -0.00020115472, -0.00027642053, -9.252588e-05, 1.5646497e-08, -7.352509e-05, -0.00037011533, -0.00018935473, 0.00016881316, -2.7354636e-05, 0.00010705442, 0.000188242, -0.00034651344, 0.00024827858, -3.0523584e-05, 0.00022913166, 2.8284918e-05, 5.985839e-05, 0.00011323507, -1.5379584e-06, -6.6789624e-05, -0.00018081622, -3.7833524e-05, 3.1038771e-06, -4.0079827e-05, 9.667929e-05, 0.00029089185, -0.00018023452, 0.0003391618, 4.056943e-05, 0.00011079062, -0.00010890644, 0.00022681372, 7.508169e-05, -0.00019085054, -3.2176747e-05, 9.223391e-05, -0.00017720796, -0.00053971657, -0.00025070304, 8.636784e-05, 6.8615955e-05, -0.00028270384, 0.00035749516, 4.5139324e-05, -7.574657e-05, 0.00011209925, -2.2899547e-05, 0.000117858326, 0.0001309124, 1.8886108e-06, 7.887964e-05, 0.00017375956, 2.2706325e-05, 0.00026031825, 1.2975547e-05, -0.00022163654, -5.8541926e-05, 2.3670354e-05, -1.81304e-05, -0.00016479913, -1.8041974e-05, -0.00016049315, -0.0001409579, -0.0001782285, -0.000105148225, -0.00013801968, -5.39394e-05, 5.4899258e-05, 0.00031735437, 0.00022802522, -4.3287466e-05, -0.00020749395, 6.5763474e-05, 0.00014586703, -0.00018475261, 3.6049303e-05, -1.7746116e-06, -0.00013005723, -0.00011610243, 0.00023298555, -2.2077702e-05, 0.00014848296, -0.00017309304, -1.4236517e-08, 0.00020790249, 4.693366e-05, -5.6910798e-05, -2.1032763e-05, -7.3526435e-06, 0.00023797671, 0.00019347541, 7.5171356e-06, 0.0001176465, -0.00023854616, -0.00030802801, -0.00035425654, 0.00010961337, -5.0065144e-05, 0.00013905732, 6.478908e-05, 0.00016693163, -6.3569297e-07, -8.388875e-06, -8.322521e-05, 9.043e-05, -0.0002214445, -6.785226e-06, 0.00015925543, -0.00024142752, -4.1626907e-05, -0.00029571838, 0.00012500916, 3.248202e-05, -1.7947091e-08, -0.00020259513, 0.00012649916, 0.0003475086, 2.2921178e-05, -7.387266e-05, -1.23290265e-05, -0.00012012741, -6.222139e-05, 0.00031497463, -0.00032422852, 7.6495504e-05, -0.0003568619, -1.8995665e-05, -0.0005455705, 9.4271134e-05, 0.00017306612, 0.00014171797, 4.076449e-06, 0.0003454843, 0.00071952515, 0.00018692287, -0.00022687086, -4.031624e-05, 6.601684e-05, -0.00037344662, 7.821533e-05, -0.0001536944, 4.7850663e-06, -0.00011878971, -0.00017801054, -0.000117544136, -0.00022722027, 7.86855e-05, -4.0628485e-05, -7.907946e-05, -0.00012919705, 5.7300073e-05, 0.00025533995, -0.00013254583, -0.00023763962, 5.589468e-05, -4.9841547e-05, -0.00017194144, 0.000147907, 0.00033110485, 0.00021338221, -2.3865938e-05, 0.00024322774, 6.613272e-05, -0.000120283694, -0.00017557194, 0.00020841735, 8.439531e-05, 0.00011183238, -0.00013740566, 0.00016523073, -8.591196e-06, 3.602755e-05, -0.00015796341, -2.2495815e-05, -2.0237941e-05, 3.6037627e-06, 0.00023657172, 2.1491403e-06, -9.150794e-05, 3.7100952e-05, 0.00015444096, 0.00013855574, 0.000117552736, 8.5653155e-05, 2.7210162e-05, 0.000271551, 5.6862278e-05, -9.0075755e-06, 4.6943795e-05, -0.0002487237, -0.00011398406, -0.00027852505, -0.0001712138, -0.000116813746, -5.216807e-07, 2.2726928e-05, 0.000268209, 0.00012511371, -0.00029205065, -8.932404e-05, -8.234182e-05, 7.686128e-05, -1.242277e-05, -4.949815e-06, 4.329877e-05, 0.00022022334, 0.0001202751, -3.8859635e-05, 1.8031353e-05, -5.9884802e-05, 0.0001946689, -4.838759e-06, -0.00023848169, 9.499976e-05, 4.853125e-05, -0.00023249291, -4.214591e-05, -0.00024693206, -0.00019809452, -0.00014696902, -0.00010393447, 0.00017099775, 0.00019173721, 0.000264467, -0.000100211444, -7.555453e-05, -0.00018900356, -8.305644e-05, -6.0065195e-06, 0.00016385753, 0.00015474067, -2.0989732e-05, -1.3128366e-06, 0.00019689433, -8.900426e-05, 0.00015685074, -0.00015901672, 2.7592276e-05, -1.936523e-05, 3.9314156e-05, 5.5483702e-05, -4.2860192e-05, -4.4771416e-05, 7.008496e-05, 9.440521e-05, 0.00019091203, 6.4624175e-05, -4.596619e-06, -5.5896613e-05, -2.937449e-05, -1.4260865e-05, -0.00014677047, 2.4690831e-05, -0.00015336763, -9.570048e-05, -0.0001540124, -0.0001626422, -3.2954256e-05, 3.689344e-05, -6.0733106e-05, 0.00028890304, 0.00029883624, 5.8417646e-07, -0.00010525269, -4.417264e-05, 0.00014111992, -0.00016454689, -0.00016515308, 0.00011577931, 0.00019353798, 0.00037458848, -0.00013293905, 0.00011094503, 1.3574758e-05, 0.00034258259, -2.27203e-05, -0.00043933903, 0.00019074988, 0.00020615861, -0.00019000417, 2.0089945e-05, 3.75708e-05, -0.0004365809, 0.00019025037, -0.00016461454, 0.00024416848, 0.00015716869, 0.00042690116, -0.00024176834, -0.00042314403, -0.0003350299, -8.222507e-06, -0.000103927116, -0.00036161367, -0.00015494737, 0.00013411859, 3.076142e-05, 0.00019094022, 0.00020011787, 0.00013951221, -0.00021993912, -3.541606e-05, 0.00024730983, -0.0003019381, 7.0162794e-05, -1.5285821e-05, -1.9389765e-05, -0.00021146842, -2.2803859e-05, 8.568245e-05, 0.00018952883, 0.00039813126, 0.0002447414, -8.1299084e-05, -0.00031867067, 0.0001578688, 7.891381e-05, 5.022269e-05, 0.00010191038, 6.984098e-05, -0.0004195819, -0.00011522951, -9.093053e-06, -6.897701e-05, 4.83365e-05, -0.00030095893, -0.00018816472, 0.00028038284, -0.00013685862, 0.00014605305, 0.00015647682, -0.0002410988, 0.00015174804, 9.025303e-05, 0.00030955934, 0.0001167614, 0.00021016021, 0.00013095661, 6.718137e-05, 2.9526018e-05, -0.00022706491, 0.00021310923, 6.114477e-05, -0.00012811131, 8.305041e-05, 0.00030423212, -0.00033864367, 0.00023145213, -2.675161e-05, -1.0546368e-05, -0.00016884523, 1.3664215e-05, -0.00013448959, -0.00038241685, -0.000116548654, 0.00010996381, 7.8193e-05, -0.00038608664, -0.00022218208, 6.156035e-06, 5.9709957e-05, -9.0180314e-05, 0.00020614418, 4.894494e-05, -7.568657e-05, 6.875135e-05, -0.000149189, 1.54445e-05, -2.657567e-05, -9.819206e-05, -6.72868e-05, 3.7709728e-05, 8.73016e-05, -2.8727607e-05, -3.040875e-05, -3.8193626e-05, -4.3737782e-05, -0.0001900305, 0.0001300699, -0.0001692339, -2.0610794e-05, -8.1889746e-05, 0.00010631167, -4.6207948e-05, 5.7637222e-05, 0.00017827457, 5.125573e-05, -4.2972744e-05, 0.00010587465, 0.0003504302, 0.00013237081, -8.7008404e-05, -5.5047465e-05, 8.912672e-05, -0.00020850427, -3.0727606e-05, 9.570976e-05, 2.8307451e-05, 5.6886252e-05, 0.00016626612, 9.82973e-05, 5.704865e-05, 3.2054577e-05, 5.8742746e-05, -8.973375e-05, 0.00013929453, 1.2395031e-05, -0.00020570538, -4.1133047e-05, 0.00014861637, -5.8446545e-05, 1.8223156e-05, -1.3844998e-05, -2.7468885e-05, -0.00017945496, -1.7726437e-05, 7.8189205e-06, -0.00018326551, -2.8519149e-05, 3.5476383e-05, 8.9997055e-05, -4.309886e-05, -7.826457e-05, -7.955571e-05, 2.5919759e-05, -3.4281107e-05, 4.0172483e-05, 8.3622304e-05, -8.085816e-05, 0.00013886268, 0.00012673643, -0.00019286596, -8.5774474e-05, -5.6901343e-05, 5.9309274e-05, -4.8077603e-05, -0.00014221392, -1.7134606e-05, 1.8600946e-05, 6.355872e-05, 4.8331658e-05, -0.00024257881, -0.00014877635, -6.789985e-05, -3.3548797e-05, 0.00016151987, 0.0002562497, 0.00023653146, -0.000116776726, 6.765186e-05, -9.535992e-05, -8.92955e-05, -7.28142e-05, -1.0704352e-05, 7.504371e-05, 9.333072e-05, -5.0304516e-05, 0.00017428354, -5.174787e-05, -0.00013677623, 9.876823e-05, -1.0831727e-06, 6.876492e-06, 2.5298035e-05, -4.8193946e-05, -3.4827746e-05, 3.3093846e-05, -3.6002642e-05, -5.752885e-05, -0.000109920264, -1.9618283e-05, -1.5947893e-05, 3.2156995e-06, -5.5580338e-05, -2.059219e-05, 8.4010266e-05, -6.3231295e-05, 0.00012711795, 8.4635314e-05, 0.0001413115, 0.000112296184, 5.3224245e-05, -1.9747346e-05, -1.3230396e-05, -0.00015042453, -0.00012555004, 6.63398e-05, 7.033077e-05, 8.598553e-06, -7.537737e-05, 6.8515845e-05, -9.685725e-05, 6.699886e-05, -5.3318978e-05, 2.3622757e-05, 1.6343049e-05, 4.8781596e-05, 0.0001549915, 4.4078737e-05, -1.1647081e-05, -3.8944665e-05, -2.5919098e-05, -2.3632158e-05, -4.7190242e-05, 6.90854e-06, 0.0002924129, 2.970108e-05, 0.00012414998, -2.0266094e-05, -9.436581e-06, -2.207244e-05, -0.00010115474, 2.9262072e-05, -0.00012557818, -1.4370131e-05, 9.2972194e-05, -0.00011981463, -0.00019752618, -6.8409216e-05, 3.381963e-05, 1.1951285e-05, -0.00014972969, 0.00014987336, -0.00014475232, 0.0001366671, -4.5521585e-05, -1.3699929e-05, -0.00011974825, -0.00012891968, -7.453787e-06, 7.247807e-05, -3.193269e-05, -0.00012980067, -0.00025058482, -8.5106796e-05, 7.5842305e-05, -2.8064538e-05, -3.057267e-05, 3.2905562e-05, 0.00012672835, -5.370045e-05, 0.00018527362, 0.00015863577, 0.00026849555, 0.00019949207, 0.000116977906, 2.878596e-05, -2.0327952e-05, -0.00037472896, -0.0001301515, 0.00012892263, 0.000103136896, -5.8404272e-05, -0.00016547719, 0.00018460644, 3.19578e-05, -9.384909e-05, -7.92176e-05, 6.893691e-05, -3.9845876e-05, 2.6460848e-05, 5.7550224e-05, -6.7078574e-05, -3.2544147e-05, 8.2144e-05, 3.1555865e-05, 3.460351e-05, 0.00013792553, 7.879336e-05, 8.878817e-05, -2.33264e-05, 9.109647e-05, 9.219657e-05, -8.410727e-05, -9.838679e-05, -0.00016939642, -8.280169e-05, -8.285361e-05, 2.8865614e-05, 5.3704367e-05, 0.00011078797, -0.00012005164, -0.00011267534, 5.337758e-05, 3.051589e-05, -6.078697e-05, 4.7660757e-05, 6.9880094e-05, -1.4010227e-05, -1.5667796e-05, 0.0002571588, -0.00013052294, 1.5196156e-05, 4.498169e-05, 6.934362e-05, -7.906168e-05, -0.00014785647, 6.6198576e-05, 6.705088e-05, 0.000111493166, 9.8645454e-05, 4.578929e-05, -0.0002429055, 0.00020214068, 1.3498252e-05, 0.00012862282, -3.2220625e-05, 0.00015356696, -0.00019455938, -0.00020769355, -5.6355257e-05, 1.797826e-05, -4.7960104e-05, -0.00044751915, -0.00015343336, 0.00019830567, 7.604175e-07, 1.4549851e-05, 0.00019460541, -1.0849534e-05, 0.00016905351, -8.925512e-05, -0.00031241562, 9.545437e-05, -0.00034755125, -2.9243522e-05, -1.2122993e-05, 7.7974444e-05, 6.581513e-05, -0.0002867498, -0.00019924347, -2.7360038e-05, -0.00015103337, -0.00010860045, 0.00034931576, -0.00010590274, 2.618867e-05, 5.282903e-05, -1.5665713e-05, 0.00012300414, 0.00046764256, 0.00020864823, 0.00018775427, -4.914695e-05, -0.00033029274, 0.00019767118, 0.00030838064, -8.327137e-05, 4.9403905e-05, -0.0002045747, -1.5856083e-05, -2.48991e-05, -7.132351e-05, 9.618085e-05, 0.000226241, -0.00021148828, 6.0723534e-05, -7.4578296e-05, 9.259168e-05, -0.00010180592, -0.00016516719, 2.8792214e-05, 0.00014085832, 0.00012688106, 0.00013112318, -0.00016858678, -0.00028884714, 9.071087e-05, -7.3076386e-05, 0.00013565326, 0.00021040216, 0.00018890406, -0.00025701887, -3.5213197e-05, -0.00016741817, -4.3460062e-05, 1.4139902e-05, -0.0001657553, -6.303028e-05, 0.0002260065, -4.5967885e-05, 0.00014524304, 4.3184657e-05, 0.000102998776, -9.206859e-05, 8.937927e-06, 7.828173e-05, 6.3594474e-05, 9.4655305e-05, 2.9999204e-05, -9.712856e-05, 5.3333177e-05, 5.299225e-05, 0.00023573417, 7.6863515e-05, 3.1756317e-05, 7.954863e-05, 0.00010155852, -0.00016363719, -3.9762404e-06, 7.266045e-05, -0.00020963876, -0.00018958072, -0.00013646687, -0.00019968736, -0.00019760276, 0.00010261903, 1.5990528e-05, 0.0002364277, 1.4863605e-05, -0.00012737584, -8.322003e-05, 1.0948867e-05, 5.1844876e-05, -1.52260445e-05, 1.4784258e-05, 0.00013514746, 0.00022094676, -1.1899339e-05, -2.8427303e-05, -0.000136183, -7.776231e-05, 0.00011674898, 6.4425076e-05, -0.00016090598, -9.878622e-05, -9.3985276e-05, -0.0002592735, -7.5451615e-05, -0.00037765512, -9.705349e-06, -0.00021026038, -9.627459e-05, 0.00020343365, 0.00024413236, 0.00027841693, 0.00011474547, 0.00012329918, -0.00016633673, -0.000100024816, -0.00010993751, 0.00021347341, 0.00030886225, -1.7794953e-05, 4.423438e-05, 0.00014581585, -0.00019780183, 5.2960026e-05, -8.703921e-05, -8.529461e-05, 3.1738105e-05, 9.2924616e-05, 0.00013146883, 6.759646e-05, -5.423025e-05, 9.588059e-05, 0.00012302786, 0.00015872347, 2.642875e-05, -7.767356e-06, 3.5159872e-05, 0.0002447753, 5.347681e-05, -1.7516997e-05, 0.000101120655, -0.00025561135, -0.00023603854, -0.00027895876, -7.2394476e-05, -0.00014578163, 3.563025e-05, 8.7253684e-05, 0.00025737545, -1.2989292e-05, -0.00015245675, -0.00012747964, 1.8345603e-06, -5.7923626e-05, -5.8929236e-06, 6.5469353e-06, 9.083497e-06, 5.3409887e-05, -8.971755e-05, -5.237488e-05, -4.2515956e-05, -4.93085e-05, 1.61045e-05, 7.4440726e-07, 7.193773e-06, -0.00012382216, -4.6046833e-05, -8.53477e-06, -4.2209616e-05, -0.00015973204, 0.00011227375, -8.075709e-05, -1.4646478e-05, 7.2529433e-06, 0.00010680005, 9.472708e-05, 9.956056e-05, 0.00013306437, -3.668044e-05, -6.5873086e-05, -6.232837e-05, 0.00018003439, 0.00013959673, 2.0868245e-05, -6.814593e-05, 3.3209992e-06, -4.7888305e-05, -0.0002504423, 0.00027691261, 0.00016847547, 0.00033282329, -0.00012084831, 8.484497e-05, -6.283453e-05, 0.00037607274, -0.0001440336, -0.00049843465, 3.5011337e-05, 0.00019113427, -0.00014180824, 7.029805e-05, -0.000108188724, -0.0005046496, 0.00029339283, -0.00020401337, 0.00046951172, 0.0003038023, 0.0007269835, -0.00016199368, -0.00021270613, -0.00035355944, -2.1085565e-05, -0.0004277169, -0.00071001257, -0.00013872964, 0.00022625251, 4.6873674e-06, 0.00022556465, 0.00027529002, -7.8568904e-05, 9.139044e-05, -9.863638e-06, 0.00010089749, 8.3820654e-05, 9.3508505e-05, 0.00012676865, 1.3989682e-05, -2.4444995e-05, -5.938686e-05, 7.131762e-05, 4.0158004e-05, -8.804708e-05, 6.329579e-05, 0.00023356809, -8.91393e-05, 0.00010692903, 5.2130417e-05, -3.170661e-05, -0.00011806576, -1.8408924e-05, -3.166857e-05, -0.0002070344, -9.598819e-05, 8.548032e-05, 3.737191e-05, -0.00025821532, -0.00014490611, 7.743269e-06, 2.1203892e-05, -8.4009676e-05, 0.00010988047, -3.35253e-06, -2.6673797e-05, 0.00012259958, 0.000121214056, -0.000246657, -7.517607e-05, -0.00018088942, 7.57725e-05, -6.175322e-05, -0.00011763951, -7.525275e-05, 5.4063647e-05, 7.421774e-05, 3.492492e-05, -0.0003338734, -0.00015089959, -5.5906392e-05, -1.2432103e-05, 0.00023008685, 0.00021904163, 0.00040606485, -8.295221e-05, 0.00010757694, -0.00013027694, -0.0001715338, -0.0001446955, 7.215657e-05, 0.00013270552, 0.00017072089, -9.195458e-05, 0.00015282056, -1.2047169e-05, 7.53565e-05, -0.00011449426, -5.853498e-06, -0.0001802325, 2.7684942e-05, -1.5199263e-05, -0.00012447726, -7.298661e-05, 2.796467e-05, 0.0001541969, -9.479675e-06, 1.36101235e-05, 5.7003916e-05, -8.876784e-05, -0.00011254708, 0.0001324258, -0.0001577862, -4.4677865e-05, -0.00011894948, 8.775322e-05, -0.00018170316, -1.2716241e-05, 0.00018217058, 8.186213e-05, -4.8588037e-05, 0.00012764326, 0.0003634037, 0.00013324141, -6.232297e-05, -2.152987e-05, 9.0477806e-05, -0.00018248319, -0.00014921212, 0.00011861524, -6.476576e-05, 0.000109642104, -9.167819e-05, -2.5174631e-05, -1.5490557e-05, 0.000108519685, -0.00010885811, -0.00017850127, -0.00010499267, 8.119527e-05, 0.000100875135, -2.0441319e-05, 0.00013358895, -0.00011227979, 0.0002518475, -9.015593e-05, 0.00024512396, 6.8147456e-05, 0.0003253239, 2.460142e-05, -0.00011018654, -3.1102503e-05, -2.3288523e-05, -0.0003261704, -0.00034018548, -0.00012165743, 0.00020191098, -7.543982e-05, -7.971601e-05, 0.00029990528, -3.9368675e-05, 1.13324795e-05, 1.535614e-07, -7.199987e-05, 7.861694e-05, 1.6063761e-05, -2.2191689e-05, 1.4059388e-05, 4.047565e-05, 3.319436e-05, 5.8774443e-05, 1.9077977e-05, -8.8676585e-05, -7.9246e-05, 6.753331e-05, 5.790224e-05, -4.219236e-05, -2.182575e-05, -4.2193762e-05, -4.3105396e-05, -5.0230527e-05, 2.0446574e-05, -2.5776013e-05, 2.7643036e-05, -5.0519334e-06, 4.6982437e-05, 0.00011970428, -1.4885104e-05, -8.240313e-05, 2.8535906e-05, 3.7651796e-05, -4.9001315e-05, -2.1947499e-05, 2.475652e-05, -3.530311e-05, 6.172269e-06, -7.935357e-05, -3.7587442e-06, 5.5427652e-05, -3.3711817e-06, -0.00013428529, -6.238713e-05, -0.00012755686, -6.2774643e-07, 0.00011150533, 7.525462e-05, 3.317417e-05, 4.097736e-06, 0.0001032182, 1.0272808e-05, 8.160636e-05, 0.00012476, 9.5140786e-05, 2.5903351e-05, 2.5504523e-05, -1.2367067e-05, -3.534293e-06, -0.00018153433, -0.00017560658, 9.676217e-06, 9.536168e-05, -0.00010583444, -7.635881e-05, 0.00014199442}},
    {"bert.encoder.layer.4.intermediate.dense.bias_grad", {3.971268e-05, -0.0003183912, 0.00018829934, -8.2325234e-05, -0.00046368994, -0.0006620451, 6.955452e-05, 0.0001793739, 0.0007483624, 0.00020501204, 5.2718697e-05, -0.00015944128, 0.00021573243, -0.00077329896, -0.00023004483, -0.00060559536, 0.00035193306, -0.0002080493, -7.020537e-05, -8.9980036e-05, -0.00021313498, -0.00012576794, -2.0026084e-05, -0.00038778494, 0.00035417816, -0.00027445465, -1.9451254e-05, 7.589927e-05, 4.6890855e-05, 0.00016037415, -0.0009044859, -0.0003184378, -7.1597504e-05, 0.0004221845, -0.00042568278, 5.4231354e-05, -0.00010933586}},
    {"bert.encoder.layer.4.output.dense.weight_grad", {-2.2919787e-05, -4.868344e-05, -2.122833e-06, -2.6785994e-05, 0.00015830729, -8.9005705e-05, -3.605742e-05, 5.166508e-05, -6.820731e-05, -2.0167592e-05, -6.5262757e-06, -2.854551e-05, -3.5292254e-05, 9.9466315e-06, -8.7217304e-05, -6.467365e-05, 1.9447363e-05, 2.7681872e-06, 0.00013163037, 5.048838e-06, -9.147222e-05, 2.7815677e-05, -2.8181765e-05, -5.7870322e-05, -0.000119905126, -5.4000757e-05, 2.1513383e-06, 3.4322336e-05, 2.44459e-06, -3.167675e-05, -0.00012967999, -7.631947e-05, -7.53027e-06, 7.665999e-05, -0.00011014054, -2.8770462e-05, -1.3001172e-06, -8.135293e-06, -5.9495014e-05, -3.6780293e-05, 2.8221531e-05, 1.2146665e-05, 6.0696275e-05, -3.3866196e-05, -5.6025056e-06, 7.689049e-05, 7.393868e-05, 3.579098e-05, 6.215112e-05, 4.3109463e-05, 3.6042446e-05, 4.9265316e-05, -1.9986925e-05, 2.176868e-06, 1.0210374e-06, -7.537697e-05, 2.9638504e-05, 4.2895153e-05, 4.8543106e-06, -9.130169e-06, 5.415951e-05, 7.126517e-05, 1.0511252e-05, 3.583783e-05, -2.169949e-05, 2.0827298e-05, -1.5171628e-07, 9.893673e-05, -2.6380574e-05, -1.2633456e-05, 1.7402224e-05, 3.2924843e-05, -1.1504385e-06, 4.51621e-05, 0.00010611241, 0.00013753133, -1.4703888e-05, -0.00012709355, 0.00016585167, -8.270732e-05, -7.2918614e-05, 0.000120775774, -0.00016758019, -0.00012991685, -3.9637875e-06, -0.00025122327, -7.553833e-05, -0.00010524262, -0.00012278571, -0.00010136236, 3.3988563e-05, -0.00011557814, 9.144148e-06, -8.082929e-06, -2.3534443e-05, 6.916137e-05, -2.8328019e-05, -0.00021906297, -6.575826e-05, -6.661604e-06, -0.00034642548, -8.671297e-05, -0.0001932958, 4.4112203e-05, -0.00023762796, 0.00014721193, 4.006477e-05, -0.00014315777, -5.3267195e-06, 4.5614972e-05, -0.00012172272, 2.7532044e-06, 4.71415e-05, -8.034989e-05, -4.465934e-05, -3.9804483e-05, -3.64338e-05, 4.3118907e-05, -2.3930363e-05, -0.0001784394, -0.00013927247, 0.00015156485, -3.81612e-05, -9.508931e-05, -0.00012752478, -2.4716317e-05, -2.9931398e-05, -4.588857e-05, 0.0001319835, 4.1738844e-05, 2.7096114e-05, -9.5821895e-05, 6.089485e-06, -2.1918491e-05, -8.475981e-05, -9.955859e-05, -6.548502e-05, 2.7904012e-05, 0.0001984069, 7.703238e-05, -0.00016719126, -0.00016966317, 0.00015687419, -0.00010350461, 5.199282e-05, 5.0308274e-05, -0.00014835408, -6.484564e-05, 7.142059e-05, -0.00018847769, -3.861864e-05, 3.3237506e-05, 0.0003104062, 0.00010155449, -5.6494926e-05, 3.1036103e-05, 4.39056e-05, 2.9590428e-05, 0.00024340987, 0.00037076286, 4.6787016e-05, -1.6049229e-05, 5.932341e-05, -0.00022864857, 5.367422e-05, 9.1929294e-05, -8.324978e-05, 7.453733e-05, -0.0001458774, 5.848934e-05, -4.4023185e-05, -9.914177e-06, 3.178911e-06, -7.646064e-05, 0.00022494435, -5.5727378e-05, -5.862149e-06, -4.155069e-07, 8.292332e-05, -5.9466263e-05, 6.3008396e-05, 0.000116056115, -3.34236e-05, -0.00012086643, 0.00016093603, -3.146939e-05, -0.00017331155, -8.7604356e-05, 4.576114e-05, -3.170562e-05, 0.00014416952, 6.73214e-06, -0.00013106721, 8.551016e-05, 5.5401008e-05, 0.000133572, 0.00025976487, 4.294644e-06, -1.7037832e-05, 0.00010666389, -4.6137273e-05, -4.3976725e-05, 0.00014588438, -0.00010825683, 5.62648e-05, -6.7167406e-05, 1.25632605e-05, -2.809223e-05, 0.00017428861, 5.7611203e-05, -4.640846e-05, 0.00034121584, 8.3311505e-05, 0.00012010529, -7.366918e-05, 0.00016139868, -9.19078e-05, -9.583676e-05, 0.00019345757, 3.7718324e-05, -0.00015632508, 9.983364e-05, 2.0454932e-05, 0.00013968181, -0.00021396167, -0.00017916075, -0.00020555269, -5.762121e-05, 9.128597e-05, -0.0002219618, -0.00021831218, -0.00016855552, 8.550946e-05, -0.00031390678, -0.00024279999, -0.00025602727, -6.013052e-05, -6.5106426e-05, -0.00013495167, 0.00024293129, 8.10921e-05, 7.116886e-05, -0.00017686698, -9.29548e-06, -3.0369207e-05, -3.335273e-05, -0.00022016373, -0.00012494264, 7.660101e-05, 0.0003844415, 8.510133e-05, -0.00032347947, -0.00036228634, 0.00023882749, -0.0002973311, 0.00014454202, 4.6510784e-05, -0.00018236534, -0.00010518073, 7.624535e-05, 1.7024797e-05, 0.00020143916, 0.00017167335, 5.612084e-05, 0.0001697226, -0.00012067014, 0.00011522304, 0.0003713503, 0.00023898354, -0.00023847313, 0.00020367047, 0.00029808324, 0.00027035948, 0.000220315, 9.349025e-05, 7.2692696e-05, -0.00039744566, -0.00031366962, -0.0001026974, 0.00045651715, -5.625398e-05, 0.00011339813, 3.5568388e-05, 0.00029493854, 0.00018282169, -0.00019724411, -0.00052915624, -0.00015856864, 0.00047352712, 0.0004657035, -0.00011065708, 0.00030523655, -0.00037612548, 6.993816e-05, 0.000313396, 0.000112828835, -9.176167e-05, -4.0704694e-05, 2.4936284e-05, 4.182942e-05, -0.00022162705, -2.5095205e-05, 7.2637554e-06, -8.771668e-05, 0.000101500205, 0.0001373493, -0.00022409257, -0.00013803635, 2.6574033e-05, 0.00015323765, -2.0168896e-05, 0.0001766851, -1.11590725e-05, -4.9077287e-05, 6.6957975e-05, -2.300563e-05, 0.00010866176, -3.7983045e-05, 3.6972975e-05, 0.00019249578, 8.461608e-05, 7.252706e-05, 1.1745907e-05, 2.7910015e-05, 5.5506614e-05, 2.1472171e-05, 0.0001287599, -0.00016211603, -4.8026548e-05, 3.5481145e-05, -3.2471224e-05, 0.0001240669, -3.0193118e-05, -1.3641565e-05, 0.00012389332, -1.8299104e-05, -3.3845983e-05, -9.0956106e-05, -8.431743e-05, 6.617154e-05, 2.3943065e-05, -6.879652e-05, -0.00017377277, -4.677516e-06, -0.00022639605, -7.536796e-05, -5.35587e-05, -6.843738e-05, 2.5131156e-05, 2.6920836e-06, 9.391371e-05, 0.00010822707, 1.4217668e-05, -6.74167e-05, -7.1870163e-06, 2.7166257e-05, -9.286552e-06, -4.6339035e-05, -1.9666677e-06, -8.652288e-05, 0.00012048951, -2.5220581e-06, -0.00017742133, -0.00017595087, 8.892599e-05, -3.98998e-05, -2.5392143e-07, 1.0416287e-05, -2.8286962e-05, -8.56201e-05, 0.00013123607, 9.890448e-05, -9.268864e-05, -0.00012086154, 0.00027013375, 3.461501e-05, -6.0557002e-05, 3.4491237e-05, -9.618284e-05, -0.000119041346, 0.00018765859, -6.9934365e-05, -8.362458e-05, -0.00018165843, 3.2148414e-06, -0.00021400719, -1.0962529e-05, 4.7358003e-06, -0.0001355208, 8.217845e-05, -4.7240956e-05, 4.9963255e-05, -5.552776e-05, -0.00023650247, -0.00011185024, -7.739417e-05, -0.00011868415, -2.215436e-05, -0.00010871724, -6.071414e-05, -0.00015006472, 0.00023105525, -7.018152e-05, -7.788453e-05, 5.313979e-05, -0.00011461867, -1.3791543e-05, -1.7516066e-05, -9.915897e-05, 7.955619e-05, 6.4069776e-05, 1.963994e-05, 5.2591102e-05, 1.7208753e-05, 3.1746993e-05, 6.0436534e-05, 2.578098e-05, 4.2927506e-05, 0.0002406731, 7.1723494e-05, 3.7885806e-05, 4.7731603e-05, 9.0027615e-06, 7.296337e-06, 1.4526125e-05, -2.6777929e-05, -3.1967968e-05, -3.803691e-05, 2.1721886e-05, 8.607708e-07, 7.695541e-05, 6.9509595e-05, 2.4928118e-05, 0.0001278743, -7.855235e-05, 1.7734484e-06, 7.580641e-05, 0.00012625165, -0.00012475692, 7.0970455e-05, 6.2421146e-05, -4.1727235e-06, -9.840772e-06, 8.607258e-05, 2.5138606e-05, -8.265039e-06, 5.7546687e-05, -1.8088916e-05, 6.861728e-05, -0.00013556913, 6.168557e-05, 0.00011820284, -0.00018304495, -0.00016616742, 0.000100329264, -1.0891799e-05, -8.369803e-05, -3.5861805e-05, -9.9135126e-05, 2.6732101e-05, 5.8921374e-05, 4.78738e-05, 0.00020879012, -8.4929365e-05, -0.0001771996, 3.3999095e-05, -7.1232785e-06, -0.00015278958, -6.132004e-05, -1.1732771e-05, -8.3165956e-05, 8.889104e-05, -6.8736285e-06, -5.9987084e-05, -0.00014783912, 4.459134e-07, 3.1138235e-05, 1.8775143e-05, -2.8264023e-05, -1.5735457e-05, -7.4357355e-05, -2.4749072e-05, 0.00014029775, -2.3870865e-05, -3.4511835e-05, 7.1557133e-06, -0.00013367398, 1.700134e-05, 9.298464e-05, -0.00014367893, -0.00013928826, -5.9390513e-05, -0.00024116701, -5.7692912e-05, -2.2685947e-05, -0.000111137444, 1.0146947e-05, -6.4616356e-06, -6.831291e-06, 0.00014131106, -2.3883807e-05, -2.0904896e-05, -1.9906804e-05, -4.6955415e-06, -9.074247e-05, -0.00010204438, -3.700199e-05, -0.0001842749, 0.000108677195, 3.3507335e-05, -0.00010516417, -0.00023404876, 0.0001215274, -3.3344946e-05, -3.7414335e-05, -1.3438012e-05, 7.4242957e-06, -9.178792e-05, -6.7572655e-05, 6.0282262e-05, -1.8134893e-05, 2.902338e-05, -0.00010159788, 5.9265698e-05, -5.365216e-05, -8.506965e-05, 0.00015592585, 0.00016445179, -0.00015438798, -0.00016787498, 5.924437e-05, 4.8522954e-05, 2.6000902e-05, 9.570796e-05, -6.206457e-05, -0.000111975525, -0.00014578266, 7.3579795e-05, 0.00021218859, -5.6063625e-05, -5.759154e-06, 7.017894e-05, 5.293176e-05, 6.0853436e-05, -7.497862e-05, -7.08561e-05, 1.4342239e-05, 7.7802586e-05, 0.0001694934, 1.3669377e-05, -8.047397e-05, -7.900246e-05, 2.3349152e-05, 9.1236056e-05, 1.1732389e-05, -1.7083288e-05, -0.00015239338, -1.2955e-05, 2.8212782e-05, -6.971866e-05, 2.1617083e-05, 1.520519e-05, -8.2351056e-05, 2.8286495e-05, 6.209052e-05, 2.512994e-06, 0.00021116465, 1.8893721e-05, 6.712988e-05, 4.3170243e-05, -2.8984889e-05, 5.686812e-06, 7.045581e-05, 5.375132e-05, -2.3619785e-05, -5.305956e-05, -2.001085e-05, 1.9794332e-05, 0.0001488909, 9.069184e-06, -3.4384586e-05, 0.00024440227, 5.7103935e-05, 7.082201e-05, -1.2524828e-05, 4.9887065e-05, -0.00014243064, 9.100744e-06, 0.00015971184, -4.4793807e-05, -4.2900287e-05, 8.756169e-05, -6.230574e-05, 0.00013815306, -5.9523776e-05, -7.4892494e-05, -0.00018462526, -0.000101073696, 3.5289333e-05, -2.3815595e-05, -0.00019411044, -8.961816e-05, -1.0032495e-05, -0.00030416134, -9.717746e-05, -8.265047e-05, -0.00013469114, 9.39136e-05, -5.5251774e-05, 4.3723114e-05, 0.00010065618, 3.6682683e-05, -6.450514e-05, -1.0524226e-05, -1.2472346e-05, -7.948586e-05, -9.816838e-05, -9.897549e-06, -0.00018090094, 0.00017176024, 9.90937e-06, -0.000117598436, -0.00023047502, 0.00017679279, -0.00011468517, -2.8406705e-06, 2.1286336e-05, 9.6512085e-06, -0.00012614159, 3.654576e-05, 7.835508e-07, 2.977918e-06, 3.4040022e-05, -0.00012385024, 0.0001369422, 4.5615234e-05, -0.00011641134, 0.00015501466, 0.000114292576, 2.4846952e-06, 0.00013715793, 6.823476e-05, 5.6560216e-06, 0.0001965592, 3.0346957e-05, -3.5955327e-05, -2.0959309e-05, -0.00020713295, -1.03817e-05, 0.00018167986, -2.9693138e-05, 4.784954e-05, 6.689074e-05, 7.11264e-05, 4.5283086e-05, 9.3747054e-05, -5.5858454e-05, 4.3351825e-05, 6.791872e-05, 0.00019400546, 3.1762458e-05, 2.3653176e-06, -0.00011189699, 8.869499e-05, -4.0949173e-05, 6.7181813e-06, -4.4678673e-05, -7.772423e-05, 2.2637147e-05, 2.16775e-05, -0.000112372574, 4.037955e-05, 0.00011162799, -9.259684e-05, 9.35305e-05, 3.22383e-06, 1.5643302e-05, 0.00017129697, -2.1840493e-05, -1.7148677e-05, 7.745567e-05, 4.6304185e-06, 3.1081431e-06, 0.00015169194, 5.164458e-05, -2.8254091e-05, -9.161073e-05, -1.1628095e-05, 4.446469e-06, 0.0001801258, 3.5407702e-05, -4.849228e-06, 0.00028801517, 7.949354e-05, 9.573212e-05, -0.00010375472, 8.257989e-05, -0.00014141781, -3.4726192e-05, 0.000140562, -9.656556e-06, -7.0930044e-05, 5.944964e-05, 5.839311e-05, -3.9456816e-05, 0.00010130527, 2.951094e-05, 0.0003083291, 7.9314515e-05, -0.00014271821, 0.00014292184, 6.18005e-05, 8.281295e-05, 6.568665e-05, 0.00017357322, 0.00011165516, 2.8235208e-05, 3.0001487e-05, -7.869204e-05, 3.4981185e-05, -0.00020980455, -0.00020893132, 2.560331e-05, 8.943788e-05, 6.106099e-05, -2.4742701e-05, -0.00015289192, 4.8742157e-05, 2.5533254e-05, -0.0001301346, -0.00032983348, -0.00016570232, 0.00027918053, 0.00015946521, 1.354874e-05, 0.00015669833, -0.00014576089, -8.393448e-06, 4.901725e-05, 7.554356e-05, -3.8685142e-05, 0.0002215604, -3.7581387e-05, -5.5903867e-05, -0.00020726267, -6.9864785e-05, 0.000104515224, -6.9362824e-05, -0.00013045217, -0.00012791684, 2.8014252e-05, -0.00028254243, -0.00010816994, -0.00012033383, -4.632602e-05, 4.5332992e-05, -5.6935765e-05, 9.843866e-05, 4.266083e-05, 5.3206953e-05, -2.4656683e-05, -3.894014e-05, -1.6303942e-05, -8.200319e-05, -5.0707815e-05, 7.063829e-06, -0.00013181566, 0.00019964357, 5.2265637e-05, -0.00020737665, -0.00016457103, 0.00027019242, -0.00014933557, -5.6355988e-05, 0.00011465149, -1.641851e-05, -8.148134e-05, -7.773572e-05, 0.00010899222, -6.704914e-05, 3.2718017e-05, -0.00040391504, 6.7257584e-05, 4.5692588e-05, -0.00022227355, 0.00020356782, 0.00015805438, -0.0003230825, -0.00029489424, 4.2067768e-05, 8.6703745e-05, 5.3987995e-05, 0.00024331242, -0.00010203366, -1.2804398e-05, -5.9265938e-05, 2.519698e-05, 0.00024155987, -0.000111656205, 9.053513e-05, 0.0002617755, 2.9431067e-05, 5.7380683e-05, 4.5346747e-05, 6.449555e-05, 8.239261e-05, 3.7070242e-06, 7.760333e-05, -3.2112664e-05, -7.398631e-05, -3.2232263e-05, 3.480719e-06, 9.240744e-05, -7.5987664e-05, -3.2600863e-05, -3.399387e-05, 6.354622e-06, 3.645284e-05, -1.5471582e-05, -6.8978305e-05, -2.6223815e-05, 5.3210715e-05, -7.878557e-05, -3.587037e-05, -1.8619066e-05, -4.4460157e-05, -2.7871986e-06, 5.93524e-05, -0.00010753982, 5.4090502e-05, 2.6635313e-05, 2.6705964e-05, 0.00013521333, -2.7668459e-05, -8.385051e-05, -1.7372424e-05, 4.421798e-06, 9.915213e-06, -2.3257915e-05, -2.7001565e-06, -7.1119375e-06, 5.3326185e-05, 1.5254215e-05, 1.4300288e-06, -5.282308e-05, -4.644806e-05, 1.1504229e-05, 7.167281e-05, -4.618569e-05, 4.8906448e-05, 1.3416993e-06, 8.2651513e-07, 0.00021165113, 0.00011397033, -3.078793e-05, 5.4552675e-05, -0.00021262153, 2.7041755e-05, 0.00018325177, -0.00020011447, -0.00020327313, -5.646194e-05, -0.00029583325, -4.294212e-05, 1.2401422e-05, -0.0001645233, 6.604698e-05, 6.31568e-05, -8.923236e-05, 0.00020303408, -7.6364326e-05, -4.524704e-05, -1.5627802e-05, 2.0805486e-05, -0.00023059288, -8.448872e-05, 1.7210963e-05, -0.00037145382, 3.4727045e-06, -8.6074644e-05, -1.8304258e-05, -0.00023303987, 0.00015492126, 5.7213307e-05, -0.00016927137, -8.371272e-06, 0.00013215642, -0.00010871611, 9.38514e-05, -0.00016898937, 3.4097648e-05, 3.6981008e-05, 0.00027969957, 4.863924e-05, -9.156399e-05, 6.838196e-05, 2.378229e-05, 5.4158216e-05, 9.321026e-05, 0.00033401084, 5.933674e-05, 5.539582e-05, 4.2258074e-05, -0.00015844262, 5.8504556e-05, -8.448931e-05, -7.008429e-05, -4.34653e-05, -4.1297488e-05, 3.6929636e-05, -3.2388853e-05, -5.439376e-05, 5.455728e-05, -3.6958125e-05, 0.00010463572, -0.00016220803, -6.487398e-05, 0.00017322174, 0.0001449663, -0.00010912306, 0.00010856945, 3.2973487e-05, -2.254151e-05, 1.0550571e-05, 0.00014075123, 5.5784043e-05, -0.00035205114, 0.0002408875, 0.00014430993, 0.00031478287, 9.1978065e-05, -0.00012633602, 0.00021244262, 0.0002185164, 0.00029825, -6.146056e-05, 0.00063640537, 0.00025388607, 0.00022578459, 8.542844e-05, -3.6572354e-05, 0.0001514034, -0.00025817912, -4.1583135e-05, -0.00016210866, 4.4525113e-05, 8.184816e-05, 1.10852895e-07, 5.4687473e-05, 0.00021310431, 9.650731e-05, 9.6379e-05, -0.0005016762, -0.00013604375, 0.0005080444, 0.00037205382, -0.00045032636, 0.00039877548, -3.4183573e-05, -0.00014419846, 0.00021018175, 0.0002112047, -4.978701e-05, 9.028723e-05, 5.0596795e-05, -4.7399513e-05, 9.591843e-06, -4.496991e-05, -1.948966e-05, 7.28711e-06, 0.00010129027, 7.0039925e-05, -0.00025435496, -0.00032839584, 2.4068568e-06, 5.3562188e-05, -0.000110351575, 0.00013627183, 1.6121206e-05, -0.00013862942, 6.204468e-05, 3.33444e-05, 6.3651016e-05, 7.833949e-06, 2.5255567e-05, -2.2825196e-05, -3.4239718e-05, 6.539042e-05, -0.00021218396, -0.00012120187, -0.00012452663, 9.065882e-05, -6.1135936e-05, -0.00011175153, 4.1473697e-05, -0.00010338378, -0.00012859903, 0.00015174213, -0.000120062556, -1.9946001e-05, -0.00018357633, -2.2496977e-05, 0.00010045325, 2.372045e-05, 0.00014113772, -4.2758533e-05, -6.336563e-05, 0.00020860817, 0.00015669267, 2.419427e-05, 0.00033983446, 0.0001333531, 0.00011646129, 0.00017031468, -4.477701e-05, -7.555664e-06, 2.1870266e-05, -0.00014088722, 1.6416001e-05, 9.19905e-05, -2.665124e-05, 3.1918327e-05, 0.00021755854, 9.525713e-05, -1.986288e-05, 0.0002970468, -6.4784326e-05, 9.446641e-05, 5.5621087e-05, 0.0002447541, -0.00016340564, 4.0087634e-05, 9.520555e-05, -2.3450466e-06, -5.7123365e-05, 0.00015761908, -5.6590117e-05, -0.00032840544, 0.00020499055, 0.00016731824, 6.677708e-05, 1.1951229e-05, -1.3796155e-06, 0.00013610258, 0.00014727804, 0.0002036274, -7.104033e-05, 0.00049845746, 0.00016000266, 0.00024545603, 1.4572207e-05, 0.000106447915, 0.0001367375, -7.937716e-05, 0.00014696088, -0.00014312261, -4.8789945e-05, 1.4903914e-05, 4.7049944e-06, 0.00016382338, 0.00018176813, 8.661123e-05, 0.00022378734, -0.00021491469, 1.7107988e-05, 0.00025524865, 0.00034261908, -0.00044275643, 0.0002720992, 0.00012458584, -0.00014480953, 0.00013442959, 0.0001439115, 7.069488e-05, 3.4764234e-05, -6.636952e-05, -7.809582e-07, -1.7762031e-05, 6.0983686e-05, 3.9836217e-05, -1.9008558e-06, -2.075407e-06, -7.3657706e-05, 0.000188004, 0.00011338498, -8.896616e-06, -6.6944755e-05, 0.00014175574, -7.8638965e-05, 1.4291011e-05, 8.52194e-05, -0.00010995896, 1.7172813e-06, 5.5362376e-05, -1.1372999e-05, 2.462249e-05, -5.3986256e-05, 1.8854185e-05, -2.0046942e-05, 4.948678e-05, 7.320742e-05, 4.0290306e-05, -0.00010242314, -2.4683106e-06, 0.00015806523, 1.3165461e-05, -7.200549e-05, 0.000117044554, -0.00014426862, -3.0384035e-05, -2.8786012e-06, 0.0001460419, 1.821362e-05, -1.50280775e-05, -2.7691274e-06, -3.778345e-05, -2.2058223e-06, 2.9048053e-05, -9.016572e-05, -0.00011486822, 7.392958e-05, -0.00015234464, -2.8275806e-05, -6.799633e-05, -1.9761888e-05, -7.721462e-06, -4.816884e-05, -1.0435615e-05, -7.619966e-05, 6.501713e-05, 4.4699736e-05, -6.4557935e-06, -1.6727108e-07, -0.00012798875, -5.365867e-05, 9.993295e-06, -0.00014794181, 2.6121987e-05, -1.6038603e-05, -6.3750085e-05, -5.6222205e-05, 0.00022501539, -7.221578e-05, -9.109711e-05, 7.6426135e-05, -4.420716e-05, -3.3811106e-05, -6.940018e-05, 0.00023769592, -0.0002663987, -0.00023568976, -0.00029684184, -0.00014310004, 0.00015160066, -0.00022528955, -0.00031724822, -0.00022735138, 1.21211615e-05, -0.0005635392, -0.00034046, -0.00034141255, -0.00019109622, -1.3606743e-05, -0.0001401496, 0.00030914685, 0.0002178207, 9.863692e-05, -0.00022861245, -6.114906e-07, -0.0001036392, -8.865335e-06, -0.00021990821, -0.00013186136, -1.8282666e-05, 0.00054026063, 0.00013686651, -0.00050214876, -0.00049350463, 0.0002625406, -0.00038775924, 0.00019136684, 4.124133e-05, -0.00019766988, -0.00023528318}},
    {"bert.encoder.layer.4.output.dense.bias_grad", {-0.0014097014, 0.0016142498, -0.00060213264, -0.004887355, 0.0031705773, 0.00019591456, -0.011665357, 0.014772725, -9.7525626e-05, -0.0046521295, -0.001233454, 0.0029370196, -0.0023443394, -0.0037296184, 0.0014163338, 1.1423341e-05, -0.0064603817, 0.0027408984, -0.0011224517, 0.007831907, -0.006554978, -0.0016036747, -0.0014143091, -0.0027025447, 0.0057701278, 0.015341489, 0.00040161135, 0.0045851264, 0.008298751, -0.00034115318, -0.0022919301, -0.015975112}},
    {"bert.encoder.layer.4.output.LayerNorm.weight_grad", {-0.0016636298, -0.0017956732, 0.0011897505, 0.0016964382, 0.004395872, 0.002538849, -2.8132403e-05, -0.0010900225, -0.0021263235, -0.0015880641, 0.0013802408, -0.0006551773, -0.0015175769, -0.0005366099, -0.0026983093, 0.000312277, 0.0017628563, 0.0001802572, -0.0036156273, -0.00031796139, 0.0046372777, -0.0042544096, 0.00027275452, -0.0013412077, 0.0010101552, 0.0037942678, 0.0011435533, -0.0015982467, -0.0025227673, 0.0018077133, 0.00037045465, 0.0067634303}},
    {"bert.encoder.layer.4.output.LayerNorm.bias_grad", {-0.00018227333, 0.0027646157, 0.00068579265, -0.0038696884, 0.004644617, 0.0015334031, -0.0105244825, 0.015918255, 0.0010619778, -0.0033772758, 3.6613827e-05, 0.004137489, -0.0014489606, -0.002586405, 0.0025998594, 0.0012264462, -0.005503917, 0.003954313, 7.708013e-05, 0.008887052, -0.005481869, -0.00045382377, -0.00033171396, -0.0016352584, 0.007045505, 0.016644454, 0.0016898024, 0.0059572225, 0.00934, 0.0008415014, -0.0009700139, -0.015050629}},
    {"bert.pooler.dense.weight_grad", {0.0074455864, -0.00097453524, 0.010463882, -0.0017308531, 0.013194946, 0.004451539, -0.0051774206, 0.0010439722, 0.009489369, -0.0010499542, 0.014562957, -0.00067058566, -0.022622721, -0.0048447032, -0.013739071, -0.0020931805, -0.01880976, -0.0023733755, -0.0057656034, -0.0059609297, -0.0054644328, -0.0017193323, -0.0013126687, -0.0037605257, 0.0003474365, 0.022239953, 0.024384465, 0.00947423, -0.015196208, 0.0046808627, 0.011233512, -0.019746846, 0.004519814, -0.00078817067, 0.0065193796, -0.0011501575, 0.007934373, 0.002667879, -0.0030635153, 0.00058122707, 0.005718145, -0.0005275926, 0.008691331, -0.0005092643, -0.013362115, -0.0029501577, -0.008163567, -0.0013445477, -0.011632726, -0.0010408638, -0.0033954266, -0.003920583, -0.0033454124, -0.0009639464, -0.00088615145, -0.0024125832, 0.0003058794, 0.013488756, 0.014821542, 0.005793042, -0.009256753, 0.0028685723, 0.006768448, -0.011964851, -0.0044217897, 0.0007354906, -0.0064272727, 0.0011212793, -0.007835022, -0.0026396185, 0.0030020708, -0.0005641451, -0.0056294785, 0.00056724285, -0.008601387, 0.00048832735, 0.013269479, 0.0029021008, 0.008124207, 0.0012785849, 0.011426123, 0.0011296871, 0.0034016888, 0.0037572673, 0.0033102513, 0.0009962453, 0.0008112472, 0.0023702262, -0.0002719159, -0.013395937, -0.014652306, -0.0057397475, 0.009151507, -0.002840067, -0.0066570453, 0.011832702, 0.0029608207, -0.0005109234, 0.0043173586, -0.00086487737, 0.005347332, 0.0017849369, -0.0020480605, 0.00027855422, 0.0038340245, -0.00033985666, 0.005851621, -0.00026728434, -0.008968839, -0.0020337696, -0.0054661166, -0.0009277888, -0.007762576, -0.0007637548, -0.0022148937, -0.0025233226, -0.0022266551, -0.0006909765, -0.00055359874, -0.001536658, 0.00021512872, 0.009040036, 0.009972605, 0.0038696486, -0.0061648064, 0.0018527645, 0.004613338, -0.008073409, 0.0019148871, -0.00033544234, 0.0028230182, -0.0005743352, 0.0034794125, 0.0012026462, -0.0013244428, 0.00020003448, 0.002504348, -0.00022640005, 0.0037998487, -0.0002095781, -0.005855178, -0.0013060076, -0.0035738635, -0.0005334122, -0.0050473236, -0.00051552197, -0.0014897754, -0.0016442158, -0.0014567783, -0.00045924587, -0.00034074704, -0.0010573249, 0.00014225119, 0.00594774, 0.006480082, 0.0025335036, -0.004030562, 0.0012539426, 0.002970358, -0.0052719177, -0.0027663843, 0.00050726184, -0.0039913054, 0.00075446506, -0.004854624, -0.0016415758, 0.0018934801, -0.00025651697, -0.0035344618, 0.00032581095, -0.0053551584, 0.0002735461, 0.008240379, 0.0018900399, 0.004982253, 0.0008006228, 0.0071372325, 0.00063350657, 0.0020492997, 0.002364608, 0.002052108, 0.0005813177, 0.0005481112, 0.0014848564, -0.00019736272, -0.008315979, -0.009188126, -0.0035430507, 0.005665252, -0.0017126846, -0.004228525, 0.0074016005, -0.00067515275, 0.000112107584, -0.0009883161, 0.00018939201, -0.0012018628, -0.0004049566, 0.00045398826, -8.2288505e-05, -0.0008593388, 8.06822e-05, -0.0013174353, 7.302052e-05, 0.0020244813, 0.00043895206, 0.0012406618, 0.00020375272, 0.0017556348, 0.00016887666, 0.0005120222, 0.0005799501, 0.00050464255, 0.00015770762, 0.0001222982, 0.00035889228, -4.677875e-05, -0.0020449404, -0.0022358948, -0.0008800603, 0.0013990134, -0.00042743402, -0.0010291099, 0.0018174927, 0.008115764, -0.0014376894, 0.011727388, -0.0023617856, 0.014350647, 0.0048010526, -0.0054570413, 0.0007228284, 0.010264582, -0.0009824636, 0.015801748, -0.0006687106, -0.024482349, -0.0055603883, -0.014563853, -0.0022045868, -0.020965958, -0.0020833015, -0.0060144984, -0.0068634534, -0.006038039, -0.0017537987, -0.0015060309, -0.0043842243, 0.0005740688, 0.024533175, 0.027134284, 0.010356568, -0.016696177, 0.0050074058, 0.012464588, -0.021829741, -0.0026506078, 0.00037842256, -0.0037161135, 0.0008940224, -0.004731744, -0.001734502, 0.0018198411, -0.00020211092, -0.0033544167, 0.00017224325, -0.0051378314, 0.00025310577, 0.007903757, 0.0017099469, 0.004669239, 0.0008381134, 0.006694367, 0.0006989718, 0.001847268, 0.0023004203, 0.001847121, 0.0006496124, 0.00063229806, 0.001346303, -0.0001916947, -0.007662305, -0.008424659, -0.0034078234, 0.005259488, -0.0015488751, -0.004195396, 0.0070435368, 0.0046941903, -0.0008557528, 0.006570574, -0.0014728727, 0.008224913, 0.0027119264, -0.003044348, 0.0007149819, 0.0060792062, -0.0006185338, 0.008875374, -0.00044906096, -0.013751092, -0.0031772847, -0.008349423, -0.0013333489, -0.012016137, -0.0010191067, -0.0034991852, -0.0039141383, -0.0033844041, -0.00091856247, -0.0010290657, -0.0025746694, 0.00041227715, 0.0136936195, 0.015414312, 0.0058714394, -0.009590014, 0.002958344, 0.007220472, -0.012444631, -0.0071013873, 0.0012509918, -0.010374011, 0.0020314201, -0.012843775, -0.0041463897, 0.004801456, -0.000802351, -0.009012025, 0.00078347, -0.013989678, 0.0006502494, 0.021418924, 0.004621984, 0.012994686, 0.0020865167, 0.018728798, 0.0017128702, 0.0054656053, 0.0062578344, 0.005424234, 0.0016236694, 0.0010660139, 0.003661789, -0.0005493337, -0.021778231, -0.023765637, -0.00912449, 0.014909097, -0.004506056, -0.010740659, 0.01924441, 0.0046828757, -0.0008685012, 0.006775397, -0.0012487287, 0.008381562, 0.0027880166, -0.003280178, 0.0005506217, 0.006137246, -0.0005332739, 0.009220543, -0.00054976187, -0.014052134, -0.0030815646, -0.008667956, -0.0013385487, -0.012263877, -0.001175051, -0.0036470452, -0.0041148565, -0.0035808636, -0.001028151, -0.0007582388, -0.0024080581, 0.0003410162, 0.014345835, 0.015667854, 0.006023732, -0.00975727, 0.0030446325, 0.0070471554, -0.012652428, -0.00018207404, 3.314636e-05, -0.0002637443, 5.2565076e-05, -0.00032674658, -0.00010920609, 0.00012329777, -2.2777233e-05, -0.00023570977, 2.3282066e-05, -0.0003543853, 1.904623e-05, 0.0005475777, 0.00012405725, 0.00033311796, 5.0176364e-05, 0.0004754786, 4.4006632e-05, 0.00014017306, 0.00015597006, 0.00013700139, 3.9229806e-05, 3.4117842e-05, 0.000100439735, -1.458188e-05, -0.0005542461, -0.0006098066, -0.00023609346, 0.00038014425, -0.00011845192, -0.0002777141, 0.0004927093, 0.0028373094, -0.00046464958, 0.0041796165, -0.0007960197, 0.0051123668, 0.0017300344, -0.0019576494, 0.00035369993, 0.0036427134, -0.00035654398, 0.0056023365, -0.00029431, -0.008633984, -0.0018887523, -0.0052784765, -0.0008050437, -0.007441745, -0.0007851548, -0.0021883694, -0.0024269333, -0.002152618, -0.00066959596, -0.0004665601, -0.0015439135, 0.00021173446, 0.008747118, 0.009513787, 0.0037115375, -0.0059383367, 0.0018389878, 0.00433929, -0.0077318726, -0.006631232, 0.0011760009, -0.00932579, 0.0016777887, -0.011557961, -0.004058506, 0.0047249147, -0.00060217734, -0.008624705, 0.0006739291, -0.012857721, 0.00082210574, 0.019622624, 0.004301571, 0.0119541995, 0.0018249361, 0.016858783, 0.0015480949, 0.00502751, 0.005773944, 0.004891039, 0.0013824952, 0.0012402567, 0.0033652913, -0.0004392144, -0.019746974, -0.021499405, -0.008382478, 0.013370169, -0.0040997257, -0.009951672, 0.01754191, 0.0032602812, -0.00057479367, 0.004859353, -0.0010079755, 0.006054106, 0.0021069688, -0.0022730574, 0.00036602927, 0.004304137, -0.000384638, 0.0065258723, -0.0003514556, -0.010096188, -0.0022957707, -0.0061644036, -0.000909738, -0.008712003, -0.0009173314, -0.0025787358, -0.0028044276, -0.002504553, -0.0008117141, -0.0006061166, -0.0018720917, 0.0002504141, 0.010287709, 0.011210646, 0.0043897154, -0.006976964, 0.0022194802, 0.0051157423, -0.009108496, -0.0049164137, 0.0009288323, -0.007133906, 0.0014999652, -0.0087435935, -0.0030414881, 0.0033380908, -0.00046583195, -0.0063709724, 0.00064769253, -0.009534498, 0.00046852912, 0.0148432795, 0.0034778868, 0.008910694, 0.0011926227, 0.012847504, 0.0010061483, 0.003847586, 0.004121611, 0.0036776199, 0.0010311619, 0.0009160434, 0.002920453, -0.00043755423, -0.015127652, -0.0165426, -0.0063212235, 0.010292863, -0.0031448063, -0.007640773, 0.013452732, -0.0025787018, 0.0003675207, -0.003749477, 0.0007261976, -0.004586073, -0.0015329072, 0.0017426048, -0.00048970117, -0.0032342167, 0.00040050363, -0.004966747, 0.00026656437, 0.007752956, 0.001677862, 0.0047228667, 0.0006709929, 0.0066499664, 0.0007421823, 0.0019474991, 0.0021614453, 0.0019087661, 0.0005524588, 0.00042713495, 0.0014770248, -0.00025375324, -0.0077353637, -0.008401178, -0.0033278377, 0.0053145685, -0.0016763214, -0.0038662043, 0.006889363, 0.003751865, -0.0005507301, 0.005379251, -0.0009129918, 0.0067169485, 0.002354547, -0.0026085, 0.00051628484, 0.004631314, -0.00033510075, 0.007221556, -0.00036661868, -0.011175067, -0.0024448875, -0.0067270463, -0.0011826194, -0.009646144, -0.00089611916, -0.0028164547, -0.0032770324, -0.0027094057, -0.00087039085, -0.00081261375, -0.0020578497, 0.0002310195, 0.011144842, 0.0121567, 0.004799506, -0.007677405, 0.0024070311, 0.005676817, -0.009920703, -0.00072680257, 0.00013291005, -0.0010570784, 0.00015702304, -0.0012475217, -0.00040702676, 0.00047125167, -8.481478e-05, -0.00090630795, 0.00010501477, -0.0013814613, 0.0001009407, 0.0021287783, 0.00046331738, 0.0013087956, 0.0002180315, 0.0018327892, 0.00016837542, 0.0005331062, 0.00062588527, 0.00054140703, 0.00014692973, 0.00015681826, 0.00037230435, -3.2710566e-05, -0.0021396403, -0.0023617276, -0.0009638978, 0.0014688243, -0.00045419793, -0.0010495378, 0.0018802227, 0.00037111217, -6.250682e-05, 0.00055167265, -0.000104150575, 0.00067496503, 0.00022509629, -0.00026058516, 4.792103e-05, 0.0004815246, -5.240856e-05, 0.000736257, -3.799716e-05, -0.0011365125, -0.0002590343, -0.0006974616, -0.00010734004, -0.0009797927, -0.000109251596, -0.000280677, -0.0003153692, -0.00028435406, -8.4904845e-05, -6.466665e-05, -0.00020505278, 3.1292027e-05, 0.001151187, 0.0012598931, 0.00049484137, -0.00078009994, 0.00024403233, 0.000570803, -0.0010184321, -0.005958134, 0.0010292165, -0.008368805, 0.0016305163, -0.010403555, -0.003496666, 0.004065892, -0.0006537463, -0.007679913, 0.0007803633, -0.011439896, 0.0006451793, 0.017638177, 0.003980505, 0.010674889, 0.0016704471, 0.015062815, 0.0014825112, 0.004357834, 0.0050119977, 0.0043503153, 0.0011865371, 0.0012315023, 0.0030566917, -0.00044234545, -0.017476404, -0.01936314, -0.007624569, 0.011990296, -0.003637051, -0.008999874, 0.015698412, -0.0024549766, 0.00040843672, -0.0035828326, 0.00066659425, -0.0043631378, -0.0014533115, 0.0016249075, -0.00031679618, -0.003087923, 0.00030224456, -0.0047552167, 0.00027348497, 0.0073319823, 0.0015796764, 0.0044716736, 0.0007316535, 0.00634692, 0.00060608337, 0.0018505978, 0.0021217142, 0.0018300968, 0.0005574649, 0.00046242212, 0.0013044055, -0.00016463053, -0.0073763444, -0.008072803, -0.003210257, 0.005069483, -0.0015589597, -0.003688034, 0.0065453826, -0.0034174183, 0.00061090797, -0.005111391, 0.00096960855, -0.006312169, -0.0021334917, 0.0024283393, -0.0003464855, -0.0045215334, 0.00040708488, -0.006907451, 0.00034573898, 0.01060089, 0.0024087126, 0.0065205605, 0.001015203, 0.009153413, 0.0010260388, 0.0026814477, 0.0029340994, 0.002663385, 0.000852432, 0.00057634787, 0.0018502414, -0.00022573871, -0.01084369, -0.011869433, -0.0045696734, 0.0073072133, -0.0022968354, -0.005334612, 0.009538258, 0.0018731398, -0.00033525555, 0.002692091, -0.0005417727, 0.0033092524, 0.001113657, -0.0012843219, 0.00021774578, 0.0023972895, -0.00022340477, 0.0036201228, -0.00017656162, -0.005585333, -0.0012858628, -0.0033679605, -0.0005321621, -0.00484343, -0.00046142976, -0.0013756653, -0.0016040731, -0.0013833181, -0.00038770546, -0.00037042773, -0.0010222866, 0.00015671329, 0.005607828, 0.00621391, 0.0023840999, -0.0038360243, 0.0011761899, 0.0028723194, -0.005017365, -0.00206616, 0.00038147354, -0.0030138427, 0.00043214587, -0.0034961717, -0.0012348347, 0.0014300771, -0.00015288297, -0.0025415902, 0.00023378662, -0.00392786, 0.00021272458, 0.006069788, 0.0014153107, 0.0036524492, 0.0005934908, 0.005265448, 0.0003735795, 0.0015293125, 0.0017627071, 0.0015120804, 0.0004156634, 0.00043855316, 0.0011825551, -0.00010909062, -0.006201455, -0.0067955856, -0.0026108713, 0.0041787336, -0.0012593585, -0.003104988, 0.005434813, 0.0061386493, -0.0009933084, 0.009079412, -0.0019946157, 0.011275561, 0.0038450237, -0.0041205594, 0.00077651266, 0.0077877454, -0.0005987322, 0.01210623, -0.0006337886, -0.018642405, -0.0039911307, -0.01127787, -0.0018518432, -0.016214369, -0.0016563339, -0.0046179565, -0.005459575, -0.00460288, -0.0015340679, -0.0011182987, -0.0033412923, 0.00051272527, 0.018756438, 0.020408757, 0.008120287, -0.012865457, 0.0039829314, 0.009485954, -0.01676174, 0.0005911151, -9.00764e-05, 0.0008780564, -0.00018012931, 0.0010554462, 0.0003657129, -0.000385216, 7.471515e-05, 0.0007109782, -6.285292e-05, 0.0011416238, -4.7809994e-05, -0.0017878987, -0.00038893154, -0.0010516745, -0.00016245432, -0.0015379782, -0.00015427623, -0.00043487395, -0.0005128067, -0.0004328669, -0.00014110435, -0.000112436675, -0.00035001631, 4.5640354e-05, 0.0017889059, 0.0019497306, 0.00076248846, -0.0012230605, 0.0003747601, 0.00090700755, -0.0015897172, -0.006357738, 0.0011074374, -0.0092472015, 0.0018141014, -0.011364642, -0.0038082595, 0.00431862, -0.00072427, -0.008119415, 0.0007685611, -0.012414682, 0.0006590342, 0.019125454, 0.0042153867, 0.011597081, 0.0017772245, 0.016554408, 0.0015703266, 0.004834825, 0.0054985606, 0.004782288, 0.0014091857, 0.0011096172, 0.0034172037, -0.0004961152, -0.019325199, -0.021111527, -0.0082376115, 0.0131911, -0.0040387292, -0.009650594, 0.017145569, -0.0014234977, 0.000233404, -0.0020266273, 0.0004054072, -0.002563884, -0.0008788753, 0.0009988841, -0.00014118961, -0.0018285508, 0.0001465364, -0.0027782235, 0.00013244097, 0.004273095, 0.00096924475, 0.0025755032, 0.00043746262, 0.0036747213, 0.0003511126, 0.0010500571, 0.0012230166, 0.0010435143, 0.00031772902, 0.00029667618, 0.0007412453, -0.000108523935, -0.0042525884, -0.004680943, -0.0018405328, 0.0029144718, -0.0008827841, -0.0022015998, 0.0038232948, 0.0012405008, -0.0002256104, 0.0018004314, -0.00037034194, 0.0022429305, 0.000755559, -0.0008631889, 0.00015166457, 0.0016248998, -0.00013920764, 0.002435082, -0.00012692786, -0.0037362669, -0.0008562793, -0.0022846952, -0.00037059264, -0.003261275, -0.00032132224, -0.00093541085, -0.0010756861, -0.0009322873, -0.0002762731, -0.00024060131, -0.0006698061, 0.00010291136, 0.003779393, 0.0041779885, 0.0016084097, -0.002585762, 0.00080803013, 0.0019210124, -0.0033772788, 0.0021653986, -0.0003465774, 0.0031675852, -0.00060042914, 0.0038663996, 0.0013168751, -0.0014998803, 0.00028184755, 0.0026803594, -0.00026819122, 0.004199481, -0.00018269196, -0.0065468303, -0.0014795398, -0.003890797, -0.00056828884, -0.0056304433, -0.0005686735, -0.0016042789, -0.001865672, -0.0016090404, -0.00046213728, -0.00038275996, -0.0012562237, 0.00019782249, 0.0065761157, 0.0071602035, 0.0027734276, -0.0044687465, 0.0013820352, 0.0032872804, -0.005823629}},
    {"bert.pooler.dense.bias_grad", {0.013973449, 0.008479333, -0.008379813, 0.005637888, 0.003688442, -0.005203991, -0.0012790429, 0.015308755, -0.004870533, 0.008665167, -0.013537612, 0.008925643, -0.00034608683, 0.005437987, -0.012383344, 0.0063597583, -0.009371899, -0.0048666913, 0.0070284903, -0.0013575824, 0.0007165274, -0.011055926, -0.004633795, -0.0066838297, 0.0035173506, -0.003871594, 0.011722724, 0.0011182778, -0.012064764, -0.0026747305, 0.0023604801, 0.0041078716}},
    {"cls.predictions.bias_grad", {-0.27560568, -0.3416083, -0.3529165, 0.0098963315, 0.010343531, 0.010000101, 0.010051059, 0.010289837, 0.0102571715, 0.009753555, 0.010251506, 0.009949713, 0.009970938, 0.009632777, 0.010436248, 0.010696312, 0.010756706, 0.010088428, 0.0101112025, 0.010150485, 0.010156348, 0.00952212, 0.010129985, 0.009760095, 0.009749677, 0.010386011, 0.00997542, 0.00943077, 0.010487673, 0.009891956, 0.010154407, 0.010466991, 0.009650099, 0.0102189025, 0.010463716, 0.009700446, 0.010538415, 0.009944881, 0.010337617, 0.010585849, 0.009438956, 0.010243081, 0.01057352, 0.0097215455, 0.00944574, 0.010461903, 0.009768127, 0.009613373, 0.010881185, 0.009707543, 0.0101779, 0.010399274, 0.010162983, 0.010052574, 0.010320227, 0.010376239, 0.010193899, 0.010020694, 0.010562242, 0.010237128, 0.009879805, 0.009324153, 0.009900024, 0.010093542, 0.010144557, 0.010308593, 0.009940605, 0.009741472, 0.010032964, 0.010176384, 0.010201734, 0.010382718, 0.010458223, 0.009811132, 0.01045942, 0.009609348, 0.010024986, 0.010390944, 0.010070957, 0.010337648, 0.009860872, 0.0098887235, 0.010324559, 0.009619089, 0.0109148845, 0.010140003, 0.010222417, 0.010270428, 0.00981385, 0.010021102, 0.010243353, 0.009754157, 0.010264138, 0.010292856, 0.010062652, 0.0101404, 0.01000926, 0.010273247, 0.010179793}},
    {"cls.predictions.transform.dense.weight_grad", {-0.005763962, 0.020323379, 0.007679147, 0.017281609, -0.015075564, 0.0024140158, 0.0027550096, 0.012155598, 0.005758574, -0.015942642, -0.008035047, -0.005001794, -0.0055802693, 0.010389476, -0.0041456386, -0.017298475, 0.0054974407, -0.003678841, 0.021362364, 0.0123446025, 0.026261298, -0.0015539748, -0.011415985, -0.019573413, 0.0021504457, -0.02502823, -0.038999446, -0.005369011, 0.010114154, 0.0055106254, 0.0030066543, 0.01745791, 0.01663275, -0.013820366, 0.012042959, -0.002748278, -0.035082977, -0.014224678, -0.019386373, 0.0048254025, 0.0021328845, 0.0024340788, -0.021449653, -0.008773303, 0.016842829, 0.008946716, -0.05296351, 0.0011163504, -0.018980384, -0.0042047175, 0.010438541, 0.03404704, 0.01621735, 0.00091414806, 0.034811407, -0.0036366056, -0.009182234, -0.010275496, 0.029253082, 0.025577182, 0.009099339, -0.008443052, 0.012107654, -0.014268073, -0.028083488, 0.0026927888, 0.00296127, 0.052780494, -0.010410967, 0.035197, 0.021593584, 0.0065045813, -0.020187221, -0.025677595, 0.027621271, 0.03377544, -0.00020637058, 0.023541784, 0.0409184, -0.052822817, 0.053476013, 0.010473641, 0.011464055, -0.0129467845, 0.020216575, -0.042787604, -0.064213604, -0.04060285, 0.005665467, 0.012076722, -0.0799731, -0.051282916, 0.033027086, -0.0042344406, 0.004078256, 0.03536537, -0.00029359487, 0.004114649, 0.0020565984, -0.0031963133, -0.0017969345, -0.011863491, -0.0074208216, 0.008892529, 0.0023905544, -0.009046026, -0.005806536, 0.004244059, 0.0040980657, -0.00872288, -0.0069454773, 0.000489647, -0.0008822398, -0.009846739, 0.0076587386, 0.008742423, 0.019983318, 0.0022489051, 0.005966553, -0.0014263703, -0.0046124826, -0.010399564, -0.001648916, 0.00026891753, 0.00486, 0.002319358, 0.0066527775, -0.0010787068, -0.015031648, 0.0022058596, -0.00489225, 0.007840973, 0.0071171406, 0.014385927, 0.013844949, -0.0011245747, 0.0015836926, -0.0031948863, 0.019323144, 0.0071317796, -0.0046437746, 0.0029845885, 0.032897647, -0.0070719477, 0.020934246, 0.0037302307, -0.008482415, -0.022867128, -0.009954168, -0.0064727617, -0.027858092, 0.0018338001, 0.0113759935, 0.009333243, -0.025118392, -0.025108786, -0.002247151, -0.00089157344, -0.007232342, 0.015668651, -0.028646238, 0.020456435, -0.0014228373, 0.02854123, 0.018934868, 0.019736666, 0.03003141, 0.0064873965, -0.012881419, -0.019434132, 0.027177311, 0.012661636, -0.027333545, 0.011145866, 0.05268349, -0.029036175, 0.038866006, 0.004503812, -0.003836502, -0.024490645, 0.0037773717, -0.013275807, -0.052326206, -0.009146448, 0.01630368, 0.00029155734, -0.060663216, -0.03885314, 0.0031737757, 0.011544727, -0.012361572, 0.02739064, -0.014129034, 0.024772989, -0.0028673164, 0.011200073, 0.012838964, -0.0058964025, 0.01293113, 0.010867396, -0.005513658, -0.02005319, 0.00019533887, -0.00026012753, -0.02720825, -0.0092430115, 0.010654744, -0.0061101, 0.013374685, 0.0011476433, 0.023040228, -0.016364006, 0.032546215, 0.02007454, -0.01674465, -0.009549152, -0.00015018927, -0.014021868, -0.029456325, -0.00027181272, -0.0038533916, 0.0074868575, -0.01625429, 0.016815966, 0.011053512, 0.015660452, 0.0045070313, -0.024623137, 0.022731215, -0.021802805, 0.0004200631, -0.006291746, 0.019561594, 0.007009312, -0.008474186, -0.03010142, -0.025353603, -0.0128018195, -0.019404104, 0.028178196, -0.026239457, 0.002178849, -0.0030791503, -0.016197264, 0.00070494186, 0.033679515, 0.022341385, 0.017331023, 0.002349507, -0.0052403663, 0.03175131, 0.026727738, -0.027709417, 0.014401478, -0.007856176, -0.025412487, -0.0019347838, 0.01546133, -0.002215285, -0.010532404, 0.016129669, -0.01952994, -0.0033232903, 0.0051485994, 0.008530089, -0.008638748, -0.01118576, -0.020194696, -0.01352961, -0.015753742, -0.011481576, 0.014600414, -0.00813492, -0.0021522956, 0.0025601443, -0.008235656, 0.01624934, 0.028777067, 0.015543683, 0.01965735, 0.0031037692, -0.0141843185, 0.013001197, 0.023838462, -0.01381871, 0.003057273, -0.018836189, -0.0019764437, 0.032304708, -0.03428078, -0.016917389, -0.0100506935, -0.00191625, -0.0010058152, 0.0109793, -0.025344145, -0.0038936823, 0.03122673, 0.023239136, 0.008541811, 0.03254368, -0.0010702431, 0.026117006, 0.015010005, -0.0022222584, 0.01654829, -0.03761254, -0.02351204, -0.054973792, -0.03356459, -0.0023674075, 0.026716229, -0.004161837, 0.032151446, 0.018505478, -0.016350403, -0.0015436964, -0.0032354044, 0.0055809175, -0.0054417723, -0.029715521, 0.013287199, -0.00053760817, 0.03761737, -0.0022877932, 0.024537345, 0.012734185, 0.008399099, -0.009642664, -0.023197243, 0.022079397, 0.019624488, -0.002758296, 0.008586411, 0.04595364, -0.03923026, 0.038942564, 0.0005655666, 0.0087959785, -0.017406216, 0.014261915, -0.023739133, -0.044816837, -0.016588379, 0.0092567615, 0.001583216, -0.057970505, -0.0456414, 0.01231864, 0.004438567, -0.004325278, 0.034874756, 0.041333515, -0.036856227, -0.0065539293, -0.054670922, 0.0013116088, -0.016190048, -0.027611088, -0.024680149, 0.016518954, 0.0576392, -0.020119727, -0.0152743915, 0.034126114, -0.015177471, -0.043071024, 0.05322472, -0.061737888, 0.012848215, -0.036791354, 0.011636205, -0.048439406, 0.010527872, 0.05916325, 0.023216005, -0.019621765, 0.030612385, 0.10881529, 0.0448641, -0.028537143, -0.008906923, 0.01766674, -0.059264723, 0.0203241, -0.015901199, 0.0073215854, -0.040831387, -0.014221157, -0.023563325, -0.02333316, -0.015911225, 0.02198991, 0.040640477, -0.028491315, -0.02769664, 0.015083708, -0.0074696736, -0.05125934, 0.043437622, -0.04905929, 0.004896956, -0.016506055, 0.021718033, -0.026592344, 0.020019297, 0.06895487, 0.018599125, -0.00793785, 0.007571639, 0.0730878, 0.041629072, -0.020727074, 0.0046066176, 0.010732468, -0.051112197, 0.0032975317, 0.00021716573, 0.008016954, 0.010098025, -0.021111123, 0.0007158526, -0.008295551, 0.011027927, -0.0020042814, -0.008128912, -0.0082997065, 0.0018376339, 0.010570353, 0.012519191, -0.018216874, -0.015215329, -0.0021612449, -0.0077015874, 0.013242789, 0.018381672, 0.020302983, -0.0054860176, 0.0075678965, -0.009774786, -0.0061935293, -0.015949523, -0.011544145, 0.001283261, 0.010381222, -0.004942334, 0.0070301658, 0.008534345, 0.0080448175, -0.011927703, 0.0028552443, 0.001765204, -0.020272298, 0.0059883366, -0.0072972267, 0.003923398, -0.0061116833, -0.0012919838, -0.0032918376, 0.009527382, 0.016660599, 0.003301391, -0.0076562283, -0.0066262255, 0.001586472, -0.0055699986, 0.005561858, 0.019774213, 0.0062839836, -0.016249536, 0.0028467008, -0.005887986, -0.006840483, -0.0056454004, -0.0006816799, -0.0017064166, 0.015269886, -0.014545999, 0.0122799855, 0.005933209, -0.022856476, 0.024479277, 0.0040627993, 0.0030312396, 0.024767397, -0.0049435548, 0.009435018, 0.01009718, 0.0035953908, -0.022942418, 0.007105878, -0.0058439816, -0.030218255, -0.013205889, 0.016342122, -0.0042464677, 0.015993547, -0.010048293, 0.0120351035, -0.015692703, 0.022602944, 0.023074856, -0.016002811, 0.001917553, 0.009456128, -0.013255198, -0.026742691, -0.007833218, -0.006620492, 0.011568156, -0.011892563, 0.012780425, 0.005906372, -0.01024786, -0.009917844, -0.045355804, 0.030526727, -0.008997673, -0.0017076109, -0.021026611, 0.016635053, 0.04013421, -0.0046028276, -0.01917372, 3.4170305e-05, -0.01968265, 0.0041589737, 0.052058853, -0.028555773, -0.00014714686, -0.035024624, -0.019536389, -0.055728067, 0.025961505, 0.027806401, 0.026578916, 0.008592541, 0.03128631, 0.061094355, 0.011767313, -0.033000812, 0.012946398, -0.01092013, -0.03186256, -0.022306835, 0.019510953, 0.0047172112, 0.054857995, -0.020403117, 0.01879692, 0.03541026, 0.017431578, -0.019388365, -0.05228926, 0.009179993, 0.013785026, -0.015344109, 0.02468252, 0.023881726, -0.04408225, 0.045693588, 0.0048228553, 0.024945548, 0.0042911475, 0.035240937, -0.009528801, -0.052879337, -0.038743094, 0.009141346, -0.012456279, -0.08053689, -0.02791042, 0.02329275, -0.0021929236, -0.01886428, 0.04724361, -0.03372911, 0.038375802, 0.006876687, 0.052268088, 0.008661018, 0.0015634513, 0.0025880188, 0.02381996, -0.026151687, -0.061491344, 0.008366647, 0.015530659, -0.031856827, 0.012683447, -0.0024580131, -0.05483771, 0.04143568, -0.0053680628, 0.05262301, -0.0021185458, 0.077285126, -0.0019551653, -0.041218862, -0.029395819, -0.0011573817, -0.03396126, -0.08186531, -0.015790287, 0.030487439, 0.012762744, -0.014731043, 0.052758604, 0.016410029, -0.018673927, -0.00030378447, -0.03274228, -0.011158611, -0.00777458, -0.013886572, -0.0069605648, 0.006302237, 0.024631493, -0.008631878, -0.0042272233, 0.018128982, -0.013330407, -0.016861796, 0.029570958, -0.023656026, -0.004239468, -0.0138782505, 0.01553439, -0.023034485, 0.0016457405, 0.027831921, 0.01409126, -0.009165793, 0.0056228586, 0.052215137, 0.023193123, -0.005828642, -0.010147838, 0.010605163, -0.021281198, 0.019791743, -0.013706377, 0.007368951, -0.03841388, -0.010973609, -0.019495938, -0.02938797, 0.00254813, 0.018987004, 0.014628649, -0.025410034, -0.020732962, 0.011598345, -0.020214371, -0.04140797, 0.037730232, -0.038049478, -0.016056353, -0.0044796844, 0.03185264, -0.004184512, 0.021450745, 0.05644275, 0.017849144, -0.012022285, -0.009035137, 0.06928879, 0.0379118, -0.015924865, -0.00882994, 0.013588468, -0.032712054, -0.03160092, 0.021854794, 0.01412337, 0.07941598, -0.04387847, 0.018606225, 0.0010459133, 0.049115095, -0.050799828, -0.08815684, 0.0019274179, 0.042947333, -0.0009217557, 0.0335542, -0.009211008, -0.10181657, 0.06725667, -0.026465923, 0.09691611, 0.056772906, 0.11847336, -0.042327933, -0.056558814, -0.048363805, -0.0038614594, -0.07483531, -0.13175274, -0.03021999, 0.070649534, -0.02592949, 0.027229019, 0.06681297, 0.014378185, -0.004812099, 0.0050038225, 0.00517553, -0.015860228, -0.0019451535, -0.020243837, -0.0070456704, 0.0018394336, 0.0077278833, -0.009577085, 0.0030934094, 0.021035526, 0.009890591, -0.019084692, -0.00975883, -0.010950434, -0.0034601814, 0.0025152962, 0.012106442, 0.005699603, -0.010391524, 0.018270325, 0.003139716, -0.008742051, -0.0054798704, 0.0070644487, -0.0026151277, 0.010076777, -0.005170758, 0.008492465, -0.0003719083, 0.019780744, -0.024601512, -0.0035323154, 0.0008408514, -0.017995406, -0.004827086, -0.011931979, -0.0034053402, 0.0036680095, 0.020999176, -0.0030994408, 0.0028782007, 0.030491572, 0.0060279435, -0.018067222, 0.0015460032, -0.013657957, 0.0066414373, -0.011283206, 0.009387744, -0.020239186, -0.016865665, 0.017293233, 4.5332767e-05, -0.005866029, 0.017795334, 0.014303979, -0.0007873953, 0.0016917842, 0.003484657, 0.015726166, -0.016442422, -0.013033925, 0.0105913635, -0.0018970799, 0.0016002292, 0.012044061, -0.0026236896, -0.0007620052, 0.0039797476, -0.00733431, -0.008154692, 0.0019385179, 0.003353524, -0.00987851, -0.006129961, 0.00010649221, -0.004390091, 0.0072028623, -0.003858214, 0.007414046, -0.009079745, 0.012387159, 0.008895157, -0.0024137574, 0.0012995558, 4.8481492e-05, -0.004552073, -0.004367667, 0.0006987062, 0.0009916982, 0.0074585197, -0.0069482983, 0.005413891, 0.0067309467, -0.0070322547, -0.014520193, -0.018499825, 0.023221314, 0.0066266507, 0.016907386, -0.014876538, 0.012852779, 0.025985627, 0.00833583, -0.008582808, -0.0021190995, -0.0017616376, 0.028030932, 0.026110606, -0.0028422263, 0.012292051, -0.035377573, -0.031669296, -0.05291585, 0.007507003, -0.0076174024, 0.015961373, 0.01809466, 0.030468483, 0.0077532106, -0.011745702, -0.022141904, 0.012389316, -0.016997363, -0.010568481, 0.031647194, -0.034856487, -0.0027704595, -0.045961287, -0.031454816, 0.00317139, -0.02285413, -0.0063219536, 0.010671974, 0.037579738, -0.024862574, 0.00047209687, 0.031580087, -0.012784519, -0.016913002, 0.044789154, -0.036467854, -0.013693322, -0.021547154, 0.04320229, -0.04109805, -0.0050394153, 0.043867514, 0.0066167875, -0.01323457, 0.00076574244, 0.081856556, 0.027365765, 0.0020511746, -0.033684425, 0.026593214, -0.028686682, -0.022032639, 0.02997593, 0.006150977, 0.024172092, 0.025926223, 0.006815993, 0.021619597, 0.01248562, 0.0029032151, -0.027272705, 0.01574507, -0.0045805126, -0.037135098, 0.003061375, 0.030608755, -0.025690814, 0.020379497, -0.0008755143, 0.012931461, -0.020995246, 0.01504888, 0.004472767, -0.03506628, -0.009794248, 0.012547014, -0.01269461, -0.04976515, -0.011314128, -0.004634921, 0.014152664, -0.015508132, 0.018362857, 0.003077398, -0.0060761007, 0.004491866, 0.041710716, -0.029883068, 0.012966238, 0.0068872212, 0.011153972, -0.017354513, -0.025518106, 0.010741393, 0.018207626, 0.007034343, 0.020916974, 0.0013665787, -0.04030674, 0.025316305, -0.00079094776, 0.023626251, 0.008920072, 0.025076192, -0.032481622, -0.032230515, -0.02014844, -0.0065897875, -0.00507769, -0.043127168, -0.016091943, 0.033955622, -0.015082103, 0.007009429, 0.028300501, 0.01906461, -0.018611075, -0.011001317, -0.040749032, 0.043861967, -0.0044913488, 0.0054693623, -0.041243196, 0.0069391415, 0.05201133, 0.003001002, -0.01109903, -0.0012021437, -0.008733304, 0.005788079, 0.04875904, -0.03642586, 0.02569507, -0.055100065, -0.029439751, -0.0707697, 0.020027572, 0.018823992, 0.02456225, 0.002405323, 0.051147804, 0.06658369, 0.015506982, -0.03560104, 0.006093782, -0.008793257, -0.042480927, 0.013926207, -0.020585097, -0.017137807, -0.041057833, 0.026238525, 8.6587155e-05, -0.0041103116, -0.032576397, 0.009384714, 0.044810686, 0.0051610596, -0.007716949, 0.013098787, -0.012830693, 0.011370537, 0.038573384, -0.020042464, 0.009836374, -0.04160445, -0.025432039, -0.06384674, 0.0057632104, 0.02505856, 0.03152842, 0.005232259, 0.037070602, 0.050400175, 0.011846211, -0.018860985, 0.004242449, -0.0067135636, -0.0311134, -0.014834335, 0.008496963, -0.0032359564, -0.018953275, 0.02567812, -0.005440533, -0.0017581497, -0.002917454, 0.010209128, 0.009543589, 0.00021208005, -0.010962307, -0.023326844, -0.013758967, 0.007715507, 0.022205444, -0.013958991, 0.0029296002, -0.012403777, -0.014718878, -0.013720595, 0.027713723, 0.012966131, 0.012614159, 0.0020824706, 0.0053610886, 0.035827592, 0.016951913, -0.029485082, 0.008970333, -0.014453054, -0.015549644}},
    {"cls.predictions.transform.dense.bias_grad", {-0.040883854, 0.037940357, -0.109973066, -0.002362915, -0.03498583, -0.082181774, -0.04345209, 0.042638592, 0.015242959, 0.037378654, -0.08810167, 0.14415994, 0.10686929, -0.010380374, -0.00067379966, -0.0389312, 0.0831522, -0.11530825, -0.117458045, 0.06674543, 0.08610852, -0.17903142, 0.017209398, 0.038847953, -0.012502425, 0.028633546, 0.095203996, -0.06797018, -0.06394567, 0.09570208, 0.07841872, 0.030581146}},
    {"cls.predictions.transform.LayerNorm.weight_grad", {3.973275e-05, 0.0014337562, -0.00080129254, 0.0004010295, 0.0018938495, -0.0005767403, 0.00016344135, -0.00068912655, 0.0012950267, 0.0022206875, 0.0025257112, 0.001928386, 0.006046523, 0.0006784266, 9.783986e-05, -0.0012473663, -0.0012431649, 0.004113084, -0.002361348, -0.0010533582, 0.0004773224, 0.0013733559, 0.0007194528, -0.0032691346, -0.0011332828, 0.0008065204, 0.0030730553, 0.0014334759, 0.0035142791, 0.004749466, 0.0007050411, 0.005324531}},
    {"cls.predictions.transform.LayerNorm.bias_grad", {-0.004998165, 0.004506847, -0.012484557, -0.001351309, -0.005096396, -0.009266191, -0.005534892, 0.005942759, 0.0013437972, 0.002329771, -0.010794659, 0.015391614, 0.012322558, -0.0016211955, -0.0005864685, -0.0050905664, 0.00882358, -0.013662686, -0.012131795, 0.007539292, 0.010195303, -0.020979438, 0.001040003, 0.004246565, -0.001779833, 0.0013392161, 0.0102768075, -0.008497233, -0.00820675, 0.00957833, 0.008834732, 0.0034028576}},
    {"cls.seq_relationship.weight_grad", {0.03683943, 0.004499306, 0.012637066, -0.0022620803, -0.0025605208, -0.0072933994, 0.0014744436, -0.00042386074, -0.023203516, -0.03829667, -0.023702562, 0.005296928, 0.019396389, 0.018737225, -0.006453916, -0.001617573, -0.018407427, 0.025214348, 0.0076358314, 0.0037247874, 0.011508712, -0.018125828, 0.008172771, -0.023605628, -0.018213145, 0.016652836, -0.028795326, -0.04646692, -0.0057319705, -0.008671218, 0.015476605, -0.012649689, -0.036839426, -0.004499305, -0.012637066, 0.00226208, 0.00256052, 0.0072933985, -0.0014744438, 0.00042386173, 0.023203515, 0.038296666, 0.02370256, -0.005296928, -0.019396387, -0.018737223, 0.006453915, 0.0016175725, 0.018407425, -0.02521434, -0.007635835, -0.0037247892, -0.011508709, 0.018125826, -0.008172771, 0.023605626, 0.018213144, -0.016652834, 0.028795326, 0.046466917, 0.00573197, 0.008671217, -0.015476605, 0.012649686}},
    {"cls.seq_relationship.bias_grad", {0.19693524, -0.19693522}},
};
}  // namespace test
}  // namespace onnxruntime
