///////////////////////////////////////////////////////////////////////////////
// $Id: Frame.cxx,v 1.1 1995/01/08 06:51:02 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Frame.cxx - Frame widget
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Frame.cxx,v $
// Revision 1.1  1995/01/08  06:51:02  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#include "Frame.hxx"
#include "UIApplication.hxx"

///////////////////////////////////////////////////////////////////////////////
// Constructor
///////////////////////////////////////////////////////////////////////////////
Frame::Frame(ContainerWidget *const parent, const char *const widgetName,
    int x, int y, int width, int height, BorderStyle borderStyle)
    : ContainerWidget(parent, widgetName, x, y, width, height),
      myBorderStyle(borderStyle)
{
  // Create window for widget
  myWindow = XCreateSimpleWindow(application->display(), myParent->window(),
      x, y, width, height,
      0, 0, 0);

  // Non-Flat frames have to respond to Exposure events
  if(borderStyle != Flat)
    XSelectInput(application->display(), myWindow, ExposureMask);
}

///////////////////////////////////////////////////////////////////////////////
// Destructor
///////////////////////////////////////////////////////////////////////////////
Frame::~Frame()
{
}

///////////////////////////////////////////////////////////////////////////////
// Update the graphical view of myself
///////////////////////////////////////////////////////////////////////////////
void Frame::updateView()
{
  Draw3DBorder(this, 3, myBorderStyle);
}

///////////////////////////////////////////////////////////////////////////////
// Called whenever an event arrives for me (I override the default)
///////////////////////////////////////////////////////////////////////////////
void Frame::handleEvent(XEvent* event)
{
  // Handle the event
  if (event->type == Expose)
  {
    updateView();
  }
}

