/***************************************************************************
 *   Copyright (C) 2006 by Christian Nitschkowski   *
 *   christian.nitschkowski@kdemail.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _OOOQS2_H_
#define _OOOQS2_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kprocess.h>
#include <ksystemtray.h>

#include "oooqs2iface.h"

class KAboutData;
class KAction;
class KHelpMenu;

/**
 * @short Application Main Window
 * @author Christian Nitschkowski <christian.nitschkowski@kdemail.net>
 * @version 1.0
 */
class OOoQs2 : public KSystemTray, OOoQs2Iface
{
   Q_OBJECT
   public:
      OOoQs2( KAboutData* about );
      virtual ~OOoQs2();

      static QString preloadMessage();

   protected:
      virtual void mouseDoubleClickEvent( QMouseEvent* );

   private:
      void setup();
      void startInstance( const QString& );

      virtual bool preloading();
      virtual void enablePreloading( bool );
      virtual bool startOnLogin();
      virtual void enableStartOnLogin( bool );
      virtual bool overrideDetection();
      virtual void setOverrideDetection( bool );
      virtual QString overrideBinary();
      virtual void setOverrideBinary( QString );
      virtual QString binary();
      virtual int instanceOOo();
      virtual int quickAccess();
      virtual void setQuickAccess( int );

      static QString detectBinary();

   private:
      KAction* p_actionPreferences;
      KAction* p_actionBase;
      KAction* p_actionCalc;
      KAction* p_actionDraw;
      KAction* p_actionImpress;
      KAction* p_actionMath;
      KAction* p_actionQuickAccess;
      KAction* p_actionTemplate;
      KAction* p_actionWriter;
      KHelpMenu* p_menuHelp;
      KProcess p_processQuickstart;
      QString p_strBinary;
      bool p_bFirstPreloadRun;
      bool p_bRunPreloader;

   private slots:
      void preferences( bool onError = false );
      void preloadInstance();
      void startBase();
      void startCalc();
      void startDraw();
      void startImpress();
      void startMath();
      void startTemplate();
      void startWriter();
};

#endif // _OOOQS2_H_
