#!/usr/bin/perl
#    OpaL Perl Modules
#    Copyright (C) 2000,2007  Ola Lundqvist <ola@opalsys.net>
#    $Id: dir.pm 2527 2007-12-06 19:57:04Z ola $
#    For full COPYRIGHT notice see the COPYING document.
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of either:
#
#	a) the GNU General Public License as published by the Free
#	Software Foundation; either version 1, or (at your option) any
#	later version, or
#
#	b) the "Artistic License" which comes with this Kit.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See either
#    the GNU General Public License or the Artistic License for more details.
#
#
#    For more information take a look at the official homepage at:
#      http://opalsys.net/software/opalmod
#    or contact the author at:
#      ola@opalsys.net
#

package OpaL::dir;

use strict;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
use OpaL::action qw(pdebug action);
use POSIX qw(strftime);

require Exporter;

@ISA = qw(Exporter AutoLoader);
# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw( );
@EXPORT_OK = qw(getdirlist);

# If you are using CVS/RCS this can be quite handy.
#$VERSION = do{my@r=q$Revision: 1.13 $=~/\d+/g;sprintf '%d.'.'%02d'x$#r,@r};

# If that is not what you want use this instead. Will be rewritten by
# create release.
my $version = '0.01';
$VERSION = $version;

###############################################################################
############################ PACKAGE GLOBALS ##################################
###############################################################################
# First exported ones (those in @EXPORT or @EXPORT_OK)

# Then package other global ones. (not exported ones)
# Can be accessed through $OpaL::dir::variablename

# All file-scooped variables must be created before any method that uses them.
# my $myvar = '';

###############################################################################
########################### PRELOADED METHODS #################################
###############################################################################
# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

# Modules must return true.
1;
__END__

###############################################################################
############################# DOCUMENTATION ###################################
###############################################################################
# Below is the stub of documentation for your module. You better edit it!

=head1 NAME

OpaL::dir - Perl extension for directory access.

=head1 SYNOPSIS

  use OpaL::dir qw(getdirlist);

  @list = getdirlist($directory);

=head1 DESCRIPTION

OpaL::dir is a module for directory access in a bit more advanced manner
than the ordinary perl module for directory access.

=head1 FUNCTIONS

=over 4

=item B<getdirlist>

Returns a list containing all files in the directory you have specified.
It will look for all files recursivly.

It will also exclude all CVS/* files, "." and ".." directories.

USAGE:
    @list = C<getdirlist>($directoryname);

=back

=head1 AUTHOR

Ola Lundqvist <ola@opalsys.net>

=head1 REQUIRES

This package requires OpaL::action so you have to make sure that that perl
module is installed.

=head1 SEE ALSO

L<OpaL::action>

perl(1)

=cut

###############################################################################
########################### AUTOLOAD METHODS ##################################
###############################################################################

###############################################################################
# Name:		getdirlist
# Description:	Get the filenames for a directory, recursive.
# Argument:	A directory name.
# Returns:	A list of filenames.
# Author:	Ola Lundqvist <ola@opalsys.net>
# Date:		2000-05-13
#		2000-06-29	Argument definition.
###############################################################################
sub getdirlist {#($) {
    pdebug(5,"Entering getdirlist.");
    my $dir,@t = ();
    while ($dir = shift) {
	&action(! (opendir (D,$dir)),
		"Trying to open $dir.");
	my $k;
	while ($k = readdir(D)) {
	    if (-f "$dir/$k") {
		if ($k !~ /~$/ &&
		    $k !~ /^#.*#$/
		    ) {
		    push @t, "$dir/$k";
		}
	    }
	    elsif (-d "$dir/$k") {
		if ($k !~ /^\.+$/ &&
		    $k !~ /CVS/
		    ) {
		    push @_, "$dir/$k";
		}
	    }
	}
    }
    return @t;
}
