#!/bin/sh

# container-tools - Manage systemd-nspawn containers
# Copyright (C) 2014-2016 Daniel Baumann <daniel.baumann@open-infrastructure.net>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

set -e

# Usage: sudo asciinema -c ./introduction.sh

PS1="root@debian:~#"

Command ()
{
	COMMAND="${@}"

	echo
	echo -n "${PS1} "
	echo "${COMMAND}"

	${COMMAND}

	echo "${PS1}"
	echo
	sleep 2
}

Text ()
{
	TEXT="${@}"

	echo "${TEXT}"
	sleep 2
}

# Content

sleep 2

Text "# Welcome to this container-tools introduction cast."
echo
echo

Text "# 1. We're using Debian ($(lsb_release -cs))..."

Command "lsb_release -a"

Text "# ...and container-tools version $(cnt version)."

Command "cnt version"


Text "# 2. Let's list all available containers."
Text "#"
Text "# Note: there are no containers yet."

Command "sudo cnt list"


Text "# 3. Let's create an example container."
Text "#"
Text "# Note: creating containers with the simple debootstrap"
Text "# container create script is slow as it doesn't cache anything."
Text "# Using the advanced debconf container create script for"
Text "# fast, automated, and reproducible setup of complex containers"
Text "# will be covered in a subsequent screencast."
Text "#"
Text "# Note: we're using a custom mirror here and"
Text "# a custom root password, see container-create-debootstrap(1)"
Text "# for more information about these options."

Command "sudo cnt create -n example.net -s debootstrap -- -d sid -m http://ftp.ch.debian.org/debian -p debian"


Text "# 4. Let's list all available containers."
Text "#"
Text "# Note: there's one container now."

Command "sudo cnt list"


Text "# 5. Let's start the example container."

Command "sudo cnt start -n example.net"


Text "# 6. Let's check if the container was started."

Command "sudo cnt list"


Text "# 7. Let's stop the example container."

Command "sudo cnt stop -n example.net"


Text "# 8. Let's check if the container was stopped."

Command "sudo cnt list"


Text "# 9. Let's remove the example container."

Command "sudo cnt remove -f -n example.net"


Text "# 10. Let's check if the container was removed."

Command "sudo cnt list"


echo
echo
Text "# This concludes this introduction to container-tools."
Text "#"
Text "# Thanks for watching and have fun setting up"
Text "# your own Linux containers based on systemd-nspawn"
Text "# using container-tools from Open Infrastructure:"
Text "#"
Text "# https://open-infrastructure.net/software/container-tools"

sleep 2

exit 0
