/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include <allegro.h>

#ifdef ALLEGRO_LINUX
#include "config.h"
#include "include/declare.h"
#endif

#ifndef ALLEGRO_LINUX
#include "../include/declare.h"
#endif


using namespace std;

FONT *gamefont;

BITMAP *display;
BITMAP *ship;
BITMAP *projectile;
BITMAP *alien;
BITMAP *death;
BITMAP *ufo;
BITMAP *shield_original;
BITMAP *shield_copies[3];
BITMAP *logo;
BITMAP *level2bk[2];
BITMAP *level3bk;
BITMAP *level4bk[2];
BITMAP *level5bk;
BITMAP *level6bk;
BITMAP *level7bk;
BITMAP *level9bk[3];
BITMAP *level11bk;
BITMAP *level12bk;
BITMAP *level13bk;
BITMAP *level14bk;

RLE_SPRITE *rock_background[2];
RLE_SPRITE *grid_background;
RLE_SPRITE *cloud_background[2];
RLE_SPRITE *planet_background;
RLE_SPRITE *meteor_background;
RLE_SPRITE *moon_background;
RLE_SPRITE *gummibear_background[3];
RLE_SPRITE *lightning_background;
RLE_SPRITE *city_background;
RLE_SPRITE *fortress_background;

RLE_SPRITE *rle_ship, *rle_projectile, *rle_alien, *rle_death, *rle_ufo;


extern int level;
extern int todisplayx, todisplayy;
extern startype stars[500], clouds[4], meteors[10], gummis[30];
extern item wave[9][5];
extern item shipposition;
extern int posx;
extern item bulletposition, ufoposition;
extern int projlimit;
extern item enemybullets[25];
extern int score, lives;
extern int bkoffsetx, bkoffsety;
extern bool game_active, paused;

extern SAMPLE *shoot, *explode;
extern AL_DUH_PLAYER *gamesongplayer;

extern void load_data_files();

void display_background()
{
	if(level==1||level==6)
	{
		for(int displaystars=0; displaystars<100; displaystars++)
	 	{
			todisplayx=stars[displaystars].x;
   			todisplayy=stars[displaystars].y;
   			putpixel(display,todisplayx,todisplayy,makecol16(255,255,255));

   			if(!paused)
			{
				stars[displaystars].y=stars[displaystars].y+stars[displaystars].speed;
			}
			
   			if(stars[displaystars].y>600)
   			{
   				stars[displaystars].x=rand()%SCREEN_W;
   				stars[displaystars].y=0;
   				stars[displaystars].speed=(rand()%10)+1;
   			};
   		};
	}
	
	if(level==2)
	{
		for(int displayrocks=0; displayrocks<(SCREEN_H/250)+2; displayrocks++)
		{
			draw_rle_sprite(display,rock_background[0],0,(displayrocks*250)-bkoffsety);
			draw_rle_sprite(display,rock_background[1],SCREEN_W-250,(displayrocks*250)-bkoffsety);
		};
		
		if(!paused)
		{	
			bkoffsety--;
		}
		
		if(bkoffsety<0)
		{
			bkoffsety=250;
		}		
	};
	
	if(level==3)
	{
		for(int displaygridx=0; displaygridx<6; displaygridx++)
		{
			for(int displaygridy=0; displaygridy<5; displaygridy++)
			{
				draw_rle_sprite(display,grid_background,displaygridx*250,(displaygridy*250)-bkoffsety);
			}
		}
		
		if(!paused)
		{
			bkoffsety--;
		}		
		
		if(bkoffsety<0)
		{
			bkoffsety=250;
		}
	}
	
	if(level==4||level==8)
	{
		if(level==4)
		{
			clear_to_color(display,makecol16(0,190,160));
		}
		
		if(level==8)
		{
			clear_to_color(display,makecol16(0,0,40));
		}
		
		for(int displayclouds=0; displayclouds<3; displayclouds++)
	 	{
			todisplayx=clouds[displayclouds].x;
   			todisplayy=clouds[displayclouds].y;
   			draw_rle_sprite(display,cloud_background[clouds[displayclouds].color],clouds[displayclouds].x,clouds[displayclouds].y);
			
			if(!paused)
			{
				clouds[displayclouds].x=clouds[displayclouds].x+clouds[displayclouds].speed;
			}
			
			if(clouds[displayclouds].x>SCREEN_W)
   			{
   				clouds[displayclouds].x=-250;
   				clouds[displayclouds].y=rand()%400;
   				clouds[displayclouds].speed=(rand()%3)+1;
   			};
   		};
	}
	
	if(level==5)
	{
		for(int displaystars=0; displaystars<100; displaystars++)
		{
			putpixel(display,stars[displaystars].x,stars[displaystars].y,makecol16(180,180,180));
		}
		
		draw_rle_sprite(display,planet_background,400,100);
	}
	
	if(level==6)
	{
		for(int displaymeteors=0; displaymeteors<10; displaymeteors++)
	 	{
			todisplayx=meteors[displaymeteors].x;
   			todisplayy=meteors[displaymeteors].y;
   			draw_rle_sprite(display,meteor_background,meteors[displaymeteors].x,meteors[displaymeteors].y);
			
			if(!paused)
			{
				meteors[displaymeteors].y=meteors[displaymeteors].y+meteors[displaymeteors].speed;
			}
				
			if(meteors[displaymeteors].y>SCREEN_H)
   			{
   				meteors[displaymeteors].x=rand()%SCREEN_W;
   				meteors[displaymeteors].y=-300;
   				meteors[displaymeteors].speed=(rand()%7)+3;
   			};
   		};
	}
	
	if(level==7||level==12||level==14)
	{
		for(int displaystars=0; displaystars<100; displaystars++)
		{
			int shade=rand()%100+155;
			putpixel(display,stars[displaystars].x,stars[displaystars].y,makecol16(shade,shade,shade));
		}
		
		switch(level)
		{
			case 7: draw_rle_sprite(display,moon_background,400,100); break;
			case 12: draw_rle_sprite(display,city_background,0,300); break;
		}
	}
	
	if(level==9)
	{
		for(int displaygummis=0; displaygummis<30; displaygummis++)
	 	{
			todisplayx=gummis[displaygummis].x;
   			todisplayy=gummis[displaygummis].y;
   			draw_rle_sprite(display,gummibear_background[gummis[displaygummis].color],gummis[displaygummis].x,gummis[displaygummis].y);
			
			if(!paused)
			{
				gummis[displaygummis].y=gummis[displaygummis].y+gummis[displaygummis].speed;
			}
			
			if(gummis[displaygummis].y>SCREEN_H)
   			{
   				gummis[displaygummis].x=rand()%SCREEN_W;
   				gummis[displaygummis].y=-300;
   				gummis[displaygummis].speed=(rand()%7)+3;
				gummis[displaygummis].color=rand()%3;
   			};
   		};
	}
	
	if(level==11||level==14)
	{
		int chance_of_bad_weather = rand()%100;
		int position_of_bolt = rand()%(SCREEN_W-level11bk->w);
		
		if(chance_of_bad_weather>96&&!paused)
		{
			clear_to_color(display,makecol16(220,220,255));
			draw_rle_sprite(display,lightning_background,position_of_bolt,0);
		}
		else
		{
			if(level==11)
			{
				clear_to_color(display,makecol16(0,0,40));
			}
		}			
	}
	
	if(level==13)
	{
		blit(level13bk,display,0,0,0,0,800,600);
	}
	
	if(level==14)
	{
		draw_rle_sprite(display,fortress_background,200,100);
	}		
}


// Inititialise display and reserve memory for sprites

void display_setup(int screenmode)
{	
	set_color_depth(16);
	
	switch(screenmode)
	{
		case 0: set_gfx_mode(GFX_AUTODETECT,800,600,0,0); break;
		case 1: set_gfx_mode(GFX_AUTODETECT_FULLSCREEN,800,600,0,0); break;
		case 2: set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0); break;
		case 3: set_gfx_mode(GFX_TEXT,800,600,0,0); break;
	};
}
	
void define_sprites()
{
	set_color_conversion(COLORCONV_24_TO_16);
	
	display=create_bitmap(800,600);
	
	for(int copies=0; copies<3; copies++)
	{
		shield_copies[copies]=create_bitmap(140,88);
	};

	load_data_files();

	rle_ship=get_rle_sprite(ship);
	rle_alien=get_rle_sprite(alien);
	rle_projectile=get_rle_sprite(projectile);
	rle_death=get_rle_sprite(death);
	rle_ufo=get_rle_sprite(ufo);
		
	rock_background[0]=get_rle_sprite(level2bk[0]);
	rock_background[1]=get_rle_sprite(level2bk[1]);
	grid_background=get_rle_sprite(level3bk);
	cloud_background[0]=get_rle_sprite(level4bk[0]);
	cloud_background[1]=get_rle_sprite(level4bk[1]);
	planet_background=get_rle_sprite(level5bk);
	meteor_background=get_rle_sprite(level6bk);
	moon_background=get_rle_sprite(level7bk);
	for(int gummisback=0; gummisback<3; gummisback++)
	{gummibear_background[gummisback]=get_rle_sprite(level9bk[gummisback]);}
	lightning_background=get_rle_sprite(level11bk);
	city_background=get_rle_sprite(level12bk);	
	fortress_background=get_rle_sprite(level14bk);	
};

void game_display(int alpha)
{	
	// Display background
	
	display_background();
	
	// Display characters
	
	for(int wavex=0; wavex<8; wavex++)
	{
		for(int wavey=0; wavey<4; wavey++)
		{
			if(wave[wavex][wavey].alive==alive)
			{
				draw_rle_sprite(display,rle_alien,wave[wavex][wavey].xpos,wave[wavex][wavey].ypos);
			};
			
			if(wave[wavex][wavey].alive==dying)
			{
				draw_rle_sprite(display,rle_death,wave[wavex][wavey].xpos,wave[wavex][wavey].ypos);
				wave[wavex][wavey].deathtime--;
				if(wave[wavex][wavey].deathtime==0)
				{
					wave[wavex][wavey].alive=dead;
				};
			};
		};
	};
	
	if(shipposition.alive==alive)
	{
		draw_rle_sprite(display,rle_ship,posx,530);
	}
	else
	{
		draw_rle_sprite(display,rle_death,posx,530);
	};
		
	if(bulletposition.alive==alive)
	{
		draw_rle_sprite(display,rle_projectile,bulletposition.xpos,bulletposition.ypos);
	};
	
	if(ufoposition.alive==alive)
	{
		draw_rle_sprite(display,rle_ufo,ufoposition.xpos,ufoposition.ypos);
	};
	
	if(ufoposition.alive==dying)
	{
		draw_rle_sprite(display,rle_death,ufoposition.xpos,ufoposition.ypos);
	};
	
	// Display enemy bullets
	
	for(int enemy_shots=0; enemy_shots<projlimit; enemy_shots++)
	{
		if(enemybullets[enemy_shots].alive==alive)
		{
			draw_rle_sprite(display,rle_projectile,enemybullets[enemy_shots].xpos,enemybullets[enemy_shots].ypos);
		}
	};
	
	// Display shields (copies which are modified as bullets collide with them)
	
	for(int shieldnumber=0; shieldnumber<3; shieldnumber++)
	{
		masked_blit(shield_copies[shieldnumber],display,0,0,(shieldnumber*270)+60,420,140,88);
	};
		
	// Display scoreboard
	
	textprintf_ex(display,gamefont,0,0,makecol16(255,255,255),makecol16(255,0,255),"SCORE: %d",score);
	textprintf_centre_ex(display,gamefont,399,0,makecol16(255,255,255),makecol16(255,0,255),"LIVES: %d",lives);
	textprintf_right_ex(display,gamefont,799,0,makecol16(255,255,255),makecol16(255,0,255),"LEVEL: %d",level);
	
	// Display final image and clear buffer
	
	if(alpha<255)
	{
		set_trans_blender(0,0,0,255-alpha);
		drawing_mode(DRAW_MODE_TRANS,0,0,0);
		rectfill(display,0,0,(int) SCREEN_W-1,(int) SCREEN_H-1,0);
	}
	else
	{
		drawing_mode(DRAW_MODE_SOLID,0,0,0);
	}
	
	if(paused)
	{
		textout_centre_ex(display, gamefont, "PAUSED", SCREEN_W/2, 300,-1,-1);
	}
	
	blit(display,screen,0,0,0,0,800,600);
	
	clear_to_color(display,0);
};

void alt_fade_in(BITMAP *destimage, int speed)
{
	BITMAP *buffer;
	
	buffer=create_bitmap(800,600);
	
	clear_to_color(buffer,0);
	
	for(int alpha=0; alpha<256; alpha+=speed)
	{
		set_trans_blender(0,0,0,alpha);
		draw_trans_sprite(buffer,destimage,0,0);
		vsync();
		blit(buffer,screen,0,0,0,0,800,600);
		//al_poll_duh(songplayer);
	}
	
	blit(destimage,screen,0,0,0,0,800,600);
	
	destroy_bitmap(buffer);
}

void alt_fade_out(BITMAP *sourceimage, int speed)
{	
	//I'm sure there's a more efficient way of doing this - please let me know
	//if you find it
	
	BITMAP *buffer,*buffer2;
	
	buffer=create_bitmap(800,600);
	buffer2=create_bitmap(800,600);
	
	blit(sourceimage,buffer,0,0,0,0,800,600);
	clear_to_color(buffer2,0);
	
	for(int alpha=0; alpha<256; alpha+=speed)
	{
		set_trans_blender(0,0,0,alpha);
		draw_trans_sprite(buffer,buffer2,0,0);
		vsync();
		blit(buffer,screen,0,0,0,0,800,600);
		al_poll_duh(gamesongplayer);
	}
	
	clear_to_color(screen,0);
	
	destroy_bitmap(buffer);
	destroy_bitmap(buffer2);
}

void alt_fade_between(BITMAP *sourceimage, BITMAP *destimage, int speed)
{
	BITMAP *buffer;
	
	buffer=create_bitmap(800,600);
	
	blit(sourceimage,buffer,0,0,0,0,800,600);
	
	for(int alpha=0; alpha<256; alpha+=speed)
	{
		set_trans_blender(0,0,0,alpha);
		draw_trans_sprite(buffer,destimage,0,0);
		vsync();
		blit(buffer,screen,0,0,0,0,800,600);
		al_poll_duh(gamesongplayer);
	}
	
	blit(destimage,screen,0,0,0,0,800,600);
	
	destroy_bitmap(buffer);
}
