/***************************************************************************
 *            intro.cc
 *
 *  Fri Jun  1 00:17:55 2007
 *  Copyright  2007  Darryl LeCount
 *  darryl@jamyskis.net
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <allegro.h>

#ifdef ALLEGRO_LINUX
#include "config.h"
#include "include/declare.h"
#endif

#ifndef ALLEGRO_LINUX
#include "../include/declare.h"
#endif

using namespace std;

extern PALETTE gamepalette;
extern BITMAP *display, *logo;
extern FONT *gamefont;
extern startype stars[500];
extern int todisplayx, todisplayy, difficulty;
extern bool program_active, game_active;
extern int hiscore, sfx_volume;
extern int music_volume;
extern SAMPLE *welcome, *letsgo;
extern string keynames[7];
extern int keysdefined[7];
BITMAP *credits;

extern void delay_loop(int counter);
string keydescriptors[]={
   "(none)",     "A",          "B",          "C",
   "D",          "E",          "F",          "G",
   "H",          "I",          "J",          "K",
   "L",          "M",          "N",          "O",
   "P",          "Q",          "R",          "S",
   "T",          "U",          "V",          "W",
   "X",          "Y",          "Z",          "0",
   "1",          "2",          "3",          "4",
   "5",          "6",          "7",          "8",
   "9",          "NUMPAD 0",   "NUMPAD 1",   "NUMPAD 2",
   "NUMPAD 3",   "NUMPAD 4",   "NUMPAD 5",   "NUMPAD 6",
   "NUMPAD 7",   "NUMPAD 8",   "NUMPAD 9",   "F1",
   "F2",         "F3",         "F4",         "F5",
   "F6",         "F7",         "F8",         "F9",
   "F10",        "F11",        "F12",        "ESC",
   "TILDE",      "MINUS",      "EQUALS",     "BACKSPACE",
   "TAB",        "OPENBRACE",  "CLOSEBRACE", "ENTER",
   "COLON",      "QUOTE",      "BACKSLASH",  "BACKSLASH2",
   "COMMA",      "STOP",       "SLASH",      "SPACE",
   "INSERT",     "DEL",        "HOME",       "END",
   "PGUP",       "PGDN",       "LEFT",       "RIGHT",
   "UP",         "DOWN",       "NUMPAD /",   "ASTERISK",
   "NUMPAD -",  "NUMPAD +",   "NUMPAD DEL",    "NUMPAD ENTER",
   "PRTSCR",     "PAUSE",      "ABNT_C1",    "YEN",
   "KANA",       "CONVERT",    "NOCONVERT",  "AT",
   "CIRCUMFLEX", "COLON2",     "KANJI",      "EQUALS_PAD",
   "BACKQUOTE",  "SEMICOLON",  "COMMAND",    "UNKNOWN1",
   "UNKNOWN2",   "UNKNOWN3",   "UNKNOWN4",   "UNKNOWN5",
   "UNKNOWN6",   "UNKNOWN7",   "UNKNOWN8",   "LEFT SHIFT",
   "RIGHT SHIFT",     "LEFT CTRL",   "RIGHT CTRL",   "ALT",
   "ALTGR",      "LEFT WIN",       "RIGHT WIN",       "MENU",
   "SCRLOCK",    "NUMLOCK",    "CAPSLOCK",   "MAX"
};


void intro_sequence()
{	
	BITMAP *jamyskis;
	BITMAP *allegro;
	BITMAP *linuxlogo;

	jamyskis=load_pcx("./data/jamyskis_logo.pcx", NULL);
	allegro=load_pcx("./data/allegro_logo.pcx", NULL);
	linuxlogo=load_pcx("./data/linux.pcx", NULL);

#ifdef ALLEGRO_LINUX
	if(!jamyskis)
	{
		jamyskis=load_pcx(JAMYSKIS_LOGO, NULL);	
	}
	
	if(!allegro)
	{
		allegro=load_pcx(ALLEGRO_LOGO, NULL);
	}
	
	if(!linuxlogo)
	{
		linuxlogo=load_pcx(LINUX_LOGO, NULL);
	}
#endif

	
	if(!jamyskis||!allegro||!linuxlogo)
	{
		cout << "Could not load intro images";
		allegro_exit();
		abort();
	}
		
	clear_to_color(screen,0);
	set_palette(black_palette);
	rest(2000);
	
	alt_fade_in(jamyskis,5);
		
	blit(jamyskis,screen,0,0,0,0,800,600);
		
	rest(2000);
	alt_fade_between(jamyskis,allegro,5);
		
	blit(allegro,screen,0,0,0,0,800,600);
		
	rest(2000);
	alt_fade_between(allegro,linuxlogo,5);
	
	blit(linuxlogo,screen,0,0,0,0,800,600);
	
	rest(2000);
	alt_fade_out(linuxlogo,5);
	
	destroy_bitmap(jamyskis);
	destroy_bitmap(allegro);
	destroy_bitmap(linuxlogo);
};


void title_screen()
{
	bool title_screen_active=true;
	int flashdelay, flashcolor; // for "Press Start" message
	
	int verticalsize, verticalposition;// these two are
	bool logoinvert, growing; // for the logo 3D effect
	int title_mode=1; //1=press start, 2=menu
	int menu_timer=0; //time needed to go automatically back from menu to press start prompt
	int option_selected=0; //currently selected option_selected
	int alpha_blend=0; //State of bounding box in menu options
	bool keyreleased=false;
	int number_of_redefs_displayed=1;
	
	string difficulties[5] = {
		"CHICKEN",
		"EASY",
		"MEDIUM",
		"HARD",
		"INSANE!"
	};
	
	int r=0,g=0,b=0;
	
	string options_available[4] = {"START THE MASSACRE","OPTIONS","CREDITS","EXIT GAME"};
	
	BITMAP *logobuffer=create_bitmap(logo->w,logo->h);
	
	SAMPLE *move_sound;
	SAMPLE *select_sound;
	SAMPLE *goodbye_sound;
	SAMPLE *credits_sound;
	SAMPLE *options_sound;
	
	credits=create_bitmap(SCREEN_W,SCREEN_H);
		
	extern DUH *titlesong;
	AL_DUH_PLAYER *titlesongplayer;

	ostringstream hiscore_as_string;
	
	titlesong=dumb_load_mod_quick("./data/titlesong.mod");
	
#ifdef ALLEGRO_LINUX
	if(!titlesong)
	{
		titlesong=dumb_load_mod_quick(TITLE_SONG);
	}
#endif
		
	if(!titlesong)
	{
		cout << "Could not load title song";
		allegro_exit();
		abort();
	}
	
	options_sound=oi_load_sfx("options.wav",TITLE_OPTIONS_SOUND);
	credits_sound=oi_load_sfx("credits.wav",TITLE_CREDITS_SOUND);
	goodbye_sound=oi_load_sfx("goodbye.wav",TITLE_GOODBYE_SOUND);
	
	move_sound=oi_load_sfx("move.wav",TITLE_MOVE_SOUND);
	select_sound=oi_load_sfx("select.wav",TITLE_SELECT_SOUND);
	
	titlesongplayer=al_start_duh(titlesong,2,0,(float) music_volume/10,
		get_config_int("sound", "buffer_size", 4096),
		get_config_int("sound", "sound_freq", 22500));
	
	flashdelay=0;
	flashcolor=makecol16(255,255,255);
	
	verticalsize=logo->h;
	verticalposition=200;
	logoinvert=false;
	growing=false;
	
	clear(display);	
	
	for(int starcount=0; starcount<500; starcount++)
	{
		stars[starcount].x=rand()%SCREEN_W;
		stars[starcount].y=rand()%SCREEN_H;
		stars[starcount].speed=(rand()%4)+1;
	};
	
	play_sample(welcome,sfx_volume,128,1000,0);
		
	while(title_screen_active)
	{
		clear_to_color(display,0);
		
		flashdelay++;
		
		if(flashdelay==10)
		{
			flashdelay=0;
			if(flashcolor==0)
			{
				flashcolor=1;
			}
			else
			{
				flashcolor=0;
			};
		};
		
		al_poll_duh(titlesongplayer);
		
		poll_joystick();

    	for(int displaystars=0; displaystars<500; displaystars++)
	 	{
			todisplayx=stars[displaystars].x;
   			todisplayy=stars[displaystars].y;
   			putpixel(display,todisplayx,todisplayy,makecol16(255,255,255));

   			stars[displaystars].x=stars[displaystars].x-stars[displaystars].speed;
   			if(stars[displaystars].x<0)
   			{
   				stars[displaystars].x=SCREEN_W-1;
   				stars[displaystars].y=rand()%SCREEN_H;
   				stars[displaystars].speed=(rand()%20)+1;
   				stars[displaystars].color=(rand()%14)+1;
   			};
   		};
		
		if(title_mode==1||title_mode==2)
		{
			hiscore_as_string << "HISCORE: " << hiscore;
		
			if(logoinvert)
			{		
				draw_sprite_v_flip(logobuffer,logo,0,0);
				masked_stretch_blit(logobuffer,display,0,0,logobuffer->w,logobuffer->h,100,verticalposition/2,logo->w,verticalsize);
			}
			else
			{
				draw_sprite(logobuffer,logo,0,0);
				stretch_sprite(display,logobuffer,100,verticalposition/2,logo->w,verticalsize);
			}
		
			clear_to_color(logobuffer,makecol16(255,0,255));
		
			if(verticalsize<=0&&logoinvert)
			{
				growing=true;
				verticalsize=1;
				logoinvert=false;
			}
		
			if(verticalsize>=logo->h&&logoinvert)
			{
				growing=false;
				verticalsize=logo->h;
			}
		
			if(verticalsize<=0&&!logoinvert)
			{
				growing=true;
				verticalsize=1;
				logoinvert=true;
			}
		
			if(verticalsize>=logo->h&&!logoinvert)
			{
				growing=false;
				verticalsize=logo->h;
			}
			
			if(growing)
			{
				verticalsize=verticalsize+3;
				verticalposition=verticalposition-3;
			}
			else
			{	
				verticalsize=verticalsize-3;
				verticalposition=verticalposition+3;
			}
		
			textprintf_centre_ex(display,gamefont,400,550,-1,-1,"(C) 2006-2007 DARRYL LECOUNT / JAMYSKIS");
			textprintf_right_ex(display,gamefont,799,0,-1,-1,"VERSION 0.2");
		}

		switch(title_mode)
		{
			case 1: //mode 1 is the "press start" prompt
				if(flashcolor==1)
				{	
					textprintf_centre_ex(display,gamefont,400,400,flashcolor,0,"PRESS FIRE OR ANY KEY TO BEGIN");
				}
				//textprintf_centre_ex(display,gamefont,400,450,-1,-1,"PRESS CTRL+Q TO EXIT");
				textprintf_centre_ex(display,gamefont,400,500,-1,-1,hiscore_as_string.str().c_str());
				
				hiscore_as_string.str("");
		
				if(input_pressed()||joy[0].button[0].b)
				{
					title_mode=2;
					menu_timer=1000;
					play_sample(select_sound,sfx_volume,128,1000,0);
				};
	
				if((key[KEY_LCONTROL]||key[KEY_RCONTROL])&&key[KEY_Q])
				{
					title_screen_active=false;
					program_active=false;
				}
		
				rest(0);
				
				break;
				
			case 2: //mode 2 is the main menu
				set_trans_blender(0,0,0,alpha_blend);
				drawing_mode(DRAW_MODE_TRANS,0,0,0);
				rectfill(display,220,360+(option_selected*45),620,395+(option_selected*45),makecol16(0,0,200));
				drawing_mode(DRAW_MODE_SOLID,0,0,0);

				for(int optionsdisplay=0; optionsdisplay<4; optionsdisplay++)
				{
					textout_ex(display,gamefont,options_available[optionsdisplay].c_str(),240,370+(optionsdisplay*45),-1,-1);
				}
				
				alpha_blend=alpha_blend+5;
				
				if(alpha_blend>255)
				{
					alpha_blend=0;
				}
				
				poll_joystick();
				
				if(keyreleased)
				{
					if((key[KEY_UP]||key[keysdefined[2]]||joy[0].stick[0].axis[1].d1)&&option_selected>0)
					{
						option_selected--;
						keyreleased=false;
						menu_timer=1000;
						play_sample(move_sound,sfx_volume,128,1000,0);
					}
				
					if((key[KEY_DOWN]||key[keysdefined[3]]||joy[0].stick[0].axis[1].d2)&&option_selected<3)
					{
						option_selected++;
						keyreleased=false;
						menu_timer=1000;
						play_sample(move_sound,sfx_volume,128,1000,0);
					}

					if(key[keysdefined[4]]||key[KEY_ENTER]||joy[0].button[0].b)
					{
						play_sample(select_sound,sfx_volume,128,1000,0);
						
						switch(option_selected)
						{
							case 0:
								title_screen_active=false;
								break;
							
							case 1:
								alpha_blend=0;
								title_mode=5;
								keyreleased=false;
								option_selected=0;
								play_sample(options_sound,sfx_volume,128,1000,0);
								break;							
							case 2:
								option_selected=0;
								alpha_blend=0;
								title_mode=3;
								keyreleased=false;
								setup_credits_screen();
								play_sample(credits_sound,sfx_volume,128,1000,0);
								break;
							case 3:
								al_pause_duh(titlesongplayer);
								play_sample(goodbye_sound,sfx_volume,128,1000,0);
								alt_fade_out(screen,1);			
								title_screen_active=false;
								program_active=false;
								break;
							break;
						}	
					}					
				}
				
				if(input_pressed())
				{
					keyreleased=false;
				}
				else
				{
					keyreleased=true;
				}
				
				menu_timer--;
				
				if(menu_timer==0)
				{
					title_mode=1;
					option_selected=0;
					keyreleased=false;
				}
								
				break;
				
			case 3: //mode 3 is the credits screen
				set_trans_blender(0,0,0,alpha_blend);
				draw_trans_sprite(display,credits,0,0);
				
				alpha_blend=alpha_blend+2;
			
				if(alpha_blend>255)
				{
					alpha_blend=255;
				}
				
				if(!input_pressed())
				{
					keyreleased=true;
				}
				
				if(input_pressed()&&keyreleased)
				{	
					keyreleased=false;
					title_mode=4;
				};
				break;
				
			case 4: //mode 4 is the credits screen fading out 
				set_trans_blender(0,0,0,alpha_blend);
				draw_trans_sprite(display,credits,0,0);
				
				alpha_blend=alpha_blend-4;
			
				if(alpha_blend<0)
				{
					option_selected=0;
					title_mode=2;
					alpha_blend=0;
				}
				break;
			case 5: //mode 5 is the options screen
				set_trans_blender(0,0,0,alpha_blend);
				
				drawing_mode(DRAW_MODE_TRANS,0,0,0);
				rectfill(display,30,122+(option_selected*60),380,152+(option_selected*60),makecol16(0,0,200));
				drawing_mode(DRAW_MODE_SOLID,0,0,0);	
			
				textout_centre_ex(display,gamefont,"OPTIONS",399,50,-1,-1);
				textout_ex(display,gamefont,"DIFFICULTY LEVEL",40,130,-1,-1);
				textout_ex(display,gamefont,difficulties[difficulty].c_str(),540,130,-1,-1);
				textout_ex(display,gamefont,"MUSIC VOLUME",40,190,-1,-1);
				for(int volumesteps=0; volumesteps<music_volume+1; volumesteps++)
				{
					if(volumesteps>=0&&volumesteps<=4)
					{
						r=255; g=0; b=0;
					}
					if(volumesteps>=5&&volumesteps<=8)
					{
						r=255; g=255; b=0;
					}
					if(volumesteps>8)
					{
						r=0; g=255; b=0;
					}
										
					rectfill(display,540+(volumesteps*15),190,550+(volumesteps*15),210,makecol16(r,g,b));
				}
				textout_ex(display,gamefont,"SFX VOLUME",40,250,-1,-1);
			
				for(int volumesteps=0; volumesteps<(sfx_volume/25)+1; volumesteps++)
				{					
					if(volumesteps>=0&&volumesteps<=4)
					{
						r=255; g=0; b=0;
					}
					if(volumesteps>=5&&volumesteps<=8)
					{
						r=255; g=255; b=0;
					}
					if(volumesteps>8)
					{
						r=0; g=255; b=0;
					}
				
					rectfill(display,540+(volumesteps*15),250,550+(volumesteps*15),270,makecol16(r,g,b));
				}
				textout_ex(display,gamefont,"REDEFINE KEYS",40,310,-1,-1);
				textout_ex(display,gamefont,"RETURN TO MENU",40,370,-1,-1);
			
				alpha_blend=alpha_blend+5;
			
				if(alpha_blend>255)
				{
					alpha_blend=0;
				}
				
				poll_joystick();
				
				if(keyreleased)
				{
					if((key[KEY_UP]||key[keysdefined[2]]||joy[0].stick[0].axis[1].d1)&&option_selected>0)
					{
						play_sample(move_sound,sfx_volume,128,1000,0);
						option_selected--;
						keyreleased=false;
					}
				
					if((key[KEY_DOWN]||key[keysdefined[3]]||joy[0].stick[0].axis[1].d2)&&option_selected<4)
					{
						play_sample(move_sound,sfx_volume,128,1000,0);
						option_selected++;
						keyreleased=false;
					}
					
					if((key[KEY_LEFT]||key[keysdefined[0]]||joy[0].stick[0].axis[0].d1)&&option_selected<3)
					{
						play_sample(move_sound,sfx_volume,128,1000,0);
						switch(option_selected)
						{
							case 0:
								if(difficulty>0)
								{
									difficulty--;
								}
								break;
							case 1:
								if(music_volume>0)
								{
									music_volume=music_volume-1;
									al_duh_set_volume(titlesongplayer,(float) music_volume/10);
								}
								break;
							case 2:
								if(sfx_volume>0)
								{
									sfx_volume=sfx_volume-25;
								}
								break;
						}
					}
					
					if((key[KEY_RIGHT]||key[keysdefined[1]]||joy[0].stick[0].axis[0].d2)&&option_selected<3)
					{
						play_sample(move_sound,sfx_volume,128,1000,0);
						switch(option_selected)
						{
							case 0:
								if(difficulty<4)
								{
									difficulty++;
								}
								break;
							case 1:
								if(music_volume<10)
								{
									music_volume=music_volume+1;
									al_duh_set_volume(titlesongplayer,(float) music_volume/10);
								}
								break;
							case 2:
								if(sfx_volume<250)
								{
									sfx_volume=sfx_volume+25;
								}
								break;
						}
					}					

					if(key[KEY_LSHIFT]||key[keysdefined[4]]||key[KEY_SPACE]||key[KEY_ENTER]||joy[0].button[0].b)
					{
						if(option_selected>=3)
						{
							play_sample(select_sound,sfx_volume,128,1000,0);
						}
						switch(option_selected)
						{
							case 3:
								title_mode=6;
								keyreleased=false;
								option_selected=0;
								break;
							case 4:
								save_config();
								title_mode=2;
								keyreleased=false;
								option_selected=0;
								break;
						}	
					}	
				}				
				if(input_pressed())
				{
					keyreleased=false;
				}
				else
				{
					keyreleased=true;
				}
				
				break;					
			case 6:
				textout_ex(display,gamefont,"REDEFINE KEYS",270,100,-1,-1);

				for(int keysdisplays=0; keysdisplays<number_of_redefs_displayed; keysdisplays++)
				{
					textout_ex(display,gamefont,keynames[keysdisplays].c_str(),230,200+(keysdisplays*50),-1,-1);
					if(keysdisplays<number_of_redefs_displayed-1)
					{
						textout_ex(display,gamefont,keydescriptors[keysdefined[keysdisplays]].c_str(),460,200+(keysdisplays*50),-1,-1);
					}
				}
					
				for(int scanned_keys=1; scanned_keys<KEY_MAX; scanned_keys++)
				{
					if(key[scanned_keys]&&keyreleased)
					{
						keysdefined[number_of_redefs_displayed-1]=scanned_keys;
						number_of_redefs_displayed++;
						play_sample(select_sound,sfx_volume,128,1000,0);
					}
				}
					
				if(number_of_redefs_displayed>7)
				{
					title_mode=5;
					number_of_redefs_displayed=1;
				}
			
				if(input_pressed())
				{
					keyreleased=false;
				}
				else
				{
					keyreleased=true;
				}
				break;
			
		}
		
		blit(display,screen,0,0,0,0,800,600);
	};
	
	destroy_bitmap(logobuffer);
	al_stop_duh(titlesongplayer);
	unload_duh(titlesong);	
	play_sample(letsgo,sfx_volume,128,1000,0);
};

void setup_credits_screen()
{	
	clear_to_color(credits,makecol16(255,0,255));
	
	textout_ex(credits,gamefont,"OPEN INVADERS",270,15,-1,-1);
	textout_ex(credits,gamefont,"VERSION 0.2",290,40,-1,-1);
	textout_ex(credits,gamefont,"(C) 2006 - 2007 JAMYSKIS",160,70,-1,-1);
	textout_ex(credits,gamefont,"PROGRAMMING",30,115,-1,-1);
	textout_ex(credits,gamefont,"DESIGN",30,135,-1,-1);
	textout_ex(credits,gamefont,"GRAPHICS",30,155,-1,-1);
	textout_ex(credits,gamefont,"VOICE ACTING",30,175,-1,-1);
	textout_ex(credits,gamefont,"LOGO FONT",30,210,-1,-1);
	textout_ex(credits,gamefont,"GAME FONT",30,240,-1,-1);
	textout_ex(credits,gamefont,"COLLISION DETECTION",30,270,-1,-1);
	textout_ex(credits,gamefont,"ALLEGRO LIBRARY",30,300,-1,-1);
	textout_ex(credits,gamefont,"MUSIC",30,330,-1,-1);
	textout_ex(credits,gamefont,"TESTING",30,400,-1,-1);
	textout_ex(credits,gamefont,"DARRYL LECOUNT",435,115,-1,-1);
	textout_ex(credits,gamefont,"JAKOB FISCHER",435,210,-1,-1);
	textout_ex(credits,gamefont,"CODY BOISCLAIR",435,240,-1,-1);
	textout_ex(credits,gamefont,"ORZ",435,270,-1,-1);
	textout_ex(credits,gamefont,"SHAWN HARGREAVES",435,300,-1,-1);
	textout_ex(credits,gamefont,"THE MASTER",435,330,-1,-1);
	textout_ex(credits,gamefont,"JID",435,350,-1,-1);
	textout_ex(credits,gamefont,"NOISE",435,370,-1,-1);
	textout_ex(credits,gamefont,"AMBER ADAMS",435,400,-1,-1);
	textout_ex(credits,gamefont,"THE LINUX GUY",435,420,-1,-1);
	textout_ex(credits,gamefont,"LAUREN MAGGS",435,440,-1,-1);
	textout_ex(credits,gamefont,"VISIT JAMYSKIS ONLINE",200,500,-1,-1);
	textout_ex(credits,gamefont,"AT WWW.JAMYSKIS.NET",220,530,-1,-1);
}
