// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _BRepGProp_Face_HeaderFile
#define _BRepGProp_Face_HeaderFile

#ifndef _BRepAdaptor_Surface_HeaderFile
#include <BRepAdaptor_Surface.hxx>
#endif
#ifndef _Geom2dAdaptor_Curve_HeaderFile
#include <Geom2dAdaptor_Curve.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _gp_Pnt2d_HeaderFile
#include <gp_Pnt2d.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _GeomAbs_IsoType_HeaderFile
#include <GeomAbs_IsoType.hxx>
#endif
#ifndef _Handle_TColStd_HArray1OfReal_HeaderFile
#include <Handle_TColStd_HArray1OfReal.hxx>
#endif
class TopoDS_Face;
class TColStd_Array1OfReal;
class gp_Pnt;
class gp_Vec;
class TopoDS_Edge;
class gp_Pnt2d;
class gp_Vec2d;
class TColStd_HArray1OfReal;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class BRepGProp_Face  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Constructor. Initializes the object with a flag IsUseSpan <br>
//!          that says if it is necessary to define spans on a face. <br>
//!          This option has an effect only for BSpline faces. Spans <br>
//!          are returned by the methods GetUKnots and GetTKnots. <br>
BRepGProp_Face(const Standard_Boolean IsUseSpan = Standard_False);
//! Constructor. Initializes the object with the face and the <br>
//!          flag IsUseSpan that says if it is necessary to define <br>
//!          spans on a face. This option has an effect only for <br>
//!          BSpline faces. Spans are returned by the methods GetUKnots <br>
//!          and GetTKnots. <br>
BRepGProp_Face(const TopoDS_Face& F,const Standard_Boolean IsUseSpan = Standard_False);


Standard_EXPORT   void Load(const TopoDS_Face& F) ;


Standard_EXPORT   Standard_Integer VIntegrationOrder() const;
//! Returns Standard_True if the face is not trimmed. <br>
  Standard_Boolean NaturalRestriction() const;
//! Returns the value of the boundary curve of the face. <br>
  gp_Pnt2d Value2d(const Standard_Real U) const;


Standard_EXPORT   Standard_Integer SIntOrder(const Standard_Real Eps) const;


Standard_EXPORT   Standard_Integer SVIntSubs() const;


Standard_EXPORT   Standard_Integer SUIntSubs() const;


Standard_EXPORT   void UKnots(TColStd_Array1OfReal& Knots) const;


Standard_EXPORT   void VKnots(TColStd_Array1OfReal& Knots) const;


Standard_EXPORT   Standard_Integer LIntOrder(const Standard_Real Eps) const;


Standard_EXPORT   Standard_Integer LIntSubs() const;


Standard_EXPORT   void LKnots(TColStd_Array1OfReal& Knots) const;

//! Returns the number of points required to do the <br>
//!          integration in the U parametric direction with <br>
//!          a good accuracy. <br>
Standard_EXPORT   Standard_Integer UIntegrationOrder() const;

//! Returns the parametric bounds of the Face. <br>
Standard_EXPORT   void Bounds(Standard_Real& U1,Standard_Real& U2,Standard_Real& V1,Standard_Real& V2) const;

//! Computes the point of parameter U, V on the Face <S> and <br>
//!          the normal to the face at this point. <br>
Standard_EXPORT   void Normal(const Standard_Real U,const Standard_Real V,gp_Pnt& P,gp_Vec& VNor) const;

//! Loading the boundary arc. <br>
Standard_EXPORT   void Load(const TopoDS_Edge& E) ;
//! Returns the parametric value of the start point of <br>
//!          the current arc of curve. <br>
  Standard_Real FirstParameter() const;
//! Returns the parametric value of the end point of <br>
//!          the current arc of curve. <br>
  Standard_Real LastParameter() const;

//! Returns the number of points required to do the <br>
//!          integration along the parameter of curve. <br>
Standard_EXPORT   Standard_Integer IntegrationOrder() const;
//! Returns the point of parameter U and the first derivative <br>
//!          at this point of a boundary curve. <br>
  void D12d(const Standard_Real U,gp_Pnt2d& P,gp_Vec2d& V1) const;

//! Loading the boundary arc. This arc is either a top, bottom, <br>
//!          left or right bound of a UV rectangle in which the <br>
//!          parameters of surface are defined. <br>
//!          If IsFirstParam is equal to Standard_True, the face is <br>
//!          initialized by either left of bottom bound. Otherwise it is <br>
//!          initialized by the top or right one. <br>
//!          If theIsoType is equal to GeomAbs_IsoU, the face is <br>
//!          initialized with either left or right bound. Otherwise - <br>
//!          with either top or bottom one. <br>
Standard_EXPORT   void Load(const Standard_Boolean IsFirstParam,const GeomAbs_IsoType theIsoType) ;

//! Returns an array of U knots of the face. The first and last <br>
//!          elements of the array will be theUMin and theUMax. The <br>
//!          middle elements will be the U Knots of the face greater <br>
//!          then theUMin and lower then theUMax in increasing order. <br>
//!          If the face is not a BSpline, the array initialized with <br>
//!          theUMin and theUMax only. <br>
Standard_EXPORT   void GetUKnots(const Standard_Real theUMin,const Standard_Real theUMax,Handle(TColStd_HArray1OfReal)& theUKnots) const;

//! Returns an array of combination of T knots of the arc and <br>
//!          V knots of the face. The first and last elements of the <br>
//!          array will be theTMin and theTMax. The middle elements will <br>
//!          be the Knots of the arc and the values of parameters of <br>
//!          arc on which the value points have V coordinates close to V <br>
//!          knots of face. All the parameter will be greater then <br>
//!          theTMin and lower then theTMax in increasing order. <br>
//!          If the face is not a BSpline, the array initialized with <br>
//!          theTMin and theTMax only. <br>
Standard_EXPORT   void GetTKnots(const Standard_Real theTMin,const Standard_Real theTMax,Handle(TColStd_HArray1OfReal)& theTKnots) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
BRepAdaptor_Surface mySurface;
Geom2dAdaptor_Curve myCurve;
Standard_Boolean mySReverse;
Standard_Boolean myIsUseSpan;


};


#include <BRepGProp_Face.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
