// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GccInt_Bisec_HeaderFile
#define _GccInt_Bisec_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_GccInt_Bisec_HeaderFile
#include <Handle_GccInt_Bisec.hxx>
#endif

#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _GccInt_IType_HeaderFile
#include <GccInt_IType.hxx>
#endif
class Standard_DomainError;
class gp_Pnt2d;
class gp_Lin2d;
class gp_Circ2d;
class gp_Hypr2d;
class gp_Parab2d;
class gp_Elips2d;


//! The deferred class GccInt_Bisec is the root class for <br>
//! elementary bisecting loci between two simple geometric <br>
//! objects (i.e. circles, lines or points). <br>
//! Bisecting loci between two geometric objects are such <br>
//! that each of their points is at the same distance from the <br>
//! two geometric objects. It is typically a curve, such as a <br>
//! line, circle or conic. <br>
//! Generally there is more than one elementary object <br>
//! which is the solution to a bisecting loci problem: each <br>
//! solution is described with one elementary bisecting <br>
//! locus. For example, the bisectors of two secant straight <br>
//! lines are two perpendicular straight lines. <br>
//! The GccInt package provides concrete implementations <br>
//! of the following elementary derived bisecting loci: <br>
//! -   lines, circles, ellipses, hyperbolas and parabolas, and <br>
//! -   points (not used in this context). <br>
//! The GccAna package provides numerous algorithms for <br>
//! computing the bisecting loci between circles, lines or <br>
//! points, whose solutions are these types of elementary bisecting locus. <br>
class GccInt_Bisec : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Returns the type of bisecting object (line, circle, <br>
//! parabola, hyperbola, ellipse, point). <br>
Standard_EXPORT virtual  GccInt_IType ArcType() const = 0;

//! Returns the bisecting line when ArcType returns Pnt. <br>
//!          An exception DomainError is raised if ArcType is not a Pnt. <br>
Standard_EXPORT virtual  gp_Pnt2d Point() const;

//! Returns the bisecting line when ArcType returns Lin. <br>//! An exception DomainError is raised if ArcType is not a Lin. <br>
Standard_EXPORT virtual  gp_Lin2d Line() const;

//! Returns the bisecting line when ArcType returns Cir. <br>//! An exception DomainError is raised if ArcType is not a Cir. <br>
Standard_EXPORT virtual  gp_Circ2d Circle() const;

//! Returns the bisecting line when ArcType returns Hpr. <br>//! An exception DomainError is raised if ArcType is not a Hpr. <br>
Standard_EXPORT virtual  gp_Hypr2d Hyperbola() const;

//! Returns the bisecting line when ArcType returns Par. <br>//! An exception DomainError is raised if ArcType is not a Par. <br>
Standard_EXPORT virtual  gp_Parab2d Parabola() const;

//! Returns the bisecting line when ArcType returns Ell. <br>//! An exception DomainError is raised if ArcType is not an Ell. <br>
Standard_EXPORT virtual  gp_Elips2d Ellipse() const;
//Standard_EXPORT ~GccInt_Bisec();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
