// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _GeomAPI_ProjectPointOnSurf_HeaderFile
#define _GeomAPI_ProjectPointOnSurf_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Extrema_ExtPS_HeaderFile
#include <Extrema_ExtPS.hxx>
#endif
#ifndef _GeomAdaptor_Surface_HeaderFile
#include <GeomAdaptor_Surface.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Quantity_Parameter_HeaderFile
#include <Quantity_Parameter.hxx>
#endif
#ifndef _Quantity_Length_HeaderFile
#include <Quantity_Length.hxx>
#endif
class Standard_OutOfRange;
class StdFail_NotDone;
class gp_Pnt;
class Geom_Surface;
class Extrema_ExtPS;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


//! This class implements methods for  computing all the orthogonal <br>
//!  projections of a point onto a  surface. <br>
class GeomAPI_ProjectPointOnSurf  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Creates an empty object. Use the <br>
//! Init function for further initialization. <br>
Standard_EXPORT GeomAPI_ProjectPointOnSurf();

//! Create the projection  of a point <P> on a surface <br>
//!          <Surface> <br>
Standard_EXPORT GeomAPI_ProjectPointOnSurf(const gp_Pnt& P,const Handle(Geom_Surface)& Surface);

//! Create the projection  of a point <P> on a surface <br>
//!          <Surface> <br>//! Create the projection of a point <P>  on a surface <br>
//!          <Surface>. The solution are computed in the domain <br>
//!          [Umin,Usup] [Vmin,Vsup] of the surface. <br>
Standard_EXPORT GeomAPI_ProjectPointOnSurf(const gp_Pnt& P,const Handle(Geom_Surface)& Surface,const Standard_Real Tolerance);


Standard_EXPORT GeomAPI_ProjectPointOnSurf(const gp_Pnt& P,const Handle(Geom_Surface)& Surface,const Quantity_Parameter Umin,const Quantity_Parameter Usup,const Quantity_Parameter Vmin,const Quantity_Parameter Vsup,const Standard_Real Tolerance);

//! Init the projection  of a point <P> on a surface <br>
//!          <Surface> <br>
Standard_EXPORT GeomAPI_ProjectPointOnSurf(const gp_Pnt& P,const Handle(Geom_Surface)& Surface,const Quantity_Parameter Umin,const Quantity_Parameter Usup,const Quantity_Parameter Vmin,const Quantity_Parameter Vsup);


Standard_EXPORT   void Init(const gp_Pnt& P,const Handle(Geom_Surface)& Surface,const Standard_Real Tolerance) ;

//! Init the projection of a point <P>  on a surface <br>
//!          <Surface>. The solution are computed in the domain <br>
//!          [Umin,Usup] [Vmin,Vsup] of the surface. <br>
Standard_EXPORT   void Init(const gp_Pnt& P,const Handle(Geom_Surface)& Surface) ;


Standard_EXPORT   void Init(const gp_Pnt& P,const Handle(Geom_Surface)& Surface,const Quantity_Parameter Umin,const Quantity_Parameter Usup,const Quantity_Parameter Vmin,const Quantity_Parameter Vsup,const Standard_Real Tolerance) ;

//! Init the projection for many points on a surface <br>
//!          <Surface>. The solutions will be computed in the domain <br>
//!          [Umin,Usup] [Vmin,Vsup] of the surface. <br>
Standard_EXPORT   void Init(const gp_Pnt& P,const Handle(Geom_Surface)& Surface,const Quantity_Parameter Umin,const Quantity_Parameter Usup,const Quantity_Parameter Vmin,const Quantity_Parameter Vsup) ;


Standard_EXPORT   void Init(const Handle(Geom_Surface)& Surface,const Quantity_Parameter Umin,const Quantity_Parameter Usup,const Quantity_Parameter Vmin,const Quantity_Parameter Vsup,const Standard_Real Tolerance) ;


Standard_EXPORT   void Init(const Handle(Geom_Surface)& Surface,const Quantity_Parameter Umin,const Quantity_Parameter Usup,const Quantity_Parameter Vmin,const Quantity_Parameter Vsup) ;

//! Performs the projection of a point on the current surface. <br>
Standard_EXPORT   void Perform(const gp_Pnt& P) ;


Standard_EXPORT   Standard_Boolean IsDone() const;

//! Returns the number of computed orthogonal projection points. <br>
//! Note: if projection fails, NbPoints returns 0. <br>
Standard_EXPORT   Standard_Integer NbPoints() const;
Standard_EXPORT operator Standard_Integer() const;

//! Returns the orthogonal projection <br>
//! on the surface. Index is a number of a computed point. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ 1,NbPoints ], where <br>
//! NbPoints is the number of solution points. <br>
Standard_EXPORT   gp_Pnt Point(const Standard_Integer Index) const;

//! Returns the parameters (U,V) on the <br>
//! surface of the orthogonal projection. Index is a number of a <br>
//! computed point. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ 1,NbPoints ], where <br>
//! NbPoints is the number of solution points. <br>
Standard_EXPORT   void Parameters(const Standard_Integer Index,Quantity_Parameter& U,Quantity_Parameter& V) const;

//! Computes the distance between the <br>
//! point and its orthogonal projection on the surface. Index is a number <br>
//! of a computed point. <br>
//! Exceptions <br>
//! Standard_OutOfRange if Index is not in the range [ 1,NbPoints ], where <br>
//! NbPoints is the number of solution points. <br>
Standard_EXPORT   Quantity_Length Distance(const Standard_Integer Index) const;

//! Returns the nearest orthogonal projection of the point <br>
//! on the surface. <br>
//! Exceptions <br>
//! StdFail_NotDone if projection fails. <br>
Standard_EXPORT   gp_Pnt NearestPoint() const;
Standard_EXPORT operator gp_Pnt() const;

//! Returns the parameters (U,V) on the <br>
//! surface of the nearest computed orthogonal projection of the point. <br>
//! Exceptions <br>
//! StdFail_NotDone if projection fails. <br>
Standard_EXPORT   void LowerDistanceParameters(Quantity_Parameter& U,Quantity_Parameter& V) const;

//! Computes the distance between the <br>
//! point and its nearest orthogonal projection on the surface. <br>
//! Exceptions <br>
//! StdFail_NotDone if projection fails. <br>
Standard_EXPORT   Quantity_Length LowerDistance() const;
Standard_EXPORT operator Standard_Real() const;
//! return the algorithmic object from Extrema <br>
 const Extrema_ExtPS& Extrema() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void Init() ;


 // Fields PRIVATE
 //
Standard_Boolean myIsDone;
Standard_Integer myIndex;
Extrema_ExtPS myExtPS;
GeomAdaptor_Surface myGeomAdaptor;


};


#include <GeomAPI_ProjectPointOnSurf.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
