// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _IFSelect_Functions_HeaderFile
#define _IFSelect_Functions_HeaderFile

#ifndef _Handle_Standard_Transient_HeaderFile
#include <Handle_Standard_Transient.hxx>
#endif
#ifndef _Handle_IFSelect_WorkSession_HeaderFile
#include <Handle_IFSelect_WorkSession.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_TColStd_HSequenceOfTransient_HeaderFile
#include <Handle_TColStd_HSequenceOfTransient.hxx>
#endif
#ifndef _Handle_IFSelect_Dispatch_HeaderFile
#include <Handle_IFSelect_Dispatch.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Standard_Transient;
class IFSelect_WorkSession;
class TColStd_HSequenceOfTransient;
class IFSelect_Dispatch;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Functions gives access to all the actions which can be <br>
//!           commanded with the resources provided by IFSelect : especially <br>
//!           WorkSession and various types of Selections and Dispatches <br>
//! <br>
//!           It works by adding functions by method Init <br>
class IFSelect_Functions  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Takes the name of an entity, either as argument, or (if <name> <br>
//!           is empty) on keybord, and returns the entity <br>
//!           name can be a label or a number (in alphanumeric), it is <br>
//!           searched by NumberFromLabel from WorkSession. <br>
//!           If <name> doesn't match en entity, a Null Handle is returned <br>
Standard_EXPORT static  Handle_Standard_Transient GiveEntity(const Handle(IFSelect_WorkSession)& WS,const Standard_CString name = "") ;

//! Same as GetEntity, but returns the number in the model of the <br>
//!           entity. Returns 0 for null handle <br>
Standard_EXPORT static  Standard_Integer GiveEntityNumber(const Handle(IFSelect_WorkSession)& WS,const Standard_CString name = "") ;

//! Computes a List of entities from a WorkSession and two idents, <br>
//!           first and second, as follows : <br>
//!           if <first> is a Number or Label of an entity : this entity <br>
//!           if <first> is the name of a Selection in <WS>, and <second> <br>
//!             not defined, the standard result of this Selection <br>
//!           if <first> is for a Selection and <second> is defined, the <br>
//!             standard result of this selection from the list computed <br>
//!             with <second> (an entity or a selection) <br>
//!           If <second> is erroneous, it is ignored <br>
Standard_EXPORT static  Handle_TColStd_HSequenceOfTransient GiveList(const Handle(IFSelect_WorkSession)& WS,const Standard_CString first = "",const Standard_CString second = "") ;

//! Evaluates and returns a Dispatch, from data of a WorkSession <br>
//!           if <mode> is False, searches for exact name of Dispatch in WS <br>
//!           Else (D), allows a parameter between brackets : <br>
//!           ex.: dispatch_name(parameter) <br>
//!           The parameter can be: an integer for DispPerCount or DispPerFiles <br>
//!           or the name of a Signature for DispPerSignature <br>
//!           Returns Null Handle if not found not well evaluated <br>
Standard_EXPORT static  Handle_IFSelect_Dispatch GiveDispatch(const Handle(IFSelect_WorkSession)& WS,const Standard_CString name,const Standard_Boolean mode = Standard_True) ;

//! Defines and loads all basic functions (as ActFunc) <br>
Standard_EXPORT static  void Init() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
