// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _LocOpe_SplitDrafts_HeaderFile
#define _LocOpe_SplitDrafts_HeaderFile

#ifndef _TopoDS_Shape_HeaderFile
#include <TopoDS_Shape.hxx>
#endif
#ifndef _TopTools_DataMapOfShapeListOfShape_HeaderFile
#include <TopTools_DataMapOfShapeListOfShape.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class StdFail_NotDone;
class Standard_NoSuchObject;
class Standard_ConstructionError;
class Standard_NullObject;
class TopoDS_Shape;
class TopoDS_Face;
class TopoDS_Wire;
class gp_Dir;
class gp_Pln;
class TopTools_ListOfShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! This  class  provides  a    tool to   realize  the <br>
//!          following operations on a shape : <br>
//!           - split a face of the shape with a wire, <br>
//!           - put draft angle on both side of the wire. <br>
//!          For each side, the draft angle may be different. <br>
class LocOpe_SplitDrafts  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 
//! Empty constructor. <br>
LocOpe_SplitDrafts();
//! Creates the algoritm on the shape <S>. <br>
LocOpe_SplitDrafts(const TopoDS_Shape& S);

//! Initializes the algoritm with the shape <S>. <br>
Standard_EXPORT   void Init(const TopoDS_Shape& S) ;

//! Splits the face <F> of the former given shape with <br>
//!          the wire  <W>.  The wire is  assumed to lie on the <br>
//!          face.    Puts a draft  angle on  both parts of the <br>
//!          wire.    <Extractg>,  <Nplg>, <Angleg> define  the <br>
//!          arguments  for   the   left  part   of the   wire. <br>
//!          <Extractd>,  <Npld>, <Angled> define the arguments <br>
//!          for the right part of the wire. The draft angle is <br>
//!          measured    with the  direction  <Extract>.  <Npl> <br>
//!          defines the neutral plane (points belonging to the <br>
//!          neutral plane are not  modified).  <Angle> is  the <br>
//!          value of the draft  angle.  If <ModifyLeft> is set <br>
//!          to <Standard_False>, no draft  angle is applied to <br>
//!          the left part of the wire. If <ModifyRight> is set <br>
//!          to <Standard_False>,no draft  angle  is applied to <br>
//!          the right part of the wire. <br>
//! <br>
//! <br>
Standard_EXPORT   void Perform(const TopoDS_Face& F,const TopoDS_Wire& W,const gp_Dir& Extractg,const gp_Pln& NPlg,const Standard_Real Angleg,const gp_Dir& Extractd,const gp_Pln& NPld,const Standard_Real Angled,const Standard_Boolean ModifyLeft = Standard_True,const Standard_Boolean ModifyRight = Standard_True) ;

//! Splits the face <F> of the former given shape with <br>
//!          the  wire <W>.  The wire is  assumed to lie on the <br>
//!          face.  Puts a draft angle  on the left part of the <br>
//!          wire.   The draft    angle is   measured  with the <br>
//!          direction  <Extract>.   <Npl> defines the  neutral <br>
//!          plane (points belonging  to the neutral plane  are <br>
//!          not modified). <Angle> is  the value of  the draft <br>
//!          angle. <br>
Standard_EXPORT   void Perform(const TopoDS_Face& F,const TopoDS_Wire& W,const gp_Dir& Extract,const gp_Pln& NPl,const Standard_Real Angle) ;
//! Returns <Standard_True>  if the  modification  has <br>
//!          been succesfully performed. <br>
  Standard_Boolean IsDone() const;

 const TopoDS_Shape& OriginalShape() const;

//! Returns the modified shape. <br>
Standard_EXPORT  const TopoDS_Shape& Shape() const;

//! Manages the descendant shapes. <br>
Standard_EXPORT  const TopTools_ListOfShape& ShapesFromShape(const TopoDS_Shape& S) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TopoDS_Shape myShape;
TopoDS_Shape myResult;
TopTools_DataMapOfShapeListOfShape myMap;


};


#include <LocOpe_SplitDrafts.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
