// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _MeshVS_DeformedDataSource_HeaderFile
#define _MeshVS_DeformedDataSource_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_MeshVS_DeformedDataSource_HeaderFile
#include <Handle_MeshVS_DeformedDataSource.hxx>
#endif

#ifndef _Handle_MeshVS_DataSource_HeaderFile
#include <Handle_MeshVS_DataSource.hxx>
#endif
#ifndef _TColStd_PackedMapOfInteger_HeaderFile
#include <TColStd_PackedMapOfInteger.hxx>
#endif
#ifndef _MeshVS_DataMapOfIntegerVector_HeaderFile
#include <MeshVS_DataMapOfIntegerVector.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _MeshVS_DataSource_HeaderFile
#include <MeshVS_DataSource.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MeshVS_EntityType_HeaderFile
#include <MeshVS_EntityType.hxx>
#endif
#ifndef _Handle_MeshVS_HArray1OfSequenceOfInteger_HeaderFile
#include <Handle_MeshVS_HArray1OfSequenceOfInteger.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
class MeshVS_DataSource;
class TColStd_Array1OfReal;
class MeshVS_HArray1OfSequenceOfInteger;
class TColStd_Array1OfInteger;
class MeshVS_DataMapOfIntegerVector;
class gp_Vec;


//! The class provides default class which helps to represent node displacements by deformed mesh <br>
//!    This class has an internal handle to canonical non-deformed mesh data source and <br>
//! map of displacement vectors. The displacement can be magnified to useful size. <br>
//! All methods is implemented with calling the corresponding methods of non-deformed data source. <br>
class MeshVS_DeformedDataSource : public MeshVS_DataSource {

public:
 // Methods PUBLIC
 // 

//!  Constructor <br>
//! theNonDeformDS is canonical non-deformed data source, by which we are able to calculate <br>
//!   deformed mesh geometry <br>
//! theMagnify is coefficient of displacement magnify <br>
Standard_EXPORT MeshVS_DeformedDataSource(const Handle(MeshVS_DataSource)& theNonDeformDS,const Standard_Real theMagnify);


Standard_EXPORT virtual  Standard_Boolean GetGeom(const Standard_Integer ID,const Standard_Boolean IsElement,TColStd_Array1OfReal& Coords,Standard_Integer& NbNodes,MeshVS_EntityType& Type) const;


Standard_EXPORT virtual  Standard_Boolean GetGeomType(const Standard_Integer ID,const Standard_Boolean IsElement,MeshVS_EntityType& Type) const;


Standard_EXPORT virtual  Standard_Boolean Get3DGeom(const Standard_Integer ID,Standard_Integer& NbNodes,Handle(MeshVS_HArray1OfSequenceOfInteger)& Data) const;


Standard_EXPORT virtual  Standard_Address GetAddr(const Standard_Integer ID,const Standard_Boolean IsElement) const;


Standard_EXPORT virtual  Standard_Boolean GetNodesByElement(const Standard_Integer ID,TColStd_Array1OfInteger& NodeIDs,Standard_Integer& NbNodes) const;


Standard_EXPORT virtual const TColStd_PackedMapOfInteger& GetAllNodes() const;


Standard_EXPORT virtual const TColStd_PackedMapOfInteger& GetAllElements() const;

//! This method returns map of nodal displacement vectors <br>
Standard_EXPORT  const MeshVS_DataMapOfIntegerVector& GetVectors() const;

//! This method sets map of nodal displacement vectors (Map). <br>
Standard_EXPORT   void SetVectors(const MeshVS_DataMapOfIntegerVector& Map) ;

//! This method returns vector ( Vect ) assigned to node number ID. <br>
Standard_EXPORT   Standard_Boolean GetVector(const Standard_Integer ID,gp_Vec& Vect) const;

//! This method sets vector ( Vect ) assigned to node number ID. <br>
Standard_EXPORT   void SetVector(const Standard_Integer ID,const gp_Vec& Vect) ;


Standard_EXPORT   void SetNonDeformedDataSource(const Handle(MeshVS_DataSource)& theDS) ;

//! With this methods you can read and change internal canonical data source <br>
Standard_EXPORT   Handle_MeshVS_DataSource GetNonDeformedDataSource() const;


Standard_EXPORT   void SetMagnify(const Standard_Real theMagnify) ;

//! With this methods you can read and change magnify coefficient of nodal displacements <br>
Standard_EXPORT   Standard_Real GetMagnify() const;
//Standard_EXPORT ~MeshVS_DeformedDataSource();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Handle_MeshVS_DataSource myNonDeformedDataSource;
TColStd_PackedMapOfInteger myEmptyMap;
MeshVS_DataMapOfIntegerVector myVectors;
Standard_Real myMagnify;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
