// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _OSD_Timer_HeaderFile
#define _OSD_Timer_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Address_HeaderFile
#include <Standard_Address.hxx>
#endif
#ifndef _OSD_Chronometer_HeaderFile
#include <OSD_Chronometer.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Working on heterogeneous platforms <br>
//! we need to use the system call gettimeofday. <br>
//! This function is portable and it measures ELAPSED <br>
//! time and CPU time in seconds and microseconds. <br>
//! Example: OSD_Timer aTimer; <br>
//!          aTimer.Start();   // Start  the timers (t1). <br>
//!           .....            // Do something. <br>
//!          aTimer.Stop();    // Stop the timers (t2). <br>
//!          aTimer.Show();    // Give the elapsed time between t1 and t2. <br>
//!                            // Give also the process CPU time between <br>
//!                            // t1 and t2. <br>
class OSD_Timer  : public OSD_Chronometer {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Builds a Chronometer initialized and stopped. <br>
Standard_EXPORT OSD_Timer();


Standard_EXPORT virtual  void Destroy() ;
Standard_EXPORT virtual ~OSD_Timer(){Destroy();}

//! Stops and reinitializes the timer. <br>
Standard_EXPORT virtual  void Reset() ;

//! Shows both the elapsed time and CPU time on the standard output <br>
//!          stream <cout>.The chronometer can be running (Lap Time) or <br>
//!          stopped. <br>
Standard_EXPORT virtual  void Show() ;

//! Shows both the elapsed time and CPU  time on the <br>
//!          output stream <OS>. <br>
Standard_EXPORT virtual  void Show(Standard_OStream& os) ;

//! returns both the elapsed time(seconds,minutes,hours) <br>
//!          and CPU  time. <br>
Standard_EXPORT   void Show(Standard_Real& seconds,Standard_Integer& minutes,Standard_Integer& hours,Standard_Real& CPUtime) ;

//! Stops the Timer. <br>
Standard_EXPORT virtual  void Stop() ;

//! Starts (after Create or Reset) or restarts (after Stop) <br>
//!          the Timer. <br>
Standard_EXPORT virtual  void Start() ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Integer TimeCumulInt;
Standard_Integer MicroCumulInt;
Standard_Real TimeCumul;
Standard_Real MicroCumul;
Standard_Address RefToInitialTimeB;
Standard_Address RefToCurrentTimeB;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
