// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Plate_FreeGtoCConstraint_HeaderFile
#define _Plate_FreeGtoCConstraint_HeaderFile

#ifndef _gp_XY_HeaderFile
#include <gp_XY.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Plate_PinpointConstraint_HeaderFile
#include <Plate_PinpointConstraint.hxx>
#endif
#ifndef _Plate_LinearScalarConstraint_HeaderFile
#include <Plate_LinearScalarConstraint.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
class gp_XY;
class Plate_D1;
class Plate_D2;
class Plate_D3;
class Plate_PinpointConstraint;
class Plate_LinearScalarConstraint;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! define a G1, G2 or G3 constraint on the Plate using weaker <br>
//!          constraint than GtoCConstraint <br>
//! <br>
class Plate_FreeGtoCConstraint  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT Plate_FreeGtoCConstraint(const gp_XY& point2d,const Plate_D1& D1S,const Plate_D1& D1T,const Standard_Real IncrementalLoad = 1.0,const Standard_Integer orientation = 0);


Standard_EXPORT Plate_FreeGtoCConstraint(const gp_XY& point2d,const Plate_D1& D1S,const Plate_D1& D1T,const Plate_D2& D2S,const Plate_D2& D2T,const Standard_Real IncrementalLoad = 1.0,const Standard_Integer orientation = 0);


Standard_EXPORT Plate_FreeGtoCConstraint(const gp_XY& point2d,const Plate_D1& D1S,const Plate_D1& D1T,const Plate_D2& D2S,const Plate_D2& D2T,const Plate_D3& D3S,const Plate_D3& D3T,const Standard_Real IncrementalLoad = 1.0,const Standard_Integer orientation = 0);

 const Standard_Integer& nb_PPC() const;

 const Plate_PinpointConstraint& GetPPC(const Standard_Integer Index) const;

 const Standard_Integer& nb_LSC() const;

 const Plate_LinearScalarConstraint& LSC(const Standard_Integer Index) const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
gp_XY pnt2d;
Standard_Integer nb_PPConstraints;
Standard_Integer nb_LSConstraints;
Plate_PinpointConstraint myPPC[5];
Plate_LinearScalarConstraint myLSC[4];


};


#include <Plate_FreeGtoCConstraint.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
