// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _ProjLib_HeaderFile
#define _ProjLib_HeaderFile

class gp_Pnt2d;
class gp_Pln;
class gp_Pnt;
class gp_Lin2d;
class gp_Lin;
class gp_Circ2d;
class gp_Circ;
class gp_Elips2d;
class gp_Elips;
class gp_Parab2d;
class gp_Parab;
class gp_Hypr2d;
class gp_Hypr;
class gp_Cylinder;
class gp_Cone;
class gp_Sphere;
class gp_Torus;
class ProjLib_ProjectOnPlane;
class ProjLib_ProjectOnSurface;
class ProjLib_ComputeApprox;
class ProjLib_ComputeApproxOnPolarSurface;
class ProjLib_ProjectedCurve;
class ProjLib_HProjectedCurve;
class ProjLib_SequenceOfHSequenceOfPnt;
class ProjLib_HSequenceOfHSequenceOfPnt;
class ProjLib_CompProjectedCurve;
class ProjLib_HCompProjectedCurve;
class ProjLib_PrjResolve;
class ProjLib_PrjFunc;
class ProjLib_Projector;
class ProjLib_Plane;
class ProjLib_Cylinder;
class ProjLib_Cone;
class ProjLib_Sphere;
class ProjLib_Torus;
class ProjLib_SequenceNodeOfSequenceOfHSequenceOfPnt;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The  projLib package  first provides projection of <br>
//!          curves on a   plane along a  given Direction.  The <br>
//!          result will be a 3D curve. <br>//! The ProjLib package  provides projection of curves <br>
//!          on surfaces to compute the curve in the parametric <br>
//!          space. <br>
//! <br>
//!          It is assumed that the curve is on the surface. <br>
//! <br>
//!          It provides : <br>
//! <br>
//!          * Package methods to handle the easiest cases : <br>
//! <br>
//!            - Line, Circle, Ellipse, Parabola, Hyperbola on plane. <br>
//! <br>
//!            - Line, Circle on cylinder. <br>
//! <br>
//!            - Line, Circle on cone. <br>
//! <br>
//!          * Classes to handle the general cases : <br>
//! <br>
//!            - Plane. <br>
//! <br>
//!            - Cylinder. <br>
//! <br>
//!            - Cone. <br>
//! <br>
//!            - Sphere. <br>
//! <br>
//!            - Torus. <br>
//! <br>
//! <br>
//!          * A generic  class to handle  a Curve from Adaptor3d <br>
//!          on a Surface from Adaptor3d. <br>
//! <br>
class ProjLib  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT static  gp_Pnt2d Project(const gp_Pln& Pl,const gp_Pnt& P) ;


Standard_EXPORT static  gp_Lin2d Project(const gp_Pln& Pl,const gp_Lin& L) ;


Standard_EXPORT static  gp_Circ2d Project(const gp_Pln& Pl,const gp_Circ& C) ;


Standard_EXPORT static  gp_Elips2d Project(const gp_Pln& Pl,const gp_Elips& E) ;


Standard_EXPORT static  gp_Parab2d Project(const gp_Pln& Pl,const gp_Parab& P) ;


Standard_EXPORT static  gp_Hypr2d Project(const gp_Pln& Pl,const gp_Hypr& H) ;


Standard_EXPORT static  gp_Pnt2d Project(const gp_Cylinder& Cy,const gp_Pnt& P) ;


Standard_EXPORT static  gp_Lin2d Project(const gp_Cylinder& Cy,const gp_Lin& L) ;


Standard_EXPORT static  gp_Lin2d Project(const gp_Cylinder& Cy,const gp_Circ& Ci) ;


Standard_EXPORT static  gp_Pnt2d Project(const gp_Cone& Co,const gp_Pnt& P) ;


Standard_EXPORT static  gp_Lin2d Project(const gp_Cone& Co,const gp_Lin& L) ;


Standard_EXPORT static  gp_Lin2d Project(const gp_Cone& Co,const gp_Circ& Ci) ;


Standard_EXPORT static  gp_Pnt2d Project(const gp_Sphere& Sp,const gp_Pnt& P) ;


Standard_EXPORT static  gp_Lin2d Project(const gp_Sphere& Sp,const gp_Circ& Ci) ;


Standard_EXPORT static  gp_Pnt2d Project(const gp_Torus& To,const gp_Pnt& P) ;


Standard_EXPORT static  gp_Lin2d Project(const gp_Torus& To,const gp_Circ& Ci) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class ProjLib_ProjectOnPlane;
friend class ProjLib_ProjectOnSurface;
friend class ProjLib_ComputeApprox;
friend class ProjLib_ComputeApproxOnPolarSurface;
friend class ProjLib_ProjectedCurve;
friend class ProjLib_HProjectedCurve;
friend class ProjLib_SequenceOfHSequenceOfPnt;
friend class ProjLib_HSequenceOfHSequenceOfPnt;
friend class ProjLib_CompProjectedCurve;
friend class ProjLib_HCompProjectedCurve;
friend class ProjLib_PrjResolve;
friend class ProjLib_PrjFunc;
friend class ProjLib_Projector;
friend class ProjLib_Plane;
friend class ProjLib_Cylinder;
friend class ProjLib_Cone;
friend class ProjLib_Sphere;
friend class ProjLib_Torus;
friend class ProjLib_SequenceNodeOfSequenceOfHSequenceOfPnt;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
