
#include <BRepClass_FaceClassifier.ixx>
#include <TopAbs_State.hxx>
#include <Extrema_ExtPS.hxx>


BRepClass_FaceClassifier::BRepClass_FaceClassifier()
{
}

BRepClass_FaceClassifier::BRepClass_FaceClassifier(BRepClass_FaceExplorer& F, 
						   const gp_Pnt2d& P, 
						   const Standard_Real Tol) :
       BRepClass_FClassifier(F,P,Tol)
{
}

BRepClass_FaceClassifier::BRepClass_FaceClassifier(const TopoDS_Face& F, 
						   const gp_Pnt2d& P, 
						   const Standard_Real Tol)
{
  Perform(F,P,Tol);
}

void  BRepClass_FaceClassifier::Perform(const TopoDS_Face& F, 
					const gp_Pnt2d& P, 
					const Standard_Real Tol)
{
  BRepClass_FaceExplorer Fex(F);
  BRepClass_FClassifier::Perform(Fex,P,Tol);
}


BRepClass_FaceClassifier::BRepClass_FaceClassifier(const TopoDS_Face& F, 
						   const gp_Pnt& P, 
						   const Standard_Real Tol)
{
  Perform(F,P,Tol);
}


#include <BRepAdaptor_Surface.hxx>
#include <BRepTools.hxx>
#include <BRepAdaptor_HSurface.hxx>

void  BRepClass_FaceClassifier::Perform(const TopoDS_Face& face, 
					const gp_Pnt& P, 
					const Standard_Real Tol)
{
  //-- Voir BRepExtrema_ExtPF.cxx 
  BRepAdaptor_Surface Surf(face);
  //-- Handle(BRepAdaptor_HSurface) HS = new BRepAdaptor_HSurface(Surf);
  Standard_Real U1, U2, V1, V2;
  BRepTools::UVBounds(face, U1, U2, V1, V2);
  Extrema_ExtPS myExtrem;
  //-- myExtrem.Initialize(HS, U1, U2, V1, V2, Tol, Tol);
  myExtrem.Initialize(Surf, U1, U2, V1, V2, Tol, Tol);
  //----------------------------------------------------------
  //-- On cherche le point le plus proche , PUIS 
  //-- On le classifie. 
//  Standard_Integer nbv    =  myExtrem.NbExt();
  Standard_Integer nbv    = 0; // xpu
  Standard_Real MaxDist   =  RealLast();
  Standard_Integer indice = 0;
  if(myExtrem.IsDone()) {
    nbv = myExtrem.NbExt();
    for (Standard_Integer i = 1; i <= nbv; i++) {
      Standard_Real d = myExtrem.Value(i);
      d = Abs(d);
      if(d <= MaxDist) { 
	MaxDist = d;
	indice = i;
      }
    }
  }
  if(indice) { 
    gp_Pnt2d Puv;
    Standard_Real U1,U2;
    myExtrem.Point(indice).Parameter(U1, U2);
    Puv.SetCoord(U1, U2);
    Perform(face, Puv, Tol);
  }
  else { 
    Perform(face, gp_Pnt2d(U1-1.0,V1 - 1.0), Tol); //-- NYI etc BUG PAS BEAU En attendant l acces a rejected
    //-- le resultat est TopAbs_OUT;
  }
}







