// AISDisplayModeDoc.cpp : implementation of the CAISDisplayModeDoc class
//

#include "stdafx.h"

#include "AISDisplayModeDoc.h"

#include "AISDisplayModeApp.h"
#include "DlgIsos.h"
#include "DlgAttributes.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include <Graphic3d_NameOfMaterial.hxx>

DlgAttributes boxattrib;
Standard_Boolean FIRST = Standard_True;

/////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeDoc

IMPLEMENT_DYNCREATE(CAISDisplayModeDoc, CDocument)

BEGIN_MESSAGE_MAP(CAISDisplayModeDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CAISDisplayModeDoc)
	ON_COMMAND(ID_BOX, OnBox)
	ON_COMMAND(ID_SHADING, OnShading)
	ON_COMMAND(ID_WIREFRAME, OnWireframe)
	ON_COMMAND(ID_SPHERE, OnSphere)
	ON_COMMAND(ID_USERCYLINDER, OnUsercylinder)
	ON_COMMAND(ID_NBISOS, OnNbisos)
	ON_COMMAND(ID_ERASE_ALL, OnEraseAll)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAISDisplayModeDoc construction/destruction


CAISDisplayModeDoc::CAISDisplayModeDoc()
{
	myAISContext->DefaultDrawer()->ShadingAspect()->SetColor(Quantity_NOC_CHARTREUSE1); 
	myAISContext->DefaultDrawer()->ShadingAspect()->SetMaterial(Graphic3d_NOM_SILVER);
	if (FIRST) {
		boxattrib.Create(DlgAttributes::IDD, NULL);
		FIRST = Standard_False;
	}
	boxattrib.Set(myAISContext, myCResultDialog);
}

CAISDisplayModeDoc::~CAISDisplayModeDoc()
{
}


void CAISDisplayModeDoc::OnBox() 
{
	BRepPrimAPI_MakeBox B(gp_Pnt(-400.,-400.,-100.),200.,150.,100.);
	Handle(AIS_Shape) aBox = new AIS_Shape(B.Shape());
	myAISContext->SetMaterial(aBox,Graphic3d_NOM_BRONZE);
	//myAISContext->SetDisplayMode(aBox,1,Standard_False);
	myAISContext->Display(aBox);

TCollection_AsciiString Message ("\
BRepAPI_MakeBox B(gp_Pnt(-400.,-400.,-100.),200.,150.,100.);   \n\
\n\
Handle(AIS_Shape) aBox = new AIS_Shape(B.Shape());  \n\
\n\
myAISContext->Display(aBox);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a box"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a box"));
}

void CAISDisplayModeDoc::OnSphere() 
{
	BRepPrimAPI_MakeSphere S(gp_Pnt(200.,300.,200.), 100.);
	Handle(AIS_Shape) anAISShape = new AIS_Shape(S.Shape());
	myAISContext->SetMaterial(anAISShape,Graphic3d_NOM_COPPER);
	//myAISContext->SetDisplayMode(anAISShape,1,Standard_False);

	myAISContext->Display(anAISShape);	
	
TCollection_AsciiString Message ("\
BRepAPI_MakeSphere S(gp_Pnt(200.,300.,200.), 100.);   \n\
\n\
Handle(AIS_Shape) anAISShape = new AIS_Shape(S.Shape());  \n\
\n\
myAISContext->Display(anAISShape);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a sphere"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a sphere"));
}

void CAISDisplayModeDoc::OnUsercylinder() 
{
	Handle(User_Cylinder) aCyl = new User_Cylinder(100.,200.);
	myAISContext->SetDisplayMode(aCyl,1);
	myAISContext->Display(aCyl);		
	
TCollection_AsciiString Message ("\
Handle(User_Cylinder) aCyl = new User_Cylinder(100.,200.);  \n\
\n\
myAISContext->SetDisplayMode(aCyl,1);  \n\
\n\
myAISContext->Display(aCyl); \n\
\n\
NOTE: a User_Cylinder is an object defined by the user.  \n\
The User_Cylinder class inherit from the AIS_InteractiveObject   \n\
Cascade class, it's use is the same as an AIS_InteractiveObject.   \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Create a cylinder"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Create a cylinder"));
}


void CAISDisplayModeDoc::OnShading() 
{
	myAISContext->SetDisplayMode(AIS_Shaded);	
TCollection_AsciiString Message ("\
myAISContext->SetDisplayMode(AIS_Shaded);	\n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Shading"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Shading"));
}

void CAISDisplayModeDoc::OnWireframe() 
{
	
	myAISContext->SetDisplayMode(AIS_WireFrame);	
TCollection_AsciiString Message ("\
myAISContext->SetDisplayMode(AIS_WireFrame);	\n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Wireframe"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Wireframe"));
}


void CAISDisplayModeDoc::OnNbisos() 
{
	int nu = myAISContext->DefaultDrawer()->UIsoAspect()->Number();
	int nv = myAISContext->DefaultDrawer()->VIsoAspect()->Number();
	DlgIsos dlg(NULL,nu,nv);
	if (dlg.DoModal() == IDOK) {
		myAISContext->DefaultDrawer()->UIsoAspect()->SetNumber(dlg.m_isou);
		myAISContext->DefaultDrawer()->VIsoAspect()->SetNumber(dlg.m_isov);

TCollection_AsciiString Message ("\
myAISContext->DefaultDrawer()->UIsoAspect()->SetNumber(dlg.m_isou);  \n\
\n\
myAISContext->DefaultDrawer()->VIsoAspect()->SetNumber(dlg.m_isov);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Iso Aspect"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Iso Aspect"));

	}
}

void CAISDisplayModeDoc::OnEraseAll() 
{
	myAISContext->EraseAll(Standard_False); 

TCollection_AsciiString Message ("\
myAISContext->EraseAll(Standard_False);  \n\
\n");

	CString text(Message.ToCString());
	myCResultDialog.SetTitle(CString("Erase all"));
	myCResultDialog.SetText(text);
	SetTitle(CString("Erase all"));
}

void  CAISDisplayModeDoc::Popup(const Standard_Integer  x,
							   const Standard_Integer  y ,
                               const Handle(V3d_View)& aView   ) 
{
  Standard_Integer PopupMenuNumber=0;
 myAISContext->InitCurrent();
  if (myAISContext->MoreCurrent()) {
		if (myAISContext->Current()->IsKind(STANDARD_TYPE(User_Cylinder)))
			return;
		else 
			PopupMenuNumber = 1;
	}

  CMenu menu;
  VERIFY(menu.LoadMenu(IDR_Popup3D));
  CMenu* pPopup = menu.GetSubMenu(PopupMenuNumber);

  ASSERT(pPopup != NULL);
   if (PopupMenuNumber == 1) // more than 1 object.
  {
    bool OneOrMoreInShading = false;
	for (myAISContext->InitCurrent();myAISContext->MoreCurrent ();myAISContext->NextCurrent ())
    if (myAISContext->IsDisplayed(myAISContext->Current(),1)) OneOrMoreInShading=true;
	if(!OneOrMoreInShading)
   	pPopup->EnableMenuItem(5, MF_BYPOSITION | MF_DISABLED | MF_GRAYED);
   }

  POINT winCoord = { x , y };
  Handle(WNT_Window) aWNTWindow=
  Handle(WNT_Window)::DownCast(aView->Window());
  ClientToScreen ( (HWND)(aWNTWindow->HWindow()),&winCoord);
  pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON , winCoord.x, winCoord.y , 
                         AfxGetMainWnd());
}