// WalkthroughDoc.cpp : implementation of the CWalkthroughDoc class
//

#include "stdafx.h"

#include "WalkthroughDoc.h"

#include "WalkthroughApp.h"
#include "WalkthroughView.h"

#include <TopoDS_Shape.hxx>
#include <BRep_Builder.hxx>
#include <BRepTools.hxx>
//zyg #include <BRepAPI.hxx>
#include <BRepBuilderAPI_MakeFace.hxx>
#include <BRepBndLib.hxx>
#include <BndLib_AddSurface.hxx>
#include <AIS_Shape.hxx>
#include <GeomAdaptor_Surface.hxx>
#include <Geom_BSplineSurface.hxx>
#include <Quantity_NameOfColor.hxx>
#include <TopoDS_Solid.hxx>

#include "Fonc.hxx"

#define DEFAULT_COLOR Quantity_NOC_CYAN1
#define DEFAULT_MATERIAL Graphic3d_NOM_PLASTER
#define DEFAULT_DEVIATIONCOEFFICIENT 0.001
#define DEFAULT_HILIGHTCOLOR Quantity_NOC_YELLOW

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughDoc

IMPLEMENT_DYNCREATE(CWalkthroughDoc, CDocument)

BEGIN_MESSAGE_MAP(CWalkthroughDoc, OCC_3dBaseDoc)
	//{{AFX_MSG_MAP(CWalkthroughDoc)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(ID_FILE_LOADGRID, OnFileLoadgrid)
	ON_UPDATE_COMMAND_UI(ID_WALK_WALKTHRU, OnUpdateWalkWalkthru)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughDoc construction/destruction

CWalkthroughDoc::CWalkthroughDoc()
{
	// TODO: add one-time construction code here
	Handle(Graphic3d_WNTGraphicDevice) theGraphicDevice = 
		((CWalkthroughApp*)AfxGetApp())->GetGraphicDevice();

	myViewer = new V3d_Viewer(theGraphicDevice,(short *) "Visu3D");
	myViewer->DefaultPerspectiveView () ;
	myViewer->SetDefaultLights();
	myViewer->SetLightOn();
	myViewer->SetDefaultAngle ( Standard_PI / 2. ) ;

	myAISContext =new AIS_InteractiveContext(myViewer);

	myAISContext->SetDeviationCoefficient (DEFAULT_DEVIATIONCOEFFICIENT);
	myAISContext->SetHilightColor (DEFAULT_HILIGHTCOLOR);

	//CurrentIC = myAISContext ;

    m_Xmin = -300. ;
	m_Ymin = -300. ;
	m_Zmin = -300. ;
	m_Xmax = +300. ;
	m_Ymax = +300. ;
	m_Zmax = +300. ;

}

CWalkthroughDoc::~CWalkthroughDoc()
{
}

BOOL CWalkthroughDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
//	SetTitle("Viewer");

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CWalkthroughDoc serialization

void CWalkthroughDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughDoc diagnostics

#ifdef _DEBUG
void CWalkthroughDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CWalkthroughDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWalkthroughDoc commands


//-----------------------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------------------

void CWalkthroughDoc::OnFileOpen() 
{
	// TODO: Add your command handler code here

	CFileDialog dlg(TRUE,NULL,NULL,OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
				    "RLE Files (*.brep , *.rle)|*.brep;  *.rle; |All Files (*.*)|*.*||",
				     NULL );

	CString initdir(((OCC_BaseApp*) AfxGetApp())->GetInitDataDir());
	initdir += "\\Data";

	dlg.m_ofn.lpstrInitialDir = initdir;

	if (dlg.DoModal() == IDOK) {
       SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));

       CString aCFileName = dlg.GetPathName();
       const char* aFileName = aCFileName;

       TopoDS_Shape aShape;
       BRep_Builder aBuilder;

       Standard_Boolean result = BRepTools::Read(aShape,(char *)aFileName,aBuilder);

       if (!result) {
         MessageBox(0,"Error : The file doesn't exist","CasCade Error",MB_ICONERROR);
	   }
	   else {
//		   if (!BRepAPI::IsValid(aShape)) {
//             MessageBox(0,"Error : The shape is not valid","CasCade Error",MB_ICONWARNING);
//		   }

           Handle (AIS_Shape) anAISShape = new AIS_Shape(aShape);
           myAISContext->SetColor(anAISShape,Quantity_NOC_AZURE); 
           myAISContext->SetMaterial(anAISShape,Graphic3d_NOM_PEWTER);    
           myAISContext->SetDisplayMode(anAISShape,1);
		   myAISContext->Display (anAISShape, Standard_False);

           Bnd_Box B;
           BRepBndLib::Add(aShape, B);
           B.Get(m_Xmin, m_Ymin, m_Zmin, m_Xmax, m_Ymax, m_Zmax);

	   }
       SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));
	}
	CMDIFrameWnd *pFrame =  (CMDIFrameWnd*)AfxGetApp()->m_pMainWnd;
	CMDIChildWnd *pChild =  (CMDIChildWnd *) pFrame->GetActiveFrame();
	CWalkthroughView *pView = (CWalkthroughView *) pChild->GetActiveView();
	pView->SetDimensions();
}

void CWalkthroughDoc::OnFileLoadgrid() 
{
	// TODO: Add your command handler code here

  CFileDialog dlg(TRUE,
		  NULL,
		  NULL,
		  OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		  "Points Files (*.pnt;*.pnts)|*.pnt; *.pnts|All Files (*.*)|*.*||", 
		  NULL );

	CString initdir(((OCC_BaseApp*) AfxGetApp())->GetInitDataDir());
	initdir += "\\Data";

	dlg.m_ofn.lpstrInitialDir = initdir;


  if (dlg.DoModal() == IDOK)
    {
      CString C = dlg.GetPathName();
      SetCursor(AfxGetApp()->LoadStandardCursor(IDC_WAIT));

      Handle_Geom_BSplineSurface mySurface;

      if(grid2surf(C,mySurface ))
	{
	  //To set the minimum value of the surface to Z=0 
	  Standard_Real Tolerance = 0.0;
	  Bnd_Box B;
      TopoDS_Face myFace;
	  GeomAdaptor_Surface GAS(mySurface);

	  
	  BndLib_AddSurface::Add(GAS,Tolerance,B);

	  Standard_Real Xmin,Xmax,Ymin,Ymax,Zmin,Zmax;
	  B.Get(Xmin,Ymin,Zmin,Xmax,Ymax,Zmax);
	  TopoDS_Solid Box = BRepPrimAPI_MakeBox(gp_Pnt(Xmin,Ymin,0),Xmax-Xmin,Ymax-Ymin,50).Solid();

	  gp_Vec V(gp_Pnt(0,0,Zmin),gp_Pnt(0,0,0));
	  
	  gp_Trsf T;
	  T.SetTranslation(V);
	  mySurface->Transform(T);
	  BRepBuilderAPI_MakeFace aMkFace(mySurface);
	  myFace = aMkFace.Face();

	  Handle(AIS_Shape) myAISSurface = new AIS_Shape(myFace);

	  myAISContext->Display(myAISSurface, Standard_False);
	  myAISContext->Deactivate(myAISSurface,Standard_False);
	  myAISContext->SetColor (myAISSurface,Quantity_NOC_WHITE,Standard_False);
	  myAISContext->SetMaterial (myAISSurface,Graphic3d_NOM_STONE,Standard_False);
	  myAISContext->SetDisplayMode (myAISSurface,1,Standard_False);
	  myAISContext->SetDeviationCoefficient (0.001);
  	CMDIFrameWnd *pFrame =  (CMDIFrameWnd*)AfxGetApp()->m_pMainWnd;
	CMDIChildWnd *pChild =  (CMDIChildWnd *) pFrame->GetActiveFrame();
	CWalkthroughView *pView = (CWalkthroughView *) pChild->GetActiveView();
	pView->FitAll();

      Bnd_Box Boite;
      BRepBndLib::Add(myFace, Boite);
      Boite.Get(m_Xmin, m_Ymin, m_Zmin, m_Xmax, m_Ymax, m_Zmax);
	  
	}	
      SetCursor(AfxGetApp()->LoadStandardCursor(IDC_ARROW));
}


}

void CWalkthroughDoc::OnUpdateWalkWalkthru(CCmdUI* pCmdUI) 
{
	// TODO: Add your command update UI handler code here

	int i ;
	char szMsg [256] ;
	i = GetEnvironmentVariable( "CSF_WALKTHROUGH" , szMsg , sizeof szMsg ) ;
	if ( i )
		pCmdUI->SetCheck ( 1 ) ;
	else
		pCmdUI->SetCheck ( 0 ) ;

}


