/***************************************************************************
                          main.h  -  description
          $Id: main.h 41 2006-09-10 11:43:28Z neoneurone $
                             -------------------
    begin                : mer mai 28 2003
    copyright            : (C) 2003-2005 by Duong-Khang NGUYEN
    email                : neoneurone @ users sourceforge net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   any later version.                                                    *
 *                                                                         *
 ***************************************************************************/


#if !defined(_OPENCITY_MAIN_H_)
#define _OPENCITY_MAIN_H_ 1

#include "header.h"					// Checks for headers generated by configure

/* for reference, included by "SDL_opengl.h"
	#include <GL/gl.h>					// OpenGL
	#include <GL/glu.h>
   *---
	Under Windows, OpenGL 1.2 & 1.3 functionalities are not defined.
	They are treated as extensions, that's why we have the following lines
	Without this, glEnable( GL_RESCALE_NORMAL ) doesn't work under win32
   ----*
	#ifdef __WIN32__
		#include <GL/glext.h>
	#endif
*/

/* for reference, included by GCC's option "-ansi"
	#ifndef __STRICT_ANSI__
		#define __STRICT_ANSI__ 1		// Let's stay with the standard
										// This avoids "long long" from SDL.h
	#endif
*/
#include "SDL.h"				// Simple Directmedia Library
#include "SDL_thread.h"			// thread
#include "SDL_opengl.h"			// portable OpenGL headers

#include <string> 				// New standard not something.h ok ?
using std::string;

#include "macros.h"				// Our macros
#include "enum.h"				// Our enums

class UI;


// OpenCity's types --> for future releases and porting work
	#define OC_LINT long int
	#define OC_ULINT unsigned long int
	#define OC_SUINT short unsigned int
	#define OC_FLOAT float
	#define OC_CHAR char
	#define OC_BYTE char
	#define OC_UBYTE unsigned char

	#define OC_DATE int

// game default parameters
	#define OC_FUND_START 15000
	#define OC_R_INCOME_TAX 8
	#define OC_C_INCOME_TAX 8
	#define OC_I_INCOME_TAX 9
	#define OC_INCOME_HELP 10		// let's say this is government help ;)

	#define OC_MAP_HEIGHT_MAX 10
	#define OC_MAP_HEIGHT_MIN -10

	#define OC_CITY_W 100		// Watch out ! if you change this you must change
	#define OC_CITY_H 100		// the value of OC_SIMULATOR_LAG* too,
								// It's dangerous !
								// Don't touch it if you don't know what you do

	#define OC_CHANCE_COUNTER_MAX 300	// help the random method to find a structure
										// should be equal to 3% of city surface

// Sound & Music list file's name
	#define OC_MUSIC_LIST_FILENAME "music/music.m3u"
	#define OC_SOUND_LIST_FILENAME "sound/sound.m3u"

// OpenCity's config file
	#define OC_CONFIG_FILE_FILENAME "config/opencity.conf"
	#define OC_GRAPHISM_FILE_FILENAME "config/graphism.conf"

// Simulators' defines.
// Bad values can block your system, don't change them !
	#define OC_MS_PER_FRAME 10				// milliseconds delay per frame
	#define OC_MS_PER_DAY	1750			// Milliseconds delay per day
	#define OC_MS_GLOBAL_LOG_FACTOR		500
	#define OC_MS_STRUCTURE_LOG_FACTOR	400

// OpenGL default view parameters
	#define OC_EYE_X_START 200.0			// used for gluLookAt();
	#define OC_EYE_Y_START 100.0
	#define OC_EYE_Z_START 200.0

	#define OC_DELTA_X_START 0.0			// used for the translation
	#define OC_DELTA_Z_START 0.0
	#define OC_DELTA_X_STEP  2.0
	#define OC_DELTA_Z_STEP  2.0

	#define OC_Y_ROTATE_ANGLE 0.0			// used for the rotation
	#define OC_Y_ROTATE_STEP 10.0

	#define OC_CLEAR_COLOR		.0, .0, 0.25, 1.0
	#define OC_RED_COLOR		255, 0, 0
	#define OC_GREEN_COLOR		0, 255, 0
	#define OC_BLUE_COLOR		0, 0, 255
	#define OC_YELLOW_COLOR		255, 255, 0
	#define OC_PINK_COLOR		255,   0, 255
	#define OC_WHITE_COLOR		255, 255, 255
	#define OC_BLACK_COLOR		0, 0, 0

	#define OC_LIGHT_MODEL_AMBIENT	0.7, 0.7, 0.7, 1.0



   /*=====================================================================*/
   /*                       GLOBAL       FUNCTIONS                        */
   /*=====================================================================*/

//========================================================================
/** Prefix the specified path "s" with the data home directory
	\param s The path to be prefixed
	\return The modified path
*/
	string ocHomeDirPrefix( const string & s );


//========================================================================
/** Prefix the specified path "s" with the save directory
	\param s The path to be prefixed
	\return The modified path
*/
	string ocSaveDirPrefix( const string & s );


   /*=====================================================================*/
   /*                         MAIN      FUNCTIONS                         */
   /*=====================================================================*/
// Just a routine to print out the error message from the error code.
	void ocPerror( const OPENCITY_ERR_CODE & err_code );

//SDL event treatment call-back functions
	void ocKeyboard( const SDL_KeyboardEvent & );
	void ocMouseButton( const SDL_MouseButtonEvent & );
	void ocMouseMotion( const SDL_MouseMotionEvent & );
	void ocResize( const SDL_ResizeEvent & );
	void ocExpose( const SDL_ExposeEvent & );
	void ocQuit( const int & = 0 );
	void ocProcessSDLEvents( void );
	void ocSetNewUI( UI* );

#endif




























