//
/*
             Common Public License Version 0.5
 
             THE ACCOMPANYING PROGRAM IS PROVIDED UNDER THE TERMS OF
             THIS COMMON PUBLIC LICENSE ("AGREEMENT"). ANY USE,
             REPRODUCTION OR DISTRIBUTION OF THE PROGRAM CONSTITUTES
             RECIPIENT'S ACCEPTANCE OF THIS AGREEMENT.
 
             1. DEFINITIONS
 
             "Contribution" means:
                   a) in the case of the initial Contributor, the
                   initial code and documentation distributed under
                   this Agreement, and
 
                   b) in the case of each subsequent Contributor:
                   i) changes to the Program, and
                   ii) additions to the Program;
 
                   where such changes and/or additions to the Program
                   originate from and are distributed by that
                   particular Contributor. A Contribution 'originates'
                   from a Contributor if it was added to the Program
                   by such Contributor itself or anyone acting on such
                   Contributor's behalf. Contributions do not include
                   additions to the Program which: (i) are separate
                   modules of software distributed in conjunction with
                   the Program under their own license agreement, and
                   (ii) are not derivative works of the Program.
 
 
             "Contributor" means any person or entity that distributes
             the Program.
 
             "Licensed Patents " mean patent claims licensable by a
             Contributor which are necessarily infringed by the use or
             sale of its Contribution alone or when combined with the
             Program.
 
             "Program" means the Contributions distributed in
             accordance with this Agreement.
             "Recipient" means anyone who receives the Program under
             this Agreement, including all Contributors.
 
             2. GRANT OF RIGHTS
 
                   a) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free copyright
                   license to reproduce, prepare derivative works of,
                   publicly display, publicly perform, distribute and
                   sublicense the Contribution of such Contributor, if
                   any, and such derivative works, in source code and
                   object code form.
 
                   b) Subject to the terms of this Agreement, each
                   Contributor hereby grants Recipient a
                   non-exclusive, worldwide, royalty-free patent
                   license under Licensed Patents to make, use, sell,
                   offer to sell, import and otherwise transfer the
                   Contribution of such Contributor, if any, in source
                   code and object code form. This patent license
                   shall apply to the combination of the Contribution
                   and the Program if, at the time the Contribution is
                   added by the Contributor, such addition of the
                   Contribution causes such combination to be covered
                   by the Licensed Patents. The patent license shall
                   not apply to any other combinations which include
                   the Contribution. No hardware per se is licensed
                   hereunder.
 
                   c) Recipient understands that although each
                   Contributor grants the licenses to its
                   Contributions set forth herein, no assurances are
                   provided by any Contributor that the Program does
                   not infringe the patent or other intellectual
                   property rights of any other entity. Each
                   Contributor disclaims any liability to Recipient
                   for claims brought by any other entity based on
                   infringement of intellectual property rights or
                   otherwise. As a condition to exercising the rights
                   and licenses granted hereunder, each Recipient
                   hereby assumes sole responsibility to secure any
                   other intellectual property rights needed, if any.

                   For example, if a third party patent license is
                   required to allow Recipient to distribute the
                   Program, it is Recipient's responsibility to
                   acquire that license before distributing the
                   Program.
 
                   d) Each Contributor represents that to its
                   knowledge it has sufficient copyright rights in its
                   Contribution, if any, to grant the copyright
                   license set forth in this Agreement.
 
             3. REQUIREMENTS
 
             A Contributor may choose to distribute the Program in
             object code form under its own license agreement, provided
             that:
                   a) it complies with the terms and conditions of
                   this Agreement; and
 
                   b) its license agreement:
                   i) effectively disclaims on behalf of all
                   Contributors all warranties and conditions, express
                   and implied, including warranties or conditions of
                   title and non-infringement, and implied warranties
                   or conditions of merchantability and fitness for a
                   particular purpose;
 
                   ii) effectively excludes on behalf of all
                   Contributors all liability for damages, including
                   direct, indirect, special, incidental and
                   consequential damages, such as lost profits;
 
                   iii) states that any provisions which differ from
                   this Agreement are offered by that Contributor
                   alone and not by any other party; and
 
                   iv) states that source code for the Program is
                   available from such Contributor, and informs
                   licensees how to obtain it in a reasonable manner
                   on or through a medium customarily used for
                   software exchange.

             When the Program is made available in source code form:
                   a) it must be made available under this Agreement;
                   and
                   b) a copy of this Agreement must be included with
                   each copy of the Program.
 
             Contributors may not remove or alter any copyright notices
             contained within the Program.
 
             Each Contributor must identify itself as the originator of
             its Contribution, if any, in a manner that reasonably
             allows subsequent Recipients to identify the originator of
             the Contribution.
 
 
             4. COMMERCIAL DISTRIBUTION
 
             Commercial distributors of software may accept certain
             responsibilities with respect to end users, business
             partners and the like. While this license is intended to
             facilitate the commercial use of the Program, the
             Contributor who includes the Program in a commercial
             product offering should do so in a manner which does not
             create potential liability for other Contributors.
             Therefore, if a Contributor includes the Program in a
             commercial product offering, such Contributor ("Commercial
             Contributor") hereby agrees to defend and indemnify every
             other Contributor ("Indemnified Contributor") against any
             losses, damages and costs (collectively "Losses") arising
             from claims, lawsuits and other legal actions brought by a
             third party against the Indemnified Contributor to the
             extent caused by the acts or omissions of such Commercial
             Contributor in connection with its distribution of the
             Program in a commercial product offering. The obligations
             in this section do not apply to any claims or Losses
             relating to any actual or alleged intellectual property
             infringement. In order to qualify, an Indemnified
             Contributor must: a) promptly notify the Commercial
             Contributor in writing of such claim, and b) allow the
             Commercial Contributor to control, and cooperate with the
             Commercial Contributor in, the defense and any related
             settlement negotiations. The Indemnified Contributor may
             participate in any such claim at its own expense.

             For example, a Contributor might include the Program in a
             commercial product offering, Product X. That Contributor
             is then a Commercial Contributor. If that Commercial
             Contributor then makes performance claims, or offers
             warranties related to Product X, those performance claims
             and warranties are such Commercial Contributor's
             responsibility alone. Under this section, the Commercial
             Contributor would have to defend claims against the other
             Contributors related to those performance claims and
             warranties, and if a court requires any other Contributor
             to pay any damages as a result, the Commercial Contributor
             must pay those damages.
 
 
             5. NO WARRANTY
 
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, THE
             PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT
             WARRANTIES OR CONDITIONS OF ANY KIND, EITHER EXPRESS OR
             IMPLIED INCLUDING, WITHOUT LIMITATION, ANY WARRANTIES OR
             CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
             FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is solely
             responsible for determining the appropriateness of using
             and distributing the Program and assumes all risks
             associated with its exercise of rights under this
             Agreement, including but not limited to the risks and
             costs of program errors, compliance with applicable laws,
             damage to or loss of data, programs or equipment, and
             unavailability or interruption of operations.
 
             6. DISCLAIMER OF LIABILITY
             EXCEPT AS EXPRESSLY SET FORTH IN THIS AGREEMENT, NEITHER
             RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY
             FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
             OR CONSEQUENTIAL DAMAGES (INCLUDING WITHOUT LIMITATION
             LOST PROFITS), HOWEVER CAUSED AND ON ANY THEORY OF
             LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
             (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
             OF THE USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE
             OF ANY RIGHTS GRANTED HEREUNDER, EVEN IF ADVISED OF THE
             POSSIBILITY OF SUCH DAMAGES.

             7. GENERAL
 
             If any provision of this Agreement is invalid or
             unenforceable under applicable law, it shall not affect
             the validity or enforceability of the remainder of the
             terms of this Agreement, and without further action by the
             parties hereto, such provision shall be reformed to the
             minimum extent necessary to make such provision valid and
             enforceable.
 
 
             If Recipient institutes patent litigation against a
             Contributor with respect to a patent applicable to
             software (including a cross-claim or counterclaim in a
             lawsuit), then any patent licenses granted by that
             Contributor to such Recipient under this Agreement shall
             terminate as of the date such litigation is filed. In
             addition, If Recipient institutes patent litigation
             against any entity (including a cross-claim or
             counterclaim in a lawsuit) alleging that the Program
             itself (excluding combinations of the Program with other
             software or hardware) infringes such Recipient's
             patent(s), then such Recipient's rights granted under
             Section 2(b) shall terminate as of the date such
             litigation is filed.
 
             All Recipient's rights under this Agreement shall
             terminate if it fails to comply with any of the material
             terms or conditions of this Agreement and does not cure
             such failure in a reasonable period of time after becoming
             aware of such noncompliance. If all Recipient's rights
             under this Agreement terminate, Recipient agrees to cease
             use and distribution of the Program as soon as reasonably
             practicable. However, Recipient's obligations under this
             Agreement and any licenses granted by Recipient relating
             to the Program shall continue and survive.
 
             Everyone is permitted to copy and distribute copies of
             this Agreement, but in order to avoid inconsistency the
             Agreement is copyrighted and may only be modified in the
             following manner. The Agreement Steward reserves the right
             to publish new versions (including revisions) of this
             Agreement from time to time. No one other than the
             Agreement Steward has the right to modify this Agreement.

             IBM is the initial Agreement Steward. IBM may assign the
             responsibility to serve as the Agreement Steward to a
             suitable separate entity. Each new version of the
             Agreement will be given a distinguishing version number.
             The Program (including Contributions) may always be
             distributed subject to the version of the Agreement under
             which it was received. In addition, after a new version of
             the Agreement is published, Contributor may elect to
             distribute the Program (including its Contributions) under
             the new version. Except as expressly stated in Sections
             2(a) and 2(b) above, Recipient receives no rights or
             licenses to the intellectual property of any Contributor
             under this Agreement, whether expressly, by implication,
             estoppel or otherwise. All rights in the Program not
             expressly granted under this Agreement are reserved.
 
             This Agreement is governed by the laws of the State of New
             York and the intellectual property laws of the United
             States of America. No party to this Agreement will bring a
             legal action under this Agreement more than one year after
             the cause of action arose. Each party waives its rights to
             a jury trial in any resulting litigation.
 
*/

/************************************************************************
*                                                                       *
*      Copyright:       Corrent Corporation (c) 2000-2003               *
*                                                                       *
*      Filename:        dh_func.c                                       *
*      Created By:      Kapil Sood                                      *
*      Created On:      April 28, 2003                                  *
*      Description:     This is the file for testing Diffie-Hellman     *
*                       key pair generation and shared key derivation   *
*                       operations.                                     *
*                                                                       *
************************************************************************/

// File: dh_func.c
//

#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include "pkcs11types.h"
#include "regress.h"

// These values were obtained from IPsec second oakley group. These values are in big-endian
// format.  These are required for generating DH keys and secrets.
 
CK_BYTE DH_PUBL_PRIME[128] =
{
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xC9, 0x0F, 0xDA, 0xA2, 0x21, 0x68, 0xC2,
   0x34, 0xC4, 0xC6, 0x62, 0x8B, 0x80, 0xDC, 0x1C, 0xD1, 0x29, 0x02, 0x4E, 0x08, 0x8A, 0x67,
   0xCC, 0x74, 0x02, 0x0B, 0xBE, 0xA6, 0x3B, 0x13, 0x9B, 0x22, 0x51, 0x4A, 0x08, 0x79, 0x8E,
   0x34, 0x04, 0xDD, 0xEF, 0x95, 0x19, 0xB3, 0xCD, 0x3A, 0x43, 0x1B, 0x30, 0x2B, 0x0A, 0x6D,
   0xF2, 0x5F, 0x14, 0x37, 0x4F, 0xE1, 0x35, 0x6D, 0x6D, 0x51, 0xC2, 0x45, 0xE4, 0x85, 0xB5,
   0x76, 0x62, 0x5E, 0x7E, 0xC6, 0xF4, 0x4C, 0x42, 0xE9, 0xA6, 0x37, 0xED, 0x6B, 0x0B, 0xFF,
   0x5C, 0xB6, 0xF4, 0x06, 0xB7, 0xED, 0xEE, 0x38, 0x6B, 0xFB, 0x5A, 0x89, 0x9F, 0xA5, 0xAE,
   0x9F, 0x24, 0x11, 0x7C, 0x4B, 0x1F, 0xE6, 0x49, 0x28, 0x66, 0x51, 0xEC, 0xE6, 0x53, 0x81,
   0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF
} ;
 
CK_BYTE DH_PUBL_BASE[128] =
{
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02
 
};

//
//
int do_GenerateDHKeyPair( void )
{
   CK_SLOT_ID          slot_id;
   CK_SESSION_HANDLE   session;
   CK_MECHANISM        mech;
   CK_OBJECT_HANDLE    publ_key, priv_key;
   CK_FLAGS            flags;
   CK_BYTE             user_pin[PKCS11_MAX_PIN_LEN];
   CK_ULONG            user_pin_len;
   CK_RV               rc;

   CK_OBJECT_CLASS     pub_key_class  = CKO_PUBLIC_KEY ;
   CK_KEY_TYPE         pub_key_type   = CKK_DH ;
   CK_OBJECT_CLASS     priv_key_class = CKO_PRIVATE_KEY ;
   CK_KEY_TYPE         priv_key_type   = CKK_DH ;
   CK_BYTE             pub_value[128] ;
   CK_BYTE             priv_value[128] ;
   CK_BBOOL            true = TRUE ;

   CK_ATTRIBUTE  publ_tmpl[] =
   {
      {CKA_CLASS,    &pub_key_class,   sizeof(pub_key_class)    },
      {CKA_KEY_TYPE, &pub_key_type,    sizeof(pub_key_type)     },
      {CKA_MODIFIABLE, &true,          sizeof(true)             },
      {CKA_PRIME,    DH_PUBL_PRIME,    sizeof(DSA_PUBL_PRIME)   },
      {CKA_BASE,     DH_PUBL_BASE,     sizeof(DSA_PUBL_BASE)    }
   };

   CK_ATTRIBUTE  priv_tmpl[] =
   {
      {CKA_CLASS,    &priv_key_class,   sizeof(priv_key_class)    },
      {CKA_KEY_TYPE, &priv_key_type,    sizeof(priv_key_type)     },
      {CKA_MODIFIABLE, &true,          sizeof(true)             }
   };

   slot_id = SLOT_ID;

   if (get_user_pin(user_pin))
	   return CKR_FUNCTION_FAILED;
   user_pin_len = (CK_ULONG)strlen((char *)user_pin);

   mech.mechanism      = CKM_DH_PKCS_KEY_PAIR_GEN;
   mech.ulParameterLen = 0;
   mech.pParameter     = NULL;

   flags = CKF_SERIAL_SESSION;
   rc = funcs->C_OpenSession( slot_id, flags, NULL, NULL, &session );
   if (rc != CKR_OK) {
      show_error("   C_OpenSession #3", rc );
      return FALSE;
   }

   rc = funcs->C_Login( session, CKU_USER, user_pin, user_pin_len );
   if (rc != CKR_OK) {
      show_error("   C_Login #1", rc );
      goto error;
   }

   printf("do_GenerateDHKeyPair...\n");

   rc = funcs->C_GenerateKeyPair( session,   &mech,
                                  publ_tmpl,  5,
                                  priv_tmpl,  3,
                                  &publ_key, &priv_key );
   if (rc != CKR_OK) {
      show_error("   C_GenerateKeyPair #1", rc );
      goto error;
   }

   rc = funcs->C_CloseSession( session );
   if (rc != CKR_OK) {
      show_error("   C_CloseSession #3", rc );
      return FALSE;
   }

   printf("Looks okay...\n");
   return TRUE;

error:
   rc = funcs->C_CloseSession (session);
   if (rc != CKR_OK)
      show_error ("   C_CloseSession", rc);

   return FALSE;
}


int do_DeriveDHKey( void )
{
   CK_SLOT_ID          slot_id;
   CK_SESSION_HANDLE   session;
   CK_MECHANISM        mech;
   CK_OBJECT_HANDLE    publ_key, priv_key, secret_key;
   CK_FLAGS            flags;
   CK_BYTE             user_pin[PKCS11_MAX_PIN_LEN];
   CK_ULONG            user_pin_len;
   CK_RV               rc;

   CK_OBJECT_CLASS     pub_key_class  = CKO_PUBLIC_KEY ;
   CK_KEY_TYPE         pub_key_type   = CKK_DH ;
   CK_OBJECT_CLASS     priv_key_class = CKO_PRIVATE_KEY ;
   CK_KEY_TYPE         priv_key_type   = CKK_DH ;
   CK_BYTE             pub_value[128] ;
   CK_BYTE             peer_pub_value[128];
   CK_ULONG            count ;
   CK_BYTE             priv_value[128] ;
   CK_BBOOL            true = TRUE ;
   CK_ULONG            cka_value_bits = 180 ;
   
   CK_OBJECT_CLASS     secret_key_class  = CKO_SECRET_KEY ;
   CK_KEY_TYPE         secret_key_type   = CKK_GENERIC_SECRET ;
   CK_BYTE             secret_key_value[128] ;
   CK_ULONG            secret_key_value_len = 128 ;

   CK_ATTRIBUTE  publ_tmpl[] =
   {
      {CKA_CLASS,    &pub_key_class,   sizeof(pub_key_class)    },
      {CKA_KEY_TYPE, &pub_key_type,    sizeof(pub_key_type)     },
      {CKA_MODIFIABLE, &true,          sizeof(true)             },
      {CKA_PRIME,    DH_PUBL_PRIME,    sizeof(DSA_PUBL_PRIME)   },
      {CKA_BASE,     DH_PUBL_BASE,     sizeof(DSA_PUBL_BASE)    }
   };

   CK_ATTRIBUTE  priv_tmpl[] =
   {
      {CKA_CLASS,    &priv_key_class,   sizeof(priv_key_class)    },
      {CKA_KEY_TYPE, &priv_key_type,    sizeof(priv_key_type)     },
      {CKA_MODIFIABLE, &true,          sizeof(true)             },
      {CKA_VALUE_BITS, &cka_value_bits, sizeof(cka_value_bits) }                                                   
   };

   CK_ATTRIBUTE  secret_tmpl[] =
   {
      {CKA_CLASS,    &secret_key_class,   sizeof(secret_key_class) },
      {CKA_KEY_TYPE, &secret_key_type,    sizeof(secret_key_type)  },
      {CKA_VALUE_LEN, &secret_key_value_len, sizeof(secret_key_value_len) }
   };

   printf("do_DeriveDHKey...\n");

   slot_id = SLOT_ID;

   if (get_user_pin(user_pin))
	   return CKR_FUNCTION_FAILED;
   user_pin_len = (CK_ULONG)strlen((char *)user_pin);


   flags = CKF_SERIAL_SESSION | CKF_RW_SESSION;
   rc = funcs->C_OpenSession( slot_id, flags, NULL, NULL, &session );
   if (rc != CKR_OK) {
      show_error("   C_OpenSession #3", rc );
      return FALSE;
   }

   rc = funcs->C_Login( session, CKU_USER, user_pin, user_pin_len );
   if (rc != CKR_OK) {
      show_error("   C_Login #1", rc );
      goto error;
   }

   // First, generate the DH key Pair

   mech.mechanism      = CKM_DH_PKCS_KEY_PAIR_GEN;
   mech.ulParameterLen = 0;
   mech.pParameter     = NULL;

   rc = funcs->C_GenerateKeyPair( session,   &mech,
                                  publ_tmpl,  5,
                                  priv_tmpl,  4,
                                  &publ_key, &priv_key );
   if (rc != CKR_OK) {
      show_error("   C_GenerateKeyPair #1", rc );
      goto error;
   }

   // Now, Use the key pair derived above to derive the DH key

   // Fill in dummy value for peer's public key
   for (count=0; count<128; count++)
       peer_pub_value[count] = 0x22 ;

   mech.mechanism      = CKM_DH_PKCS_DERIVE;
   mech.pParameter     = peer_pub_value ;
   mech.ulParameterLen = sizeof(peer_pub_value);

   rc = funcs->C_DeriveKey( session, &mech,
                            priv_key, secret_tmpl,
                            3, &secret_key ) ;
   if (rc != CKR_OK) {
printf("DeriveKey Failed\n") ;
      show_error("   C_DeriveKey #1", rc );
      goto error;
   }


   rc = funcs->C_CloseSession( session );
   if (rc != CKR_OK) {
      show_error("   C_CloseSession #3", rc );
      return FALSE;
   }

   printf("Looks okay...\n");
   return TRUE;

error:
   rc = funcs->C_CloseSession (session);
   if (rc != CKR_OK)
      show_error ("   C_CloseSession", rc);

   return FALSE;
} /* end do_DeriveDHKey() */


int dh_functions()
{
   SYSTEMTIME t1, t2;
   int        rc;

   GetSystemTime(&t1);
   rc = do_GenerateDHKeyPair();
   if (!rc)
      fprintf (stderr, "ERRRO do_GenerateDHKeyPair failed, rc = 0x%0x\n", rc);
   GetSystemTime(&t2);
   process_time( t1, t2 );

   GetSystemTime(&t1);
   rc = do_DeriveDHKey();
   if (!rc)
      fprintf (stderr, "ERRRO do_DeriveDHKey failed, rc = 0x%0x\n", rc);
   GetSystemTime(&t2);
   process_time( t1, t2 );

   return TRUE;
}
