<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
include_once("./functions/Snoopy.class.php");
include_once("./functions/filecache.php");
include_once("./functions/logging.php");
include_once("./functions/utils.php");
include_once("./functions/fileutils.php");

/**
* This class does assume that the $CONFIG_VARS and $HTTP_VARS arrays
* have been defined before this class is instantiated.
*/
class OpenDbSnoopy extends Snoopy
{
	var $_debug;
	var $_file_cache_r;
	var $_file_cache_enabled;
	
	function OpenDbSnoopy()
	{
		global $CONFIG_VARS;

		// if file cache table is not installed, we cannot use file cache.
		if($CONFIG_VARS['http_cache.enable']!==FALSE)
			$this->_file_cache_enabled = file_cache_check_is_installed();
		else
			$this->_file_cache_enabled = FALSE;
		
		//override user agent.
		$this->agent = 'Mozilla/4.77 [en] (Windows NT 5.0; U)';
		
		if($CONFIG_VARS['http.debug'] !== FALSE)
		{
			$this->_debug = TRUE;
		}
		
		// if no proxy
		if ($CONFIG_VARS['proxy_server.enable']==TRUE)
		{
			$this->proxy_host = $CONFIG_VARS['proxy_server.host'];
			$this->proxy_port = $CONFIG_VARS['proxy_server.port'];
			$this->user = $CONFIG_VARS['proxy_server.userid'];
			$this->pass = $CONFIG_VARS['proxy_server.password'];
		}
	}
	
	/*
	* @param $url
	* @param $http_cache	If FALSE, will not cache the resource.  Useful for
	* 					images, where we have no interest in caching them,
	* 					as we rely on browser to do this.
	*/
	function fetchURI($URI, $http_cache=TRUE)
	{
		// from config.php
		global $CONFIG_VARS;
		
		@set_time_limit(600);
		
		// trim it first in case any extraneous spaces
		$URI = trim($URI);
		
		if($this->_debug)
		{
			echo("\n<br>OpenDbSnoopy::fetchURI() - URL: $URI\n");
		}
		
		$this->_file_cache_r = NULL;
		
		if($http_cache!==FALSE && $CONFIG_VARS['http_cache.enable']!==FALSE)
		{
			if($this->_file_cache_enabled!==FALSE)
			{
				// see if we can find the cache file.
				$sequence_number = file_cache_is_exists_url($URI, 'HTTP');
				if($sequence_number!==FALSE)
				{
					$this->_file_cache_r = fetch_file_cache_r($sequence_number);
					if($this->_file_cache_r!==FALSE)
					{
						$this->_file_cache_r['content'] = file_cache_fetch_content($sequence_number);
					}
				}
			}
			else
			{
				// log misconfiguration here.
				opendb_log("OpenDbSnoopy::fetchURI() - \$CONFIG_VARS['http_cache.enable'] is enabled, but the file_cache table is not installed.");
			}
		}
			
		if(is_not_empty_array($this->_file_cache_r))
		{
			if($this->_debug)
			{
				echo("\n<br>OpenDbSnoopy::fetchURI() - URL cached\n");
			}
			return $this->_file_cache_r['content'];
		}
		else
		{
			if($this->_debug)
			{
				echo("\n<br>OpenDbSnoopy::fetchURI() - URL NOT cached\n");
			}
		
			if($this->fetch($URI) && $this->status >= 200 && $this->status < 300)
			{
				$this->_file_cache_r['url'] = $URI;
				$this->_file_cache_r['content'] = $this->results;
		
				// don't write an empty result page.
				if(strlen($this->_file_cache_r['content'])>0)
				{
					if($this->_debug)
					{
						echo("\n<br>OpenDbSnoopy::fetchURI() - URL fetched (Size=".strlen($this->_file_cache_r['content']).")\n");
					}
			
					// assume a default.
					$this->_file_cache_r['content_type'] = 'text/html';

					// save all headers.
					if(is_array($this->headers) && count($this->headers)>0)
					{
						for($i=0; $i<count($this->headers); $i++)
						{
							if(preg_match("/^([^:]*):([^$]*)$/i", $this->headers[$i], $matches))
							{
								// only save content-type
								if(strcasecmp(trim($matches[1]), 'content-type')===0)
								{
									$this->_file_cache_r['content_type'] = trim($matches[2]);
									break;
								}
							}
						}
					}
						
					$this->_file_cache_r['location'] = $this->lastredirectaddr;
					
					// if caching, save it.
					if($http_cache!==FALSE && $CONFIG_VARS['http_cache.enable']!==FALSE)
					{	
						if($this->_file_cache_enabled!==FALSE)
						{
							if(file_cache_insert_file($this->_file_cache_r['url'], $this->_file_cache_r['location'], $this->_file_cache_r['content_type'], $this->_file_cache_r['content'], 'HTTP')!==FALSE)
							{
								if($this->_debug)
								{
									echo("\n<br>OpenDbSnoopy::fetchURI() - Added $URI to file cache");
								}
								opendb_log("OpenDbSnoopy::fetchURI() - Added $URI to file cache");
							}
							else
							{
								if($this->_debug)
								{
									echo("\n<br>OpenDbSnoopy::fetchURI() - Failed to add $URI to file cache");
								}
								opendb_log("OpenDbSnoopy::fetchURI() - Failed to add $URI to file cache");
							}
						}//if($this->_file_cache_enabled!==FALSE)
					}
				}//if(strlen($_file_cache_r['content'])>0)
				
				// return content.
				return $this->_file_cache_r['content'];
			}
			else
			{
				opendb_log("OpenDbSnoopy::fetchURI() - failed to fetch $URI (".$this->error.")");
				return FALSE;
			}
		}
	}
	
	/**
	*/
	function getLocation()
	{
		if(is_not_empty_array($this->_file_cache_r))
		{
			return ifempty(
				$this->_file_cache_r['location'],
				$this->_file_cache_r['url']);
		}
		else
		{
			// no location because no URL has been fetched.
			return NULL;
		}
	}
}
?>