<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/database.php");
include_once("./functions/logging.php");
include_once("./functions/user.php");

function is_exists_address_type($s_address_type)
{
	if(strlen($s_address_type)>0)
	{
		$query = "SELECT 'x' FROM s_address_type WHERE s_address_type = '".$s_address_type."'";
		$result = run_opendb_query($query);
		if($result && mysql_num_rows($result)>0)
		{
			mysql_free_result($result);
			return TRUE;
		}
	}
	//else
	return FALSE;
}


function fetch_address_type_r($address_type)
{
	$query = 'SELECT s_address_type,'.
			'description '.
			'FROM s_address_type '.
			'WHERE s_address_type = \''.$address_type.'\' '.
			'LIMIT 0,1';
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

function fetch_addr_attribute_type_rltshp_r($address_type, $attribute_type, $order_no = NULL)
{
	$query = 'SELECT s_address_type,'.
			's_attribute_type,'.
			'order_no,'.
			'prompt '.
			'FROM s_addr_attribute_type_rltshp '.
			'WHERE s_address_type = \''.$address_type.'\' AND '.
			's_attribute_type = \''.$attribute_type.'\'';
	
	// if an order_no provided, there is no need to sort to get the first order_no	
	if(is_numeric($order_no))
	{
		$query .= ' AND order_no = \''.$order_no.'\' ';
	}
	else
	{
		$query .= 'ORDER BY order_no ';
	}
	
	$query .= 'LIMIT 0,1';
	
	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

function fetch_user_address_type_r($user_id, $address_type)
{
	global $HTTP_SESSION_VARS;

	$query = "SELECT ua.sequence_number, ".
				"sadt.s_address_type, ".
				"sadt.description ".
			"FROM s_address_type sadt ".
				",user_address ua ".
			"WHERE ua.user_id = '".$user_id."' AND ".
			"ua.s_address_type = '".$address_type."' AND ".
				"ua.start_dt <= now() AND (ua.end_dt IS NULL OR ua.end_dt < now()) AND ".
				"sadt.s_address_type = ua.s_address_type ";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found;
	}
	else
		return FALSE;
}

/**
*/
function fetch_user_address_type_rs($user_id, $min_user_type = NULL, $order_by = FALSE)
{
	global $HTTP_SESSION_VARS;

	$query = "SELECT ua.sequence_number, ".
				"sadt.s_address_type, ".
				"sadt.description ".
			"FROM s_address_type sadt ";
			
	if(strlen($min_user_type)>0)
	{
		$query .= "LEFT JOIN user_address ua ".
			"ON ua.user_id = '".$user_id."' AND ".
			"ua.s_address_type = sadt.s_address_type AND ".
			"ua.start_dt <= now() AND (ua.end_dt IS NULL OR ua.end_dt < now()) ";
			
		$user_type_r = get_min_user_type_r($min_user_type);
		if(is_not_empty_array($user_type_r))
		{
			$query .= "WHERE sadt.min_create_user_type IN (".format_sql_in_clause($user_type_r).") ";
		}
	}
	else
	{
		$query .= ", user_address ua ".
			"WHERE ua.user_id = '".$user_id."' AND ".
			"ua.s_address_type = sadt.s_address_type AND ".
			"ua.start_dt <= now() AND (ua.end_dt IS NULL OR ua.end_dt < now()) ";
	}
	
	if($order_by)
	{
		$query .= "ORDER BY sadt.display_order, ua.start_dt ASC";
	}

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
    	return $result;
	else
		return FALSE;
}

/**
	Will return the attribute_val for the record, or FALSE if no found.
	
	Note: $s_attribute_type should be UPPERCASE
*/
function fetch_user_address_attribute_val($ua_sequence_number, $s_attribute_type, $order_no = NULL)
{
	// Only load previous record if edit.
	$query = "SELECT uaa.attribute_val ".
		"FROM user_address ua,".
			"user_address_attribute uaa ".
		"WHERE ua.sequence_number = '".$ua_sequence_number."' AND ".
			"ua.start_dt <= now() AND (ua.end_dt IS NULL OR ua.end_dt < now()) AND ".
			"uaa.ua_sequence_number = ua.sequence_number AND ".
           	"uaa.s_attribute_type = '".$s_attribute_type."' ";

	// Only add order_no where condition if order_no defined, otherwise we
	// will return the first instance of s_attribute_type.
	if(is_numeric($order_no))
		$query .= "AND uaa.order_no = '".$order_no."' ";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		$found = mysql_fetch_array($result, MYSQL_ASSOC);
		mysql_free_result($result);
		return $found['attribute_val'];
	}
	else
		return FALSE;
}

function fetch_user_address_lookup_attribute_val($ua_sequence_number, $s_attribute_type, $order_no = NULL)
{
	// Only load previous record if edit.
	$query = "SELECT uaa.lookup_attribute_val ".
		"FROM user_address ua,".
			"user_address_attribute uaa ".
		"WHERE ua.sequence_number = '".$ua_sequence_number."' AND ".
			"ua.start_dt <= now() AND (ua.end_dt IS NULL OR ua.end_dt < now()) AND ".
			"uaa.ua_sequence_number = ua.sequence_number AND ".
           	"uaa.s_attribute_type = '".$s_attribute_type."' ";

	// Only add order_no where condition if order_no defined, otherwise we
	// will return the first instance of s_attribute_type.
	if(is_numeric($order_no))
		$query .= "AND uaa.order_no = '".$order_no."' ";

	$results = run_opendb_query($query);
	if($results && mysql_num_rows($results)>0)
	{
		$lookup_val_r = NULL;
		while($lookup_r = mysql_fetch_array($results, MYSQL_ASSOC))
		{
			$lookup_val_r[] = $lookup_r['lookup_attribute_val'];
		}
		
		mysql_free_result($results);
		return $lookup_val_r;
	}
	else
	{
		return FALSE;
	}
}

/**
* Return a set of address types for a new user
*/
function fetch_address_type_rs($min_user_type = NULL, $order_by = FALSE)
{
	global $HTTP_SESSION_VARS;

	$query = "SELECT sadt.s_address_type, ".
				"sadt.description ".
			"FROM s_address_type sadt ";
	
	if(strlen($min_user_type)>0)
	{
		$user_type_r = get_min_user_type_r($min_user_type);
		if(is_not_empty_array($user_type_r))
		{
			$query .= "WHERE sadt.min_create_user_type IN (".format_sql_in_clause($user_type_r).") ";
		}
	}
	
	if($order_by)
	{
		$query .= "ORDER BY sadt.display_order";
	}

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
    	return $result;
	else
		return FALSE;
}

/**
* @param $mode - One of 'query' or 'edit'.  
* 					In 'edit' mode, the $user_type parameter will control what records
* 					are displayed based on the min_create_user_type column).  It will also
* 					return the 'compulsory_ind' based on the compulsory_for_user_type
* 					column.
* 
* 					In 'query' mode, will restrict what records 
* 				
*/
function fetch_address_type_attribute_type_rs($s_address_type, $min_user_type = NULL, $mode = 'query', $order_by = FALSE)
{
	$query = 
		"SELECT sadt.s_address_type, ".
				"saatr.s_attribute_type, ".
				"saatr.order_no, ".
				"if(length(saatr.prompt)>0,saatr.prompt,sat.prompt) as prompt, ".
				"sat.input_type, ".
				"sat.display_type ";
	
	if(strlen($min_user_type)>0)
	{
		$user_type_r = get_min_user_type_r($min_user_type);
	}
	
	if($mode == 'update')
	{
		if(is_not_empty_array($user_type_r))
		{
			$query .= ", IF(IFNULL(saatr.compulsory_for_user_type, sadt.compulsory_for_user_type) IN(".format_sql_in_clause($user_type_r)."), 'Y', 'N') as compulsory_ind ";
		}
		else
		{
			$query .= ", 'N' as compulsory_ind ";
		}
	}
	
	$query .= "FROM	s_addr_attribute_type_rltshp saatr, ".
				"s_attribute_type sat, ".
				"s_address_type sadt ".
			"WHERE sadt.s_address_type = '".$s_address_type."' AND ".
				"saatr.s_address_type = sadt.s_address_type AND ".
				"sat.s_attribute_type = saatr.s_attribute_type ";
	
	if($mode == 'update')
	{
		if(is_not_empty_array($user_type_r))
		{
			$query .= "AND IFNULL(saatr.min_create_user_type, sadt.min_create_user_type) IN (".format_sql_in_clause($user_type_r).") ";
		}
		
		// do not close for display purposes, only update
		$query .= "AND sadt.closed_ind <> 'Y' AND saatr.closed_ind <> 'Y'";
	}
	else //if($mode == 'query')
	{
		if(is_not_empty_array($user_type_r))
		{
			$query .= "AND IFNULL(saatr.min_display_user_type, sadt.min_display_user_type) IN (".format_sql_in_clause($user_type_r).") ";
		}
	}
	
	if($order_by)
	{
		$query .= "order by saatr.s_address_type ASC, saatr.order_no ASC";
	}

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
    	return $result;
	}
	else
	{
		return FALSE;
	}
}

function is_exists_valid_user_address($user_id, $s_address_type)
{
	$query = "SELECT 'x' FROM user_address WHERE user_id = '$user_id' AND ".
			"s_address_type = '$s_address_type' AND ".
			"start_dt <= now() AND (end_dt IS NULL OR end_dt < now()) ";

	$result = run_opendb_query($query);
	if($result && mysql_num_rows($result)>0)
	{
		mysql_free_result($result);
		// The very fact that at least one row was returned indicates that user_address exists
		return TRUE;
	}

	//else
	return FALSE;
}

/**
* Delete all user_address_attributes, followed by the address.  If no 
* sequence number specified, all addresses for the user will be deleted.
*/
function delete_user_addresses($user_id, $sequence_number = NULL)
{
	global $HTTP_SESSION_VARS;
	
	if(run_opendb_query("LOCK TABLES user_address WRITE, user_address_attribute WRITE"))
	{
		$query = "SELECT sequence_number FROM user_address WHERE user_id='".$user_id."'";
		if(is_numeric($sequence_number))
		{
			$query .= " AND sequence_number = '".$sequence_number."'";
		}
		
		$failures = 0;
		$results = run_opendb_query($query);
		if($results)
		{
			while($user_address_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				if(delete_user_address_attributes($user_address_r['sequence_number']))
				{
					if(!delete_user_address($user_address_r['sequence_number']))
					{
						$failures++;
					}
				}
				else
				{
					$failures++;
				}
			}
			mysql_free_result($results);
		}
		
		run_opendb_query("UNLOCK TABLES");
		if($failures == 0)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		opendb_log("Could not lock user_address, user_address_attribute tables for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

//
// If successful will return the new ID for the item, otherwise will return FALSE.
//
function insert_user_address($user_id, $s_address_type, $start_dt = NULL, $end_dt = NULL)
{
	global $HTTP_SESSION_VARS;
	
	if(strlen($user_id)>0)
	{
		$query = "INSERT INTO user_address (user_id, s_address_type, start_dt, end_dt)".				   
				" VALUES ('".$user_id."','".$s_address_type."',".(strlen($start_dt)>0?$start_dt:"now()").", ".(strlen($end_dt)>0?"'".$end_dt."'":"NULL").")";

		$insert = run_opendb_query($query);
		if ($insert && mysql_affected_rows() > 0)
		{
			$new_sequence_number = mysql_insert_id();
			opendb_log("Inserted user address (sequence_number=$new_sequence_number, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return $new_sequence_number;
		}
		else
		{
			opendb_log("Failed to insert user address (update_who=".$HTTP_SESSION_VARS['user_id'].") [error=".mysql_error()."]");
			return FALSE;
		}
	}
	else
	{
		opendb_log("Failed to insert user address (update_who=".$HTTP_SESSION_VARS['user_id'].") [Userid not specified]");
		return FALSE;
	}		
}

/**
	Delete user_address and return boolean indicating success or failure.
	
	This function does not check for any dependencies.
*/	
function delete_user_address($sequence_number)
{
	global $HTTP_SESSION_VARS;
	
	$query ="DELETE FROM user_address WHERE sequence_number = '".$sequence_number."'";
	$delete = run_opendb_query($query);
	if($delete && mysql_affected_rows() > 0)
	{
		opendb_log("Deleted user address (sequence_number=$sequence_number, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete user address (sequence_number=$sequence_number, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

// Insert a user_address_attribute record.  Assumes that it does not already exist!
// 
// If successful will return TRUE, otherwise will return FALSE.
//
function insert_user_address_attribute($ua_sequence_number, $s_attribute_type, $order_no, $attribute_val)
{
	global $HTTP_SESSION_VARS;
	
	$attribute_val = replace_newlines(trim($attribute_val));
	if(strlen($attribute_val))
	{
		$attribute_val = addslashes($attribute_val);
		
		$query = "INSERT INTO user_address_attribute (ua_sequence_number, s_attribute_type, order_no, lookup_attribute_val, attribute_val)".
				"VALUES ('$ua_sequence_number','$s_attribute_type','$order_no','','$attribute_val')";
			
		$insert = run_opendb_query($query);
		if ($insert && mysql_affected_rows() > 0)
		{
			opendb_log("Inserted user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return TRUE;
		}
		else
		{
			opendb_log("Failed to insert user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			return FALSE;
		}
	}
	else
	{
		opendb_log("Failed to insert user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [Attribute value is empty]");
		return FALSE;
	}
}

function insert_lookup_user_address_attributes($ua_sequence_number, $s_attribute_type, $order_no, $lookup_attribute_val_r)
{
	global $HTTP_SESSION_VARS;
	
	if(run_opendb_query("LOCK TABLES user_address_attribute WRITE"))
	{
		for($i=0; $i<count($lookup_attribute_val_r); $i++)
		{
			$lookup_attribute_val = addslashes($lookup_attribute_val_r[$i]);
			if(strlen($lookup_attribute_val))
			{
				$query = "INSERT INTO user_address_attribute (ua_sequence_number, s_attribute_type, order_no, lookup_attribute_val, attribute_val)".
					"VALUES ('$ua_sequence_number','$s_attribute_type','$order_no','$lookup_attribute_val',NULL)";
				
				$insert = run_opendb_query($query);
				if ($insert && mysql_affected_rows() > 0)
				{
					opendb_log("Inserted lookup user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].")");
				}
				else
				{
					opendb_log("Failed to insert lookup user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
					
					run_opendb_query("UNLOCK TABLES");
					return FALSE;
				}
			}
			else
			{
				opendb_log("Failed to insert lookup user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [Lookup Attribute value is empty]");
			}
		}
		
		run_opendb_query("UNLOCK TABLES");
		return TRUE;
	}
	else
	{
		opendb_log("Could not lock user_address_attribute table for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

//
// If successful will return TRUE, otherwise will return FALSE.
//
function update_user_address_attribute($ua_sequence_number, $s_attribute_type, $order_no, $attribute_val)
{
	global $HTTP_SESSION_VARS;
	
	
	$attribute_val = replace_newlines(trim($attribute_val));
	if(strlen($attribute_val))
	{
		$attribute_val = addslashes($attribute_val);
	
		$query = "UPDATE user_address_attribute SET attribute_val = '$attribute_val' ".
				 "WHERE ua_sequence_number = '".$ua_sequence_number."' and s_attribute_type = '".$s_attribute_type."' and order_no = '".$order_no."'";
		$update = run_opendb_query($query);
		
		// We should not treat updates that were not actually updated because value did not change as failures.
		if ($update && ($rows_affected = mysql_affected_rows()) !== -1)
		{
			if($rows_affected>0)
				opendb_log("Updated user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return TRUE;
		}
		else
		{
			opendb_log("Failed to update user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id']."). [".mysql_error()."]");
			return FALSE;
		}
	}
	else
	{
		opendb_log("Failed to update user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [Attribute value is empty]");
		return FALSE;
	}
}

function update_lookup_user_address_attributes($ua_sequence_number, $s_attribute_type, $order_no, $lookup_attribute_val_r)
{
	global $HTTP_SESSION_VARS;
	
	if(run_opendb_query("LOCK TABLES user_address_attribute WRITE"))
	{
		// lets get a list of the current attributes for the item_id, s_attribute_type and order_no
		$query = "SELECT lookup_attribute_val FROM user_address_attribute WHERE ua_sequence_number='".$ua_sequence_number."' AND s_attribute_type = '".$s_attribute_type."' AND order_no = '".$order_no."'";
		$results = run_opendb_query($query);
		if($results)
		{
			while($user_addr_attribute_r = mysql_fetch_array($results, MYSQL_ASSOC))
			{
				$lookup_key = array_search2($user_addr_attribute_r['lookup_attribute_val'], $lookup_attribute_val_r, TRUE);
				if($lookup_key !== FALSE)
				{
					// Remove the matched element
					array_splice($lookup_attribute_val_r, $lookup_key, 1);
				}
				else
				{
					delete_lookup_user_address_attribute($ua_sequence_number, $s_attribute_type, $order_no, $user_addr_attribute_r['lookup_attribute_val']);
				}
			}
		}
		
		for($i=0; $i<count($lookup_attribute_val_r); $i++)
		{
			$lookup_attribute_val = addslashes($lookup_attribute_val_r[$i]);
			if(strlen($lookup_attribute_val))
			{
				$query = "INSERT INTO user_address_attribute (ua_sequence_number, s_attribute_type, order_no, lookup_attribute_val, attribute_val)".
					"VALUES ('$ua_sequence_number','$s_attribute_type','$order_no','$lookup_attribute_val',NULL)";
				
				$insert = run_opendb_query($query);
				if ($insert && mysql_affected_rows() > 0)
				{
					opendb_log("Inserted lookup user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].")");
				}
				else
				{
					opendb_log("Failed to insert lookup user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
					
					run_opendb_query("UNLOCK TABLES");
					return FALSE;
				}
			}
			else
			{
				opendb_log("Failed to insert lookup user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [Lookup Attribute value is empty]");
			}
		}
		
		run_opendb_query("UNLOCK TABLES");
		return TRUE;
	}//if(run_opendb_query("LOCK TABLES item_attribute WRITE"))
	else
	{
		opendb_log("Could not lock user_address_attribute table for write (update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

//
// If successful will return TRUE, otherwise will return FALSE.
//
function delete_user_address_attribute($ua_sequence_number, $s_attribute_type, $order_no)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM user_address_attribute ".
			 "WHERE ua_sequence_number = '".$ua_sequence_number."' AND s_attribute_type = '".$s_attribute_type."' and order_no = '".$order_no."'";
	$delete = run_opendb_query($query);
	if ($delete && mysql_affected_rows() > 0)
	{
		opendb_log("Deleted user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

function delete_lookup_user_address_attribute($ua_sequence_number, $s_attribute_type, $order_no, $lookup_attribute_val)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM user_address_attribute ".
			 "WHERE ua_sequence_number = '".$ua_sequence_number."' and s_attribute_type = '".$s_attribute_type."' and order_no = '".$order_no."' AND lookup_attribute_val = '".$lookup_attribute_val."'";
	$delete = run_opendb_query($query);
	// Even if no attributes were deleted, because there were none, this should still return true.
	if ( $delete )
	{
		opendb_log("Deleted lookup user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete lookup user address attribute (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, lookup_attribute_val=$lookup_attribute_val, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

function delete_lookup_user_address_attributes($ua_sequence_number, $s_attribute_type, $order_no)
{
	global $HTTP_SESSION_VARS;
	
	$query = "DELETE FROM user_address_attribute ".
			 "WHERE ua_sequence_number = '".$ua_sequence_number."' and s_attribute_type = '".$s_attribute_type."' and order_no = '".$order_no."'";
	$delete = run_opendb_query($query);
	// Even if no attributes were deleted, because there were none, this should still return true.
	if ( $delete )
	{
		opendb_log("Deleted lookup user address attribute(s) (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].")");
		return TRUE;
	}
	else
	{
		opendb_log("Failed to delete lookup user address attribute(s) (ua_sequence_number=$ua_sequence_number, s_attribute_type=$s_attribute_type, order_no=$order_no, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
		return FALSE;
	}
}

//
// If successful will return TRUE, otherwise will return FALSE.
//
function delete_user_address_attributes($ua_sequence_number)
{
	global $HTTP_SESSION_VARS;
	
	if(is_numeric($ua_sequence_number))
	{
		$query = "DELETE FROM user_address_attribute ".
			 "WHERE ua_sequence_number = '".$ua_sequence_number."'";
		$delete = run_opendb_query($query);
	
		// Even if no attributes were deleted, because there were none, this should still return true.
		if( $delete )
		{
			opendb_log("Deleted ".mysql_affected_rows()." user_address attribute(s) (ua_sequence_number=$ua_sequence_number, update_who=".$HTTP_SESSION_VARS['user_id'].")");
			return TRUE;
		}
		else
		{
			opendb_log("Failed to delete user_address attributes (ua_sequence_number=$ua_sequence_number, update_who=".$HTTP_SESSION_VARS['user_id'].") [".mysql_error()."]");
			return FALSE;
		}
	}
	else
	{
		// invalid $ua_sequence_number supplied.
		return FALSE;
	}
}
?>