<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// *** Note assumes that config.php variables have been defined ***
// *** This must be assumed so that the configuration variables ***
// *** can actually be defined somewhere in begin.inc.php, but  ***
// *** we do not have to care about where...

include_once("./functions/theme.php");
include_once("./include/menu.php");

// Allow overriding theme definition here.
if($HTTP_VARS['mode'] == 'job')
{
	// no theme
	$_OPENDB_THEME = "";
}
else if($HTTP_VARS['mode'] == 'printable' && is_legal_theme('printable'))
{
	// The Printable theme can now look for images in the $_OPENDB_DEFAULT_THEME directory first.
	$_OPENDB_DEFAULT_THEME = $CONFIG_VARS['site.theme'];
	$_OPENDB_THEME = 'printable';
}
else if(is_legal_theme($HTTP_SESSION_VARS['user_theme']))
{
	$_OPENDB_THEME = $HTTP_SESSION_VARS['user_theme'];
}
else if(is_legal_theme($CONFIG_VARS['site.theme']))
{
	$_OPENDB_THEME = $CONFIG_VARS['site.theme'];
}
else // This is the final default.
{
	$_OPENDB_THEME = "default";
}

if(strlen($_OPENDB_THEME)>0)
{
	// All the particular functions are in this file.
	include("./theme/$_OPENDB_THEME/index.php");
}
?>
