<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
$table_r = array("user", 
				"user_address", 
				"user_address_attribute", 
				"review", 
				"item",
				"item_instance", 
				"item_attribute", 
				"borrowed_item", 
				"s_status_type", 
				"s_item_type", 
				"s_address_type", 
				"s_addr_attribute_type_rltshp", 
				"s_attribute_type", 
				"s_attribute_type_lookup",
				"s_item_attribute_type",
				"import_cache",
				"file_cache",
				"s_item_type_group",
				"s_item_type_group_rltshp",
				"s_site_plugin",
				"s_site_plugin_conf",
				"s_site_plugin_link",
				"s_site_plugin_input_field",
				"s_site_plugin_s_attribute_type_map",
				"s_site_plugin_s_attribute_type_lookup_map"
				);

/**
	Check that all tables exist WITH prefix!

	If no prefix defined in config file, this function will return false
	as well!
*/
function check_if_installed()
{
	global $table_r;
	global $CONFIG_VARS;

	reset($table_r);
	while(list($key, $table) = each($table_r))
	{
		if(!check_table($table,TRUE)) // Check for prefixed tables.
			return FALSE;// Not all tables converted.
	}

	// else
	return TRUE;
}

if($CONFIG_VARS['patch.enable']===TRUE)
{
	if($HTTP_VARS['op'] == "menu")
	{
		echo("<DIV ALIGN=\"CENTER\">");
		if(empty($CONFIG_VARS['db_server.table_prefix']))
		{
			echo("<p>You have to configure the \$CONFIG_VARS['db_server.table_prefix'] variable to use this patch.</p>");
		}
		echo("<FORM action=\"$PHP_SELF\" method=\"get\" target=\"main\">");
		print_button("apply", "Apply Prefixes", empty($CONFIG_VARS['db_server.table_prefix']) || check_if_installed());
		echo("&nbsp;");
		print_button("remove", "Remove Prefixes", empty($CONFIG_VARS['db_server.table_prefix']) || !check_if_installed());
		echo("<br>");
		echo("<INPUT TYPE=\"hidden\" name=\"op\" value=\"result\">");
		echo("<INPUT TYPE=\"hidden\" name=\"from\" value=\"".$HTTP_VARS['from']."\">");
		echo("</FORM>");
		echo("</DIV>");
	}
	else
	{
		if(isset($HTTP_VARS['apply']) && !empty($CONFIG_VARS['db_server.table_prefix']))
		{
			while(list($key, $table) = each($table_r))
			{
				if(!check_table($CONFIG_VARS['db_server.table_prefix'].$table,FALSE))
				{
					$sql_command = "ALTER TABLE $table RENAME AS ".$CONFIG_VARS['db_server.table_prefix'].$table;

					echo( "<DIV CLASS=\"code\"><PRE>$sql_command;</PRE></DIV>\n" );
					if(run_opendb_query($sql_command,FALSE))
						echo( "<div class=\"upgrade_success\">SQL query evaluated successfully.</div>\n" );
					else
						echo( "<div class=\"upgrade_failure\">SQL query evaluation failed. (".mysql_error().")</div>\n" );
				}
				else
					echo( "<div class=\"upgrade_warning\">Table ".$CONFIG_VARS['db_server.table_prefix']."$table exists.</div>\n" );
			}
		}
		else if(isset($HTTP_VARS['remove']) && !empty($CONFIG_VARS['db_server.table_prefix']))
		{
			while(list($key, $table) = each($table_r))
			{
				if(check_table($CONFIG_VARS['db_server.table_prefix'].$table,FALSE))
				{
					$sql_command = "ALTER TABLE ".$CONFIG_VARS['db_server.table_prefix']."$table RENAME AS $table";

					echo( "<DIV CLASS=\"code\"><PRE>$sql_command;</PRE></DIV>\n" );
					if(run_opendb_query("ALTER TABLE ".$CONFIG_VARS['db_server.table_prefix']."$table RENAME AS $table",FALSE))
						echo( "<div class=\"upgrade_success\">SQL query evaluated successfully.</div>\n" );
					else
						echo( "<div class=\"upgrade_failure\">SQL query evaluation failed. (".mysql_error().")</div>\n" );
				}
				else
					echo( "<div class=\"upgrade_warning\">Table $table already reset.</div>\n" );
			}
		}
	}
}
?>
